/*****************************************************************************
*                                                                            *
*  OpenNI 1.x Alpha                                                          *
*  Copyright (C) 2012 PrimeSense Ltd.                                        *
*                                                                            *
*  This file is part of OpenNI.                                              *
*                                                                            *
*  Licensed under the Apache License, Version 2.0 (the "License");           *
*  you may not use this file except in compliance with the License.          *
*  You may obtain a copy of the License at                                   *
*                                                                            *
*      http://www.apache.org/licenses/LICENSE-2.0                            *
*                                                                            *
*  Unless required by applicable law or agreed to in writing, software       *
*  distributed under the License is distributed on an "AS IS" BASIS,         *
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
*  See the License for the specific language governing permissions and       *
*  limitations under the License.                                            *
*                                                                            *
*****************************************************************************/
package org.openni;

/**
 * Provides a structure for storing the data in Hand Direction Events. <BR><BR>
 * 
 * This class allows for the easy storage of the various data values passed
 * along with a Hand Direction events when using the HandGenerator and the NiTE HandPoint APIs.<BR><BR>
 * 
 * Normally this class would only be created when a HandDirectionEvent is initiated by the system.
 * Users detecting this event would primarily use this API to read the values back out.  <BR><BR>
 * 
 * More information on the HandPoint APIs can be found in the NiTE Algorithms document,
 * included in PDF format in the documentation directory when installing PrimeSense NiTE
 *
 */
public class ActiveHandDirectionEventArgs extends EventArgs
{
	/** Constructor to create object with specified id, position, time and direction. This
	 * constructor would normally only be called by the system when creating an Active Hand
	 * Direction Event.
	 * @param id The id of the handpoint this event refers to
	 * @param position The current position of that handpoint in real world coordinates
	 * @param time The timestamp of the frame this handpoint was generated by
	 * @param direction Direction that the hand is traveling
	 */
	public ActiveHandDirectionEventArgs(int id, Point3D position, float time, Direction direction)
	{
		this.id = id;
		this.position = position;
		this.time = time;
		this.direction = direction;
	}
	
	/**
	 * Getter function for the id of the handpoint
	 * @return The ID of the handpoint that triggered this event
	 */
	public int getId()
	{
		return this.id;
	}
	/** 
	 * Getter function for the position of the handpoint in space
	 * @return Coordinates of the handpoint, in real world coordinates
	 */
	public Point3D getPosition()
	{
		return this.position;
	}
	/**
	 * Getter function for the timestamp of the frame that generated
	 * this event
	 * @return Timestamp of the frame that generated this event
	 */
	public float getTime()
	{
		return this.time;
	}
	/** Getter function for the direction of travel
	 * @return Cardinal direction of hand travel
	 */
	public Direction getDirection()
	{
		return this.direction;
	}
	
	
	private final int id;
	private final Point3D position;
	private final float time;
	private final Direction direction;

}
