//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2_core_foundation::*;

use crate::*;

/// Updates the DHCP client preferences to include the
/// given list of options for the given application ID.
///
/// Parameter `applicationID`: The application's preference ID, for example:
/// "com.apple.SystemPreferences".
///
/// Parameter `options`: An array of 8-bit values containing the
/// DHCP option codes (see RFC 2132) for this application ID.
/// A NULL value will clear the list of options for this
/// application ID.
///
/// Parameter `count`: The number of elements in the options parameter.
///
/// Returns: Returns TRUE if the operation succeeded, FALSE otherwise.
///
/// # Safety
///
/// `options` must be a valid pointer or null.
#[inline]
pub unsafe extern "C-unwind" fn DHCPClientPreferencesSetApplicationOptions(
    application_id: &CFString,
    options: *const u8,
    count: CFIndex,
) -> bool {
    extern "C-unwind" {
        fn DHCPClientPreferencesSetApplicationOptions(
            application_id: &CFString,
            options: *const u8,
            count: CFIndex,
        ) -> Boolean;
    }
    let ret = unsafe { DHCPClientPreferencesSetApplicationOptions(application_id, options, count) };
    ret != 0
}

extern "C-unwind" {
    /// Copies the requested DHCP options for the
    /// given application ID.
    ///
    /// Parameter `applicationID`: The application's preference ID, for example
    /// "com.apple.SystemPreferences".
    ///
    /// Parameter `count`: The number of elements in the returned array.
    ///
    /// Returns: Returns the list of options for the given application ID, or
    /// NULL if no options are defined or an error occurred.
    ///
    /// When you are finished, use free() to release a non-NULL return value.
    ///
    /// # Safety
    ///
    /// `count` must be a valid pointer.
    pub fn DHCPClientPreferencesCopyApplicationOptions(
        application_id: &CFString,
        count: NonNull<CFIndex>,
    ) -> *mut u8;
}
