# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: example.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from typing import TYPE_CHECKING


if TYPE_CHECKING:
    from dataclasses import dataclass
else:
    from pydantic.dataclasses import dataclass

from typing import List

import betterproto
from pydantic.dataclasses import rebuild_dataclass


class FieldDescriptorProtoType(betterproto.Enum):
    TYPE_DOUBLE = 1
    """
    0 is reserved for errors.
     Order is weird for historical reasons.
    """

    TYPE_FLOAT = 2
    TYPE_INT64 = 3
    """
    Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
     negative values are likely.
    """

    TYPE_UINT64 = 4
    TYPE_INT32 = 5
    """
    Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
     negative values are likely.
    """

    TYPE_FIXED64 = 6
    TYPE_FIXED32 = 7
    TYPE_BOOL = 8
    TYPE_STRING = 9
    TYPE_GROUP = 10
    """
    Tag-delimited aggregate.
     Group type is deprecated and not supported in proto3. However, Proto3
     implementations should still be able to parse the group wire format and
     treat group fields as unknown fields.
    """

    TYPE_MESSAGE = 11
    TYPE_BYTES = 12
    """New in version 2."""

    TYPE_UINT32 = 13
    TYPE_ENUM = 14
    TYPE_SFIXED32 = 15
    TYPE_SFIXED64 = 16
    TYPE_SINT32 = 17
    TYPE_SINT64 = 18

    @classmethod
    def __get_pydantic_core_schema__(cls, _source_type, _handler):
        from pydantic_core import core_schema

        return core_schema.int_schema(ge=0)


class FieldDescriptorProtoLabel(betterproto.Enum):
    LABEL_OPTIONAL = 1
    """0 is reserved for errors"""

    LABEL_REQUIRED = 2
    LABEL_REPEATED = 3

    @classmethod
    def __get_pydantic_core_schema__(cls, _source_type, _handler):
        from pydantic_core import core_schema

        return core_schema.int_schema(ge=0)


class FileOptionsOptimizeMode(betterproto.Enum):
    """Generated classes can be optimized for speed or code size."""

    SPEED = 1
    CODE_SIZE = 2
    """etc."""

    LITE_RUNTIME = 3

    @classmethod
    def __get_pydantic_core_schema__(cls, _source_type, _handler):
        from pydantic_core import core_schema

        return core_schema.int_schema(ge=0)


class FieldOptionsCType(betterproto.Enum):
    STRING = 0
    """Default mode."""

    CORD = 1
    STRING_PIECE = 2

    @classmethod
    def __get_pydantic_core_schema__(cls, _source_type, _handler):
        from pydantic_core import core_schema

        return core_schema.int_schema(ge=0)


class FieldOptionsJsType(betterproto.Enum):
    JS_NORMAL = 0
    """Use the default type."""

    JS_STRING = 1
    """Use JavaScript strings."""

    JS_NUMBER = 2
    """Use JavaScript numbers."""

    @classmethod
    def __get_pydantic_core_schema__(cls, _source_type, _handler):
        from pydantic_core import core_schema

        return core_schema.int_schema(ge=0)


class MethodOptionsIdempotencyLevel(betterproto.Enum):
    """
    Is this method side-effect-free (or safe in HTTP parlance), or idempotent,
     or neither? HTTP based RPC implementation may choose GET verb for safe
     methods, and PUT verb for idempotent methods instead of the default POST.
    """

    IDEMPOTENCY_UNKNOWN = 0
    NO_SIDE_EFFECTS = 1
    IDEMPOTENT = 2

    @classmethod
    def __get_pydantic_core_schema__(cls, _source_type, _handler):
        from pydantic_core import core_schema

        return core_schema.int_schema(ge=0)


@dataclass(eq=False, repr=False)
class FileDescriptorSet(betterproto.Message):
    """
    The protocol compiler can output a FileDescriptorSet containing the .proto
     files it parses.
    """

    file: List["FileDescriptorProto"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class FileDescriptorProto(betterproto.Message):
    """Describes a complete .proto file."""

    name: str = betterproto.string_field(1)
    package: str = betterproto.string_field(2)
    dependency: List[str] = betterproto.string_field(3)
    """Names of files imported by this file."""

    public_dependency: List[int] = betterproto.int32_field(10)
    """Indexes of the public imported files in the dependency list above."""

    weak_dependency: List[int] = betterproto.int32_field(11)
    """
    Indexes of the weak imported files in the dependency list.
     For Google-internal migration only. Do not use.
    """

    message_type: List["DescriptorProto"] = betterproto.message_field(4)
    """All top-level definitions in this file."""

    enum_type: List["EnumDescriptorProto"] = betterproto.message_field(5)
    service: List["ServiceDescriptorProto"] = betterproto.message_field(6)
    extension: List["FieldDescriptorProto"] = betterproto.message_field(7)
    options: "FileOptions" = betterproto.message_field(8)
    source_code_info: "SourceCodeInfo" = betterproto.message_field(9)
    """
    This field contains optional information about the original source code.
     You may safely remove this entire field without harming runtime
     functionality of the descriptors -- the information is needed only by
     development tools.
    """

    syntax: str = betterproto.string_field(12)
    """
    The syntax of the proto file.
     The supported values are "proto2" and "proto3".
    """


@dataclass(eq=False, repr=False)
class DescriptorProto(betterproto.Message):
    """Describes a message type."""

    name: str = betterproto.string_field(1)
    field: List["FieldDescriptorProto"] = betterproto.message_field(2)
    extension: List["FieldDescriptorProto"] = betterproto.message_field(6)
    nested_type: List["DescriptorProto"] = betterproto.message_field(3)
    enum_type: List["EnumDescriptorProto"] = betterproto.message_field(4)
    extension_range: List["DescriptorProtoExtensionRange"] = betterproto.message_field(
        5
    )
    oneof_decl: List["OneofDescriptorProto"] = betterproto.message_field(8)
    options: "MessageOptions" = betterproto.message_field(7)
    reserved_range: List["DescriptorProtoReservedRange"] = betterproto.message_field(9)
    reserved_name: List[str] = betterproto.string_field(10)
    """
    Reserved field names, which may not be used by fields in the same message.
     A given name may only be reserved once.
    """


@dataclass(eq=False, repr=False)
class DescriptorProtoExtensionRange(betterproto.Message):
    start: int = betterproto.int32_field(1)
    end: int = betterproto.int32_field(2)
    options: "ExtensionRangeOptions" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class DescriptorProtoReservedRange(betterproto.Message):
    """
    Range of reserved tag numbers. Reserved tag numbers may not be used by
     fields or extension ranges in the same message. Reserved ranges may
     not overlap.
    """

    start: int = betterproto.int32_field(1)
    end: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class ExtensionRangeOptions(betterproto.Message):
    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class FieldDescriptorProto(betterproto.Message):
    """Describes a field within a message."""

    name: str = betterproto.string_field(1)
    number: int = betterproto.int32_field(3)
    label: "FieldDescriptorProtoLabel" = betterproto.enum_field(4)
    type: "FieldDescriptorProtoType" = betterproto.enum_field(5)
    """
    If type_name is set, this need not be set.  If both this and type_name
     are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or TYPE_GROUP.
    """

    type_name: str = betterproto.string_field(6)
    """
    For message and enum types, this is the name of the type.  If the name
     starts with a '.', it is fully-qualified.  Otherwise, C++-like scoping
     rules are used to find the type (i.e. first the nested types within this
     message are searched, then within the parent, on up to the root
     namespace).
    """

    extendee: str = betterproto.string_field(2)
    """
    For extensions, this is the name of the type being extended.  It is
     resolved in the same manner as type_name.
    """

    default_value: str = betterproto.string_field(7)
    """
    For numeric types, contains the original text representation of the value.
     For booleans, "true" or "false".
     For strings, contains the default text contents (not escaped in any way).
     For bytes, contains the C escaped value.  All bytes >= 128 are escaped.
     TODO(kenton):  Base-64 encode?
    """

    oneof_index: int = betterproto.int32_field(9)
    """
    If set, gives the index of a oneof in the containing type's oneof_decl
     list.  This field is a member of that oneof.
    """

    json_name: str = betterproto.string_field(10)
    """
    JSON name of this field. The value is set by protocol compiler. If the
     user has set a "json_name" option on this field, that option's value
     will be used. Otherwise, it's deduced from the field's name by converting
     it to camelCase.
    """

    options: "FieldOptions" = betterproto.message_field(8)
    proto3_optional: bool = betterproto.bool_field(17)
    """
    If true, this is a proto3 "optional". When a proto3 field is optional, it
     tracks presence regardless of field type.
    
     When proto3_optional is true, this field must be belong to a oneof to
     signal to old proto3 clients that presence is tracked for this field. This
     oneof is known as a "synthetic" oneof, and this field must be its sole
     member (each proto3 optional field gets its own synthetic oneof). Synthetic
     oneofs exist in the descriptor only, and do not generate any API. Synthetic
     oneofs must be ordered after all "real" oneofs.
    
     For message fields, proto3_optional doesn't create any semantic change,
     since non-repeated message fields always track presence. However it still
     indicates the semantic detail of whether the user wrote "optional" or not.
     This can be useful for round-tripping the .proto file. For consistency we
     give message fields a synthetic oneof also, even though it is not required
     to track presence. This is especially important because the parser can't
     tell if a field is a message or an enum, so it must always create a
     synthetic oneof.
    
     Proto2 optional fields do not set this flag, because they already indicate
     optional with `LABEL_OPTIONAL`.
    """


@dataclass(eq=False, repr=False)
class OneofDescriptorProto(betterproto.Message):
    """Describes a oneof."""

    name: str = betterproto.string_field(1)
    options: "OneofOptions" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EnumDescriptorProto(betterproto.Message):
    """Describes an enum type."""

    name: str = betterproto.string_field(1)
    value: List["EnumValueDescriptorProto"] = betterproto.message_field(2)
    options: "EnumOptions" = betterproto.message_field(3)
    reserved_range: List[
        "EnumDescriptorProtoEnumReservedRange"
    ] = betterproto.message_field(4)
    """
    Range of reserved numeric values. Reserved numeric values may not be used
     by enum values in the same enum declaration. Reserved ranges may not
     overlap.
    """

    reserved_name: List[str] = betterproto.string_field(5)
    """
    Reserved enum value names, which may not be reused. A given name may only
     be reserved once.
    """


@dataclass(eq=False, repr=False)
class EnumDescriptorProtoEnumReservedRange(betterproto.Message):
    """
    Range of reserved numeric values. Reserved values may not be used by
     entries in the same enum. Reserved ranges may not overlap.

     Note that this is distinct from DescriptorProto.ReservedRange in that it
     is inclusive such that it can appropriately represent the entire int32
     domain.
    """

    start: int = betterproto.int32_field(1)
    end: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class EnumValueDescriptorProto(betterproto.Message):
    """Describes a value within an enum."""

    name: str = betterproto.string_field(1)
    number: int = betterproto.int32_field(2)
    options: "EnumValueOptions" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ServiceDescriptorProto(betterproto.Message):
    """Describes a service."""

    name: str = betterproto.string_field(1)
    method: List["MethodDescriptorProto"] = betterproto.message_field(2)
    options: "ServiceOptions" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MethodDescriptorProto(betterproto.Message):
    """Describes a method of a service."""

    name: str = betterproto.string_field(1)
    input_type: str = betterproto.string_field(2)
    """
    Input and output type names.  These are resolved in the same way as
     FieldDescriptorProto.type_name, but must refer to a message type.
    """

    output_type: str = betterproto.string_field(3)
    options: "MethodOptions" = betterproto.message_field(4)
    client_streaming: bool = betterproto.bool_field(5)
    """Identifies if client streams multiple client messages"""

    server_streaming: bool = betterproto.bool_field(6)
    """Identifies if server streams multiple server messages"""


@dataclass(eq=False, repr=False)
class FileOptions(betterproto.Message):
    java_package: str = betterproto.string_field(1)
    """
    Sets the Java package where classes generated from this .proto will be
     placed.  By default, the proto package is used, but this is often
     inappropriate because proto packages do not normally start with backwards
     domain names.
    """

    java_outer_classname: str = betterproto.string_field(8)
    """
    If set, all the classes from the .proto file are wrapped in a single
     outer class with the given name.  This applies to both Proto1
     (equivalent to the old "--one_java_file" option) and Proto2 (where
     a .proto always translates to a single class, but you may want to
     explicitly choose the class name).
    """

    java_multiple_files: bool = betterproto.bool_field(10)
    """
    If set true, then the Java code generator will generate a separate .java
     file for each top-level message, enum, and service defined in the .proto
     file.  Thus, these types will *not* be nested inside the outer class
     named by java_outer_classname.  However, the outer class will still be
     generated to contain the file's getDescriptor() method as well as any
     top-level extensions defined in the file.
    """

    java_generate_equals_and_hash: bool = betterproto.bool_field(20)
    """This option does nothing."""

    java_string_check_utf8: bool = betterproto.bool_field(27)
    """
    If set true, then the Java2 code generator will generate code that
     throws an exception whenever an attempt is made to assign a non-UTF-8
     byte sequence to a string field.
     Message reflection will do the same.
     However, an extension field still accepts non-UTF-8 byte sequences.
     This option has no effect on when used with the lite runtime.
    """

    optimize_for: "FileOptionsOptimizeMode" = betterproto.enum_field(9)
    go_package: str = betterproto.string_field(11)
    """
    Sets the Go package where structs generated from this .proto will be
     placed. If omitted, the Go package will be derived from the following:
       - The basename of the package import path, if provided.
       - Otherwise, the package statement in the .proto file, if present.
       - Otherwise, the basename of the .proto file, without extension.
    """

    cc_generic_services: bool = betterproto.bool_field(16)
    """
    Should generic services be generated in each language?  "Generic" services
     are not specific to any particular RPC system.  They are generated by the
     main code generators in each language (without additional plugins).
     Generic services were the only kind of service generation supported by
     early versions of google.protobuf.
    
     Generic services are now considered deprecated in favor of using plugins
     that generate code specific to your particular RPC system.  Therefore,
     these default to false.  Old code which depends on generic services should
     explicitly set them to true.
    """

    java_generic_services: bool = betterproto.bool_field(17)
    py_generic_services: bool = betterproto.bool_field(18)
    php_generic_services: bool = betterproto.bool_field(42)
    deprecated: bool = betterproto.bool_field(23)
    """
    Is this file deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for everything in the file, or it will be completely ignored; in the very
     least, this is a formalization for deprecating files.
    """

    cc_enable_arenas: bool = betterproto.bool_field(31)
    """
    Enables the use of arenas for the proto messages in this file. This applies
     only to generated classes for C++.
    """

    objc_class_prefix: str = betterproto.string_field(36)
    """
    Sets the objective c class prefix which is prepended to all objective c
     generated classes from this .proto. There is no default.
    """

    csharp_namespace: str = betterproto.string_field(37)
    """Namespace for generated classes; defaults to the package."""

    swift_prefix: str = betterproto.string_field(39)
    """
    By default Swift generators will take the proto package and CamelCase it
     replacing '.' with underscore and use that to prefix the types/symbols
     defined. When this options is provided, they will use this value instead
     to prefix the types/symbols defined.
    """

    php_class_prefix: str = betterproto.string_field(40)
    """
    Sets the php class prefix which is prepended to all php generated classes
     from this .proto. Default is empty.
    """

    php_namespace: str = betterproto.string_field(41)
    """
    Use this option to change the namespace of php generated classes. Default
     is empty. When this option is empty, the package name will be used for
     determining the namespace.
    """

    php_metadata_namespace: str = betterproto.string_field(44)
    """
    Use this option to change the namespace of php generated metadata classes.
     Default is empty. When this option is empty, the proto file name will be
     used for determining the namespace.
    """

    ruby_package: str = betterproto.string_field(45)
    """
    Use this option to change the package of ruby generated classes. Default
     is empty. When this option is not set, the package name will be used for
     determining the ruby package.
    """

    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """
    The parser stores options it doesn't recognize here.
     See the documentation for the "Options" section above.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("java_generate_equals_and_hash"):
            warnings.warn(
                "FileOptions.java_generate_equals_and_hash is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class MessageOptions(betterproto.Message):
    message_set_wire_format: bool = betterproto.bool_field(1)
    """
    Set true to use the old proto1 MessageSet wire format for extensions.
     This is provided for backwards-compatibility with the MessageSet wire
     format.  You should not use this for any other reason:  It's less
     efficient, has fewer features, and is more complicated.
    
     The message must be defined exactly as follows:
       message Foo {
         option message_set_wire_format = true;
         extensions 4 to max;
       }
     Note that the message cannot have any defined fields; MessageSets only
     have extensions.
    
     All extensions of your type must be singular messages; e.g. they cannot
     be int32s, enums, or repeated messages.
    
     Because this is an option, the above two restrictions are not enforced by
     the protocol compiler.
    """

    no_standard_descriptor_accessor: bool = betterproto.bool_field(2)
    """
    Disables the generation of the standard "descriptor()" accessor, which can
     conflict with a field of the same name.  This is meant to make migration
     from proto1 easier; new code should avoid fields named "descriptor".
    """

    deprecated: bool = betterproto.bool_field(3)
    """
    Is this message deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for the message, or it will be completely ignored; in the very least,
     this is a formalization for deprecating messages.
    """

    map_entry: bool = betterproto.bool_field(7)
    """
    Whether the message is an automatically generated map entry type for the
     maps field.
    
     For maps fields:
         map<KeyType, ValueType> map_field = 1;
     The parsed descriptor looks like:
         message MapFieldEntry {
             option map_entry = true;
             optional KeyType key = 1;
             optional ValueType value = 2;
         }
         repeated MapFieldEntry map_field = 1;
    
     Implementations may choose not to generate the map_entry=true message, but
     use a native map in the target language to hold the keys and values.
     The reflection APIs in such implementations still need to work as
     if the field is a repeated message field.
    
     NOTE: Do not set the option in .proto files. Always use the maps syntax
     instead. The option should only be implicitly set by the proto compiler
     parser.
    """

    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class FieldOptions(betterproto.Message):
    ctype: "FieldOptionsCType" = betterproto.enum_field(1)
    """
    The ctype option instructs the C++ code generator to use a different
     representation of the field than it normally would.  See the specific
     options below.  This option is not yet implemented in the open source
     release -- sorry, we'll try to include it in a future version!
    """

    packed: bool = betterproto.bool_field(2)
    """
    The packed option can be enabled for repeated primitive fields to enable
     a more efficient representation on the wire. Rather than repeatedly
     writing the tag and type for each element, the entire array is encoded as
     a single length-delimited blob. In proto3, only explicit setting it to
     false will avoid using packed encoding.
    """

    jstype: "FieldOptionsJsType" = betterproto.enum_field(6)
    """
    The jstype option determines the JavaScript type used for values of the
     field.  The option is permitted only for 64 bit integral and fixed types
     (int64, uint64, sint64, fixed64, sfixed64).  A field with jstype JS_STRING
     is represented as JavaScript string, which avoids loss of precision that
     can happen when a large value is converted to a floating point JavaScript.
     Specifying JS_NUMBER for the jstype causes the generated JavaScript code to
     use the JavaScript "number" type.  The behavior of the default option
     JS_NORMAL is implementation dependent.
    
     This option is an enum to permit additional types to be added, e.g.
     goog.math.Integer.
    """

    lazy: bool = betterproto.bool_field(5)
    """
    Should this field be parsed lazily?  Lazy applies only to message-type
     fields.  It means that when the outer message is initially parsed, the
     inner message's contents will not be parsed but instead stored in encoded
     form.  The inner message will actually be parsed when it is first accessed.
    
     This is only a hint.  Implementations are free to choose whether to use
     eager or lazy parsing regardless of the value of this option.  However,
     setting this option true suggests that the protocol author believes that
     using lazy parsing on this field is worth the additional bookkeeping
     overhead typically needed to implement it.
    
     This option does not affect the public interface of any generated code;
     all method signatures remain the same.  Furthermore, thread-safety of the
     interface is not affected by this option; const methods remain safe to
     call from multiple threads concurrently, while non-const methods continue
     to require exclusive access.
    
    
     Note that implementations may choose not to check required fields within
     a lazy sub-message.  That is, calling IsInitialized() on the outer message
     may return true even if the inner message has missing required fields.
     This is necessary because otherwise the inner message would have to be
     parsed in order to perform the check, defeating the purpose of lazy
     parsing.  An implementation which chooses not to check required fields
     must be consistent about it.  That is, for any particular sub-message, the
     implementation must either *always* check its required fields, or *never*
     check its required fields, regardless of whether or not the message has
     been parsed.
    """

    deprecated: bool = betterproto.bool_field(3)
    """
    Is this field deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for accessors, or it will be completely ignored; in the very least, this
     is a formalization for deprecating fields.
    """

    weak: bool = betterproto.bool_field(10)
    """For Google-internal migration only. Do not use."""

    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class OneofOptions(betterproto.Message):
    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class EnumOptions(betterproto.Message):
    allow_alias: bool = betterproto.bool_field(2)
    """
    Set this option to true to allow mapping different tag names to the same
     value.
    """

    deprecated: bool = betterproto.bool_field(3)
    """
    Is this enum deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for the enum, or it will be completely ignored; in the very least, this
     is a formalization for deprecating enums.
    """

    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class EnumValueOptions(betterproto.Message):
    deprecated: bool = betterproto.bool_field(1)
    """
    Is this enum value deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for the enum value, or it will be completely ignored; in the very least,
     this is a formalization for deprecating enum values.
    """

    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class ServiceOptions(betterproto.Message):
    deprecated: bool = betterproto.bool_field(33)
    """
    Is this service deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for the service, or it will be completely ignored; in the very least,
     this is a formalization for deprecating services.
    """

    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class MethodOptions(betterproto.Message):
    deprecated: bool = betterproto.bool_field(33)
    """
    Is this method deprecated?
     Depending on the target platform, this can emit Deprecated annotations
     for the method, or it will be completely ignored; in the very least,
     this is a formalization for deprecating methods.
    """

    idempotency_level: "MethodOptionsIdempotencyLevel" = betterproto.enum_field(34)
    uninterpreted_option: List["UninterpretedOption"] = betterproto.message_field(999)
    """The parser stores options it doesn't recognize here. See above."""


@dataclass(eq=False, repr=False)
class UninterpretedOption(betterproto.Message):
    """
    A message representing a option the parser does not recognize. This only
     appears in options protos created by the compiler::Parser class.
     DescriptorPool resolves these when building Descriptor objects. Therefore,
     options protos in descriptor objects (e.g. returned by Descriptor::options(),
     or produced by Descriptor::CopyTo()) will never have UninterpretedOptions
     in them.
    """

    name: List["UninterpretedOptionNamePart"] = betterproto.message_field(2)
    identifier_value: str = betterproto.string_field(3)
    """
    The value of the uninterpreted option, in whatever type the tokenizer
     identified it as during parsing. Exactly one of these should be set.
    """

    positive_int_value: int = betterproto.uint64_field(4)
    negative_int_value: int = betterproto.int64_field(5)
    double_value: float = betterproto.double_field(6)
    string_value: bytes = betterproto.bytes_field(7)
    aggregate_value: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class UninterpretedOptionNamePart(betterproto.Message):
    """
    The name of the uninterpreted option.  Each string represents a segment in
     a dot-separated name.  is_extension is true iff a segment represents an
     extension (denoted with parentheses in options specs in .proto files).
     E.g.,{ ["foo", false], ["bar.baz", true], ["qux", false] } represents
     "foo.(bar.baz).qux".
    """

    name_part: str = betterproto.string_field(1)
    is_extension: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class SourceCodeInfo(betterproto.Message):
    """
    Encapsulates information about the original source file from which a
     FileDescriptorProto was generated.
    """

    location: List["SourceCodeInfoLocation"] = betterproto.message_field(1)
    """
    A Location identifies a piece of source code in a .proto file which
     corresponds to a particular definition.  This information is intended
     to be useful to IDEs, code indexers, documentation generators, and similar
     tools.
    
     For example, say we have a file like:
       message Foo {
         optional string foo = 1;
       }
     Let's look at just the field definition:
       optional string foo = 1;
       ^       ^^     ^^  ^  ^^^
       a       bc     de  f  ghi
     We have the following locations:
       span   path               represents
       [a,i)  [ 4, 0, 2, 0 ]     The whole field definition.
       [a,b)  [ 4, 0, 2, 0, 4 ]  The label (optional).
       [c,d)  [ 4, 0, 2, 0, 5 ]  The type (string).
       [e,f)  [ 4, 0, 2, 0, 1 ]  The name (foo).
       [g,h)  [ 4, 0, 2, 0, 3 ]  The number (1).
    
     Notes:
     - A location may refer to a repeated field itself (i.e. not to any
       particular index within it).  This is used whenever a set of elements are
       logically enclosed in a single code segment.  For example, an entire
       extend block (possibly containing multiple extension definitions) will
       have an outer location whose path refers to the "extensions" repeated
       field without an index.
     - Multiple locations may have the same path.  This happens when a single
       logical declaration is spread out across multiple places.  The most
       obvious example is the "extend" block again -- there may be multiple
       extend blocks in the same scope, each of which will have the same path.
     - A location's span is not always a subset of its parent's span.  For
       example, the "extendee" of an extension declaration appears at the
       beginning of the "extend" block and is shared by all extensions within
       the block.
     - Just because a location's span is a subset of some other location's span
       does not mean that it is a descendant.  For example, a "group" defines
       both a type and a field in a single declaration.  Thus, the locations
       corresponding to the type and field and their components will overlap.
     - Code which tries to interpret locations should probably be designed to
       ignore those that it doesn't understand, as more types of locations could
       be recorded in the future.
    """


@dataclass(eq=False, repr=False)
class SourceCodeInfoLocation(betterproto.Message):
    path: List[int] = betterproto.int32_field(1)
    """
    Identifies which part of the FileDescriptorProto was defined at this
     location.
    
     Each element is a field number or an index.  They form a path from
     the root FileDescriptorProto to the place where the definition.  For
     example, this path:
       [ 4, 3, 2, 7, 1 ]
     refers to:
       file.message_type(3)  // 4, 3
           .field(7)         // 2, 7
           .name()           // 1
     This is because FileDescriptorProto.message_type has field number 4:
       repeated DescriptorProto message_type = 4;
     and DescriptorProto.field has field number 2:
       repeated FieldDescriptorProto field = 2;
     and FieldDescriptorProto.name has field number 1:
       optional string name = 1;
    
     Thus, the above path gives the location of a field name.  If we removed
     the last element:
       [ 4, 3, 2, 7 ]
     this path refers to the whole field declaration (from the beginning
     of the label to the terminating semicolon).
    """

    span: List[int] = betterproto.int32_field(2)
    """
    Always has exactly three or four elements: start line, start column,
     end line (optional, otherwise assumed same as start line), end column.
     These are packed into a single field for efficiency.  Note that line
     and column numbers are zero-based -- typically you will want to add
     1 to each before displaying to a user.
    """

    leading_comments: str = betterproto.string_field(3)
    """
    If this SourceCodeInfo represents a complete declaration, these are any
     comments appearing before and after the declaration which appear to be
     attached to the declaration.
    
     A series of line comments appearing on consecutive lines, with no other
     tokens appearing on those lines, will be treated as a single comment.
    
     leading_detached_comments will keep paragraphs of comments that appear
     before (but not connected to) the current element. Each paragraph,
     separated by empty lines, will be one comment element in the repeated
     field.
    
     Only the comment content is provided; comment markers (e.g. //) are
     stripped out.  For block comments, leading whitespace and an asterisk
     will be stripped from the beginning of each line other than the first.
     Newlines are included in the output.
    
     Examples:
    
       optional int32 foo = 1;  // Comment attached to foo.
       // Comment attached to bar.
       optional int32 bar = 2;
    
       optional string baz = 3;
       // Comment attached to baz.
       // Another line attached to baz.
    
       // Comment attached to qux.
       //
       // Another line attached to qux.
       optional double qux = 4;
    
       // Detached comment for corge. This is not leading or trailing comments
       // to qux or corge because there are blank lines separating it from
       // both.
    
       // Detached comment for corge paragraph 2.
    
       optional string corge = 5;
       /* Block comment attached
        * to corge.  Leading asterisks
        * will be removed. */
       /* Block comment attached to
        * grault. */
       optional int32 grault = 6;
    
       // ignored detached comments.
    """

    trailing_comments: str = betterproto.string_field(4)
    leading_detached_comments: List[str] = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class GeneratedCodeInfo(betterproto.Message):
    """
    Describes the relationship between generated code and its original source
     file. A GeneratedCodeInfo message is associated with only one generated
     source file, but may contain references to different source .proto files.
    """

    annotation: List["GeneratedCodeInfoAnnotation"] = betterproto.message_field(1)
    """
    An Annotation connects some span of text in generated code to an element
     of its generating .proto file.
    """


@dataclass(eq=False, repr=False)
class GeneratedCodeInfoAnnotation(betterproto.Message):
    path: List[int] = betterproto.int32_field(1)
    """
    Identifies the element in the original source .proto file. This field
     is formatted the same as SourceCodeInfo.Location.path.
    """

    source_file: str = betterproto.string_field(2)
    """Identifies the filesystem path to the original source .proto."""

    begin: int = betterproto.int32_field(3)
    """
    Identifies the starting offset in bytes in the generated code
     that relates to the identified object.
    """

    end: int = betterproto.int32_field(4)
    """
    Identifies the ending offset in bytes in the generated code that
     relates to the identified offset. The end offset should be one past
     the last relevant byte (so the length of the text = end - begin).
    """


rebuild_dataclass(FileDescriptorSet)  # type: ignore
rebuild_dataclass(FileDescriptorProto)  # type: ignore
rebuild_dataclass(DescriptorProto)  # type: ignore
rebuild_dataclass(DescriptorProtoExtensionRange)  # type: ignore
rebuild_dataclass(ExtensionRangeOptions)  # type: ignore
rebuild_dataclass(FieldDescriptorProto)  # type: ignore
rebuild_dataclass(OneofDescriptorProto)  # type: ignore
rebuild_dataclass(EnumDescriptorProto)  # type: ignore
rebuild_dataclass(EnumValueDescriptorProto)  # type: ignore
rebuild_dataclass(ServiceDescriptorProto)  # type: ignore
rebuild_dataclass(MethodDescriptorProto)  # type: ignore
rebuild_dataclass(FileOptions)  # type: ignore
rebuild_dataclass(MessageOptions)  # type: ignore
rebuild_dataclass(FieldOptions)  # type: ignore
rebuild_dataclass(OneofOptions)  # type: ignore
rebuild_dataclass(EnumOptions)  # type: ignore
rebuild_dataclass(EnumValueOptions)  # type: ignore
rebuild_dataclass(ServiceOptions)  # type: ignore
rebuild_dataclass(MethodOptions)  # type: ignore
rebuild_dataclass(UninterpretedOption)  # type: ignore
rebuild_dataclass(SourceCodeInfo)  # type: ignore
rebuild_dataclass(GeneratedCodeInfo)  # type: ignore
