/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImageVisualizer
extends JPanel {
    private static final long serialVersionUID = -6754436015453195809L;
    private static final int COUNT_TO_AVG = 50;
    private static final int OSD_SIZE_FRACT_OF_HEIGHT = 20;
    private Font default_osd_font = null;
    private int current_osd_height;
    private BufferedImage todraw = null;
    private Object locker = new Object();
    private long prev = System.currentTimeMillis();
    private long osdtime = System.currentTimeMillis();
    private int count = 0;
    private int fps;
    private String OSD;
    private int width = -1;
    private int height = -1;
    private int nwidth = 1;
    private int nheight = 1;
    private int im_width = -1;
    private int im_height = -1;
    private int todraw_width = 1;
    private int todraw_height = 1;
    private int todraw_x = 0;
    private int todraw_y = 0;
    private int desired_image_width = -1;
    private Graphics theonewith_hints = null;
    private volatile boolean rendering_quality_high = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(BufferedImage bufferedImage, int n) {
        Object object = this.locker;
        synchronized (object) {
            this.desired_image_width = n;
            this.todraw = bufferedImage;
        }
        this.repaint();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.nwidth = n3;
        this.nheight = n4;
        this.current_osd_height = n4 / 20;
        this.default_osd_font = new Font(null, 0, this.current_osd_height);
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.nwidth = rectangle.width;
        this.nheight = rectangle.height;
        this.current_osd_height = this.height / 20;
        this.default_osd_font = new Font(null, 0, this.current_osd_height);
        super.setBounds(rectangle);
    }

    public void setRenderingQualityHigh(boolean bl) {
        this.rendering_quality_high = bl;
        this.theonewith_hints = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Object object;
        if (this.theonewith_hints != graphics) {
            try {
                object = (Graphics2D)graphics;
                if (this.rendering_quality_high) {
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                this.theonewith_hints = graphics;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.todraw != null) {
            if (this.desired_image_width != this.im_width || this.todraw.getHeight() != this.im_height || this.nwidth != this.width || this.nheight != this.height) {
                this.width = this.nwidth;
                this.height = this.nheight;
                this.im_width = this.desired_image_width;
                this.im_height = this.todraw.getHeight();
                this.todraw_width = this.width;
                this.todraw_height = this.height;
                if (this.width * this.im_height < this.im_width * this.height) {
                    this.todraw_height = this.width * this.im_height / this.im_width;
                } else {
                    this.todraw_width = this.height * this.im_width / this.im_height;
                }
                this.todraw_x = (this.width - this.todraw_width) / 2;
                this.todraw_y = (this.height - this.todraw_height) / 2;
            }
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.width, this.height);
            object = this.locker;
            synchronized (object) {
                graphics.drawImage(this.todraw, this.todraw_x, this.todraw_y, this.todraw_width, this.todraw_height, null);
            }
            this.drawFPS(graphics);
            this.drawOSD(graphics);
        } else {
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void drawFPS(Graphics graphics) {
        ++this.count;
        if (this.count > 50) {
            long l = System.currentTimeMillis();
            this.fps = (int)Math.round(50000.0 / (double)(l - this.prev));
            this.count = 0;
            this.prev = l;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(this.width - 60, 0, 60, 20);
        graphics.setColor(Color.black);
        graphics.drawString(this.fps + " fps", this.width - 60, 15);
    }

    private void drawOSD(Graphics graphics) {
        if (this.OSD != null && !this.OSD.isEmpty()) {
            graphics.setColor(Color.green);
            Font font = graphics.getFont();
            graphics.setFont(this.default_osd_font);
            graphics.drawString(this.OSD, 5, this.current_osd_height);
            graphics.setFont(font);
            if (System.currentTimeMillis() > this.osdtime) {
                this.OSD = null;
            }
        }
    }

    public void setOSD(String string, long l) {
        this.OSD = string;
        this.osdtime = System.currentTimeMillis() + l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImageToPNGFile(File file) {
        File file2 = new File(file, new Timestamp(new Date().getTime()).toString().replace(" ", "").replace(":", "") + ".png");
        if (this.todraw != null) {
            BufferedImage bufferedImage = this.todraw;
            synchronized (bufferedImage) {
                try {
                    ImageIO.write((RenderedImage)this.todraw, "png", file2);
                    System.out.println("File " + file2 + " saved!");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("No file on screen to write!");
    }
}

