/*

Copyright 2006 Suzanne Skinner, John Spray

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef LOAD_SAVE_H
#define LOAD_SAVE_H

#include "util.h"

/*** Defines ***/

#define GLF_VERSION  "1.0"

/* Size limits for the RLE and LIF file formats. RLE_MAX_COLS also applies to the GLF format,
 * but not for the pattern description. */
#define RLE_MAX_COLS         70
#define RLE_DESC_MAX_COLS    (RLE_MAX_COLS-3)
#define LIF_MAX_COLS         80
#define LIF_DESC_MAX_COLS    (LIF_MAX_COLS-3)
#define LIF_DESC_MAX_LINES   22

/*** Enums ***/

/* Possible pattern file formats */
typedef enum {
    FORMAT_GLF,
    FORMAT_RLE,
    FORMAT_LIF_105,
    FORMAT_LIF_106,
    FORMAT_XLIFE,

    NUM_FORMATS
} file_format_type;

/*** Types ***/

/* File format loaders and savers */
typedef void (*loader_function)(FILE* f);
typedef void (*saver_function)(FILE* f);

/* Temporary structure used when saving RLE/GLF files */
typedef struct rle_cage_struct {
    uint16  x, y;
    uint16  nw, ne, sw, se;
} rle_cage;

/*** Public Constants ***/

extern loader_function loaders[NUM_FORMATS];
extern saver_function  savers[NUM_FORMATS];

/*** Public Prototypes ***/

void  load_pattern_glf(FILE* f);
void  load_pattern_rle(FILE* f);
void  load_pattern_lif_105(FILE* f);
void  load_pattern_lif_106(FILE* f);
void  load_pattern_xlife(FILE* f);

void  save_pattern_glf(FILE* f);
void  save_pattern_rle(FILE* f);
void  save_pattern_lif_105(FILE* f);
void  save_pattern_lif_106(FILE* f);
void  save_pattern_xlife(FILE* f);

boolean  process_glf_header(const char* line, int32* startx, int32* starty,
                            int32* width, int32* height);
boolean  process_rle_header(const char* line, int32* startx, int32* starty,
                            int32* width, int32* height);

#endif
