﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudhsmv2/model/CreateClusterRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CloudHSMV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateClusterRequest::SerializePayload() const {
  JsonValue payload;

  if (m_backupRetentionPolicyHasBeenSet) {
    payload.WithObject("BackupRetentionPolicy", m_backupRetentionPolicy.Jsonize());
  }

  if (m_hsmTypeHasBeenSet) {
    payload.WithString("HsmType", m_hsmType);
  }

  if (m_sourceBackupIdHasBeenSet) {
    payload.WithString("SourceBackupId", m_sourceBackupId);
  }

  if (m_subnetIdsHasBeenSet) {
    Aws::Utils::Array<JsonValue> subnetIdsJsonList(m_subnetIds.size());
    for (unsigned subnetIdsIndex = 0; subnetIdsIndex < subnetIdsJsonList.GetLength(); ++subnetIdsIndex) {
      subnetIdsJsonList[subnetIdsIndex].AsString(m_subnetIds[subnetIdsIndex]);
    }
    payload.WithArray("SubnetIds", std::move(subnetIdsJsonList));
  }

  if (m_networkTypeHasBeenSet) {
    payload.WithString("NetworkType", NetworkTypeMapper::GetNameForNetworkType(m_networkType));
  }

  if (m_tagListHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagListJsonList(m_tagList.size());
    for (unsigned tagListIndex = 0; tagListIndex < tagListJsonList.GetLength(); ++tagListIndex) {
      tagListJsonList[tagListIndex].AsObject(m_tagList[tagListIndex].Jsonize());
    }
    payload.WithArray("TagList", std::move(tagListJsonList));
  }

  if (m_modeHasBeenSet) {
    payload.WithString("Mode", ClusterModeMapper::GetNameForClusterMode(m_mode));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateClusterRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "BaldrApiService.CreateCluster"));
  return headers;
}
