//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armresources.ClientFactory type.
type ServerFactory struct {
	Server                      Server
	DeploymentOperationsServer  DeploymentOperationsServer
	DeploymentsServer           DeploymentsServer
	OperationsServer            OperationsServer
	ProviderResourceTypesServer ProviderResourceTypesServer
	ProvidersServer             ProvidersServer
	ResourceGroupsServer        ResourceGroupsServer
	TagsServer                  TagsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armresources.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armresources.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                           *ServerFactory
	trMu                          sync.Mutex
	trServer                      *ServerTransport
	trDeploymentOperationsServer  *DeploymentOperationsServerTransport
	trDeploymentsServer           *DeploymentsServerTransport
	trOperationsServer            *OperationsServerTransport
	trProviderResourceTypesServer *ProviderResourceTypesServerTransport
	trProvidersServer             *ProvidersServerTransport
	trResourceGroupsServer        *ResourceGroupsServerTransport
	trTagsServer                  *TagsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "Client":
		initServer(s, &s.trServer, func() *ServerTransport { return NewServerTransport(&s.srv.Server) })
		resp, err = s.trServer.Do(req)
	case "DeploymentOperationsClient":
		initServer(s, &s.trDeploymentOperationsServer, func() *DeploymentOperationsServerTransport {
			return NewDeploymentOperationsServerTransport(&s.srv.DeploymentOperationsServer)
		})
		resp, err = s.trDeploymentOperationsServer.Do(req)
	case "DeploymentsClient":
		initServer(s, &s.trDeploymentsServer, func() *DeploymentsServerTransport { return NewDeploymentsServerTransport(&s.srv.DeploymentsServer) })
		resp, err = s.trDeploymentsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "ProviderResourceTypesClient":
		initServer(s, &s.trProviderResourceTypesServer, func() *ProviderResourceTypesServerTransport {
			return NewProviderResourceTypesServerTransport(&s.srv.ProviderResourceTypesServer)
		})
		resp, err = s.trProviderResourceTypesServer.Do(req)
	case "ProvidersClient":
		initServer(s, &s.trProvidersServer, func() *ProvidersServerTransport { return NewProvidersServerTransport(&s.srv.ProvidersServer) })
		resp, err = s.trProvidersServer.Do(req)
	case "ResourceGroupsClient":
		initServer(s, &s.trResourceGroupsServer, func() *ResourceGroupsServerTransport {
			return NewResourceGroupsServerTransport(&s.srv.ResourceGroupsServer)
		})
		resp, err = s.trResourceGroupsServer.Do(req)
	case "TagsClient":
		initServer(s, &s.trTagsServer, func() *TagsServerTransport { return NewTagsServerTransport(&s.srv.TagsServer) })
		resp, err = s.trTagsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
