//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armresources_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armresources"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/GetProviderPermissions.json
func ExampleProvidersClient_ProviderPermissions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProvidersClient().ProviderPermissions(ctx, "Microsoft.TestRP", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderPermissionListResult = armresources.ProviderPermissionListResult{
	// 	Value: []*armresources.ProviderPermission{
	// 		{
	// 			ApplicationID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			ProviderAuthorizationConsentState: to.Ptr(armresources.ProviderAuthorizationConsentStateConsented),
	// 			RoleDefinition: &armresources.RoleDefinition{
	// 				Name: to.Ptr("Contoso service role"),
	// 				ID: to.Ptr("00000000000000000000000000000000"),
	// 				IsServiceRole: to.Ptr(true),
	// 				Permissions: []*armresources.Permission{
	// 					{
	// 						Actions: []*string{
	// 							to.Ptr("Microsoft.Contoso/*")},
	// 							DataActions: []*string{
	// 							},
	// 							NotActions: []*string{
	// 							},
	// 							NotDataActions: []*string{
	// 							},
	// 					}},
	// 					Scopes: []*string{
	// 						to.Ptr("/")},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/GetProviders.json
func ExampleProvidersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProvidersClient().NewListPager(&armresources.ProvidersClientListOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProviderListResult = armresources.ProviderListResult{
		// 	Value: []*armresources.Provider{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.TestRP1"),
		// 			Namespace: to.Ptr("Microsoft.TestRP1"),
		// 			RegistrationPolicy: to.Ptr("RegistrationRequired"),
		// 			RegistrationState: to.Ptr("Registering"),
		// 			ResourceTypes: []*armresources.ProviderResourceType{
		// 				{
		// 					APIVersions: []*string{
		// 						to.Ptr("2018-01-01"),
		// 						to.Ptr("2015-05-01")},
		// 						Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 						LocationMappings: []*armresources.ProviderExtendedLocation{
		// 							{
		// 								Type: to.Ptr("EdgeZone"),
		// 								ExtendedLocations: []*string{
		// 									to.Ptr("LosAngeles"),
		// 									to.Ptr("LosAngeles2")},
		// 									Location: to.Ptr("West US"),
		// 							}},
		// 							Locations: []*string{
		// 								to.Ptr("West US")},
		// 								ResourceType: to.Ptr("TestResourceType"),
		// 							},
		// 							{
		// 								APIVersions: []*string{
		// 									to.Ptr("2018-01-01"),
		// 									to.Ptr("2015-05-01")},
		// 									Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 									Locations: []*string{
		// 										to.Ptr("West US")},
		// 										ResourceType: to.Ptr("TestResourceTypeSibling"),
		// 								}},
		// 							},
		// 							{
		// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Resources"),
		// 								Namespace: to.Ptr("Microsoft.Resources"),
		// 								RegistrationPolicy: to.Ptr("RegistrationFree"),
		// 								RegistrationState: to.Ptr("Registered"),
		// 								ResourceTypes: []*armresources.ProviderResourceType{
		// 									{
		// 										Aliases: []*armresources.Alias{
		// 										},
		// 										APIVersions: []*string{
		// 											to.Ptr("2016-09-01"),
		// 											to.Ptr("2014-04-01-preview")},
		// 											Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 											Locations: []*string{
		// 												to.Ptr("eastus"),
		// 												to.Ptr("eastus2"),
		// 												to.Ptr("westus")},
		// 												ResourceType: to.Ptr("subscriptions"),
		// 											},
		// 											{
		// 												Aliases: []*armresources.Alias{
		// 												},
		// 												APIVersions: []*string{
		// 													to.Ptr("2016-09-01"),
		// 													to.Ptr("2014-04-01-preview")},
		// 													Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 													Locations: []*string{
		// 														to.Ptr("centralus"),
		// 														to.Ptr("eastasia"),
		// 														to.Ptr("southeastasia")},
		// 														ResourceType: to.Ptr("resourceGroups"),
		// 													},
		// 													{
		// 														Aliases: []*armresources.Alias{
		// 														},
		// 														APIVersions: []*string{
		// 															to.Ptr("2016-09-01"),
		// 															to.Ptr("2014-04-01-preview")},
		// 															Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 															Locations: []*string{
		// 																to.Ptr("eastus"),
		// 																to.Ptr("eastus2"),
		// 																to.Ptr("westus")},
		// 																ResourceType: to.Ptr("subscriptions/resourceGroups"),
		// 															},
		// 															{
		// 																Aliases: []*armresources.Alias{
		// 																},
		// 																APIVersions: []*string{
		// 																	to.Ptr("2014-04-01-preview")},
		// 																	Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 																	Locations: []*string{
		// 																		to.Ptr("centralus"),
		// 																		to.Ptr("eastasia")},
		// 																		ResourceType: to.Ptr("bulkDelete"),
		// 																	},
		// 																	{
		// 																		Aliases: []*armresources.Alias{
		// 																		},
		// 																		APIVersions: []*string{
		// 																			to.Ptr("2017-08-01"),
		// 																			to.Ptr("2017-06-01")},
		// 																			Capabilities: to.Ptr("SupportsTags"),
		// 																			Locations: []*string{
		// 																			},
		// 																			ResourceType: to.Ptr("deployments"),
		// 																		},
		// 																		{
		// 																			Aliases: []*armresources.Alias{
		// 																			},
		// 																			APIVersions: []*string{
		// 																			},
		// 																			Capabilities: to.Ptr("SupportsExtension"),
		// 																			Locations: []*string{
		// 																				to.Ptr("DevFabric")},
		// 																				ResourceType: to.Ptr("tags"),
		// 																		}},
		// 																	},
		// 																	{
		// 																		ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.TestRP2"),
		// 																		Namespace: to.Ptr("Microsoft.TestRP2"),
		// 																		RegistrationPolicy: to.Ptr("RegistrationRequired"),
		// 																		RegistrationState: to.Ptr("NotRegistered"),
		// 																		ResourceTypes: []*armresources.ProviderResourceType{
		// 																			{
		// 																				APIVersions: []*string{
		// 																					to.Ptr("2018-01-01"),
		// 																					to.Ptr("2015-05-01")},
		// 																					Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 																					LocationMappings: []*armresources.ProviderExtendedLocation{
		// 																						{
		// 																							Type: to.Ptr("EdgeZone"),
		// 																							ExtendedLocations: []*string{
		// 																								to.Ptr("LosAngeles"),
		// 																								to.Ptr("LosAngeles2")},
		// 																								Location: to.Ptr("West US"),
		// 																						}},
		// 																						Locations: []*string{
		// 																							to.Ptr("West US")},
		// 																							ResourceType: to.Ptr("TestResourceType"),
		// 																						},
		// 																						{
		// 																							APIVersions: []*string{
		// 																								to.Ptr("2018-01-01"),
		// 																								to.Ptr("2015-05-01")},
		// 																								Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
		// 																								Locations: []*string{
		// 																									to.Ptr("West US")},
		// 																									ResourceType: to.Ptr("TestResourceTypeSibling"),
		// 																							}},
		// 																					}},
		// 																				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/GetProvider.json
func ExampleProvidersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProvidersClient().Get(ctx, "Microsoft.TestRP1", &armresources.ProvidersClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Provider = armresources.Provider{
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.TestRP1"),
	// 	Namespace: to.Ptr("Microsoft.TestRP1"),
	// 	RegistrationPolicy: to.Ptr("RegistrationRequired"),
	// 	RegistrationState: to.Ptr("Registering"),
	// 	ResourceTypes: []*armresources.ProviderResourceType{
	// 		{
	// 			APIVersions: []*string{
	// 				to.Ptr("2018-01-01"),
	// 				to.Ptr("2015-05-01")},
	// 				Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
	// 				LocationMappings: []*armresources.ProviderExtendedLocation{
	// 					{
	// 						Type: to.Ptr("EdgeZone"),
	// 						ExtendedLocations: []*string{
	// 							to.Ptr("LosAngeles"),
	// 							to.Ptr("LosAngeles2")},
	// 							Location: to.Ptr("West US"),
	// 					}},
	// 					Locations: []*string{
	// 						to.Ptr("West US")},
	// 						ResourceType: to.Ptr("TestResourceType"),
	// 					},
	// 					{
	// 						APIVersions: []*string{
	// 							to.Ptr("2018-01-01"),
	// 							to.Ptr("2015-05-01")},
	// 							Capabilities: to.Ptr("CrossResourceGroupResourceMove, CrossSubscriptionResourceMove, SupportsTags, SupportsLocation"),
	// 							Locations: []*string{
	// 								to.Ptr("West US")},
	// 								ResourceType: to.Ptr("TestResourceTypeSibling"),
	// 						}},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4fd842fb73656039ec94ce367bcedee25a57bd18/specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/GetNamedProviderAtTenant.json
func ExampleProvidersClient_GetAtTenantScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresources.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProvidersClient().GetAtTenantScope(ctx, "Microsoft.Storage", &armresources.ProvidersClientGetAtTenantScopeOptions{Expand: to.Ptr("resourceTypes/aliases")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Provider = armresources.Provider{
	// 	Namespace: to.Ptr("Microsoft.Storage"),
	// 	ResourceTypes: []*armresources.ProviderResourceType{
	// 		{
	// 			Aliases: []*armresources.Alias{
	// 				{
	// 					Name: to.Ptr("Microsoft.Storage/storageAccounts/accountType"),
	// 					DefaultPath: to.Ptr("sku.name"),
	// 					Paths: []*armresources.AliasPath{
	// 						{
	// 							Path: to.Ptr("properties.accountType"),
	// 							APIVersions: []*string{
	// 								to.Ptr("2015-06-15"),
	// 								to.Ptr("2015-05-01-preview")},
	// 							},
	// 							{
	// 								Path: to.Ptr("sku.name"),
	// 								APIVersions: []*string{
	// 									to.Ptr("2018-11-01"),
	// 									to.Ptr("2018-11-09"),
	// 									to.Ptr("2018-07-01"),
	// 									to.Ptr("2018-03-01-Preview"),
	// 									to.Ptr("2018-02-01"),
	// 									to.Ptr("2017-10-01"),
	// 									to.Ptr("2017-06-01"),
	// 									to.Ptr("2016-12-01"),
	// 									to.Ptr("2016-05-01"),
	// 									to.Ptr("2016-01-01")},
	// 							}},
	// 						},
	// 						{
	// 							Name: to.Ptr("Microsoft.Storage/storageAccounts/sku.name"),
	// 							DefaultPath: to.Ptr("sku.name"),
	// 							Paths: []*armresources.AliasPath{
	// 								{
	// 									Path: to.Ptr("properties.accountType"),
	// 									APIVersions: []*string{
	// 										to.Ptr("2015-06-15"),
	// 										to.Ptr("2015-05-01-preview")},
	// 									},
	// 									{
	// 										Path: to.Ptr("sku.name"),
	// 										APIVersions: []*string{
	// 											to.Ptr("2018-11-01"),
	// 											to.Ptr("2018-11-09"),
	// 											to.Ptr("2018-07-01"),
	// 											to.Ptr("2018-03-01-Preview"),
	// 											to.Ptr("2018-02-01"),
	// 											to.Ptr("2017-10-01"),
	// 											to.Ptr("2017-06-01"),
	// 											to.Ptr("2016-12-01"),
	// 											to.Ptr("2016-05-01"),
	// 											to.Ptr("2016-01-01")},
	// 									}},
	// 								},
	// 								{
	// 									Name: to.Ptr("Microsoft.Storage/storageAccounts/accessTier"),
	// 									DefaultPath: to.Ptr("properties.accessTier"),
	// 									Paths: []*armresources.AliasPath{
	// 										{
	// 											Path: to.Ptr("properties.accessTier"),
	// 											APIVersions: []*string{
	// 												to.Ptr("2018-11-01"),
	// 												to.Ptr("2018-11-09"),
	// 												to.Ptr("2018-07-01"),
	// 												to.Ptr("2018-03-01-Preview"),
	// 												to.Ptr("2018-02-01"),
	// 												to.Ptr("2017-10-01"),
	// 												to.Ptr("2017-06-01"),
	// 												to.Ptr("2016-12-01"),
	// 												to.Ptr("2016-05-01"),
	// 												to.Ptr("2016-01-01"),
	// 												to.Ptr("2015-06-15"),
	// 												to.Ptr("2015-05-01-preview")},
	// 										}},
	// 									},
	// 									{
	// 										Name: to.Ptr("Microsoft.Storage/storageAccounts/enableBlobEncryption"),
	// 										DefaultPath: to.Ptr("properties.encryption.services.blob.enabled"),
	// 										Paths: []*armresources.AliasPath{
	// 											{
	// 												Path: to.Ptr("properties.encryption.services.blob.enabled"),
	// 												APIVersions: []*string{
	// 													to.Ptr("2018-11-01"),
	// 													to.Ptr("2018-11-09"),
	// 													to.Ptr("2018-07-01"),
	// 													to.Ptr("2018-03-01-Preview"),
	// 													to.Ptr("2018-02-01"),
	// 													to.Ptr("2017-10-01"),
	// 													to.Ptr("2017-06-01"),
	// 													to.Ptr("2016-12-01"),
	// 													to.Ptr("2016-05-01"),
	// 													to.Ptr("2016-01-01"),
	// 													to.Ptr("2015-06-15"),
	// 													to.Ptr("2015-05-01-preview")},
	// 											}},
	// 										},
	// 										{
	// 											Name: to.Ptr("Microsoft.Storage/storageAccounts/enableFileEncryption"),
	// 											DefaultPath: to.Ptr("properties.encryption.services.file.enabled"),
	// 											Paths: []*armresources.AliasPath{
	// 												{
	// 													Path: to.Ptr("properties.encryption.services.file.enabled"),
	// 													APIVersions: []*string{
	// 														to.Ptr("2018-11-01"),
	// 														to.Ptr("2018-11-09"),
	// 														to.Ptr("2018-07-01"),
	// 														to.Ptr("2018-03-01-Preview"),
	// 														to.Ptr("2018-02-01"),
	// 														to.Ptr("2017-10-01"),
	// 														to.Ptr("2017-06-01"),
	// 														to.Ptr("2016-12-01"),
	// 														to.Ptr("2016-05-01"),
	// 														to.Ptr("2016-01-01"),
	// 														to.Ptr("2015-06-15"),
	// 														to.Ptr("2015-05-01-preview")},
	// 												}},
	// 											},
	// 											{
	// 												Name: to.Ptr("Microsoft.Storage/storageAccounts/supportsHttpsTrafficOnly"),
	// 												DefaultMetadata: &armresources.AliasPathMetadata{
	// 													Type: to.Ptr(armresources.AliasPathTokenTypeBoolean),
	// 													Attributes: to.Ptr(armresources.AliasPathAttributesModifiable),
	// 												},
	// 												DefaultPath: to.Ptr("properties.supportsHttpsTrafficOnly"),
	// 												Paths: []*armresources.AliasPath{
	// 													{
	// 														Path: to.Ptr("properties.supportsHttpsTrafficOnly"),
	// 														APIVersions: []*string{
	// 															to.Ptr("2018-11-09"),
	// 															to.Ptr("2018-03-01-Preview"),
	// 															to.Ptr("2016-05-01"),
	// 															to.Ptr("2016-01-01"),
	// 															to.Ptr("2015-06-15"),
	// 															to.Ptr("2015-05-01-preview")},
	// 															Metadata: &armresources.AliasPathMetadata{
	// 																Type: to.Ptr(armresources.AliasPathTokenTypeNotSpecified),
	// 																Attributes: to.Ptr(armresources.AliasPathAttributesNone),
	// 															},
	// 													}},
	// 											}},
	// 											APIProfiles: []*armresources.APIProfile{
	// 												{
	// 													APIVersion: to.Ptr("2017-10-01"),
	// 													ProfileVersion: to.Ptr("2019-03-01-hybrid"),
	// 												},
	// 												{
	// 													APIVersion: to.Ptr("2016-01-01"),
	// 													ProfileVersion: to.Ptr("2017-03-09-profile"),
	// 												},
	// 												{
	// 													APIVersion: to.Ptr("2016-01-01"),
	// 													ProfileVersion: to.Ptr("2018-03-01-hybrid"),
	// 												},
	// 												{
	// 													APIVersion: to.Ptr("2017-10-01"),
	// 													ProfileVersion: to.Ptr("2018-06-01-profile"),
	// 											}},
	// 											APIVersions: []*string{
	// 												to.Ptr("2019-06-01"),
	// 												to.Ptr("2019-04-01"),
	// 												to.Ptr("2018-11-01"),
	// 												to.Ptr("2018-07-01"),
	// 												to.Ptr("2018-03-01-preview"),
	// 												to.Ptr("2018-02-01"),
	// 												to.Ptr("2017-10-01"),
	// 												to.Ptr("2017-06-01"),
	// 												to.Ptr("2016-12-01"),
	// 												to.Ptr("2016-05-01"),
	// 												to.Ptr("2016-01-01"),
	// 												to.Ptr("2015-06-15"),
	// 												to.Ptr("2015-05-01-preview")},
	// 												Capabilities: to.Ptr("SupportsTags, SupportsLocation"),
	// 												DefaultAPIVersion: to.Ptr("2019-06-01"),
	// 												Locations: []*string{
	// 													to.Ptr("East US"),
	// 													to.Ptr("East US 2"),
	// 													to.Ptr("East US 2 (Stage)"),
	// 													to.Ptr("West US"),
	// 													to.Ptr("West Europe"),
	// 													to.Ptr("East Asia"),
	// 													to.Ptr("Southeast Asia"),
	// 													to.Ptr("Japan East"),
	// 													to.Ptr("Japan West"),
	// 													to.Ptr("North Central US"),
	// 													to.Ptr("South Central US"),
	// 													to.Ptr("Central US"),
	// 													to.Ptr("North Europe"),
	// 													to.Ptr("Brazil South"),
	// 													to.Ptr("Australia East"),
	// 													to.Ptr("Australia Southeast"),
	// 													to.Ptr("South India"),
	// 													to.Ptr("Central India"),
	// 													to.Ptr("West India"),
	// 													to.Ptr("Canada East"),
	// 													to.Ptr("Canada Central"),
	// 													to.Ptr("West US 2"),
	// 													to.Ptr("West Central US"),
	// 													to.Ptr("UK South"),
	// 													to.Ptr("UK West"),
	// 													to.Ptr("Korea Central"),
	// 													to.Ptr("Korea South"),
	// 													to.Ptr("East US 2 EUAP"),
	// 													to.Ptr("Central US EUAP"),
	// 													to.Ptr("France Central"),
	// 													to.Ptr("France South"),
	// 													to.Ptr("Australia Central"),
	// 													to.Ptr("Australia Central 2"),
	// 													to.Ptr("South Africa West"),
	// 													to.Ptr("South Africa North"),
	// 													to.Ptr("UAE Central"),
	// 													to.Ptr("UAE North"),
	// 													to.Ptr("Switzerland North"),
	// 													to.Ptr("Switzerland West"),
	// 													to.Ptr("Germany West Central"),
	// 													to.Ptr("Germany North"),
	// 													to.Ptr("Norway East"),
	// 													to.Ptr("Norway West"),
	// 													to.Ptr("South Central US STG"),
	// 													to.Ptr("Brazil Southeast")},
	// 													ResourceType: to.Ptr("storageAccounts"),
	// 											}},
	// 										}
}
