/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the CreateCrlRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CreateCrlRestResponse{}

// CreateCrlRestResponse struct for CreateCrlRestResponse
type CreateCrlRestResponse struct {
	// Issuer Distinguished Name
	IssuerDn *string `json:"issuer_dn,omitempty"`
	// Latest base CRL version
	LatestCrlVersion *int32 `json:"latest_crl_version,omitempty"`
	// Latest delta CRL version
	LatestDeltaCrlVersion           *int32            `json:"latest_delta_crl_version,omitempty"`
	LatestPartitionCrlVersions      *map[string]int32 `json:"latest_partition_crl_versions,omitempty"`
	LatestPartitionDeltaCrlVersions *map[string]int32 `json:"latest_partition_delta_crl_versions,omitempty"`
	AllSuccess                      *bool             `json:"all_success,omitempty"`
	AdditionalProperties            map[string]interface{}
}

type _CreateCrlRestResponse CreateCrlRestResponse

// NewCreateCrlRestResponse instantiates a new CreateCrlRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateCrlRestResponse() *CreateCrlRestResponse {
	this := CreateCrlRestResponse{}
	return &this
}

// NewCreateCrlRestResponseWithDefaults instantiates a new CreateCrlRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateCrlRestResponseWithDefaults() *CreateCrlRestResponse {
	this := CreateCrlRestResponse{}
	return &this
}

// GetIssuerDn returns the IssuerDn field value if set, zero value otherwise.
func (o *CreateCrlRestResponse) GetIssuerDn() string {
	if o == nil || isNil(o.IssuerDn) {
		var ret string
		return ret
	}
	return *o.IssuerDn
}

// GetIssuerDnOk returns a tuple with the IssuerDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateCrlRestResponse) GetIssuerDnOk() (*string, bool) {
	if o == nil || isNil(o.IssuerDn) {
		return nil, false
	}
	return o.IssuerDn, true
}

// HasIssuerDn returns a boolean if a field has been set.
func (o *CreateCrlRestResponse) HasIssuerDn() bool {
	if o != nil && !isNil(o.IssuerDn) {
		return true
	}

	return false
}

// SetIssuerDn gets a reference to the given string and assigns it to the IssuerDn field.
func (o *CreateCrlRestResponse) SetIssuerDn(v string) {
	o.IssuerDn = &v
}

// GetLatestCrlVersion returns the LatestCrlVersion field value if set, zero value otherwise.
func (o *CreateCrlRestResponse) GetLatestCrlVersion() int32 {
	if o == nil || isNil(o.LatestCrlVersion) {
		var ret int32
		return ret
	}
	return *o.LatestCrlVersion
}

// GetLatestCrlVersionOk returns a tuple with the LatestCrlVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateCrlRestResponse) GetLatestCrlVersionOk() (*int32, bool) {
	if o == nil || isNil(o.LatestCrlVersion) {
		return nil, false
	}
	return o.LatestCrlVersion, true
}

// HasLatestCrlVersion returns a boolean if a field has been set.
func (o *CreateCrlRestResponse) HasLatestCrlVersion() bool {
	if o != nil && !isNil(o.LatestCrlVersion) {
		return true
	}

	return false
}

// SetLatestCrlVersion gets a reference to the given int32 and assigns it to the LatestCrlVersion field.
func (o *CreateCrlRestResponse) SetLatestCrlVersion(v int32) {
	o.LatestCrlVersion = &v
}

// GetLatestDeltaCrlVersion returns the LatestDeltaCrlVersion field value if set, zero value otherwise.
func (o *CreateCrlRestResponse) GetLatestDeltaCrlVersion() int32 {
	if o == nil || isNil(o.LatestDeltaCrlVersion) {
		var ret int32
		return ret
	}
	return *o.LatestDeltaCrlVersion
}

// GetLatestDeltaCrlVersionOk returns a tuple with the LatestDeltaCrlVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateCrlRestResponse) GetLatestDeltaCrlVersionOk() (*int32, bool) {
	if o == nil || isNil(o.LatestDeltaCrlVersion) {
		return nil, false
	}
	return o.LatestDeltaCrlVersion, true
}

// HasLatestDeltaCrlVersion returns a boolean if a field has been set.
func (o *CreateCrlRestResponse) HasLatestDeltaCrlVersion() bool {
	if o != nil && !isNil(o.LatestDeltaCrlVersion) {
		return true
	}

	return false
}

// SetLatestDeltaCrlVersion gets a reference to the given int32 and assigns it to the LatestDeltaCrlVersion field.
func (o *CreateCrlRestResponse) SetLatestDeltaCrlVersion(v int32) {
	o.LatestDeltaCrlVersion = &v
}

// GetLatestPartitionCrlVersions returns the LatestPartitionCrlVersions field value if set, zero value otherwise.
func (o *CreateCrlRestResponse) GetLatestPartitionCrlVersions() map[string]int32 {
	if o == nil || isNil(o.LatestPartitionCrlVersions) {
		var ret map[string]int32
		return ret
	}
	return *o.LatestPartitionCrlVersions
}

// GetLatestPartitionCrlVersionsOk returns a tuple with the LatestPartitionCrlVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateCrlRestResponse) GetLatestPartitionCrlVersionsOk() (*map[string]int32, bool) {
	if o == nil || isNil(o.LatestPartitionCrlVersions) {
		return nil, false
	}
	return o.LatestPartitionCrlVersions, true
}

// HasLatestPartitionCrlVersions returns a boolean if a field has been set.
func (o *CreateCrlRestResponse) HasLatestPartitionCrlVersions() bool {
	if o != nil && !isNil(o.LatestPartitionCrlVersions) {
		return true
	}

	return false
}

// SetLatestPartitionCrlVersions gets a reference to the given map[string]int32 and assigns it to the LatestPartitionCrlVersions field.
func (o *CreateCrlRestResponse) SetLatestPartitionCrlVersions(v map[string]int32) {
	o.LatestPartitionCrlVersions = &v
}

// GetLatestPartitionDeltaCrlVersions returns the LatestPartitionDeltaCrlVersions field value if set, zero value otherwise.
func (o *CreateCrlRestResponse) GetLatestPartitionDeltaCrlVersions() map[string]int32 {
	if o == nil || isNil(o.LatestPartitionDeltaCrlVersions) {
		var ret map[string]int32
		return ret
	}
	return *o.LatestPartitionDeltaCrlVersions
}

// GetLatestPartitionDeltaCrlVersionsOk returns a tuple with the LatestPartitionDeltaCrlVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateCrlRestResponse) GetLatestPartitionDeltaCrlVersionsOk() (*map[string]int32, bool) {
	if o == nil || isNil(o.LatestPartitionDeltaCrlVersions) {
		return nil, false
	}
	return o.LatestPartitionDeltaCrlVersions, true
}

// HasLatestPartitionDeltaCrlVersions returns a boolean if a field has been set.
func (o *CreateCrlRestResponse) HasLatestPartitionDeltaCrlVersions() bool {
	if o != nil && !isNil(o.LatestPartitionDeltaCrlVersions) {
		return true
	}

	return false
}

// SetLatestPartitionDeltaCrlVersions gets a reference to the given map[string]int32 and assigns it to the LatestPartitionDeltaCrlVersions field.
func (o *CreateCrlRestResponse) SetLatestPartitionDeltaCrlVersions(v map[string]int32) {
	o.LatestPartitionDeltaCrlVersions = &v
}

// GetAllSuccess returns the AllSuccess field value if set, zero value otherwise.
func (o *CreateCrlRestResponse) GetAllSuccess() bool {
	if o == nil || isNil(o.AllSuccess) {
		var ret bool
		return ret
	}
	return *o.AllSuccess
}

// GetAllSuccessOk returns a tuple with the AllSuccess field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateCrlRestResponse) GetAllSuccessOk() (*bool, bool) {
	if o == nil || isNil(o.AllSuccess) {
		return nil, false
	}
	return o.AllSuccess, true
}

// HasAllSuccess returns a boolean if a field has been set.
func (o *CreateCrlRestResponse) HasAllSuccess() bool {
	if o != nil && !isNil(o.AllSuccess) {
		return true
	}

	return false
}

// SetAllSuccess gets a reference to the given bool and assigns it to the AllSuccess field.
func (o *CreateCrlRestResponse) SetAllSuccess(v bool) {
	o.AllSuccess = &v
}

func (o CreateCrlRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CreateCrlRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.IssuerDn) {
		toSerialize["issuer_dn"] = o.IssuerDn
	}
	if !isNil(o.LatestCrlVersion) {
		toSerialize["latest_crl_version"] = o.LatestCrlVersion
	}
	if !isNil(o.LatestDeltaCrlVersion) {
		toSerialize["latest_delta_crl_version"] = o.LatestDeltaCrlVersion
	}
	if !isNil(o.LatestPartitionCrlVersions) {
		toSerialize["latest_partition_crl_versions"] = o.LatestPartitionCrlVersions
	}
	if !isNil(o.LatestPartitionDeltaCrlVersions) {
		toSerialize["latest_partition_delta_crl_versions"] = o.LatestPartitionDeltaCrlVersions
	}
	if !isNil(o.AllSuccess) {
		toSerialize["all_success"] = o.AllSuccess
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CreateCrlRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varCreateCrlRestResponse := _CreateCrlRestResponse{}

	if err = json.Unmarshal(bytes, &varCreateCrlRestResponse); err == nil {
		*o = CreateCrlRestResponse(varCreateCrlRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "issuer_dn")
		delete(additionalProperties, "latest_crl_version")
		delete(additionalProperties, "latest_delta_crl_version")
		delete(additionalProperties, "latest_partition_crl_versions")
		delete(additionalProperties, "latest_partition_delta_crl_versions")
		delete(additionalProperties, "all_success")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCreateCrlRestResponse struct {
	value *CreateCrlRestResponse
	isSet bool
}

func (v NullableCreateCrlRestResponse) Get() *CreateCrlRestResponse {
	return v.value
}

func (v *NullableCreateCrlRestResponse) Set(val *CreateCrlRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateCrlRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateCrlRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateCrlRestResponse(val *CreateCrlRestResponse) *NullableCreateCrlRestResponse {
	return &NullableCreateCrlRestResponse{value: val, isSet: true}
}

func (v NullableCreateCrlRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateCrlRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
