/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
	"time"
)

// checks if the RevokeStatusRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RevokeStatusRestResponse{}

// RevokeStatusRestResponse struct for RevokeStatusRestResponse
type RevokeStatusRestResponse struct {
	// Issuer Distinguished Name
	IssuerDn *string `json:"issuer_dn,omitempty"`
	// Hex Serial Number
	SerialNumber *string `json:"serial_number,omitempty"`
	// RFC5280 revokation reason
	RevocationReason *string `json:"revocation_reason,omitempty"`
	// Revokation date
	RevocationDate *time.Time `json:"revocation_date,omitempty"`
	// Message
	Message              *string `json:"message,omitempty"`
	Revoked              *bool   `json:"revoked,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RevokeStatusRestResponse RevokeStatusRestResponse

// NewRevokeStatusRestResponse instantiates a new RevokeStatusRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRevokeStatusRestResponse() *RevokeStatusRestResponse {
	this := RevokeStatusRestResponse{}
	return &this
}

// NewRevokeStatusRestResponseWithDefaults instantiates a new RevokeStatusRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRevokeStatusRestResponseWithDefaults() *RevokeStatusRestResponse {
	this := RevokeStatusRestResponse{}
	return &this
}

// GetIssuerDn returns the IssuerDn field value if set, zero value otherwise.
func (o *RevokeStatusRestResponse) GetIssuerDn() string {
	if o == nil || isNil(o.IssuerDn) {
		var ret string
		return ret
	}
	return *o.IssuerDn
}

// GetIssuerDnOk returns a tuple with the IssuerDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RevokeStatusRestResponse) GetIssuerDnOk() (*string, bool) {
	if o == nil || isNil(o.IssuerDn) {
		return nil, false
	}
	return o.IssuerDn, true
}

// HasIssuerDn returns a boolean if a field has been set.
func (o *RevokeStatusRestResponse) HasIssuerDn() bool {
	if o != nil && !isNil(o.IssuerDn) {
		return true
	}

	return false
}

// SetIssuerDn gets a reference to the given string and assigns it to the IssuerDn field.
func (o *RevokeStatusRestResponse) SetIssuerDn(v string) {
	o.IssuerDn = &v
}

// GetSerialNumber returns the SerialNumber field value if set, zero value otherwise.
func (o *RevokeStatusRestResponse) GetSerialNumber() string {
	if o == nil || isNil(o.SerialNumber) {
		var ret string
		return ret
	}
	return *o.SerialNumber
}

// GetSerialNumberOk returns a tuple with the SerialNumber field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RevokeStatusRestResponse) GetSerialNumberOk() (*string, bool) {
	if o == nil || isNil(o.SerialNumber) {
		return nil, false
	}
	return o.SerialNumber, true
}

// HasSerialNumber returns a boolean if a field has been set.
func (o *RevokeStatusRestResponse) HasSerialNumber() bool {
	if o != nil && !isNil(o.SerialNumber) {
		return true
	}

	return false
}

// SetSerialNumber gets a reference to the given string and assigns it to the SerialNumber field.
func (o *RevokeStatusRestResponse) SetSerialNumber(v string) {
	o.SerialNumber = &v
}

// GetRevocationReason returns the RevocationReason field value if set, zero value otherwise.
func (o *RevokeStatusRestResponse) GetRevocationReason() string {
	if o == nil || isNil(o.RevocationReason) {
		var ret string
		return ret
	}
	return *o.RevocationReason
}

// GetRevocationReasonOk returns a tuple with the RevocationReason field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RevokeStatusRestResponse) GetRevocationReasonOk() (*string, bool) {
	if o == nil || isNil(o.RevocationReason) {
		return nil, false
	}
	return o.RevocationReason, true
}

// HasRevocationReason returns a boolean if a field has been set.
func (o *RevokeStatusRestResponse) HasRevocationReason() bool {
	if o != nil && !isNil(o.RevocationReason) {
		return true
	}

	return false
}

// SetRevocationReason gets a reference to the given string and assigns it to the RevocationReason field.
func (o *RevokeStatusRestResponse) SetRevocationReason(v string) {
	o.RevocationReason = &v
}

// GetRevocationDate returns the RevocationDate field value if set, zero value otherwise.
func (o *RevokeStatusRestResponse) GetRevocationDate() time.Time {
	if o == nil || isNil(o.RevocationDate) {
		var ret time.Time
		return ret
	}
	return *o.RevocationDate
}

// GetRevocationDateOk returns a tuple with the RevocationDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RevokeStatusRestResponse) GetRevocationDateOk() (*time.Time, bool) {
	if o == nil || isNil(o.RevocationDate) {
		return nil, false
	}
	return o.RevocationDate, true
}

// HasRevocationDate returns a boolean if a field has been set.
func (o *RevokeStatusRestResponse) HasRevocationDate() bool {
	if o != nil && !isNil(o.RevocationDate) {
		return true
	}

	return false
}

// SetRevocationDate gets a reference to the given time.Time and assigns it to the RevocationDate field.
func (o *RevokeStatusRestResponse) SetRevocationDate(v time.Time) {
	o.RevocationDate = &v
}

// GetMessage returns the Message field value if set, zero value otherwise.
func (o *RevokeStatusRestResponse) GetMessage() string {
	if o == nil || isNil(o.Message) {
		var ret string
		return ret
	}
	return *o.Message
}

// GetMessageOk returns a tuple with the Message field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RevokeStatusRestResponse) GetMessageOk() (*string, bool) {
	if o == nil || isNil(o.Message) {
		return nil, false
	}
	return o.Message, true
}

// HasMessage returns a boolean if a field has been set.
func (o *RevokeStatusRestResponse) HasMessage() bool {
	if o != nil && !isNil(o.Message) {
		return true
	}

	return false
}

// SetMessage gets a reference to the given string and assigns it to the Message field.
func (o *RevokeStatusRestResponse) SetMessage(v string) {
	o.Message = &v
}

// GetRevoked returns the Revoked field value if set, zero value otherwise.
func (o *RevokeStatusRestResponse) GetRevoked() bool {
	if o == nil || isNil(o.Revoked) {
		var ret bool
		return ret
	}
	return *o.Revoked
}

// GetRevokedOk returns a tuple with the Revoked field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RevokeStatusRestResponse) GetRevokedOk() (*bool, bool) {
	if o == nil || isNil(o.Revoked) {
		return nil, false
	}
	return o.Revoked, true
}

// HasRevoked returns a boolean if a field has been set.
func (o *RevokeStatusRestResponse) HasRevoked() bool {
	if o != nil && !isNil(o.Revoked) {
		return true
	}

	return false
}

// SetRevoked gets a reference to the given bool and assigns it to the Revoked field.
func (o *RevokeStatusRestResponse) SetRevoked(v bool) {
	o.Revoked = &v
}

func (o RevokeStatusRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RevokeStatusRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.IssuerDn) {
		toSerialize["issuer_dn"] = o.IssuerDn
	}
	if !isNil(o.SerialNumber) {
		toSerialize["serial_number"] = o.SerialNumber
	}
	if !isNil(o.RevocationReason) {
		toSerialize["revocation_reason"] = o.RevocationReason
	}
	if !isNil(o.RevocationDate) {
		toSerialize["revocation_date"] = o.RevocationDate
	}
	if !isNil(o.Message) {
		toSerialize["message"] = o.Message
	}
	if !isNil(o.Revoked) {
		toSerialize["revoked"] = o.Revoked
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RevokeStatusRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRevokeStatusRestResponse := _RevokeStatusRestResponse{}

	if err = json.Unmarshal(bytes, &varRevokeStatusRestResponse); err == nil {
		*o = RevokeStatusRestResponse(varRevokeStatusRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "issuer_dn")
		delete(additionalProperties, "serial_number")
		delete(additionalProperties, "revocation_reason")
		delete(additionalProperties, "revocation_date")
		delete(additionalProperties, "message")
		delete(additionalProperties, "revoked")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRevokeStatusRestResponse struct {
	value *RevokeStatusRestResponse
	isSet bool
}

func (v NullableRevokeStatusRestResponse) Get() *RevokeStatusRestResponse {
	return v.value
}

func (v *NullableRevokeStatusRestResponse) Set(val *RevokeStatusRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRevokeStatusRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRevokeStatusRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRevokeStatusRestResponse(val *RevokeStatusRestResponse) *NullableRevokeStatusRestResponse {
	return &NullableRevokeStatusRestResponse{value: val, isSet: true}
}

func (v NullableRevokeStatusRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRevokeStatusRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
