// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package loggerv1

import (
	context "context"
	types "github.com/spiffe/spire-api-sdk/proto/spire/api/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// LoggerClient is the client API for Logger service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LoggerClient interface {
	// Gets the logger level.
	//
	// The caller must be local or present an admin X509-SVID.
	GetLogger(ctx context.Context, in *GetLoggerRequest, opts ...grpc.CallOption) (*types.Logger, error)
	// Sets the logger to a specified log level.
	//
	// The caller must be local or present an admin X509-SVID.
	SetLogLevel(ctx context.Context, in *SetLogLevelRequest, opts ...grpc.CallOption) (*types.Logger, error)
	// Resets the logger level to the level configured at launch.
	//
	// The caller must be local or present an admin X509-SVID.
	ResetLogLevel(ctx context.Context, in *ResetLogLevelRequest, opts ...grpc.CallOption) (*types.Logger, error)
}

type loggerClient struct {
	cc grpc.ClientConnInterface
}

func NewLoggerClient(cc grpc.ClientConnInterface) LoggerClient {
	return &loggerClient{cc}
}

func (c *loggerClient) GetLogger(ctx context.Context, in *GetLoggerRequest, opts ...grpc.CallOption) (*types.Logger, error) {
	out := new(types.Logger)
	err := c.cc.Invoke(ctx, "/spire.api.server.logger.v1.Logger/GetLogger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggerClient) SetLogLevel(ctx context.Context, in *SetLogLevelRequest, opts ...grpc.CallOption) (*types.Logger, error) {
	out := new(types.Logger)
	err := c.cc.Invoke(ctx, "/spire.api.server.logger.v1.Logger/SetLogLevel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggerClient) ResetLogLevel(ctx context.Context, in *ResetLogLevelRequest, opts ...grpc.CallOption) (*types.Logger, error) {
	out := new(types.Logger)
	err := c.cc.Invoke(ctx, "/spire.api.server.logger.v1.Logger/ResetLogLevel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LoggerServer is the server API for Logger service.
// All implementations must embed UnimplementedLoggerServer
// for forward compatibility
type LoggerServer interface {
	// Gets the logger level.
	//
	// The caller must be local or present an admin X509-SVID.
	GetLogger(context.Context, *GetLoggerRequest) (*types.Logger, error)
	// Sets the logger to a specified log level.
	//
	// The caller must be local or present an admin X509-SVID.
	SetLogLevel(context.Context, *SetLogLevelRequest) (*types.Logger, error)
	// Resets the logger level to the level configured at launch.
	//
	// The caller must be local or present an admin X509-SVID.
	ResetLogLevel(context.Context, *ResetLogLevelRequest) (*types.Logger, error)
	mustEmbedUnimplementedLoggerServer()
}

// UnimplementedLoggerServer must be embedded to have forward compatible implementations.
type UnimplementedLoggerServer struct {
}

func (UnimplementedLoggerServer) GetLogger(context.Context, *GetLoggerRequest) (*types.Logger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLogger not implemented")
}
func (UnimplementedLoggerServer) SetLogLevel(context.Context, *SetLogLevelRequest) (*types.Logger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLogLevel not implemented")
}
func (UnimplementedLoggerServer) ResetLogLevel(context.Context, *ResetLogLevelRequest) (*types.Logger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetLogLevel not implemented")
}
func (UnimplementedLoggerServer) mustEmbedUnimplementedLoggerServer() {}

// UnsafeLoggerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LoggerServer will
// result in compilation errors.
type UnsafeLoggerServer interface {
	mustEmbedUnimplementedLoggerServer()
}

func RegisterLoggerServer(s grpc.ServiceRegistrar, srv LoggerServer) {
	s.RegisterService(&_Logger_serviceDesc, srv)
}

func _Logger_GetLogger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggerServer).GetLogger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.logger.v1.Logger/GetLogger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggerServer).GetLogger(ctx, req.(*GetLoggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Logger_SetLogLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLogLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggerServer).SetLogLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.logger.v1.Logger/SetLogLevel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggerServer).SetLogLevel(ctx, req.(*SetLogLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Logger_ResetLogLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetLogLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggerServer).ResetLogLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.logger.v1.Logger/ResetLogLevel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggerServer).ResetLogLevel(ctx, req.(*ResetLogLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Logger_serviceDesc = grpc.ServiceDesc{
	ServiceName: "spire.api.server.logger.v1.Logger",
	HandlerType: (*LoggerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLogger",
			Handler:    _Logger_GetLogger_Handler,
		},
		{
			MethodName: "SetLogLevel",
			Handler:    _Logger_SetLogLevel_Handler,
		},
		{
			MethodName: "ResetLogLevel",
			Handler:    _Logger_ResetLogLevel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "spire/api/server/logger/v1/logger.proto",
}
