/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool-applet
 * Filename:            session.c
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Fri Jul 30 16:05:08 1999
 *                                                                             
 * Last Modification:   Fri Jul 30 16:05:08 1999
 *                                                                             
 * Copyright:           Georg Huettenegger                                
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */
#include <stdio.h>
#include <string.h>
#include <gnome.h>

#include <applet-widget.h>

#include "plextor-tool.h"
#include "session.h"
#include "scsi-functions.h"
#include "utility-functions.h"

/* has to be a positive integer (0 reserved for testing, neg. => error) */
#define SESSION_VER_1 1
#define SESSION_VER 2

void plextor_tool_session_load (gchar * cfgpath,
                                GPlextorToolAppletData * gptad)
{
  /* version of saved session */
  GPlextorToolData * gptd;
  char tmp_name[1024], * device_name_ptr, * old_device_selection;
  int session_ver, i = 0, mmc_drive, model, act_speed, max_speed;
  int act_spindown, act_speed_mode, act_waiting_setting, act_avoid_vib_setting;
  int dummy_int = -1;
  float left_volume, right_volume;
  gboolean lock_volume;


#ifdef CALL_TRACE
  flushed_output_1_string (gptad->out_file_ptr,
                           "Trace: plextor_tool_session_load: %s\n", cfgpath);
#endif

  gnome_config_push_prefix (cfgpath);

  if (!gnome_config_has_section ("plextor-tool-applet"))
  {
#ifdef VERBOSE_OUTPUT
    flushed_output_0 (gptad->out_file_ptr, "no config file?\n");
#endif
    return;
  }
  session_ver = gnome_config_get_int_with_default
    ("plextor-tool-applet/session-ver", &dummy_int);
  if ( (session_ver != SESSION_VER) && (session_ver != SESSION_VER_1) )
  {
#ifdef VERBOSE_OUTPUT
    flushed_output_2_int (gptad->out_file_ptr,
                          "wrong format, expected: %d, got: %d!\n",
                          SESSION_VER, session_ver);
#endif
    return;
  }

  old_device_selection = gnome_config_get_string 
    ("plextor-tool-applet/device_selection");


  gptd = find_gptd_with_device_name (gptad, old_device_selection);

  if (gptd)
  { /* the old selected device is still available, use stored info */
    g_free (gptad->old_device_selection);
    gptad->old_device_selection = old_device_selection;

    g_free (gptad->old_speed_selection);
    gptad->old_speed_selection = gnome_config_get_string
      ("plextor-tool-applet/speed_selection");
    
    g_free (gptad->old_spindown_selection);
    gptad->old_spindown_selection = gnome_config_get_string
      ("plextor-tool-applet/spindown-selection");
  }
  else
  { /* just eat the old information */
    g_free (gnome_config_get_string ("plextor-tool-applet/speed_selection"));
    g_free (gnome_config_get_string
            ("plextor-tool-applet/spindown-selection"));
    g_free (old_device_selection);
  }


  while (1)
  {
    /* first try to retrieve device name, if success retrieve more */
    sprintf (tmp_name, "plextor-tool-applet/dev%d-dev-name", i);
    device_name_ptr = gnome_config_get_string_with_default (tmp_name,
                                                            NULL);
   
    if (device_name_ptr == NULL)
      break;
 
#ifdef VERBOSE_OUTPUT
    flushed_output_1_string (gptad->out_file_ptr, "found: %s\n",
                             device_name_ptr);
#endif

    sprintf (tmp_name, "plextor-tool-applet/dev%d-mmc-drive", i);
    mmc_drive = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-plex-model", i);
    model = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-speed", i);
    act_speed = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-max-speed", i);
    max_speed = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-spindown", i);
    act_spindown = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-speed-mode", i);
    act_speed_mode = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-waiting-setting", i);
    act_waiting_setting = gnome_config_get_int (tmp_name);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-avoid-vib_setting", i);
    act_avoid_vib_setting = gnome_config_get_int (tmp_name);
    if (session_ver > SESSION_VER_1)
    {
      sprintf (tmp_name, "plextor-tool-applet/dev%d-left-volume-setting", i);
      left_volume = gnome_config_get_float (tmp_name);
      sprintf (tmp_name, "plextor-tool-applet/dev%d-right-volume-setting", i);
      right_volume = gnome_config_get_float (tmp_name);
      sprintf (tmp_name, "plextor-tool-applet/dev%d-lock-volume-setting", i);
      lock_volume = gnome_config_get_bool (tmp_name);
    }

    /* now check whether anything should be set */
    gptd = find_gptd_with_device_name (gptad, device_name_ptr+5);

    if (gptd)
    {
      if ( (mmc_drive == gptd->ptd.mmc_drive) &&
           (model == gptd->ptd.model) )
      { /* only change if at least same model, otherwise do nothing */
        if (act_speed != gptd->ptd.act_speed)
        {
          /* assumes that setable parameter are not used when changing */
          change_speed_of_device (return_speed_string
                                  (act_speed, model, mmc_drive), gptd);
        }
        if (act_spindown != gptd->ptd.act_spindown)
        {
          change_spindown_of_device (PrintInactivityString
                                     (act_spindown), gptd);
        }
        if (act_speed_mode != gptd->ptd.act_speed_mode)
        {
          gptd->ptd.act_speed_mode = act_speed_mode;
          change_speed_mode_setting (gptd);
        }
        if (act_waiting_setting != gptd->ptd.act_waiting_setting)
        {
          gptd->ptd.act_waiting_setting = act_waiting_setting;
          change_waiting_for_speed_setting (gptd);
        }
        if (act_avoid_vib_setting != gptd->ptd.act_avoid_vib_setting)
        {
          gptd->ptd.act_avoid_vib_setting = act_avoid_vib_setting;
          change_avoid_vibration_setting (gptd);
        }
	if (session_ver > SESSION_VER_1)
	{
	  if ( (left_volume != gptd->ptd.act_left_volume) ||
	       (right_volume != gptd->ptd.act_right_volume) )
	  {
	    gptd->ptd.act_left_volume = left_volume;
	    gptd->ptd.act_right_volume = right_volume;
	    change_volume_setting (gptd);
	  }
	  gptd->act_lock_volume = lock_volume;
	}
      }
    }
#ifdef VERBOSE_OUTPUT
    else
    {
      flushed_output_1_string (gptad->out_file_ptr, "did not find: %s\n",
                               device_name_ptr);
    }
#endif

    /* advance to the next element, delete string */
    ++i;
    g_free (device_name_ptr);
  };

  gnome_config_pop_prefix ();
}

int plextor_tool_session_save (GtkWidget * w,
                               const char * privcfgpath,
                               const char * globcfgpath,
                               gpointer data)
{
  GPlextorToolAppletData * gptad = data;
  GPlextorToolData * gptd;
  int i = 0;
  char tmp_name[1024];
  
#ifdef CALL_TRACE
  flushed_output_1_string (gptad->out_file_ptr,
                           "Trace: plextor_tool_session_save: %s\n",
                           privcfgpath);
#endif

  gnome_config_push_prefix (privcfgpath);

  gnome_config_set_int ("plextor-tool-applet/session-ver",
                        SESSION_VER);
  gnome_config_set_string ("plextor-tool-applet/device_selection",
                           gptad->old_device_selection);
  gnome_config_set_string ("plextor-tool-applet/speed_selection",
                           gptad->old_speed_selection);
  gnome_config_set_string ("plextor-tool-applet/spindown_selection",
                           gptad->old_spindown_selection);

  /* at least one must be available */
  gptd = g_list_nth_data (gptad->device_data, i);
  do
  { /* store all relevant parameters */

#ifdef VERBOSE_OUTPUT
    flushed_output_1_string (gptad->out_file_ptr, "Storing: %s\n",
                             gptd->ptd.device_name_ptr);
#endif

    sprintf (tmp_name, "plextor-tool-applet/dev%d-dev-name", i);
    gnome_config_set_string (tmp_name, gptd->ptd.device_name_ptr);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-mmc-drive", i);
    gnome_config_set_int (tmp_name, gptd->ptd.mmc_drive);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-plex-model", i);
    gnome_config_set_int (tmp_name, gptd->ptd.model);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-speed", i);
    gnome_config_set_int (tmp_name, gptd->ptd.act_speed);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-max-speed", i);
    gnome_config_set_int (tmp_name, gptd->ptd.max_speed);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-spindown", i);
    gnome_config_set_int (tmp_name, gptd->ptd.act_spindown);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-speed-mode", i);
    gnome_config_set_int (tmp_name, gptd->ptd.act_speed_mode);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-waiting-setting", i);
    gnome_config_set_int (tmp_name, gptd->ptd.act_waiting_setting);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-act-avoid-vib_setting", i);
    gnome_config_set_int (tmp_name, gptd->ptd.act_avoid_vib_setting);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-left-volume-setting", i);
    gnome_config_set_float (tmp_name, gptd->ptd.act_left_volume);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-right-volume-setting", i);
    gnome_config_set_float (tmp_name, gptd->ptd.act_right_volume);
    sprintf (tmp_name, "plextor-tool-applet/dev%d-lock-volume-setting", i);
    gnome_config_set_bool (tmp_name, gptd->act_lock_volume);

    /* try to get next element */
    ++i;
    gptd = g_list_nth_data (gptad->device_data, i);
  } while (gptd);

  gnome_config_pop_prefix ();

  gnome_config_sync ();
  gnome_config_drop_all ();

  return FALSE;
}

void plextor_tool_session_defaults (GPlextorToolAppletData * gptad)
{
  GPlextorToolData * gptd = NULL;

#ifdef CALL_TRACE
  flushed_output_0 (gptad->out_file_ptr,
                    "Trace: plextor_tool_session_defaults\n");
#endif

  inquiry_all_drives (gptad);

  gptd = g_list_nth_data (gptad->device_data, 0);

  /* initialize all missing gptad fields */
  if (gptd)
  {
    gptad->old_device_selection = g_strdup (g_list_nth_data 
                                            (gptad->device_names, 0));
    gptad->old_speed_selection = g_strdup (return_speed_string
                                           (gptd->ptd.act_speed,
                                            gptd->ptd.model,
                                            gptd->ptd.mmc_drive));
    gptad->old_spindown_selection = g_strdup (g_list_nth_data 
                                              (gptd->avail_spindowns,
                                               gptd->ptd.act_spindown));
  }
}

/*============================================================================*
 *============================================================================*
 * EOF session.c
 *============================================================================*
 *============================================================================*
 */
