#ifndef YARA_X
#define YARA_X

#pragma once

/* Generated with cbindgen:0.29.2 */

// This file is autogenerated by cbindgen. Don't modify it manually.

#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>


// Flag passed to [`yrx_compiler_create`] for producing colorful error
// messages.
#define YRX_COLORIZE_ERRORS 1

// Flag passed to [`yrx_compiler_create`] that enables a more relaxed
// syntax check for regular expressions.
//
// YARA-X enforces stricter regular expression syntax compared to YARA.
// For instance, YARA accepts invalid escape sequences and treats them
// as literal characters (e.g., \R is interpreted as a literal 'R'). It
// also allows some special characters to appear unescaped, inferring
// their meaning from the context (e.g., `{` and `}` in `/foo{}bar/` are
// literal, but in `/foo{0,1}bar/` they form the repetition operator
// `{0,1}`).
//
// When this flag is set, YARA-X mimics YARA's behavior, allowing
// constructs that YARA-X doesn't accept by default.
#define YRX_RELAXED_RE_SYNTAX 2

// Flag passed to [`yrx_compiler_create`] for treating slow patterns as
// errors instead of warnings.
#define YRX_ERROR_ON_SLOW_PATTERN 4

// Flag passed to [`yrx_compiler_create`] for treating slow loops as
// errors instead of warnings.
#define YRX_ERROR_ON_SLOW_LOOP 8

// Flag passed to [`yrx_compiler_create`] for enabling optimizations.
// With this flag the compiler tries to optimize rule conditions by applying
// techniques like common subexpression elimination (CSE) and loop-invariant
// code motion (LICM).
#define YRX_ENABLE_CONDITION_OPTIMIZATION 16

// Flag passed to [`yrx_compiler_create`] for disabling `include` statements.
// With this flag, the compiler produces an error when `include` statements are
// encountered.
#define YRX_DISABLE_INCLUDES 32

// Error codes returned by functions in this API.
typedef enum YRX_RESULT {
  // Everything was OK.
  YRX_SUCCESS,
  // A syntax error occurred while compiling YARA rules.
  YRX_SYNTAX_ERROR,
  // An error occurred while defining or setting a global variable. This may
  // happen when a variable is defined twice and when you try to set a value
  // that doesn't correspond to the variable's type.
  YRX_VARIABLE_ERROR,
  // An error occurred during a scan operation.
  YRX_SCAN_ERROR,
  // A scan operation was aborted due to a timeout.
  YRX_SCAN_TIMEOUT,
  // An error indicating that some of the arguments passed to a function is
  // invalid. Usually indicates a nil pointer to a scanner or compiler.
  YRX_INVALID_ARGUMENT,
  // An error indicating that some of the strings passed to a function is
  // not valid UTF-8.
  YRX_INVALID_UTF8,
  // An error indicating that a scanner that was already in multi-block
  // mode has been used as a standard scanner.
  YRX_INVALID_STATE,
  // An error occurred while serializing/deserializing YARA rules.
  YRX_SERIALIZATION_ERROR,
  // An error returned when a rule doesn't have any metadata.
  YRX_NO_METADATA,
  // An error returned in cases where some API is not supported because the
  // library was not built with the required features.
  YRX_NOT_SUPPORTED,
} YRX_RESULT;

// Types of metadata values.
typedef enum YRX_METADATA_TYPE {
  YRX_I64,
  YRX_F64,
  YRX_BOOLEAN,
  YRX_STRING,
  YRX_BYTES,
} YRX_METADATA_TYPE;

// A compiler that takes YARA source code and produces compiled rules.
typedef struct YRX_COMPILER YRX_COMPILER;

// A pattern defined in a rule.
typedef struct YRX_PATTERN YRX_PATTERN;

// A single YARA rule.
typedef struct YRX_RULE YRX_RULE;

// A set of compiled YARA rules.
typedef struct YRX_RULES YRX_RULES;

// A scanner that scans data with a set of compiled YARA rules.
typedef struct YRX_SCANNER YRX_SCANNER;

// Represents a buffer with arbitrary data.
typedef struct YRX_BUFFER {
  // Pointer to the data contained in the buffer.
  uint8_t *data;
  // Length of data in bytes.
  size_t length;
} YRX_BUFFER;

// Contains information about a pattern match.
typedef struct YRX_MATCH {
  // Offset within the data where the match occurred.
  size_t offset;
  // Length of the match.
  size_t length;
} YRX_MATCH;

// Callback function passed to [`yrx_pattern_iter_matches`].
//
// The callback is called by all matches found for a pattern, and it receives
// a pointer to a [`YRX_MATCH`] structure. This pointer is guaranteed to be
// valid while the callback function is being executed, but it will be freed
// after the callback function returns, so you cannot use the pointer, or any
// other pointer contained in the structure, outside the callback.
//
// The callback also receives a `user_data` pointer that can point to arbitrary
// data owned by the user.
typedef void (*YRX_MATCH_CALLBACK)(const struct YRX_MATCH *match_,
                                   void *user_data);

// Represents a metadata value that contains raw bytes.
typedef struct YRX_METADATA_BYTES {
  // Number of bytes.
  size_t length;
  // Pointer to the bytes.
  const uint8_t *data;
} YRX_METADATA_BYTES;

// A metadata value.
typedef union YRX_METADATA_VALUE {
  // Value if the metadata is I64.
  int64_t i64;
  // Value if the metadata is F64.
  double f64;
  // Value if the metadata is BOOLEAN.
  bool boolean;
  // Value if the metadata is STRING.
  const char *string;
  // Value if the metadata is BYTES.
  struct YRX_METADATA_BYTES bytes;
} YRX_METADATA_VALUE;

// A metadata entry.
typedef struct YRX_METADATA {
  // Metadata identifier.
  const char *identifier;
  // Metadata type.
  enum YRX_METADATA_TYPE value_type;
  // Metadata value.
  //
  // This a union type, the variant that should be used is determined by the
  // type indicated in `value_type`.
  union YRX_METADATA_VALUE value;
} YRX_METADATA;

// Callback function passed to [`yrx_rule_iter_metadata`].
//
// The callback is called for each metadata in the rule, and receives a pointer
// to a [`YRX_METADATA`] structure. This pointer is guaranteed to be valid
// while the callback function is being executed, but it will be freed after
// the callback function returns, so you cannot use the pointer, or any other
// pointer contained in this structure, outside the callback.
//
// The callback also receives a `user_data` pointer that can point to arbitrary
// data owned by the user.
typedef void (*YRX_METADATA_CALLBACK)(const struct YRX_METADATA *metadata,
                                      void *user_data);

// Callback function passed to [`yrx_rule_iter_patterns`].
//
// The callback is called for each pattern defined in the rule, and it receives
// a pointer to a [`YRX_PATTERN`] structure. This pointer is guaranteed to be
// valid while the callback function is being executed, but it will be freed
// after the callback function returns, so you cannot use this pointer, or
// any other pointer contained in the structure, outside the callback.
//
// The callback also receives a `user_data` pointer that can point to arbitrary
// data owned by the user.
typedef void (*YRX_PATTERN_CALLBACK)(const struct YRX_PATTERN *pattern,
                                     void *user_data);

// Callback function passed to [`yrx_rule_iter_tags`].
//
// The callback is called for each tag defined in the rule, and it receives
// a pointer to a string with the tag name. This pointer is guaranteed to be
// valid while the callback function is being executed, but it will be freed
// after the callback function returns, so you cannot use this pointer, or
// any other pointer contained in the structure, outside the callback.
//
// The callback also receives a `user_data` pointer that can point to arbitrary
// data owned by the user.
typedef void (*YRX_TAG_CALLBACK)(const char *tag,
                                 void *user_data);

// Callback function passed to `yrx_scanner_on_matching_rule` or
// [`yrx_rules_iter`].
//
// The callback receives a pointer to a rule, represented by a [`YRX_RULE`]
// structure. This pointer is guaranteed to be valid while the callback
// function is being executed, but it may be freed after the callback function
// returns, so you cannot use the pointer outside the callback.
//
// It also receives the `user_data` pointer that can point to arbitrary data
// owned by the user.
typedef void (*YRX_RULE_CALLBACK)(const struct YRX_RULE *rule,
                                  void *user_data);

// Callback function passed to [`yrx_rules_iter_imports`].
//
// The callback is called for every module imported by the rules, and it
// receives a pointer to the module's name. This pointer is guaranteed to be
// valid while the callback function is being executed, but it will be freed
// after the callback function returns, so you cannot use the pointer outside
// the callback.
//
// The callback also receives a `user_data` pointer that can point to arbitrary
// data owned by the user.
typedef void (*YRX_IMPORT_CALLBACK)(const char *module_name,
                                    void *user_data);

// Callback function passed to [`yrx_scanner_iter_slowest_rules`].
//
// The callback function receives pointers to the namespace and rule name,
// and two float numbers with the time spent by the rule matching patterns
// and executing its condition. The pointers are valid as long as the callback
// function is being executed, but will be freed after the callback returns.
//
// The callback also receives a `user_data` pointer that can point to arbitrary
// data owned by the user.
//
// Requires the `rules-profiling` feature.
typedef void (*YRX_SLOWEST_RULES_CALLBACK)(const char *namespace_,
                                           const char *rule,
                                           double pattern_matching_time,
                                           double condition_exec_time,
                                           void *user_data);

// Returns the error message for the most recent function in this API
// invoked by the current thread.
//
// The returned pointer is only valid until this thread calls some other
// function, as it can modify the last error and render the pointer to
// a previous error message invalid. Also, the pointer will be null if
// the most recent function was successfully.
const char *yrx_last_error(void);

// Destroys a [`YRX_BUFFER`] object.
void yrx_buffer_destroy(struct YRX_BUFFER *buf);

// Compiles YARA source code and creates a [`YRX_RULES`] object that contains
// the compiled rules.
//
// The rules must be destroyed with [`yrx_rules_destroy`].
enum YRX_RESULT yrx_compile(const char *src,
                            struct YRX_RULES **rules);

// Finalizes YARA-X.
//
// This function only needs to be called in a very specific scenario:
// when YARA-X is used as a dynamically loaded library (`.so`, `.dll`,
// `.dylib`) **and** that library must be unloaded at runtime.
//
// Its primary purpose is to remove the process-wide signal handlers
// installed by the [wasmtime] engine.
//
// # Safety
//
// This function is **unsafe** to call under normal circumstances. It has
// strict preconditions that must be met:
//
// - There must be no other active `wasmtime` engines in the process. This
//   applies not only to clones of the engine used by YARA-X (which should not
//   exist because YARA-X uses a single copy of its engine), but to *any*
//   `wasmtime` engine, since global state shared by all engines is torn
//   down.
//
// - On Unix platforms, no other signal handlers may have been installed
//   for signals intercepted by `wasmtime`. If other handlers have been set,
//   `wasmtime` cannot reliably restore the original state, which may lead
//   to undefined behavior.
//
// [wasmtime]: https://wasmtime.dev/
void yrx_finalize(void);

// Creates a [`YRX_COMPILER`] object.
enum YRX_RESULT yrx_compiler_create(uint32_t flags,
                                    struct YRX_COMPILER **compiler);

// Destroys a [`YRX_COMPILER`] object.
void yrx_compiler_destroy(struct YRX_COMPILER *compiler);

// Adds a YARA source code to be compiled.
//
// This function can be called multiple times.
enum YRX_RESULT yrx_compiler_add_source(struct YRX_COMPILER *compiler,
                                        const char *src);

// Adds a YARA source code to be compiled, specifying an origin for the
// source code.
//
// This function is similar to [`yrx_compiler_add_source`], but in addition
// to the source code itself it provides a string that identifies the origin
// of the code, usually the file path from where the source was obtained.
//
// This origin is shown in error reports.
enum YRX_RESULT yrx_compiler_add_source_with_origin(struct YRX_COMPILER *compiler,
                                                    const char *src,
                                                    const char *origin);

// Adds a directory to the list of directories where the compiler should
// look for included files.
//
// When an `include` statement is found, the compiler looks for the included
// file in the directories added with this function, in the order they were
// added.
//
// If this function is not called, the compiler will only look for included
// files in the current directory.
enum YRX_RESULT yrx_compiler_add_include_dir(struct YRX_COMPILER *compiler,
                                             const char *dir);

// Tell the compiler that a YARA module is not supported.
//
// Import statements for ignored modules will be ignored without errors but a
// warning will be issued. Any rule that make use of an ignored module will be
// ignored, while the rest of rules that don't rely on that module will be
// correctly compiled.
enum YRX_RESULT yrx_compiler_ignore_module(struct YRX_COMPILER *compiler,
                                           const char *module);

// Enables a feature on this compiler.
//
// When defining the structure of a module in a `.proto` file, you can
// specify that certain fields are accessible only when one or more
// features are enabled. For example, the snippet below shows the
// definition of a field named `requires_foo_and_bar`, which can be
// accessed only when both features "foo" and "bar" are enabled.
//
// ```protobuf
// optional uint64 requires_foo_and_bar = 500 [
//   (yara.field_options) = {
//     acl: [
//       {
//         allow_if: "foo",
//         error_title: "foo is required",
//         error_label: "this field was used without foo"
//       },
//       {
//         allow_if: "bar",
//         error_title: "bar is required",
//         error_label: "this field was used without bar"
//       }
//     ]
//   }
// ];
// ```
//
// If some of the required features are not enabled, using this field in
// a YARA rule will cause an error while compiling the rules. The error
// looks like:
//
// ```text
// error[E034]: foo is required
//  --> line:5:29
//   |
// 5 |  test_proto2.requires_foo_and_bar == 0
//   |              ^^^^^^^^^^^^^^^^^^^^ this field was used without foo
//   |
// ```
//
// Notice that both the title and label in the error message are defined
// in the .proto file.
//
// # Important
//
// This API is hidden from the public documentation because it is unstable
// and subject to change.
enum YRX_RESULT yrx_compiler_enable_feature(struct YRX_COMPILER *compiler,
                                            const char *feature);

// Tell the compiler that a YARA module can't be used.
//
// Import statements for the banned module will cause an error. The error
// message can be customized by using the given error title and message.
//
// If this function is called multiple times with the same module name,
// the error title and message will be updated.
enum YRX_RESULT yrx_compiler_ban_module(struct YRX_COMPILER *compiler,
                                        const char *module,
                                        const char *error_title,
                                        const char *error_msg);

// Creates a new namespace.
//
// Further calls to `yrx_compiler_add_source` will put the rules under the
// newly created namespace.
//
// The `namespace` argument must be pointer to null-terminated UTF-8 string.
// If the string is not valid UTF-8 the result is an `INVALID_ARGUMENT` error.
enum YRX_RESULT yrx_compiler_new_namespace(struct YRX_COMPILER *compiler,
                                           const char *namespace_);

// Defines a global variable of string type and sets its initial value.
enum YRX_RESULT yrx_compiler_define_global_str(struct YRX_COMPILER *compiler,
                                               const char *ident,
                                               const char *value);

// Defines a global variable of bool type and sets its initial value.
enum YRX_RESULT yrx_compiler_define_global_bool(struct YRX_COMPILER *compiler,
                                                const char *ident,
                                                bool value);

// Defines a global variable of integer type and sets its initial value.
enum YRX_RESULT yrx_compiler_define_global_int(struct YRX_COMPILER *compiler,
                                               const char *ident,
                                               int64_t value);

// Defines a global variable of float type and sets its initial value.
enum YRX_RESULT yrx_compiler_define_global_float(struct YRX_COMPILER *compiler,
                                                 const char *ident,
                                                 double value);

// Defines a global variable from a JSON-encoded string.
//
// This is best for complex types like maps and arrays. For simple types
// (e.g., booleans, integers, strings), prefer dedicated functions to avoid
// the overhead of JSON deserialization.
//
// When defining a map, keys must be of string type, and values can be
// any of the types supported by YARA, including other maps. Arrays must be
// homogeneous (all elements must be the same type).
enum YRX_RESULT yrx_compiler_define_global_json(struct YRX_COMPILER *compiler,
                                                const char *ident,
                                                const char *value);

// Returns the errors encountered during the compilation in JSON format.
//
// In the address indicated by the `buf` pointer, the function will copy a
// `YRX_BUFFER*` pointer. The `YRX_BUFFER` structure represents a buffer
// that contains the JSON representation of the compilation errors.
//
// The JSON consists on an array of objects, each object representing a
// compilation error. The object has the following fields:
//
// * type: A string that describes the type of error.
// * code: Error code (e.g: "E009").
// * title: Error title (e.g: "unknown identifier `foo`").
// * labels: Array of labels.
// * text: The full text of the error report, as shown by the command-line tool.
//
// Here is an example:
//
// ```json
// [
//     {
//         "type": "UnknownIdentifier",
//         "code": "E009",
//         "title": "unknown identifier `foo`",
//         "labels": [
//             {
//                 "level": "error",
//                 "code_origin": null,
//                 "span": {"start":25,"end":28},
//                 "text": "this identifier has not been declared"
//             }
//         ],
//         "text": "... <full report here> ..."
//     }
// ]
// ```
//
// The [`YRX_BUFFER`] must be destroyed with [`yrx_buffer_destroy`].
enum YRX_RESULT yrx_compiler_errors_json(struct YRX_COMPILER *compiler,
                                         struct YRX_BUFFER **buf);

// Returns the warnings encountered during the compilation in JSON format.
//
// In the address indicated by the `buf` pointer, the function will copy a
// `YRX_BUFFER*` pointer. The `YRX_BUFFER` structure represents a buffer
// that contains the JSON representation of the warnings.
//
// The JSON consists on an array of objects, each object representing a
// warning. The object has the following fields:
//
// * type: A string that describes the type of warning.
// * code: Warning code (e.g: "slow_pattern").
// * title: Error title (e.g: "slow pattern").
// * labels: Array of labels.
// * text: The full text of the warning report, as shown by the command-line tool.
//
// Here is an example:
//
// ```json
// [
//     {
//         "type": "SlowPattern",
//         "code": "slow_pattern",
//         "title": "slow pattern",
//         "labels": [
//             {
//                 "level": "warning",
//                 "code_origin": null,
//                 "span": {"start":25,"end":28},
//                 "text": "this pattern may slow down the scan"
//             }
//         ],
//         "text": "... <full report here> ..."
//     }
// ]
// ```
//
// The [`YRX_BUFFER`] must be destroyed with [`yrx_buffer_destroy`].
enum YRX_RESULT yrx_compiler_warnings_json(struct YRX_COMPILER *compiler,
                                           struct YRX_BUFFER **buf);

// Builds the source code previously added to the compiler.
//
// After calling this function the compiler is reset to its initial state,
// (i.e: the state it had after returning from yrx_compiler_create) you can
// keep using it by adding more sources and calling this function again.
struct YRX_RULES *yrx_compiler_build(struct YRX_COMPILER *compiler);

// Returns the name of the pattern represented by [`YRX_PATTERN`].
//
// Arguments `ident` and `len` are output parameters that receive pointers
// to a `const uint8_t*` and `size_t`, where this function will leave a pointer
// to the rule's name and its length, respectively. The rule's name is *NOT*
// null-terminated, and the pointer will be valid as long as the `YRX_RULES`
// object that contains the pattern is not freed. The name is guaranteed to be
// a valid UTF-8 string.
enum YRX_RESULT yrx_pattern_identifier(const struct YRX_PATTERN *pattern,
                                       const uint8_t **ident,
                                       size_t *len);

// Iterates over the matches of a pattern, calling the callback with a pointer
// to a [`YRX_MATCH`] structure for each pattern.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function.
//
// See [`YRX_MATCH_CALLBACK`] for more details.
enum YRX_RESULT yrx_pattern_iter_matches(const struct YRX_PATTERN *pattern,
                                         YRX_MATCH_CALLBACK callback,
                                         void *user_data);

// Returns the name of the rule represented by [`YRX_RULE`].
//
// Arguments `ident` and `len` are output parameters that receive pointers
// to a `const uint8_t*` and `size_t`, where this function will leave a pointer
// to the rule's name and its length, respectively. The rule's name is *NOT*
// null-terminated, and the pointer will be valid as long as the `YRX_RULES`
// object that contains the rule is not freed. The name is guaranteed to be a
// valid UTF-8 string.
enum YRX_RESULT yrx_rule_identifier(const struct YRX_RULE *rule,
                                    const uint8_t **ident,
                                    size_t *len);

// Returns the namespace of the rule represented by [`YRX_RULE`].
//
// Arguments `ns` and `len` are output parameters that receive pointers to a
// `const uint8_t*` and `size_t`, where this function will leave a pointer
// to the rule's namespace and its length, respectively. The namespace is *NOT*
// null-terminated, and the pointer will be valid as long as the `YRX_RULES`
// object that contains the rule is not freed. The namespace is guaranteed to
// be a valid UTF-8 string.
enum YRX_RESULT yrx_rule_namespace(const struct YRX_RULE *rule,
                                   const uint8_t **ns,
                                   size_t *len);

// Iterates over the metadata of a rule, calling the callback with a pointer
// to a [`YRX_METADATA`] structure for each metadata in the rule.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function.
//
// See [`YRX_METADATA_CALLBACK`] for more details.
enum YRX_RESULT yrx_rule_iter_metadata(const struct YRX_RULE *rule,
                                       YRX_METADATA_CALLBACK callback,
                                       void *user_data);

// Iterates over the patterns in a rule, calling the callback with a pointer
// to a [`YRX_PATTERN`] structure for each pattern.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function.
//
// See [`YRX_PATTERN_CALLBACK`] for more details.
enum YRX_RESULT yrx_rule_iter_patterns(const struct YRX_RULE *rule,
                                       YRX_PATTERN_CALLBACK callback,
                                       void *user_data);

// Iterates over the tags in a rule, calling the callback with a pointer
// to each tag.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function.
//
// See [`YRX_TAG_CALLBACK`] for more details.
enum YRX_RESULT yrx_rule_iter_tags(const struct YRX_RULE *rule,
                                   YRX_TAG_CALLBACK callback,
                                   void *user_data);

// Iterates over the compiled rules, calling the callback function for each
// rule.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function.
//
// See [`YRX_RULE_CALLBACK`] for more details.
enum YRX_RESULT yrx_rules_iter(const struct YRX_RULES *rules,
                               YRX_RULE_CALLBACK callback,
                               void *user_data);

// Returns the total number of rules.
//
// Returns -1 in case of error.
int yrx_rules_count(struct YRX_RULES *rules);

// Serializes the rules as a sequence of bytes.
//
// In the address indicated by the `buf` pointer, the function will copy a
// `YRX_BUFFER*` pointer. The `YRX_BUFFER` structure represents a buffer
// that contains the serialized rules. This structure has a pointer to the
// data itself, and its length.
//
// The [`YRX_BUFFER`] must be destroyed with `yrx_buffer_destroy`.
enum YRX_RESULT yrx_rules_serialize(const struct YRX_RULES *rules,
                                    struct YRX_BUFFER **buf);

// Deserializes the rules from a sequence of bytes produced by
// [`yrx_rules_serialize`].
enum YRX_RESULT yrx_rules_deserialize(const uint8_t *data,
                                      size_t len,
                                      struct YRX_RULES **rules);

// Iterates over the modules imported by the rules, calling the callback with
// the name of each imported module.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function.
//
// See [`YRX_IMPORT_CALLBACK`] for more details.
enum YRX_RESULT yrx_rules_iter_imports(const struct YRX_RULES *rules,
                                       YRX_IMPORT_CALLBACK callback,
                                       void *user_data);

// Destroys a [`YRX_RULES`] object.
void yrx_rules_destroy(struct YRX_RULES *rules);

// Creates a [`YRX_SCANNER`] object that can be used for scanning data with
// the provided [`YRX_RULES`].
//
// It's ok to pass the same [`YRX_RULES`] to multiple scanners, and use each
// scanner from a different thread. The scanner can be used as many times as
// you want, and it must be destroyed with [`yrx_scanner_destroy`]. Also, the
// scanner is valid as long as the rules are not destroyed, so, always destroy
// the [`YRX_SCANNER`] object before the [`YRX_RULES`] object.
enum YRX_RESULT yrx_scanner_create(const struct YRX_RULES *rules,
                                   struct YRX_SCANNER **scanner);

// Destroys a [`YRX_SCANNER`] object.
void yrx_scanner_destroy(struct YRX_SCANNER *scanner);

// Sets a timeout (in seconds) for scan operations.
//
// The scan functions will return a timeout error once the provided timeout
// duration has elapsed. The scanner will make every effort to stop promptly
// after the designated timeout duration. However, in some cases, particularly
// with rules containing only a few patterns, the scanner could potentially
// continue running for a longer period than the specified timeout.
enum YRX_RESULT yrx_scanner_set_timeout(struct YRX_SCANNER *scanner,
                                        uint64_t timeout);

// Scans a data buffer.
//
// `data` can be null as long as `len` is 0. In such cases its handled as
// empty data. Some YARA rules (i.e: `rule dummy { condition: true }`) can
// match even with empty data.
enum YRX_RESULT yrx_scanner_scan(struct YRX_SCANNER *scanner,
                                 const uint8_t *data,
                                 size_t len);

// Scans a file.
//
// This function is similar to `yrx_scanner_scan`, but it receives a file
// path instead of data to be scanned.
enum YRX_RESULT yrx_scanner_scan_file(struct YRX_SCANNER *scanner,
                                      const char *path);

// Scans a block of data.
//
// This function is designed for scenarios where the data to be scanned is not
// available as a single contiguous block of memory, but rather arrives in
// smaller, discrete blocks, allowing for incremental scanning.
//
// Each call to this function scans a block of data. The `base` argument
// specifies the offset of the current block within the overall data being
// scanned. In most cases you will want to call this function multiple times,
// providing a different block on each call.
//
// Once this function is called for a scanner, it enters block scanning mode
// and any subsequent call to [`yrx_scanner_scan`] will fail with
// [`YRX_RESULT::YRX_INVALID_STATE`]. Once the scanner is in block scanning
// mode it can be used in that mode only.
//
// When all blocks have been scanned, you must call [`yrx_scanner_finish`].
//
// # Limitations of Block Scanning
//
// Block scanning works by analyzing data in chunks rather than as a whole
// file. This makes it useful for streaming or memory-constrained scenarios,
// but it comes with important limitations compared to standard scanning:
//
// 1) Modules won't work. Parsers for structured formats (e.g., PE, ELF)
//    require access to the entire file and cannot be applied in block
//    scanning mode.
// 2) Other modules like `hash` won't work either, as they require access to
//    all the scanned data during the evaluation of the rule's condition,
//    something that can't be guaranteed in block scanning mode. The hash
//    functions will return `undefined` when used in a multi-block context.
// 3) Built-in functions like `uint8`, `uint16`, `uint32`, etc., have the
//    same limitation. They also return `undefined` in block scanning mode.
// 4) The `filesize` keyword returns `undefined` in block scanning mode.
// 5) Patterns won't match across block boundaries. Every match will be
//    completely contained within one of the blocks.
//
// All these limitations imply that in block scanning mode you should only
// use rules that rely on text, hex or regex patterns.
//
// # Data Consistency in Overlapping Blocks
//
// When [`yrx_scanner_scan_block`] is invoked multiple times with different
// blocks that may overlap, the user is responsible for ensuring data
// consistency. This means that if the same region of the original data is
// present in two or more overlapping blocks, the content of that region must
// be identical across all calls to `scan`.
//
// Generally speaking, the scanner does not verify this consistency and
// assumes the user provides accurate and consistent data. In debug releases
// the scanner may try to verify this consistency, but only when some pattern
// matches in the overlapping region.
enum YRX_RESULT yrx_scanner_scan_block(struct YRX_SCANNER *scanner,
                                       size_t base,
                                       const uint8_t *data,
                                       size_t len);

// Finalizes the scan of a set of memory blocks.
//
// This function must be used in conjunction with [`yrx_scanner_scan_block`]
// when scanning data in blocks. After all data blocks have been scanned, this
// functions evaluates the conditions of the YARA rules and produces the final
// scan results.
//
// After this function returns, the scanner is ready to be used again for
// scanning a new set of memory blocks. However, the scanner remains in block
// scanning mode and can't be used for normal scanning.
enum YRX_RESULT yrx_scanner_finish(struct YRX_SCANNER *scanner);

// Sets a callback function that is called by the scanner for each rule that
// matched during a scan.
//
// The `user_data` pointer can be used to provide additional context to your
// callback function. If the callback is not set, the scanner doesn't notify
// about matching rules.
//
// See [`YRX_RULE_CALLBACK`] for more details.
enum YRX_RESULT yrx_scanner_on_matching_rule(struct YRX_SCANNER *scanner,
                                             YRX_RULE_CALLBACK callback,
                                             void *user_data);

// Specifies the output data structure for a module.
//
// Each YARA module generates an output consisting of a data structure that
// contains information about the scanned file. This data structure is represented
// by a Protocol Buffer. Typically, you won't need to provide this output data
// yourself, as the YARA module automatically generates different outputs for
// each file it scans.
//
// However, there are two scenarios in which you may want to provide the output
// for a module yourself:
//
// 1) When the module does not produce any output on its own.
// 2) When you already know the output of the module for the upcoming file to
//    be scanned, and you prefer to reuse this data instead of generating it
//    again.
//
// Case 1) applies to certain modules lacking a main function, thus incapable of
// producing any output on their own. For such modules, you must set the output
// before scanning the associated data. Since the module's output typically varies
// with each scanned file, you need to call [yrx_scanner_set_module_output] prior
// to each invocation of [yrx_scanner_scan]. Once [yrx_scanner_scan] is executed,
// the module's output is consumed and will be empty unless set again before the
// subsequent call.
//
// Case 2) applies when you have previously stored the module's output for certain
// scanned data. In such cases, when rescanning the data, you can utilize this
// function to supply the module's output, thereby preventing redundant computation
// by the module. This optimization enhances performance by eliminating the need
// for the module to reparse the scanned data.
//
// The `name` argument is either a YARA module name (i.e: "pe", "elf", "dotnet",
// etc.) or the fully-qualified name of the protobuf message associated to
// the module. It must be a valid UTF-8 string.
//
// If the scanner is in block scanning mode this function returns `YRX_INVALID_STATE`.
enum YRX_RESULT yrx_scanner_set_module_output(struct YRX_SCANNER *scanner,
                                              const char *name,
                                              const uint8_t *data,
                                              size_t len);

// Specifies metadata for a module.
//
// Since the module's output typically varies with each scanned file, you need to
// call [yrx_scanner_set_module_data] prior to each invocation of
// [yrx_scanner_scan]. Once [yrx_scanner_scan] is executed, the module's metadata
// is consumed and will be empty unless set again before the subsequent call.
//
// The `name` argument is the name of a YARA module. It must be a valid UTF-8 string.
//
// The `name` as well as `data` must be valid from the time they are used as arguments
// of this function until the scan is executed.
//
// If the scanner is in block scanning mode this function returns `YRX_INVALID_STATE`.
enum YRX_RESULT yrx_scanner_set_module_data(struct YRX_SCANNER *scanner,
                                            const char *name,
                                            const uint8_t *data,
                                            size_t len);

// Sets the value of a global variable of type string.
enum YRX_RESULT yrx_scanner_set_global_str(struct YRX_SCANNER *scanner,
                                           const char *ident,
                                           const char *value);

// Sets the value of a global variable of type bool.
enum YRX_RESULT yrx_scanner_set_global_bool(struct YRX_SCANNER *scanner,
                                            const char *ident,
                                            bool value);

// Sets the value of a global variable of type int.
enum YRX_RESULT yrx_scanner_set_global_int(struct YRX_SCANNER *scanner,
                                           const char *ident,
                                           int64_t value);

// Sets the value of a global variable of type float.
enum YRX_RESULT yrx_scanner_set_global_float(struct YRX_SCANNER *scanner,
                                             const char *ident,
                                             double value);

// Sets the value of a global variable from a JSON-encoded string.
//
// This is best for complex types like maps and arrays. For simple types
// (e.g., booleans, integers, strings), prefer dedicated functions to avoid
// the overhead of JSON deserialization.
//
// The type of the JSON-encoded value must match the type of the variable
// as it was defined.
enum YRX_RESULT yrx_scanner_set_global_json(struct YRX_SCANNER *scanner,
                                            const char *ident,
                                            const char *value);

// Iterates over the slowest N rules, calling the callback for each rule.
//
// Requires the `rules-profiling` feature, otherwise returns
// `YRX_RESULT::NOT_SUPPORTED`.
//
// See [`YRX_SLOWEST_RULES_CALLBACK`] for more details.
enum YRX_RESULT yrx_scanner_iter_slowest_rules(struct YRX_SCANNER *scanner,
                                               size_t n,
                                               YRX_SLOWEST_RULES_CALLBACK callback,
                                               void *user_data);

// Clears all accumulated profiling data.
//
// This resets the profiling data collected during rule execution across
// scanned files. Use this to start a new profiling session, ensuring the
// results reflect only the data gathered after this method is called.
//
// Requires the `rules-profiling` feature, otherwise returns
// `YRX_RESULT::NOT_SUPPORTED`.
//
enum YRX_RESULT yrx_scanner_clear_profiling_data(struct YRX_SCANNER *scanner);

#endif  /* YARA_X */
