#!/bin/bash
PO=po/parcellite.pot
D=$(date +"%Y-%m-%d %H:%M%z")
if [ -e $PO ]; then
  echo "Overwrite $PO?"
  read YN
  if [ "$YN" != "y" ]; then
    echo "User Abort"
    exit 1
  fi
fi
if [ -n "$1" ]; then # assume we were passed in a revision number
  PV="$1"
else
  if [ -e Makefile ]; then
    PV=$( grep PACKAGE_VER Makefile|sed 's!.*= *!!')
  else
    PV="PACKAGE VERSION"
    echo "********WARNING $PV cannot be set until configure is run************"
  fi
fi
echo "#Generated by extract_strings">$PO
#echo "msgid \"\"" >>$PO
#echo "msgstr \"\"" >> $PO
echo "\"Project-Id-Version: $PV\n\"" >> $PO
echo "\"Report-Msgid-Bugs-To: \n\"" >> $PO
echo "\"POT-Creation-Date: $D\n\"" >> $PO
echo "\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\n\"" >> $PO
echo "\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\n\"" >> $PO
echo "\"Language-Team: LANGUAGE <LL@li.org>\n\"" >> $PO
echo "\"MIME-Version: 1.0\n\"" >> $PO
echo "\"Content-Type: text/plain; charset=CHARSET\n\"" >> $PO
echo "\"Content-Transfer-Encoding: 8bit\n\"" >> $PO
echo "">>$PO
# extraction from preferences.c
sed 's!\.desc!\n\.desc!;s!\.tip!\n\.tip!' src/preferences.c|grep '"' |grep "\.desc\|\.tip\|label\|dialog\|combo\|tooltip" |sed 's!.*"\(.*\)".*!\1!;s!^ *!!' > $PO.tmp

for f in main utils; do
  grep "_(" src/$f.c|sed 's!.*_("\(.*\)".*!\1!' >> $PO.tmp
done
#grab license
grep -A 10 license src/main.c|grep '  "'|sed 's! *!!;s!"!!g'|tr -d '\n' >> $PO.tmp
# Leave markups s!<.>!!;s!<..>!!;
cat $PO.tmp|sort|uniq|sed 's!^!msgid "!;s!$!"\nmsgstr ""\n!'>>$PO
#rm $PO.tmp

echo "Output in $PO"
