#ifndef ECA_SERIALCOMM_H
#define ECA_SERIALCOMM_H

#include "BaseCommunication.h"


class CSerialCommunication :
	public CBaseCommunication
{
public:
	CSerialCommunication(char *cDeviceName,CReader *Owner);
	virtual int Write(void *Message,uint32_t len);
	virtual int Read(void *Response,uint32_t *ResponseLen);
	virtual CBaseReader *BuildReaderObject(); 
	virtual void SetCommunicationString(cj_ReaderInfo *ReaderInfo);
	virtual bool IsConnected();

	virtual int Open();
	virtual void Close();


public:
	virtual ~CSerialCommunication(void);
	DWORD ReadThreadRoutine();
	DWORD SerialPollThreadRoutine(void);
private:
	virtual int StartInterruptPipe();
	virtual int HaltInterruptPipe();
	static DWORD __stdcall _ReadThreadRoutine(LPVOID ptr);
	static DWORD __stdcall _SerialPollThread(LPVOID ptr);
	int WriteAck(uint8_t Ack);


	void _Close();
private:
	HANDLE m_hDevice;
	OVERLAPPED m_olTransmit;
	OVERLAPPED m_olAck;
   OVERLAPPED m_r_over;

	HANDLE m_ReadPipeThread;
	HANDLE m_PollThread;
	HANDLE m_hAck;

	HANDLE m_hReadBufferSig;
	CRSCTCriticalSection m_CritReadBuffer;
	uint8_t rbuffer[1024];
	uint8_t *m_pReadBuffer;
	uint32_t m_ReadBufferSize;
	uint8_t m_AckByte;


};

#endif
