/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.fileformat;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.inbox.Inbox;
import org.openhab.core.config.discovery.inbox.InboxPredicates;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.items.fileconverter.ItemFileGenerator;
import org.openhab.core.thing.Bridge;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingFactory;
import org.openhab.core.thing.fileconverter.ThingFileGenerator;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkRegistry;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="file-format")
@Tag(name="file-format")
@Component
@JaxrsResource
@JaxrsName(value="file-format")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class FileFormatResource
implements RESTResource {
    public static final String PATH_FILE_FORMAT = "file-format";
    private static final String DSL_THINGS_EXAMPLE = "Bridge binding:typeBridge:idBridge \"Label bridge\" @ \"Location bridge\" [stringParam=\"my value\"] {\n    Thing type id \"Label thing\" @ \"Location thing\" [booleanParam=true, decimalParam=2.5]\n}\n";
    private static final String YAML_THINGS_EXAMPLE = "version: 2\nthings:\n  binding:typeBridge:idBridge:\n    isBridge: true\n    label: Label bridge\n    location: Location bridge\n    config:\n      stringParam: my value\n  binding:type:idBridge:id:\n    bridge: binding:typeBridge:idBridge\n    label: Label thing\n    location: Location thing\n    config:\n      booleanParam: true\n      decimalParam: 2.5\n";
    private static final String DSL_ITEMS_EXAMPLE = "Group Group1 \"Label\"\nGroup:Switch:OR(ON,OFF) Group2 \"Label\"\nSwitch MyItem \"Label\" <icon> (Group1, Group2) [Tag1, Tag2] { channel=\"binding:type:id:channelid\", namespace=\"my value\" [param=\"my param value\"] }\n";
    private static final String YAML_ITEMS_EXAMPLE = "version: 2\nitems:\n  Group1:\n    type: Group\n    label: Label\n  Group2:\n    type: Group\n    group:\n      type: Switch\n      function: Or\n      parameters:\n        - \"ON\"\n        - \"OFF\"\n    label: Label\n  MyItem:\n    type: Switch\n    label: Label\n    icon: icon\n    groups:\n      - Group1\n      - Group2\n    tags:\n      - Tag1\n      - Tag2\n    channel: binding:type:id:channelid\n    metadata:\n      namespace:\n        value: my value\n        config:\n          param: my param value\n";
    private final Logger logger = LoggerFactory.getLogger(FileFormatResource.class);
    private final ItemRegistry itemRegistry;
    private final MetadataRegistry metadataRegistry;
    private final ItemChannelLinkRegistry itemChannelLinkRegistry;
    private final ThingRegistry thingRegistry;
    private final Inbox inbox;
    private final ThingTypeRegistry thingTypeRegistry;
    private final ConfigDescriptionRegistry configDescRegistry;
    private final Map<String, ItemFileGenerator> itemFileGenerators = new ConcurrentHashMap<String, ItemFileGenerator>();
    private final Map<String, ThingFileGenerator> thingFileGenerators = new ConcurrentHashMap<String, ThingFileGenerator>();

    @Activate
    public FileFormatResource(@Reference ItemRegistry itemRegistry, @Reference MetadataRegistry metadataRegistry, @Reference ItemChannelLinkRegistry itemChannelLinkRegistry, @Reference ThingRegistry thingRegistry, @Reference Inbox inbox, @Reference ThingTypeRegistry thingTypeRegistry, @Reference ConfigDescriptionRegistry configDescRegistry) {
        this.itemRegistry = itemRegistry;
        this.metadataRegistry = metadataRegistry;
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
        this.thingRegistry = thingRegistry;
        this.inbox = inbox;
        this.thingTypeRegistry = thingTypeRegistry;
        this.configDescRegistry = configDescRegistry;
    }

    @Deactivate
    void deactivate() {
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void addItemFileGenerator(ItemFileGenerator itemFileGenerator) {
        this.itemFileGenerators.put(itemFileGenerator.getFileFormatGenerator(), itemFileGenerator);
    }

    protected void removeItemFileGenerator(ItemFileGenerator itemFileGenerator) {
        this.itemFileGenerators.remove(itemFileGenerator.getFileFormatGenerator());
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void addThingFileGenerator(ThingFileGenerator thingFileGenerator) {
        this.thingFileGenerators.put(thingFileGenerator.getFileFormatGenerator(), thingFileGenerator);
    }

    protected void removeThingFileGenerator(ThingFileGenerator thingFileGenerator) {
        this.thingFileGenerators.remove(thingFileGenerator.getFileFormatGenerator());
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Path(value="/items")
    @Consumes(value={"application/json"})
    @Produces(value={"text/vnd.openhab.dsl.item", "application/yaml"})
    @Operation(operationId="createFileFormatForItems", summary="Create file format for a list of items in registry.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/vnd.openhab.dsl.item", schema=@Schema(example="Group Group1 \"Label\"\nGroup:Switch:OR(ON,OFF) Group2 \"Label\"\nSwitch MyItem \"Label\" <icon> (Group1, Group2) [Tag1, Tag2] { channel=\"binding:type:id:channelid\", namespace=\"my value\" [param=\"my param value\"] }\n")), @Content(mediaType="application/yaml", schema=@Schema(example="version: 2\nitems:\n  Group1:\n    type: Group\n    label: Label\n  Group2:\n    type: Group\n    group:\n      type: Switch\n      function: Or\n      parameters:\n        - \"ON\"\n        - \"OFF\"\n    label: Label\n  MyItem:\n    type: Switch\n    label: Label\n    icon: icon\n    groups:\n      - Group1\n      - Group2\n    tags:\n      - Tag1\n      - Tag2\n    channel: binding:type:id:channelid\n    metadata:\n      namespace:\n        value: my value\n        config:\n          param: my param value\n"))}), @ApiResponse(responseCode="404", description="One or more items not found in registry."), @ApiResponse(responseCode="415", description="Unsupported media type.")})
    public Response createFileFormatForItems(@Context HttpHeaders httpHeaders, @DefaultValue(value="true") @QueryParam(value="hideDefaultParameters") @Parameter(description="hide the configuration parameters having the default value") boolean hideDefaultParameters, @Parameter(description="Array of item names. If empty or omitted, return all Items.") @Nullable List<String> itemNames) {
        List<Item> items;
        String acceptHeader = httpHeaders.getHeaderString("Accept");
        this.logger.debug("createFileFormatForItems: mediaType = {}, itemNames = {}", (Object)acceptHeader, itemNames);
        ItemFileGenerator generator = this.getItemFileGenerator(acceptHeader);
        if (generator == null) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)("Unsupported media type '" + acceptHeader + "'!")).build();
        }
        if (itemNames == null || itemNames.isEmpty()) {
            items = this.getAllItemsSorted();
        } else {
            items = new ArrayList<Item>();
            for (String itemname : itemNames) {
                Item item = (Item)this.itemRegistry.get((Object)itemname);
                if (item == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Item with name '" + itemname + "' not found in the items registry!")).build();
                }
                items.add(item);
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        generator.generateFileFormat((OutputStream)outputStream, items, this.getMetadata(items), hideDefaultParameters);
        return Response.ok((Object)new String(outputStream.toByteArray())).build();
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Path(value="/things")
    @Consumes(value={"application/json"})
    @Produces(value={"text/vnd.openhab.dsl.thing", "application/yaml"})
    @Operation(operationId="createFileFormatForThings", summary="Create file format for a list of things in things or discovery registry.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/vnd.openhab.dsl.thing", schema=@Schema(example="Bridge binding:typeBridge:idBridge \"Label bridge\" @ \"Location bridge\" [stringParam=\"my value\"] {\n    Thing type id \"Label thing\" @ \"Location thing\" [booleanParam=true, decimalParam=2.5]\n}\n")), @Content(mediaType="application/yaml", schema=@Schema(example="version: 2\nthings:\n  binding:typeBridge:idBridge:\n    isBridge: true\n    label: Label bridge\n    location: Location bridge\n    config:\n      stringParam: my value\n  binding:type:idBridge:id:\n    bridge: binding:typeBridge:idBridge\n    label: Label thing\n    location: Location thing\n    config:\n      booleanParam: true\n      decimalParam: 2.5\n"))}), @ApiResponse(responseCode="404", description="One or more things not found in registry."), @ApiResponse(responseCode="415", description="Unsupported media type.")})
    public Response createFileFormatForThings(@Context HttpHeaders httpHeaders, @DefaultValue(value="true") @QueryParam(value="hideDefaultParameters") @Parameter(description="hide the configuration parameters having the default value") boolean hideDefaultParameters, @Parameter(description="Array of Thing UIDs. If empty or omitted, return all Things from the Registry.") @Nullable List<String> thingUIDs) {
        List<Thing> things;
        String acceptHeader = httpHeaders.getHeaderString("Accept");
        this.logger.debug("createFileFormatForThings: mediaType = {}, thingUIDs = {}", (Object)acceptHeader, thingUIDs);
        ThingFileGenerator generator = this.getThingFileGenerator(acceptHeader);
        if (generator == null) {
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)("Unsupported media type '" + acceptHeader + "'!")).build();
        }
        if (thingUIDs == null || thingUIDs.isEmpty()) {
            things = this.getAllThingsSorted();
        } else {
            try {
                things = this.getThingsOrDiscoveryResult(thingUIDs);
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        generator.generateFileFormat((OutputStream)outputStream, things, hideDefaultParameters);
        return Response.ok((Object)new String(outputStream.toByteArray())).build();
    }

    private Collection<Metadata> getMetadata(Collection<Item> items) {
        ArrayList<Metadata> metadata = new ArrayList<Metadata>();
        for (Item item : items) {
            String itemName = item.getName();
            this.metadataRegistry.getAll().stream().filter(md -> md.getUID().getItemName().equals(itemName)).forEach(md -> metadata.add((Metadata)md));
            this.itemChannelLinkRegistry.getLinks(itemName).forEach(link -> {
                MetadataKey key = new MetadataKey("channel", itemName);
                Metadata md = new Metadata(key, link.getLinkedUID().getAsString(), link.getConfiguration().getProperties());
                metadata.add(md);
            });
        }
        return metadata;
    }

    private List<Item> getAllItemsSorted() {
        Collection items = this.itemRegistry.getAll();
        List<Item> groups = items.stream().filter(item -> item instanceof GroupItem).sorted((item1, item2) -> item1.getName().compareTo(item2.getName())).toList();
        List<Item> topGroups = groups.stream().filter(group -> group.getGroupNames().isEmpty()).sorted((group1, group2) -> group1.getName().compareTo(group2.getName())).toList();
        List<Item> groupTree = new ArrayList<Item>();
        for (Item group3 : topGroups) {
            this.fillGroupTree(groupTree, group3);
        }
        if (groupTree.size() != groups.size()) {
            this.logger.warn("Something went wrong when sorting groups; failback to a sort by name.");
            groupTree = groups;
        }
        List<Item> nonGroups = items.stream().filter(item -> !(item instanceof GroupItem)).sorted((item1, item2) -> {
            String thingUID2;
            Set channelLinks1 = this.itemChannelLinkRegistry.getLinks(item1.getName());
            String thingUID1 = channelLinks1.isEmpty() ? null : ((ItemChannelLink)channelLinks1.iterator().next()).getLinkedUID().getThingUID().getAsString();
            Set channelLinks2 = this.itemChannelLinkRegistry.getLinks(item2.getName());
            String string = thingUID2 = channelLinks2.isEmpty() ? null : ((ItemChannelLink)channelLinks2.iterator().next()).getLinkedUID().getThingUID().getAsString();
            if (thingUID1 == null && thingUID2 != null) {
                return -1;
            }
            if (thingUID1 != null && thingUID2 == null) {
                return 1;
            }
            if (thingUID1 != null && thingUID2 != null && !thingUID1.equals(thingUID2)) {
                return thingUID1.compareTo(thingUID2);
            }
            return item1.getName().compareTo(item2.getName());
        }).toList();
        return Stream.of(groupTree, nonGroups).flatMap(Collection::stream).toList();
    }

    private void fillGroupTree(List<Item> groups, Item item) {
        GroupItem group;
        if (item instanceof GroupItem && !groups.contains(group = (GroupItem)item)) {
            groups.add((Item)group);
            List members = group.getMembers().stream().sorted((member1, member2) -> member1.getName().compareTo(member2.getName())).toList();
            for (Item member : members) {
                this.fillGroupTree(groups, member);
            }
        }
    }

    private List<Thing> getAllThingsSorted() {
        Collection things = this.thingRegistry.getAll();
        ArrayList<Thing> thingTree = new ArrayList<Thing>();
        Set bindings = things.stream().map(thing -> thing.getUID().getBindingId()).collect(Collectors.toSet());
        for (String binding : bindings.stream().sorted().toList()) {
            List<Thing> topThings = things.stream().filter(thing -> thing.getUID().getBindingId().equals(binding) && thing.getBridgeUID() == null).sorted((thing1, thing2) -> thing1.getUID().getAsString().compareTo(thing2.getUID().getAsString())).toList();
            for (Thing thing3 : topThings) {
                this.fillThingTree(thingTree, thing3);
            }
        }
        return thingTree;
    }

    private void fillThingTree(List<Thing> things, Thing thing) {
        if (!things.contains(thing)) {
            things.add(thing);
            if (thing instanceof Bridge) {
                Bridge bridge = (Bridge)thing;
                List subThings = bridge.getThings().stream().sorted((thing1, thing2) -> thing1.getUID().getAsString().compareTo(thing2.getUID().getAsString())).toList();
                for (Thing subThing : subThings) {
                    this.fillThingTree(things, subThing);
                }
            }
        }
    }

    private Thing simulateThing(DiscoveryResult result, ThingType thingType) {
        ConfigDescription desc;
        HashMap<String, Object> configParams = new HashMap<String, Object>();
        List configDescriptionParameters = List.of();
        URI descURI = thingType.getConfigDescriptionURI();
        if (descURI != null && (desc = this.configDescRegistry.getConfigDescription(descURI)) != null) {
            configDescriptionParameters = desc.getParameters();
        }
        for (ConfigDescriptionParameter param : configDescriptionParameters) {
            Object normalizedValue;
            Object value = result.getProperties().get(param.getName());
            Object object = normalizedValue = value != null ? ConfigUtil.normalizeType(value, (ConfigDescriptionParameter)param) : null;
            if (normalizedValue == null) continue;
            configParams.put(param.getName(), normalizedValue);
        }
        Configuration config = new Configuration(configParams);
        return ThingFactory.createThing((ThingType)thingType, (ThingUID)result.getThingUID(), (Configuration)config, (ThingUID)result.getBridgeUID(), (ConfigDescriptionRegistry)this.configDescRegistry);
    }

    private @Nullable ItemFileGenerator getItemFileGenerator(String mediaType) {
        return switch (mediaType) {
            case "text/vnd.openhab.dsl.item" -> this.itemFileGenerators.get("DSL");
            case "application/yaml" -> this.itemFileGenerators.get("YAML");
            default -> null;
        };
    }

    private @Nullable ThingFileGenerator getThingFileGenerator(String mediaType) {
        return switch (mediaType) {
            case "text/vnd.openhab.dsl.thing" -> this.thingFileGenerators.get("DSL");
            case "application/yaml" -> this.thingFileGenerators.get("YAML");
            default -> null;
        };
    }

    private List<Thing> getThingsOrDiscoveryResult(List<String> thingUIDs) {
        return thingUIDs.stream().distinct().map(uid -> {
            ThingUID thingUID = new ThingUID(uid);
            Thing thing = this.thingRegistry.get(thingUID);
            if (thing != null) {
                return thing;
            }
            DiscoveryResult discoveryResult = (DiscoveryResult)this.inbox.stream().filter(InboxPredicates.forThingUID((ThingUID)thingUID)).findFirst().orElseThrow(() -> new IllegalArgumentException("Thing with UID '" + uid + "' not found in the things or discovery registry!"));
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
            if (thingType == null) {
                throw new IllegalArgumentException("Thing type with UID '" + String.valueOf(thingTypeUID) + "' does not exist!");
            }
            return this.simulateThing(discoveryResult, thingType);
        }).toList();
    }
}

