## RabbitMQ 4.1.1

RabbitMQ `4.1.1` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).


### Core Server

#### Enhancements

 * [Default queue type](https://www.rabbitmq.com/docs/vhosts#default-queue-type) is now injected into virtual host metadata when the virtual host
   is created.

   This seemingly subtle change elimiantes confusing inconsistencies between different
   definition export methods and scenarios.

   GitHub issue: [#13854](https://github.com/rabbitmq/rabbitmq-server/pull/13854)

 * Empty classic queues init faster after a clean shutdown.

   GitHub issue: [#13870](https://github.com/rabbitmq/rabbitmq-server/pull/13870)


#### Bug Fixes

 * Classic queue message store compaction could fall behind (not be able to keep up with)
   very busy publishers.

   GitHub issue: [#13987](https://github.com/rabbitmq/rabbitmq-server/pull/13987)

 * Classic queue message store could run into a rare exception
   when a message was routed to multiple queues.

   GitHub issue: [#13758](https://github.com/rabbitmq/rabbitmq-server/issues/13758)

 * Quorum queue commit map operation order was Erlang-version specific,
   potentially leading to confusing inconsistencies between replica behaviors.

   GitHub issue: [#14025](https://github.com/rabbitmq/rabbitmq-server/pull/14025)

 * Quorum queue failed to recover from a rare timeout during cluster formation.

   GitHub issue: [#13828](https://github.com/rabbitmq/rabbitmq-server/issues/13828)

 * RabbitMQ could fail to log certain client connection errors for TLS-enabled
   listeners.

   GitHub issue: [#13985](https://github.com/rabbitmq/rabbitmq-server/pull/13985)

 * Private key password could appear in certain exceptions at (failed) node boot time.

   GitHub issue: [#13999](https://github.com/rabbitmq/rabbitmq-server/pull/13999), [#14028](https://github.com/rabbitmq/rabbitmq-server/pull/14028)


### MQTT Plugin

#### Bug Fixes

 * When an MQTTv5 client that had a QoS 0 subscription is closed, the
   transient queue that was backing it will now be deleted.

   GitHub issue: [#14006](https://github.com/rabbitmq/rabbitmq-server/pull/14006)


### Stream Plugin

#### Bug Fixes

 * Stream producer could run into an exception (`accept_chunk_out_of_order`) when a publishing filter
   was enabled.

   GitHub issue: [#13897](https://github.com/rabbitmq/rabbitmq-server/issues/13897)

 * Stream [SAC](https://www.rabbitmq.com/docs/streams#single-active-consumer) coordinator failed when a super stream consumer was added next to
   a SAC consumer.

   GitHub issue: [#13835](https://github.com/rabbitmq/rabbitmq-server/issues/13835)


### CLI Tools

#### Enhancements

 * `rabbitmq-queues force_checkpoint [--vhost-pattern <pattern>] [--queue-pattern <pattern>]`
   is a new command that forces a group of quorum queues to take a checkpoint and
   delete its on disk segment files, where possible.

   GitHub issue: [#13938](https://github.com/rabbitmq/rabbitmq-server/pull/13938)


### Management Plugin

#### Enhancements

 * A separate chain for authentication and authorization backends now can be used
   used exclusively for the HTTP API and the management UI.

   GitHub issue: [#13819](https://github.com/rabbitmq/rabbitmq-server/pull/13819)

 * Reduced memory footprint of the plugin for certain workloads.

   GitHub issue: [#13900](https://github.com/rabbitmq/rabbitmq-server/pull/13900)

 * When UI session expires, the user is redirected to the login page.

   GitHub issue: [#13975](https://github.com/rabbitmq/rabbitmq-server/pull/13975)

 * `GET /api/health/checks/below-node-connection-limit` is a new health check
   that responds a 200 OK if the target node has fewer connections to the AMQP
   and AMQPS ports than the configured maximum.

   GitHub issue: [#13782](https://github.com/rabbitmq/rabbitmq-server/issues/13782)

 * `GET /api/health/checks/ready-to-serve-clients` is a new health check
   that responds a 200 OK if the target node is ready to serve clients
   (booted, not above the connection limit, not in [maintenance mode](https://www.rabbitmq.com/docs/upgrade#maintenance-mode)).

   GitHub issue: [#13782](https://github.com/rabbitmq/rabbitmq-server/issues/13782)

 * Protocol listener health check now supports comma-separated lists of
   protocol names.

   GitHub issue: [#13874](https://github.com/rabbitmq/rabbitmq-server/pull/13874)

 * New page for declaring super streams (partitioned streams).

   GitHub issue: [#13852](https://github.com/rabbitmq/rabbitmq-server/pull/13852)


### OAuth 2 Plugin

#### Enhancements

 * Select variables now can be used in scopes, for example: `"rabbitmq.write:*/x-{vhost}-*/u-{sub}-*"`

   GitHub issue: [#14008](https://github.com/rabbitmq/rabbitmq-server/pull/14008)


### Shovel Plugin

#### Bug Fixes

 * Shovels could fail to convert messages published by an AMQP 0-9-1
   client to AMQP 1.0 if the headers had a complex structure.

   GitHub issue: [#13801](https://github.com/rabbitmq/rabbitmq-server/pull/13801)


### Dependency Changes

 * `ra` was updated to [`2.16.9`](https://github.com/rabbitmq/ra/releases)
 * `osiris` was updated to [`1.8.8`](https://github.com/rabbitmq/osiris/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.1.1.tar.xz`
instead of the source tarball produced by GitHub.
