/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.gcalc.calc.PluginListReader;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.calc.main.DuplicatePluginException;

class PluginList
extends JPanel {
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;

    public PluginList() {
        super(new BorderLayout());
        try {
            this.init();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setMinimumSize(new Dimension(dim.width / 2, dim.height / 2));
    }

    private void init() throws IOException, ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        PluginListReader plh = new PluginListReader(cl);
        DefaultMutableTreeNode top = null;
        try {
            top = plh.getTreeRoot(cl.getResourceAsStream("pluginlist.xml"));
        }
        catch (Exception e) {
            SwingGUI.popupFatalError("Error reading builtin plugin list.\n(" + e.getMessage() + ")", 2);
        }
        this.root = new DefaultMutableTreeNode("Plugins");
        this.root.add(top);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        DefaultMutableTreeNode node = top;
        while (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        node = (DefaultMutableTreeNode)node.getParent();
        this.tree.expandPath(new TreePath(node.getPath()));
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = PluginList.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = PluginList.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    PluginList.this.doubleClicked(selPath);
                }
            }
        };
        this.tree.addMouseListener(ml);
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.tree.addTreeSelectionListener(l);
        this.tree.addSelectionRow(1);
    }

    private void doubleClicked(TreePath selPath) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        if (node.getUserObject() instanceof AbstractPlugin) {
            this.openSelectedPlugin();
        }
    }

    public void openSelectedPlugin() {
        AbstractPlugin dp = this.getSelectedPlugin();
        if (!dp.isInitialized()) {
            dp.init();
        }
        dp.setVisible(true);
    }

    private AbstractPlugin getSelectedPlugin() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        AbstractPlugin dp = (AbstractPlugin)node.getUserObject();
        return dp;
    }

    private Vector getPluginNodes(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        Vector<DefaultMutableTreeNode> list = new Vector<DefaultMutableTreeNode>();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!node.isLeaf()) continue;
            list.add(node);
        }
        return list;
    }

    public void graftBranch(DefaultMutableTreeNode node) throws DuplicatePluginException {
        int badplugin = 0;
        Vector existingNodes = this.getPluginNodes(this.root);
        Vector newNodes = this.getPluginNodes(node);
        int i = 0;
        while (i < existingNodes.size()) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)existingNodes.elementAt(i);
            int j = 0;
            while (j < newNodes.size()) {
                DefaultMutableTreeNode iternode = (DefaultMutableTreeNode)newNodes.elementAt(j);
                if (nd.getUserObject().equals(iternode.getUserObject())) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)iternode.getParent();
                    DefaultMutableTreeNode grandparent = null;
                    iternode.removeFromParent();
                    ++badplugin;
                    while (parent != null && parent.getChildCount() == 0) {
                        grandparent = (DefaultMutableTreeNode)parent.getParent();
                        parent.removeFromParent();
                        parent = grandparent;
                    }
                    System.out.println(iternode);
                }
                ++j;
            }
            ++i;
        }
        if (!node.isLeaf()) {
            this.treeModel.insertNodeInto(node, this.root, this.root.getChildCount());
        }
        if (badplugin > 0) {
            throw new DuplicatePluginException(String.valueOf(badplugin) + "/" + newNodes.size() + " plugin(s) ignored.");
        }
    }
}

