/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.BooleanOperation;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.parser.BadSyntaxRuntimeException;
import net.gcalc.calc.parser.ParseTree;

public class Case
extends Function {
    public Case(ParseTree pt) {
        super(pt);
        this.convertArgumentsToFunction();
        int numberOfArgs = this.getNumberOfArgs();
        if (numberOfArgs < 2) {
            throw new BadSyntaxRuntimeException("Not enough arguments for case");
        }
        int i = 0;
        while (i < numberOfArgs - 1) {
            if (!(this.getArg(i) instanceof BooleanOperation)) {
                throw new BadSyntaxRuntimeException("Malformed case function.");
            }
            i += 2;
        }
    }

    public Function derivative(Vector vars) {
        return NOT_A_NUMBER;
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        int numberOfArgs = this.getNumberOfArgs();
        int i = 0;
        while (i < numberOfArgs - 1) {
            BooleanOperation boolOp = (BooleanOperation)this.getArg(i);
            if (BooleanOperation.getBooleanValue(boolOp.evaluate(st, vt))) {
                return ((Function)this.getArg(i + 1)).evaluate(st, vt);
            }
            i += 2;
        }
        if (numberOfArgs % 2 == 0) {
            return Double.NaN;
        }
        return ((Function)this.getArg(numberOfArgs - 1)).evaluate(st, vt);
    }
}

