/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.gcalc.calc.math.FileFormatException;
import net.gcalc.calc.math.functions.Constant;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.Variable;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.BadSyntaxRuntimeException;
import net.gcalc.calc.parser.CalcParser;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;

public class FunctionFactory {
    private static Hashtable operationClasses = null;
    private static final String PACKAGE_NAME = "net.gcalc.calc.math.functions";
    private static final boolean CACHE = true;
    private static Hashtable cachedFunctions = new Hashtable();
    private static Vector functionNames;
    private static Vector operationNames;

    public static boolean isFunctionName(String s) {
        if (functionNames == null) {
            FunctionFactory.init();
        }
        return functionNames.contains(s);
    }

    private static synchronized void init() {
        ClassLoader cl = new FunctionFactory().getClass().getClassLoader();
        functionNames = new Vector();
        operationNames = new Vector();
        operationClasses = new Hashtable();
        String s = null;
        String opname = null;
        String classname = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream("resources/function_list.txt")));
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.charAt(0) == '#') continue;
                StringTokenizer st = new StringTokenizer(s);
                if (st.countTokens() != 2) {
                    throw new FileFormatException();
                }
                opname = st.nextToken();
                classname = "net.gcalc.calc.math.functions." + st.nextToken();
                operationClasses.put(opname, Class.forName(classname));
                if (opname.toLowerCase().equals(opname.toUpperCase())) {
                    operationNames.add(opname);
                    continue;
                }
                functionNames.add(opname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Function getFunction(double x) throws BadSyntaxRuntimeException {
        return FunctionFactory.getFunction(new Constant(x));
    }

    public static Function getFunction(ParseTree pt) throws BadSyntaxRuntimeException {
        if (operationClasses == null) {
            FunctionFactory.init();
        }
        if (pt instanceof Function) {
            return (Function)pt;
        }
        if (cachedFunctions.containsKey(pt)) {
            return (Function)cachedFunctions.get(pt);
        }
        Function F = null;
        if (pt.getRoot().isConstant()) {
            F = new Constant(pt);
        } else if (pt.getRoot().isVariable()) {
            F = new Variable(pt);
        } else {
            try {
                Class C = (Class)operationClasses.get(pt.getRoot().getName());
                F = (Function)C.getConstructors()[0].newInstance(pt);
            }
            catch (InstantiationException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof BadSyntaxRuntimeException) {
                    throw (BadSyntaxRuntimeException)cause;
                }
                System.err.println(cause);
                cause.printStackTrace();
            }
        }
        cachedFunctions.put(pt, F);
        return F;
    }

    public static Function getFunction(String infix) throws BadSyntaxException {
        ParseTree pt = CalcParser.parse(infix);
        pt = ParseTree.removeUnnecessarySemiColon(pt);
        Function f = FunctionFactory.getFunction(pt);
        f.setID(infix);
        return f;
    }

    public static Function getFunction(Token constant) {
        return FunctionFactory.getFunction(new ParseTree(constant));
    }

    public static Function getFunction(Token tk, Function x1) {
        Vector<Function> v = new Vector<Function>(1);
        v.add(x1);
        return FunctionFactory.getFunction(tk, v);
    }

    public static Function getFunction(Token tk, Function x1, Function x2) {
        Vector<Function> v = new Vector<Function>(1);
        v.add(x1);
        v.add(x2);
        return FunctionFactory.getFunction(tk, v);
    }

    public static Function getFunction(Token tk, Vector v) {
        return FunctionFactory.getFunction(new ParseTree(tk, v));
    }

    protected FunctionFactory() {
    }
}

