/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import net.gcalc.calc.math.functions.BooleanOperation;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianInequalityGraph;
import net.gcalc.plugin.plane.gui.FlagPanel;

public class InequalitiesPlugin
extends CartesianGraphPlugin {
    public InequalitiesPlugin() {
        this.graph = new CartesianInequalityGraph(this);
    }

    protected Color firstColor() {
        return Color.gray;
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.graph.getProperties());
    }

    protected InputPanel getInputPanel() {
        return new TextInputPanel("Inequality", new String[]{""}, null);
    }

    public String getDescription() {
        return "<p>Graphs inequalities involving x and y.</p>";
    }

    public String getPluginName() {
        return "Inequalities Plugin";
    }

    protected String[] getModelLabels() {
        return null;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String s = this.ip.getValues()[0].trim();
            Function f = null;
            try {
                f = FunctionFactory.getFunction(s);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s + "'!\n" + e.getMessage(), 0);
                return;
            }
            if (f != null) {
                if (f instanceof BooleanOperation) {
                    this.drawGraph(f, s);
                    this.statusBar.setText("Graphing: " + s);
                } else {
                    this.popupMessageDialog("This plugin only graphs inequalities or boolean functions!", 0);
                }
            }
        }
    }
}

