/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Image;
import java.awt.image.BufferedImage;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.SymbolTableException;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.ParametricGraph;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;

public class PolarGraph
extends ParametricGraph {
    private SymbolTable st;
    private Function x;
    private Function y;

    public PolarGraph(AbstractCartesianGraphPlugin plugin) {
        super(plugin);
        this.getProperties().put(GraphProperties.V_TITLE_STRING, "y");
        this.st = new SymbolTable();
        try {
            this.x = FunctionFactory.getFunction("cos(t)*r");
            this.y = FunctionFactory.getFunction("sin(t)*r");
        }
        catch (BadSyntaxException badSyntaxException) {
            // empty catch block
        }
    }

    public void setDefaultGraphElements() {
        boolean b = true;
        this.properties.initDefault(GraphProperties.H_AXIS, b);
        this.properties.initDefault(GraphProperties.H_GRID, !b);
        this.properties.initDefault(GraphProperties.H_SCALE, !b);
        this.properties.initDefault(GraphProperties.V_AXIS, b);
        this.properties.initDefault(GraphProperties.V_GRID, !b);
        this.properties.initDefault(GraphProperties.V_SCALE, !b);
        this.properties.initDefault(GraphProperties.V_TITLE, b);
        this.properties.initDefault(GraphProperties.H_TITLE, b);
        this.properties.initDefault(GraphProperties.V_LABEL, b);
        this.properties.initDefault(GraphProperties.H_LABEL, b);
        this.properties.initDefault(GraphProperties.INTERACTIVE_ZOOM, b);
    }

    protected void draw(RenderableModel model) {
        BufferedImage buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        Function r = model.getFunction(0);
        try {
            this.st.setVariable(VariableToken.R_VAR, r);
        }
        catch (SymbolTableException e) {
            System.err.println(e);
            return;
        }
        Range T = this.properties.getViewProperty(GraphProperties.VIEW).getRange(2);
        this.draw(this.x, this.y, T, model.getColor(), buffer.getGraphics(), this.st);
        this.gr.drawImage((Image)buffer, 0, 0, null);
        model.setImage(buffer);
    }
}

