/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.gui;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.gcalc.plugin.plane.gui.BooleanPropertyAction;
import net.gcalc.plugin.properties.GraphProperties;

public class FlagPanel
extends JPanel {
    private GraphProperties properties;

    public FlagPanel(GraphProperties gp) {
        this(gp, 5, 2, new String[]{GraphProperties.H_GRID, GraphProperties.V_GRID, GraphProperties.H_AXIS, GraphProperties.V_AXIS, GraphProperties.H_LABEL, GraphProperties.V_LABEL, GraphProperties.H_SCALE, GraphProperties.V_SCALE, GraphProperties.H_TITLE, GraphProperties.V_TITLE});
    }

    public FlagPanel(GraphProperties gp, int row, int col, String[] keys) {
        super(new GridLayout(row, col));
        this.properties = gp;
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != null) {
                this.add(this.makeCheckBox(this.getLabelString(keys[i]), keys[i]));
            } else {
                this.add(new JPanel());
            }
            ++i;
        }
    }

    private JCheckBox makeCheckBox(String title, String key) {
        JCheckBox cb = new JCheckBox(new BooleanPropertyAction(title, this.properties, key));
        cb.setSelected(this.properties.getBooleanProperty(key));
        return cb;
    }

    public String getLabelString(String key) {
        if (key.equals(GraphProperties.TRACE)) {
            return "Trace";
        }
        if (key.equals(GraphProperties.THICK_GRAPH)) {
            return "Thick Graph";
        }
        if (key.equals(GraphProperties.H_GRID)) {
            return "H Grid";
        }
        if (key.equals(GraphProperties.H_AXIS)) {
            return "H Axis";
        }
        if (key.equals(GraphProperties.H_LABEL)) {
            return "H Label";
        }
        if (key.equals(GraphProperties.H_SCALE)) {
            return "H Scale";
        }
        if (key.equals(GraphProperties.H_TITLE)) {
            return "H Title";
        }
        if (key.equals(GraphProperties.V_GRID)) {
            return "V Grid";
        }
        if (key.equals(GraphProperties.V_AXIS)) {
            return "V Axis";
        }
        if (key.equals(GraphProperties.V_LABEL)) {
            return "V Label";
        }
        if (key.equals(GraphProperties.V_SCALE)) {
            return "V Scale";
        }
        if (key.equals(GraphProperties.V_TITLE)) {
            return "V Title";
        }
        if (key.equals(GraphProperties.SHOW_CONCAVITY)) {
            return "Concavity";
        }
        if (key.equals(GraphProperties.SHOW_MONOTONICITY)) {
            return "Monotonicity";
        }
        return "";
    }
}

