/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.example;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.proto.plugin.example.Problem;
import net.gcalc.proto.plugin.example.SmallIntegerAdditionProblem;

public class ArithmeticDrillPlugin
extends AbstractPlugin
implements ActionListener {
    private JLabel problemLabel = new JLabel("    ", 0);
    private JTextField input = new JTextField(20);
    private Problem currentProblem;

    public void init() {
        this.getContentPane().add((Component)this.problemLabel, "Center");
        this.getContentPane().add((Component)this.input, "South");
        this.problemLabel.setFont(new Font("Serif", 0, 45));
        this.setSize(400, 300);
        this.setVisible(true);
        this.input.addActionListener(this);
        this.newProblem();
    }

    public String getCreatorName() {
        return "Jiho Kim (jiho@gcalc.net)";
    }

    public String getDescription() {
        return "<p>Drills students on arithmetic problems.</p>";
    }

    public String getPluginName() {
        return "Arithmetic Drill";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.input) {
            return;
        }
        String ans = this.input.getText();
        boolean correct = this.currentProblem.checkAnswer(ans);
        if (correct) {
            this.newProblem();
        }
    }

    private void newProblem() {
        this.currentProblem = this.createNewProblem();
        this.problemLabel.setText(this.currentProblem.getStatement());
        this.input.setText("");
        this.input.requestFocus();
    }

    private Problem createNewProblem() {
        return SmallIntegerAdditionProblem.getNewProblem();
    }
}

