/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.jstestdriver.HeartBeat;
import com.google.jstestdriver.HeartBeatManager;
import com.google.jstestdriver.util.StopWatch;
import java.util.Timer;
import java.util.TimerTask;

public class SimpleHeartBeatManager
implements HeartBeatManager {
    private Timer timer;
    private final StopWatch stopWatch;

    @Inject
    public SimpleHeartBeatManager(StopWatch stopWatch) {
        this.stopWatch = stopWatch;
    }

    public void startTimer() {
        this.stopWatch.start("start timer", new Object[0]);
        this.timer = new Timer(true);
        this.stopWatch.stop("start timer", new Object[0]);
    }

    public void cancelTimer() {
        this.stopWatch.start("stop timer", new Object[0]);
        this.timer.cancel();
        this.stopWatch.stop("stop timer", new Object[0]);
    }

    public void startHeartBeat(String baseUrl, String browserId, String sessionId) {
        this.stopWatch.start("start heartbeat", new Object[0]);
        this.timer.schedule((TimerTask)new HeartBeat(baseUrl + "/fileSet?id=" + browserId + "&sessionId=" + sessionId), 0L, 500L);
        this.stopWatch.stop("start heartbeat", new Object[0]);
    }
}

