/* doc.c was originally generated by the autoSql program, which also 
 * generated doc.h and doc.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "output/doc.h"


void addressBookStaticLoad(char **row, struct addressBook *ret)
/* Load a row from addressBook table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->address = row[1];
ret->city = row[2];
ret->zipCode = sqlUnsigned(row[3]);
safecpy(ret->state, sizeof(ret->state), row[4]);
}

struct addressBook *addressBookLoad(char **row)
/* Load a addressBook from row fetched with select * from addressBook
 * from database.  Dispose of this with addressBookFree(). */
{
struct addressBook *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->address = cloneString(row[1]);
ret->city = cloneString(row[2]);
ret->zipCode = sqlUnsigned(row[3]);
safecpy(ret->state, sizeof(ret->state), row[4]);
return ret;
}

struct addressBook *addressBookLoadAll(char *fileName) 
/* Load all addressBook from a whitespace-separated file.
 * Dispose of this with addressBookFreeList(). */
{
struct addressBook *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = addressBookLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct addressBook *addressBookLoadAllByChar(char *fileName, char chopper) 
/* Load all addressBook from a chopper separated file.
 * Dispose of this with addressBookFreeList(). */
{
struct addressBook *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = addressBookLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct addressBook *addressBookCommaIn(char **pS, struct addressBook *ret)
/* Create a addressBook out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new addressBook */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->address = sqlStringComma(&s);
ret->city = sqlStringComma(&s);
ret->zipCode = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->state, sizeof(ret->state));
*pS = s;
return ret;
}

void addressBookFree(struct addressBook **pEl)
/* Free a single dynamically allocated addressBook such as created
 * with addressBookLoad(). */
{
struct addressBook *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->address);
freeMem(el->city);
freez(pEl);
}

void addressBookFreeList(struct addressBook **pList)
/* Free a list of dynamically allocated addressBook's */
{
struct addressBook *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    addressBookFree(&el);
    }
*pList = NULL;
}

void addressBookOutput(struct addressBook *el, FILE *f, char sep, char lastSep) 
/* Print out addressBook.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->address);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->city);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->zipCode);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->state);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void addressBookJsonOutput(struct addressBook *el, FILE *f) 
/* Print out addressBook in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"name");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->name);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"address");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->address);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"city");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->city);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"zipCode");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->zipCode);
fputc(',',f);
fputc('"',f);
fprintf(f,"state");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->state);
fputc('"',f);
fputc('}',f);
}

/* definitions for sex column */
static char *values_sex[] = {"male", "female", NULL};
static struct hash *valhash_sex = NULL;

/* definitions for skills column */
static char *values_skills[] = {"cProg", "javaProg", "pythonProg", "awkProg", NULL};
static struct hash *valhash_skills = NULL;

void symbolColsStaticLoad(char **row, struct symbolCols *ret)
/* Load a row from symbolCols table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlSigned(row[0]);
ret->sex = sqlEnumParse(row[1], values_sex, &valhash_sex);
ret->skills = sqlSetParse(row[2], values_skills, &valhash_skills);
}

struct symbolCols *symbolColsLoad(char **row)
/* Load a symbolCols from row fetched with select * from symbolCols
 * from database.  Dispose of this with symbolColsFree(). */
{
struct symbolCols *ret;

AllocVar(ret);
ret->id = sqlSigned(row[0]);
ret->sex = sqlEnumParse(row[1], values_sex, &valhash_sex);
ret->skills = sqlSetParse(row[2], values_skills, &valhash_skills);
return ret;
}

struct symbolCols *symbolColsLoadAll(char *fileName) 
/* Load all symbolCols from a whitespace-separated file.
 * Dispose of this with symbolColsFreeList(). */
{
struct symbolCols *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = symbolColsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct symbolCols *symbolColsLoadAllByChar(char *fileName, char chopper) 
/* Load all symbolCols from a chopper separated file.
 * Dispose of this with symbolColsFreeList(). */
{
struct symbolCols *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = symbolColsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct symbolCols *symbolColsCommaIn(char **pS, struct symbolCols *ret)
/* Create a symbolCols out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new symbolCols */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlSignedComma(&s);
ret->sex = sqlEnumComma(&s, values_sex, &valhash_sex);
ret->skills = sqlSetComma(&s, values_skills, &valhash_skills);
*pS = s;
return ret;
}

void symbolColsFree(struct symbolCols **pEl)
/* Free a single dynamically allocated symbolCols such as created
 * with symbolColsLoad(). */
{
struct symbolCols *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void symbolColsFreeList(struct symbolCols **pList)
/* Free a list of dynamically allocated symbolCols's */
{
struct symbolCols *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    symbolColsFree(&el);
    }
*pList = NULL;
}

void symbolColsOutput(struct symbolCols *el, FILE *f, char sep, char lastSep) 
/* Print out symbolCols.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->sex, values_sex);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlSetPrint(f, el->skills, values_skills);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void symbolColsJsonOutput(struct symbolCols *el, FILE *f) 
/* Print out symbolCols in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"id");
fputc('"',f);
fputc(':',f);
fprintf(f, "%d", el->id);
fputc(',',f);
fputc('"',f);
fprintf(f,"sex");
fputc('"',f);
fputc(':',f);
fputc('"',f);
sqlEnumPrint(f, el->sex, values_sex);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"skills");
fputc('"',f);
fputc(':',f);
fputc('"',f);
sqlSetPrint(f, el->skills, values_skills);
fputc('"',f);
fputc('}',f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

