/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.Version;
import org.mortbay.http.ajp.AJP13InputStream;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.ajp.AJP13OutputStream;
import org.mortbay.http.ajp.AJP13RequestPacket;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;

public class AJP13Connection
extends HttpConnection {
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener listener, InputStream in, OutputStream out, Socket socket, int bufferSize) throws IOException {
        super(listener, null, new AJP13InputStream(in, out, bufferSize), out, socket);
        LineInput lin = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lin.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getFilterStream(), bufferSize);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut, true);
        this._listener = listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleNext() {
        AJP13RequestPacket packet = null;
        HttpRequest request = this.getRequest();
        HttpResponse response = this.getResponse();
        HttpContext context = null;
        boolean gotRequest = false;
        this._persistent = true;
        this._keepAlive = true;
        try {
            packet = null;
            packet = this._ajpIn.nextPacket();
            if (packet == null) {
                boolean bl = false;
                return bl;
            }
            if (packet.getDataSize() == 0) {
                boolean e2 = true;
                return e2;
            }
        }
        catch (IOException e) {
            Code.ignore(e);
            boolean e2 = false;
            return e2;
        }
        {
            byte type = packet.getByte();
            if (Code.debug()) {
                Code.debug("AJP13 type=" + type + " size=" + packet.unconsumedData());
            }
            switch (type) {
                case 2: {
                    request.setTimeStamp(System.currentTimeMillis());
                    request.setState(0);
                    request.setMethod(packet.getMethod());
                    request.setVersion(packet.getString());
                    request.setPath(packet.getString());
                    this._remoteAddr = packet.getString();
                    this._remoteHost = packet.getString();
                    this._serverName = packet.getString();
                    this._serverPort = packet.getInt();
                    this._isSSL = packet.getBoolean();
                    this._keepAlive = request.getDotVersion() >= 1;
                    int h = packet.getInt();
                    int i = 0;
                    while (i < h) {
                        String hdr = packet.getHeader();
                        String val = packet.getString();
                        request.setField(hdr, val);
                        if (!this._keepAlive && hdr.equalsIgnoreCase("Connection") && val.equalsIgnoreCase("keep-alive")) {
                            this._keepAlive = true;
                        }
                        ++i;
                    }
                    byte attr = packet.getByte();
                    while ((0xFF & attr) != 255) {
                        String value = packet.getString();
                        switch (attr) {
                            case 10: {
                                request.setAttribute(value, packet.getString());
                                break;
                            }
                            case 9: {
                                break;
                            }
                            case 8: {
                                request.setAttribute("javax.servlet.request.cipher_suite", value);
                                break;
                            }
                            case 7: {
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                ByteArrayInputStream certstream = new ByteArrayInputStream(value.getBytes());
                                X509Certificate cert = (X509Certificate)cf.generateCertificate(certstream);
                                X509Certificate[] certs = new X509Certificate[]{cert};
                                request.setAttribute("javax.servlet.request.X509Certificate", certs);
                                break;
                            }
                            case 6: {
                                request.setAttribute("org.mortbay.http.ajp.JVMRoute", value);
                                break;
                            }
                            case 5: {
                                request.setQuery(value);
                                break;
                            }
                            case 4: {
                                request.setAuthType(value);
                                break;
                            }
                            case 3: {
                                request.setAuthUser(value);
                                break;
                            }
                            default: {
                                Code.warning("Unknown attr: " + attr + "=" + value);
                            }
                        }
                        attr = packet.getByte();
                    }
                    this._listener.customizeRequest(this, request);
                    gotRequest = true;
                    this.statsRequestStart();
                    request.setState(2);
                    if (request.getContentLength() == 0 && request.getField("Transfer-Encoding") == null) {
                        this._ajpIn.close();
                    }
                    response.setState(0);
                    response.setVersion("HTTP/1.1");
                    response.setDateField("Date", this._request.getTimeStamp());
                    response.setField("Server", Version.__VersionDetail);
                    Code.debug((Object)"REQUEST:\n", (Object)request);
                    context = this.service(request, response);
                    Code.debug((Object)"RESPONSE:\n", (Object)response);
                    return this._persistent;
                }
                default: {
                    Code.debug("Ignored: " + packet);
                    this._persistent = false;
                    return this._persistent;
                }
            }
        }
        catch (SocketException e) {
            Code.ignore(e);
            this._persistent = false;
            return this._persistent;
        }
        catch (Exception e) {
            Code.warning(e);
            this._persistent = false;
            try {
                if (!gotRequest) return this._persistent;
                this._ajpOut.close();
                return this._persistent;
            }
            catch (IOException e2) {
                Code.ignore(e2);
            }
            return this._persistent;
        }
        finally {
            block65: {
                if (packet == null || !gotRequest) {
                    return false;
                }
                try {
                    this.getOutputStream().close();
                    if (!this._persistent) {
                        this._ajpOut.end();
                    }
                    this._ajpOut.close();
                    this.getOutputStream().resetStream();
                    this.getOutputStream().addObserver(this);
                    this.getInputStream().resetStream();
                    this._ajpIn.resetStream();
                    this._ajpOut.resetStream();
                    Object var18_45 = null;
                }
                catch (Throwable throwable) {
                    Object var18_47 = null;
                    this.statsRequestEnd();
                    if (context == null) throw throwable;
                    context.log(request, response, -1);
                    throw throwable;
                }
                this.statsRequestEnd();
                if (context != null) {
                    context.log(request, response, -1);
                }
                break block65;
                {
                    catch (Exception e) {
                        Code.debug(e);
                        this._persistent = false;
                        Object var18_46 = null;
                        this.statsRequestEnd();
                        if (context != null) {
                            context.log(request, response, -1);
                        }
                    }
                }
            }
        }
    }

    protected void firstWrite() throws IOException {
        Code.debug("ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        Code.debug("ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

