/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.mortbay.util.Code;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;

public class Pool
implements LifeCycle,
Serializable {
    static int __max = Integer.getInteger("POOL_MAX", 256);
    static int __min = Integer.getInteger("POOL_MIN", 2);
    static HashMap __nameMap = new HashMap();
    private int _max = __max;
    private int _min = __min;
    private String _name;
    private String _className;
    private int _maxIdleTimeMs = 10000;
    private HashMap _attributes = new HashMap();
    private transient Class _class;
    private transient PondLife[] _pondLife;
    private transient int[] _index;
    private transient int _size;
    private transient int _available;
    private transient int _running = 0;
    static /* synthetic */ Class class$org$mortbay$util$Pool;
    static /* synthetic */ Class class$org$mortbay$util$Pool$PondLife;

    public static Pool getPool(String name) {
        return (Pool)__nameMap.get(name);
    }

    public String getPoolName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolName(String name) throws IllegalStateException {
        Class clazz = class$org$mortbay$util$Pool == null ? (class$org$mortbay$util$Pool = Pool.class$("org.mortbay.util.Pool")) : class$org$mortbay$util$Pool;
        synchronized (clazz) {
            if (this._name != null && !this._name.equals(name)) {
                __nameMap.remove(this._name);
            }
            if (__nameMap.containsKey(name)) {
                throw new IllegalStateException("Name already exists");
            }
            this._name = name;
            __nameMap.put(this._name, this);
        }
    }

    public void setPoolClass(Class poolClass) throws IllegalStateException {
        if (this._class != poolClass) {
            if (this._running > 0) {
                throw new IllegalStateException("Thread Pool Running");
            }
            if (!(class$org$mortbay$util$Pool$PondLife == null ? (class$org$mortbay$util$Pool$PondLife = Pool.class$("org.mortbay.util.Pool$PondLife")) : class$org$mortbay$util$Pool$PondLife).isAssignableFrom(poolClass)) {
                throw new IllegalArgumentException("Not PondLife: " + poolClass);
            }
            this._class = poolClass;
            this._className = this._class.getName();
        }
    }

    public Class getPoolClass() {
        return this._class;
    }

    public int getMinSize() {
        return this._min;
    }

    public void setMinSize(int min) {
        this._min = min;
    }

    public int getMaxSize() {
        return this._max;
    }

    public void setMaxSize(int max) {
        this._max = max;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public boolean isStarted() {
        return this._running > 0 && this._pondLife != null;
    }

    public int size() {
        return this._size;
    }

    public int available() {
        return this._available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Pool pool = this;
        synchronized (pool) {
            ++this._running;
            if (this._running > 1) {
                return;
            }
            this._pondLife = new PondLife[this._max];
            this._index = new int[this._max];
            this._size = 0;
            this._available = 0;
            int i = 0;
            while (i < this._max) {
                this._index[i] = i;
                ++i;
            }
            int i2 = 0;
            while (i2 < this._min) {
                this.newPondLife();
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Pool pool = this;
        synchronized (pool) {
            --this._running;
            if (this._running > 0) {
                return;
            }
            this.notifyAll();
        }
        if (this._pondLife != null && this._size > 0) {
            int i = 0;
            while (i < this._pondLife.length) {
                this.closePondLife(i);
                ++i;
            }
            Thread.yield();
            int i2 = 0;
            while (i2 < this._pondLife.length) {
                this.stopPondLife(i2);
                ++i2;
            }
        }
        this._pondLife = null;
        this._index = null;
        this._size = 0;
        this._available = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PondLife get(int timeoutMs) throws Exception {
        PondLife pl = null;
        if (this._available < this._min) {
            Thread.yield();
        }
        int new_id = -1;
        Pool pool = this;
        synchronized (pool) {
            if (this._running > 0 && this._available == 0 && this._size == this._pondLife.length && timeoutMs > 0) {
                this.wait(timeoutMs);
            }
            if (this._running > 0) {
                if (this._available > 0) {
                    int id = this._index[--this._available];
                    pl = this._pondLife[id];
                } else if (this._size < this._pondLife.length) {
                    new_id = this.reservePondLife(false);
                }
            }
        }
        if (pl == null && new_id >= 0) {
            pl = this.newPondLife(new_id);
        }
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PondLife pl) throws InterruptedException {
        int id = pl.getID();
        if (this._running == 0) {
            this.stopPondLife(id);
        } else {
            Pool pool = this;
            synchronized (pool) {
                if (this._running == 0) {
                    this.stopPondLife(id);
                } else if (this._pondLife[id] != null) {
                    this._index[this._available++] = id;
                    this.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink() throws InterruptedException {
        if (this._running == 0) {
            return;
        }
        Pool pool = this;
        synchronized (pool) {
            if (this._running > 0 && this._available > 0 && this._size > this._min) {
                this.stopPondLife(this._index[--this._available]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reservePondLife(boolean available) throws Exception {
        int id = -1;
        Pool pool = this;
        synchronized (pool) {
            id = this._index[this._size++];
            if (available) {
                this._index[this._available++] = id;
            }
        }
        return id;
    }

    private PondLife newPondLife(int id) throws Exception {
        PondLife pl;
        this._pondLife[id] = pl = (PondLife)this._class.newInstance();
        pl.enterPool(this, id);
        return pl;
    }

    private PondLife newPondLife() throws Exception {
        return this.newPondLife(this.reservePondLife(true));
    }

    private void closePondLife(int id) {
        if (this._pondLife[id] != null) {
            this._pondLife[id].poolClosing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPondLife(int id) {
        PondLife pl = null;
        Pool pool = this;
        synchronized (pool) {
            pl = this._pondLife[id];
            if (pl != null) {
                this._pondLife[id] = null;
                this._index[--this._size] = id;
                if (this._available > this._size) {
                    this._available = this._size;
                }
            }
        }
        if (pl != null) {
            pl.leavePool();
        }
    }

    public void dump(String msg) {
        StringBuffer pond = new StringBuffer();
        StringBuffer avail = new StringBuffer();
        StringBuffer index = new StringBuffer();
        pond.append("pond: ");
        avail.append("avail:");
        index.append("index:");
        int i = 0;
        while (i < this._pondLife.length) {
            if (this._pondLife[i] == null) {
                pond.append("   ");
            } else {
                pond.append(' ');
                StringUtil.append(pond, (byte)i, 16);
            }
            if (i == this._size) {
                avail.append(i == this._available ? " AS" : "  S");
            } else {
                avail.append(i == this._available ? " A " : "   ");
            }
            index.append(' ');
            StringUtil.append(index, (byte)this._index[i], 16);
            ++i;
        }
        System.err.println();
        System.err.println(msg);
        System.err.println(pond);
        System.err.println(avail);
        System.err.println(index);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this._class == null || !this._class.getName().equals(this._className)) {
            try {
                this.setPoolClass(Loader.loadClass(class$org$mortbay$util$Pool == null ? (class$org$mortbay$util$Pool = Pool.class$("org.mortbay.util.Pool")) : class$org$mortbay$util$Pool, this._className));
            }
            catch (Exception e) {
                Code.warning(e);
                throw new InvalidObjectException(e.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface PondLife {
        public int getID();

        public void enterPool(Pool var1, int var2);

        public void poolClosing();

        public void leavePool();
    }
}

