struct OperatorMapping
{
    const char *op;
    const char *description;
};

OperatorMapping op_mapping[] = {
    { .op = "b", .description = "Close, fill, and stroke path using nonzero winding number rule" },
    { .op = "B", .description = "Fill and stroke path using nonzero winding number rule" },
    { .op = "b*", .description = "Close, fill, and stroke path using even-odd rule" },
    { .op = "B*", .description = "Fill and stroke path using even-odd rule" },
    { .op = "BDC", .description = "(PDF 1.2) Begin marked-content sequence with property list" },
    { .op = "BI", .description = "Begin inline image object" },
    { .op = "BMC", .description = "(PDF 1.2) Begin marked-content sequence" },
    { .op = "BT", .description = "Begin text object" },
    { .op = "BX", .description = "(PDF 1.1) Begin compatibility section" },
    { .op = "c", .description = "Append curved segment to path (three control points)" },
    { .op = "cm", .description = "Concatenate matrix to current transformation matrix" },
    { .op = "CS", .description = "(PDF 1.1) Set color space for stroking operations" },
    { .op = "cs", .description = "(PDF 1.1) Set color space for nonstroking operations" },
    { .op = "d", .description = "Set line dash pattern" },
    { .op = "d0", .description = "Set glyph width in Type 3 font" },
    { .op = "d1", .description = "Set glyph width and bounding box in Type 3 font" },
    { .op = "Do", .description = "Invoke named XObject" },
    { .op = "DP", .description = "(PDF 1.2) Define marked-content point with property list" },
    { .op = "EI", .description = "End inline image object" },
    { .op = "EMC", .description = "(PDF 1.2) End marked-content sequence" },
    { .op = "ET", .description = "End text object" },
    { .op = "EX", .description = "(PDF 1.1) End compatibility section" },
    { .op = "f", .description = "Fill path using nonzero winding number rule" },
    { .op = "F", .description = "Fill path using nonzero winding number rule (obsolete)" },
    { .op = "f*", .description = "Fill path using even-odd rule" },
    { .op = "G", .description = "Set gray level for stroking operations" },
    { .op = "g", .description = "Set gray level for nonstroking operations" },
    { .op = "gs", .description = "(PDF 1.2) Set parameters from graphics state parameter dictionary" },
    { .op = "h", .description = "Close subpath" },
    { .op = "i", .description = "Set flatness tolerance" },
    { .op = "ID", .description = "Begin inline image data" },
    { .op = "j", .description = "Set line join style" },
    { .op = "J", .description = "Set line cap style" },
    { .op = "K", .description = "Set CMYK color for stroking operations" },
    { .op = "k", .description = "Set CMYK color for nonstroking operations" },
    { .op = "l", .description = "Append straight line segment to path" },
    { .op = "m", .description = "Begin new subpath" },
    { .op = "M", .description = "Set miter limit" },
    { .op = "MP", .description = "(PDF 1.2) Define marked-content point" },
    { .op = "n", .description = "End path without filling or stroking" },
    { .op = "q", .description = "Save graphics state" },
    { .op = "Q", .description = "Restore graphics state" },
    { .op = "re", .description = "Append rectangle to path" },
    { .op = "RG", .description = "Set RGB color for stroking operations" },
    { .op = "rg", .description = "Set RGB color for nonstroking operations" },
    { .op = "ri", .description = "Set color rendering intent" },
    { .op = "s", .description = "Close and stroke path" },
    { .op = "S", .description = "Stroke path" },
    { .op = "SC", .description = "(PDF 1.1) Set color for stroking operations" },
    { .op = "sc", .description = "(PDF 1.1) Set color for nonstroking operations" },
    { .op = "SCN", .description = "(PDF 1.2) Set color for stroking operations (ICCBased and special color spaces)" },
    { .op = "scn", .description = "(PDF 1.2) Set color for nonstroking operations (ICCBased and special color spaces)" },
    { .op = "sh", .description = "(PDF 1.3) Paint area defined by shading pattern" },
    { .op = "T*", .description = "Move to start of next text line" },
    { .op = "Tc", .description = "Set character spacing" },
    { .op = "Td", .description = "Move text position" },
    { .op = "TD", .description = "Move text position and set leading" },
    { .op = "Tf", .description = "Set text font and size" },
    { .op = "Tj", .description = "Show text" },
    { .op = "TJ", .description = "Show text, allowing individual glyph positioning" },
    { .op = "TL", .description = "Set text leading" },
    { .op = "Tm", .description = "Set text matrix and text line matrix" },
    { .op = "Tr", .description = "Set text rendering mode" },
    { .op = "Ts", .description = "Set text rise" },
    { .op = "Tw", .description = "Set word spacing" },
    { .op = "Tz", .description = "Set horizontal text scaling" },
    { .op = "v", .description = "Append curved segment to path (initial point replicated)" },
    { .op = "w", .description = "Set line width" },
    { .op = "W", .description = "Set clipping path using nonzero winding number rule" },
    { .op = "W*", .description = "Set clipping path using even-odd rule" },
    { .op = "y", .description = "Append curved segment to path (final point replicated)" },
    { .op = "'", .description = "Move to next line and show text" },
    { .op = "\"", .description = "Set word and character spacing, move to next line, and show text" },
};
