![Greenbone Logo](https://www.greenbone.net/wp-content/uploads/gb_new-logo_horizontal_rgb_small.png)

[![GitHub releases](https://img.shields.io/github/release/greenbone/opensight-frontend-components.svg)](https://github.com/greenbone/opensight-frontend-components/releases)
<span class="badge-npmversion"><a href="https://npmjs.org/package/@greenbone/opensight-ui-components-mantinev7" title="View this project on NPM"><img src="https://img.shields.io/npm/v/@greenbone/opensight-ui-components.svg" alt="NPM version" /></a></span>
[![Build](https://github.com/greenbone/opensight-frontend-components/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/greenbone/opensight-frontend-components/actions/workflows/build.yml?query=branch%3Amain++)

# OpenSight User Interface Component Library

## About

This project is used to sequentially update the current opensight-ui-components library to mantine v7.

To use this in parallel with the current opensight-ui-components (mantine v6) (Dev mode):

- `npm run build` - build this project
- `npm pack` - Pack this project into a tarball (file is created in this project)
- Switch to main project
- `npm install <path to tarball file>`

To use the latest release in your frontend, just install it with `npm install @greenbone/opensight-ui-components-mantinev7`

## Prerequisites

Install npm dependencies `npm install`

## Build

To create a production build use `npm run build:source` and `npm run build:types`.

- `npm run build:source` transpiles and bundles the `./src` files into `./lib`
  - For this [SWC](https://swc.rs/) is used
  - Configuration for SWC is located at
    - `./swcrc`/`./swcrc.production` for transpilation and minification
    - `./spack.config.js` for bundling
- `npm run build:types` generated Type definition from `./src` into `./types`
  - For this TSC is used.
    - `./tsconfig[.XXX].json` is used

Why SWC?

> SWC is 20x faster than Babel on a single thread and 70x faster on four cores.

## Credits

| Dependency     | License   | Source-code location |
| -------------- | --------- | -------------------- |
| `caniuse-lite` | CC-BY-4.0 | `caniuse.com`        |

## Maintainer

This project is maintained by [Greenbone AG](https://www.greenbone.net/).

## Contributing

Your contributions are highly appreciated. Please
[create a pull request](https://github.com/greenbone/opensight-frontend-components/pulls)
on GitHub. Bigger changes need to be discussed with the development team via the
[issues section at GitHub](https://github.com/greenbone/opensight-frontend-components/issues)
first.

## License

Copyright (C) 2022-2024 [Greenbone AG](https://www.greenbone.net/)

Licensed under the [GNU Affero General Public License v3.0 or later](LICENSE).
