/* $Id: soap_envelope_.hpp 103491 2007-05-04 17:18:18Z kazimird $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file soap_envelope_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'soap_11.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef SOAP_ENVELOPE_BASE_HPP
#define SOAP_ENVELOPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

// forward declarations
class CSoapBody;
class CSoapHeader;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Envelope, header and body 
class CSoapEnvelope_Base : public ncbi::CSerialObject
{
    typedef ncbi::CSerialObject Tparent;
public:
    // constructor
    CSoapEnvelope_Base(void);
    // destructor
    virtual ~CSoapEnvelope_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSoapHeader THeader;
    typedef CSoapBody TBody;
    typedef std::list< ncbi::CRef< ncbi::CAnyContentObject > > TAnyContent;

    // getters
    // setters

    /// optional
    /// typedef CSoapHeader THeader
    bool IsSetHeader(void) const;
    bool CanGetHeader(void) const;
    void ResetHeader(void);
    const THeader& GetHeader(void) const;
    void SetHeader(THeader& value);
    THeader& SetHeader(void);

    /// mandatory
    /// typedef CSoapBody TBody
    bool IsSetBody(void) const;
    bool CanGetBody(void) const;
    void ResetBody(void);
    const TBody& GetBody(void) const;
    void SetBody(TBody& value);
    TBody& SetBody(void);

    /// optional
    /// typedef std::list< ncbi::CRef< ncbi::CAnyContentObject > > TAnyContent
    bool IsSetAnyContent(void) const;
    bool CanGetAnyContent(void) const;
    void ResetAnyContent(void);
    const TAnyContent& GetAnyContent(void) const;
    TAnyContent& SetAnyContent(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSoapEnvelope_Base(const CSoapEnvelope_Base&);
    CSoapEnvelope_Base& operator=(const CSoapEnvelope_Base&);

    // data
    Uint4 m_set_State[1];
    ncbi::CRef< THeader > m_Header;
    ncbi::CRef< TBody > m_Body;
    TAnyContent m_AnyContent;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSoapEnvelope_Base::IsSetHeader(void) const
{
    return m_Header.NotEmpty();
}

inline
bool CSoapEnvelope_Base::CanGetHeader(void) const
{
    return IsSetHeader();
}

inline
const CSoapEnvelope_Base::THeader& CSoapEnvelope_Base::GetHeader(void) const
{
    if (!CanGetHeader()) {
        ThrowUnassigned(0);
    }
    return (*m_Header);
}

inline
bool CSoapEnvelope_Base::IsSetBody(void) const
{
    return m_Body.NotEmpty();
}

inline
bool CSoapEnvelope_Base::CanGetBody(void) const
{
    return true;
}

inline
const CSoapEnvelope_Base::TBody& CSoapEnvelope_Base::GetBody(void) const
{
    if ( !m_Body ) {
        const_cast<CSoapEnvelope_Base*>(this)->ResetBody();
    }
    return (*m_Body);
}

inline
CSoapEnvelope_Base::TBody& CSoapEnvelope_Base::SetBody(void)
{
    if ( !m_Body ) {
        ResetBody();
    }
    return (*m_Body);
}

inline
bool CSoapEnvelope_Base::IsSetAnyContent(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSoapEnvelope_Base::CanGetAnyContent(void) const
{
    return true;
}

inline
const CSoapEnvelope_Base::TAnyContent& CSoapEnvelope_Base::GetAnyContent(void) const
{
    return m_AnyContent;
}

inline
CSoapEnvelope_Base::TAnyContent& CSoapEnvelope_Base::SetAnyContent(void)
{
    m_set_State[0] |= 0x10;
    return m_AnyContent;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////




END_NCBI_SCOPE


#endif // SOAP_ENVELOPE_BASE_HPP
