/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.internal.tasks.compile.daemon.ProcessIsolatedCompilerWorkerExecutor;
import org.gradle.api.internal.tasks.scala.ScalaCompilerFactory;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.api.tasks.scala.internal.ScalaCompileOptionsConfigurer;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

@CacheableTask
public abstract class ScalaCompile
extends AbstractScalaCompile {
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private FileCollection scalaCompilerPlugins;
    private Compiler<ScalaJavaJointCompileSpec> compiler;

    @Override
    @Nested
    public ScalaCompileOptions getScalaCompileOptions() {
        return (ScalaCompileOptions)super.getScalaCompileOptions();
    }

    @Classpath
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @Classpath
    public FileCollection getScalaCompilerPlugins() {
        return this.scalaCompilerPlugins;
    }

    public void setScalaCompilerPlugins(FileCollection scalaCompilerPlugins) {
        this.scalaCompilerPlugins = scalaCompilerPlugins;
    }

    @Override
    protected ScalaJavaJointCompileSpec createSpec() {
        ScalaCompileOptionsConfigurer.configure(this.getScalaCompileOptions(), this.getToolchain(), this.getScalaClasspath().getFiles());
        ScalaJavaJointCompileSpec spec = super.createSpec();
        if (this.getScalaCompilerPlugins() != null) {
            spec.setScalaCompilerPlugins((Iterable<File>)ImmutableList.copyOf((Iterable)this.getScalaCompilerPlugins()));
        }
        return spec;
    }

    @Classpath
    public FileCollection getZincClasspath() {
        return this.zincClasspath;
    }

    public void setZincClasspath(FileCollection zincClasspath) {
        this.zincClasspath = zincClasspath;
    }

    public void setCompiler(Compiler<ScalaJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }

    @Override
    protected Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec spec) {
        this.assertScalaClasspathIsNonEmpty();
        if (this.compiler == null) {
            WorkerDaemonFactory workerDaemonFactory = (WorkerDaemonFactory)this.getServices().get(WorkerDaemonFactory.class);
            JavaForkOptionsFactory forkOptionsFactory = (JavaForkOptionsFactory)this.getServices().get(JavaForkOptionsFactory.class);
            ClassPathRegistry classPathRegistry = (ClassPathRegistry)this.getServices().get(ClassPathRegistry.class);
            ClassLoaderRegistry classLoaderRegistry = (ClassLoaderRegistry)this.getServices().get(ClassLoaderRegistry.class);
            ActionExecutionSpecFactory actionExecutionSpecFactory = (ActionExecutionSpecFactory)this.getServices().get(ActionExecutionSpecFactory.class);
            ProjectCacheDir projectCacheDir = (ProjectCacheDir)this.getServices().get(ProjectCacheDir.class);
            ScalaCompilerFactory scalaCompilerFactory = new ScalaCompilerFactory(((WorkerDirectoryProvider)this.getServices().get(WorkerDirectoryProvider.class)).getWorkingDirectory(), (CompilerWorkerExecutor)new ProcessIsolatedCompilerWorkerExecutor(workerDaemonFactory, actionExecutionSpecFactory, projectCacheDir), this.getScalaClasspath(), this.getZincClasspath(), forkOptionsFactory, classPathRegistry, classLoaderRegistry, (ClasspathHasher)this.getServices().get(ClasspathHasher.class));
            this.compiler = scalaCompilerFactory.newCompiler(spec);
        }
        return this.compiler;
    }

    protected void assertScalaClasspathIsNonEmpty() {
        if (this.getScalaClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".scalaClasspath' must not be empty. If a Scala compile dependency is provided, the 'scala-base' plugin will attempt to configure 'scalaClasspath' automatically. Alternatively, you may configure 'scalaClasspath' explicitly.");
        }
    }
}

