// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/destination_policy.proto

package meshv2beta1

import (
	_ "github.com/hashicorp/consul/proto-public/pbresource"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// +kubebuilder:validation:Enum=LOCALITY_PRIORITIZATION_MODE_UNSPECIFIED;LOCALITY_PRIORITIZATION_MODE_NONE;LOCALITY_PRIORITIZATION_MODE_FAILOVER
// +kubebuilder:validation:Type=string
type LocalityPrioritizationMode int32

const (
	LocalityPrioritizationMode_LOCALITY_PRIORITIZATION_MODE_UNSPECIFIED LocalityPrioritizationMode = 0
	LocalityPrioritizationMode_LOCALITY_PRIORITIZATION_MODE_NONE        LocalityPrioritizationMode = 1
	LocalityPrioritizationMode_LOCALITY_PRIORITIZATION_MODE_FAILOVER    LocalityPrioritizationMode = 2
)

// Enum value maps for LocalityPrioritizationMode.
var (
	LocalityPrioritizationMode_name = map[int32]string{
		0: "LOCALITY_PRIORITIZATION_MODE_UNSPECIFIED",
		1: "LOCALITY_PRIORITIZATION_MODE_NONE",
		2: "LOCALITY_PRIORITIZATION_MODE_FAILOVER",
	}
	LocalityPrioritizationMode_value = map[string]int32{
		"LOCALITY_PRIORITIZATION_MODE_UNSPECIFIED": 0,
		"LOCALITY_PRIORITIZATION_MODE_NONE":        1,
		"LOCALITY_PRIORITIZATION_MODE_FAILOVER":    2,
	}
)

func (x LocalityPrioritizationMode) Enum() *LocalityPrioritizationMode {
	p := new(LocalityPrioritizationMode)
	*p = x
	return p
}

func (x LocalityPrioritizationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocalityPrioritizationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_destination_policy_proto_enumTypes[0].Descriptor()
}

func (LocalityPrioritizationMode) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_destination_policy_proto_enumTypes[0]
}

func (x LocalityPrioritizationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocalityPrioritizationMode.Descriptor instead.
func (LocalityPrioritizationMode) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{0}
}

// +kubebuilder:validation:Enum=LOAD_BALANCER_POLICY_UNSPECIFIED;LOAD_BALANCER_POLICY_RANDOM;LOAD_BALANCER_POLICY_ROUND_ROBIN;LOAD_BALANCER_POLICY_LEAST_REQUEST;LOAD_BALANCER_POLICY_MAGLEV;LOAD_BALANCER_POLICY_RING_HASH
// +kubebuilder:validation:Type=string
type LoadBalancerPolicy int32

const (
	LoadBalancerPolicy_LOAD_BALANCER_POLICY_UNSPECIFIED   LoadBalancerPolicy = 0
	LoadBalancerPolicy_LOAD_BALANCER_POLICY_RANDOM        LoadBalancerPolicy = 1
	LoadBalancerPolicy_LOAD_BALANCER_POLICY_ROUND_ROBIN   LoadBalancerPolicy = 2
	LoadBalancerPolicy_LOAD_BALANCER_POLICY_LEAST_REQUEST LoadBalancerPolicy = 3
	LoadBalancerPolicy_LOAD_BALANCER_POLICY_MAGLEV        LoadBalancerPolicy = 4
	LoadBalancerPolicy_LOAD_BALANCER_POLICY_RING_HASH     LoadBalancerPolicy = 5
)

// Enum value maps for LoadBalancerPolicy.
var (
	LoadBalancerPolicy_name = map[int32]string{
		0: "LOAD_BALANCER_POLICY_UNSPECIFIED",
		1: "LOAD_BALANCER_POLICY_RANDOM",
		2: "LOAD_BALANCER_POLICY_ROUND_ROBIN",
		3: "LOAD_BALANCER_POLICY_LEAST_REQUEST",
		4: "LOAD_BALANCER_POLICY_MAGLEV",
		5: "LOAD_BALANCER_POLICY_RING_HASH",
	}
	LoadBalancerPolicy_value = map[string]int32{
		"LOAD_BALANCER_POLICY_UNSPECIFIED":   0,
		"LOAD_BALANCER_POLICY_RANDOM":        1,
		"LOAD_BALANCER_POLICY_ROUND_ROBIN":   2,
		"LOAD_BALANCER_POLICY_LEAST_REQUEST": 3,
		"LOAD_BALANCER_POLICY_MAGLEV":        4,
		"LOAD_BALANCER_POLICY_RING_HASH":     5,
	}
)

func (x LoadBalancerPolicy) Enum() *LoadBalancerPolicy {
	p := new(LoadBalancerPolicy)
	*p = x
	return p
}

func (x LoadBalancerPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_destination_policy_proto_enumTypes[1].Descriptor()
}

func (LoadBalancerPolicy) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_destination_policy_proto_enumTypes[1]
}

func (x LoadBalancerPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerPolicy.Descriptor instead.
func (LoadBalancerPolicy) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{1}
}

// +kubebuilder:validation:Enum=HASH_POLICY_FIELD_UNSPECIFIED;HASH_POLICY_FIELD_HEADER;HASH_POLICY_FIELD_COOKIE;HASH_POLICY_FIELD_QUERY_PARAMETER
// +kubebuilder:validation:Type=string
type HashPolicyField int32

const (
	HashPolicyField_HASH_POLICY_FIELD_UNSPECIFIED     HashPolicyField = 0
	HashPolicyField_HASH_POLICY_FIELD_HEADER          HashPolicyField = 1
	HashPolicyField_HASH_POLICY_FIELD_COOKIE          HashPolicyField = 2
	HashPolicyField_HASH_POLICY_FIELD_QUERY_PARAMETER HashPolicyField = 3
)

// Enum value maps for HashPolicyField.
var (
	HashPolicyField_name = map[int32]string{
		0: "HASH_POLICY_FIELD_UNSPECIFIED",
		1: "HASH_POLICY_FIELD_HEADER",
		2: "HASH_POLICY_FIELD_COOKIE",
		3: "HASH_POLICY_FIELD_QUERY_PARAMETER",
	}
	HashPolicyField_value = map[string]int32{
		"HASH_POLICY_FIELD_UNSPECIFIED":     0,
		"HASH_POLICY_FIELD_HEADER":          1,
		"HASH_POLICY_FIELD_COOKIE":          2,
		"HASH_POLICY_FIELD_QUERY_PARAMETER": 3,
	}
)

func (x HashPolicyField) Enum() *HashPolicyField {
	p := new(HashPolicyField)
	*p = x
	return p
}

func (x HashPolicyField) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HashPolicyField) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_destination_policy_proto_enumTypes[2].Descriptor()
}

func (HashPolicyField) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_destination_policy_proto_enumTypes[2]
}

func (x HashPolicyField) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HashPolicyField.Descriptor instead.
func (HashPolicyField) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{2}
}

// DestinationPolicy is the destination-controlled set of defaults that
// are used when similar controls defined in an DestinationsConfiguration are
// left unspecified.
//
// Users may wish to share commonly configured settings for communicating with
// a service in one place, but yet retain the ability to tweak those on a
// client-by-client basis, which is why there are separate resources to control
// the definition of these values from either end of the connection.
//
// This is a Resource type.
type DestinationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PortConfigs defines the destination policy for a specific port on a service.
	//
	// For more details on potential values of the service port identifier key,
	// see documentation for Service.ServicePort.
	PortConfigs map[string]*DestinationConfig `protobuf:"bytes,1,rep,name=port_configs,json=portConfigs,proto3" json:"port_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DestinationPolicy) Reset() {
	*x = DestinationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationPolicy) ProtoMessage() {}

func (x *DestinationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationPolicy.ProtoReflect.Descriptor instead.
func (*DestinationPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{0}
}

func (x *DestinationPolicy) GetPortConfigs() map[string]*DestinationConfig {
	if x != nil {
		return x.PortConfigs
	}
	return nil
}

type DestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ConnectTimeout is the timeout for establishing new network connections
	// to this service.
	// +kubebuilder:validation:Format=duration
	ConnectTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	// RequestTimeout is the timeout for an HTTP request to complete before the
	// connection is automatically terminated. If unspecified, defaults to 15
	// seconds.
	// +kubebuilder:validation:Format=duration
	RequestTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=request_timeout,json=requestTimeout,proto3" json:"request_timeout,omitempty"`
	// LoadBalancer determines the load balancing policy and configuration for
	// services issuing requests to this upstream service.
	LoadBalancer *LoadBalancer `protobuf:"bytes,3,opt,name=load_balancer,json=loadBalancer,proto3" json:"load_balancer,omitempty"`
	// LocalityPrioritization controls whether the locality of services within the
	// local partition will be used to prioritize connectivity.
	LocalityPrioritization *LocalityPrioritization `protobuf:"bytes,4,opt,name=locality_prioritization,json=localityPrioritization,proto3" json:"locality_prioritization,omitempty"`
}

func (x *DestinationConfig) Reset() {
	*x = DestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationConfig) ProtoMessage() {}

func (x *DestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationConfig.ProtoReflect.Descriptor instead.
func (*DestinationConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{1}
}

func (x *DestinationConfig) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *DestinationConfig) GetRequestTimeout() *durationpb.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (x *DestinationConfig) GetLoadBalancer() *LoadBalancer {
	if x != nil {
		return x.LoadBalancer
	}
	return nil
}

func (x *DestinationConfig) GetLocalityPrioritization() *LocalityPrioritization {
	if x != nil {
		return x.LocalityPrioritization
	}
	return nil
}

type LocalityPrioritization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode specifies the type of prioritization that will be performed
	// when selecting nodes in the local partition.
	// Valid values are: "" (default "none"), "none", and "failover".
	Mode LocalityPrioritizationMode `protobuf:"varint,1,opt,name=mode,proto3,enum=hashicorp.consul.mesh.v2beta1.LocalityPrioritizationMode" json:"mode,omitempty"`
}

func (x *LocalityPrioritization) Reset() {
	*x = LocalityPrioritization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalityPrioritization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalityPrioritization) ProtoMessage() {}

func (x *LocalityPrioritization) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalityPrioritization.ProtoReflect.Descriptor instead.
func (*LocalityPrioritization) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{2}
}

func (x *LocalityPrioritization) GetMode() LocalityPrioritizationMode {
	if x != nil {
		return x.Mode
	}
	return LocalityPrioritizationMode_LOCALITY_PRIORITIZATION_MODE_UNSPECIFIED
}

// LoadBalancer determines the load balancing policy and configuration
// for services issuing requests to this upstream service.
type LoadBalancer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Policy is the load balancing policy used to select a host
	Policy LoadBalancerPolicy `protobuf:"varint,1,opt,name=policy,proto3,enum=hashicorp.consul.mesh.v2beta1.LoadBalancerPolicy" json:"policy,omitempty"`
	// HashPolicies is a list of hash policies to use for hashing load balancing
	// algorithms. Hash policies are evaluated individually and combined such
	// that identical lists result in the same hash.
	//
	// If no hash policies are present, or none are successfully evaluated,
	// then a random backend host will be selected.
	HashPolicies []*HashPolicy `protobuf:"bytes,2,rep,name=hash_policies,json=hashPolicies,proto3" json:"hash_policies,omitempty"`
	// Types that are assignable to Config:
	//
	//	*LoadBalancer_RingHashConfig
	//	*LoadBalancer_LeastRequestConfig
	Config isLoadBalancer_Config `protobuf_oneof:"config"`
}

func (x *LoadBalancer) Reset() {
	*x = LoadBalancer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancer) ProtoMessage() {}

func (x *LoadBalancer) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancer.ProtoReflect.Descriptor instead.
func (*LoadBalancer) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{3}
}

func (x *LoadBalancer) GetPolicy() LoadBalancerPolicy {
	if x != nil {
		return x.Policy
	}
	return LoadBalancerPolicy_LOAD_BALANCER_POLICY_UNSPECIFIED
}

func (x *LoadBalancer) GetHashPolicies() []*HashPolicy {
	if x != nil {
		return x.HashPolicies
	}
	return nil
}

func (m *LoadBalancer) GetConfig() isLoadBalancer_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *LoadBalancer) GetRingHashConfig() *RingHashConfig {
	if x, ok := x.GetConfig().(*LoadBalancer_RingHashConfig); ok {
		return x.RingHashConfig
	}
	return nil
}

func (x *LoadBalancer) GetLeastRequestConfig() *LeastRequestConfig {
	if x, ok := x.GetConfig().(*LoadBalancer_LeastRequestConfig); ok {
		return x.LeastRequestConfig
	}
	return nil
}

type isLoadBalancer_Config interface {
	isLoadBalancer_Config()
}

type LoadBalancer_RingHashConfig struct {
	// RingHashConfig contains configuration for the "ring_hash" policy type
	RingHashConfig *RingHashConfig `protobuf:"bytes,3,opt,name=ring_hash_config,json=ringHashConfig,proto3,oneof"`
}

type LoadBalancer_LeastRequestConfig struct {
	// LeastRequestConfig contains configuration for the "least_request" policy type
	LeastRequestConfig *LeastRequestConfig `protobuf:"bytes,4,opt,name=least_request_config,json=leastRequestConfig,proto3,oneof"`
}

func (*LoadBalancer_RingHashConfig) isLoadBalancer_Config() {}

func (*LoadBalancer_LeastRequestConfig) isLoadBalancer_Config() {}

// RingHashConfig contains configuration for the "ring_hash" policy type
type RingHashConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// MinimumRingSize determines the minimum number of entries in the hash ring
	MinimumRingSize uint64 `protobuf:"varint,1,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
	// MaximumRingSize determines the maximum number of entries in the hash ring
	MaximumRingSize uint64 `protobuf:"varint,2,opt,name=maximum_ring_size,json=maximumRingSize,proto3" json:"maximum_ring_size,omitempty"`
}

func (x *RingHashConfig) Reset() {
	*x = RingHashConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RingHashConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RingHashConfig) ProtoMessage() {}

func (x *RingHashConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RingHashConfig.ProtoReflect.Descriptor instead.
func (*RingHashConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{4}
}

func (x *RingHashConfig) GetMinimumRingSize() uint64 {
	if x != nil {
		return x.MinimumRingSize
	}
	return 0
}

func (x *RingHashConfig) GetMaximumRingSize() uint64 {
	if x != nil {
		return x.MaximumRingSize
	}
	return 0
}

// LeastRequestConfig contains configuration for the "least_request" policy type
type LeastRequestConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ChoiceCount determines the number of random healthy hosts from which to select the one with the least requests.
	ChoiceCount uint32 `protobuf:"varint,1,opt,name=choice_count,json=choiceCount,proto3" json:"choice_count,omitempty"`
}

func (x *LeastRequestConfig) Reset() {
	*x = LeastRequestConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeastRequestConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeastRequestConfig) ProtoMessage() {}

func (x *LeastRequestConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeastRequestConfig.ProtoReflect.Descriptor instead.
func (*LeastRequestConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{5}
}

func (x *LeastRequestConfig) GetChoiceCount() uint32 {
	if x != nil {
		return x.ChoiceCount
	}
	return 0
}

// HashPolicy defines which attributes will be hashed by hash-based LB algorithms
type HashPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field is the attribute type to hash on.
	// Must be one of "header","cookie", or "query_parameter".
	// Cannot be specified along with SourceIP.
	Field HashPolicyField `protobuf:"varint,1,opt,name=field,proto3,enum=hashicorp.consul.mesh.v2beta1.HashPolicyField" json:"field,omitempty"`
	// FieldValue is the value to hash.
	// ie. header name, cookie name, URL query parameter name
	// Cannot be specified along with SourceIP.
	FieldValue string `protobuf:"bytes,2,opt,name=field_value,json=fieldValue,proto3" json:"field_value,omitempty"`
	// CookieConfig contains configuration for the "cookie" hash policy type.
	CookieConfig *CookieConfig `protobuf:"bytes,3,opt,name=cookie_config,json=cookieConfig,proto3" json:"cookie_config,omitempty"`
	// SourceIP determines whether the hash should be of the source IP rather than of a field and field value.
	// Cannot be specified along with Field or FieldValue.
	SourceIp bool `protobuf:"varint,4,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Terminal will short circuit the computation of the hash when multiple hash policies are present.
	// If a hash is computed when a Terminal policy is evaluated,
	// then that hash will be used and subsequent hash policies will be ignored.
	Terminal bool `protobuf:"varint,5,opt,name=terminal,proto3" json:"terminal,omitempty"`
}

func (x *HashPolicy) Reset() {
	*x = HashPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashPolicy) ProtoMessage() {}

func (x *HashPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashPolicy.ProtoReflect.Descriptor instead.
func (*HashPolicy) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{6}
}

func (x *HashPolicy) GetField() HashPolicyField {
	if x != nil {
		return x.Field
	}
	return HashPolicyField_HASH_POLICY_FIELD_UNSPECIFIED
}

func (x *HashPolicy) GetFieldValue() string {
	if x != nil {
		return x.FieldValue
	}
	return ""
}

func (x *HashPolicy) GetCookieConfig() *CookieConfig {
	if x != nil {
		return x.CookieConfig
	}
	return nil
}

func (x *HashPolicy) GetSourceIp() bool {
	if x != nil {
		return x.SourceIp
	}
	return false
}

func (x *HashPolicy) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

// CookieConfig contains configuration for the "cookie" hash policy type.
// This is specified to have Envoy generate a cookie for a client on its first request.
type CookieConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generates a session cookie with no expiration.
	Session bool `protobuf:"varint,1,opt,name=session,proto3" json:"session,omitempty"`
	// TTL for generated cookies. Cannot be specified for session cookies.
	// +kubebuilder:validation:Format=duration
	Ttl *durationpb.Duration `protobuf:"bytes,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// The path to set for the cookie
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *CookieConfig) Reset() {
	*x = CookieConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CookieConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CookieConfig) ProtoMessage() {}

func (x *CookieConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_destination_policy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CookieConfig.ProtoReflect.Descriptor instead.
func (*CookieConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP(), []int{7}
}

func (x *CookieConfig) GetSession() bool {
	if x != nil {
		return x.Session
	}
	return false
}

func (x *CookieConfig) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *CookieConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

var File_pbmesh_v2beta1_destination_policy_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_destination_policy_proto_rawDesc = []byte{
	0x0a, 0x27, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x70, 0x62, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf3, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x64, 0x0a, 0x0c,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x1a, 0x70, 0x0a, 0x10, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0xa2, 0x93, 0x04, 0x02, 0x08, 0x03, 0x22, 0xdd, 0x02, 0x0a,
	0x11, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x42, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x42, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x52, 0x0c,
	0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x6e, 0x0a, 0x17,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x16,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xf5, 0x02, 0x0a, 0x0c, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x4e, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x0c, 0x68, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x12, 0x59, 0x0a, 0x10, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x69, 0x6e, 0x67,
	0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x69,
	0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x14,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x65, 0x61, 0x73, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x12, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x68, 0x0a,
	0x0e, 0x52, 0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6d,
	0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x52,
	0x69, 0x6e, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x37, 0x0a, 0x12, 0x4c, 0x65, 0x61, 0x73, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0b, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x22, 0xfe, 0x01, 0x0a, 0x0a, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x44, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48,
	0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x05,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x63, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x70, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x6c, 0x22, 0x69, 0x0a, 0x0c, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x03, 0x74,
	0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x2a, 0x9c, 0x01, 0x0a,
	0x1a, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x28, 0x4c,
	0x4f, 0x43, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x4c, 0x4f, 0x43,
	0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x29, 0x0a, 0x25, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x49,
	0x4f, 0x52, 0x49, 0x54, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x02, 0x2a, 0xee, 0x01, 0x0a, 0x12,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e,
	0x43, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x4f, 0x41,
	0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x52, 0x4f, 0x42, 0x49, 0x4e, 0x10, 0x02, 0x12,
	0x26, 0x0a, 0x22, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4c, 0x45, 0x41, 0x53, 0x54, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x41, 0x44, 0x5f,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x4d, 0x41, 0x47, 0x4c, 0x45, 0x56, 0x10, 0x04, 0x12, 0x22, 0x0a, 0x1e, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x10, 0x05, 0x2a, 0x97, 0x01, 0x0a,
	0x0f, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x21, 0x0a, 0x1d, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10,
	0x01, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x43, 0x4f, 0x4f, 0x4b, 0x49, 0x45, 0x10, 0x02, 0x12,
	0x25, 0x0a, 0x21, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x46,
	0x49, 0x45, 0x4c, 0x44, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4d,
	0x45, 0x54, 0x45, 0x52, 0x10, 0x03, 0x42, 0x97, 0x02, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x16, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x2f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b,
	0x6d, 0x65, 0x73, 0x68, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x48, 0x43,
	0x4d, 0xaa, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xca, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xe2, 0x02, 0x29, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x20,
	0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73, 0x68, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_destination_policy_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_destination_policy_proto_rawDescData = file_pbmesh_v2beta1_destination_policy_proto_rawDesc
)

func file_pbmesh_v2beta1_destination_policy_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_destination_policy_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_destination_policy_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_destination_policy_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_destination_policy_proto_rawDescData
}

var file_pbmesh_v2beta1_destination_policy_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_pbmesh_v2beta1_destination_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_pbmesh_v2beta1_destination_policy_proto_goTypes = []interface{}{
	(LocalityPrioritizationMode)(0), // 0: hashicorp.consul.mesh.v2beta1.LocalityPrioritizationMode
	(LoadBalancerPolicy)(0),         // 1: hashicorp.consul.mesh.v2beta1.LoadBalancerPolicy
	(HashPolicyField)(0),            // 2: hashicorp.consul.mesh.v2beta1.HashPolicyField
	(*DestinationPolicy)(nil),       // 3: hashicorp.consul.mesh.v2beta1.DestinationPolicy
	(*DestinationConfig)(nil),       // 4: hashicorp.consul.mesh.v2beta1.DestinationConfig
	(*LocalityPrioritization)(nil),  // 5: hashicorp.consul.mesh.v2beta1.LocalityPrioritization
	(*LoadBalancer)(nil),            // 6: hashicorp.consul.mesh.v2beta1.LoadBalancer
	(*RingHashConfig)(nil),          // 7: hashicorp.consul.mesh.v2beta1.RingHashConfig
	(*LeastRequestConfig)(nil),      // 8: hashicorp.consul.mesh.v2beta1.LeastRequestConfig
	(*HashPolicy)(nil),              // 9: hashicorp.consul.mesh.v2beta1.HashPolicy
	(*CookieConfig)(nil),            // 10: hashicorp.consul.mesh.v2beta1.CookieConfig
	nil,                             // 11: hashicorp.consul.mesh.v2beta1.DestinationPolicy.PortConfigsEntry
	(*durationpb.Duration)(nil),     // 12: google.protobuf.Duration
}
var file_pbmesh_v2beta1_destination_policy_proto_depIdxs = []int32{
	11, // 0: hashicorp.consul.mesh.v2beta1.DestinationPolicy.port_configs:type_name -> hashicorp.consul.mesh.v2beta1.DestinationPolicy.PortConfigsEntry
	12, // 1: hashicorp.consul.mesh.v2beta1.DestinationConfig.connect_timeout:type_name -> google.protobuf.Duration
	12, // 2: hashicorp.consul.mesh.v2beta1.DestinationConfig.request_timeout:type_name -> google.protobuf.Duration
	6,  // 3: hashicorp.consul.mesh.v2beta1.DestinationConfig.load_balancer:type_name -> hashicorp.consul.mesh.v2beta1.LoadBalancer
	5,  // 4: hashicorp.consul.mesh.v2beta1.DestinationConfig.locality_prioritization:type_name -> hashicorp.consul.mesh.v2beta1.LocalityPrioritization
	0,  // 5: hashicorp.consul.mesh.v2beta1.LocalityPrioritization.mode:type_name -> hashicorp.consul.mesh.v2beta1.LocalityPrioritizationMode
	1,  // 6: hashicorp.consul.mesh.v2beta1.LoadBalancer.policy:type_name -> hashicorp.consul.mesh.v2beta1.LoadBalancerPolicy
	9,  // 7: hashicorp.consul.mesh.v2beta1.LoadBalancer.hash_policies:type_name -> hashicorp.consul.mesh.v2beta1.HashPolicy
	7,  // 8: hashicorp.consul.mesh.v2beta1.LoadBalancer.ring_hash_config:type_name -> hashicorp.consul.mesh.v2beta1.RingHashConfig
	8,  // 9: hashicorp.consul.mesh.v2beta1.LoadBalancer.least_request_config:type_name -> hashicorp.consul.mesh.v2beta1.LeastRequestConfig
	2,  // 10: hashicorp.consul.mesh.v2beta1.HashPolicy.field:type_name -> hashicorp.consul.mesh.v2beta1.HashPolicyField
	10, // 11: hashicorp.consul.mesh.v2beta1.HashPolicy.cookie_config:type_name -> hashicorp.consul.mesh.v2beta1.CookieConfig
	12, // 12: hashicorp.consul.mesh.v2beta1.CookieConfig.ttl:type_name -> google.protobuf.Duration
	4,  // 13: hashicorp.consul.mesh.v2beta1.DestinationPolicy.PortConfigsEntry.value:type_name -> hashicorp.consul.mesh.v2beta1.DestinationConfig
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_destination_policy_proto_init() }
func file_pbmesh_v2beta1_destination_policy_proto_init() {
	if File_pbmesh_v2beta1_destination_policy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalityPrioritization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RingHashConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeastRequestConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_destination_policy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CookieConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pbmesh_v2beta1_destination_policy_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*LoadBalancer_RingHashConfig)(nil),
		(*LoadBalancer_LeastRequestConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_destination_policy_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_destination_policy_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_destination_policy_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_destination_policy_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_destination_policy_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_destination_policy_proto = out.File
	file_pbmesh_v2beta1_destination_policy_proto_rawDesc = nil
	file_pbmesh_v2beta1_destination_policy_proto_goTypes = nil
	file_pbmesh_v2beta1_destination_policy_proto_depIdxs = nil
}
