/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.apache.log4j.Logger;
import org.argouml.model.ActivityGraphsFactory;
import org.argouml.model.ActivityGraphsHelper;
import org.argouml.model.AggregationKind;
import org.argouml.model.ChangeableKind;
import org.argouml.model.CollaborationsFactory;
import org.argouml.model.CollaborationsHelper;
import org.argouml.model.CommonBehaviorFactory;
import org.argouml.model.CommonBehaviorHelper;
import org.argouml.model.ConcurrencyKind;
import org.argouml.model.CopyHelper;
import org.argouml.model.CoreFactory;
import org.argouml.model.CoreHelper;
import org.argouml.model.DataTypesFactory;
import org.argouml.model.DataTypesHelper;
import org.argouml.model.DiagramInterchangeModel;
import org.argouml.model.DirectionKind;
import org.argouml.model.ExtensionMechanismsFactory;
import org.argouml.model.ExtensionMechanismsHelper;
import org.argouml.model.Facade;
import org.argouml.model.MessageSort;
import org.argouml.model.MetaTypes;
import org.argouml.model.ModelEventPump;
import org.argouml.model.ModelImplementation;
import org.argouml.model.ModelManagementFactory;
import org.argouml.model.ModelManagementHelper;
import org.argouml.model.OrderingKind;
import org.argouml.model.PseudostateKind;
import org.argouml.model.ScopeKind;
import org.argouml.model.StateMachinesFactory;
import org.argouml.model.StateMachinesHelper;
import org.argouml.model.UUIDManager;
import org.argouml.model.UmlException;
import org.argouml.model.UmlFactory;
import org.argouml.model.UmlHelper;
import org.argouml.model.UseCasesFactory;
import org.argouml.model.UseCasesHelper;
import org.argouml.model.VisibilityKind;
import org.argouml.model.XmiReader;
import org.argouml.model.XmiWriter;
import org.argouml.model.mdr.ActivityGraphsFactoryMDRImpl;
import org.argouml.model.mdr.ActivityGraphsHelperMDRImpl;
import org.argouml.model.mdr.CollaborationsFactoryMDRImpl;
import org.argouml.model.mdr.CollaborationsHelperMDRImpl;
import org.argouml.model.mdr.CommonBehaviorFactoryMDRImpl;
import org.argouml.model.mdr.CommonBehaviorHelperMDRImpl;
import org.argouml.model.mdr.CoreFactoryMDRImpl;
import org.argouml.model.mdr.CoreHelperMDRImpl;
import org.argouml.model.mdr.DataTypesFactoryMDRImpl;
import org.argouml.model.mdr.DataTypesHelperMDRImpl;
import org.argouml.model.mdr.ExtensionMechanismsFactoryMDRImpl;
import org.argouml.model.mdr.ExtensionMechanismsHelperMDRImpl;
import org.argouml.model.mdr.FacadeMDRImpl;
import org.argouml.model.mdr.KindsMDRImpl;
import org.argouml.model.mdr.MessageSortMDRImpl;
import org.argouml.model.mdr.MetaTypesMDRImpl;
import org.argouml.model.mdr.ModelEventPumpMDRImpl;
import org.argouml.model.mdr.ModelManagementFactoryMDRImpl;
import org.argouml.model.mdr.ModelManagementHelperMDRImpl;
import org.argouml.model.mdr.StateMachinesFactoryMDRImpl;
import org.argouml.model.mdr.StateMachinesHelperMDRImpl;
import org.argouml.model.mdr.UmlFactoryMDRImpl;
import org.argouml.model.mdr.UmlHelperMDRImpl;
import org.argouml.model.mdr.UndoCoreHelperDecorator;
import org.argouml.model.mdr.UseCasesFactoryMDRImpl;
import org.argouml.model.mdr.UseCasesHelperMDRImpl;
import org.argouml.model.mdr.XmiReaderImpl;
import org.argouml.model.mdr.XmiReference;
import org.argouml.model.mdr.XmiWriterMDRImpl;
import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.omg.uml.UmlPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDRModelImplementation
implements ModelImplementation {
    private static final Logger LOG = Logger.getLogger(MDRModelImplementation.class);
    private Facade theFacade;
    private ModelEventPumpMDRImpl theModelEventPump;
    private org.argouml.model.mdr.CopyHelper theCopyHelper;
    private ActivityGraphsHelper theActivityGraphsHelper;
    private CoreHelper theCoreHelper;
    private MessageSort theMessageSort;
    private MetaTypes theMetaTypes = new MetaTypesMDRImpl();
    private ModelManagementFactory theModelManagementFactory;
    private ModelManagementHelper theModelManagementHelper;
    private StateMachinesHelper theStateMachinesHelper;
    private UmlFactory theUmlFactory;
    private UmlHelper theUmlHelper;
    private UseCasesFactory theUseCasesFactory;
    private UseCasesHelper theUseCasesHelper;
    private ActivityGraphsFactory theActivityGraphsFactory;
    private CollaborationsFactory theCollaborationsFactory;
    private CollaborationsHelper theCollaborationsHelper;
    private CommonBehaviorFactory theCommonBehaviorFactory;
    private CommonBehaviorHelper theCommonBehaviorHelper;
    private DataTypesFactoryMDRImpl theDataTypesFactory;
    private DataTypesHelper theDataTypesHelper;
    private ExtensionMechanismsFactory theExtensionMechanismsFactory;
    private ExtensionMechanismsHelper theExtensionMechanismsHelper;
    private StateMachinesFactory theStateMachinesFactory;
    private CoreFactory theCoreFactory;
    private KindsMDRImpl theKindsObject;
    private MDRepository repository;
    private UmlPackage umlPackage;
    private MofPackage mofPackage;
    private ModelPackage mofExtent;
    private Map<String, XmiReference> objectToId = Collections.synchronizedMap(new HashMap());
    private Map<String, String> public2SystemIds = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Object>> idToObject = Collections.synchronizedMap(new HashMap());
    private List<String> searchDirs = new ArrayList<String>();
    private Map<UmlPackage, Extent> extents = new HashMap<UmlPackage, Extent>(10, 0.5f);
    static final String MOF_EXTENT_NAME = "MOF Extent";
    static final String MODEL_EXTENT_NAME = "model extent";
    static final String METAMODEL_URL = "mof/01-02-15_Diff.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UmlPackage getUmlPackage() {
        Map<UmlPackage, Extent> map = this.extents;
        synchronized (map) {
            if (this.umlPackage == null) {
                LOG.debug((Object)"umlPackage is null - no current extent");
            }
            return this.umlPackage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RefPackage createExtent(String name, boolean readOnly) {
        try {
            Map<UmlPackage, Extent> map = this.extents;
            synchronized (map) {
                UmlPackage extent = (UmlPackage)this.getRepository().createExtent(name, (RefObject)this.getMofPackage());
                this.extents.put(extent, new Extent(name, readOnly));
                if (!readOnly) {
                    if (this.umlPackage != null) {
                        try {
                            this.deleteExtentUnchecked(this.umlPackage);
                        }
                        catch (InvalidObjectException e) {
                            LOG.debug((Object)"User model extent already deleted");
                        }
                    }
                    this.umlPackage = extent;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Created new " + (readOnly ? "readonly " : "") + "extent " + this.umlPackage));
                    LOG.debug((Object)("All registered extents = " + Arrays.toString(this.repository.getExtentNames())));
                }
                return extent;
            }
        }
        catch (CreationFailedException e) {
            LOG.error((Object)("Extent creation failed for " + name));
            return null;
        }
    }

    private void cleanExtents() {
        String[] names;
        for (String n : names = this.repository.getExtentNames()) {
            if (MOF_EXTENT_NAME.equals(n) || "MOF".equals(n)) continue;
            RefPackage extent = this.repository.getExtent(n);
            extent.refDelete();
            LOG.debug((Object)("Deleting extent " + n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteExtent(UmlPackage extent) {
        Map<UmlPackage, Extent> map = this.extents;
        synchronized (map) {
            if (this.umlPackage.equals(extent)) {
                this.createDefaultExtent();
            } else {
                this.deleteExtentUnchecked(extent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExtentUnchecked(UmlPackage extent) {
        Map<UmlPackage, Extent> map = this.extents;
        synchronized (map) {
            Extent e = this.extents.get(extent);
            if (e == null) {
                LOG.warn((Object)("No listing for extent " + extent));
                extent.refDelete();
            } else if (e.decrementCount() == 0) {
                String name = this.extents.remove((Object)extent).name;
                if (this.public2SystemIds.remove(name) == null && !MODEL_EXTENT_NAME.equals(name)) {
                    LOG.warn((Object)("No system id found for extent " + (name == null ? "" : name) + " : " + extent));
                }
                if (this.idToObject.remove(name) == null && !MODEL_EXTENT_NAME.equals(name)) {
                    LOG.warn((Object)("No ID map found for extent " + (name == null ? "" : name) + " : " + extent));
                }
                extent.refDelete();
            }
        }
    }

    Collection<UmlPackage> getExtents() {
        return Collections.unmodifiableSet(this.extents.keySet());
    }

    public UmlPackage getExtent(String name) {
        return (UmlPackage)this.repository.getExtent(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReadOnly(Object extent) {
        Map<UmlPackage, Extent> map = this.extents;
        synchronized (map) {
            Extent result = this.extents.get(extent);
            if (result == null) {
                return false;
            }
            return result.readOnly;
        }
    }

    public MofPackage getMofPackage() {
        return this.mofPackage;
    }

    ModelPackage getModelPackage() {
        return this.mofExtent;
    }

    MDRepository getRepository() {
        return this.repository;
    }

    public MDRModelImplementation(MDRepository r) throws UmlException {
        this.repository = r;
        this.initializeM2();
    }

    public MDRModelImplementation() throws UmlException {
        this(MDRModelImplementation.getDefaultRepository());
        this.cleanExtents();
        this.createDefaultExtent();
        if (this.umlPackage == null) {
            throw new UmlException("Could not create UML extent");
        }
        LOG.debug((Object)"MDR Init - created UML extent");
        this.initializeFactories(this.umlPackage);
    }

    private static MDRepository getDefaultRepository() {
        LOG.debug((Object)"Starting MDR system initialization");
        String storageImplementation = System.getProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
        System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", storageImplementation);
        System.setProperty("MDRStorageProperty.org.netbeans.mdr.persistence.memoryimpl.id", UUIDManager.getInstance().getNewUUID());
        MDRepository defaultRepository = MDRManager.getDefault().getDefaultRepository();
        LOG.debug((Object)"MDR Init - got default repository");
        return defaultRepository;
    }

    private void initializeM2() throws UmlException {
        this.mofExtent = (ModelPackage)this.repository.getExtent(MOF_EXTENT_NAME);
        LOG.debug((Object)"MDR Init - tried to get MOF extent");
        if (this.mofExtent == null) {
            try {
                this.mofExtent = (ModelPackage)this.repository.createExtent(MOF_EXTENT_NAME);
            }
            catch (CreationFailedException e) {
                throw new UmlException(e);
            }
            LOG.debug((Object)"MDR Init - created MOF extent");
            XMIReader reader = XMIReaderFactory.getDefault().createXMIReader();
            LOG.debug((Object)"MDR Init - created XMI reader");
            String metafacade = System.getProperty("argouml.model.mdr.facade", METAMODEL_URL);
            URL resource = this.getClass().getResource(metafacade);
            try {
                reader.read(resource.toString(), (RefPackage)this.mofExtent);
            }
            catch (IOException e) {
                throw new UmlException(e);
            }
            catch (MalformedXMIException e) {
                throw new UmlException(e);
            }
            LOG.debug((Object)"MDR Init - read UML metamodel");
        }
        this.mofPackage = null;
        for (MofPackage pkg : this.mofExtent.getMofPackage().refAllOfClass()) {
            if (!"UML".equals(pkg.getName())) continue;
            this.mofPackage = pkg;
            break;
        }
    }

    public void initializeFactories(UmlPackage up) {
        this.umlPackage = up;
        this.theModelEventPump = new ModelEventPumpMDRImpl(this, this.repository);
        this.theModelEventPump.startPumpingEvents();
        LOG.debug((Object)"MDR Init - event pump started");
        this.theDataTypesFactory = new DataTypesFactoryMDRImpl(this);
        this.theDataTypesHelper = new DataTypesHelperMDRImpl(this);
        this.theKindsObject = new KindsMDRImpl(this);
        this.theMessageSort = new MessageSortMDRImpl();
        this.theModelManagementFactory = new ModelManagementFactoryMDRImpl(this);
        this.theExtensionMechanismsHelper = new ExtensionMechanismsHelperMDRImpl(this);
        this.theExtensionMechanismsFactory = new ExtensionMechanismsFactoryMDRImpl(this);
        LOG.debug((Object)"MDR Init - initialized package Extension mechanism");
        this.theCopyHelper = new org.argouml.model.mdr.CopyHelper(this);
        this.theActivityGraphsHelper = new ActivityGraphsHelperMDRImpl();
        this.theCoreHelper = new UndoCoreHelperDecorator(new CoreHelperMDRImpl(this));
        LOG.debug((Object)"MDR Init - initialized package Core helper");
        this.theModelManagementHelper = new ModelManagementHelperMDRImpl(this);
        this.theStateMachinesHelper = new StateMachinesHelperMDRImpl(this);
        LOG.debug((Object)"MDR Init - initialized package StateMachines");
        this.theUseCasesFactory = new UseCasesFactoryMDRImpl(this);
        this.theUseCasesHelper = new UseCasesHelperMDRImpl(this);
        LOG.debug((Object)"MDR Init - initialized package Use Cases");
        this.theActivityGraphsFactory = new ActivityGraphsFactoryMDRImpl(this);
        LOG.debug((Object)"MDR Init - initialized package Collaborations");
        this.theCommonBehaviorFactory = new CommonBehaviorFactoryMDRImpl(this);
        this.theCommonBehaviorHelper = new CommonBehaviorHelperMDRImpl(this);
        LOG.debug((Object)"MDR Init - initialized package CommonBehavior");
        this.theStateMachinesFactory = new StateMachinesFactoryMDRImpl(this);
        this.theCoreFactory = new CoreFactoryMDRImpl(this);
        LOG.debug((Object)"MDR Init - all packages initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RefPackage createDefaultExtent() {
        Map<UmlPackage, Extent> map = this.extents;
        synchronized (map) {
            this.umlPackage = (UmlPackage)this.repository.getExtent(MODEL_EXTENT_NAME);
            if (this.umlPackage != null) {
                try {
                    UmlPackage oldPackage = this.umlPackage;
                    this.umlPackage = null;
                    this.deleteExtentUnchecked(oldPackage);
                    LOG.debug((Object)"MDR Init - UML extent existed - deleted it and all UML data");
                }
                catch (InvalidObjectException e) {
                    LOG.debug((Object)"Got error deleting old default user extent");
                }
            }
            this.umlPackage = (UmlPackage)this.createExtent(MODEL_EXTENT_NAME, false);
            LOG.debug((Object)"Created default extent");
            return this.umlPackage;
        }
    }

    public void shutdown() {
        this.theModelEventPump.flushModelEvents();
        this.theModelEventPump.stopPumpingEvents();
        MDRManager.getDefault().shutdownAll();
    }

    @Override
    public DiagramInterchangeModel getDiagramInterchangeModel() {
        return null;
    }

    @Override
    public Facade getFacade() {
        if (this.theFacade == null) {
            this.theFacade = new FacadeMDRImpl(this);
        }
        return this.theFacade;
    }

    @Override
    public ModelEventPump getModelEventPump() {
        return this.theModelEventPump;
    }

    @Override
    public ActivityGraphsFactory getActivityGraphsFactory() {
        return this.theActivityGraphsFactory;
    }

    @Override
    public ActivityGraphsHelper getActivityGraphsHelper() {
        return this.theActivityGraphsHelper;
    }

    @Override
    public CollaborationsFactory getCollaborationsFactory() {
        if (this.theCollaborationsFactory == null) {
            this.theCollaborationsFactory = new CollaborationsFactoryMDRImpl(this);
        }
        return this.theCollaborationsFactory;
    }

    @Override
    public CollaborationsHelper getCollaborationsHelper() {
        if (this.theCollaborationsHelper == null) {
            this.theCollaborationsHelper = new CollaborationsHelperMDRImpl(this);
        }
        return this.theCollaborationsHelper;
    }

    @Override
    public CommonBehaviorFactory getCommonBehaviorFactory() {
        return this.theCommonBehaviorFactory;
    }

    @Override
    public CommonBehaviorHelper getCommonBehaviorHelper() {
        return this.theCommonBehaviorHelper;
    }

    @Override
    public CopyHelper getCopyHelper() {
        return this.theCopyHelper;
    }

    @Override
    public CoreFactory getCoreFactory() {
        return this.theCoreFactory;
    }

    @Override
    public CoreHelper getCoreHelper() {
        return this.theCoreHelper;
    }

    @Override
    public DataTypesFactory getDataTypesFactory() {
        return this.theDataTypesFactory;
    }

    DataTypesFactoryMDRImpl getDataTypesFactoryInternal() {
        return this.theDataTypesFactory;
    }

    @Override
    public DataTypesHelper getDataTypesHelper() {
        return this.theDataTypesHelper;
    }

    @Override
    public ExtensionMechanismsFactory getExtensionMechanismsFactory() {
        return this.theExtensionMechanismsFactory;
    }

    @Override
    public ExtensionMechanismsHelper getExtensionMechanismsHelper() {
        return this.theExtensionMechanismsHelper;
    }

    @Override
    public ModelManagementFactory getModelManagementFactory() {
        return this.theModelManagementFactory;
    }

    @Override
    public ModelManagementHelper getModelManagementHelper() {
        return this.theModelManagementHelper;
    }

    @Override
    public StateMachinesFactory getStateMachinesFactory() {
        return this.theStateMachinesFactory;
    }

    @Override
    public StateMachinesHelper getStateMachinesHelper() {
        return this.theStateMachinesHelper;
    }

    @Override
    public UmlFactory getUmlFactory() {
        if (this.theUmlFactory == null) {
            this.theUmlFactory = new UmlFactoryMDRImpl(this);
        }
        return this.theUmlFactory;
    }

    @Override
    public UmlHelper getUmlHelper() {
        if (this.theUmlHelper == null) {
            this.theUmlHelper = new UmlHelperMDRImpl(this);
        }
        return this.theUmlHelper;
    }

    @Override
    public UseCasesFactory getUseCasesFactory() {
        return this.theUseCasesFactory;
    }

    @Override
    public UseCasesHelper getUseCasesHelper() {
        return this.theUseCasesHelper;
    }

    @Override
    public MetaTypes getMetaTypes() {
        return this.theMetaTypes;
    }

    @Override
    public ChangeableKind getChangeableKind() {
        return this.theKindsObject;
    }

    @Override
    public AggregationKind getAggregationKind() {
        return this.theKindsObject;
    }

    @Override
    public PseudostateKind getPseudostateKind() {
        return this.theKindsObject;
    }

    @Override
    public ScopeKind getScopeKind() {
        return this.theKindsObject;
    }

    @Override
    public ConcurrencyKind getConcurrencyKind() {
        return this.theKindsObject;
    }

    @Override
    public DirectionKind getDirectionKind() {
        return this.theKindsObject;
    }

    @Override
    public OrderingKind getOrderingKind() {
        return this.theKindsObject;
    }

    @Override
    public MessageSort getMessageSort() {
        return this.theMessageSort;
    }

    @Override
    public VisibilityKind getVisibilityKind() {
        return this.theKindsObject;
    }

    @Override
    public XmiReader getXmiReader() throws UmlException {
        XmiReaderImpl reader = new XmiReaderImpl(this);
        return reader;
    }

    @Override
    public XmiWriter getXmiWriter(Object model, OutputStream stream, String version) throws UmlException {
        return new XmiWriterMDRImpl(this, model, stream, version);
    }

    Map<String, XmiReference> getObjectToId() {
        return this.objectToId;
    }

    Map<String, Map<String, Object>> getIdToObject() {
        return this.idToObject;
    }

    boolean removeElement(String mofId) {
        Object o;
        Map<String, Object> m;
        XmiReference xref = this.objectToId.remove(mofId);
        if (xref != null && (m = this.idToObject.get(xref.getSystemId())) != null && (o = m.remove(xref.getXmiId())) != null) {
            if (!mofId.equals(((RefObject)o).refMofId())) {
                LOG.error((Object)("Internal index inconsistency for mof ID " + mofId + " (got " + ((RefObject)o).refMofId()));
            }
            return true;
        }
        LOG.debug((Object)("Failed to remove index entries for mof ID " + mofId));
        return false;
    }

    Map<String, String> getPublic2SystemIds() {
        return this.public2SystemIds;
    }

    void addSearchPath(String path) {
        this.searchDirs.add(path);
    }

    void removeSearchPath(String path) {
        this.searchDirs.remove(path);
    }

    List<String> getSearchPath() {
        return this.searchDirs;
    }

    private class Extent {
        int refCount = 0;
        boolean readOnly = false;
        String name;

        Extent(String name, boolean readOnly) {
            this.name = name;
            this.readOnly = readOnly;
        }

        int getRefCount() {
            return this.refCount;
        }

        synchronized int decrementCount() {
            return this.refCount--;
        }

        synchronized int incrementCount() {
            return this.refCount++;
        }
    }
}

