/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.injection.lib;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class TypeTracer {
    public static final String TRACE_TYPES = "tudresden.ocl.injection.lib.TypeTracer.traceTypes";
    private static final HashMap element_types = new HashMap();
    private static final HashMap key_types = new HashMap();
    private String attr;
    private HashSet types_all = new HashSet();
    private HashSet types_minima = new HashSet();
    public static final char SEPARATOR = '\t';
    public static final char ADD_ALL = '*';
    public static final char ADD_MINIMA = '+';
    public static final char REMOVE_MINIMA = '-';
    public static final char COMMENT = '#';
    private static PrintStream log = System.out;

    public static void traceTypes(String attr, Collection c) {
        if (c != null) {
            TypeTracer.traceTypes(attr, c.iterator(), element_types, "element-type");
        }
    }

    public static void traceTypes(String attr, Map m) {
        if (m != null) {
            TypeTracer.traceTypes(attr, m.values().iterator(), element_types, "element-type");
            TypeTracer.traceTypes(attr, m.keySet().iterator(), key_types, "key-type");
        }
    }

    private static void traceTypes(String attr, Iterator i, HashMap types, String kind) {
        TypeTracer tt = (TypeTracer)types.get(attr);
        if (tt == null) {
            tt = new TypeTracer(attr);
            types.put(attr, tt);
        }
        tt.traceTypes(i, kind);
    }

    private TypeTracer(String attr) {
        this.attr = attr;
    }

    private void traceTypes(Iterator iterator, String kind) {
        boolean usedLog = false;
        block0: while (iterator.hasNext()) {
            Class<?> c = iterator.next().getClass();
            if (this.types_all.contains(c)) continue;
            this.types_all.add(c);
            log.print('*');
            log.print(this.attr);
            log.print('\t');
            log.print(kind);
            log.print('\t');
            log.println(c.getName());
            usedLog = true;
            boolean gets_in = false;
            Iterator i = this.types_minima.iterator();
            while (i.hasNext()) {
                Class i_minima = (Class)i.next();
                if (i_minima.isAssignableFrom(c)) {
                    if (!gets_in) continue block0;
                    throw new RuntimeException();
                }
                if (!c.isAssignableFrom(i_minima)) continue;
                i.remove();
                log.print('-');
                log.print(this.attr);
                log.print('\t');
                log.print(kind);
                log.print('\t');
                log.println(i_minima.getName());
                gets_in = true;
            }
            this.types_minima.add(c);
            log.print('+');
            log.print(this.attr);
            log.print('\t');
            log.print(kind);
            log.print('\t');
            log.println(c.getName());
        }
        if (usedLog) {
            log.flush();
        }
    }

    static {
        String logfile = System.getProperty("tudresden.ocl.injection.lib.TypeTracer.log");
        if (logfile != null) {
            try {
                log = new PrintStream(new FileOutputStream(logfile));
            }
            catch (FileNotFoundException e) {
                System.out.println("could not open type tracer log: " + e);
            }
        }
    }
}

