/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import tudresden.ocl.lib.Ocl;
import tudresden.ocl.lib.OclAddable;
import tudresden.ocl.lib.OclAny;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclComparable;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclInteger;
import tudresden.ocl.lib.OclMultiplyable;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclSubtractable;
import tudresden.ocl.lib.OclType;

public class OclReal
extends OclAny
implements OclSubtractable,
OclMultiplyable,
OclAddable,
OclComparable,
Comparable {
    private double dValue;

    public OclReal(double d) {
        this.dValue = d;
    }

    public OclReal(float f) {
        this((double)f);
    }

    public OclReal(int dummy, String reason) {
        super(dummy, reason);
        this.dValue = Double.NaN;
    }

    public OclBoolean isEqualTo(Object o) {
        OclReal or = this.toOclReal(o, "OclReal isEqualTo()");
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (or.isUndefined()) {
            return new OclBoolean(0, or.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.getDouble() == or.getDouble());
    }

    public OclBoolean isNotEqualTo(Object o) {
        return this.isEqualTo(o).not();
    }

    public OclAddable add(OclAddable a) {
        if (a instanceof OclReal) {
            return this.add((OclReal)a);
        }
        return this.toOclReal(a, "OclReal add()");
    }

    public OclReal add(OclReal or) {
        if (this.isUndefined()) {
            return this;
        }
        if (or.isUndefined()) {
            return or;
        }
        return new OclReal(this.getDouble() + or.getDouble());
    }

    public OclSubtractable subtract(OclSubtractable s) {
        if (s instanceof OclReal) {
            return this.subtract((OclReal)s);
        }
        return this.toOclReal(s, "OclReal subtract()");
    }

    public OclReal negative() {
        if (this.isUndefined()) {
            return this;
        }
        return new OclReal(-this.getDouble());
    }

    public OclReal subtract(OclReal or) {
        if (this.isUndefined()) {
            return this;
        }
        if (or.isUndefined()) {
            return or;
        }
        return new OclReal(this.getDouble() - or.getDouble());
    }

    public OclMultiplyable multiply(OclMultiplyable m) {
        if (m instanceof OclReal) {
            return this.multiply((OclReal)m);
        }
        return this.toOclReal(m, "OclReal multiply()");
    }

    public OclReal multiply(OclReal or) {
        if (this.isUndefined()) {
            return this;
        }
        if (or.isUndefined()) {
            return or;
        }
        return new OclReal(this.getDouble() * or.getDouble());
    }

    public OclMultiplyable divide(OclMultiplyable m) {
        if (m instanceof OclReal) {
            return this.divide((OclReal)m);
        }
        return this.toOclReal(m, "OclReal divide()");
    }

    public OclReal divide(OclReal or) {
        if (this.isUndefined()) {
            return this;
        }
        if (or.isUndefined()) {
            return or;
        }
        return new OclReal(this.getDouble() / or.getDouble());
    }

    public OclReal abs() {
        if (this.isUndefined()) {
            return this;
        }
        return new OclReal(Math.abs(this.getDouble()));
    }

    public OclInteger floor() {
        if (this.isUndefined()) {
            return new OclInteger(0, this.getUndefinedReason());
        }
        return new OclInteger((long)Math.floor(this.getDouble()));
    }

    public OclInteger round() {
        if (this.isUndefined()) {
            return new OclInteger(0, this.getUndefinedReason());
        }
        return new OclInteger(Math.round(this.getDouble()));
    }

    public OclReal max(OclReal r) {
        if (this.isUndefined()) {
            return this;
        }
        if (r.isUndefined()) {
            return r;
        }
        return new OclReal(Math.max(this.getDouble(), r.getDouble()));
    }

    public OclReal min(OclReal r) {
        if (this.isUndefined()) {
            return this;
        }
        if (r.isUndefined()) {
            return r;
        }
        return new OclReal(Math.min(this.getDouble(), r.getDouble()));
    }

    public int compareTo(Object o) {
        double dOther;
        OclReal or = (OclReal)o;
        if (this.isUndefined()) {
            throw new OclException("tried to compare undefined OclReal value: " + this.getUndefinedReason());
        }
        if (or.isUndefined()) {
            throw new OclException("tried to compare undefined OclReal value: " + or.getUndefinedReason());
        }
        double dThis = this.getDouble();
        if (dThis > (dOther = or.getDouble())) {
            return 1;
        }
        if (dThis < dOther) {
            return -1;
        }
        return 0;
    }

    public OclBoolean isLessThan(OclComparable c) {
        OclReal or = this.toOclReal(c, "OclReal isLessThan()");
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (or.isUndefined()) {
            return new OclBoolean(0, or.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.getDouble() < or.getDouble());
    }

    public OclBoolean isGreaterThan(OclComparable c) {
        OclReal or = this.toOclReal(c, "OclReal isLessThan()");
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (or.isUndefined()) {
            return new OclBoolean(0, or.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.getDouble() > or.getDouble());
    }

    public OclBoolean isLessEqual(OclComparable c) {
        OclReal or = this.toOclReal(c, "OclReal isLessThan()");
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (or.isUndefined()) {
            return new OclBoolean(0, or.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.getDouble() <= or.getDouble());
    }

    public OclBoolean isGreaterEqual(OclComparable c) {
        OclReal or = this.toOclReal(c, "OclReal isLessThan()");
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (or.isUndefined()) {
            return new OclBoolean(0, or.getUndefinedReason());
        }
        return Ocl.getOclRepresentationFor(this.getDouble() >= or.getDouble());
    }

    public double getDouble() {
        if (this.isUndefined()) {
            throw new OclException("tried to read value of undefined OclReal: " + this.getUndefinedReason());
        }
        return this.dValue;
    }

    public OclRoot getFeature(String name) {
        return new OclReal(0, "feature " + name + " of OclBoolean requested");
    }

    /*
     * WARNING - void declaration
     */
    private OclReal toOclReal(Object o, String methodname) {
        try {
            void cce;
            OclReal ret = (OclReal)o;
            return cce;
        }
        catch (Exception cce) {
            return new OclReal(0, methodname + " called with non-OclReal parameter");
        }
    }

    public OclType oclType() {
        if (this.isUndefined()) {
            return new OclType(0, this.getUndefinedReason());
        }
        return OclType.typeReal;
    }
}

