/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Random;
import java.util.StringTokenizer;

public class UUID
implements Comparable,
Serializable {
    public static final int STRING_LENGTH = 36;
    private int timeLow;
    private short timeMid;
    private short timeHiAndVersion;
    private byte clockSeqHiAndReserved;
    private byte clockSeqLow;
    private byte[] nodeId;

    public UUID() {
        this.nodeId = new byte[6];
        this.generate();
    }

    public UUID(String str) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(str, "-", true);
        this.nodeId = new byte[6];
        try {
            this.timeLow = (int)Long.parseLong(st.nextToken(), 16);
            if (!st.nextToken().equals("-")) {
                throw new NumberFormatException();
            }
            this.timeMid = (short)Integer.parseInt(st.nextToken(), 16);
            if (!st.nextToken().equals("-")) {
                throw new NumberFormatException();
            }
            this.timeHiAndVersion = (short)Integer.parseInt(st.nextToken(), 16);
            if (!st.nextToken().equals("-")) {
                throw new NumberFormatException();
            }
            short clock = (short)Integer.parseInt(st.nextToken(), 16);
            this.clockSeqHiAndReserved = (byte)(clock >> 8 & 0xFF);
            this.clockSeqLow = (byte)(clock & 0xFF);
            if (!st.nextToken().equals("-")) {
                throw new NumberFormatException();
            }
            String node = st.nextToken();
            for (int i = 0; i < 6; ++i) {
                this.nodeId[i] = (byte)Integer.parseInt(node.substring(i * 2, i * 2 + 2), 16);
            }
        }
        catch (Exception ex) {
            throw new NumberFormatException();
        }
    }

    private void generate() {
        UUIDGenerator gener = UUIDGenerator.create();
        gener.generate(this);
    }

    public String toString() {
        Object[] nodeArgs = new Object[]{UUID.toHex(this.nodeId[0]), UUID.toHex(this.nodeId[1]), UUID.toHex(this.nodeId[2]), UUID.toHex(this.nodeId[3]), UUID.toHex(this.nodeId[4]), UUID.toHex(this.nodeId[5])};
        String nodeString = MessageFormat.format("{0}{1}{2}{3}{4}{5}", nodeArgs);
        Object[] args = new Object[]{UUID.toHex(this.timeLow), UUID.toHex(this.timeMid), UUID.toHex(this.timeHiAndVersion), UUID.toHex(this.clockSeqHiAndReserved), UUID.toHex(this.clockSeqLow), nodeString};
        return MessageFormat.format("{0}-{1}-{2}-{3}{4}-{5}", args);
    }

    public boolean equals(Object o) {
        if (!(o instanceof UUID)) {
            return false;
        }
        UUID other = (UUID)o;
        return other.timeLow == this.timeLow && other.timeMid == this.timeMid && other.timeHiAndVersion == this.timeHiAndVersion && other.clockSeqHiAndReserved == this.clockSeqHiAndReserved && other.clockSeqLow == this.clockSeqLow && other.nodeId[0] == this.nodeId[0] && other.nodeId[1] == this.nodeId[1] && other.nodeId[2] == this.nodeId[2] && other.nodeId[3] == this.nodeId[3] && other.nodeId[4] == this.nodeId[4] && other.nodeId[5] == this.nodeId[5];
    }

    public int compareTo(Object o) {
        if (!(o instanceof UUID)) {
            throw new ClassCastException();
        }
        UUID other = (UUID)o;
        if (other.timeLow != this.timeLow) {
            return this.timeLow - other.timeLow;
        }
        if (other.timeMid != this.timeMid) {
            return this.timeMid - other.timeMid;
        }
        if (other.timeHiAndVersion != this.timeHiAndVersion) {
            return this.timeHiAndVersion - other.timeHiAndVersion;
        }
        if (other.clockSeqHiAndReserved != this.clockSeqHiAndReserved) {
            return this.clockSeqHiAndReserved - other.clockSeqHiAndReserved;
        }
        if (other.clockSeqLow != this.clockSeqLow) {
            return this.clockSeqLow - other.clockSeqLow;
        }
        for (int i = 0; i < 6; ++i) {
            if (other.nodeId[i] == this.nodeId[i]) continue;
            return this.nodeId[i] - other.nodeId[i];
        }
        return 0;
    }

    public int hashCode() {
        return this.timeLow;
    }

    private static String toHex(byte num) {
        return UUID.toHex(num & 0xFF, 2);
    }

    private static String toHex(short num) {
        return UUID.toHex(num & 0xFFFF, 4);
    }

    private static String toHex(int num) {
        return UUID.toHex(num, 8);
    }

    private static String toHex(int num, int digits) {
        String hex = Integer.toHexString(num);
        if (hex.length() < digits) {
            StringBuffer sb = new StringBuffer();
            int toAdd = digits - hex.length();
            for (int i = 0; i < toAdd; ++i) {
                sb.append('0');
            }
            sb.append(hex);
            hex = sb.toString();
        }
        return hex.toUpperCase();
    }

    private static class UUIDGenerator {
        private static UUIDGenerator theGenerator;
        private Random random1 = new Random(this.hashCode());
        private Random random2 = new Random(Thread.currentThread().hashCode());
        private long lastTime;
        private long timeAdjust;
        private int clockSequence;
        private byte[] nodeId = new byte[6];
        private static final int CLOCK_SEQ_MASK = 16383;
        private static final int VERSION_BITS = 4096;
        private static final int RESERVED_BITS = 128;
        private static final int TIME_ADJUST_MASK = 4095;
        private static final long N100NS_PER_MILLI = 10000L;
        private static final long EPOCH_CVT = 122192928000000000L;

        public static synchronized UUIDGenerator create() {
            if (theGenerator == null) {
                theGenerator = new UUIDGenerator();
            }
            return theGenerator;
        }

        private UUIDGenerator() {
            this.initializeNodeId();
            this.getClockSequence();
        }

        public synchronized void generate(UUID uuid) {
            long now = System.currentTimeMillis();
            while (true) {
                if (now > this.lastTime) {
                    this.getTimeAdjust();
                    break;
                }
                if (now < this.lastTime) {
                    this.getClockSequence();
                    this.getTimeAdjust();
                    break;
                }
                ++this.timeAdjust;
                if (this.timeAdjust < 10000L) break;
                Thread.yield();
            }
            this.lastTime = now;
            long result = this.lastTime * 10000L + 122192928000000000L + this.timeAdjust;
            uuid.timeLow = (int)(result & 0xFFFFFFFFFFFFFFFFL);
            uuid.timeMid = (short)(result >> 32 & 0xFFFFL);
            uuid.timeHiAndVersion = (short)(result >> 48 & 0xFFFFL | 0x1000L);
            uuid.clockSeqHiAndReserved = (byte)(this.clockSequence >> 8 & 0xFF | 0x80);
            uuid.clockSeqLow = (byte)(this.clockSequence & 0xFF);
            for (int i = 0; i < 6; ++i) {
                ((UUID)uuid).nodeId[i] = this.nodeId[i];
            }
        }

        private void getTimeAdjust() {
            this.timeAdjust = this.random2.nextInt() & 0xFFF;
        }

        private void getClockSequence() {
            this.clockSequence = this.random1.nextInt() & 0x3FFF;
            if (this.clockSequence == 0) {
                ++this.clockSequence;
            }
        }

        private void initializeNodeId() {
            byte[] barr = new byte[2];
            Random r1 = new Random();
            Random r2 = new Random(r1.hashCode());
            r1.nextBytes(barr);
            this.nodeId[0] = barr[0];
            this.nodeId[1] = barr[1];
            r2.nextBytes(barr);
            this.nodeId[2] = barr[0];
            this.nodeId[3] = barr[1];
            this.nodeId[4] = -86;
            this.nodeId[5] = 119;
        }
    }
}

