/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.uml.ui.AbstractActionAddModelElement2;
import org.argouml.uml.ui.AbstractActionNewModelElement;
import org.argouml.uml.ui.AbstractActionRemoveElement;

class UMLObjectFlowStateParameterListModel
extends UMLModelElementListModel {
    private static final long serialVersionUID = -6095531893213309195L;

    public UMLObjectFlowStateParameterListModel(Object modelElement, String propertyName) {
        super(propertyName, modelElement.getClass(), new ActionAddOFSParameter(), new ActionNewOFSParameter(), new ActionRemoveOFSParameter());
        this.setTarget(modelElement);
    }

    protected void buildModelList() {
        if (this.getTarget() != null) {
            this.setAllElements(Model.getFacade().getParameters(this.getTarget()));
        }
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().getParameters(this.getTarget()).contains(element);
    }

    private static class ActionRemoveOFSParameter
    extends AbstractActionRemoveElement {
        public ActionRemoveOFSParameter() {
            super(Translator.localize((String)"menu.popup.remove"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Object param = this.getObjectToRemove();
            if (param != null) {
                Object t = this.getTarget();
                if (Model.getFacade().isAObjectFlowState(t)) {
                    Model.getActivityGraphsHelper().removeParameter(t, param);
                }
            }
        }
    }

    private static class ActionNewOFSParameter
    extends AbstractActionNewModelElement {
        private ActionNewOFSParameter() {
        }

        public void actionPerformed(ActionEvent e) {
            Object target = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(target)) {
                Object type = ActionNewOFSParameter.getType(target);
                Object parameter = Model.getCoreFactory().createParameter();
                Model.getCoreHelper().setType(parameter, type);
                Model.getActivityGraphsHelper().addParameter(target, parameter);
            }
        }

        private static Object getType(Object target) {
            Object type = Model.getFacade().getType(target);
            if (Model.getFacade().isAClassifierInState(type)) {
                type = Model.getFacade().getType(type);
            }
            return type;
        }
    }

    private static class ActionAddOFSParameter
    extends AbstractActionAddModelElement2 {
        private Object choiceClass = Model.getMetaTypes().getParameter();

        public ActionAddOFSParameter() {
            this.setMultiSelect(true);
        }

        protected void doIt(Collection selected) {
            Object t = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(t)) {
                Model.getActivityGraphsHelper().setParameters(t, selected);
            }
        }

        protected List getChoices() {
            ArrayList ret = new ArrayList();
            Object t = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(t)) {
                Object classifier = ActionAddOFSParameter.getType(t);
                if (Model.getFacade().isAClassifier(classifier)) {
                    ret.addAll(Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(classifier, this.choiceClass));
                }
            }
            return ret;
        }

        protected String getDialogTitle() {
            return Translator.localize((String)"dialog.title.add-state");
        }

        protected List getSelected() {
            Object t = this.getTarget();
            if (Model.getFacade().isAObjectFlowState(t)) {
                return new ArrayList(Model.getFacade().getParameters(t));
            }
            return new ArrayList();
        }

        private static Object getType(Object target) {
            Object type = Model.getFacade().getType(target);
            if (Model.getFacade().isAClassifierInState(type)) {
                type = Model.getFacade().getType(type);
            }
            return type;
        }
    }
}

