/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.language.cpp.generator.AssociationEndHandler;
import org.argouml.language.cpp.generator.Inline;
import org.argouml.language.cpp.generator.Section;
import org.argouml.model.Model;
import org.argouml.uml.DocumentationManager;
import org.argouml.uml.UUIDHelper;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.SourceUnit;

public class GeneratorCpp
implements CodeGenerator {
    private static final Logger LOG = Logger.getLogger(GeneratorCpp.class);
    static final String LANGUAGE_NAME = "cpp";
    private boolean verboseDocs = false;
    private boolean lfBeforeCurly = false;
    private String indent = "    ";
    private boolean hdrGuardUpperCase = false;
    private boolean hdrGuardGUID = false;
    private static final ConfigurationKey KEY_CPP_INDENT = Configuration.makeKey((String)"cpp", (String)"indent");
    private static final ConfigurationKey KEY_CPP_LF_BEFORE_CURLY = Configuration.makeKey((String)"cpp", (String)"lf-before-curly");
    private static final ConfigurationKey KEY_CPP_VERBOSE_COMM = Configuration.makeKey((String)"cpp", (String)"verbose-comments");
    private static final ConfigurationKey KEY_CPP_SECT = Configuration.makeKey((String)"cpp", (String)"sections");
    private static final ConfigurationKey KEY_CPP_HEADER_GUARD_UPPERCASE = Configuration.makeKey((String)"cpp", (String)"header-guard-case");
    private static final ConfigurationKey KEY_CPP_HEADER_GUARD_GUID = Configuration.makeKey((String)"cpp", (String)"header-guard-guid");
    private static final ConfigurationKey KEY_CPP_DEFAULT_INLINE = Configuration.makeKey((String)"cpp", (String)"default-inline");
    private static Section sect;
    private Object actualNamespace;
    private Object currClass = null;
    private Set localInc = new TreeSet();
    private Set extInc = new TreeSet();
    private Set systemInc = new TreeSet();
    private Set includeCls = new LinkedHashSet();
    private Set predeclCls = new LinkedHashSet();
    private static final String LINE_SEPARATOR;
    private static final int PUBLIC_PART = 0;
    private static final int PROTECTED_PART = 1;
    private static final int PRIVATE_PART = 2;
    private static final int[] ALL_PARTS;
    private static final String[] PART_NAME;
    private static final int NONE_PASS = 1;
    private static final int HEADER_PASS = 2;
    private static final int SOURCE_PASS = 3;
    private static int generatorPass;
    private static final int DOC_COMMENT_TAGS = 1;
    private static final int ALL_BUT_DOC_TAGS = 2;
    private static final int ALL_TAGS = 3;
    private static final int NORMAL_MOD = 0;
    private static final int REFERENCE_MOD = 1;
    private static final int POINTER_MOD = 2;
    private static final int CONST_MOD = 3;
    private static GeneratorCpp singleton;
    private String stdPrefix = "std::";
    private Set generatedFiles = null;
    private int generateRecur = 0;

    public static synchronized GeneratorCpp getInstance() {
        if (singleton != null) {
            return singleton;
        }
        return new GeneratorCpp();
    }

    protected GeneratorCpp() {
        singleton = this;
        this.loadConfig();
    }

    protected void cleanupGenerator() {
        this.localInc.clear();
        this.extInc.clear();
        this.systemInc.clear();
        this.includeCls.clear();
        this.predeclCls.clear();
        this.currClass = null;
        this.actualNamespace = null;
    }

    protected void setupGenerator(Object cls) {
        this.cleanupGenerator();
        this.currClass = cls;
    }

    private String generateFileAsString(Object o, String pathname) {
        this.setupGenerator(o);
        if (generatorPass == 3 && Model.getFacade().isAInterface(o)) {
            return "";
        }
        String headerTop = this.generateHeaderTop(pathname);
        String header = this.generateHeader(o);
        String src = this.generateClassifier(o);
        String inlinedMethods = null;
        if (generatorPass == 2) {
            inlinedMethods = this.generateInlinedMethodsOutsideClass(o);
        }
        String footer = this.generateFooter();
        StringBuffer incl = new StringBuffer();
        if (generatorPass == 3) {
            this.localInc.add(Model.getFacade().getName(o) + ".h");
        }
        this.generateIncludes(incl);
        if (generatorPass == 2) {
            if (incl.length() > 0) {
                incl.append(LINE_SEPARATOR);
            }
            this.generatePredeclare(incl);
        }
        StringBuffer result = new StringBuffer();
        String guard = new String();
        if (generatorPass == 2) {
            String name = Model.getFacade().getName(o);
            String guardPack = this.generateRelativePackage(o, null, "_").substring(1);
            guard = name + this.getFileExtension().replace('.', '_');
            if (guardPack.length() > 0) {
                guard = guardPack + "_" + guard;
            }
            if (this.hdrGuardGUID) {
                guard = guard + "_" + UUID.randomUUID().toString().replace("-", "_");
            }
            if (this.hdrGuardUpperCase) {
                guard = guard.toUpperCase();
            }
            result.append("#ifndef " + guard + LINE_SEPARATOR + "#define " + guard + LINE_SEPARATOR + LINE_SEPARATOR);
        }
        result.append(headerTop);
        result.append(incl.toString());
        result.append(header);
        result.append(src);
        if (generatorPass == 2 && inlinedMethods != null) {
            result.append(inlinedMethods);
        }
        result.append(footer);
        if (generatorPass == 2) {
            result.append(LINE_SEPARATOR);
            result.append("#endif // " + guard);
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    String generateCpp(Object o) {
        generatorPass = 3;
        String name = this.generateRelativePackage(o, null, "/").substring(1);
        if (name.length() > 0) {
            name = name + "/";
        }
        name = name + Model.getFacade().getName(o) + ".cpp";
        String ret = this.generateFileAsString(o, name);
        this.cleanupGenerator();
        generatorPass = 1;
        return ret;
    }

    String generateH(Object o) {
        generatorPass = 2;
        String name = this.generateRelativePackage(o, null, "/").substring(1);
        if (name.length() > 0) {
            name = name + "/";
        }
        name = name + Model.getFacade().getName(o) + ".h";
        String ret = this.generateFileAsString(o, name);
        this.cleanupGenerator();
        generatorPass = 1;
        return ret;
    }

    private String generateRelativePackage(Object cls, Object pack, String sep) {
        StringBuffer packagePath = new StringBuffer();
        Object parent = Model.getFacade().getNamespace(cls);
        while (parent != null && parent != pack) {
            Object grandParent = Model.getFacade().getNamespace(parent);
            if (grandParent != null) {
                String name = Model.getFacade().getName(parent);
                if (packagePath.length() > 0) {
                    packagePath.insert(0, sep);
                }
                packagePath.insert(0, name);
            }
            parent = grandParent;
        }
        if (parent == null) {
            packagePath.insert(0, sep);
        }
        return packagePath.toString();
    }

    private String getFileExtension() {
        if (generatorPass == 2) {
            return ".h";
        }
        return ".cpp";
    }

    private String generatePath(Object cls) {
        String packagePath = this.generateRelativePackage(cls, null, CodeGenerator.FILE_SEPARATOR);
        packagePath = packagePath.substring(1);
        return packagePath;
    }

    private String createDirectoriesPathname(Object cls, String path) {
        String name = Model.getFacade().getName(cls);
        if (name == null || name.length() == 0) {
            return "";
        }
        if (!path.endsWith(CodeGenerator.FILE_SEPARATOR)) {
            path = path + CodeGenerator.FILE_SEPARATOR;
        }
        String packagePath = this.generateRelativePackage(cls, null, ".");
        packagePath = packagePath.substring(1);
        String filename = name + this.getFileExtension();
        int lastIndex = -1;
        while (true) {
            File f;
            if (!(f = new File(path)).isDirectory() && !f.mkdir()) {
                LOG.error((Object)(" could not make directory " + path));
                return null;
            }
            if (lastIndex == packagePath.length()) break;
            int index = packagePath.indexOf(".", lastIndex + 1);
            if (index == -1) {
                index = packagePath.length();
            }
            path = path + packagePath.substring(lastIndex + 1, index) + CodeGenerator.FILE_SEPARATOR;
            lastIndex = index;
        }
        String pathname = path + filename;
        return pathname;
    }

    private static boolean isAInnerClass(Object cls) {
        Object parent = Model.getFacade().getNamespace(cls);
        return parent != null && !Model.getFacade().isAPackage(parent);
    }

    private String getDate() {
        GregorianCalendar cal = new GregorianCalendar();
        DateFormat df = DateFormat.getDateInstance(2);
        return df.format(cal.getTime());
    }

    private String getYear() {
        GregorianCalendar cal = new GregorianCalendar();
        return Integer.toString(cal.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(Object cls, String path, BufferedWriter fos) {
        String templatePathName = path + "/templates/";
        String fileName = Model.getFacade().getName(cls);
        String tagTemplatePathName = Model.getFacade().getTaggedValueValue(cls, "TemplatePath");
        String authorTag = Model.getFacade().getTaggedValueValue(cls, "author");
        String emailTag = Model.getFacade().getTaggedValueValue(cls, "email");
        if (tagTemplatePathName != null && tagTemplatePathName.length() > 0) {
            templatePathName = tagTemplatePathName;
        }
        if (generatorPass == 2) {
            templatePathName = templatePathName + "header_template";
            fileName = fileName + ".h";
        } else {
            templatePathName = templatePathName + "cpp_template";
            fileName = fileName + ".cpp";
        }
        File templateFile = new File(templatePathName);
        if (templateFile.exists()) {
            boolean eof = false;
            BufferedReader templateFileReader = null;
            try {
                templateFileReader = new BufferedReader(new FileReader(templateFile.getAbsolutePath()));
                while (!eof) {
                    String lineStr = templateFileReader.readLine();
                    if (lineStr == null) {
                        eof = true;
                        continue;
                    }
                    StringBuffer line = new StringBuffer(lineStr);
                    this.replaceToken(line, "|FILENAME|", fileName);
                    this.replaceToken(line, "|DATE|", this.getDate());
                    this.replaceToken(line, "|YEAR|", this.getYear());
                    this.replaceToken(line, "|AUTHOR|", authorTag);
                    this.replaceToken(line, "|EMAIL|", emailTag);
                    fos.write(line + LINE_SEPARATOR);
                }
                templateFileReader.close();
            }
            catch (IOException exp) {
            }
            finally {
                try {
                    if (templateFileReader != null) {
                        templateFileReader.close();
                    }
                }
                catch (IOException exp) {
                    LOG.error((Object)("FAILED: " + templateFile.getPath()));
                }
            }
        }
    }

    private void replaceToken(StringBuffer line, String tokenName, String tokenValue) {
        int tokenStart = line.toString().indexOf(tokenName);
        if (tokenStart != -1 && tokenValue != null && tokenValue.length() > 0) {
            line.replace(tokenStart, tokenStart + tokenName.length(), tokenValue);
        }
    }

    private String generateHeaderTop(String pathname) {
        StringBuffer sb = new StringBuffer(80);
        if (this.verboseDocs) {
            sb.append("// FILE: ").append(pathname.replace('\\', '/'));
            sb.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private boolean checkInclude4UsageIndirection(boolean isIndirect, String usageTag) {
        if (isIndirect) {
            if (usageTag.indexOf("header") != -1) {
                return generatorPass == 2;
            }
            return generatorPass == 3;
        }
        return generatorPass == 2;
    }

    private boolean checkIncludeNeeded4Element(Object cls) {
        String usageTag = "";
        boolean predeclareCandidate = false;
        Iterator iter = Model.getFacade().getTaggedValues(cls);
        while (iter.hasNext()) {
            Object tv = iter.next();
            String tag = Model.getFacade().getTagOfTag(tv);
            if (tag == null) continue;
            if (tag.equals("usage")) {
                usageTag = Model.getFacade().getValueOfTag(tv);
            }
            if (tag.indexOf("reference") == -1 && !tag.equals("&") && tag.indexOf("pointer") == -1 && !tag.equals("*")) continue;
            predeclareCandidate = true;
        }
        return this.checkInclude4UsageIndirection(predeclareCandidate, usageTag);
    }

    private StringBuffer generateIncludes(StringBuffer sb) {
        for (String inc : this.systemInc) {
            sb.append("#include <");
            sb.append(inc).append('>').append(LINE_SEPARATOR);
        }
        if (this.systemInc.size() > 0) {
            sb.append(LINE_SEPARATOR);
        }
        for (String inc : this.extInc) {
            sb.append("#include <");
            sb.append(inc).append('>').append(LINE_SEPARATOR);
        }
        if (this.extInc.size() > 0) {
            sb.append(LINE_SEPARATOR);
        }
        for (String inc : this.localInc) {
            sb.append("#include \"").append(inc).append("\"" + LINE_SEPARATOR);
        }
        return sb;
    }

    private StringBuffer generatePredeclare(StringBuffer sb) {
        for (Object cls : this.predeclCls) {
            String name = Model.getFacade().getName(cls);
            sb.append(this.generateHeaderPackageStart(cls));
            sb.append("class ").append(name);
            sb.append(";").append(LINE_SEPARATOR);
        }
        sb.append(this.generateHeaderPackageEnd());
        return sb;
    }

    private void addUserHeaders(Object cls, boolean source) {
        Iterator iter = Model.getFacade().getTaggedValues(cls);
        String tagPrefix = source ? "source_incl" : "header_incl";
        while (iter.hasNext()) {
            Object tv = iter.next();
            String tag = Model.getFacade().getTagOfTag(tv);
            if (tag == null || !tag.equals(tagPrefix)) continue;
            String name = Model.getFacade().getValueOfTag(tv);
            if (name.length() > 2 && name.charAt(0) == '<') {
                this.systemInc.add(name.substring(1, name.length() - 1));
                continue;
            }
            if (name.length() > 2 && name.charAt(0) == '\"') {
                this.localInc.add(name.substring(1, name.length() - 1));
                continue;
            }
            if (name.length() <= 0) continue;
            this.localInc.add(name);
        }
    }

    private void addDependency(Object dep, boolean predecl) {
        if (generatorPass == 1) {
            return;
        }
        if (!Model.getFacade().isAClass(dep) && !Model.getFacade().isAInterface(dep)) {
            return;
        }
        if (predecl && !this.includeCls.contains(dep)) {
            if (generatorPass == 2) {
                this.predeclCls.add(dep);
            }
        } else {
            if (this.predeclCls.contains(dep)) {
                this.predeclCls.remove(dep);
            }
            if (this.includeCls.add(dep)) {
                Object ns = Model.getFacade().getNamespace(this.currClass);
                String name = Model.getFacade().getName(dep);
                String path = this.generateRelativePackage(dep, ns, "/");
                Set inc = this.localInc;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                    inc = this.extInc;
                }
                if (path.length() > 0) {
                    inc.add(path + "/" + name + ".h");
                } else {
                    inc.add(name + ".h");
                }
            }
        }
    }

    private String generateHeaderPackageStartSingle(Object pkg) {
        StringBuffer sb = new StringBuffer(30);
        String packageName = Model.getFacade().getName(pkg);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String token = "";
        sb.append(this.generateTaggedValues(pkg, 1));
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            sb.append("namespace ").append(token).append(" {").append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String generateHeaderPackageEndSingle(Object pkg) {
        StringBuffer sb = new StringBuffer(30);
        String packageName = Model.getFacade().getName(pkg);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String token = "";
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            StringBuffer tempBuf = new StringBuffer(20);
            String absoluteName = this.generatePackageAbsoluteName(pkg);
            if (absoluteName.indexOf(token) != -1) {
                absoluteName = absoluteName.substring(0, absoluteName.indexOf(token) + token.length());
            }
            tempBuf.append("} /* End of namespace ").append(absoluteName);
            tempBuf.append(" */").append(LINE_SEPARATOR);
            sb.insert(0, tempBuf.toString());
        }
        return sb.toString();
    }

    private String generatePackageAbsoluteName(Object pkg) {
        String pack = this.generateRelativePackage(pkg, null, "::");
        if ((pack = pack.substring(2)).length() > 0) {
            pack = pack + "::";
        }
        return pack + Model.getFacade().getName(pkg);
    }

    private String generateNameWithPkgSelection(Object item, Object localPkg) {
        if (item == null) {
            return "void ";
        }
        Object pkg = null;
        if (Model.getFacade().isADataType(item)) {
            return Model.getFacade().getName(item);
        }
        if (Model.getFacade().isAParameter(item) || Model.getFacade().isAAttribute(item) || Model.getFacade().isAAssociationEnd(item) || Model.getFacade().isAClassifier(item)) {
            pkg = this.getNamespaceWithoutModel(item);
        }
        if (pkg == null) {
            return Model.getFacade().getName(item);
        }
        String packPrefix = this.generateRelativePackage(item, localPkg, "::");
        if (packPrefix.length() > 0) {
            packPrefix = packPrefix + "::";
        }
        return packPrefix + Model.getFacade().getName(item);
    }

    private String generateNameWithPkgSelection(Object item) {
        Object pkg = this.actualNamespace;
        String name = this.generateNameWithPkgSelection(item, pkg);
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        return name;
    }

    private String generateHeaderPackageStart(Object cls) {
        StringBuffer sb = new StringBuffer(80);
        if (this.actualNamespace != null) {
            Object lastSearch = this.actualNamespace;
            Object fromSearch = this.actualNamespace;
            while (fromSearch != null) {
                fromSearch = lastSearch;
                StringBuffer contPath = new StringBuffer(80);
                Object toSearch = this.getNamespaceWithoutModel(cls);
                while (toSearch != null && toSearch != fromSearch) {
                    contPath.insert(0, this.generateHeaderPackageStartSingle(toSearch));
                    toSearch = this.getNamespaceWithoutModel(toSearch);
                }
                if (toSearch == fromSearch) {
                    sb.append(contPath.toString());
                    break;
                }
                sb.append(this.generateHeaderPackageEndSingle(fromSearch));
                lastSearch = this.getNamespaceWithoutModel(fromSearch);
            }
        } else {
            Object toSearch = this.getNamespaceWithoutModel(cls);
            while (toSearch != null) {
                sb.insert(0, this.generateHeaderPackageStartSingle(toSearch));
                toSearch = this.getNamespaceWithoutModel(toSearch);
            }
        }
        this.actualNamespace = this.getNamespaceWithoutModel(cls);
        return sb.toString();
    }

    private Object getNamespaceWithoutModel(Object me) {
        Object parent = Model.getFacade().getNamespace(me);
        if (parent != null && Model.getFacade().getNamespace(parent) != null) {
            return parent;
        }
        return null;
    }

    private String generateHeaderPackageEnd() {
        StringBuffer sb = new StringBuffer(20);
        Object closeIt = this.actualNamespace;
        while (closeIt != null) {
            sb.append(this.generateHeaderPackageEndSingle(closeIt));
            closeIt = this.getNamespaceWithoutModel(closeIt);
        }
        this.actualNamespace = null;
        return sb.toString();
    }

    private String generateHeader(Object cls) {
        String pkgstart;
        StringBuffer sb = new StringBuffer(240);
        this.addUserHeaders(cls, generatorPass == 3);
        if (this.getNamespaceWithoutModel(cls) != null && (pkgstart = this.generateHeaderPackageStart(cls)).length() > 0) {
            sb.append(LINE_SEPARATOR);
            sb.append(pkgstart);
        }
        return sb.toString();
    }

    private String generateFooter() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.generateHeaderPackageEnd());
        if (sb.length() > 0) {
            sb.insert(0, LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String generateOperationPrefix(Object op) {
        StringBuffer sb = new StringBuffer(80);
        if (generatorPass != 3) {
            if (Model.getFacade().isLeaf(op) && !Model.getFacade().isRoot(op)) {
                LOG.warn((Object)(op + " is leaf but not root: " + "C++ can't handle this properly"));
                LOG.warn((Object)"    Ignoring the 'root' attribute");
            }
            if (!Model.getFacade().isLeaf(op) && !Model.getFacade().isConstructor(op) && !Model.getFacade().isStatic(op) || Model.getFacade().isAbstract(op)) {
                sb.append("virtual ");
            }
            sb.append(this.generateScope(op));
        }
        return sb.toString();
    }

    private String generateOperationSuffix(Object op) {
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.generateOperationChangeability(op));
        sb.append(this.generateAbstractness(op));
        return sb.toString();
    }

    private void generateOperationNameAndTestForConstructor(Object op, StringBuffer sb) {
        if (generatorPass == 3) {
            Object cls = Model.getFacade().getOwner(op);
            String prefix = new String();
            while (!Model.getFacade().isAPackage(cls)) {
                prefix = Model.getFacade().getName(cls) + "::" + prefix;
                cls = Model.getFacade().getNamespace(cls);
            }
            sb.append(prefix);
        }
        String name = Model.getFacade().isConstructor(op) ? Model.getFacade().getName(Model.getFacade().getOwner(op)) : (this.isDestructor(op) ? "~" + Model.getFacade().getName(Model.getFacade().getOwner(op)) : Model.getFacade().getName(op));
        sb.append(name);
    }

    private boolean isDestructor(Object op) {
        return Model.getExtensionMechanismsHelper().hasStereotype(op, "destroy");
    }

    public String generateOperation(Object op, boolean documented) {
        String suffix;
        String tv;
        if (generatorPass == 3 && Model.getFacade().isAbstract(op)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(80);
        StringBuffer nameBuffer = new StringBuffer(20);
        String operationIndent = generatorPass == 2 ? this.indent : "";
        this.generateOperationNameAndTestForConstructor(op, nameBuffer);
        if ((documented || generatorPass != 1) && (tv = this.generateTaggedValues(op, 1)) != null && tv.length() > 0) {
            sb.append(LINE_SEPARATOR).append(operationIndent).append(tv);
        }
        sb.append(operationIndent).append(this.generateOperationPrefix(op));
        List returnParams = Model.getCoreHelper().getReturnParameters(op);
        Object rp = returnParams.size() == 0 ? null : returnParams.iterator().next();
        if (returnParams.size() > 1) {
            LOG.warn((Object)("C++ generator only handles one return parameter - Found " + returnParams.size() + " for " + Model.getFacade().getName(op)));
        }
        if (!Model.getFacade().isConstructor(op) && !this.isDestructor(op)) {
            Inline inlineStyle = Inline.getInlineOperationModifierType(op);
            sb.append(inlineStyle.getInlineKeyword4Declaration());
            if (rp != null) {
                Object returnType = Model.getFacade().getType(rp);
                if (returnType == null) {
                    sb.append("void ");
                } else if (returnType != null) {
                    sb.append(this.generateNameWithPkgSelection(returnType)).append(' ');
                    sb.append(this.generateAttributeParameterModifier(rp));
                }
                boolean predecl = !this.checkIncludeNeeded4Element(rp);
                this.addDependency(returnType, predecl);
            }
        }
        Vector params = new Vector(Model.getFacade().getParameters(op));
        params.remove(rp);
        sb.append(nameBuffer.toString()).append('(');
        if (params != null) {
            boolean first = true;
            for (int i = 0; i < params.size(); ++i) {
                Object p = params.elementAt(i);
                if (!first) {
                    sb.append(", ");
                }
                sb.append(this.generateParameter(p));
                first = false;
            }
        }
        if ((suffix = this.generateOperationSuffix(op)).equals("")) {
            sb.append(")");
        } else {
            sb.append(") ").append(suffix);
        }
        return sb.toString();
    }

    private int getAttributeModifierType(Object elem) {
        Iterator iter = Model.getFacade().getTaggedValues(elem);
        while (iter.hasNext()) {
            Object tv = iter.next();
            String tag = Model.getFacade().getTagOfTag(tv);
            String val = Model.getFacade().getValueOfTag(tv);
            if (tag == null) continue;
            if (tag.equals("reference") || tag.equals("&")) {
                return val.equals("false") ? 0 : 1;
            }
            if (!tag.equals("pointer") && !tag.equals("*")) continue;
            return val.equals("false") ? 0 : 2;
        }
        return -1;
    }

    private String generateAttributeParameterModifier(Object attr, String def) {
        int modType = this.getAttributeModifierType(attr);
        if (!(modType != 0 && modType != -1 || Model.getFacade().isAAssociationClass(attr))) {
            Object type = Model.getFacade().getType(attr);
            if (type == null) {
                LOG.error((Object)(attr + " has no type!"));
                return "";
            }
            if (Model.getFacade().isAbstract(type) || Model.getFacade().isAInterface(type)) {
                if (modType == 0) {
                    LOG.warn((Object)"Requested no reference or pointer modifier, but");
                    LOG.warn((Object)("\t" + type + " cannot be instantiated, " + "using reference"));
                }
                modType = 1;
            }
        }
        if (modType == 0) {
            return "";
        }
        if (modType == 1) {
            return "&";
        }
        if (modType == 2) {
            return "*";
        }
        if (def.length() == 0 && Model.getFacade().isAParameter(attr) && (Model.getDirectionKind().getOutParameter().equals(Model.getFacade().getKind(attr)) || Model.getDirectionKind().getInOutParameter().equals(Model.getFacade().getKind(attr)))) {
            return "&";
        }
        return def;
    }

    private int getConstAttributeModifierType(Object elem) {
        Iterator iter = Model.getFacade().getTaggedValues(elem);
        while (iter.hasNext()) {
            Object tv = iter.next();
            String tag = Model.getFacade().getTagOfTag(tv);
            String val = Model.getFacade().getValueOfTag(tv);
            if (tag == null || !tag.equals("const")) continue;
            return val.equals("false") ? 0 : 3;
        }
        return -1;
    }

    private String generateConstAttributeParameterModifier(Object attr) {
        if (this.getConstAttributeModifierType(attr) == 3) {
            return "const";
        }
        return null;
    }

    private String generateAttributeParameterModifier(Object attr) {
        return this.generateAttributeParameterModifier(attr, "");
    }

    public String generateAttribute(Object attr, boolean documented) {
        String tv;
        StringBuffer sb = new StringBuffer(80);
        if ((documented || generatorPass != 1) && (tv = this.generateTaggedValues(attr, 1)) != null && tv.length() > 0) {
            sb.append(LINE_SEPARATOR).append(this.indent).append(tv).append(this.indent);
        }
        sb.append(this.generateVisibility(attr));
        sb.append(this.generateScope(attr));
        sb.append(this.generateStructuralFeatureChangeability(attr));
        sb.append(this.generateMultiplicity(attr, Model.getFacade().getName(attr), Model.getFacade().getMultiplicity(attr), this.generateAttributeParameterModifier(attr)));
        sb.append(";");
        if (generatorPass != 1) {
            sb.append(LINE_SEPARATOR);
        }
        boolean predecl = !this.checkIncludeNeeded4Element(attr);
        this.addDependency(Model.getFacade().getType(attr), predecl);
        return sb.toString();
    }

    private String generateParameter(Object param) {
        String defval;
        Object defvalObj;
        StringBuffer sb = new StringBuffer(20);
        Object type = Model.getFacade().getType(param);
        sb.append(this.generateParameterChangeability(param));
        String constModifier = this.generateConstAttributeParameterModifier(param);
        if (constModifier != null) {
            sb.append(constModifier).append(' ');
        }
        sb.append(this.generateNameWithPkgSelection(type));
        sb.append(' ');
        sb.append(this.generateAttributeParameterModifier(param));
        sb.append(Model.getFacade().getName(param));
        if (generatorPass != 3 && (defvalObj = Model.getFacade().getDefaultValue(param)) != null && (defval = Model.getFacade().getBody(defvalObj).toString().trim()).length() > 0) {
            sb.append(" = ").append(defval);
        }
        boolean predecl = !this.checkIncludeNeeded4Element(param);
        this.addDependency(type, predecl);
        return sb.toString();
    }

    StringBuffer generateClassifierStart(Object cls) {
        StringBuffer sb = new StringBuffer(80);
        sb.append(LINE_SEPARATOR).append(DocumentationManager.getComments((Object)cls));
        String tv = this.generateTaggedValues(cls, 1);
        if (tv != null && tv.length() > 0) {
            sb.append(LINE_SEPARATOR).append(this.indent).append(tv);
        }
        sb.append(this.generateClassifierNameAndAncestors(cls));
        if (this.lfBeforeCurly) {
            sb.append(LINE_SEPARATOR).append('{');
        } else if (generatorPass != 3) {
            sb.append(" {");
        }
        tv = this.generateTaggedValues(cls, 2);
        if (tv != null && tv.length() > 0) {
            sb.append(LINE_SEPARATOR).append(this.indent).append(tv);
        }
        return sb;
    }

    public StringBuffer generateClassifierNameAndAncestors(Object cls) {
        String interfaces;
        StringBuffer sb = new StringBuffer(80);
        if (generatorPass == 3) {
            return sb;
        }
        if (!Model.getFacade().isAClass(cls) && !Model.getFacade().isAInterface(cls)) {
            return null;
        }
        String sClassifierKeyword = "class";
        boolean hasBaseClass = false;
        sb.append(sClassifierKeyword).append(" ");
        sb.append(Model.getFacade().getName(cls));
        String baseClass = this.generateGeneralization(Model.getFacade().getGeneralizations(cls));
        if (!baseClass.equals("")) {
            sb.append(" : ").append(baseClass);
            hasBaseClass = true;
        }
        if (Model.getFacade().isAClass(cls) && !(interfaces = this.generateSpecification(cls)).equals("")) {
            if (!hasBaseClass) {
                sb.append(" : ");
            } else {
                sb.append(", ");
            }
            sb.append(interfaces);
        }
        return sb;
    }

    private StringBuffer generateClassifierEnd(Object cls) {
        StringBuffer sb = new StringBuffer();
        if (Model.getFacade().isAClass(cls) || Model.getFacade().isAInterface(cls)) {
            if (this.verboseDocs && generatorPass != 3) {
                String classifierkeyword = null;
                classifierkeyword = Model.getFacade().isAClass(cls) ? "class" : "class";
                sb.append(LINE_SEPARATOR).append("//end of ").append(classifierkeyword).append(" ").append(Model.getFacade().getName(cls)).append(LINE_SEPARATOR);
            }
            if (generatorPass != 3) {
                sb.append("};").append(LINE_SEPARATOR);
            }
        }
        return sb;
    }

    private String generateAllParts(StringBuffer[] parts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ALL_PARTS.length; ++i) {
            if (parts[i].toString().trim().length() <= 0) continue;
            if (generatorPass != 3) {
                if (i != 0) {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(' ').append(PART_NAME[i]).append(':');
                sb.append(LINE_SEPARATOR);
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    private int getVisibilityPart(Object o) {
        if (Model.getFacade().isPublic(o)) {
            return 0;
        }
        if (Model.getFacade().isProtected(o)) {
            return 1;
        }
        if (Model.getFacade().isPrivate(o)) {
            return 2;
        }
        LOG.warn((Object)(Model.getFacade().getName(o) + " is not public, nor protected, " + "nor private!!! (ignored)"));
        return -1;
    }

    private String indentString(String s, int n) {
        String ind = new String();
        while (n > 0) {
            ind = ind + this.indent;
            --n;
        }
        StringBuffer result = new StringBuffer();
        int i = s.indexOf(10);
        while (i != -1) {
            result.append(ind).append(s.substring(0, i + 1));
            s = s.substring(i + 1);
            i = s.indexOf(10);
        }
        if (s.length() > 0) {
            result.append(ind).append(s);
        }
        return result.toString();
    }

    public String generateClassifier(Object cls) {
        if (generatorPass == 1 && (Model.getFacade().isAClass(cls) || Model.getFacade().isAInterface(cls))) {
            while (GeneratorCpp.isAInnerClass(cls)) {
                cls = Model.getFacade().getNamespace(cls);
            }
            StringBuffer sb = new StringBuffer();
            String name = Model.getFacade().getName(cls);
            sb.append("// ").append(name).append(".h");
            sb.append(LINE_SEPARATOR);
            sb.append(this.generateH(cls));
            if (Model.getFacade().isAClass(cls)) {
                sb.append(LINE_SEPARATOR);
                sb.append("// ").append(name).append(".cpp");
                sb.append(LINE_SEPARATOR);
                sb.append(this.generateCpp(cls));
            }
            return sb.toString();
        }
        StringBuffer returnValue = new StringBuffer();
        StringBuffer start = this.generateClassifierStart(cls);
        if (start != null && start.length() > 0 || generatorPass == 3) {
            StringBuffer typedefs = this.generateGlobalTypedefs(cls);
            StringBuffer body = this.generateClassifierBody(cls);
            StringBuffer end = this.generateClassifierEnd(cls);
            returnValue.append(typedefs != null ? typedefs.toString() : "");
            returnValue.append(start);
            if (body != null && body.length() > 0) {
                returnValue.append(LINE_SEPARATOR);
                returnValue.append(body);
                if (this.lfBeforeCurly) {
                    returnValue.append(LINE_SEPARATOR);
                }
            }
            returnValue.append(end != null ? end.toString() : "");
        }
        return returnValue.toString();
    }

    private StringBuffer generateGlobalTypedefs(Object cls) {
        StringBuffer sb;
        block3: {
            block4: {
                sb = new StringBuffer();
                if (!Model.getFacade().isAClass(cls) && !Model.getFacade().isAInstance(cls)) break block3;
                if (generatorPass != 2) break block4;
                Collection globalTypedefStatements = this.findTagValues(cls, "typedef_global_header");
                if (globalTypedefStatements.isEmpty()) break block3;
                sb.append("// global type definitions for header defined by Tag entries in ArgoUML");
                sb.append(LINE_SEPARATOR);
                sb.append("// Result: typedef <typedef_global_header> <tag_value>;");
                sb.append(LINE_SEPARATOR);
                Iterator typedefEnum = globalTypedefStatements.iterator();
                while (typedefEnum.hasNext()) {
                    sb.append("typedef ").append(typedefEnum.next());
                    sb.append(";").append(LINE_SEPARATOR);
                }
                break block3;
            }
            Collection globalTypedefStatements = this.findTagValues(cls, "typedef_global_source");
            if (!globalTypedefStatements.isEmpty()) {
                sb.append("// global type definitions for class implementation in source file defined by Tag entries in ArgoUML");
                sb.append(LINE_SEPARATOR);
                sb.append("// Result: typedef <typedef_global_source> <tag_value>;");
                sb.append(LINE_SEPARATOR);
                Iterator typedefEnum = globalTypedefStatements.iterator();
                while (typedefEnum.hasNext()) {
                    sb.append("typedef ").append(typedefEnum.next());
                    sb.append(";").append(LINE_SEPARATOR);
                }
            }
        }
        return sb;
    }

    private void generateClassifierBodyAttributes(Object cls, StringBuffer sb) {
        List attrs = Model.getFacade().getAttributes(cls);
        if (attrs.isEmpty() || generatorPass != 2) {
            return;
        }
        String tv = null;
        sb.append(LINE_SEPARATOR);
        if (this.verboseDocs && Model.getFacade().isAClass(cls)) {
            sb.append(this.indent).append("// Attributes").append(LINE_SEPARATOR);
        }
        StringBuffer[] part = new StringBuffer[ALL_PARTS.length];
        for (int i = 0; i < part.length; ++i) {
            part[i] = new StringBuffer(80);
        }
        for (Object attr : attrs) {
            int i = this.getVisibilityPart(attr);
            part[i].append(this.indent).append(this.generateAttribute(attr, false));
            tv = this.generateTaggedValues(attr, 2);
            if (tv == null || tv.length() <= 0) continue;
            part[i].append(this.indent).append(tv);
        }
        sb.append(this.generateAllParts(part));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateClassifierBodyAssociations(Object cls, StringBuffer sb) {
        if (generatorPass == 3) {
            return;
        }
        Collection ends = Model.getFacade().getAssociationEnds(cls);
        if (!ends.isEmpty()) {
            sb.append(LINE_SEPARATOR);
            if (this.verboseDocs && Model.getFacade().isAClass(cls)) {
                sb.append(this.indent).append("// Associations").append(LINE_SEPARATOR);
            }
            StringBuffer[] part = new StringBuffer[3];
            for (int i = 0; i < ALL_PARTS.length; ++i) {
                part[i] = new StringBuffer(80);
            }
            for (Object ae : ends) {
                Object a = Model.getFacade().getAssociation(ae);
                AssociationEndHandler aeHandler = new AssociationEndHandler(ae);
                try {
                    aeHandler.pre();
                    this.generateAssociationFrom(a, ae, part);
                }
                finally {
                    aeHandler.post();
                }
            }
            sb.append(this.generateAllParts(part));
        }
        if (Model.getFacade().isAAssociationClass(cls)) {
            if (this.verboseDocs) {
                sb.append(LINE_SEPARATOR).append(this.indent);
                sb.append("// AssociationClass associated classes");
            }
            sb.append(LINE_SEPARATOR).append(" public:").append(LINE_SEPARATOR);
            ends = Model.getFacade().getConnections(cls);
            for (Object ae : ends) {
                sb.append(LINE_SEPARATOR);
                String comment = this.generateConstraintEnrichedDocComment(cls, ae);
                if (comment.length() > 0) {
                    sb.append(comment).append(this.indent);
                }
                String n = Model.getFacade().getName(ae);
                Object type = Model.getFacade().getType(ae);
                String name = n != null && n.length() > 0 ? n : "my" + GeneratorCpp.generateClassifierRef(type);
                sb.append(this.generateNameWithPkgSelection(type));
                sb.append(this.generateAttributeParameterModifier(ae));
                sb.append(" ").append(name);
                sb.append(";").append(LINE_SEPARATOR);
                this.addDependency(type, !this.checkIncludeNeeded4Element(type));
                String tv = this.generateTaggedValues(ae, 2);
                if (tv == null || tv.length() <= 0) continue;
                sb.append(this.indent).append(tv);
            }
        }
    }

    private boolean checkGenerateOperationBody(Object op) {
        boolean result = generatorPass != 2 && !Model.getFacade().isAbstract(op) && !Model.getFacade().isAInterface(Model.getFacade().getOwner(op));
        Inline inlineStyle = Inline.getInlineOperationModifierType(op);
        if (generatorPass == 2) {
            result = inlineStyle.isMethodBodyInsideClass();
        } else if (generatorPass == 1) {
            result = inlineStyle.isMethodBodyOutsideClass();
        }
        return result;
    }

    private void generateSingleAttributeSet(Object attr, StringBuffer sb) {
        if (Model.getFacade().getType(attr) == null) {
            return;
        }
        sb.append(LINE_SEPARATOR).append(this.indent);
        sb.append("/** simple access function to set the attribute ");
        sb.append(Model.getFacade().getName(attr));
        sb.append(" by function").append(LINE_SEPARATOR).append(this.indent);
        sb.append("  * @param value value to set for the attribute ");
        sb.append(Model.getFacade().getName(attr)).append(LINE_SEPARATOR);
        sb.append(this.indent).append("  */").append(LINE_SEPARATOR);
        sb.append(this.indent);
        sb.append("void set_").append(Model.getFacade().getName(attr)).append("( ");
        String modifier = this.generateAttributeParameterModifier(attr);
        if (modifier != null && modifier.length() > 0) {
            if (modifier.equals("&")) {
                sb.append("const ");
            }
            sb.append(GeneratorCpp.generateClassifierRef(Model.getFacade().getType(attr))).append(' ').append(modifier).append("value");
        } else if (Model.getFacade().isAClass(Model.getFacade().getType(attr))) {
            sb.append("const ");
            sb.append(GeneratorCpp.generateClassifierRef(Model.getFacade().getType(attr)));
            sb.append(" &value");
        } else {
            sb.append(GeneratorCpp.generateClassifierRef(Model.getFacade().getType(attr))).append(" value");
        }
        sb.append(" ) { ").append(Model.getFacade().getName(attr));
        sb.append(" = value; };").append(LINE_SEPARATOR);
    }

    private void generateSingleAttributeGet(Object attr, StringBuffer sb) {
        if (Model.getFacade().getType(attr) == null) {
            return;
        }
        sb.append(LINE_SEPARATOR).append(this.indent);
        sb.append("/** simple access function to get the attribute ");
        sb.append(Model.getFacade().getName(attr));
        sb.append(" by function */").append(LINE_SEPARATOR).append(this.indent);
        String modifier = this.generateAttributeParameterModifier(attr);
        if (modifier != null && modifier.length() > 0) {
            sb.append("const ");
            sb.append(GeneratorCpp.generateClassifierRef(Model.getFacade().getType(attr)));
            sb.append(modifier);
        } else if (Model.getFacade().isAClass(Model.getFacade().getType(attr))) {
            sb.append("const ");
            sb.append(GeneratorCpp.generateClassifierRef(Model.getFacade().getType(attr)));
            sb.append("&");
        } else {
            sb.append(GeneratorCpp.generateClassifierRef(Model.getFacade().getType(attr)));
        }
        sb.append(" get_").append(Model.getFacade().getName(attr));
        sb.append("( void ) const { return ").append(Model.getFacade().getName(attr));
        sb.append("; };").append(LINE_SEPARATOR);
    }

    private void generateClassifierBodyTaggedAccess4Attributes(Object cls, StringBuffer funcPrivate, StringBuffer funcProtected, StringBuffer funcPublic) {
        List strs = Model.getFacade().getAttributes(cls);
        if (strs.isEmpty() || generatorPass != 2) {
            return;
        }
        String accessTag = null;
        for (Object attr : strs) {
            accessTag = Model.getFacade().getTaggedValueValue(attr, "set");
            if (accessTag != null && accessTag.length() > 0) {
                if (accessTag.indexOf("public") != -1) {
                    this.generateSingleAttributeSet(attr, funcPublic);
                }
                if (accessTag.indexOf("protected") != -1) {
                    this.generateSingleAttributeSet(attr, funcProtected);
                }
                if (accessTag.indexOf("private") != -1) {
                    this.generateSingleAttributeSet(attr, funcPrivate);
                }
            }
            if ((accessTag = Model.getFacade().getTaggedValueValue(attr, "get")) == null || accessTag.length() <= 0) continue;
            if (accessTag.indexOf("public") != -1) {
                this.generateSingleAttributeGet(attr, funcPublic);
            }
            if (accessTag.indexOf("protected") != -1) {
                this.generateSingleAttributeGet(attr, funcProtected);
            }
            if (accessTag.indexOf("private") == -1) continue;
            this.generateSingleAttributeGet(attr, funcPrivate);
        }
    }

    private void generateClassifierBodyOperations(Object cls, StringBuffer sb) {
        List behs = Model.getFacade().getOperations(cls);
        if (behs.isEmpty()) {
            return;
        }
        sb.append(LINE_SEPARATOR);
        if (this.verboseDocs) {
            sb.append(this.indent).append("// Operations").append(LINE_SEPARATOR);
        }
        StringBuffer[] funcs = new StringBuffer[]{new StringBuffer(80), new StringBuffer(80), new StringBuffer(80)};
        this.generateClassifierBodyTaggedAccess4Attributes(cls, funcs[2], funcs[1], funcs[0]);
        for (Object bf : behs) {
            StringBuffer tb = null;
            int p = this.getVisibilityPart(bf);
            if (p < 0) continue;
            tb = funcs[p];
            boolean mustGenBody = this.checkGenerateOperationBody(bf);
            if (tb == null || generatorPass != 2 && !mustGenBody) continue;
            tb.append(LINE_SEPARATOR);
            tb.append(this.generateOperation(bf, false));
            String tv = this.generateTaggedValues(bf, 2);
            if (mustGenBody && Model.getFacade().isAClass(cls) && Model.getFacade().isAOperation(bf) && !Model.getFacade().isAbstract(bf)) {
                tb.append(LINE_SEPARATOR).append(this.generateMethodBody(bf));
                continue;
            }
            tb.append(";").append(LINE_SEPARATOR);
            if (tv.length() <= 0) continue;
            tb.append(this.indent).append(tv).append(LINE_SEPARATOR);
        }
        sb.append(this.generateAllParts(funcs));
    }

    private void generateClassifierBodyTypedefs(Object cls, StringBuffer sb) {
        if (generatorPass == 2) {
            Iterator typedefEnum;
            Collection publicTypedefStatements = this.findTagValues(cls, "typedef_public");
            Collection protectedTypedefStatements = this.findTagValues(cls, "typedef_protected");
            Collection privateTypedefStatements = this.findTagValues(cls, "typedef_private");
            if (!publicTypedefStatements.isEmpty()) {
                sb.append(LINE_SEPARATOR).append(" public:").append(LINE_SEPARATOR).append(this.indent);
                sb.append("// public type definitions for header defined by Tag entries in ArgoUML").append(LINE_SEPARATOR);
                sb.append(this.indent);
                sb.append("// Result: typedef <typedef_public> <tag_value>;").append(LINE_SEPARATOR);
                typedefEnum = publicTypedefStatements.iterator();
                while (typedefEnum.hasNext()) {
                    sb.append(this.indent).append("typedef ");
                    sb.append(typedefEnum.next()).append(";").append(LINE_SEPARATOR);
                }
            }
            if (!protectedTypedefStatements.isEmpty()) {
                sb.append(LINE_SEPARATOR).append(" protected:").append(LINE_SEPARATOR).append(this.indent);
                sb.append("// protected type definitions for header defined by Tag entries in ArgoUML").append(LINE_SEPARATOR);
                sb.append(this.indent);
                sb.append("// Result: typedef <typedef_protected> <tag_value>;").append(LINE_SEPARATOR);
                typedefEnum = protectedTypedefStatements.iterator();
                while (typedefEnum.hasNext()) {
                    sb.append(this.indent).append("typedef ");
                    sb.append(typedefEnum.next()).append(";").append(LINE_SEPARATOR);
                }
            }
            if (!privateTypedefStatements.isEmpty()) {
                sb.append(LINE_SEPARATOR).append(" private:").append(LINE_SEPARATOR).append(this.indent);
                sb.append("// private type definitions for header defined by Tag entries in ArgoUML").append(LINE_SEPARATOR);
                sb.append(this.indent);
                sb.append("// Result: typedef <typedef_private> <tag_value>;").append(LINE_SEPARATOR);
                typedefEnum = privateTypedefStatements.iterator();
                while (typedefEnum.hasNext()) {
                    sb.append(this.indent).append("typedef ");
                    sb.append(typedefEnum.next()).append(";").append(LINE_SEPARATOR);
                }
            }
        }
    }

    private void generateClassifierDestructor(Object cls, StringBuffer sb) {
        if (Model.getFacade().isAInterface(cls) && generatorPass == 2) {
            sb.append(LINE_SEPARATOR).append("public:").append(LINE_SEPARATOR);
            sb.append(this.indent).append("// virtual destructor for interface ").append(LINE_SEPARATOR);
            sb.append(this.indent).append("virtual ").append('~').append(Model.getFacade().getName(cls)).append("() { }").append(LINE_SEPARATOR);
        }
    }

    private void generateClassifierInnerClasses(Object cls, StringBuffer sb) {
        StringBuffer[] part = new StringBuffer[ALL_PARTS.length];
        for (int i = 0; i < part.length; ++i) {
            part[i] = new StringBuffer(80);
        }
        Collection inners = Model.getFacade().getOwnedElements(cls);
        for (Object inner : inners) {
            if (!Model.getFacade().isAClass(inner) && !Model.getFacade().isAInterface(inner)) continue;
            String innerCode = this.generateClassifier(inner);
            int p = this.getVisibilityPart(inner);
            part[p].append(LINE_SEPARATOR);
            if (generatorPass == 2) {
                part[p].append(this.indentString(innerCode, 1));
            } else {
                part[p].append(innerCode);
            }
            part[p].append(LINE_SEPARATOR);
        }
        sb.append(this.generateAllParts(part));
    }

    private StringBuffer generateClassifierBody(Object cls) {
        StringBuffer sb = new StringBuffer();
        if (Model.getFacade().isAClass(cls) || Model.getFacade().isAInterface(cls)) {
            this.generateClassifierInnerClasses(cls, sb);
            this.generateClassifierBodyOperations(cls, sb);
            this.generateClassifierDestructor(cls, sb);
            this.generateClassifierBodyAttributes(cls, sb);
            this.generateClassifierBodyAssociations(cls, sb);
            this.generateClassifierBodyTypedefs(cls, sb);
        }
        return sb;
    }

    private String generateMethodBody(Object op) {
        if (op != null) {
            String operationIndent;
            StringBuffer sb = new StringBuffer(80);
            Collection methods = Model.getFacade().getMethods(op);
            Iterator i = methods.iterator();
            Object method = null;
            boolean methodFound = false;
            String tv = this.generateTaggedValues(op, 2);
            String string = operationIndent = generatorPass == 2 ? this.indent : "";
            if (tv.length() > 0) {
                sb.append(operationIndent).append(tv).append(LINE_SEPARATOR);
            }
            sb.append(this.generateSectionTop(op, operationIndent)).append(operationIndent).append("{").append(LINE_SEPARATOR);
            while (i != null && i.hasNext()) {
                method = i.next();
                if (method == null || Model.getFacade().getBody(method) == null || methodFound) continue;
                Object body = Model.getFacade().getBody(method);
                sb.append(Model.getFacade().getBody(body));
                methodFound = true;
                break;
            }
            if (!methodFound) {
                List returnParams = Model.getCoreHelper().getReturnParameters(op);
                Object rp = returnParams.size() == 0 ? null : returnParams.iterator().next();
                if (returnParams.size() > 1) {
                    LOG.warn((Object)("C++ generator only handles one return parameter - Found " + returnParams.size() + " for " + Model.getFacade().getName(op)));
                }
                if (rp != null) {
                    Object returnType = Model.getFacade().getType(rp);
                    sb.append(this.generateDefaultReturnStatement(returnType));
                }
            }
            sb.append(operationIndent).append("}").append(LINE_SEPARATOR).append(this.generateSectionBottom(op, operationIndent));
            return sb.toString();
        }
        return this.generateDefaultReturnStatement(null);
    }

    private String generateSectionTop(Object op, String localIndent) {
        String id = UUIDHelper.getUUID((Object)op);
        return Section.generateTop(id, localIndent);
    }

    private String generateSectionBottom(Object op, String localIndent) {
        String id = UUIDHelper.getUUID((Object)op);
        return Section.generateBottom(id, localIndent);
    }

    private String generateDefaultReturnStatement(Object cls) {
        if (cls == null) {
            return "";
        }
        String clsName = Model.getFacade().getName(cls);
        String res = null;
        if (clsName.equals("void")) {
            res = "";
        } else if (clsName.equals("char")) {
            res = "return 'x';";
        } else if (clsName.equals("int")) {
            res = "return 0;";
        } else if (clsName.equals("bool")) {
            res = "return false;";
        } else if (clsName.equals("byte")) {
            res = "return 0;";
        } else if (clsName.equals("long")) {
            res = "return 0;";
        } else if (clsName.equals("float")) {
            res = "return 0.0;";
        } else if (clsName.equals("double")) {
            res = "return 0.0;";
        }
        if (res == null) {
            return "";
        }
        return this.indent + res + LINE_SEPARATOR;
    }

    private String generateTaggedValues(Object e, int tagSelection) {
        String doc;
        Iterator iter = Model.getFacade().getTaggedValues(e);
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        String s = null;
        while (iter.hasNext()) {
            s = this.generateTaggedValue(iter.next(), tagSelection);
            if (s == null || s.length() <= 0) continue;
            if (first) {
                if (tagSelection == 1) {
                    String string = doc = DocumentationManager.hasDocs((Object)e) ? DocumentationManager.getDocs((Object)e, (String)this.indent) : null;
                    if (doc != null && doc.trim().length() > 0) {
                        buf.append(doc.substring(0, doc.indexOf("*/") + 1));
                        buf.append("  ");
                    } else {
                        buf.append("/** ");
                    }
                } else {
                    buf.append("/* {");
                }
                first = false;
            } else if (tagSelection == 1) {
                buf.append(LINE_SEPARATOR).append(this.indent).append(" *  ");
            } else {
                buf.append(", ");
            }
            buf.append(s);
        }
        if (!first) {
            if (tagSelection == 1) {
                buf.append(LINE_SEPARATOR).append(this.indent).append(" */").append(LINE_SEPARATOR);
            } else {
                buf.append("}*/").append(LINE_SEPARATOR);
            }
        } else if (tagSelection == 1) {
            String string = doc = DocumentationManager.hasDocs((Object)e) ? DocumentationManager.getDocs((Object)e, (String)this.indent) : null;
            if (doc != null && doc.trim().length() > 0) {
                buf.append(doc).append(LINE_SEPARATOR);
            }
        }
        return buf.toString();
    }

    private String generateTaggedValue(Object tv, int tagSelection) {
        if (tv == null) {
            return "";
        }
        String s = GeneratorCpp.generateUninterpreted(Model.getFacade().getValueOfTag(tv));
        String tagName = Model.getFacade().getTagOfTag(tv);
        if (s == null || s.length() == 0 || s.equals("/** */") || tagName == null || tagName.indexOf("include") != -1 || tagName.indexOf("_incl") != -1) {
            return "";
        }
        if (tagSelection == 1 && this.isDocCommentTag(tagName)) {
            return this.generateDocComment4Tag(tagName) + s;
        }
        if (tagSelection == 2 && !this.isDocCommentTag(tagName) && !tagName.equals("documentation") && !tagName.equals("javadocs") || tagSelection == 3) {
            return tagName + "=" + s;
        }
        return "";
    }

    private Collection findTagValues(Object item, String searchedName) {
        Vector<String> result = new Vector<String>();
        Iterator iter = Model.getFacade().getTaggedValues(item);
        String s = null;
        while (iter.hasNext()) {
            Object tag = iter.next();
            String tagOfTag = Model.getFacade().getTagOfTag(tag);
            if (tagOfTag == null || !tagOfTag.equals(searchedName) || (s = Model.getFacade().getValueOfTag(tag)) == null || s.length() == 0) continue;
            result.add(s);
        }
        return result;
    }

    private boolean isDocCommentTag(String tagName) {
        boolean result = false;
        if (tagName.equals("inv")) {
            result = true;
        } else if (tagName.equals("post")) {
            result = true;
        } else if (tagName.equals("pre")) {
            result = true;
        } else if (tagName.equals("author")) {
            result = true;
        } else if (tagName.equals("version")) {
            result = true;
        } else if (tagName.equals("see")) {
            result = true;
        } else if (tagName.equals("param")) {
            result = true;
        }
        return result;
    }

    private String generateDocComment4Tag(String tagName) {
        if (tagName.equals("inv")) {
            return "@invariant ";
        }
        if (tagName.equals("post")) {
            return "@postcondition ";
        }
        if (tagName.equals("pre")) {
            return "@precondition ";
        }
        if (tagName.equals("author")) {
            return "@author ";
        }
        if (tagName.equals("version")) {
            return "@version ";
        }
        if (tagName.equals("see")) {
            return "@see ";
        }
        if (tagName.equals("param")) {
            return "@param ";
        }
        return "";
    }

    private String generateConstraintEnrichedDocComment(Object me, Object ae) {
        String s = this.generateTaggedValues(me, 1);
        if (Model.getFacade().getUpper(ae) != 1) {
            StringBuffer sDocComment = new StringBuffer(80);
            if (s != null && !"".equals(s)) {
                sDocComment.append(this.indent).append(s.substring(0, s.indexOf("*/") + 1));
            } else {
                sDocComment.append(this.indent).append("/**").append(LINE_SEPARATOR);
                sDocComment.append(this.indent).append(" *");
            }
            Object type = Model.getFacade().getType(ae);
            if (type != null) {
                sDocComment.append(" @element-type ");
                sDocComment.append(Model.getFacade().getName(type));
            }
            sDocComment.append(LINE_SEPARATOR).append(this.indent).append(" */").append(LINE_SEPARATOR);
            return sDocComment.toString();
        }
        return s != null ? s : "";
    }

    private void generateAssociationFrom(Object a, Object ae, StringBuffer[] parts) {
        Collection connections = Model.getFacade().getConnections(a);
        for (Object ae2 : connections) {
            String tv;
            int p;
            if (ae2 == ae || (p = this.getVisibilityPart(ae2)) < 0) continue;
            StringBuffer sb = parts[p];
            sb.append(LINE_SEPARATOR);
            String assend = this.generateAssociationEnd(ae2);
            if (assend.length() > 0) {
                String comment = this.generateConstraintEnrichedDocComment(a, ae2);
                if (comment.length() > 0) {
                    sb.append(comment);
                }
                sb.append(this.indent).append(assend);
            }
            if ((tv = this.generateTaggedValues(a, 2)) == null || tv.length() <= 0) continue;
            sb.append(this.indent).append(tv);
        }
    }

    private String generateAssociationEnd(Object ae) {
        String modifier;
        if (!Model.getFacade().isNavigable(ae)) {
            return "";
        }
        if (Model.getFacade().isAbstract(Model.getFacade().getAssociation(ae))) {
            return "";
        }
        StringBuffer sb = new StringBuffer(80);
        if (Model.getFacade().isStatic(ae)) {
            sb.append("static ");
        }
        String n = Model.getFacade().getName(ae);
        Object asc = Model.getFacade().getAssociation(ae);
        String ascName = Model.getFacade().getName(asc);
        String name = null;
        name = n != null && n.length() > 0 ? n : (ascName != null && ascName.length() > 0 ? ascName : "my" + GeneratorCpp.generateClassifierRef(Model.getFacade().getType(ae)));
        if (Model.getFacade().isAAssociationClass(asc)) {
            modifier = this.generateAttributeParameterModifier(asc, "*");
            this.addDependency(asc, !this.checkIncludeNeeded4Element(ae));
        } else {
            modifier = this.generateAttributeParameterModifier(ae);
            boolean predecl = !this.checkIncludeNeeded4Element(ae);
            this.addDependency(Model.getFacade().getType(ae), predecl);
        }
        sb.append(this.generateMultiplicity(ae, name, Model.getFacade().getMultiplicity(ae), modifier));
        return sb.append(";").append(LINE_SEPARATOR).toString();
    }

    private String generateGeneralization(Collection generalizations) {
        if (generalizations == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(80);
        for (Object generalization : generalizations) {
            String visTag;
            Object ge = Model.getFacade().getGeneral(generalization);
            if (ge == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if ((visTag = Model.getFacade().getTaggedValueValue(generalization, "cpp_inheritance_visibility").trim()) != null && !visTag.equals("")) {
                sb.append(visTag).append(" ");
            } else if (Model.getFacade().isAInterface(ge)) {
                sb.append("virtual public ");
            } else {
                sb.append("public ");
            }
            sb.append(this.generateNameWithPkgSelection(ge));
            this.addDependency(ge, false);
        }
        return sb.toString();
    }

    private String generateSpecification(Object cls) {
        Collection deps = Model.getFacade().getClientDependencies(cls);
        Iterator depIterator = deps.iterator();
        StringBuffer sb = new StringBuffer(80);
        while (depIterator.hasNext()) {
            Object dependency = depIterator.next();
            if (!Model.getFacade().isAAbstraction(dependency) || !Model.getFacade().isRealize(dependency)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            Object iFace = Model.getFacade().getSuppliers(dependency).iterator().next();
            String visTag = Model.getFacade().getTaggedValueValue(dependency, "cpp_inheritance_visibility").trim();
            if (visTag != null && !visTag.equals("")) {
                sb.append(visTag).append(" ");
            } else {
                sb.append("virtual public ");
            }
            sb.append(this.generateNameWithPkgSelection(iFace));
            this.addDependency(iFace, false);
        }
        return sb.toString();
    }

    private String generateVisibility(Object o) {
        String tagged;
        Object tv;
        if (Model.getFacade().isAAttribute(o)) {
            return "";
        }
        if (Model.getFacade().isAFeature(o) && (tv = Model.getFacade().getTaggedValue(o, "src_visibility")) != null && (tagged = (String)Model.getFacade().getValue(tv)) != null) {
            if (tagged.trim().equals("") || tagged.trim().toLowerCase().equals("default") || tagged.trim().toLowerCase().equals("package")) {
                return "";
            }
            return tagged + ": ";
        }
        if (Model.getFacade().isAModelElement(o)) {
            if (Model.getFacade().isPublic(o)) {
                return "public: ";
            }
            if (Model.getFacade().isPrivate(o)) {
                return "private: ";
            }
            if (Model.getFacade().isProtected(o)) {
                return "protected: ";
            }
            if (Model.getFacade().isPackage(o)) {
                return "";
            }
        }
        if (Model.getFacade().isAVisibilityKind(o)) {
            if (Model.getVisibilityKind().getPublic().equals(o)) {
                return "public: ";
            }
            if (Model.getVisibilityKind().getPrivate().equals(o)) {
                return "private: ";
            }
            if (Model.getVisibilityKind().getProtected().equals(o)) {
                return "protected: ";
            }
            if (Model.getVisibilityKind().getPackage().equals(o)) {
                return "";
            }
        }
        return "";
    }

    private String generateScope(Object me) {
        if (Model.getFacade().isStatic(me)) {
            return "static ";
        }
        return "";
    }

    private String generateAbstractness(Object op) {
        Object opOwner = Model.getFacade().getOwner(op);
        if (Model.getFacade().isAbstract(op) || Model.getFacade().isAInterface(opOwner)) {
            return " = 0";
        }
        return "";
    }

    private String generateOperationChangeability(Object op) {
        if (Model.getFacade().isQuery(op)) {
            return "const ";
        }
        return "";
    }

    private String generateParameterChangeability(Object par) {
        int parType = this.getAttributeModifierType(par);
        if (parType != -1 && parType != 0 && Model.getFacade().getKind(par) != null && Model.getFacade().getKind(par).equals(Model.getDirectionKind().getInParameter())) {
            return "const ";
        }
        return "";
    }

    private String generateStructuralFeatureChangeability(Object sf) {
        if (Model.getFacade().isReadOnly(sf)) {
            return "const ";
        }
        return "";
    }

    private String generateMultiplicity(Object item, String name, Object m, String modifier) {
        String type = null;
        String containerType = null;
        Object typeCls = null;
        if (Model.getFacade().isAAssociationEnd(item)) {
            Object assoc = Model.getFacade().getAssociation(item);
            if (Model.getFacade().isAAssociationClass(assoc)) {
                typeCls = assoc;
                name = name + "Assoc";
            } else {
                typeCls = Model.getFacade().getType(item);
            }
        } else if (Model.getFacade().isAAttribute(item)) {
            typeCls = Model.getFacade().getType(item);
        } else if (Model.getFacade().isAClassifier(item)) {
            typeCls = item;
        } else {
            type = "";
        }
        if (typeCls != null) {
            type = this.generateNameWithPkgSelection(typeCls);
        }
        if (m == null) {
            return type + " " + modifier + name;
        }
        StringBuffer sb = new StringBuffer(80);
        int countUpper = Model.getFacade().getUpper(m);
        int countLower = Model.getFacade().getLower(m);
        if (countUpper == 1 && countLower == 1) {
            sb.append(type).append(' ').append(modifier).append(name);
        } else if (countUpper == 1 && countLower == 0) {
            sb.append(type).append(' ').append(modifier).append("* ").append(name);
        } else if (countUpper == countLower) {
            sb.append(type).append(' ').append(modifier).append(name).append("[ " + countUpper + "]");
        } else {
            String multType = Model.getFacade().getTaggedValueValue(item, "MultiplicityType");
            if (multType != null && multType.length() > 0) {
                if (multType.equals("vector")) {
                    containerType = "vector";
                } else if (multType.equals("list")) {
                    containerType = "list";
                } else if (multType.equals("slist")) {
                    containerType = "slist";
                } else if (multType.equals("map")) {
                    containerType = "map";
                } else if (multType.equals("stack")) {
                    containerType = "stack";
                } else if (multType.equals("stringmap")) {
                    this.systemInc.add("string");
                    this.systemInc.add("map");
                    sb.append(this.stdPrefix + "map<" + this.stdPrefix + "string, ");
                    if (modifier.indexOf(38) != -1) {
                        LOG.warn((Object)"cannot generate STL container with references, using pointers");
                        modifier = "*";
                    }
                    sb.append(type).append(modifier);
                    sb.append(" > ").append(name);
                } else {
                    LOG.warn((Object)("unknown MultiplicityType \"" + multType + "\", using default"));
                    containerType = "vector";
                }
            } else {
                containerType = "vector";
            }
            if (containerType != null) {
                this.systemInc.add(containerType);
                sb.append(this.stdPrefix).append(containerType).append("< ");
                if (modifier.indexOf(38) != -1) {
                    LOG.warn((Object)"cannot generate STL container with references, using pointers");
                    modifier = "*";
                }
                sb.append(type).append(modifier);
                sb.append(" > ").append(name);
            }
        }
        return sb.toString();
    }

    public void loadConfig() {
        int indWidth = Configuration.getInteger((ConfigurationKey)KEY_CPP_INDENT, (int)4);
        char[] ind = new char[indWidth];
        for (int i = 0; i < indWidth; ++i) {
            ind[i] = 32;
        }
        this.indent = new String(ind);
        this.lfBeforeCurly = Configuration.getBoolean((ConfigurationKey)KEY_CPP_LF_BEFORE_CURLY, (boolean)false);
        this.verboseDocs = Configuration.getBoolean((ConfigurationKey)KEY_CPP_VERBOSE_COMM, (boolean)false);
        int useSect = Configuration.getInteger((ConfigurationKey)KEY_CPP_SECT, (int)1);
        Section.setUseSect(useSect);
        this.hdrGuardUpperCase = Configuration.getBoolean((ConfigurationKey)KEY_CPP_HEADER_GUARD_UPPERCASE, (boolean)false);
        this.hdrGuardGUID = Configuration.getBoolean((ConfigurationKey)KEY_CPP_HEADER_GUARD_GUID, (boolean)false);
        int defaultInlineStyle = Configuration.getInteger((ConfigurationKey)KEY_CPP_DEFAULT_INLINE, (int)Inline.getDefaultDefaultStyle());
        Inline.setDefaultStyle(defaultInlineStyle);
    }

    public boolean isLfBeforeCurly() {
        return this.lfBeforeCurly;
    }

    public void setLfBeforeCurly(boolean beforeCurly) {
        this.lfBeforeCurly = beforeCurly;
        Configuration.setBoolean((ConfigurationKey)KEY_CPP_LF_BEFORE_CURLY, (boolean)beforeCurly);
    }

    public boolean isVerboseDocs() {
        return this.verboseDocs;
    }

    public void setVerboseDocs(boolean verbose) {
        this.verboseDocs = verbose;
        Configuration.setBoolean((ConfigurationKey)KEY_CPP_VERBOSE_COMM, (boolean)verbose);
    }

    public int getIndent() {
        return this.indent.length();
    }

    public void setIndent(int indWidth) {
        char[] ind = new char[indWidth];
        for (int i = 0; i < indWidth; ++i) {
            ind[i] = 32;
        }
        this.indent = new String(ind);
        Configuration.setInteger((ConfigurationKey)KEY_CPP_INDENT, (int)indWidth);
    }

    public int getUseSect() {
        return Section.getUseSect();
    }

    public void setUseSect(int use) {
        Section.setUseSect(use);
        Configuration.setInteger((ConfigurationKey)KEY_CPP_SECT, (int)use);
    }

    public boolean isHeaderGuardUpperCase() {
        return this.hdrGuardUpperCase;
    }

    public void setHeaderGuardUpperCase(boolean upperCase) {
        this.hdrGuardUpperCase = upperCase;
        Configuration.setBoolean((ConfigurationKey)KEY_CPP_HEADER_GUARD_UPPERCASE, (boolean)upperCase);
    }

    public boolean isHeaderGuardGUID() {
        return this.hdrGuardGUID;
    }

    public void setHeaderGuardGUID(boolean addGUID) {
        this.hdrGuardGUID = addGUID;
        Configuration.setBoolean((ConfigurationKey)KEY_CPP_HEADER_GUARD_GUID, (boolean)addGUID);
    }

    public int getDefaultInlineStyle() {
        return Inline.getDefaultStyle();
    }

    public void setDefaultInlineStyle(int inline) {
        Inline.setDefaultStyle(inline);
        Configuration.setInteger((ConfigurationKey)KEY_CPP_DEFAULT_INLINE, (int)inline);
    }

    private void startFileGeneration() {
        if (this.generateRecur++ == 0) {
            this.generatedFiles = new HashSet();
        }
    }

    private void endFileGeneration() {
        if (--this.generateRecur == 0) {
            this.generatedFiles = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection generateFilesForElem(Object o, String path, boolean deps) {
        Vector<Object> ret = new Vector<Object>();
        if (this.generatedFiles.contains(o)) {
            return ret;
        }
        if (!Model.getFacade().isAClass(o) && !Model.getFacade().isAInterface(o)) {
            return ret;
        }
        while (GeneratorCpp.isAInnerClass(o)) {
            o = Model.getFacade().getNamespace(o);
        }
        String pathname = null;
        if (Section.getUseSect() != 0) {
            sect = new Section();
            for (generatorPass = 2; generatorPass <= 3; ++generatorPass) {
                pathname = this.createDirectoriesPathname(o, path);
                File f = new File(pathname);
                if (f.exists()) {
                    LOG.info((Object)("Generating (updated) " + f.getPath()));
                    sect.read(pathname);
                    File bakFile = new File(pathname + ".bak");
                    if (bakFile.exists()) {
                        bakFile.delete();
                    }
                    f.renameTo(bakFile);
                    continue;
                }
                LOG.info((Object)("Generating (new) " + f.getPath()));
            }
        }
        TreeSet<Set> dependencies = null;
        if (deps) {
            dependencies = new TreeSet<Set>();
        }
        for (generatorPass = 2; generatorPass <= 3; ++generatorPass) {
            pathname = this.createDirectoriesPathname(o, path);
            String fileContent = this.generateFileAsString(o, pathname);
            if (fileContent.length() == 0) continue;
            BufferedWriter fos = null;
            File f = new File(pathname);
            try {
                fos = new BufferedWriter(new FileWriter(f));
                this.writeTemplate(o, path, fos);
                fos.write(fileContent);
                fos.newLine();
            }
            catch (IOException exp) {
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException exp) {
                    LOG.error((Object)("FAILED: " + f.getPath()));
                }
            }
            LOG.info((Object)("written: " + pathname));
            if (Section.getUseSect() != 0) {
                File outFile = new File(pathname + ".out");
                if (outFile.exists()) {
                    outFile.delete();
                }
                if (generatorPass == 2) {
                    sect.write(pathname, this.indent, false);
                } else {
                    sect.write(pathname, this.indent, true);
                }
                if (outFile.exists()) {
                    assert (f.exists());
                    f.delete();
                    outFile.renameTo(f);
                    LOG.info((Object)("added sections to: " + pathname));
                }
            }
            LOG.info((Object)("----- end updating " + pathname + "-----"));
            ret.add(pathname);
            if (!deps) continue;
            dependencies.add(this.includeCls);
            dependencies.add(this.predeclCls);
        }
        this.cleanupGenerator();
        generatorPass = 1;
        this.generatedFiles.add(o);
        if (deps) {
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                ret.add(this.generateFilesForElem(it.next(), path, deps));
            }
        }
        return ret;
    }

    public Collection generate(Collection elements, boolean deps) {
        ArrayList<Object> ret = new ArrayList<Object>();
        this.startFileGeneration();
        for (Object elem : elements) {
            String path = this.generatePath(elem);
            TreeSet dependencies = null;
            if (deps) {
                dependencies = new TreeSet();
            }
            for (generatorPass = 2; generatorPass <= 3; ++generatorPass) {
                String name = Model.getFacade().getName(elem) + this.getFileExtension();
                String content = this.generateFileAsString(elem, path + name);
                SourceUnit su = new SourceUnit(name, path, content);
                ret.add(su);
            }
            generatorPass = 1;
            this.generatedFiles.add(elem);
            if (!deps) continue;
            ret.add(this.generate(dependencies, deps));
        }
        this.endFileGeneration();
        return ret;
    }

    public Collection generateFiles(Collection elements, String path, boolean deps) {
        ArrayList ret = new ArrayList();
        this.startFileGeneration();
        for (Object elem : elements) {
            ret.addAll(this.generateFilesForElem(elem, path, deps));
        }
        this.endFileGeneration();
        return ret;
    }

    public Collection generateFileList(Collection elements, boolean deps) {
        ArrayList<String> ret = new ArrayList<String>();
        this.startFileGeneration();
        for (Object elem : elements) {
            ret.add(Model.getFacade().getName(elem) + ".cpp");
            ret.add(Model.getFacade().getName(elem) + ".h");
        }
        this.endFileGeneration();
        return null;
    }

    private static String generateUninterpreted(String un) {
        if (un == null) {
            return "";
        }
        return un;
    }

    private static String generateClassifierRef(Object cls) {
        if (cls == null) {
            return "";
        }
        return Model.getFacade().getName(cls);
    }

    private String generateInlinedMethodsOutsideClass(Object cls) {
        String s = new String();
        List op = Model.getFacade().getOperations(cls);
        if (op.isEmpty()) {
            return null;
        }
        s = LINE_SEPARATOR;
        if (this.verboseDocs) {
            s = s + this.indent + "// Operations" + LINE_SEPARATOR;
        }
        int tmpGeneratorPass = generatorPass;
        generatorPass = 3;
        String opString = new String();
        for (Object bf : op) {
            Inline inlineStyle;
            if (Model.getFacade().isAbstract(bf) || !(inlineStyle = Inline.getInlineOperationModifierType(bf)).isMethodBodyOutsideClass()) continue;
            opString = opString + this.generateOperation(bf, false);
            opString = opString + LINE_SEPARATOR + this.generateMethodBody(bf) + LINE_SEPARATOR;
        }
        generatorPass = tmpGeneratorPass;
        if (opString.length() != 0) {
            s = s + opString;
            return s;
        }
        return null;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        ALL_PARTS = new int[]{0, 1, 2};
        PART_NAME = new String[]{"public", "protected", "private"};
        generatorPass = 1;
    }
}

