/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import jp.co.antenna.XfoJavaCtl.MessageListener;
import jp.co.antenna.XfoJavaCtl.XfoException;
import jp.co.antenna.XfoJavaCtl.XfoFormatPageListener;
import jp.co.antenna.XfoJavaCtl.XfoObj;
import net.sf.saxon.s9api.XdmNode;

public class FoAH
implements FoProcessor {
    XProcRuntime runtime = null;
    Properties options = null;
    XStep step = null;
    XfoObj ah = null;

    @Override
    public void initialize(XProcRuntime xProcRuntime, XStep xStep, Properties properties) {
        this.runtime = xProcRuntime;
        this.step = xStep;
        this.options = properties;
        try {
            Boolean bl;
            this.ah = new XfoObj();
            this.ah.setFormatterType(4);
            FoMessages foMessages = new FoMessages();
            this.ah.setMessageListener((MessageListener)foMessages);
            String string = this.getStringProp("OptionsFileURI");
            if (string != null) {
                this.ah.setOptionFileURI(string);
            }
            this.ah.setExitLevel(4);
            Integer n = this.getIntProp("ExitLevel");
            if (n != null) {
                this.ah.setExitLevel(n.intValue());
            }
            if ((n = this.getIntProp("EmbedAllFontsEx")) != null) {
                this.ah.setPdfEmbedAllFontsEx(n.intValue());
            }
            if ((n = this.getIntProp("ImageCompression")) != null) {
                this.ah.setPdfImageCompression(n.intValue());
            }
            if ((bl = this.getBooleanProp("NoAccessibility")) != null) {
                this.ah.setPdfNoAccessibility(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoAddingOrChangingComments")) != null) {
                this.ah.setPdfNoAddingOrChangingComments(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoAssembleDoc")) != null) {
                this.ah.setPdfNoAssembleDoc(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoChanging")) != null) {
                this.ah.setPdfNoChanging(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoContentCopying")) != null) {
                this.ah.setPdfNoContentCopying(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoFillForm")) != null) {
                this.ah.setPdfNoFillForm(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoPrinting")) != null) {
                this.ah.setPdfNoPrinting(bl.booleanValue());
            }
            if ((string = this.getStringProp("OwnersPassword")) != null) {
                this.ah.setPdfOwnerPassword(string);
            }
            if ((bl = this.getBooleanProp("TwoPassFormatting")) != null) {
                this.ah.setTwoPassFormatting(bl.booleanValue());
            }
        }
        catch (XfoException xfoException) {
            throw new XProcException(xfoException);
        }
    }

    @Override
    public void format(XdmNode xdmNode, OutputStream outputStream, String string) {
        String string2 = null;
        if (string == null || "application/pdf".equals(string)) {
            string2 = "@PDF";
        } else if ("application/PostScript".equals(string)) {
            string2 = "@PS";
        } else if ("image/svg+xml".equals(string)) {
            string2 = "@SVG";
        } else if ("application/vnd.inx".equals(string)) {
            string2 = "@INX";
        } else if ("application/vnd.mif".equals(string)) {
            string2 = "@MIF";
        } else if ("text/plain".equals(string)) {
            string2 = "@TXT";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + string);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdmNode.toString().getBytes("UTF-8"));
            this.ah.render((InputStream)byteArrayInputStream, outputStream, string2);
            this.ah.releaseObjectEx();
        }
        catch (XfoException xfoException) {
            if (this.runtime.getDebug()) {
                System.out.println("ErrorLevel = " + xfoException.getErrorLevel() + "\nErrorCode = " + xfoException.getErrorCode() + "\n" + xfoException.getErrorMessage());
                xfoException.printStackTrace();
            }
            throw new XProcException(xfoException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XProcException(unsupportedEncodingException);
        }
    }

    private String getStringProp(String string) {
        return this.options.getProperty(string);
    }

    private Integer getIntProp(String string) {
        String string2 = this.getStringProp(string);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                return new Integer(n);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String string) {
        String string2 = this.options.getProperty(string);
        if (string2 != null) {
            return "true".equals(string2);
        }
        return null;
    }

    private class FoMessages
    implements MessageListener,
    XfoFormatPageListener {
        private FoMessages() {
        }

        public void onMessage(int n, int n2, String string) {
            switch (n) {
                case 1: {
                    FoAH.this.step.info(FoAH.this.step.getNode(), string);
                    return;
                }
                case 2: {
                    FoAH.this.step.warning(FoAH.this.step.getNode(), string);
                    return;
                }
            }
            FoAH.this.step.error(FoAH.this.step.getNode(), string, XProcConstants.stepError(n2));
        }

        public void onFormatPage(int n) {
            FoAH.this.step.finest(FoAH.this.step.getNode(), "Formatted PDF page " + n);
        }
    }
}

