/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.TypeHierarchy;

final class AttributeImpl
extends NodeImpl {
    public AttributeImpl(ElementImpl element, int index) {
        this.setRawParent(element);
        this.setSiblingPosition(index);
    }

    public int getNameCode() {
        if (this.getRawParent() == null || this.getSiblingPosition() == -1) {
            return -1;
        }
        return ((ElementImpl)this.getRawParent()).getAttributeList().getNameCode(this.getSiblingPosition());
    }

    public int getTypeAnnotation() {
        return ((ElementImpl)this.getRawParent()).getAttributeList().getTypeAnnotation(this.getSiblingPosition());
    }

    public boolean isId() {
        if (this.getFingerprint() == 388) {
            return true;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return th.isIdCode(this.getTypeAnnotation());
    }

    public boolean isIdref() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return th.isIdrefsCode(this.getTypeAnnotation());
    }

    public boolean isNilled() {
        return false;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof AttributeImpl)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        AttributeImpl otherAtt = (AttributeImpl)other;
        return this.getRawParent().isSameNodeInfo(otherAtt.getRawParent()) && this.getSiblingPosition() == otherAtt.getSiblingPosition();
    }

    public int hashCode() {
        return this.getRawParent().hashCode() ^ this.getSiblingPosition() << 16;
    }

    protected long getSequenceNumber() {
        long parseq = this.getRawParent().getSequenceNumber();
        return parseq == -1L ? parseq : parseq + 32768L + (long)this.getSiblingPosition();
    }

    public final int getNodeKind() {
        return 2;
    }

    public String getStringValue() {
        return ((ElementImpl)this.getRawParent()).getAttributeList().getValue(this.getSiblingPosition());
    }

    public NodeInfo getNextSibling() {
        return null;
    }

    public NodeInfo getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl anchor) {
        if (anchor == this) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(anchor);
    }

    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append('a');
        buffer.append(Integer.toString(this.getSiblingPosition()));
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        int nameCode = this.getNameCode();
        int typeCode = CopyOptions.includes(copyOptions, 4) ? this.getTypeAnnotation() : 631;
        out.attribute(nameCode, typeCode, this.getStringValue(), locationId, 0);
    }

    public void delete() {
        if (this.getRawParent() != null) {
            this.getRawParent().removeAttribute(this);
        }
        this.setRawParent(null);
        this.setSiblingPosition(-1);
    }

    public boolean isDeleted() {
        return this.getSiblingPosition() == -1 || this.getNameCode() == -1 || this.getRawParent() != null && this.getRawParent().isDeleted();
    }

    public void replace(NodeInfo[] replacement, boolean inherit) {
        if (this.isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.getParent() == null) {
            throw new IllegalStateException("Cannot replace a parentless node");
        }
        ParentNodeImpl element = this.getRawParent();
        this.delete();
        for (int i = 0; i < replacement.length; ++i) {
            NodeInfo n = replacement[i];
            if (n.getNodeKind() != 2) {
                throw new IllegalArgumentException("Replacement nodes must be attributes");
            }
            element.addAttribute(n.getNameCode(), 631, n.getStringValue(), 0);
        }
    }

    public void rename(int newNameCode) {
        if (this.getRawParent() != null) {
            ((AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList()).renameAttribute(this.getSiblingPosition(), newNameCode);
            if (newNameCode >> 20 != 0) {
                int nscode = this.getNamePool().getNamespaceCode(newNameCode);
                int prefixCode = nscode >> 16 & 0xFFFF;
                short uc = ((ElementImpl)this.getRawParent()).getURICodeForPrefixCode(prefixCode);
                if (uc == -1) {
                    this.getRawParent().addNamespace(nscode, false);
                } else if (uc != (nscode & 0xFFFF)) {
                    throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
                }
            }
        }
    }

    public void replaceStringValue(CharSequence stringValue) {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            atts.replaceAttribute(this.getSiblingPosition(), stringValue);
        }
    }

    public void removeTypeAnnotation() {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            atts.setTypeAnnotation(this.getSiblingPosition(), 631);
            this.getRawParent().removeTypeAnnotation();
        }
    }

    public void setTypeAnnotation(int typeCode) {
        if (this.getRawParent() != null) {
            AttributeCollectionImpl atts = (AttributeCollectionImpl)((ElementImpl)this.getRawParent()).getAttributeList();
            atts.setTypeAnnotation(this.getSiblingPosition(), typeCode);
        }
    }
}

