/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class DirectoryList
extends DefaultStep {
    private static final QName _name = new QName("", "name");
    private static final QName _path = new QName("", "path");
    private static final QName _include_filter = new QName("", "include-filter");
    private static final QName _exclude_filter = new QName("", "exclude-filter");
    private static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    private static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    private static final QName c_other = new QName("c", "http://www.w3.org/ns/xproc-step", "other");
    private static final QName px_show_excluded = new QName("http://xmlcalabash.com/ns/extensions", "show-excluded");
    private WritablePipe result = null;
    private String path = ".";
    private String inclFilter = null;
    private String exclFilter = null;

    public DirectoryList(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        File[] fileArray;
        Object object;
        Object object2;
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        if (this.getOption(_path) != null) {
            object2 = this.getOption(_path).getBaseURI();
            object = URIUtils.encode(this.getOption(_path).getString());
            this.path = ((URI)object2).resolve((String)object).toASCIIString();
        } else {
            this.path = this.step.getNode().getBaseURI().resolve(".").toASCIIString();
        }
        this.runtime.finer(null, this.step.getNode(), "path: " + this.path);
        object2 = this.getOption(_include_filter);
        if (object2 != null) {
            this.inclFilter = ((RuntimeValue)object2).getString();
            this.runtime.finer(null, this.step.getNode(), "include: " + this.inclFilter);
        }
        if ((object2 = this.getOption(_exclude_filter)) != null) {
            this.exclFilter = ((RuntimeValue)object2).getString();
            this.runtime.finer(null, this.step.getNode(), "exclude: " + this.exclFilter);
        }
        object = URIUtils.getFile(this.path);
        String string = null;
        try {
            object = ((File)object).getCanonicalFile();
            string = ((File)object).getName();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        if (!((File)object).isDirectory()) {
            throw XProcException.stepError(17);
        }
        if (!((File)object).canRead()) {
            throw XProcException.stepError(12);
        }
        boolean bl = "true".equals(this.step.getExtensionAttribute(px_show_excluded));
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_directory);
        treeWriter.addAttribute(_name, string);
        treeWriter.addAttribute(XProcConstants.xml_base, ((File)object).toURI().toASCIIString());
        treeWriter.startContent();
        for (File file : fileArray = ((File)object).listFiles()) {
            boolean bl2 = true;
            String string2 = file.getName();
            this.runtime.finer(null, this.step.getNode(), "name: " + string2);
            if (this.inclFilter != null) {
                bl2 = string2.matches(this.inclFilter);
                this.runtime.finer(null, this.step.getNode(), "include: " + bl2);
            }
            if (this.exclFilter != null) {
                bl2 = bl2 && !string2.matches(this.exclFilter);
                this.runtime.finer(null, this.step.getNode(), "exclude: " + !bl2);
            }
            if (bl2) {
                if (file.isDirectory()) {
                    treeWriter.addStartElement(c_directory);
                    treeWriter.addAttribute(_name, file.getName());
                    treeWriter.addEndElement();
                    this.finest(this.step.getNode(), "Including directory: " + file.getName());
                    continue;
                }
                if (file.isFile()) {
                    treeWriter.addStartElement(c_file);
                    treeWriter.addAttribute(_name, file.getName());
                    treeWriter.addEndElement();
                    this.finest(this.step.getNode(), "Including file: " + file.getName());
                    continue;
                }
                treeWriter.addStartElement(c_other);
                treeWriter.addAttribute(_name, file.getName());
                treeWriter.addEndElement();
                this.finest(this.step.getNode(), "Including other: " + file.getName());
                continue;
            }
            if (!bl) continue;
            treeWriter.addComment(" excluded: " + file.getName() + " ");
            this.finest(this.step.getNode(), "Excluding: " + file.getName());
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

