/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NComprehension
extends NNode {
    static final long serialVersionUID = -598250664243757218L;
    public NNode target;
    public NNode iter;
    public List<NNode> ifs;

    public NComprehension(NNode target, NNode iter, List<NNode> ifs) {
        this(target, iter, ifs, 0, 1);
    }

    public NComprehension(NNode target, NNode iter, List<NNode> ifs, int start, int end) {
        super(start, end);
        this.target = target;
        this.iter = iter;
        this.ifs = ifs;
        this.addChildren(target, iter);
        this.addChildren(ifs);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s) throws Exception {
        this.bindNames(s, this.target, NameBinder.make());
    }

    private void bindNames(Scope s, NNode target, NameBinder binder) throws Exception {
        if (target instanceof NName) {
            binder.bind(s, (NName)target, (NType)new NUnknownType());
            return;
        }
        if (target instanceof NSequence) {
            for (NNode n : ((NSequence)target).getElements()) {
                this.bindNames(s, n, binder);
            }
        }
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NameBinder.make().bindIter(s, this.target, this.iter);
        this.resolveList(this.ifs, s);
        return this.setType(this.target.getType());
    }

    public String toString() {
        return "<Comprehension:" + this.start() + ":" + this.target + ":" + this.iter + ":" + this.ifs + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNode(this.target, v);
            this.visitNode(this.iter, v);
            this.visitNodeList(this.ifs, v);
        }
    }
}

