# -*- coding: utf-8 -*-
# Autogenerated by Sphinx on Tue Feb  6 21:21:08 2024
# as part of the release process.
topics = {'assert': 'The "assert" statement\n'
           '**********************\n'
           '\n'
           'Assert statements are a convenient way to insert debugging '
           'assertions\n'
           'into a program:\n'
           '\n'
           '   assert_stmt ::= "assert" expression ["," expression]\n'
           '\n'
           'The simple form, "assert expression", is equivalent to\n'
           '\n'
           '   if __debug__:\n'
           '       if not expression: raise AssertionError\n'
           '\n'
           'The extended form, "assert expression1, expression2", is '
           'equivalent to\n'
           '\n'
           '   if __debug__:\n'
           '       if not expression1: raise AssertionError(expression2)\n'
           '\n'
           'These equivalences assume that "__debug__" and "AssertionError" '
           'refer\n'
           'to the built-in variables with those names.  In the current\n'
           'implementation, the built-in variable "__debug__" is "True" under\n'
           'normal circumstances, "False" when optimization is requested '
           '(command\n'
           'line option "-O").  The current code generator emits no code for '
           'an\n'
           'assert statement when optimization is requested at compile time.  '
           'Note\n'
           'that it is unnecessary to include the source code for the '
           'expression\n'
           'that failed in the error message; it will be displayed as part of '
           'the\n'
           'stack trace.\n'
           '\n'
           'Assignments to "__debug__" are illegal.  The value for the '
           'built-in\n'
           'variable is determined when the interpreter starts.\n',
 'assignment': 'Assignment statements\n'
               '*********************\n'
               '\n'
               'Assignment statements are used to (re)bind names to values and '
               'to\n'
               'modify attributes or items of mutable objects:\n'
               '\n'
               '   assignment_stmt ::= (target_list "=")+ (starred_expression '
               '| yield_expression)\n'
               '   target_list     ::= target ("," target)* [","]\n'
               '   target          ::= identifier\n'
               '              | "(" [target_list] ")"\n'
               '              | "[" [target_list] "]"\n'
               '              | attributeref\n'
               '              | subscription\n'
               '              | slicing\n'
               '              | "*" target\n'
               '\n'
               '(See section Primaries for the syntax definitions for '
               '*attributeref*,\n'
               '*subscription*, and *slicing*.)\n'
               '\n'
               'An assignment statement evaluates the expression list '
               '(remember that\n'
               'this can be a single expression or a comma-separated list, the '
               'latter\n'
               'yielding a tuple) and assigns the single resulting object to '
               'each of\n'
               'the target lists, from left to right.\n'
               '\n'
               'Assignment is defined recursively depending on the form of the '
               'target\n'
               '(list). When a target is part of a mutable object (an '
               'attribute\n'
               'reference, subscription or slicing), the mutable object must\n'
               'ultimately perform the assignment and decide about its '
               'validity, and\n'
               'may raise an exception if the assignment is unacceptable.  The '
               'rules\n'
               'observed by various types and the exceptions raised are given '
               'with the\n'
               'definition of the object types (see section The standard type\n'
               'hierarchy).\n'
               '\n'
               'Assignment of an object to a target list, optionally enclosed '
               'in\n'
               'parentheses or square brackets, is recursively defined as '
               'follows.\n'
               '\n'
               '* If the target list is a single target with no trailing '
               'comma,\n'
               '  optionally in parentheses, the object is assigned to that '
               'target.\n'
               '\n'
               '* Else:\n'
               '\n'
               '  * If the target list contains one target prefixed with an '
               'asterisk,\n'
               '    called a “starred” target: The object must be an iterable '
               'with at\n'
               '    least as many items as there are targets in the target '
               'list, minus\n'
               '    one.  The first items of the iterable are assigned, from '
               'left to\n'
               '    right, to the targets before the starred target.  The '
               'final items\n'
               '    of the iterable are assigned to the targets after the '
               'starred\n'
               '    target.  A list of the remaining items in the iterable is '
               'then\n'
               '    assigned to the starred target (the list can be empty).\n'
               '\n'
               '  * Else: The object must be an iterable with the same number '
               'of items\n'
               '    as there are targets in the target list, and the items '
               'are\n'
               '    assigned, from left to right, to the corresponding '
               'targets.\n'
               '\n'
               'Assignment of an object to a single target is recursively '
               'defined as\n'
               'follows.\n'
               '\n'
               '* If the target is an identifier (name):\n'
               '\n'
               '  * If the name does not occur in a "global" or "nonlocal" '
               'statement\n'
               '    in the current code block: the name is bound to the object '
               'in the\n'
               '    current local namespace.\n'
               '\n'
               '  * Otherwise: the name is bound to the object in the global '
               'namespace\n'
               '    or the outer namespace determined by "nonlocal", '
               'respectively.\n'
               '\n'
               '  The name is rebound if it was already bound.  This may cause '
               'the\n'
               '  reference count for the object previously bound to the name '
               'to reach\n'
               '  zero, causing the object to be deallocated and its '
               'destructor (if it\n'
               '  has one) to be called.\n'
               '\n'
               '* If the target is an attribute reference: The primary '
               'expression in\n'
               '  the reference is evaluated.  It should yield an object with\n'
               '  assignable attributes; if this is not the case, "TypeError" '
               'is\n'
               '  raised.  That object is then asked to assign the assigned '
               'object to\n'
               '  the given attribute; if it cannot perform the assignment, it '
               'raises\n'
               '  an exception (usually but not necessarily '
               '"AttributeError").\n'
               '\n'
               '  Note: If the object is a class instance and the attribute '
               'reference\n'
               '  occurs on both sides of the assignment operator, the '
               'right-hand side\n'
               '  expression, "a.x" can access either an instance attribute or '
               '(if no\n'
               '  instance attribute exists) a class attribute.  The left-hand '
               'side\n'
               '  target "a.x" is always set as an instance attribute, '
               'creating it if\n'
               '  necessary.  Thus, the two occurrences of "a.x" do not '
               'necessarily\n'
               '  refer to the same attribute: if the right-hand side '
               'expression\n'
               '  refers to a class attribute, the left-hand side creates a '
               'new\n'
               '  instance attribute as the target of the assignment:\n'
               '\n'
               '     class Cls:\n'
               '         x = 3             # class variable\n'
               '     inst = Cls()\n'
               '     inst.x = inst.x + 1   # writes inst.x as 4 leaving Cls.x '
               'as 3\n'
               '\n'
               '  This description does not necessarily apply to descriptor\n'
               '  attributes, such as properties created with "property()".\n'
               '\n'
               '* If the target is a subscription: The primary expression in '
               'the\n'
               '  reference is evaluated.  It should yield either a mutable '
               'sequence\n'
               '  object (such as a list) or a mapping object (such as a '
               'dictionary).\n'
               '  Next, the subscript expression is evaluated.\n'
               '\n'
               '  If the primary is a mutable sequence object (such as a '
               'list), the\n'
               '  subscript must yield an integer.  If it is negative, the '
               'sequence’s\n'
               '  length is added to it.  The resulting value must be a '
               'nonnegative\n'
               '  integer less than the sequence’s length, and the sequence is '
               'asked\n'
               '  to assign the assigned object to its item with that index.  '
               'If the\n'
               '  index is out of range, "IndexError" is raised (assignment to '
               'a\n'
               '  subscripted sequence cannot add new items to a list).\n'
               '\n'
               '  If the primary is a mapping object (such as a dictionary), '
               'the\n'
               '  subscript must have a type compatible with the mapping’s key '
               'type,\n'
               '  and the mapping is then asked to create a key/value pair '
               'which maps\n'
               '  the subscript to the assigned object.  This can either '
               'replace an\n'
               '  existing key/value pair with the same key value, or insert a '
               'new\n'
               '  key/value pair (if no key with the same value existed).\n'
               '\n'
               '  For user-defined objects, the "__setitem__()" method is '
               'called with\n'
               '  appropriate arguments.\n'
               '\n'
               '* If the target is a slicing: The primary expression in the '
               'reference\n'
               '  is evaluated.  It should yield a mutable sequence object '
               '(such as a\n'
               '  list).  The assigned object should be a sequence object of '
               'the same\n'
               '  type.  Next, the lower and upper bound expressions are '
               'evaluated,\n'
               '  insofar they are present; defaults are zero and the '
               'sequence’s\n'
               '  length.  The bounds should evaluate to integers. If either '
               'bound is\n'
               '  negative, the sequence’s length is added to it.  The '
               'resulting\n'
               '  bounds are clipped to lie between zero and the sequence’s '
               'length,\n'
               '  inclusive.  Finally, the sequence object is asked to replace '
               'the\n'
               '  slice with the items of the assigned sequence.  The length '
               'of the\n'
               '  slice may be different from the length of the assigned '
               'sequence,\n'
               '  thus changing the length of the target sequence, if the '
               'target\n'
               '  sequence allows it.\n'
               '\n'
               '**CPython implementation detail:** In the current '
               'implementation, the\n'
               'syntax for targets is taken to be the same as for expressions, '
               'and\n'
               'invalid syntax is rejected during the code generation phase, '
               'causing\n'
               'less detailed error messages.\n'
               '\n'
               'Although the definition of assignment implies that overlaps '
               'between\n'
               'the left-hand side and the right-hand side are ‘simultaneous’ '
               '(for\n'
               'example "a, b = b, a" swaps two variables), overlaps *within* '
               'the\n'
               'collection of assigned-to variables occur left-to-right, '
               'sometimes\n'
               'resulting in confusion.  For instance, the following program '
               'prints\n'
               '"[0, 2]":\n'
               '\n'
               '   x = [0, 1]\n'
               '   i = 0\n'
               '   i, x[i] = 1, 2         # i is updated, then x[i] is '
               'updated\n'
               '   print(x)\n'
               '\n'
               'See also:\n'
               '\n'
               '  **PEP 3132** - Extended Iterable Unpacking\n'
               '     The specification for the "*target" feature.\n'
               '\n'
               '\n'
               'Augmented assignment statements\n'
               '===============================\n'
               '\n'
               'Augmented assignment is the combination, in a single '
               'statement, of a\n'
               'binary operation and an assignment statement:\n'
               '\n'
               '   augmented_assignment_stmt ::= augtarget augop '
               '(expression_list | yield_expression)\n'
               '   augtarget                 ::= identifier | attributeref | '
               'subscription | slicing\n'
               '   augop                     ::= "+=" | "-=" | "*=" | "@=" | '
               '"/=" | "//=" | "%=" | "**="\n'
               '             | ">>=" | "<<=" | "&=" | "^=" | "|="\n'
               '\n'
               '(See section Primaries for the syntax definitions of the last '
               'three\n'
               'symbols.)\n'
               '\n'
               'An augmented assignment evaluates the target (which, unlike '
               'normal\n'
               'assignment statements, cannot be an unpacking) and the '
               'expression\n'
               'list, performs the binary operation specific to the type of '
               'assignment\n'
               'on the two operands, and assigns the result to the original '
               'target.\n'
               'The target is only evaluated once.\n'
               '\n'
               'An augmented assignment expression like "x += 1" can be '
               'rewritten as\n'
               '"x = x + 1" to achieve a similar, but not exactly equal '
               'effect. In the\n'
               'augmented version, "x" is only evaluated once. Also, when '
               'possible,\n'
               'the actual operation is performed *in-place*, meaning that '
               'rather than\n'
               'creating a new object and assigning that to the target, the '
               'old object\n'
               'is modified instead.\n'
               '\n'
               'Unlike normal assignments, augmented assignments evaluate the '
               'left-\n'
               'hand side *before* evaluating the right-hand side.  For '
               'example, "a[i]\n'
               '+= f(x)" first looks-up "a[i]", then it evaluates "f(x)" and '
               'performs\n'
               'the addition, and lastly, it writes the result back to '
               '"a[i]".\n'
               '\n'
               'With the exception of assigning to tuples and multiple targets '
               'in a\n'
               'single statement, the assignment done by augmented assignment\n'
               'statements is handled the same way as normal assignments. '
               'Similarly,\n'
               'with the exception of the possible *in-place* behavior, the '
               'binary\n'
               'operation performed by augmented assignment is the same as the '
               'normal\n'
               'binary operations.\n'
               '\n'
               'For targets which are attribute references, the same caveat '
               'about\n'
               'class and instance attributes applies as for regular '
               'assignments.\n'
               '\n'
               '\n'
               'Annotated assignment statements\n'
               '===============================\n'
               '\n'
               '*Annotation* assignment is the combination, in a single '
               'statement, of\n'
               'a variable or attribute annotation and an optional assignment\n'
               'statement:\n'
               '\n'
               '   annotated_assignment_stmt ::= augtarget ":" expression\n'
               '                                 ["=" (starred_expression | '
               'yield_expression)]\n'
               '\n'
               'The difference from normal Assignment statements is that only '
               'a single\n'
               'target is allowed.\n'
               '\n'
               'For simple names as assignment targets, if in class or module '
               'scope,\n'
               'the annotations are evaluated and stored in a special class or '
               'module\n'
               'attribute "__annotations__" that is a dictionary mapping from '
               'variable\n'
               'names (mangled if private) to evaluated annotations. This '
               'attribute is\n'
               'writable and is automatically created at the start of class or '
               'module\n'
               'body execution, if annotations are found statically.\n'
               '\n'
               'For expressions as assignment targets, the annotations are '
               'evaluated\n'
               'if in class or module scope, but not stored.\n'
               '\n'
               'If a name is annotated in a function scope, then this name is '
               'local\n'
               'for that scope. Annotations are never evaluated and stored in '
               'function\n'
               'scopes.\n'
               '\n'
               'If the right hand side is present, an annotated assignment '
               'performs\n'
               'the actual assignment before evaluating annotations (where\n'
               'applicable). If the right hand side is not present for an '
               'expression\n'
               'target, then the interpreter evaluates the target except for '
               'the last\n'
               '"__setitem__()" or "__setattr__()" call.\n'
               '\n'
               'See also:\n'
               '\n'
               '  **PEP 526** - Syntax for Variable Annotations\n'
               '     The proposal that added syntax for annotating the types '
               'of\n'
               '     variables (including class variables and instance '
               'variables),\n'
               '     instead of expressing them through comments.\n'
               '\n'
               '  **PEP 484** - Type hints\n'
               '     The proposal that added the "typing" module to provide a '
               'standard\n'
               '     syntax for type annotations that can be used in static '
               'analysis\n'
               '     tools and IDEs.\n'
               '\n'
               'Changed in version 3.8: Now annotated assignments allow the '
               'same\n'
               'expressions in the right hand side as regular assignments. '
               'Previously,\n'
               'some expressions (like un-parenthesized tuple expressions) '
               'caused a\n'
               'syntax error.\n',
 'async': 'Coroutines\n'
          '**********\n'
          '\n'
          'New in version 3.5.\n'
          '\n'
          '\n'
          'Coroutine function definition\n'
          '=============================\n'
          '\n'
          '   async_funcdef ::= [decorators] "async" "def" funcname "(" '
          '[parameter_list] ")"\n'
          '                     ["->" expression] ":" suite\n'
          '\n'
          'Execution of Python coroutines can be suspended and resumed at '
          'many\n'
          'points (see *coroutine*). "await" expressions, "async for" and '
          '"async\n'
          'with" can only be used in the body of a coroutine function.\n'
          '\n'
          'Functions defined with "async def" syntax are always coroutine\n'
          'functions, even if they do not contain "await" or "async" '
          'keywords.\n'
          '\n'
          'It is a "SyntaxError" to use a "yield from" expression inside the '
          'body\n'
          'of a coroutine function.\n'
          '\n'
          'An example of a coroutine function:\n'
          '\n'
          '   async def func(param1, param2):\n'
          '       do_stuff()\n'
          '       await some_coroutine()\n'
          '\n'
          'Changed in version 3.7: "await" and "async" are now keywords;\n'
          'previously they were only treated as such inside the body of a\n'
          'coroutine function.\n'
          '\n'
          '\n'
          'The "async for" statement\n'
          '=========================\n'
          '\n'
          '   async_for_stmt ::= "async" for_stmt\n'
          '\n'
          'An *asynchronous iterable* provides an "__aiter__" method that\n'
          'directly returns an *asynchronous iterator*, which can call\n'
          'asynchronous code in its "__anext__" method.\n'
          '\n'
          'The "async for" statement allows convenient iteration over\n'
          'asynchronous iterables.\n'
          '\n'
          'The following code:\n'
          '\n'
          '   async for TARGET in ITER:\n'
          '       SUITE\n'
          '   else:\n'
          '       SUITE2\n'
          '\n'
          'Is semantically equivalent to:\n'
          '\n'
          '   iter = (ITER)\n'
          '   iter = type(iter).__aiter__(iter)\n'
          '   running = True\n'
          '\n'
          '   while running:\n'
          '       try:\n'
          '           TARGET = await type(iter).__anext__(iter)\n'
          '       except StopAsyncIteration:\n'
          '           running = False\n'
          '       else:\n'
          '           SUITE\n'
          '   else:\n'
          '       SUITE2\n'
          '\n'
          'See also "__aiter__()" and "__anext__()" for details.\n'
          '\n'
          'It is a "SyntaxError" to use an "async for" statement outside the '
          'body\n'
          'of a coroutine function.\n'
          '\n'
          '\n'
          'The "async with" statement\n'
          '==========================\n'
          '\n'
          '   async_with_stmt ::= "async" with_stmt\n'
          '\n'
          'An *asynchronous context manager* is a *context manager* that is '
          'able\n'
          'to suspend execution in its *enter* and *exit* methods.\n'
          '\n'
          'The following code:\n'
          '\n'
          '   async with EXPRESSION as TARGET:\n'
          '       SUITE\n'
          '\n'
          'is semantically equivalent to:\n'
          '\n'
          '   manager = (EXPRESSION)\n'
          '   aenter = type(manager).__aenter__\n'
          '   aexit = type(manager).__aexit__\n'
          '   value = await aenter(manager)\n'
          '   hit_except = False\n'
          '\n'
          '   try:\n'
          '       TARGET = value\n'
          '       SUITE\n'
          '   except:\n'
          '       hit_except = True\n'
          '       if not await aexit(manager, *sys.exc_info()):\n'
          '           raise\n'
          '   finally:\n'
          '       if not hit_except:\n'
          '           await aexit(manager, None, None, None)\n'
          '\n'
          'See also "__aenter__()" and "__aexit__()" for details.\n'
          '\n'
          'It is a "SyntaxError" to use an "async with" statement outside the\n'
          'body of a coroutine function.\n'
          '\n'
          'See also:\n'
          '\n'
          '  **PEP 492** - Coroutines with async and await syntax\n'
          '     The proposal that made coroutines a proper standalone concept '
          'in\n'
          '     Python, and added supporting syntax.\n'
          '\n'
          '-[ Footnotes ]-\n'
          '\n'
          '[1] The exception is propagated to the invocation stack unless '
          'there\n'
          '    is a "finally" clause which happens to raise another '
          'exception.\n'
          '    That new exception causes the old one to be lost.\n'
          '\n'
          '[2] In pattern matching, a sequence is defined as one of the\n'
          '    following:\n'
          '\n'
          '    * a class that inherits from "collections.abc.Sequence"\n'
          '\n'
          '    * a Python class that has been registered as\n'
          '      "collections.abc.Sequence"\n'
          '\n'
          '    * a builtin class that has its (CPython) "Py_TPFLAGS_SEQUENCE" '
          'bit\n'
          '      set\n'
          '\n'
          '    * a class that inherits from any of the above\n'
          '\n'
          '    The following standard library classes are sequences:\n'
          '\n'
          '    * "array.array"\n'
          '\n'
          '    * "collections.deque"\n'
          '\n'
          '    * "list"\n'
          '\n'
          '    * "memoryview"\n'
          '\n'
          '    * "range"\n'
          '\n'
          '    * "tuple"\n'
          '\n'
          '    Note:\n'
          '\n'
          '      Subject values of type "str", "bytes", and "bytearray" do '
          'not\n'
          '      match sequence patterns.\n'
          '\n'
          '[3] In pattern matching, a mapping is defined as one of the '
          'following:\n'
          '\n'
          '    * a class that inherits from "collections.abc.Mapping"\n'
          '\n'
          '    * a Python class that has been registered as\n'
          '      "collections.abc.Mapping"\n'
          '\n'
          '    * a builtin class that has its (CPython) "Py_TPFLAGS_MAPPING" '
          'bit\n'
          '      set\n'
          '\n'
          '    * a class that inherits from any of the above\n'
          '\n'
          '    The standard library classes "dict" and '
          '"types.MappingProxyType"\n'
          '    are mappings.\n'
          '\n'
          '[4] A string literal appearing as the first statement in the '
          'function\n'
          '    body is transformed into the function’s "__doc__" attribute '
          'and\n'
          '    therefore the function’s *docstring*.\n'
          '\n'
          '[5] A string literal appearing as the first statement in the class\n'
          '    body is transformed into the namespace’s "__doc__" item and\n'
          '    therefore the class’s *docstring*.\n',
 'atom-identifiers': 'Identifiers (Names)\n'
                     '*******************\n'
                     '\n'
                     'An identifier occurring as an atom is a name.  See '
                     'section Identifiers\n'
                     'and keywords for lexical definition and section Naming '
                     'and binding for\n'
                     'documentation of naming and binding.\n'
                     '\n'
                     'When the name is bound to an object, evaluation of the '
                     'atom yields\n'
                     'that object. When a name is not bound, an attempt to '
                     'evaluate it\n'
                     'raises a "NameError" exception.\n'
                     '\n'
                     '**Private name mangling:** When an identifier that '
                     'textually occurs in\n'
                     'a class definition begins with two or more underscore '
                     'characters and\n'
                     'does not end in two or more underscores, it is '
                     'considered a *private\n'
                     'name* of that class. Private names are transformed to a '
                     'longer form\n'
                     'before code is generated for them.  The transformation '
                     'inserts the\n'
                     'class name, with leading underscores removed and a '
                     'single underscore\n'
                     'inserted, in front of the name.  For example, the '
                     'identifier "__spam"\n'
                     'occurring in a class named "Ham" will be transformed to '
                     '"_Ham__spam".\n'
                     'This transformation is independent of the syntactical '
                     'context in which\n'
                     'the identifier is used.  If the transformed name is '
                     'extremely long\n'
                     '(longer than 255 characters), implementation defined '
                     'truncation may\n'
                     'happen. If the class name consists only of underscores, '
                     'no\n'
                     'transformation is done.\n',
 'atom-literals': 'Literals\n'
                  '********\n'
                  '\n'
                  'Python supports string and bytes literals and various '
                  'numeric\n'
                  'literals:\n'
                  '\n'
                  '   literal ::= stringliteral | bytesliteral\n'
                  '               | integer | floatnumber | imagnumber\n'
                  '\n'
                  'Evaluation of a literal yields an object of the given type '
                  '(string,\n'
                  'bytes, integer, floating point number, complex number) with '
                  'the given\n'
                  'value.  The value may be approximated in the case of '
                  'floating point\n'
                  'and imaginary (complex) literals.  See section Literals for '
                  'details.\n'
                  '\n'
                  'All literals correspond to immutable data types, and hence '
                  'the\n'
                  'object’s identity is less important than its value.  '
                  'Multiple\n'
                  'evaluations of literals with the same value (either the '
                  'same\n'
                  'occurrence in the program text or a different occurrence) '
                  'may obtain\n'
                  'the same object or a different object with the same '
                  'value.\n',
 'attribute-access': 'Customizing attribute access\n'
                     '****************************\n'
                     '\n'
                     'The following methods can be defined to customize the '
                     'meaning of\n'
                     'attribute access (use of, assignment to, or deletion of '
                     '"x.name") for\n'
                     'class instances.\n'
                     '\n'
                     'object.__getattr__(self, name)\n'
                     '\n'
                     '   Called when the default attribute access fails with '
                     'an\n'
                     '   "AttributeError" (either "__getattribute__()" raises '
                     'an\n'
                     '   "AttributeError" because *name* is not an instance '
                     'attribute or an\n'
                     '   attribute in the class tree for "self"; or '
                     '"__get__()" of a *name*\n'
                     '   property raises "AttributeError").  This method '
                     'should either\n'
                     '   return the (computed) attribute value or raise an '
                     '"AttributeError"\n'
                     '   exception.\n'
                     '\n'
                     '   Note that if the attribute is found through the '
                     'normal mechanism,\n'
                     '   "__getattr__()" is not called.  (This is an '
                     'intentional asymmetry\n'
                     '   between "__getattr__()" and "__setattr__()".) This is '
                     'done both for\n'
                     '   efficiency reasons and because otherwise '
                     '"__getattr__()" would have\n'
                     '   no way to access other attributes of the instance.  '
                     'Note that at\n'
                     '   least for instance variables, you can fake total '
                     'control by not\n'
                     '   inserting any values in the instance attribute '
                     'dictionary (but\n'
                     '   instead inserting them in another object).  See the\n'
                     '   "__getattribute__()" method below for a way to '
                     'actually get total\n'
                     '   control over attribute access.\n'
                     '\n'
                     'object.__getattribute__(self, name)\n'
                     '\n'
                     '   Called unconditionally to implement attribute '
                     'accesses for\n'
                     '   instances of the class. If the class also defines '
                     '"__getattr__()",\n'
                     '   the latter will not be called unless '
                     '"__getattribute__()" either\n'
                     '   calls it explicitly or raises an "AttributeError". '
                     'This method\n'
                     '   should return the (computed) attribute value or raise '
                     'an\n'
                     '   "AttributeError" exception. In order to avoid '
                     'infinite recursion in\n'
                     '   this method, its implementation should always call '
                     'the base class\n'
                     '   method with the same name to access any attributes it '
                     'needs, for\n'
                     '   example, "object.__getattribute__(self, name)".\n'
                     '\n'
                     '   Note:\n'
                     '\n'
                     '     This method may still be bypassed when looking up '
                     'special methods\n'
                     '     as the result of implicit invocation via language '
                     'syntax or\n'
                     '     built-in functions. See Special method lookup.\n'
                     '\n'
                     '   For certain sensitive attribute accesses, raises an '
                     'auditing event\n'
                     '   "object.__getattr__" with arguments "obj" and '
                     '"name".\n'
                     '\n'
                     'object.__setattr__(self, name, value)\n'
                     '\n'
                     '   Called when an attribute assignment is attempted.  '
                     'This is called\n'
                     '   instead of the normal mechanism (i.e. store the value '
                     'in the\n'
                     '   instance dictionary). *name* is the attribute name, '
                     '*value* is the\n'
                     '   value to be assigned to it.\n'
                     '\n'
                     '   If "__setattr__()" wants to assign to an instance '
                     'attribute, it\n'
                     '   should call the base class method with the same name, '
                     'for example,\n'
                     '   "object.__setattr__(self, name, value)".\n'
                     '\n'
                     '   For certain sensitive attribute assignments, raises '
                     'an auditing\n'
                     '   event "object.__setattr__" with arguments "obj", '
                     '"name", "value".\n'
                     '\n'
                     'object.__delattr__(self, name)\n'
                     '\n'
                     '   Like "__setattr__()" but for attribute deletion '
                     'instead of\n'
                     '   assignment.  This should only be implemented if "del '
                     'obj.name" is\n'
                     '   meaningful for the object.\n'
                     '\n'
                     '   For certain sensitive attribute deletions, raises an '
                     'auditing event\n'
                     '   "object.__delattr__" with arguments "obj" and '
                     '"name".\n'
                     '\n'
                     'object.__dir__(self)\n'
                     '\n'
                     '   Called when "dir()" is called on the object. A '
                     'sequence must be\n'
                     '   returned. "dir()" converts the returned sequence to a '
                     'list and\n'
                     '   sorts it.\n'
                     '\n'
                     '\n'
                     'Customizing module attribute access\n'
                     '===================================\n'
                     '\n'
                     'Special names "__getattr__" and "__dir__" can be also '
                     'used to\n'
                     'customize access to module attributes. The "__getattr__" '
                     'function at\n'
                     'the module level should accept one argument which is the '
                     'name of an\n'
                     'attribute and return the computed value or raise an '
                     '"AttributeError".\n'
                     'If an attribute is not found on a module object through '
                     'the normal\n'
                     'lookup, i.e. "object.__getattribute__()", then '
                     '"__getattr__" is\n'
                     'searched in the module "__dict__" before raising an '
                     '"AttributeError".\n'
                     'If found, it is called with the attribute name and the '
                     'result is\n'
                     'returned.\n'
                     '\n'
                     'The "__dir__" function should accept no arguments, and '
                     'return a\n'
                     'sequence of strings that represents the names accessible '
                     'on module. If\n'
                     'present, this function overrides the standard "dir()" '
                     'search on a\n'
                     'module.\n'
                     '\n'
                     'For a more fine grained customization of the module '
                     'behavior (setting\n'
                     'attributes, properties, etc.), one can set the '
                     '"__class__" attribute\n'
                     'of a module object to a subclass of "types.ModuleType". '
                     'For example:\n'
                     '\n'
                     '   import sys\n'
                     '   from types import ModuleType\n'
                     '\n'
                     '   class VerboseModule(ModuleType):\n'
                     '       def __repr__(self):\n'
                     "           return f'Verbose {self.__name__}'\n"
                     '\n'
                     '       def __setattr__(self, attr, value):\n'
                     "           print(f'Setting {attr}...')\n"
                     '           super().__setattr__(attr, value)\n'
                     '\n'
                     '   sys.modules[__name__].__class__ = VerboseModule\n'
                     '\n'
                     'Note:\n'
                     '\n'
                     '  Defining module "__getattr__" and setting module '
                     '"__class__" only\n'
                     '  affect lookups made using the attribute access syntax '
                     '– directly\n'
                     '  accessing the module globals (whether by code within '
                     'the module, or\n'
                     '  via a reference to the module’s globals dictionary) is '
                     'unaffected.\n'
                     '\n'
                     'Changed in version 3.5: "__class__" module attribute is '
                     'now writable.\n'
                     '\n'
                     'New in version 3.7: "__getattr__" and "__dir__" module '
                     'attributes.\n'
                     '\n'
                     'See also:\n'
                     '\n'
                     '  **PEP 562** - Module __getattr__ and __dir__\n'
                     '     Describes the "__getattr__" and "__dir__" functions '
                     'on modules.\n'
                     '\n'
                     '\n'
                     'Implementing Descriptors\n'
                     '========================\n'
                     '\n'
                     'The following methods only apply when an instance of the '
                     'class\n'
                     'containing the method (a so-called *descriptor* class) '
                     'appears in an\n'
                     '*owner* class (the descriptor must be in either the '
                     'owner’s class\n'
                     'dictionary or in the class dictionary for one of its '
                     'parents).  In the\n'
                     'examples below, “the attribute” refers to the attribute '
                     'whose name is\n'
                     'the key of the property in the owner class’ "__dict__".\n'
                     '\n'
                     'object.__get__(self, instance, owner=None)\n'
                     '\n'
                     '   Called to get the attribute of the owner class (class '
                     'attribute\n'
                     '   access) or of an instance of that class (instance '
                     'attribute\n'
                     '   access). The optional *owner* argument is the owner '
                     'class, while\n'
                     '   *instance* is the instance that the attribute was '
                     'accessed through,\n'
                     '   or "None" when the attribute is accessed through the '
                     '*owner*.\n'
                     '\n'
                     '   This method should return the computed attribute '
                     'value or raise an\n'
                     '   "AttributeError" exception.\n'
                     '\n'
                     '   **PEP 252** specifies that "__get__()" is callable '
                     'with one or two\n'
                     '   arguments.  Python’s own built-in descriptors support '
                     'this\n'
                     '   specification; however, it is likely that some '
                     'third-party tools\n'
                     '   have descriptors that require both arguments.  '
                     'Python’s own\n'
                     '   "__getattribute__()" implementation always passes in '
                     'both arguments\n'
                     '   whether they are required or not.\n'
                     '\n'
                     'object.__set__(self, instance, value)\n'
                     '\n'
                     '   Called to set the attribute on an instance *instance* '
                     'of the owner\n'
                     '   class to a new value, *value*.\n'
                     '\n'
                     '   Note, adding "__set__()" or "__delete__()" changes '
                     'the kind of\n'
                     '   descriptor to a “data descriptor”.  See Invoking '
                     'Descriptors for\n'
                     '   more details.\n'
                     '\n'
                     'object.__delete__(self, instance)\n'
                     '\n'
                     '   Called to delete the attribute on an instance '
                     '*instance* of the\n'
                     '   owner class.\n'
                     '\n'
                     'Instances of descriptors may also have the '
                     '"__objclass__" attribute\n'
                     'present:\n'
                     '\n'
                     'object.__objclass__\n'
                     '\n'
                     '   The attribute "__objclass__" is interpreted by the '
                     '"inspect" module\n'
                     '   as specifying the class where this object was defined '
                     '(setting this\n'
                     '   appropriately can assist in runtime introspection of '
                     'dynamic class\n'
                     '   attributes). For callables, it may indicate that an '
                     'instance of the\n'
                     '   given type (or a subclass) is expected or required as '
                     'the first\n'
                     '   positional argument (for example, CPython sets this '
                     'attribute for\n'
                     '   unbound methods that are implemented in C).\n'
                     '\n'
                     '\n'
                     'Invoking Descriptors\n'
                     '====================\n'
                     '\n'
                     'In general, a descriptor is an object attribute with '
                     '“binding\n'
                     'behavior”, one whose attribute access has been '
                     'overridden by methods\n'
                     'in the descriptor protocol:  "__get__()", "__set__()", '
                     'and\n'
                     '"__delete__()". If any of those methods are defined for '
                     'an object, it\n'
                     'is said to be a descriptor.\n'
                     '\n'
                     'The default behavior for attribute access is to get, '
                     'set, or delete\n'
                     'the attribute from an object’s dictionary. For instance, '
                     '"a.x" has a\n'
                     'lookup chain starting with "a.__dict__[\'x\']", then\n'
                     '"type(a).__dict__[\'x\']", and continuing through the '
                     'base classes of\n'
                     '"type(a)" excluding metaclasses.\n'
                     '\n'
                     'However, if the looked-up value is an object defining '
                     'one of the\n'
                     'descriptor methods, then Python may override the default '
                     'behavior and\n'
                     'invoke the descriptor method instead.  Where this occurs '
                     'in the\n'
                     'precedence chain depends on which descriptor methods '
                     'were defined and\n'
                     'how they were called.\n'
                     '\n'
                     'The starting point for descriptor invocation is a '
                     'binding, "a.x". How\n'
                     'the arguments are assembled depends on "a":\n'
                     '\n'
                     'Direct Call\n'
                     '   The simplest and least common call is when user code '
                     'directly\n'
                     '   invokes a descriptor method:    "x.__get__(a)".\n'
                     '\n'
                     'Instance Binding\n'
                     '   If binding to an object instance, "a.x" is '
                     'transformed into the\n'
                     '   call: "type(a).__dict__[\'x\'].__get__(a, type(a))".\n'
                     '\n'
                     'Class Binding\n'
                     '   If binding to a class, "A.x" is transformed into the '
                     'call:\n'
                     '   "A.__dict__[\'x\'].__get__(None, A)".\n'
                     '\n'
                     'Super Binding\n'
                     '   A dotted lookup such as "super(A, a).x" searches\n'
                     '   "a.__class__.__mro__" for a base class "B" following '
                     '"A" and then\n'
                     '   returns "B.__dict__[\'x\'].__get__(a, A)".  If not a '
                     'descriptor, "x"\n'
                     '   is returned unchanged.\n'
                     '\n'
                     'For instance bindings, the precedence of descriptor '
                     'invocation depends\n'
                     'on which descriptor methods are defined.  A descriptor '
                     'can define any\n'
                     'combination of "__get__()", "__set__()" and '
                     '"__delete__()".  If it\n'
                     'does not define "__get__()", then accessing the '
                     'attribute will return\n'
                     'the descriptor object itself unless there is a value in '
                     'the object’s\n'
                     'instance dictionary.  If the descriptor defines '
                     '"__set__()" and/or\n'
                     '"__delete__()", it is a data descriptor; if it defines '
                     'neither, it is\n'
                     'a non-data descriptor.  Normally, data descriptors '
                     'define both\n'
                     '"__get__()" and "__set__()", while non-data descriptors '
                     'have just the\n'
                     '"__get__()" method.  Data descriptors with "__get__()" '
                     'and "__set__()"\n'
                     '(and/or "__delete__()") defined always override a '
                     'redefinition in an\n'
                     'instance dictionary.  In contrast, non-data descriptors '
                     'can be\n'
                     'overridden by instances.\n'
                     '\n'
                     'Python methods (including those decorated with '
                     '"@staticmethod" and\n'
                     '"@classmethod") are implemented as non-data '
                     'descriptors.  Accordingly,\n'
                     'instances can redefine and override methods.  This '
                     'allows individual\n'
                     'instances to acquire behaviors that differ from other '
                     'instances of the\n'
                     'same class.\n'
                     '\n'
                     'The "property()" function is implemented as a data '
                     'descriptor.\n'
                     'Accordingly, instances cannot override the behavior of a '
                     'property.\n'
                     '\n'
                     '\n'
                     '__slots__\n'
                     '=========\n'
                     '\n'
                     '*__slots__* allow us to explicitly declare data members '
                     '(like\n'
                     'properties) and deny the creation of "__dict__" and '
                     '*__weakref__*\n'
                     '(unless explicitly declared in *__slots__* or available '
                     'in a parent.)\n'
                     '\n'
                     'The space saved over using "__dict__" can be '
                     'significant. Attribute\n'
                     'lookup speed can be significantly improved as well.\n'
                     '\n'
                     'object.__slots__\n'
                     '\n'
                     '   This class variable can be assigned a string, '
                     'iterable, or sequence\n'
                     '   of strings with variable names used by instances.  '
                     '*__slots__*\n'
                     '   reserves space for the declared variables and '
                     'prevents the\n'
                     '   automatic creation of "__dict__" and *__weakref__* '
                     'for each\n'
                     '   instance.\n'
                     '\n'
                     'Notes on using *__slots__*:\n'
                     '\n'
                     '* When inheriting from a class without *__slots__*, the '
                     '"__dict__" and\n'
                     '  *__weakref__* attribute of the instances will always '
                     'be accessible.\n'
                     '\n'
                     '* Without a "__dict__" variable, instances cannot be '
                     'assigned new\n'
                     '  variables not listed in the *__slots__* definition.  '
                     'Attempts to\n'
                     '  assign to an unlisted variable name raises '
                     '"AttributeError". If\n'
                     '  dynamic assignment of new variables is desired, then '
                     'add\n'
                     '  "\'__dict__\'" to the sequence of strings in the '
                     '*__slots__*\n'
                     '  declaration.\n'
                     '\n'
                     '* Without a *__weakref__* variable for each instance, '
                     'classes defining\n'
                     '  *__slots__* do not support "weak references" to its '
                     'instances. If\n'
                     '  weak reference support is needed, then add '
                     '"\'__weakref__\'" to the\n'
                     '  sequence of strings in the *__slots__* declaration.\n'
                     '\n'
                     '* *__slots__* are implemented at the class level by '
                     'creating\n'
                     '  descriptors for each variable name.  As a result, '
                     'class attributes\n'
                     '  cannot be used to set default values for instance '
                     'variables defined\n'
                     '  by *__slots__*; otherwise, the class attribute would '
                     'overwrite the\n'
                     '  descriptor assignment.\n'
                     '\n'
                     '* The action of a *__slots__* declaration is not limited '
                     'to the class\n'
                     '  where it is defined.  *__slots__* declared in parents '
                     'are available\n'
                     '  in child classes. However, child subclasses will get a '
                     '"__dict__"\n'
                     '  and *__weakref__* unless they also define *__slots__* '
                     '(which should\n'
                     '  only contain names of any *additional* slots).\n'
                     '\n'
                     '* If a class defines a slot also defined in a base '
                     'class, the instance\n'
                     '  variable defined by the base class slot is '
                     'inaccessible (except by\n'
                     '  retrieving its descriptor directly from the base '
                     'class). This\n'
                     '  renders the meaning of the program undefined.  In the '
                     'future, a\n'
                     '  check may be added to prevent this.\n'
                     '\n'
                     '* "TypeError" will be raised if nonempty *__slots__* are '
                     'defined for a\n'
                     '  class derived from a ""variable-length" built-in type" '
                     'such as\n'
                     '  "int", "bytes", and "tuple".\n'
                     '\n'
                     '* Any non-string *iterable* may be assigned to '
                     '*__slots__*.\n'
                     '\n'
                     '* If a "dictionary" is used to assign *__slots__*, the '
                     'dictionary keys\n'
                     '  will be used as the slot names. The values of the '
                     'dictionary can be\n'
                     '  used to provide per-attribute docstrings that will be '
                     'recognised by\n'
                     '  "inspect.getdoc()" and displayed in the output of '
                     '"help()".\n'
                     '\n'
                     '* "__class__" assignment works only if both classes have '
                     'the same\n'
                     '  *__slots__*.\n'
                     '\n'
                     '* Multiple inheritance with multiple slotted parent '
                     'classes can be\n'
                     '  used, but only one parent is allowed to have '
                     'attributes created by\n'
                     '  slots (the other bases must have empty slot layouts) - '
                     'violations\n'
                     '  raise "TypeError".\n'
                     '\n'
                     '* If an *iterator* is used for *__slots__* then a '
                     '*descriptor* is\n'
                     '  created for each of the iterator’s values. However, '
                     'the *__slots__*\n'
                     '  attribute will be an empty iterator.\n',
 'attribute-references': 'Attribute references\n'
                         '********************\n'
                         '\n'
                         'An attribute reference is a primary followed by a '
                         'period and a name:\n'
                         '\n'
                         '   attributeref ::= primary "." identifier\n'
                         '\n'
                         'The primary must evaluate to an object of a type '
                         'that supports\n'
                         'attribute references, which most objects do.  This '
                         'object is then\n'
                         'asked to produce the attribute whose name is the '
                         'identifier. The type\n'
                         'and value produced is determined by the object.  '
                         'Multiple evaluations\n'
                         'of the same attribute reference may yield different '
                         'objects.\n'
                         '\n'
                         'This production can be customized by overriding the\n'
                         '"__getattribute__()" method or the "__getattr__()" '
                         'method.  The\n'
                         '"__getattribute__()" method is called first and '
                         'either returns a value\n'
                         'or raises "AttributeError" if the attribute is not '
                         'available.\n'
                         '\n'
                         'If an "AttributeError" is raised and the object has '
                         'a "__getattr__()"\n'
                         'method, that method is called as a fallback.\n',
 'augassign': 'Augmented assignment statements\n'
              '*******************************\n'
              '\n'
              'Augmented assignment is the combination, in a single statement, '
              'of a\n'
              'binary operation and an assignment statement:\n'
              '\n'
              '   augmented_assignment_stmt ::= augtarget augop '
              '(expression_list | yield_expression)\n'
              '   augtarget                 ::= identifier | attributeref | '
              'subscription | slicing\n'
              '   augop                     ::= "+=" | "-=" | "*=" | "@=" | '
              '"/=" | "//=" | "%=" | "**="\n'
              '             | ">>=" | "<<=" | "&=" | "^=" | "|="\n'
              '\n'
              '(See section Primaries for the syntax definitions of the last '
              'three\n'
              'symbols.)\n'
              '\n'
              'An augmented assignment evaluates the target (which, unlike '
              'normal\n'
              'assignment statements, cannot be an unpacking) and the '
              'expression\n'
              'list, performs the binary operation specific to the type of '
              'assignment\n'
              'on the two operands, and assigns the result to the original '
              'target.\n'
              'The target is only evaluated once.\n'
              '\n'
              'An augmented assignment expression like "x += 1" can be '
              'rewritten as\n'
              '"x = x + 1" to achieve a similar, but not exactly equal effect. '
              'In the\n'
              'augmented version, "x" is only evaluated once. Also, when '
              'possible,\n'
              'the actual operation is performed *in-place*, meaning that '
              'rather than\n'
              'creating a new object and assigning that to the target, the old '
              'object\n'
              'is modified instead.\n'
              '\n'
              'Unlike normal assignments, augmented assignments evaluate the '
              'left-\n'
              'hand side *before* evaluating the right-hand side.  For '
              'example, "a[i]\n'
              '+= f(x)" first looks-up "a[i]", then it evaluates "f(x)" and '
              'performs\n'
              'the addition, and lastly, it writes the result back to "a[i]".\n'
              '\n'
              'With the exception of assigning to tuples and multiple targets '
              'in a\n'
              'single statement, the assignment done by augmented assignment\n'
              'statements is handled the same way as normal assignments. '
              'Similarly,\n'
              'with the exception of the possible *in-place* behavior, the '
              'binary\n'
              'operation performed by augmented assignment is the same as the '
              'normal\n'
              'binary operations.\n'
              '\n'
              'For targets which are attribute references, the same caveat '
              'about\n'
              'class and instance attributes applies as for regular '
              'assignments.\n',
 'await': 'Await expression\n'
          '****************\n'
          '\n'
          'Suspend the execution of *coroutine* on an *awaitable* object. Can\n'
          'only be used inside a *coroutine function*.\n'
          '\n'
          '   await_expr ::= "await" primary\n'
          '\n'
          'New in version 3.5.\n',
 'binary': 'Binary arithmetic operations\n'
           '****************************\n'
           '\n'
           'The binary arithmetic operations have the conventional priority\n'
           'levels.  Note that some of these operations also apply to certain '
           'non-\n'
           'numeric types.  Apart from the power operator, there are only two\n'
           'levels, one for multiplicative operators and one for additive\n'
           'operators:\n'
           '\n'
           '   m_expr ::= u_expr | m_expr "*" u_expr | m_expr "@" m_expr |\n'
           '              m_expr "//" u_expr | m_expr "/" u_expr |\n'
           '              m_expr "%" u_expr\n'
           '   a_expr ::= m_expr | a_expr "+" m_expr | a_expr "-" m_expr\n'
           '\n'
           'The "*" (multiplication) operator yields the product of its '
           'arguments.\n'
           'The arguments must either both be numbers, or one argument must be '
           'an\n'
           'integer and the other must be a sequence. In the former case, the\n'
           'numbers are converted to a common type and then multiplied '
           'together.\n'
           'In the latter case, sequence repetition is performed; a negative\n'
           'repetition factor yields an empty sequence.\n'
           '\n'
           'This operation can be customized using the special "__mul__()" '
           'and\n'
           '"__rmul__()" methods.\n'
           '\n'
           'The "@" (at) operator is intended to be used for matrix\n'
           'multiplication.  No builtin Python types implement this operator.\n'
           '\n'
           'New in version 3.5.\n'
           '\n'
           'The "/" (division) and "//" (floor division) operators yield the\n'
           'quotient of their arguments.  The numeric arguments are first\n'
           'converted to a common type. Division of integers yields a float, '
           'while\n'
           'floor division of integers results in an integer; the result is '
           'that\n'
           'of mathematical division with the ‘floor’ function applied to the\n'
           'result.  Division by zero raises the "ZeroDivisionError" '
           'exception.\n'
           '\n'
           'This operation can be customized using the special "__truediv__()" '
           'and\n'
           '"__floordiv__()" methods.\n'
           '\n'
           'The "%" (modulo) operator yields the remainder from the division '
           'of\n'
           'the first argument by the second.  The numeric arguments are '
           'first\n'
           'converted to a common type.  A zero right argument raises the\n'
           '"ZeroDivisionError" exception.  The arguments may be floating '
           'point\n'
           'numbers, e.g., "3.14%0.7" equals "0.34" (since "3.14" equals '
           '"4*0.7 +\n'
           '0.34".)  The modulo operator always yields a result with the same '
           'sign\n'
           'as its second operand (or zero); the absolute value of the result '
           'is\n'
           'strictly smaller than the absolute value of the second operand '
           '[1].\n'
           '\n'
           'The floor division and modulo operators are connected by the '
           'following\n'
           'identity: "x == (x//y)*y + (x%y)".  Floor division and modulo are '
           'also\n'
           'connected with the built-in function "divmod()": "divmod(x, y) ==\n'
           '(x//y, x%y)". [2].\n'
           '\n'
           'In addition to performing the modulo operation on numbers, the '
           '"%"\n'
           'operator is also overloaded by string objects to perform '
           'old-style\n'
           'string formatting (also known as interpolation).  The syntax for\n'
           'string formatting is described in the Python Library Reference,\n'
           'section printf-style String Formatting.\n'
           '\n'
           'The *modulo* operation can be customized using the special '
           '"__mod__()"\n'
           'method.\n'
           '\n'
           'The floor division operator, the modulo operator, and the '
           '"divmod()"\n'
           'function are not defined for complex numbers.  Instead, convert to '
           'a\n'
           'floating point number using the "abs()" function if appropriate.\n'
           '\n'
           'The "+" (addition) operator yields the sum of its arguments.  The\n'
           'arguments must either both be numbers or both be sequences of the '
           'same\n'
           'type.  In the former case, the numbers are converted to a common '
           'type\n'
           'and then added together. In the latter case, the sequences are\n'
           'concatenated.\n'
           '\n'
           'This operation can be customized using the special "__add__()" '
           'and\n'
           '"__radd__()" methods.\n'
           '\n'
           'The "-" (subtraction) operator yields the difference of its '
           'arguments.\n'
           'The numeric arguments are first converted to a common type.\n'
           '\n'
           'This operation can be customized using the special "__sub__()" '
           'method.\n',
 'bitwise': 'Binary bitwise operations\n'
            '*************************\n'
            '\n'
            'Each of the three bitwise operations has a different priority '
            'level:\n'
            '\n'
            '   and_expr ::= shift_expr | and_expr "&" shift_expr\n'
            '   xor_expr ::= and_expr | xor_expr "^" and_expr\n'
            '   or_expr  ::= xor_expr | or_expr "|" xor_expr\n'
            '\n'
            'The "&" operator yields the bitwise AND of its arguments, which '
            'must\n'
            'be integers or one of them must be a custom object overriding\n'
            '"__and__()" or "__rand__()" special methods.\n'
            '\n'
            'The "^" operator yields the bitwise XOR (exclusive OR) of its\n'
            'arguments, which must be integers or one of them must be a '
            'custom\n'
            'object overriding "__xor__()" or "__rxor__()" special methods.\n'
            '\n'
            'The "|" operator yields the bitwise (inclusive) OR of its '
            'arguments,\n'
            'which must be integers or one of them must be a custom object\n'
            'overriding "__or__()" or "__ror__()" special methods.\n',
 'bltin-code-objects': 'Code Objects\n'
                       '************\n'
                       '\n'
                       'Code objects are used by the implementation to '
                       'represent “pseudo-\n'
                       'compiled” executable Python code such as a function '
                       'body. They differ\n'
                       'from function objects because they don’t contain a '
                       'reference to their\n'
                       'global execution environment.  Code objects are '
                       'returned by the built-\n'
                       'in "compile()" function and can be extracted from '
                       'function objects\n'
                       'through their "__code__" attribute. See also the '
                       '"code" module.\n'
                       '\n'
                       'Accessing "__code__" raises an auditing event '
                       '"object.__getattr__"\n'
                       'with arguments "obj" and ""__code__"".\n'
                       '\n'
                       'A code object can be executed or evaluated by passing '
                       'it (instead of a\n'
                       'source string) to the "exec()" or "eval()"  built-in '
                       'functions.\n'
                       '\n'
                       'See The standard type hierarchy for more '
                       'information.\n',
 'bltin-ellipsis-object': 'The Ellipsis Object\n'
                          '*******************\n'
                          '\n'
                          'This object is commonly used by slicing (see '
                          'Slicings).  It supports\n'
                          'no special operations.  There is exactly one '
                          'ellipsis object, named\n'
                          '"Ellipsis" (a built-in name).  "type(Ellipsis)()" '
                          'produces the\n'
                          '"Ellipsis" singleton.\n'
                          '\n'
                          'It is written as "Ellipsis" or "...".\n',
 'bltin-null-object': 'The Null Object\n'
                      '***************\n'
                      '\n'
                      'This object is returned by functions that don’t '
                      'explicitly return a\n'
                      'value.  It supports no special operations.  There is '
                      'exactly one null\n'
                      'object, named "None" (a built-in name).  "type(None)()" '
                      'produces the\n'
                      'same singleton.\n'
                      '\n'
                      'It is written as "None".\n',
 'bltin-type-objects': 'Type Objects\n'
                       '************\n'
                       '\n'
                       'Type objects represent the various object types.  An '
                       'object’s type is\n'
                       'accessed by the built-in function "type()".  There are '
                       'no special\n'
                       'operations on types.  The standard module "types" '
                       'defines names for\n'
                       'all standard built-in types.\n'
                       '\n'
                       'Types are written like this: "<class \'int\'>".\n',
 'booleans': 'Boolean operations\n'
             '******************\n'
             '\n'
             '   or_test  ::= and_test | or_test "or" and_test\n'
             '   and_test ::= not_test | and_test "and" not_test\n'
             '   not_test ::= comparison | "not" not_test\n'
             '\n'
             'In the context of Boolean operations, and also when expressions '
             'are\n'
             'used by control flow statements, the following values are '
             'interpreted\n'
             'as false: "False", "None", numeric zero of all types, and empty\n'
             'strings and containers (including strings, tuples, lists,\n'
             'dictionaries, sets and frozensets).  All other values are '
             'interpreted\n'
             'as true.  User-defined objects can customize their truth value '
             'by\n'
             'providing a "__bool__()" method.\n'
             '\n'
             'The operator "not" yields "True" if its argument is false, '
             '"False"\n'
             'otherwise.\n'
             '\n'
             'The expression "x and y" first evaluates *x*; if *x* is false, '
             'its\n'
             'value is returned; otherwise, *y* is evaluated and the resulting '
             'value\n'
             'is returned.\n'
             '\n'
             'The expression "x or y" first evaluates *x*; if *x* is true, its '
             'value\n'
             'is returned; otherwise, *y* is evaluated and the resulting value '
             'is\n'
             'returned.\n'
             '\n'
             'Note that neither "and" nor "or" restrict the value and type '
             'they\n'
             'return to "False" and "True", but rather return the last '
             'evaluated\n'
             'argument.  This is sometimes useful, e.g., if "s" is a string '
             'that\n'
             'should be replaced by a default value if it is empty, the '
             'expression\n'
             '"s or \'foo\'" yields the desired value.  Because "not" has to '
             'create a\n'
             'new value, it returns a boolean value regardless of the type of '
             'its\n'
             'argument (for example, "not \'foo\'" produces "False" rather '
             'than "\'\'".)\n',
 'break': 'The "break" statement\n'
          '*********************\n'
          '\n'
          '   break_stmt ::= "break"\n'
          '\n'
          '"break" may only occur syntactically nested in a "for" or "while"\n'
          'loop, but not nested in a function or class definition within that\n'
          'loop.\n'
          '\n'
          'It terminates the nearest enclosing loop, skipping the optional '
          '"else"\n'
          'clause if the loop has one.\n'
          '\n'
          'If a "for" loop is terminated by "break", the loop control target\n'
          'keeps its current value.\n'
          '\n'
          'When "break" passes control out of a "try" statement with a '
          '"finally"\n'
          'clause, that "finally" clause is executed before really leaving '
          'the\n'
          'loop.\n',
 'callable-types': 'Emulating callable objects\n'
                   '**************************\n'
                   '\n'
                   'object.__call__(self[, args...])\n'
                   '\n'
                   '   Called when the instance is “called” as a function; if '
                   'this method\n'
                   '   is defined, "x(arg1, arg2, ...)" roughly translates to\n'
                   '   "type(x).__call__(x, arg1, ...)".\n',
 'calls': 'Calls\n'
          '*****\n'
          '\n'
          'A call calls a callable object (e.g., a *function*) with a '
          'possibly\n'
          'empty series of *arguments*:\n'
          '\n'
          '   call                 ::= primary "(" [argument_list [","] | '
          'comprehension] ")"\n'
          '   argument_list        ::= positional_arguments ["," '
          'starred_and_keywords]\n'
          '                       ["," keywords_arguments]\n'
          '                     | starred_and_keywords ["," '
          'keywords_arguments]\n'
          '                     | keywords_arguments\n'
          '   positional_arguments ::= positional_item ("," positional_item)*\n'
          '   positional_item      ::= assignment_expression | "*" expression\n'
          '   starred_and_keywords ::= ("*" expression | keyword_item)\n'
          '                            ("," "*" expression | "," '
          'keyword_item)*\n'
          '   keywords_arguments   ::= (keyword_item | "**" expression)\n'
          '                          ("," keyword_item | "," "**" '
          'expression)*\n'
          '   keyword_item         ::= identifier "=" expression\n'
          '\n'
          'An optional trailing comma may be present after the positional and\n'
          'keyword arguments but does not affect the semantics.\n'
          '\n'
          'The primary must evaluate to a callable object (user-defined\n'
          'functions, built-in functions, methods of built-in objects, class\n'
          'objects, methods of class instances, and all objects having a\n'
          '"__call__()" method are callable).  All argument expressions are\n'
          'evaluated before the call is attempted.  Please refer to section\n'
          'Function definitions for the syntax of formal *parameter* lists.\n'
          '\n'
          'If keyword arguments are present, they are first converted to\n'
          'positional arguments, as follows.  First, a list of unfilled slots '
          'is\n'
          'created for the formal parameters.  If there are N positional\n'
          'arguments, they are placed in the first N slots.  Next, for each\n'
          'keyword argument, the identifier is used to determine the\n'
          'corresponding slot (if the identifier is the same as the first '
          'formal\n'
          'parameter name, the first slot is used, and so on).  If the slot '
          'is\n'
          'already filled, a "TypeError" exception is raised. Otherwise, the\n'
          'argument is placed in the slot, filling it (even if the expression '
          'is\n'
          '"None", it fills the slot).  When all arguments have been '
          'processed,\n'
          'the slots that are still unfilled are filled with the '
          'corresponding\n'
          'default value from the function definition.  (Default values are\n'
          'calculated, once, when the function is defined; thus, a mutable '
          'object\n'
          'such as a list or dictionary used as default value will be shared '
          'by\n'
          'all calls that don’t specify an argument value for the '
          'corresponding\n'
          'slot; this should usually be avoided.)  If there are any unfilled\n'
          'slots for which no default value is specified, a "TypeError" '
          'exception\n'
          'is raised.  Otherwise, the list of filled slots is used as the\n'
          'argument list for the call.\n'
          '\n'
          '**CPython implementation detail:** An implementation may provide\n'
          'built-in functions whose positional parameters do not have names, '
          'even\n'
          'if they are ‘named’ for the purpose of documentation, and which\n'
          'therefore cannot be supplied by keyword.  In CPython, this is the '
          'case\n'
          'for functions implemented in C that use "PyArg_ParseTuple()" to '
          'parse\n'
          'their arguments.\n'
          '\n'
          'If there are more positional arguments than there are formal '
          'parameter\n'
          'slots, a "TypeError" exception is raised, unless a formal '
          'parameter\n'
          'using the syntax "*identifier" is present; in this case, that '
          'formal\n'
          'parameter receives a tuple containing the excess positional '
          'arguments\n'
          '(or an empty tuple if there were no excess positional arguments).\n'
          '\n'
          'If any keyword argument does not correspond to a formal parameter\n'
          'name, a "TypeError" exception is raised, unless a formal parameter\n'
          'using the syntax "**identifier" is present; in this case, that '
          'formal\n'
          'parameter receives a dictionary containing the excess keyword\n'
          'arguments (using the keywords as keys and the argument values as\n'
          'corresponding values), or a (new) empty dictionary if there were '
          'no\n'
          'excess keyword arguments.\n'
          '\n'
          'If the syntax "*expression" appears in the function call, '
          '"expression"\n'
          'must evaluate to an *iterable*.  Elements from these iterables are\n'
          'treated as if they were additional positional arguments.  For the '
          'call\n'
          '"f(x1, x2, *y, x3, x4)", if *y* evaluates to a sequence *y1*, …, '
          '*yM*,\n'
          'this is equivalent to a call with M+4 positional arguments *x1*, '
          '*x2*,\n'
          '*y1*, …, *yM*, *x3*, *x4*.\n'
          '\n'
          'A consequence of this is that although the "*expression" syntax '
          'may\n'
          'appear *after* explicit keyword arguments, it is processed '
          '*before*\n'
          'the keyword arguments (and any "**expression" arguments – see '
          'below).\n'
          'So:\n'
          '\n'
          '   >>> def f(a, b):\n'
          '   ...     print(a, b)\n'
          '   ...\n'
          '   >>> f(b=1, *(2,))\n'
          '   2 1\n'
          '   >>> f(a=1, *(2,))\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 1, in <module>\n'
          "   TypeError: f() got multiple values for keyword argument 'a'\n"
          '   >>> f(1, *(2,))\n'
          '   1 2\n'
          '\n'
          'It is unusual for both keyword arguments and the "*expression" '
          'syntax\n'
          'to be used in the same call, so in practice this confusion does '
          'not\n'
          'often arise.\n'
          '\n'
          'If the syntax "**expression" appears in the function call,\n'
          '"expression" must evaluate to a *mapping*, the contents of which '
          'are\n'
          'treated as additional keyword arguments. If a parameter matching a '
          'key\n'
          'has already been given a value (by an explicit keyword argument, '
          'or\n'
          'from another unpacking), a "TypeError" exception is raised.\n'
          '\n'
          'When "**expression" is used, each key in this mapping must be a\n'
          'string. Each value from the mapping is assigned to the first '
          'formal\n'
          'parameter eligible for keyword assignment whose name is equal to '
          'the\n'
          'key. A key need not be a Python identifier (e.g. ""max-temp °F"" '
          'is\n'
          'acceptable, although it will not match any formal parameter that '
          'could\n'
          'be declared). If there is no match to a formal parameter the '
          'key-value\n'
          'pair is collected by the "**" parameter, if there is one, or if '
          'there\n'
          'is not, a "TypeError" exception is raised.\n'
          '\n'
          'Formal parameters using the syntax "*identifier" or "**identifier"\n'
          'cannot be used as positional argument slots or as keyword argument\n'
          'names.\n'
          '\n'
          'Changed in version 3.5: Function calls accept any number of "*" '
          'and\n'
          '"**" unpackings, positional arguments may follow iterable '
          'unpackings\n'
          '("*"), and keyword arguments may follow dictionary unpackings '
          '("**").\n'
          'Originally proposed by **PEP 448**.\n'
          '\n'
          'A call always returns some value, possibly "None", unless it raises '
          'an\n'
          'exception.  How this value is computed depends on the type of the\n'
          'callable object.\n'
          '\n'
          'If it is—\n'
          '\n'
          'a user-defined function:\n'
          '   The code block for the function is executed, passing it the\n'
          '   argument list.  The first thing the code block will do is bind '
          'the\n'
          '   formal parameters to the arguments; this is described in '
          'section\n'
          '   Function definitions.  When the code block executes a "return"\n'
          '   statement, this specifies the return value of the function '
          'call.\n'
          '\n'
          'a built-in function or method:\n'
          '   The result is up to the interpreter; see Built-in Functions for '
          'the\n'
          '   descriptions of built-in functions and methods.\n'
          '\n'
          'a class object:\n'
          '   A new instance of that class is returned.\n'
          '\n'
          'a class instance method:\n'
          '   The corresponding user-defined function is called, with an '
          'argument\n'
          '   list that is one longer than the argument list of the call: the\n'
          '   instance becomes the first argument.\n'
          '\n'
          'a class instance:\n'
          '   The class must define a "__call__()" method; the effect is then '
          'the\n'
          '   same as if that method was called.\n',
 'class': 'Class definitions\n'
          '*****************\n'
          '\n'
          'A class definition defines a class object (see section The '
          'standard\n'
          'type hierarchy):\n'
          '\n'
          '   classdef    ::= [decorators] "class" classname [inheritance] ":" '
          'suite\n'
          '   inheritance ::= "(" [argument_list] ")"\n'
          '   classname   ::= identifier\n'
          '\n'
          'A class definition is an executable statement.  The inheritance '
          'list\n'
          'usually gives a list of base classes (see Metaclasses for more\n'
          'advanced uses), so each item in the list should evaluate to a '
          'class\n'
          'object which allows subclassing.  Classes without an inheritance '
          'list\n'
          'inherit, by default, from the base class "object"; hence,\n'
          '\n'
          '   class Foo:\n'
          '       pass\n'
          '\n'
          'is equivalent to\n'
          '\n'
          '   class Foo(object):\n'
          '       pass\n'
          '\n'
          'The class’s suite is then executed in a new execution frame (see\n'
          'Naming and binding), using a newly created local namespace and the\n'
          'original global namespace. (Usually, the suite contains mostly\n'
          'function definitions.)  When the class’s suite finishes execution, '
          'its\n'
          'execution frame is discarded but its local namespace is saved. [5] '
          'A\n'
          'class object is then created using the inheritance list for the '
          'base\n'
          'classes and the saved local namespace for the attribute '
          'dictionary.\n'
          'The class name is bound to this class object in the original local\n'
          'namespace.\n'
          '\n'
          'The order in which attributes are defined in the class body is\n'
          'preserved in the new class’s "__dict__".  Note that this is '
          'reliable\n'
          'only right after the class is created and only for classes that '
          'were\n'
          'defined using the definition syntax.\n'
          '\n'
          'Class creation can be customized heavily using metaclasses.\n'
          '\n'
          'Classes can also be decorated: just like when decorating '
          'functions,\n'
          '\n'
          '   @f1(arg)\n'
          '   @f2\n'
          '   class Foo: pass\n'
          '\n'
          'is roughly equivalent to\n'
          '\n'
          '   class Foo: pass\n'
          '   Foo = f1(arg)(f2(Foo))\n'
          '\n'
          'The evaluation rules for the decorator expressions are the same as '
          'for\n'
          'function decorators.  The result is then bound to the class name.\n'
          '\n'
          'Changed in version 3.9: Classes may be decorated with any valid\n'
          '"assignment_expression". Previously, the grammar was much more\n'
          'restrictive; see **PEP 614** for details.\n'
          '\n'
          '**Programmer’s note:** Variables defined in the class definition '
          'are\n'
          'class attributes; they are shared by instances.  Instance '
          'attributes\n'
          'can be set in a method with "self.name = value".  Both class and\n'
          'instance attributes are accessible through the notation '
          '“"self.name"”,\n'
          'and an instance attribute hides a class attribute with the same '
          'name\n'
          'when accessed in this way.  Class attributes can be used as '
          'defaults\n'
          'for instance attributes, but using mutable values there can lead '
          'to\n'
          'unexpected results.  Descriptors can be used to create instance\n'
          'variables with different implementation details.\n'
          '\n'
          'See also:\n'
          '\n'
          '  **PEP 3115** - Metaclasses in Python 3000\n'
          '     The proposal that changed the declaration of metaclasses to '
          'the\n'
          '     current syntax, and the semantics for how classes with\n'
          '     metaclasses are constructed.\n'
          '\n'
          '  **PEP 3129** - Class Decorators\n'
          '     The proposal that added class decorators.  Function and '
          'method\n'
          '     decorators were introduced in **PEP 318**.\n',
 'comparisons': 'Comparisons\n'
                '***********\n'
                '\n'
                'Unlike C, all comparison operations in Python have the same '
                'priority,\n'
                'which is lower than that of any arithmetic, shifting or '
                'bitwise\n'
                'operation.  Also unlike C, expressions like "a < b < c" have '
                'the\n'
                'interpretation that is conventional in mathematics:\n'
                '\n'
                '   comparison    ::= or_expr (comp_operator or_expr)*\n'
                '   comp_operator ::= "<" | ">" | "==" | ">=" | "<=" | "!="\n'
                '                     | "is" ["not"] | ["not"] "in"\n'
                '\n'
                'Comparisons yield boolean values: "True" or "False". Custom '
                '*rich\n'
                'comparison methods* may return non-boolean values. In this '
                'case Python\n'
                'will call "bool()" on such value in boolean contexts.\n'
                '\n'
                'Comparisons can be chained arbitrarily, e.g., "x < y <= z" '
                'is\n'
                'equivalent to "x < y and y <= z", except that "y" is '
                'evaluated only\n'
                'once (but in both cases "z" is not evaluated at all when "x < '
                'y" is\n'
                'found to be false).\n'
                '\n'
                'Formally, if *a*, *b*, *c*, …, *y*, *z* are expressions and '
                '*op1*,\n'
                '*op2*, …, *opN* are comparison operators, then "a op1 b op2 c '
                '... y\n'
                'opN z" is equivalent to "a op1 b and b op2 c and ... y opN '
                'z", except\n'
                'that each expression is evaluated at most once.\n'
                '\n'
                'Note that "a op1 b op2 c" doesn’t imply any kind of '
                'comparison between\n'
                '*a* and *c*, so that, e.g., "x < y > z" is perfectly legal '
                '(though\n'
                'perhaps not pretty).\n'
                '\n'
                '\n'
                'Value comparisons\n'
                '=================\n'
                '\n'
                'The operators "<", ">", "==", ">=", "<=", and "!=" compare '
                'the values\n'
                'of two objects.  The objects do not need to have the same '
                'type.\n'
                '\n'
                'Chapter Objects, values and types states that objects have a '
                'value (in\n'
                'addition to type and identity).  The value of an object is a '
                'rather\n'
                'abstract notion in Python: For example, there is no canonical '
                'access\n'
                'method for an object’s value.  Also, there is no requirement '
                'that the\n'
                'value of an object should be constructed in a particular way, '
                'e.g.\n'
                'comprised of all its data attributes. Comparison operators '
                'implement a\n'
                'particular notion of what the value of an object is.  One can '
                'think of\n'
                'them as defining the value of an object indirectly, by means '
                'of their\n'
                'comparison implementation.\n'
                '\n'
                'Because all types are (direct or indirect) subtypes of '
                '"object", they\n'
                'inherit the default comparison behavior from "object".  Types '
                'can\n'
                'customize their comparison behavior by implementing *rich '
                'comparison\n'
                'methods* like "__lt__()", described in Basic customization.\n'
                '\n'
                'The default behavior for equality comparison ("==" and "!=") '
                'is based\n'
                'on the identity of the objects.  Hence, equality comparison '
                'of\n'
                'instances with the same identity results in equality, and '
                'equality\n'
                'comparison of instances with different identities results in\n'
                'inequality.  A motivation for this default behavior is the '
                'desire that\n'
                'all objects should be reflexive (i.e. "x is y" implies "x == '
                'y").\n'
                '\n'
                'A default order comparison ("<", ">", "<=", and ">=") is not '
                'provided;\n'
                'an attempt raises "TypeError".  A motivation for this default '
                'behavior\n'
                'is the lack of a similar invariant as for equality.\n'
                '\n'
                'The behavior of the default equality comparison, that '
                'instances with\n'
                'different identities are always unequal, may be in contrast '
                'to what\n'
                'types will need that have a sensible definition of object '
                'value and\n'
                'value-based equality.  Such types will need to customize '
                'their\n'
                'comparison behavior, and in fact, a number of built-in types '
                'have done\n'
                'that.\n'
                '\n'
                'The following list describes the comparison behavior of the '
                'most\n'
                'important built-in types.\n'
                '\n'
                '* Numbers of built-in numeric types (Numeric Types — int, '
                'float,\n'
                '  complex) and of the standard library types '
                '"fractions.Fraction" and\n'
                '  "decimal.Decimal" can be compared within and across their '
                'types,\n'
                '  with the restriction that complex numbers do not support '
                'order\n'
                '  comparison.  Within the limits of the types involved, they '
                'compare\n'
                '  mathematically (algorithmically) correct without loss of '
                'precision.\n'
                '\n'
                '  The not-a-number values "float(\'NaN\')" and '
                '"decimal.Decimal(\'NaN\')"\n'
                '  are special.  Any ordered comparison of a number to a '
                'not-a-number\n'
                '  value is false. A counter-intuitive implication is that '
                'not-a-number\n'
                '  values are not equal to themselves.  For example, if "x =\n'
                '  float(\'NaN\')", "3 < x", "x < 3" and "x == x" are all '
                'false, while "x\n'
                '  != x" is true.  This behavior is compliant with IEEE 754.\n'
                '\n'
                '* "None" and "NotImplemented" are singletons.  **PEP 8** '
                'advises that\n'
                '  comparisons for singletons should always be done with "is" '
                'or "is\n'
                '  not", never the equality operators.\n'
                '\n'
                '* Binary sequences (instances of "bytes" or "bytearray") can '
                'be\n'
                '  compared within and across their types.  They compare\n'
                '  lexicographically using the numeric values of their '
                'elements.\n'
                '\n'
                '* Strings (instances of "str") compare lexicographically '
                'using the\n'
                '  numerical Unicode code points (the result of the built-in '
                'function\n'
                '  "ord()") of their characters. [3]\n'
                '\n'
                '  Strings and binary sequences cannot be directly compared.\n'
                '\n'
                '* Sequences (instances of "tuple", "list", or "range") can be '
                'compared\n'
                '  only within each of their types, with the restriction that '
                'ranges do\n'
                '  not support order comparison.  Equality comparison across '
                'these\n'
                '  types results in inequality, and ordering comparison across '
                'these\n'
                '  types raises "TypeError".\n'
                '\n'
                '  Sequences compare lexicographically using comparison of\n'
                '  corresponding elements.  The built-in containers typically '
                'assume\n'
                '  identical objects are equal to themselves.  That lets them '
                'bypass\n'
                '  equality tests for identical objects to improve performance '
                'and to\n'
                '  maintain their internal invariants.\n'
                '\n'
                '  Lexicographical comparison between built-in collections '
                'works as\n'
                '  follows:\n'
                '\n'
                '  * For two collections to compare equal, they must be of the '
                'same\n'
                '    type, have the same length, and each pair of '
                'corresponding\n'
                '    elements must compare equal (for example, "[1,2] == '
                '(1,2)" is\n'
                '    false because the type is not the same).\n'
                '\n'
                '  * Collections that support order comparison are ordered the '
                'same as\n'
                '    their first unequal elements (for example, "[1,2,x] <= '
                '[1,2,y]"\n'
                '    has the same value as "x <= y").  If a corresponding '
                'element does\n'
                '    not exist, the shorter collection is ordered first (for '
                'example,\n'
                '    "[1,2] < [1,2,3]" is true).\n'
                '\n'
                '* Mappings (instances of "dict") compare equal if and only if '
                'they\n'
                '  have equal "(key, value)" pairs. Equality comparison of the '
                'keys and\n'
                '  values enforces reflexivity.\n'
                '\n'
                '  Order comparisons ("<", ">", "<=", and ">=") raise '
                '"TypeError".\n'
                '\n'
                '* Sets (instances of "set" or "frozenset") can be compared '
                'within and\n'
                '  across their types.\n'
                '\n'
                '  They define order comparison operators to mean subset and '
                'superset\n'
                '  tests.  Those relations do not define total orderings (for '
                'example,\n'
                '  the two sets "{1,2}" and "{2,3}" are not equal, nor subsets '
                'of one\n'
                '  another, nor supersets of one another).  Accordingly, sets '
                'are not\n'
                '  appropriate arguments for functions which depend on total '
                'ordering\n'
                '  (for example, "min()", "max()", and "sorted()" produce '
                'undefined\n'
                '  results given a list of sets as inputs).\n'
                '\n'
                '  Comparison of sets enforces reflexivity of its elements.\n'
                '\n'
                '* Most other built-in types have no comparison methods '
                'implemented, so\n'
                '  they inherit the default comparison behavior.\n'
                '\n'
                'User-defined classes that customize their comparison behavior '
                'should\n'
                'follow some consistency rules, if possible:\n'
                '\n'
                '* Equality comparison should be reflexive. In other words, '
                'identical\n'
                '  objects should compare equal:\n'
                '\n'
                '     "x is y" implies "x == y"\n'
                '\n'
                '* Comparison should be symmetric. In other words, the '
                'following\n'
                '  expressions should have the same result:\n'
                '\n'
                '     "x == y" and "y == x"\n'
                '\n'
                '     "x != y" and "y != x"\n'
                '\n'
                '     "x < y" and "y > x"\n'
                '\n'
                '     "x <= y" and "y >= x"\n'
                '\n'
                '* Comparison should be transitive. The following '
                '(non-exhaustive)\n'
                '  examples illustrate that:\n'
                '\n'
                '     "x > y and y > z" implies "x > z"\n'
                '\n'
                '     "x < y and y <= z" implies "x < z"\n'
                '\n'
                '* Inverse comparison should result in the boolean negation. '
                'In other\n'
                '  words, the following expressions should have the same '
                'result:\n'
                '\n'
                '     "x == y" and "not x != y"\n'
                '\n'
                '     "x < y" and "not x >= y" (for total ordering)\n'
                '\n'
                '     "x > y" and "not x <= y" (for total ordering)\n'
                '\n'
                '  The last two expressions apply to totally ordered '
                'collections (e.g.\n'
                '  to sequences, but not to sets or mappings). See also the\n'
                '  "total_ordering()" decorator.\n'
                '\n'
                '* The "hash()" result should be consistent with equality. '
                'Objects that\n'
                '  are equal should either have the same hash value, or be '
                'marked as\n'
                '  unhashable.\n'
                '\n'
                'Python does not enforce these consistency rules. In fact, '
                'the\n'
                'not-a-number values are an example for not following these '
                'rules.\n'
                '\n'
                '\n'
                'Membership test operations\n'
                '==========================\n'
                '\n'
                'The operators "in" and "not in" test for membership.  "x in '
                's"\n'
                'evaluates to "True" if *x* is a member of *s*, and "False" '
                'otherwise.\n'
                '"x not in s" returns the negation of "x in s".  All built-in '
                'sequences\n'
                'and set types support this as well as dictionary, for which '
                '"in" tests\n'
                'whether the dictionary has a given key. For container types '
                'such as\n'
                'list, tuple, set, frozenset, dict, or collections.deque, the\n'
                'expression "x in y" is equivalent to "any(x is e or x == e '
                'for e in\n'
                'y)".\n'
                '\n'
                'For the string and bytes types, "x in y" is "True" if and '
                'only if *x*\n'
                'is a substring of *y*.  An equivalent test is "y.find(x) != '
                '-1".\n'
                'Empty strings are always considered to be a substring of any '
                'other\n'
                'string, so """ in "abc"" will return "True".\n'
                '\n'
                'For user-defined classes which define the "__contains__()" '
                'method, "x\n'
                'in y" returns "True" if "y.__contains__(x)" returns a true '
                'value, and\n'
                '"False" otherwise.\n'
                '\n'
                'For user-defined classes which do not define "__contains__()" '
                'but do\n'
                'define "__iter__()", "x in y" is "True" if some value "z", '
                'for which\n'
                'the expression "x is z or x == z" is true, is produced while '
                'iterating\n'
                'over "y". If an exception is raised during the iteration, it '
                'is as if\n'
                '"in" raised that exception.\n'
                '\n'
                'Lastly, the old-style iteration protocol is tried: if a class '
                'defines\n'
                '"__getitem__()", "x in y" is "True" if and only if there is a '
                'non-\n'
                'negative integer index *i* such that "x is y[i] or x == '
                'y[i]", and no\n'
                'lower integer index raises the "IndexError" exception.  (If '
                'any other\n'
                'exception is raised, it is as if "in" raised that '
                'exception).\n'
                '\n'
                'The operator "not in" is defined to have the inverse truth '
                'value of\n'
                '"in".\n'
                '\n'
                '\n'
                'Identity comparisons\n'
                '====================\n'
                '\n'
                'The operators "is" and "is not" test for an object’s '
                'identity: "x is\n'
                'y" is true if and only if *x* and *y* are the same object.  '
                'An\n'
                'Object’s identity is determined using the "id()" function.  '
                '"x is not\n'
                'y" yields the inverse truth value. [4]\n',
 'compound': 'Compound statements\n'
             '*******************\n'
             '\n'
             'Compound statements contain (groups of) other statements; they '
             'affect\n'
             'or control the execution of those other statements in some way.  '
             'In\n'
             'general, compound statements span multiple lines, although in '
             'simple\n'
             'incarnations a whole compound statement may be contained in one '
             'line.\n'
             '\n'
             'The "if", "while" and "for" statements implement traditional '
             'control\n'
             'flow constructs.  "try" specifies exception handlers and/or '
             'cleanup\n'
             'code for a group of statements, while the "with" statement '
             'allows the\n'
             'execution of initialization and finalization code around a block '
             'of\n'
             'code.  Function and class definitions are also syntactically '
             'compound\n'
             'statements.\n'
             '\n'
             'A compound statement consists of one or more ‘clauses.’  A '
             'clause\n'
             'consists of a header and a ‘suite.’  The clause headers of a\n'
             'particular compound statement are all at the same indentation '
             'level.\n'
             'Each clause header begins with a uniquely identifying keyword '
             'and ends\n'
             'with a colon.  A suite is a group of statements controlled by a\n'
             'clause.  A suite can be one or more semicolon-separated simple\n'
             'statements on the same line as the header, following the '
             'header’s\n'
             'colon, or it can be one or more indented statements on '
             'subsequent\n'
             'lines.  Only the latter form of a suite can contain nested '
             'compound\n'
             'statements; the following is illegal, mostly because it wouldn’t '
             'be\n'
             'clear to which "if" clause a following "else" clause would '
             'belong:\n'
             '\n'
             '   if test1: if test2: print(x)\n'
             '\n'
             'Also note that the semicolon binds tighter than the colon in '
             'this\n'
             'context, so that in the following example, either all or none of '
             'the\n'
             '"print()" calls are executed:\n'
             '\n'
             '   if x < y < z: print(x); print(y); print(z)\n'
             '\n'
             'Summarizing:\n'
             '\n'
             '   compound_stmt ::= if_stmt\n'
             '                     | while_stmt\n'
             '                     | for_stmt\n'
             '                     | try_stmt\n'
             '                     | with_stmt\n'
             '                     | match_stmt\n'
             '                     | funcdef\n'
             '                     | classdef\n'
             '                     | async_with_stmt\n'
             '                     | async_for_stmt\n'
             '                     | async_funcdef\n'
             '   suite         ::= stmt_list NEWLINE | NEWLINE INDENT '
             'statement+ DEDENT\n'
             '   statement     ::= stmt_list NEWLINE | compound_stmt\n'
             '   stmt_list     ::= simple_stmt (";" simple_stmt)* [";"]\n'
             '\n'
             'Note that statements always end in a "NEWLINE" possibly followed '
             'by a\n'
             '"DEDENT".  Also note that optional continuation clauses always '
             'begin\n'
             'with a keyword that cannot start a statement, thus there are no\n'
             'ambiguities (the ‘dangling "else"’ problem is solved in Python '
             'by\n'
             'requiring nested "if" statements to be indented).\n'
             '\n'
             'The formatting of the grammar rules in the following sections '
             'places\n'
             'each clause on a separate line for clarity.\n'
             '\n'
             '\n'
             'The "if" statement\n'
             '==================\n'
             '\n'
             'The "if" statement is used for conditional execution:\n'
             '\n'
             '   if_stmt ::= "if" assignment_expression ":" suite\n'
             '               ("elif" assignment_expression ":" suite)*\n'
             '               ["else" ":" suite]\n'
             '\n'
             'It selects exactly one of the suites by evaluating the '
             'expressions one\n'
             'by one until one is found to be true (see section Boolean '
             'operations\n'
             'for the definition of true and false); then that suite is '
             'executed\n'
             '(and no other part of the "if" statement is executed or '
             'evaluated).\n'
             'If all expressions are false, the suite of the "else" clause, '
             'if\n'
             'present, is executed.\n'
             '\n'
             '\n'
             'The "while" statement\n'
             '=====================\n'
             '\n'
             'The "while" statement is used for repeated execution as long as '
             'an\n'
             'expression is true:\n'
             '\n'
             '   while_stmt ::= "while" assignment_expression ":" suite\n'
             '                  ["else" ":" suite]\n'
             '\n'
             'This repeatedly tests the expression and, if it is true, '
             'executes the\n'
             'first suite; if the expression is false (which may be the first '
             'time\n'
             'it is tested) the suite of the "else" clause, if present, is '
             'executed\n'
             'and the loop terminates.\n'
             '\n'
             'A "break" statement executed in the first suite terminates the '
             'loop\n'
             'without executing the "else" clause’s suite.  A "continue" '
             'statement\n'
             'executed in the first suite skips the rest of the suite and goes '
             'back\n'
             'to testing the expression.\n'
             '\n'
             '\n'
             'The "for" statement\n'
             '===================\n'
             '\n'
             'The "for" statement is used to iterate over the elements of a '
             'sequence\n'
             '(such as a string, tuple or list) or other iterable object:\n'
             '\n'
             '   for_stmt ::= "for" target_list "in" starred_list ":" suite\n'
             '                ["else" ":" suite]\n'
             '\n'
             'The "starred_list" expression is evaluated once; it should yield '
             'an\n'
             '*iterable* object.  An *iterator* is created for that iterable. '
             'The\n'
             'first item provided by the iterator is then assigned to the '
             'target\n'
             'list using the standard rules for assignments (see Assignment\n'
             'statements), and the suite is executed.  This repeats for each '
             'item\n'
             'provided by the iterator.  When the iterator is exhausted, the '
             'suite\n'
             'in the "else" clause, if present, is executed, and the loop\n'
             'terminates.\n'
             '\n'
             'A "break" statement executed in the first suite terminates the '
             'loop\n'
             'without executing the "else" clause’s suite.  A "continue" '
             'statement\n'
             'executed in the first suite skips the rest of the suite and '
             'continues\n'
             'with the next item, or with the "else" clause if there is no '
             'next\n'
             'item.\n'
             '\n'
             'The for-loop makes assignments to the variables in the target '
             'list.\n'
             'This overwrites all previous assignments to those variables '
             'including\n'
             'those made in the suite of the for-loop:\n'
             '\n'
             '   for i in range(10):\n'
             '       print(i)\n'
             '       i = 5             # this will not affect the for-loop\n'
             '                         # because i will be overwritten with '
             'the next\n'
             '                         # index in the range\n'
             '\n'
             'Names in the target list are not deleted when the loop is '
             'finished,\n'
             'but if the sequence is empty, they will not have been assigned '
             'to at\n'
             'all by the loop.  Hint: the built-in type "range()" represents\n'
             'immutable arithmetic sequences of integers. For instance, '
             'iterating\n'
             '"range(3)" successively yields 0, 1, and then 2.\n'
             '\n'
             'Changed in version 3.11: Starred elements are now allowed in '
             'the\n'
             'expression list.\n'
             '\n'
             '\n'
             'The "try" statement\n'
             '===================\n'
             '\n'
             'The "try" statement specifies exception handlers and/or cleanup '
             'code\n'
             'for a group of statements:\n'
             '\n'
             '   try_stmt  ::= try1_stmt | try2_stmt | try3_stmt\n'
             '   try1_stmt ::= "try" ":" suite\n'
             '                 ("except" [expression ["as" identifier]] ":" '
             'suite)+\n'
             '                 ["else" ":" suite]\n'
             '                 ["finally" ":" suite]\n'
             '   try2_stmt ::= "try" ":" suite\n'
             '                 ("except" "*" expression ["as" identifier] ":" '
             'suite)+\n'
             '                 ["else" ":" suite]\n'
             '                 ["finally" ":" suite]\n'
             '   try3_stmt ::= "try" ":" suite\n'
             '                 "finally" ":" suite\n'
             '\n'
             'Additional information on exceptions can be found in section\n'
             'Exceptions, and information on using the "raise" statement to '
             'generate\n'
             'exceptions may be found in section The raise statement.\n'
             '\n'
             '\n'
             '"except" clause\n'
             '---------------\n'
             '\n'
             'The "except" clause(s) specify one or more exception handlers. '
             'When no\n'
             'exception occurs in the "try" clause, no exception handler is\n'
             'executed. When an exception occurs in the "try" suite, a search '
             'for an\n'
             'exception handler is started. This search inspects the "except"\n'
             'clauses in turn until one is found that matches the exception. '
             'An\n'
             'expression-less "except" clause, if present, must be last; it '
             'matches\n'
             'any exception. For an "except" clause with an expression, that\n'
             'expression is evaluated, and the clause matches the exception if '
             'the\n'
             'resulting object is “compatible” with the exception.  An object '
             'is\n'
             'compatible with an exception if the object is the class or a '
             '*non-\n'
             'virtual base class* of the exception object, or a tuple '
             'containing an\n'
             'item that is the class or a non-virtual base class of the '
             'exception\n'
             'object.\n'
             '\n'
             'If no "except" clause matches the exception, the search for an\n'
             'exception handler continues in the surrounding code and on the\n'
             'invocation stack.  [1]\n'
             '\n'
             'If the evaluation of an expression in the header of an "except" '
             'clause\n'
             'raises an exception, the original search for a handler is '
             'canceled and\n'
             'a search starts for the new exception in the surrounding code '
             'and on\n'
             'the call stack (it is treated as if the entire "try" statement '
             'raised\n'
             'the exception).\n'
             '\n'
             'When a matching "except" clause is found, the exception is '
             'assigned to\n'
             'the target specified after the "as" keyword in that "except" '
             'clause,\n'
             'if present, and the "except" clause’s suite is executed. All '
             '"except"\n'
             'clauses must have an executable block. When the end of this '
             'block is\n'
             'reached, execution continues normally after the entire "try"\n'
             'statement. (This means that if two nested handlers exist for the '
             'same\n'
             'exception, and the exception occurs in the "try" clause of the '
             'inner\n'
             'handler, the outer handler will not handle the exception.)\n'
             '\n'
             'When an exception has been assigned using "as target", it is '
             'cleared\n'
             'at the end of the "except" clause.  This is as if\n'
             '\n'
             '   except E as N:\n'
             '       foo\n'
             '\n'
             'was translated to\n'
             '\n'
             '   except E as N:\n'
             '       try:\n'
             '           foo\n'
             '       finally:\n'
             '           del N\n'
             '\n'
             'This means the exception must be assigned to a different name to '
             'be\n'
             'able to refer to it after the "except" clause. Exceptions are '
             'cleared\n'
             'because with the traceback attached to them, they form a '
             'reference\n'
             'cycle with the stack frame, keeping all locals in that frame '
             'alive\n'
             'until the next garbage collection occurs.\n'
             '\n'
             'Before an "except" clause’s suite is executed, the exception is '
             'stored\n'
             'in the "sys" module, where it can be accessed from within the '
             'body of\n'
             'the "except" clause by calling "sys.exception()". When leaving '
             'an\n'
             'exception handler, the exception stored in the "sys" module is '
             'reset\n'
             'to its previous value:\n'
             '\n'
             '   >>> print(sys.exception())\n'
             '   None\n'
             '   >>> try:\n'
             '   ...     raise TypeError\n'
             '   ... except:\n'
             '   ...     print(repr(sys.exception()))\n'
             '   ...     try:\n'
             '   ...          raise ValueError\n'
             '   ...     except:\n'
             '   ...         print(repr(sys.exception()))\n'
             '   ...     print(repr(sys.exception()))\n'
             '   ...\n'
             '   TypeError()\n'
             '   ValueError()\n'
             '   TypeError()\n'
             '   >>> print(sys.exception())\n'
             '   None\n'
             '\n'
             '\n'
             '"except*" clause\n'
             '----------------\n'
             '\n'
             'The "except*" clause(s) are used for handling "ExceptionGroup"s. '
             'The\n'
             'exception type for matching is interpreted as in the case of '
             '"except",\n'
             'but in the case of exception groups we can have partial matches '
             'when\n'
             'the type matches some of the exceptions in the group. This means '
             'that\n'
             'multiple "except*" clauses can execute, each handling part of '
             'the\n'
             'exception group. Each clause executes at most once and handles '
             'an\n'
             'exception group of all matching exceptions.  Each exception in '
             'the\n'
             'group is handled by at most one "except*" clause, the first '
             'that\n'
             'matches it.\n'
             '\n'
             '   >>> try:\n'
             '   ...     raise ExceptionGroup("eg",\n'
             '   ...         [ValueError(1), TypeError(2), OSError(3), '
             'OSError(4)])\n'
             '   ... except* TypeError as e:\n'
             "   ...     print(f'caught {type(e)} with nested "
             "{e.exceptions}')\n"
             '   ... except* OSError as e:\n'
             "   ...     print(f'caught {type(e)} with nested "
             "{e.exceptions}')\n"
             '   ...\n'
             "   caught <class 'ExceptionGroup'> with nested (TypeError(2),)\n"
             "   caught <class 'ExceptionGroup'> with nested (OSError(3), "
             'OSError(4))\n'
             '     + Exception Group Traceback (most recent call last):\n'
             '     |   File "<stdin>", line 2, in <module>\n'
             '     | ExceptionGroup: eg\n'
             '     +-+---------------- 1 ----------------\n'
             '       | ValueError: 1\n'
             '       +------------------------------------\n'
             '\n'
             'Any remaining exceptions that were not handled by any "except*" '
             'clause\n'
             'are re-raised at the end, combined into an exception group along '
             'with\n'
             'all exceptions that were raised from within "except*" clauses.\n'
             '\n'
             'From version 3.11.4, when the entire "ExceptionGroup" is handled '
             'and\n'
             'only one exception is raised from an "except*" clause, this '
             'exception\n'
             'is no longer wrapped to form a new "ExceptionGroup".\n'
             '\n'
             'If the raised exception is not an exception group and its type '
             'matches\n'
             'one of the "except*" clauses, it is caught and wrapped by an '
             'exception\n'
             'group with an empty message string.\n'
             '\n'
             '   >>> try:\n'
             '   ...     raise BlockingIOError\n'
             '   ... except* BlockingIOError as e:\n'
             '   ...     print(repr(e))\n'
             '   ...\n'
             "   ExceptionGroup('', (BlockingIOError()))\n"
             '\n'
             'An "except*" clause must have a matching type, and this type '
             'cannot be\n'
             'a subclass of "BaseExceptionGroup". It is not possible to mix '
             '"except"\n'
             'and "except*" in the same "try". "break", "continue" and '
             '"return"\n'
             'cannot appear in an "except*" clause.\n'
             '\n'
             '\n'
             '"else" clause\n'
             '-------------\n'
             '\n'
             'The optional "else" clause is executed if the control flow '
             'leaves the\n'
             '"try" suite, no exception was raised, and no "return", '
             '"continue", or\n'
             '"break" statement was executed.  Exceptions in the "else" clause '
             'are\n'
             'not handled by the preceding "except" clauses.\n'
             '\n'
             '\n'
             '"finally" clause\n'
             '----------------\n'
             '\n'
             'If "finally" is present, it specifies a ‘cleanup’ handler.  The '
             '"try"\n'
             'clause is executed, including any "except" and "else" clauses.  '
             'If an\n'
             'exception occurs in any of the clauses and is not handled, the\n'
             'exception is temporarily saved. The "finally" clause is '
             'executed.  If\n'
             'there is a saved exception it is re-raised at the end of the '
             '"finally"\n'
             'clause.  If the "finally" clause raises another exception, the '
             'saved\n'
             'exception is set as the context of the new exception. If the '
             '"finally"\n'
             'clause executes a "return", "break" or "continue" statement, the '
             'saved\n'
             'exception is discarded:\n'
             '\n'
             '   >>> def f():\n'
             '   ...     try:\n'
             '   ...         1/0\n'
             '   ...     finally:\n'
             '   ...         return 42\n'
             '   ...\n'
             '   >>> f()\n'
             '   42\n'
             '\n'
             'The exception information is not available to the program '
             'during\n'
             'execution of the "finally" clause.\n'
             '\n'
             'When a "return", "break" or "continue" statement is executed in '
             'the\n'
             '"try" suite of a "try"…"finally" statement, the "finally" clause '
             'is\n'
             'also executed ‘on the way out.’\n'
             '\n'
             'The return value of a function is determined by the last '
             '"return"\n'
             'statement executed.  Since the "finally" clause always executes, '
             'a\n'
             '"return" statement executed in the "finally" clause will always '
             'be the\n'
             'last one executed:\n'
             '\n'
             '   >>> def foo():\n'
             '   ...     try:\n'
             "   ...         return 'try'\n"
             '   ...     finally:\n'
             "   ...         return 'finally'\n"
             '   ...\n'
             '   >>> foo()\n'
             "   'finally'\n"
             '\n'
             'Changed in version 3.8: Prior to Python 3.8, a "continue" '
             'statement\n'
             'was illegal in the "finally" clause due to a problem with the\n'
             'implementation.\n'
             '\n'
             '\n'
             'The "with" statement\n'
             '====================\n'
             '\n'
             'The "with" statement is used to wrap the execution of a block '
             'with\n'
             'methods defined by a context manager (see section With '
             'Statement\n'
             'Context Managers). This allows common "try"…"except"…"finally" '
             'usage\n'
             'patterns to be encapsulated for convenient reuse.\n'
             '\n'
             '   with_stmt          ::= "with" ( "(" with_stmt_contents ","? '
             '")" | with_stmt_contents ) ":" suite\n'
             '   with_stmt_contents ::= with_item ("," with_item)*\n'
             '   with_item          ::= expression ["as" target]\n'
             '\n'
             'The execution of the "with" statement with one “item” proceeds '
             'as\n'
             'follows:\n'
             '\n'
             '1. The context expression (the expression given in the '
             '"with_item") is\n'
             '   evaluated to obtain a context manager.\n'
             '\n'
             '2. The context manager’s "__enter__()" is loaded for later use.\n'
             '\n'
             '3. The context manager’s "__exit__()" is loaded for later use.\n'
             '\n'
             '4. The context manager’s "__enter__()" method is invoked.\n'
             '\n'
             '5. If a target was included in the "with" statement, the return '
             'value\n'
             '   from "__enter__()" is assigned to it.\n'
             '\n'
             '   Note:\n'
             '\n'
             '     The "with" statement guarantees that if the "__enter__()" '
             'method\n'
             '     returns without an error, then "__exit__()" will always be\n'
             '     called. Thus, if an error occurs during the assignment to '
             'the\n'
             '     target list, it will be treated the same as an error '
             'occurring\n'
             '     within the suite would be. See step 7 below.\n'
             '\n'
             '6. The suite is executed.\n'
             '\n'
             '7. The context manager’s "__exit__()" method is invoked.  If an\n'
             '   exception caused the suite to be exited, its type, value, '
             'and\n'
             '   traceback are passed as arguments to "__exit__()". Otherwise, '
             'three\n'
             '   "None" arguments are supplied.\n'
             '\n'
             '   If the suite was exited due to an exception, and the return '
             'value\n'
             '   from the "__exit__()" method was false, the exception is '
             'reraised.\n'
             '   If the return value was true, the exception is suppressed, '
             'and\n'
             '   execution continues with the statement following the "with"\n'
             '   statement.\n'
             '\n'
             '   If the suite was exited for any reason other than an '
             'exception, the\n'
             '   return value from "__exit__()" is ignored, and execution '
             'proceeds\n'
             '   at the normal location for the kind of exit that was taken.\n'
             '\n'
             'The following code:\n'
             '\n'
             '   with EXPRESSION as TARGET:\n'
             '       SUITE\n'
             '\n'
             'is semantically equivalent to:\n'
             '\n'
             '   manager = (EXPRESSION)\n'
             '   enter = type(manager).__enter__\n'
             '   exit = type(manager).__exit__\n'
             '   value = enter(manager)\n'
             '   hit_except = False\n'
             '\n'
             '   try:\n'
             '       TARGET = value\n'
             '       SUITE\n'
             '   except:\n'
             '       hit_except = True\n'
             '       if not exit(manager, *sys.exc_info()):\n'
             '           raise\n'
             '   finally:\n'
             '       if not hit_except:\n'
             '           exit(manager, None, None, None)\n'
             '\n'
             'With more than one item, the context managers are processed as '
             'if\n'
             'multiple "with" statements were nested:\n'
             '\n'
             '   with A() as a, B() as b:\n'
             '       SUITE\n'
             '\n'
             'is semantically equivalent to:\n'
             '\n'
             '   with A() as a:\n'
             '       with B() as b:\n'
             '           SUITE\n'
             '\n'
             'You can also write multi-item context managers in multiple lines '
             'if\n'
             'the items are surrounded by parentheses. For example:\n'
             '\n'
             '   with (\n'
             '       A() as a,\n'
             '       B() as b,\n'
             '   ):\n'
             '       SUITE\n'
             '\n'
             'Changed in version 3.1: Support for multiple context '
             'expressions.\n'
             '\n'
             'Changed in version 3.10: Support for using grouping parentheses '
             'to\n'
             'break the statement in multiple lines.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 343** - The “with” statement\n'
             '     The specification, background, and examples for the Python '
             '"with"\n'
             '     statement.\n'
             '\n'
             '\n'
             'The "match" statement\n'
             '=====================\n'
             '\n'
             'New in version 3.10.\n'
             '\n'
             'The match statement is used for pattern matching.  Syntax:\n'
             '\n'
             '   match_stmt   ::= \'match\' subject_expr ":" NEWLINE INDENT '
             'case_block+ DEDENT\n'
             '   subject_expr ::= star_named_expression "," '
             'star_named_expressions?\n'
             '                    | named_expression\n'
             '   case_block   ::= \'case\' patterns [guard] ":" block\n'
             '\n'
             'Note:\n'
             '\n'
             '  This section uses single quotes to denote soft keywords.\n'
             '\n'
             'Pattern matching takes a pattern as input (following "case") and '
             'a\n'
             'subject value (following "match").  The pattern (which may '
             'contain\n'
             'subpatterns) is matched against the subject value.  The outcomes '
             'are:\n'
             '\n'
             '* A match success or failure (also termed a pattern success or\n'
             '  failure).\n'
             '\n'
             '* Possible binding of matched values to a name.  The '
             'prerequisites for\n'
             '  this are further discussed below.\n'
             '\n'
             'The "match" and "case" keywords are soft keywords.\n'
             '\n'
             'See also:\n'
             '\n'
             '  * **PEP 634** – Structural Pattern Matching: Specification\n'
             '\n'
             '  * **PEP 636** – Structural Pattern Matching: Tutorial\n'
             '\n'
             '\n'
             'Overview\n'
             '--------\n'
             '\n'
             'Here’s an overview of the logical flow of a match statement:\n'
             '\n'
             '1. The subject expression "subject_expr" is evaluated and a '
             'resulting\n'
             '   subject value obtained. If the subject expression contains a '
             'comma,\n'
             '   a tuple is constructed using the standard rules.\n'
             '\n'
             '2. Each pattern in a "case_block" is attempted to match with '
             'the\n'
             '   subject value. The specific rules for success or failure are\n'
             '   described below. The match attempt can also bind some or all '
             'of the\n'
             '   standalone names within the pattern. The precise pattern '
             'binding\n'
             '   rules vary per pattern type and are specified below.  **Name\n'
             '   bindings made during a successful pattern match outlive the\n'
             '   executed block and can be used after the match statement**.\n'
             '\n'
             '   Note:\n'
             '\n'
             '     During failed pattern matches, some subpatterns may '
             'succeed.  Do\n'
             '     not rely on bindings being made for a failed match.  '
             'Conversely,\n'
             '     do not rely on variables remaining unchanged after a '
             'failed\n'
             '     match.  The exact behavior is dependent on implementation '
             'and may\n'
             '     vary.  This is an intentional decision made to allow '
             'different\n'
             '     implementations to add optimizations.\n'
             '\n'
             '3. If the pattern succeeds, the corresponding guard (if present) '
             'is\n'
             '   evaluated. In this case all name bindings are guaranteed to '
             'have\n'
             '   happened.\n'
             '\n'
             '   * If the guard evaluates as true or is missing, the "block" '
             'inside\n'
             '     "case_block" is executed.\n'
             '\n'
             '   * Otherwise, the next "case_block" is attempted as described '
             'above.\n'
             '\n'
             '   * If there are no further case blocks, the match statement '
             'is\n'
             '     completed.\n'
             '\n'
             'Note:\n'
             '\n'
             '  Users should generally never rely on a pattern being '
             'evaluated.\n'
             '  Depending on implementation, the interpreter may cache values '
             'or use\n'
             '  other optimizations which skip repeated evaluations.\n'
             '\n'
             'A sample match statement:\n'
             '\n'
             '   >>> flag = False\n'
             '   >>> match (100, 200):\n'
             '   ...    case (100, 300):  # Mismatch: 200 != 300\n'
             "   ...        print('Case 1')\n"
             '   ...    case (100, 200) if flag:  # Successful match, but '
             'guard fails\n'
             "   ...        print('Case 2')\n"
             '   ...    case (100, y):  # Matches and binds y to 200\n'
             "   ...        print(f'Case 3, y: {y}')\n"
             '   ...    case _:  # Pattern not attempted\n'
             "   ...        print('Case 4, I match anything!')\n"
             '   ...\n'
             '   Case 3, y: 200\n'
             '\n'
             'In this case, "if flag" is a guard.  Read more about that in the '
             'next\n'
             'section.\n'
             '\n'
             '\n'
             'Guards\n'
             '------\n'
             '\n'
             '   guard ::= "if" named_expression\n'
             '\n'
             'A "guard" (which is part of the "case") must succeed for code '
             'inside\n'
             'the "case" block to execute.  It takes the form: "if" followed '
             'by an\n'
             'expression.\n'
             '\n'
             'The logical flow of a "case" block with a "guard" follows:\n'
             '\n'
             '1. Check that the pattern in the "case" block succeeded.  If '
             'the\n'
             '   pattern failed, the "guard" is not evaluated and the next '
             '"case"\n'
             '   block is checked.\n'
             '\n'
             '2. If the pattern succeeded, evaluate the "guard".\n'
             '\n'
             '   * If the "guard" condition evaluates as true, the case block '
             'is\n'
             '     selected.\n'
             '\n'
             '   * If the "guard" condition evaluates as false, the case block '
             'is\n'
             '     not selected.\n'
             '\n'
             '   * If the "guard" raises an exception during evaluation, the\n'
             '     exception bubbles up.\n'
             '\n'
             'Guards are allowed to have side effects as they are '
             'expressions.\n'
             'Guard evaluation must proceed from the first to the last case '
             'block,\n'
             'one at a time, skipping case blocks whose pattern(s) don’t all\n'
             'succeed. (I.e., guard evaluation must happen in order.) Guard\n'
             'evaluation must stop once a case block is selected.\n'
             '\n'
             '\n'
             'Irrefutable Case Blocks\n'
             '-----------------------\n'
             '\n'
             'An irrefutable case block is a match-all case block.  A match\n'
             'statement may have at most one irrefutable case block, and it '
             'must be\n'
             'last.\n'
             '\n'
             'A case block is considered irrefutable if it has no guard and '
             'its\n'
             'pattern is irrefutable.  A pattern is considered irrefutable if '
             'we can\n'
             'prove from its syntax alone that it will always succeed.  Only '
             'the\n'
             'following patterns are irrefutable:\n'
             '\n'
             '* AS Patterns whose left-hand side is irrefutable\n'
             '\n'
             '* OR Patterns containing at least one irrefutable pattern\n'
             '\n'
             '* Capture Patterns\n'
             '\n'
             '* Wildcard Patterns\n'
             '\n'
             '* parenthesized irrefutable patterns\n'
             '\n'
             '\n'
             'Patterns\n'
             '--------\n'
             '\n'
             'Note:\n'
             '\n'
             '  This section uses grammar notations beyond standard EBNF:\n'
             '\n'
             '  * the notation "SEP.RULE+" is shorthand for "RULE (SEP '
             'RULE)*"\n'
             '\n'
             '  * the notation "!RULE" is shorthand for a negative lookahead\n'
             '    assertion\n'
             '\n'
             'The top-level syntax for "patterns" is:\n'
             '\n'
             '   patterns       ::= open_sequence_pattern | pattern\n'
             '   pattern        ::= as_pattern | or_pattern\n'
             '   closed_pattern ::= | literal_pattern\n'
             '                      | capture_pattern\n'
             '                      | wildcard_pattern\n'
             '                      | value_pattern\n'
             '                      | group_pattern\n'
             '                      | sequence_pattern\n'
             '                      | mapping_pattern\n'
             '                      | class_pattern\n'
             '\n'
             'The descriptions below will include a description “in simple '
             'terms” of\n'
             'what a pattern does for illustration purposes (credits to '
             'Raymond\n'
             'Hettinger for a document that inspired most of the '
             'descriptions). Note\n'
             'that these descriptions are purely for illustration purposes and '
             '**may\n'
             'not** reflect the underlying implementation.  Furthermore, they '
             'do not\n'
             'cover all valid forms.\n'
             '\n'
             '\n'
             'OR Patterns\n'
             '~~~~~~~~~~~\n'
             '\n'
             'An OR pattern is two or more patterns separated by vertical bars '
             '"|".\n'
             'Syntax:\n'
             '\n'
             '   or_pattern ::= "|".closed_pattern+\n'
             '\n'
             'Only the final subpattern may be irrefutable, and each '
             'subpattern must\n'
             'bind the same set of names to avoid ambiguity.\n'
             '\n'
             'An OR pattern matches each of its subpatterns in turn to the '
             'subject\n'
             'value, until one succeeds.  The OR pattern is then considered\n'
             'successful.  Otherwise, if none of the subpatterns succeed, the '
             'OR\n'
             'pattern fails.\n'
             '\n'
             'In simple terms, "P1 | P2 | ..." will try to match "P1", if it '
             'fails\n'
             'it will try to match "P2", succeeding immediately if any '
             'succeeds,\n'
             'failing otherwise.\n'
             '\n'
             '\n'
             'AS Patterns\n'
             '~~~~~~~~~~~\n'
             '\n'
             'An AS pattern matches an OR pattern on the left of the "as" '
             'keyword\n'
             'against a subject.  Syntax:\n'
             '\n'
             '   as_pattern ::= or_pattern "as" capture_pattern\n'
             '\n'
             'If the OR pattern fails, the AS pattern fails.  Otherwise, the '
             'AS\n'
             'pattern binds the subject to the name on the right of the as '
             'keyword\n'
             'and succeeds. "capture_pattern" cannot be a "_".\n'
             '\n'
             'In simple terms "P as NAME" will match with "P", and on success '
             'it\n'
             'will set "NAME = <subject>".\n'
             '\n'
             '\n'
             'Literal Patterns\n'
             '~~~~~~~~~~~~~~~~\n'
             '\n'
             'A literal pattern corresponds to most literals in Python.  '
             'Syntax:\n'
             '\n'
             '   literal_pattern ::= signed_number\n'
             '                       | signed_number "+" NUMBER\n'
             '                       | signed_number "-" NUMBER\n'
             '                       | strings\n'
             '                       | "None"\n'
             '                       | "True"\n'
             '                       | "False"\n'
             '                       | signed_number: NUMBER | "-" NUMBER\n'
             '\n'
             'The rule "strings" and the token "NUMBER" are defined in the '
             'standard\n'
             'Python grammar.  Triple-quoted strings are supported.  Raw '
             'strings and\n'
             'byte strings are supported.  f-strings are not supported.\n'
             '\n'
             'The forms "signed_number \'+\' NUMBER" and "signed_number \'-\' '
             'NUMBER"\n'
             'are for expressing complex numbers; they require a real number '
             'on the\n'
             'left and an imaginary number on the right. E.g. "3 + 4j".\n'
             '\n'
             'In simple terms, "LITERAL" will succeed only if "<subject> ==\n'
             'LITERAL". For the singletons "None", "True" and "False", the '
             '"is"\n'
             'operator is used.\n'
             '\n'
             '\n'
             'Capture Patterns\n'
             '~~~~~~~~~~~~~~~~\n'
             '\n'
             'A capture pattern binds the subject value to a name. Syntax:\n'
             '\n'
             "   capture_pattern ::= !'_' NAME\n"
             '\n'
             'A single underscore "_" is not a capture pattern (this is what '
             '"!\'_\'"\n'
             'expresses). It is instead treated as a "wildcard_pattern".\n'
             '\n'
             'In a given pattern, a given name can only be bound once.  E.g. '
             '"case\n'
             'x, x: ..." is invalid while "case [x] | x: ..." is allowed.\n'
             '\n'
             'Capture patterns always succeed.  The binding follows scoping '
             'rules\n'
             'established by the assignment expression operator in **PEP '
             '572**; the\n'
             'name becomes a local variable in the closest containing function '
             'scope\n'
             'unless there’s an applicable "global" or "nonlocal" statement.\n'
             '\n'
             'In simple terms "NAME" will always succeed and it will set "NAME '
             '=\n'
             '<subject>".\n'
             '\n'
             '\n'
             'Wildcard Patterns\n'
             '~~~~~~~~~~~~~~~~~\n'
             '\n'
             'A wildcard pattern always succeeds (matches anything) and binds '
             'no\n'
             'name.  Syntax:\n'
             '\n'
             "   wildcard_pattern ::= '_'\n"
             '\n'
             '"_" is a soft keyword within any pattern, but only within '
             'patterns.\n'
             'It is an identifier, as usual, even within "match" subject\n'
             'expressions, "guard"s, and "case" blocks.\n'
             '\n'
             'In simple terms, "_" will always succeed.\n'
             '\n'
             '\n'
             'Value Patterns\n'
             '~~~~~~~~~~~~~~\n'
             '\n'
             'A value pattern represents a named value in Python. Syntax:\n'
             '\n'
             '   value_pattern ::= attr\n'
             '   attr          ::= name_or_attr "." NAME\n'
             '   name_or_attr  ::= attr | NAME\n'
             '\n'
             'The dotted name in the pattern is looked up using standard '
             'Python name\n'
             'resolution rules.  The pattern succeeds if the value found '
             'compares\n'
             'equal to the subject value (using the "==" equality operator).\n'
             '\n'
             'In simple terms "NAME1.NAME2" will succeed only if "<subject> '
             '==\n'
             'NAME1.NAME2"\n'
             '\n'
             'Note:\n'
             '\n'
             '  If the same value occurs multiple times in the same match '
             'statement,\n'
             '  the interpreter may cache the first value found and reuse it '
             'rather\n'
             '  than repeat the same lookup.  This cache is strictly tied to a '
             'given\n'
             '  execution of a given match statement.\n'
             '\n'
             '\n'
             'Group Patterns\n'
             '~~~~~~~~~~~~~~\n'
             '\n'
             'A group pattern allows users to add parentheses around patterns '
             'to\n'
             'emphasize the intended grouping.  Otherwise, it has no '
             'additional\n'
             'syntax. Syntax:\n'
             '\n'
             '   group_pattern ::= "(" pattern ")"\n'
             '\n'
             'In simple terms "(P)" has the same effect as "P".\n'
             '\n'
             '\n'
             'Sequence Patterns\n'
             '~~~~~~~~~~~~~~~~~\n'
             '\n'
             'A sequence pattern contains several subpatterns to be matched '
             'against\n'
             'sequence elements. The syntax is similar to the unpacking of a '
             'list or\n'
             'tuple.\n'
             '\n'
             '   sequence_pattern       ::= "[" [maybe_sequence_pattern] "]"\n'
             '                        | "(" [open_sequence_pattern] ")"\n'
             '   open_sequence_pattern  ::= maybe_star_pattern "," '
             '[maybe_sequence_pattern]\n'
             '   maybe_sequence_pattern ::= ",".maybe_star_pattern+ ","?\n'
             '   maybe_star_pattern     ::= star_pattern | pattern\n'
             '   star_pattern           ::= "*" (capture_pattern | '
             'wildcard_pattern)\n'
             '\n'
             'There is no difference if parentheses  or square brackets are '
             'used for\n'
             'sequence patterns (i.e. "(...)" vs "[...]" ).\n'
             '\n'
             'Note:\n'
             '\n'
             '  A single pattern enclosed in parentheses without a trailing '
             'comma\n'
             '  (e.g. "(3 | 4)") is a group pattern. While a single pattern '
             'enclosed\n'
             '  in square brackets (e.g. "[3 | 4]") is still a sequence '
             'pattern.\n'
             '\n'
             'At most one star subpattern may be in a sequence pattern.  The '
             'star\n'
             'subpattern may occur in any position. If no star subpattern is\n'
             'present, the sequence pattern is a fixed-length sequence '
             'pattern;\n'
             'otherwise it is a variable-length sequence pattern.\n'
             '\n'
             'The following is the logical flow for matching a sequence '
             'pattern\n'
             'against a subject value:\n'
             '\n'
             '1. If the subject value is not a sequence [2], the sequence '
             'pattern\n'
             '   fails.\n'
             '\n'
             '2. If the subject value is an instance of "str", "bytes" or\n'
             '   "bytearray" the sequence pattern fails.\n'
             '\n'
             '3. The subsequent steps depend on whether the sequence pattern '
             'is\n'
             '   fixed or variable-length.\n'
             '\n'
             '   If the sequence pattern is fixed-length:\n'
             '\n'
             '   1. If the length of the subject sequence is not equal to the '
             'number\n'
             '      of subpatterns, the sequence pattern fails\n'
             '\n'
             '   2. Subpatterns in the sequence pattern are matched to their\n'
             '      corresponding items in the subject sequence from left to '
             'right.\n'
             '      Matching stops as soon as a subpattern fails.  If all\n'
             '      subpatterns succeed in matching their corresponding item, '
             'the\n'
             '      sequence pattern succeeds.\n'
             '\n'
             '   Otherwise, if the sequence pattern is variable-length:\n'
             '\n'
             '   1. If the length of the subject sequence is less than the '
             'number of\n'
             '      non-star subpatterns, the sequence pattern fails.\n'
             '\n'
             '   2. The leading non-star subpatterns are matched to their\n'
             '      corresponding items as for fixed-length sequences.\n'
             '\n'
             '   3. If the previous step succeeds, the star subpattern matches '
             'a\n'
             '      list formed of the remaining subject items, excluding the\n'
             '      remaining items corresponding to non-star subpatterns '
             'following\n'
             '      the star subpattern.\n'
             '\n'
             '   4. Remaining non-star subpatterns are matched to their\n'
             '      corresponding subject items, as for a fixed-length '
             'sequence.\n'
             '\n'
             '   Note:\n'
             '\n'
             '     The length of the subject sequence is obtained via "len()" '
             '(i.e.\n'
             '     via the "__len__()" protocol).  This length may be cached '
             'by the\n'
             '     interpreter in a similar manner as value patterns.\n'
             '\n'
             'In simple terms "[P1, P2, P3," … ", P<N>]" matches only if all '
             'the\n'
             'following happens:\n'
             '\n'
             '* check "<subject>" is a sequence\n'
             '\n'
             '* "len(subject) == <N>"\n'
             '\n'
             '* "P1" matches "<subject>[0]" (note that this match can also '
             'bind\n'
             '  names)\n'
             '\n'
             '* "P2" matches "<subject>[1]" (note that this match can also '
             'bind\n'
             '  names)\n'
             '\n'
             '* … and so on for the corresponding pattern/element.\n'
             '\n'
             '\n'
             'Mapping Patterns\n'
             '~~~~~~~~~~~~~~~~\n'
             '\n'
             'A mapping pattern contains one or more key-value patterns.  The '
             'syntax\n'
             'is similar to the construction of a dictionary. Syntax:\n'
             '\n'
             '   mapping_pattern     ::= "{" [items_pattern] "}"\n'
             '   items_pattern       ::= ",".key_value_pattern+ ","?\n'
             '   key_value_pattern   ::= (literal_pattern | value_pattern) ":" '
             'pattern\n'
             '                         | double_star_pattern\n'
             '   double_star_pattern ::= "**" capture_pattern\n'
             '\n'
             'At most one double star pattern may be in a mapping pattern.  '
             'The\n'
             'double star pattern must be the last subpattern in the mapping\n'
             'pattern.\n'
             '\n'
             'Duplicate keys in mapping patterns are disallowed. Duplicate '
             'literal\n'
             'keys will raise a "SyntaxError". Two keys that otherwise have '
             'the same\n'
             'value will raise a "ValueError" at runtime.\n'
             '\n'
             'The following is the logical flow for matching a mapping '
             'pattern\n'
             'against a subject value:\n'
             '\n'
             '1. If the subject value is not a mapping [3],the mapping '
             'pattern\n'
             '   fails.\n'
             '\n'
             '2. If every key given in the mapping pattern is present in the '
             'subject\n'
             '   mapping, and the pattern for each key matches the '
             'corresponding\n'
             '   item of the subject mapping, the mapping pattern succeeds.\n'
             '\n'
             '3. If duplicate keys are detected in the mapping pattern, the '
             'pattern\n'
             '   is considered invalid. A "SyntaxError" is raised for '
             'duplicate\n'
             '   literal values; or a "ValueError" for named keys of the same '
             'value.\n'
             '\n'
             'Note:\n'
             '\n'
             '  Key-value pairs are matched using the two-argument form of '
             'the\n'
             '  mapping subject’s "get()" method.  Matched key-value pairs '
             'must\n'
             '  already be present in the mapping, and not created on-the-fly '
             'via\n'
             '  "__missing__()" or "__getitem__()".\n'
             '\n'
             'In simple terms "{KEY1: P1, KEY2: P2, ... }" matches only if all '
             'the\n'
             'following happens:\n'
             '\n'
             '* check "<subject>" is a mapping\n'
             '\n'
             '* "KEY1 in <subject>"\n'
             '\n'
             '* "P1" matches "<subject>[KEY1]"\n'
             '\n'
             '* … and so on for the corresponding KEY/pattern pair.\n'
             '\n'
             '\n'
             'Class Patterns\n'
             '~~~~~~~~~~~~~~\n'
             '\n'
             'A class pattern represents a class and its positional and '
             'keyword\n'
             'arguments (if any).  Syntax:\n'
             '\n'
             '   class_pattern       ::= name_or_attr "(" [pattern_arguments '
             '","?] ")"\n'
             '   pattern_arguments   ::= positional_patterns ["," '
             'keyword_patterns]\n'
             '                         | keyword_patterns\n'
             '   positional_patterns ::= ",".pattern+\n'
             '   keyword_patterns    ::= ",".keyword_pattern+\n'
             '   keyword_pattern     ::= NAME "=" pattern\n'
             '\n'
             'The same keyword should not be repeated in class patterns.\n'
             '\n'
             'The following is the logical flow for matching a class pattern '
             'against\n'
             'a subject value:\n'
             '\n'
             '1. If "name_or_attr" is not an instance of the builtin "type" , '
             'raise\n'
             '   "TypeError".\n'
             '\n'
             '2. If the subject value is not an instance of "name_or_attr" '
             '(tested\n'
             '   via "isinstance()"), the class pattern fails.\n'
             '\n'
             '3. If no pattern arguments are present, the pattern succeeds.\n'
             '   Otherwise, the subsequent steps depend on whether keyword or\n'
             '   positional argument patterns are present.\n'
             '\n'
             '   For a number of built-in types (specified below), a single\n'
             '   positional subpattern is accepted which will match the '
             'entire\n'
             '   subject; for these types keyword patterns also work as for '
             'other\n'
             '   types.\n'
             '\n'
             '   If only keyword patterns are present, they are processed as\n'
             '   follows, one by one:\n'
             '\n'
             '   I. The keyword is looked up as an attribute on the subject.\n'
             '\n'
             '      * If this raises an exception other than "AttributeError", '
             'the\n'
             '        exception bubbles up.\n'
             '\n'
             '      * If this raises "AttributeError", the class pattern has '
             'failed.\n'
             '\n'
             '      * Else, the subpattern associated with the keyword pattern '
             'is\n'
             '        matched against the subject’s attribute value.  If this '
             'fails,\n'
             '        the class pattern fails; if this succeeds, the match '
             'proceeds\n'
             '        to the next keyword.\n'
             '\n'
             '   II. If all keyword patterns succeed, the class pattern '
             'succeeds.\n'
             '\n'
             '   If any positional patterns are present, they are converted '
             'to\n'
             '   keyword patterns using the "__match_args__" attribute on the '
             'class\n'
             '   "name_or_attr" before matching:\n'
             '\n'
             '   I. The equivalent of "getattr(cls, "__match_args__", ())" is\n'
             '   called.\n'
             '\n'
             '      * If this raises an exception, the exception bubbles up.\n'
             '\n'
             '      * If the returned value is not a tuple, the conversion '
             'fails and\n'
             '        "TypeError" is raised.\n'
             '\n'
             '      * If there are more positional patterns than\n'
             '        "len(cls.__match_args__)", "TypeError" is raised.\n'
             '\n'
             '      * Otherwise, positional pattern "i" is converted to a '
             'keyword\n'
             '        pattern using "__match_args__[i]" as the keyword.\n'
             '        "__match_args__[i]" must be a string; if not "TypeError" '
             'is\n'
             '        raised.\n'
             '\n'
             '      * If there are duplicate keywords, "TypeError" is raised.\n'
             '\n'
             '      See also:\n'
             '\n'
             '        Customizing positional arguments in class pattern '
             'matching\n'
             '\n'
             '   II. Once all positional patterns have been converted to '
             'keyword\n'
             '   patterns,\n'
             '      the match proceeds as if there were only keyword '
             'patterns.\n'
             '\n'
             '   For the following built-in types the handling of positional\n'
             '   subpatterns is different:\n'
             '\n'
             '   * "bool"\n'
             '\n'
             '   * "bytearray"\n'
             '\n'
             '   * "bytes"\n'
             '\n'
             '   * "dict"\n'
             '\n'
             '   * "float"\n'
             '\n'
             '   * "frozenset"\n'
             '\n'
             '   * "int"\n'
             '\n'
             '   * "list"\n'
             '\n'
             '   * "set"\n'
             '\n'
             '   * "str"\n'
             '\n'
             '   * "tuple"\n'
             '\n'
             '   These classes accept a single positional argument, and the '
             'pattern\n'
             '   there is matched against the whole object rather than an '
             'attribute.\n'
             '   For example "int(0|1)" matches the value "0", but not the '
             'value\n'
             '   "0.0".\n'
             '\n'
             'In simple terms "CLS(P1, attr=P2)" matches only if the '
             'following\n'
             'happens:\n'
             '\n'
             '* "isinstance(<subject>, CLS)"\n'
             '\n'
             '* convert "P1" to a keyword pattern using "CLS.__match_args__"\n'
             '\n'
             '* For each keyword argument "attr=P2":\n'
             '\n'
             '  * "hasattr(<subject>, "attr")"\n'
             '\n'
             '  * "P2" matches "<subject>.attr"\n'
             '\n'
             '* … and so on for the corresponding keyword argument/pattern '
             'pair.\n'
             '\n'
             'See also:\n'
             '\n'
             '  * **PEP 634** – Structural Pattern Matching: Specification\n'
             '\n'
             '  * **PEP 636** – Structural Pattern Matching: Tutorial\n'
             '\n'
             '\n'
             'Function definitions\n'
             '====================\n'
             '\n'
             'A function definition defines a user-defined function object '
             '(see\n'
             'section The standard type hierarchy):\n'
             '\n'
             '   funcdef                   ::= [decorators] "def" funcname "(" '
             '[parameter_list] ")"\n'
             '               ["->" expression] ":" suite\n'
             '   decorators                ::= decorator+\n'
             '   decorator                 ::= "@" assignment_expression '
             'NEWLINE\n'
             '   parameter_list            ::= defparameter ("," '
             'defparameter)* "," "/" ["," [parameter_list_no_posonly]]\n'
             '                        | parameter_list_no_posonly\n'
             '   parameter_list_no_posonly ::= defparameter ("," '
             'defparameter)* ["," [parameter_list_starargs]]\n'
             '                                 | parameter_list_starargs\n'
             '   parameter_list_starargs   ::= "*" [parameter] ("," '
             'defparameter)* ["," ["**" parameter [","]]]\n'
             '                               | "**" parameter [","]\n'
             '   parameter                 ::= identifier [":" expression]\n'
             '   defparameter              ::= parameter ["=" expression]\n'
             '   funcname                  ::= identifier\n'
             '\n'
             'A function definition is an executable statement.  Its execution '
             'binds\n'
             'the function name in the current local namespace to a function '
             'object\n'
             '(a wrapper around the executable code for the function).  This\n'
             'function object contains a reference to the current global '
             'namespace\n'
             'as the global namespace to be used when the function is called.\n'
             '\n'
             'The function definition does not execute the function body; this '
             'gets\n'
             'executed only when the function is called. [4]\n'
             '\n'
             'A function definition may be wrapped by one or more *decorator*\n'
             'expressions. Decorator expressions are evaluated when the '
             'function is\n'
             'defined, in the scope that contains the function definition.  '
             'The\n'
             'result must be a callable, which is invoked with the function '
             'object\n'
             'as the only argument. The returned value is bound to the '
             'function name\n'
             'instead of the function object.  Multiple decorators are applied '
             'in\n'
             'nested fashion. For example, the following code\n'
             '\n'
             '   @f1(arg)\n'
             '   @f2\n'
             '   def func(): pass\n'
             '\n'
             'is roughly equivalent to\n'
             '\n'
             '   def func(): pass\n'
             '   func = f1(arg)(f2(func))\n'
             '\n'
             'except that the original function is not temporarily bound to '
             'the name\n'
             '"func".\n'
             '\n'
             'Changed in version 3.9: Functions may be decorated with any '
             'valid\n'
             '"assignment_expression". Previously, the grammar was much more\n'
             'restrictive; see **PEP 614** for details.\n'
             '\n'
             'When one or more *parameters* have the form *parameter* "="\n'
             '*expression*, the function is said to have “default parameter '
             'values.”\n'
             'For a parameter with a default value, the corresponding '
             '*argument* may\n'
             'be omitted from a call, in which case the parameter’s default '
             'value is\n'
             'substituted.  If a parameter has a default value, all following\n'
             'parameters up until the “"*"” must also have a default value — '
             'this is\n'
             'a syntactic restriction that is not expressed by the grammar.\n'
             '\n'
             '**Default parameter values are evaluated from left to right when '
             'the\n'
             'function definition is executed.** This means that the '
             'expression is\n'
             'evaluated once, when the function is defined, and that the same '
             '“pre-\n'
             'computed” value is used for each call.  This is especially '
             'important\n'
             'to understand when a default parameter value is a mutable '
             'object, such\n'
             'as a list or a dictionary: if the function modifies the object '
             '(e.g.\n'
             'by appending an item to a list), the default parameter value is '
             'in\n'
             'effect modified.  This is generally not what was intended.  A '
             'way\n'
             'around this is to use "None" as the default, and explicitly test '
             'for\n'
             'it in the body of the function, e.g.:\n'
             '\n'
             '   def whats_on_the_telly(penguin=None):\n'
             '       if penguin is None:\n'
             '           penguin = []\n'
             '       penguin.append("property of the zoo")\n'
             '       return penguin\n'
             '\n'
             'Function call semantics are described in more detail in section '
             'Calls.\n'
             'A function call always assigns values to all parameters '
             'mentioned in\n'
             'the parameter list, either from positional arguments, from '
             'keyword\n'
             'arguments, or from default values.  If the form “"*identifier"” '
             'is\n'
             'present, it is initialized to a tuple receiving any excess '
             'positional\n'
             'parameters, defaulting to the empty tuple. If the form\n'
             '“"**identifier"” is present, it is initialized to a new ordered\n'
             'mapping receiving any excess keyword arguments, defaulting to a '
             'new\n'
             'empty mapping of the same type.  Parameters after “"*"” or\n'
             '“"*identifier"” are keyword-only parameters and may only be '
             'passed by\n'
             'keyword arguments.  Parameters before “"/"” are positional-only\n'
             'parameters and may only be passed by positional arguments.\n'
             '\n'
             'Changed in version 3.8: The "/" function parameter syntax may be '
             'used\n'
             'to indicate positional-only parameters. See **PEP 570** for '
             'details.\n'
             '\n'
             'Parameters may have an *annotation* of the form “": '
             'expression"”\n'
             'following the parameter name.  Any parameter may have an '
             'annotation,\n'
             'even those of the form "*identifier" or "**identifier".  '
             'Functions may\n'
             'have “return” annotation of the form “"-> expression"” after '
             'the\n'
             'parameter list.  These annotations can be any valid Python '
             'expression.\n'
             'The presence of annotations does not change the semantics of a\n'
             'function.  The annotation values are available as values of a\n'
             'dictionary keyed by the parameters’ names in the '
             '"__annotations__"\n'
             'attribute of the function object.  If the "annotations" import '
             'from\n'
             '"__future__" is used, annotations are preserved as strings at '
             'runtime\n'
             'which enables postponed evaluation.  Otherwise, they are '
             'evaluated\n'
             'when the function definition is executed.  In this case '
             'annotations\n'
             'may be evaluated in a different order than they appear in the '
             'source\n'
             'code.\n'
             '\n'
             'It is also possible to create anonymous functions (functions not '
             'bound\n'
             'to a name), for immediate use in expressions.  This uses lambda\n'
             'expressions, described in section Lambdas.  Note that the '
             'lambda\n'
             'expression is merely a shorthand for a simplified function '
             'definition;\n'
             'a function defined in a “"def"” statement can be passed around '
             'or\n'
             'assigned to another name just like a function defined by a '
             'lambda\n'
             'expression.  The “"def"” form is actually more powerful since '
             'it\n'
             'allows the execution of multiple statements and annotations.\n'
             '\n'
             '**Programmer’s note:** Functions are first-class objects.  A '
             '“"def"”\n'
             'statement executed inside a function definition defines a local\n'
             'function that can be returned or passed around.  Free variables '
             'used\n'
             'in the nested function can access the local variables of the '
             'function\n'
             'containing the def.  See section Naming and binding for '
             'details.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 3107** - Function Annotations\n'
             '     The original specification for function annotations.\n'
             '\n'
             '  **PEP 484** - Type Hints\n'
             '     Definition of a standard meaning for annotations: type '
             'hints.\n'
             '\n'
             '  **PEP 526** - Syntax for Variable Annotations\n'
             '     Ability to type hint variable declarations, including '
             'class\n'
             '     variables and instance variables.\n'
             '\n'
             '  **PEP 563** - Postponed Evaluation of Annotations\n'
             '     Support for forward references within annotations by '
             'preserving\n'
             '     annotations in a string form at runtime instead of eager\n'
             '     evaluation.\n'
             '\n'
             '  **PEP 318** - Decorators for Functions and Methods\n'
             '     Function and method decorators were introduced. Class '
             'decorators\n'
             '     were introduced in **PEP 3129**.\n'
             '\n'
             '\n'
             'Class definitions\n'
             '=================\n'
             '\n'
             'A class definition defines a class object (see section The '
             'standard\n'
             'type hierarchy):\n'
             '\n'
             '   classdef    ::= [decorators] "class" classname [inheritance] '
             '":" suite\n'
             '   inheritance ::= "(" [argument_list] ")"\n'
             '   classname   ::= identifier\n'
             '\n'
             'A class definition is an executable statement.  The inheritance '
             'list\n'
             'usually gives a list of base classes (see Metaclasses for more\n'
             'advanced uses), so each item in the list should evaluate to a '
             'class\n'
             'object which allows subclassing.  Classes without an inheritance '
             'list\n'
             'inherit, by default, from the base class "object"; hence,\n'
             '\n'
             '   class Foo:\n'
             '       pass\n'
             '\n'
             'is equivalent to\n'
             '\n'
             '   class Foo(object):\n'
             '       pass\n'
             '\n'
             'The class’s suite is then executed in a new execution frame '
             '(see\n'
             'Naming and binding), using a newly created local namespace and '
             'the\n'
             'original global namespace. (Usually, the suite contains mostly\n'
             'function definitions.)  When the class’s suite finishes '
             'execution, its\n'
             'execution frame is discarded but its local namespace is saved. '
             '[5] A\n'
             'class object is then created using the inheritance list for the '
             'base\n'
             'classes and the saved local namespace for the attribute '
             'dictionary.\n'
             'The class name is bound to this class object in the original '
             'local\n'
             'namespace.\n'
             '\n'
             'The order in which attributes are defined in the class body is\n'
             'preserved in the new class’s "__dict__".  Note that this is '
             'reliable\n'
             'only right after the class is created and only for classes that '
             'were\n'
             'defined using the definition syntax.\n'
             '\n'
             'Class creation can be customized heavily using metaclasses.\n'
             '\n'
             'Classes can also be decorated: just like when decorating '
             'functions,\n'
             '\n'
             '   @f1(arg)\n'
             '   @f2\n'
             '   class Foo: pass\n'
             '\n'
             'is roughly equivalent to\n'
             '\n'
             '   class Foo: pass\n'
             '   Foo = f1(arg)(f2(Foo))\n'
             '\n'
             'The evaluation rules for the decorator expressions are the same '
             'as for\n'
             'function decorators.  The result is then bound to the class '
             'name.\n'
             '\n'
             'Changed in version 3.9: Classes may be decorated with any valid\n'
             '"assignment_expression". Previously, the grammar was much more\n'
             'restrictive; see **PEP 614** for details.\n'
             '\n'
             '**Programmer’s note:** Variables defined in the class definition '
             'are\n'
             'class attributes; they are shared by instances.  Instance '
             'attributes\n'
             'can be set in a method with "self.name = value".  Both class '
             'and\n'
             'instance attributes are accessible through the notation '
             '“"self.name"”,\n'
             'and an instance attribute hides a class attribute with the same '
             'name\n'
             'when accessed in this way.  Class attributes can be used as '
             'defaults\n'
             'for instance attributes, but using mutable values there can lead '
             'to\n'
             'unexpected results.  Descriptors can be used to create instance\n'
             'variables with different implementation details.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 3115** - Metaclasses in Python 3000\n'
             '     The proposal that changed the declaration of metaclasses to '
             'the\n'
             '     current syntax, and the semantics for how classes with\n'
             '     metaclasses are constructed.\n'
             '\n'
             '  **PEP 3129** - Class Decorators\n'
             '     The proposal that added class decorators.  Function and '
             'method\n'
             '     decorators were introduced in **PEP 318**.\n'
             '\n'
             '\n'
             'Coroutines\n'
             '==========\n'
             '\n'
             'New in version 3.5.\n'
             '\n'
             '\n'
             'Coroutine function definition\n'
             '-----------------------------\n'
             '\n'
             '   async_funcdef ::= [decorators] "async" "def" funcname "(" '
             '[parameter_list] ")"\n'
             '                     ["->" expression] ":" suite\n'
             '\n'
             'Execution of Python coroutines can be suspended and resumed at '
             'many\n'
             'points (see *coroutine*). "await" expressions, "async for" and '
             '"async\n'
             'with" can only be used in the body of a coroutine function.\n'
             '\n'
             'Functions defined with "async def" syntax are always coroutine\n'
             'functions, even if they do not contain "await" or "async" '
             'keywords.\n'
             '\n'
             'It is a "SyntaxError" to use a "yield from" expression inside '
             'the body\n'
             'of a coroutine function.\n'
             '\n'
             'An example of a coroutine function:\n'
             '\n'
             '   async def func(param1, param2):\n'
             '       do_stuff()\n'
             '       await some_coroutine()\n'
             '\n'
             'Changed in version 3.7: "await" and "async" are now keywords;\n'
             'previously they were only treated as such inside the body of a\n'
             'coroutine function.\n'
             '\n'
             '\n'
             'The "async for" statement\n'
             '-------------------------\n'
             '\n'
             '   async_for_stmt ::= "async" for_stmt\n'
             '\n'
             'An *asynchronous iterable* provides an "__aiter__" method that\n'
             'directly returns an *asynchronous iterator*, which can call\n'
             'asynchronous code in its "__anext__" method.\n'
             '\n'
             'The "async for" statement allows convenient iteration over\n'
             'asynchronous iterables.\n'
             '\n'
             'The following code:\n'
             '\n'
             '   async for TARGET in ITER:\n'
             '       SUITE\n'
             '   else:\n'
             '       SUITE2\n'
             '\n'
             'Is semantically equivalent to:\n'
             '\n'
             '   iter = (ITER)\n'
             '   iter = type(iter).__aiter__(iter)\n'
             '   running = True\n'
             '\n'
             '   while running:\n'
             '       try:\n'
             '           TARGET = await type(iter).__anext__(iter)\n'
             '       except StopAsyncIteration:\n'
             '           running = False\n'
             '       else:\n'
             '           SUITE\n'
             '   else:\n'
             '       SUITE2\n'
             '\n'
             'See also "__aiter__()" and "__anext__()" for details.\n'
             '\n'
             'It is a "SyntaxError" to use an "async for" statement outside '
             'the body\n'
             'of a coroutine function.\n'
             '\n'
             '\n'
             'The "async with" statement\n'
             '--------------------------\n'
             '\n'
             '   async_with_stmt ::= "async" with_stmt\n'
             '\n'
             'An *asynchronous context manager* is a *context manager* that is '
             'able\n'
             'to suspend execution in its *enter* and *exit* methods.\n'
             '\n'
             'The following code:\n'
             '\n'
             '   async with EXPRESSION as TARGET:\n'
             '       SUITE\n'
             '\n'
             'is semantically equivalent to:\n'
             '\n'
             '   manager = (EXPRESSION)\n'
             '   aenter = type(manager).__aenter__\n'
             '   aexit = type(manager).__aexit__\n'
             '   value = await aenter(manager)\n'
             '   hit_except = False\n'
             '\n'
             '   try:\n'
             '       TARGET = value\n'
             '       SUITE\n'
             '   except:\n'
             '       hit_except = True\n'
             '       if not await aexit(manager, *sys.exc_info()):\n'
             '           raise\n'
             '   finally:\n'
             '       if not hit_except:\n'
             '           await aexit(manager, None, None, None)\n'
             '\n'
             'See also "__aenter__()" and "__aexit__()" for details.\n'
             '\n'
             'It is a "SyntaxError" to use an "async with" statement outside '
             'the\n'
             'body of a coroutine function.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 492** - Coroutines with async and await syntax\n'
             '     The proposal that made coroutines a proper standalone '
             'concept in\n'
             '     Python, and added supporting syntax.\n'
             '\n'
             '-[ Footnotes ]-\n'
             '\n'
             '[1] The exception is propagated to the invocation stack unless '
             'there\n'
             '    is a "finally" clause which happens to raise another '
             'exception.\n'
             '    That new exception causes the old one to be lost.\n'
             '\n'
             '[2] In pattern matching, a sequence is defined as one of the\n'
             '    following:\n'
             '\n'
             '    * a class that inherits from "collections.abc.Sequence"\n'
             '\n'
             '    * a Python class that has been registered as\n'
             '      "collections.abc.Sequence"\n'
             '\n'
             '    * a builtin class that has its (CPython) '
             '"Py_TPFLAGS_SEQUENCE" bit\n'
             '      set\n'
             '\n'
             '    * a class that inherits from any of the above\n'
             '\n'
             '    The following standard library classes are sequences:\n'
             '\n'
             '    * "array.array"\n'
             '\n'
             '    * "collections.deque"\n'
             '\n'
             '    * "list"\n'
             '\n'
             '    * "memoryview"\n'
             '\n'
             '    * "range"\n'
             '\n'
             '    * "tuple"\n'
             '\n'
             '    Note:\n'
             '\n'
             '      Subject values of type "str", "bytes", and "bytearray" do '
             'not\n'
             '      match sequence patterns.\n'
             '\n'
             '[3] In pattern matching, a mapping is defined as one of the '
             'following:\n'
             '\n'
             '    * a class that inherits from "collections.abc.Mapping"\n'
             '\n'
             '    * a Python class that has been registered as\n'
             '      "collections.abc.Mapping"\n'
             '\n'
             '    * a builtin class that has its (CPython) '
             '"Py_TPFLAGS_MAPPING" bit\n'
             '      set\n'
             '\n'
             '    * a class that inherits from any of the above\n'
             '\n'
             '    The standard library classes "dict" and '
             '"types.MappingProxyType"\n'
             '    are mappings.\n'
             '\n'
             '[4] A string literal appearing as the first statement in the '
             'function\n'
             '    body is transformed into the function’s "__doc__" attribute '
             'and\n'
             '    therefore the function’s *docstring*.\n'
             '\n'
             '[5] A string literal appearing as the first statement in the '
             'class\n'
             '    body is transformed into the namespace’s "__doc__" item and\n'
             '    therefore the class’s *docstring*.\n',
 'context-managers': 'With Statement Context Managers\n'
                     '*******************************\n'
                     '\n'
                     'A *context manager* is an object that defines the '
                     'runtime context to\n'
                     'be established when executing a "with" statement. The '
                     'context manager\n'
                     'handles the entry into, and the exit from, the desired '
                     'runtime context\n'
                     'for the execution of the block of code.  Context '
                     'managers are normally\n'
                     'invoked using the "with" statement (described in section '
                     'The with\n'
                     'statement), but can also be used by directly invoking '
                     'their methods.\n'
                     '\n'
                     'Typical uses of context managers include saving and '
                     'restoring various\n'
                     'kinds of global state, locking and unlocking resources, '
                     'closing opened\n'
                     'files, etc.\n'
                     '\n'
                     'For more information on context managers, see Context '
                     'Manager Types.\n'
                     '\n'
                     'object.__enter__(self)\n'
                     '\n'
                     '   Enter the runtime context related to this object. The '
                     '"with"\n'
                     '   statement will bind this method’s return value to the '
                     'target(s)\n'
                     '   specified in the "as" clause of the statement, if '
                     'any.\n'
                     '\n'
                     'object.__exit__(self, exc_type, exc_value, traceback)\n'
                     '\n'
                     '   Exit the runtime context related to this object. The '
                     'parameters\n'
                     '   describe the exception that caused the context to be '
                     'exited. If the\n'
                     '   context was exited without an exception, all three '
                     'arguments will\n'
                     '   be "None".\n'
                     '\n'
                     '   If an exception is supplied, and the method wishes to '
                     'suppress the\n'
                     '   exception (i.e., prevent it from being propagated), '
                     'it should\n'
                     '   return a true value. Otherwise, the exception will be '
                     'processed\n'
                     '   normally upon exit from this method.\n'
                     '\n'
                     '   Note that "__exit__()" methods should not reraise the '
                     'passed-in\n'
                     '   exception; this is the caller’s responsibility.\n'
                     '\n'
                     'See also:\n'
                     '\n'
                     '  **PEP 343** - The “with” statement\n'
                     '     The specification, background, and examples for the '
                     'Python "with"\n'
                     '     statement.\n',
 'continue': 'The "continue" statement\n'
             '************************\n'
             '\n'
             '   continue_stmt ::= "continue"\n'
             '\n'
             '"continue" may only occur syntactically nested in a "for" or '
             '"while"\n'
             'loop, but not nested in a function or class definition within '
             'that\n'
             'loop.  It continues with the next cycle of the nearest enclosing '
             'loop.\n'
             '\n'
             'When "continue" passes control out of a "try" statement with a\n'
             '"finally" clause, that "finally" clause is executed before '
             'really\n'
             'starting the next loop cycle.\n',
 'conversions': 'Arithmetic conversions\n'
                '**********************\n'
                '\n'
                'When a description of an arithmetic operator below uses the '
                'phrase\n'
                '“the numeric arguments are converted to a common type”, this '
                'means\n'
                'that the operator implementation for built-in types works as '
                'follows:\n'
                '\n'
                '* If either argument is a complex number, the other is '
                'converted to\n'
                '  complex;\n'
                '\n'
                '* otherwise, if either argument is a floating point number, '
                'the other\n'
                '  is converted to floating point;\n'
                '\n'
                '* otherwise, both must be integers and no conversion is '
                'necessary.\n'
                '\n'
                'Some additional rules apply for certain operators (e.g., a '
                'string as a\n'
                'left argument to the ‘%’ operator).  Extensions must define '
                'their own\n'
                'conversion behavior.\n',
 'customization': 'Basic customization\n'
                  '*******************\n'
                  '\n'
                  'object.__new__(cls[, ...])\n'
                  '\n'
                  '   Called to create a new instance of class *cls*.  '
                  '"__new__()" is a\n'
                  '   static method (special-cased so you need not declare it '
                  'as such)\n'
                  '   that takes the class of which an instance was requested '
                  'as its\n'
                  '   first argument.  The remaining arguments are those '
                  'passed to the\n'
                  '   object constructor expression (the call to the class).  '
                  'The return\n'
                  '   value of "__new__()" should be the new object instance '
                  '(usually an\n'
                  '   instance of *cls*).\n'
                  '\n'
                  '   Typical implementations create a new instance of the '
                  'class by\n'
                  '   invoking the superclass’s "__new__()" method using\n'
                  '   "super().__new__(cls[, ...])" with appropriate arguments '
                  'and then\n'
                  '   modifying the newly created instance as necessary before '
                  'returning\n'
                  '   it.\n'
                  '\n'
                  '   If "__new__()" is invoked during object construction and '
                  'it returns\n'
                  '   an instance of *cls*, then the new instance’s '
                  '"__init__()" method\n'
                  '   will be invoked like "__init__(self[, ...])", where '
                  '*self* is the\n'
                  '   new instance and the remaining arguments are the same as '
                  'were\n'
                  '   passed to the object constructor.\n'
                  '\n'
                  '   If "__new__()" does not return an instance of *cls*, '
                  'then the new\n'
                  '   instance’s "__init__()" method will not be invoked.\n'
                  '\n'
                  '   "__new__()" is intended mainly to allow subclasses of '
                  'immutable\n'
                  '   types (like int, str, or tuple) to customize instance '
                  'creation.  It\n'
                  '   is also commonly overridden in custom metaclasses in '
                  'order to\n'
                  '   customize class creation.\n'
                  '\n'
                  'object.__init__(self[, ...])\n'
                  '\n'
                  '   Called after the instance has been created (by '
                  '"__new__()"), but\n'
                  '   before it is returned to the caller.  The arguments are '
                  'those\n'
                  '   passed to the class constructor expression.  If a base '
                  'class has an\n'
                  '   "__init__()" method, the derived class’s "__init__()" '
                  'method, if\n'
                  '   any, must explicitly call it to ensure proper '
                  'initialization of the\n'
                  '   base class part of the instance; for example:\n'
                  '   "super().__init__([args...])".\n'
                  '\n'
                  '   Because "__new__()" and "__init__()" work together in '
                  'constructing\n'
                  '   objects ("__new__()" to create it, and "__init__()" to '
                  'customize\n'
                  '   it), no non-"None" value may be returned by '
                  '"__init__()"; doing so\n'
                  '   will cause a "TypeError" to be raised at runtime.\n'
                  '\n'
                  'object.__del__(self)\n'
                  '\n'
                  '   Called when the instance is about to be destroyed.  This '
                  'is also\n'
                  '   called a finalizer or (improperly) a destructor.  If a '
                  'base class\n'
                  '   has a "__del__()" method, the derived class’s '
                  '"__del__()" method,\n'
                  '   if any, must explicitly call it to ensure proper '
                  'deletion of the\n'
                  '   base class part of the instance.\n'
                  '\n'
                  '   It is possible (though not recommended!) for the '
                  '"__del__()" method\n'
                  '   to postpone destruction of the instance by creating a '
                  'new reference\n'
                  '   to it.  This is called object *resurrection*.  It is\n'
                  '   implementation-dependent whether "__del__()" is called a '
                  'second\n'
                  '   time when a resurrected object is about to be destroyed; '
                  'the\n'
                  '   current *CPython* implementation only calls it once.\n'
                  '\n'
                  '   It is not guaranteed that "__del__()" methods are called '
                  'for\n'
                  '   objects that still exist when the interpreter exits.\n'
                  '\n'
                  '   Note:\n'
                  '\n'
                  '     "del x" doesn’t directly call "x.__del__()" — the '
                  'former\n'
                  '     decrements the reference count for "x" by one, and the '
                  'latter is\n'
                  '     only called when "x"’s reference count reaches zero.\n'
                  '\n'
                  '   **CPython implementation detail:** It is possible for a '
                  'reference\n'
                  '   cycle to prevent the reference count of an object from '
                  'going to\n'
                  '   zero.  In this case, the cycle will be later detected '
                  'and deleted\n'
                  '   by the *cyclic garbage collector*.  A common cause of '
                  'reference\n'
                  '   cycles is when an exception has been caught in a local '
                  'variable.\n'
                  '   The frame’s locals then reference the exception, which '
                  'references\n'
                  '   its own traceback, which references the locals of all '
                  'frames caught\n'
                  '   in the traceback.\n'
                  '\n'
                  '   See also: Documentation for the "gc" module.\n'
                  '\n'
                  '   Warning:\n'
                  '\n'
                  '     Due to the precarious circumstances under which '
                  '"__del__()"\n'
                  '     methods are invoked, exceptions that occur during '
                  'their execution\n'
                  '     are ignored, and a warning is printed to "sys.stderr" '
                  'instead.\n'
                  '     In particular:\n'
                  '\n'
                  '     * "__del__()" can be invoked when arbitrary code is '
                  'being\n'
                  '       executed, including from any arbitrary thread.  If '
                  '"__del__()"\n'
                  '       needs to take a lock or invoke any other blocking '
                  'resource, it\n'
                  '       may deadlock as the resource may already be taken by '
                  'the code\n'
                  '       that gets interrupted to execute "__del__()".\n'
                  '\n'
                  '     * "__del__()" can be executed during interpreter '
                  'shutdown.  As a\n'
                  '       consequence, the global variables it needs to access '
                  '(including\n'
                  '       other modules) may already have been deleted or set '
                  'to "None".\n'
                  '       Python guarantees that globals whose name begins '
                  'with a single\n'
                  '       underscore are deleted from their module before '
                  'other globals\n'
                  '       are deleted; if no other references to such globals '
                  'exist, this\n'
                  '       may help in assuring that imported modules are still '
                  'available\n'
                  '       at the time when the "__del__()" method is called.\n'
                  '\n'
                  'object.__repr__(self)\n'
                  '\n'
                  '   Called by the "repr()" built-in function to compute the '
                  '“official”\n'
                  '   string representation of an object.  If at all possible, '
                  'this\n'
                  '   should look like a valid Python expression that could be '
                  'used to\n'
                  '   recreate an object with the same value (given an '
                  'appropriate\n'
                  '   environment).  If this is not possible, a string of the '
                  'form\n'
                  '   "<...some useful description...>" should be returned. '
                  'The return\n'
                  '   value must be a string object. If a class defines '
                  '"__repr__()" but\n'
                  '   not "__str__()", then "__repr__()" is also used when an '
                  '“informal”\n'
                  '   string representation of instances of that class is '
                  'required.\n'
                  '\n'
                  '   This is typically used for debugging, so it is important '
                  'that the\n'
                  '   representation is information-rich and unambiguous.\n'
                  '\n'
                  'object.__str__(self)\n'
                  '\n'
                  '   Called by "str(object)" and the built-in functions '
                  '"format()" and\n'
                  '   "print()" to compute the “informal” or nicely printable '
                  'string\n'
                  '   representation of an object.  The return value must be a '
                  'string\n'
                  '   object.\n'
                  '\n'
                  '   This method differs from "object.__repr__()" in that '
                  'there is no\n'
                  '   expectation that "__str__()" return a valid Python '
                  'expression: a\n'
                  '   more convenient or concise representation can be used.\n'
                  '\n'
                  '   The default implementation defined by the built-in type '
                  '"object"\n'
                  '   calls "object.__repr__()".\n'
                  '\n'
                  'object.__bytes__(self)\n'
                  '\n'
                  '   Called by bytes to compute a byte-string representation '
                  'of an\n'
                  '   object. This should return a "bytes" object.\n'
                  '\n'
                  'object.__format__(self, format_spec)\n'
                  '\n'
                  '   Called by the "format()" built-in function, and by '
                  'extension,\n'
                  '   evaluation of formatted string literals and the '
                  '"str.format()"\n'
                  '   method, to produce a “formatted” string representation '
                  'of an\n'
                  '   object. The *format_spec* argument is a string that '
                  'contains a\n'
                  '   description of the formatting options desired. The '
                  'interpretation\n'
                  '   of the *format_spec* argument is up to the type '
                  'implementing\n'
                  '   "__format__()", however most classes will either '
                  'delegate\n'
                  '   formatting to one of the built-in types, or use a '
                  'similar\n'
                  '   formatting option syntax.\n'
                  '\n'
                  '   See Format Specification Mini-Language for a description '
                  'of the\n'
                  '   standard formatting syntax.\n'
                  '\n'
                  '   The return value must be a string object.\n'
                  '\n'
                  '   Changed in version 3.4: The __format__ method of '
                  '"object" itself\n'
                  '   raises a "TypeError" if passed any non-empty string.\n'
                  '\n'
                  '   Changed in version 3.7: "object.__format__(x, \'\')" is '
                  'now\n'
                  '   equivalent to "str(x)" rather than "format(str(x), '
                  '\'\')".\n'
                  '\n'
                  'object.__lt__(self, other)\n'
                  'object.__le__(self, other)\n'
                  'object.__eq__(self, other)\n'
                  'object.__ne__(self, other)\n'
                  'object.__gt__(self, other)\n'
                  'object.__ge__(self, other)\n'
                  '\n'
                  '   These are the so-called “rich comparison” methods. The\n'
                  '   correspondence between operator symbols and method names '
                  'is as\n'
                  '   follows: "x<y" calls "x.__lt__(y)", "x<=y" calls '
                  '"x.__le__(y)",\n'
                  '   "x==y" calls "x.__eq__(y)", "x!=y" calls "x.__ne__(y)", '
                  '"x>y" calls\n'
                  '   "x.__gt__(y)", and "x>=y" calls "x.__ge__(y)".\n'
                  '\n'
                  '   A rich comparison method may return the singleton '
                  '"NotImplemented"\n'
                  '   if it does not implement the operation for a given pair '
                  'of\n'
                  '   arguments. By convention, "False" and "True" are '
                  'returned for a\n'
                  '   successful comparison. However, these methods can return '
                  'any value,\n'
                  '   so if the comparison operator is used in a Boolean '
                  'context (e.g.,\n'
                  '   in the condition of an "if" statement), Python will call '
                  '"bool()"\n'
                  '   on the value to determine if the result is true or '
                  'false.\n'
                  '\n'
                  '   By default, "object" implements "__eq__()" by using '
                  '"is", returning\n'
                  '   "NotImplemented" in the case of a false comparison: '
                  '"True if x is y\n'
                  '   else NotImplemented". For "__ne__()", by default it '
                  'delegates to\n'
                  '   "__eq__()" and inverts the result unless it is '
                  '"NotImplemented".\n'
                  '   There are no other implied relationships among the '
                  'comparison\n'
                  '   operators or default implementations; for example, the '
                  'truth of\n'
                  '   "(x<y or x==y)" does not imply "x<=y". To automatically '
                  'generate\n'
                  '   ordering operations from a single root operation, see\n'
                  '   "functools.total_ordering()".\n'
                  '\n'
                  '   See the paragraph on "__hash__()" for some important '
                  'notes on\n'
                  '   creating *hashable* objects which support custom '
                  'comparison\n'
                  '   operations and are usable as dictionary keys.\n'
                  '\n'
                  '   There are no swapped-argument versions of these methods '
                  '(to be used\n'
                  '   when the left argument does not support the operation '
                  'but the right\n'
                  '   argument does); rather, "__lt__()" and "__gt__()" are '
                  'each other’s\n'
                  '   reflection, "__le__()" and "__ge__()" are each other’s '
                  'reflection,\n'
                  '   and "__eq__()" and "__ne__()" are their own reflection. '
                  'If the\n'
                  '   operands are of different types, and right operand’s '
                  'type is a\n'
                  '   direct or indirect subclass of the left operand’s type, '
                  'the\n'
                  '   reflected method of the right operand has priority, '
                  'otherwise the\n'
                  '   left operand’s method has priority.  Virtual subclassing '
                  'is not\n'
                  '   considered.\n'
                  '\n'
                  'object.__hash__(self)\n'
                  '\n'
                  '   Called by built-in function "hash()" and for operations '
                  'on members\n'
                  '   of hashed collections including "set", "frozenset", and '
                  '"dict".\n'
                  '   The "__hash__()" method should return an integer. The '
                  'only required\n'
                  '   property is that objects which compare equal have the '
                  'same hash\n'
                  '   value; it is advised to mix together the hash values of '
                  'the\n'
                  '   components of the object that also play a part in '
                  'comparison of\n'
                  '   objects by packing them into a tuple and hashing the '
                  'tuple.\n'
                  '   Example:\n'
                  '\n'
                  '      def __hash__(self):\n'
                  '          return hash((self.name, self.nick, self.color))\n'
                  '\n'
                  '   Note:\n'
                  '\n'
                  '     "hash()" truncates the value returned from an object’s '
                  'custom\n'
                  '     "__hash__()" method to the size of a "Py_ssize_t".  '
                  'This is\n'
                  '     typically 8 bytes on 64-bit builds and 4 bytes on '
                  '32-bit builds.\n'
                  '     If an object’s   "__hash__()" must interoperate on '
                  'builds of\n'
                  '     different bit sizes, be sure to check the width on all '
                  'supported\n'
                  '     builds.  An easy way to do this is with "python -c '
                  '"import sys;\n'
                  '     print(sys.hash_info.width)"".\n'
                  '\n'
                  '   If a class does not define an "__eq__()" method it '
                  'should not\n'
                  '   define a "__hash__()" operation either; if it defines '
                  '"__eq__()"\n'
                  '   but not "__hash__()", its instances will not be usable '
                  'as items in\n'
                  '   hashable collections.  If a class defines mutable '
                  'objects and\n'
                  '   implements an "__eq__()" method, it should not '
                  'implement\n'
                  '   "__hash__()", since the implementation of *hashable* '
                  'collections\n'
                  '   requires that a key’s hash value is immutable (if the '
                  'object’s hash\n'
                  '   value changes, it will be in the wrong hash bucket).\n'
                  '\n'
                  '   User-defined classes have "__eq__()" and "__hash__()" '
                  'methods by\n'
                  '   default; with them, all objects compare unequal (except '
                  'with\n'
                  '   themselves) and "x.__hash__()" returns an appropriate '
                  'value such\n'
                  '   that "x == y" implies both that "x is y" and "hash(x) == '
                  'hash(y)".\n'
                  '\n'
                  '   A class that overrides "__eq__()" and does not define '
                  '"__hash__()"\n'
                  '   will have its "__hash__()" implicitly set to "None".  '
                  'When the\n'
                  '   "__hash__()" method of a class is "None", instances of '
                  'the class\n'
                  '   will raise an appropriate "TypeError" when a program '
                  'attempts to\n'
                  '   retrieve their hash value, and will also be correctly '
                  'identified as\n'
                  '   unhashable when checking "isinstance(obj,\n'
                  '   collections.abc.Hashable)".\n'
                  '\n'
                  '   If a class that overrides "__eq__()" needs to retain '
                  'the\n'
                  '   implementation of "__hash__()" from a parent class, the '
                  'interpreter\n'
                  '   must be told this explicitly by setting "__hash__ =\n'
                  '   <ParentClass>.__hash__".\n'
                  '\n'
                  '   If a class that does not override "__eq__()" wishes to '
                  'suppress\n'
                  '   hash support, it should include "__hash__ = None" in the '
                  'class\n'
                  '   definition. A class which defines its own "__hash__()" '
                  'that\n'
                  '   explicitly raises a "TypeError" would be incorrectly '
                  'identified as\n'
                  '   hashable by an "isinstance(obj, '
                  'collections.abc.Hashable)" call.\n'
                  '\n'
                  '   Note:\n'
                  '\n'
                  '     By default, the "__hash__()" values of str and bytes '
                  'objects are\n'
                  '     “salted” with an unpredictable random value.  Although '
                  'they\n'
                  '     remain constant within an individual Python process, '
                  'they are not\n'
                  '     predictable between repeated invocations of '
                  'Python.This is\n'
                  '     intended to provide protection against a '
                  'denial-of-service caused\n'
                  '     by carefully chosen inputs that exploit the worst '
                  'case\n'
                  '     performance of a dict insertion, *O*(*n*^2) '
                  'complexity.  See\n'
                  '     http://ocert.org/advisories/ocert-2011-003.html for\n'
                  '     details.Changing hash values affects the iteration '
                  'order of sets.\n'
                  '     Python has never made guarantees about this ordering '
                  '(and it\n'
                  '     typically varies between 32-bit and 64-bit builds).See '
                  'also\n'
                  '     "PYTHONHASHSEED".\n'
                  '\n'
                  '   Changed in version 3.3: Hash randomization is enabled by '
                  'default.\n'
                  '\n'
                  'object.__bool__(self)\n'
                  '\n'
                  '   Called to implement truth value testing and the built-in '
                  'operation\n'
                  '   "bool()"; should return "False" or "True".  When this '
                  'method is not\n'
                  '   defined, "__len__()" is called, if it is defined, and '
                  'the object is\n'
                  '   considered true if its result is nonzero.  If a class '
                  'defines\n'
                  '   neither "__len__()" nor "__bool__()", all its instances '
                  'are\n'
                  '   considered true.\n',
 'debugger': '"pdb" — The Python Debugger\n'
             '***************************\n'
             '\n'
             '**Source code:** Lib/pdb.py\n'
             '\n'
             '======================================================================\n'
             '\n'
             'The module "pdb" defines an interactive source code debugger '
             'for\n'
             'Python programs.  It supports setting (conditional) breakpoints '
             'and\n'
             'single stepping at the source line level, inspection of stack '
             'frames,\n'
             'source code listing, and evaluation of arbitrary Python code in '
             'the\n'
             'context of any stack frame.  It also supports post-mortem '
             'debugging\n'
             'and can be called under program control.\n'
             '\n'
             'The debugger is extensible – it is actually defined as the '
             'class\n'
             '"Pdb". This is currently undocumented but easily understood by '
             'reading\n'
             'the source.  The extension interface uses the modules "bdb" and '
             '"cmd".\n'
             '\n'
             'See also:\n'
             '\n'
             '  Module "faulthandler"\n'
             '     Used to dump Python tracebacks explicitly, on a fault, '
             'after a\n'
             '     timeout, or on a user signal.\n'
             '\n'
             '  Module "traceback"\n'
             '     Standard interface to extract, format and print stack '
             'traces of\n'
             '     Python programs.\n'
             '\n'
             'The typical usage to break into the debugger is to insert:\n'
             '\n'
             '   import pdb; pdb.set_trace()\n'
             '\n'
             'Or:\n'
             '\n'
             '   breakpoint()\n'
             '\n'
             'at the location you want to break into the debugger, and then '
             'run the\n'
             'program. You can then step through the code following this '
             'statement,\n'
             'and continue running without the debugger using the "continue"\n'
             'command.\n'
             '\n'
             'Changed in version 3.7: The built-in "breakpoint()", when called '
             'with\n'
             'defaults, can be used instead of "import pdb; pdb.set_trace()".\n'
             '\n'
             '   def double(x):\n'
             '      breakpoint()\n'
             '      return x * 2\n'
             '   val = 3\n'
             '   print(f"{val} * 2 is {double(val)}")\n'
             '\n'
             'The debugger’s prompt is "(Pdb)", which is the indicator that '
             'you are\n'
             'in debug mode:\n'
             '\n'
             '   > ...(3)double()\n'
             '   -> return x * 2\n'
             '   (Pdb) p x\n'
             '   3\n'
             '   (Pdb) continue\n'
             '   3 * 2 is 6\n'
             '\n'
             'Changed in version 3.3: Tab-completion via the "readline" module '
             'is\n'
             'available for commands and command arguments, e.g. the current '
             'global\n'
             'and local names are offered as arguments of the "p" command.\n'
             '\n'
             'You can also invoke "pdb" from the command line to debug other\n'
             'scripts.  For example:\n'
             '\n'
             '   python -m pdb myscript.py\n'
             '\n'
             'When invoked as a module, pdb will automatically enter '
             'post-mortem\n'
             'debugging if the program being debugged exits abnormally.  After '
             'post-\n'
             'mortem debugging (or after normal exit of the program), pdb '
             'will\n'
             'restart the program.  Automatic restarting preserves pdb’s state '
             '(such\n'
             'as breakpoints) and in most cases is more useful than quitting '
             'the\n'
             'debugger upon program’s exit.\n'
             '\n'
             'Changed in version 3.2: Added the "-c" option to execute '
             'commands as\n'
             'if given in a ".pdbrc" file; see Debugger Commands.\n'
             '\n'
             'Changed in version 3.7: Added the "-m" option to execute '
             'modules\n'
             'similar to the way "python -m" does. As with a script, the '
             'debugger\n'
             'will pause execution just before the first line of the module.\n'
             '\n'
             'Typical usage to execute a statement under control of the '
             'debugger is:\n'
             '\n'
             '   >>> import pdb\n'
             '   >>> def f(x):\n'
             '   ...     print(1 / x)\n'
             '   >>> pdb.run("f(2)")\n'
             '   > <string>(1)<module>()\n'
             '   (Pdb) continue\n'
             '   0.5\n'
             '   >>>\n'
             '\n'
             'The typical usage to inspect a crashed program is:\n'
             '\n'
             '   >>> import pdb\n'
             '   >>> def f(x):\n'
             '   ...     print(1 / x)\n'
             '   ...\n'
             '   >>> f(0)\n'
             '   Traceback (most recent call last):\n'
             '     File "<stdin>", line 1, in <module>\n'
             '     File "<stdin>", line 2, in f\n'
             '   ZeroDivisionError: division by zero\n'
             '   >>> pdb.pm()\n'
             '   > <stdin>(2)f()\n'
             '   (Pdb) p x\n'
             '   0\n'
             '   (Pdb)\n'
             '\n'
             'The module defines the following functions; each enters the '
             'debugger\n'
             'in a slightly different way:\n'
             '\n'
             'pdb.run(statement, globals=None, locals=None)\n'
             '\n'
             '   Execute the *statement* (given as a string or a code object) '
             'under\n'
             '   debugger control.  The debugger prompt appears before any '
             'code is\n'
             '   executed; you can set breakpoints and type "continue", or you '
             'can\n'
             '   step through the statement using "step" or "next" (all these\n'
             '   commands are explained below).  The optional *globals* and '
             '*locals*\n'
             '   arguments specify the environment in which the code is '
             'executed; by\n'
             '   default the dictionary of the module "__main__" is used.  '
             '(See the\n'
             '   explanation of the built-in "exec()" or "eval()" functions.)\n'
             '\n'
             'pdb.runeval(expression, globals=None, locals=None)\n'
             '\n'
             '   Evaluate the *expression* (given as a string or a code '
             'object)\n'
             '   under debugger control.  When "runeval()" returns, it returns '
             'the\n'
             '   value of the *expression*.  Otherwise this function is '
             'similar to\n'
             '   "run()".\n'
             '\n'
             'pdb.runcall(function, *args, **kwds)\n'
             '\n'
             '   Call the *function* (a function or method object, not a '
             'string)\n'
             '   with the given arguments.  When "runcall()" returns, it '
             'returns\n'
             '   whatever the function call returned.  The debugger prompt '
             'appears\n'
             '   as soon as the function is entered.\n'
             '\n'
             'pdb.set_trace(*, header=None)\n'
             '\n'
             '   Enter the debugger at the calling stack frame.  This is '
             'useful to\n'
             '   hard-code a breakpoint at a given point in a program, even if '
             'the\n'
             '   code is not otherwise being debugged (e.g. when an assertion\n'
             '   fails).  If given, *header* is printed to the console just '
             'before\n'
             '   debugging begins.\n'
             '\n'
             '   Changed in version 3.7: The keyword-only argument *header*.\n'
             '\n'
             'pdb.post_mortem(traceback=None)\n'
             '\n'
             '   Enter post-mortem debugging of the given *traceback* object.  '
             'If no\n'
             '   *traceback* is given, it uses the one of the exception that '
             'is\n'
             '   currently being handled (an exception must be being handled '
             'if the\n'
             '   default is to be used).\n'
             '\n'
             'pdb.pm()\n'
             '\n'
             '   Enter post-mortem debugging of the traceback found in\n'
             '   "sys.last_traceback".\n'
             '\n'
             'The "run*" functions and "set_trace()" are aliases for '
             'instantiating\n'
             'the "Pdb" class and calling the method of the same name.  If you '
             'want\n'
             'to access further features, you have to do this yourself:\n'
             '\n'
             "class pdb.Pdb(completekey='tab', stdin=None, stdout=None, "
             'skip=None, nosigint=False, readrc=True)\n'
             '\n'
             '   "Pdb" is the debugger class.\n'
             '\n'
             '   The *completekey*, *stdin* and *stdout* arguments are passed '
             'to the\n'
             '   underlying "cmd.Cmd" class; see the description there.\n'
             '\n'
             '   The *skip* argument, if given, must be an iterable of '
             'glob-style\n'
             '   module name patterns.  The debugger will not step into frames '
             'that\n'
             '   originate in a module that matches one of these patterns. '
             '[1]\n'
             '\n'
             '   By default, Pdb sets a handler for the SIGINT signal (which '
             'is sent\n'
             '   when the user presses "Ctrl-C" on the console) when you give '
             'a\n'
             '   "continue" command. This allows you to break into the '
             'debugger\n'
             '   again by pressing "Ctrl-C".  If you want Pdb not to touch '
             'the\n'
             '   SIGINT handler, set *nosigint* to true.\n'
             '\n'
             '   The *readrc* argument defaults to true and controls whether '
             'Pdb\n'
             '   will load .pdbrc files from the filesystem.\n'
             '\n'
             '   Example call to enable tracing with *skip*:\n'
             '\n'
             "      import pdb; pdb.Pdb(skip=['django.*']).set_trace()\n"
             '\n'
             '   Raises an auditing event "pdb.Pdb" with no arguments.\n'
             '\n'
             '   Changed in version 3.1: Added the *skip* parameter.\n'
             '\n'
             '   Changed in version 3.2: Added the *nosigint* parameter. '
             'Previously,\n'
             '   a SIGINT handler was never set by Pdb.\n'
             '\n'
             '   Changed in version 3.6: The *readrc* argument.\n'
             '\n'
             '   run(statement, globals=None, locals=None)\n'
             '   runeval(expression, globals=None, locals=None)\n'
             '   runcall(function, *args, **kwds)\n'
             '   set_trace()\n'
             '\n'
             '      See the documentation for the functions explained above.\n'
             '\n'
             '\n'
             'Debugger Commands\n'
             '=================\n'
             '\n'
             'The commands recognized by the debugger are listed below.  Most\n'
             'commands can be abbreviated to one or two letters as indicated; '
             'e.g.\n'
             '"h(elp)" means that either "h" or "help" can be used to enter '
             'the help\n'
             'command (but not "he" or "hel", nor "H" or "Help" or "HELP").\n'
             'Arguments to commands must be separated by whitespace (spaces '
             'or\n'
             'tabs).  Optional arguments are enclosed in square brackets '
             '("[]") in\n'
             'the command syntax; the square brackets must not be typed.\n'
             'Alternatives in the command syntax are separated by a vertical '
             'bar\n'
             '("|").\n'
             '\n'
             'Entering a blank line repeats the last command entered.  '
             'Exception: if\n'
             'the last command was a "list" command, the next 11 lines are '
             'listed.\n'
             '\n'
             'Commands that the debugger doesn’t recognize are assumed to be '
             'Python\n'
             'statements and are executed in the context of the program being\n'
             'debugged.  Python statements can also be prefixed with an '
             'exclamation\n'
             'point ("!").  This is a powerful way to inspect the program '
             'being\n'
             'debugged; it is even possible to change a variable or call a '
             'function.\n'
             'When an exception occurs in such a statement, the exception name '
             'is\n'
             'printed but the debugger’s state is not changed.\n'
             '\n'
             'The debugger supports aliases.  Aliases can have parameters '
             'which\n'
             'allows one a certain level of adaptability to the context under\n'
             'examination.\n'
             '\n'
             'Multiple commands may be entered on a single line, separated by '
             '";;".\n'
             '(A single ";" is not used as it is the separator for multiple '
             'commands\n'
             'in a line that is passed to the Python parser.)  No intelligence '
             'is\n'
             'applied to separating the commands; the input is split at the '
             'first\n'
             '";;" pair, even if it is in the middle of a quoted string. A\n'
             'workaround for strings with double semicolons is to use '
             'implicit\n'
             'string concatenation "\';\'\';\'" or "";"";"".\n'
             '\n'
             'If a file ".pdbrc" exists in the user’s home directory or in '
             'the\n'
             'current directory, it is read with "\'utf-8\'" encoding and '
             'executed as\n'
             'if it had been typed at the debugger prompt.  This is '
             'particularly\n'
             'useful for aliases.  If both files exist, the one in the home\n'
             'directory is read first and aliases defined there can be '
             'overridden by\n'
             'the local file.\n'
             '\n'
             'Changed in version 3.11: ".pdbrc" is now read with "\'utf-8\'" '
             'encoding.\n'
             'Previously, it was read with the system locale encoding.\n'
             '\n'
             'Changed in version 3.2: ".pdbrc" can now contain commands that\n'
             'continue debugging, such as "continue" or "next".  Previously, '
             'these\n'
             'commands had no effect.\n'
             '\n'
             'h(elp) [command]\n'
             '\n'
             '   Without argument, print the list of available commands.  With '
             'a\n'
             '   *command* as argument, print help about that command.  "help '
             'pdb"\n'
             '   displays the full documentation (the docstring of the "pdb"\n'
             '   module).  Since the *command* argument must be an identifier, '
             '"help\n'
             '   exec" must be entered to get help on the "!" command.\n'
             '\n'
             'w(here)\n'
             '\n'
             '   Print a stack trace, with the most recent frame at the '
             'bottom.  An\n'
             '   arrow (">") indicates the current frame, which determines '
             'the\n'
             '   context of most commands.\n'
             '\n'
             'd(own) [count]\n'
             '\n'
             '   Move the current frame *count* (default one) levels down in '
             'the\n'
             '   stack trace (to a newer frame).\n'
             '\n'
             'u(p) [count]\n'
             '\n'
             '   Move the current frame *count* (default one) levels up in the '
             'stack\n'
             '   trace (to an older frame).\n'
             '\n'
             'b(reak) [([filename:]lineno | function) [, condition]]\n'
             '\n'
             '   With a *lineno* argument, set a break there in the current '
             'file.\n'
             '   With a *function* argument, set a break at the first '
             'executable\n'
             '   statement within that function.  The line number may be '
             'prefixed\n'
             '   with a filename and a colon, to specify a breakpoint in '
             'another\n'
             '   file (probably one that hasn’t been loaded yet).  The file '
             'is\n'
             '   searched on "sys.path".  Note that each breakpoint is '
             'assigned a\n'
             '   number to which all the other breakpoint commands refer.\n'
             '\n'
             '   If a second argument is present, it is an expression which '
             'must\n'
             '   evaluate to true before the breakpoint is honored.\n'
             '\n'
             '   Without argument, list all breaks, including for each '
             'breakpoint,\n'
             '   the number of times that breakpoint has been hit, the '
             'current\n'
             '   ignore count, and the associated condition if any.\n'
             '\n'
             'tbreak [([filename:]lineno | function) [, condition]]\n'
             '\n'
             '   Temporary breakpoint, which is removed automatically when it '
             'is\n'
             '   first hit. The arguments are the same as for "break".\n'
             '\n'
             'cl(ear) [filename:lineno | bpnumber ...]\n'
             '\n'
             '   With a *filename:lineno* argument, clear all the breakpoints '
             'at\n'
             '   this line. With a space separated list of breakpoint numbers, '
             'clear\n'
             '   those breakpoints. Without argument, clear all breaks (but '
             'first\n'
             '   ask confirmation).\n'
             '\n'
             'disable [bpnumber ...]\n'
             '\n'
             '   Disable the breakpoints given as a space separated list of\n'
             '   breakpoint numbers.  Disabling a breakpoint means it cannot '
             'cause\n'
             '   the program to stop execution, but unlike clearing a '
             'breakpoint, it\n'
             '   remains in the list of breakpoints and can be (re-)enabled.\n'
             '\n'
             'enable [bpnumber ...]\n'
             '\n'
             '   Enable the breakpoints specified.\n'
             '\n'
             'ignore bpnumber [count]\n'
             '\n'
             '   Set the ignore count for the given breakpoint number.  If '
             '*count*\n'
             '   is omitted, the ignore count is set to 0.  A breakpoint '
             'becomes\n'
             '   active when the ignore count is zero.  When non-zero, the '
             '*count*\n'
             '   is decremented each time the breakpoint is reached and the\n'
             '   breakpoint is not disabled and any associated condition '
             'evaluates\n'
             '   to true.\n'
             '\n'
             'condition bpnumber [condition]\n'
             '\n'
             '   Set a new *condition* for the breakpoint, an expression which '
             'must\n'
             '   evaluate to true before the breakpoint is honored.  If '
             '*condition*\n'
             '   is absent, any existing condition is removed; i.e., the '
             'breakpoint\n'
             '   is made unconditional.\n'
             '\n'
             'commands [bpnumber]\n'
             '\n'
             '   Specify a list of commands for breakpoint number *bpnumber*.  '
             'The\n'
             '   commands themselves appear on the following lines.  Type a '
             'line\n'
             '   containing just "end" to terminate the commands. An example:\n'
             '\n'
             '      (Pdb) commands 1\n'
             '      (com) p some_variable\n'
             '      (com) end\n'
             '      (Pdb)\n'
             '\n'
             '   To remove all commands from a breakpoint, type "commands" '
             'and\n'
             '   follow it immediately with "end"; that is, give no commands.\n'
             '\n'
             '   With no *bpnumber* argument, "commands" refers to the last\n'
             '   breakpoint set.\n'
             '\n'
             '   You can use breakpoint commands to start your program up '
             'again.\n'
             '   Simply use the "continue" command, or "step", or any other '
             'command\n'
             '   that resumes execution.\n'
             '\n'
             '   Specifying any command resuming execution (currently '
             '"continue",\n'
             '   "step", "next", "return", "jump", "quit" and their '
             'abbreviations)\n'
             '   terminates the command list (as if that command was '
             'immediately\n'
             '   followed by end). This is because any time you resume '
             'execution\n'
             '   (even with a simple next or step), you may encounter another\n'
             '   breakpoint—which could have its own command list, leading to\n'
             '   ambiguities about which list to execute.\n'
             '\n'
             '   If you use the "silent" command in the command list, the '
             'usual\n'
             '   message about stopping at a breakpoint is not printed.  This '
             'may be\n'
             '   desirable for breakpoints that are to print a specific '
             'message and\n'
             '   then continue.  If none of the other commands print anything, '
             'you\n'
             '   see no sign that the breakpoint was reached.\n'
             '\n'
             's(tep)\n'
             '\n'
             '   Execute the current line, stop at the first possible '
             'occasion\n'
             '   (either in a function that is called or on the next line in '
             'the\n'
             '   current function).\n'
             '\n'
             'n(ext)\n'
             '\n'
             '   Continue execution until the next line in the current '
             'function is\n'
             '   reached or it returns.  (The difference between "next" and '
             '"step"\n'
             '   is that "step" stops inside a called function, while "next"\n'
             '   executes called functions at (nearly) full speed, only '
             'stopping at\n'
             '   the next line in the current function.)\n'
             '\n'
             'unt(il) [lineno]\n'
             '\n'
             '   Without argument, continue execution until the line with a '
             'number\n'
             '   greater than the current one is reached.\n'
             '\n'
             '   With *lineno*, continue execution until a line with a number\n'
             '   greater or equal to *lineno* is reached.  In both cases, also '
             'stop\n'
             '   when the current frame returns.\n'
             '\n'
             '   Changed in version 3.2: Allow giving an explicit line '
             'number.\n'
             '\n'
             'r(eturn)\n'
             '\n'
             '   Continue execution until the current function returns.\n'
             '\n'
             'c(ont(inue))\n'
             '\n'
             '   Continue execution, only stop when a breakpoint is '
             'encountered.\n'
             '\n'
             'j(ump) lineno\n'
             '\n'
             '   Set the next line that will be executed.  Only available in '
             'the\n'
             '   bottom-most frame.  This lets you jump back and execute code '
             'again,\n'
             '   or jump forward to skip code that you don’t want to run.\n'
             '\n'
             '   It should be noted that not all jumps are allowed – for '
             'instance it\n'
             '   is not possible to jump into the middle of a "for" loop or '
             'out of a\n'
             '   "finally" clause.\n'
             '\n'
             'l(ist) [first[, last]]\n'
             '\n'
             '   List source code for the current file.  Without arguments, '
             'list 11\n'
             '   lines around the current line or continue the previous '
             'listing.\n'
             '   With "." as argument, list 11 lines around the current line.  '
             'With\n'
             '   one argument, list 11 lines around at that line.  With two\n'
             '   arguments, list the given range; if the second argument is '
             'less\n'
             '   than the first, it is interpreted as a count.\n'
             '\n'
             '   The current line in the current frame is indicated by "->".  '
             'If an\n'
             '   exception is being debugged, the line where the exception '
             'was\n'
             '   originally raised or propagated is indicated by ">>", if it '
             'differs\n'
             '   from the current line.\n'
             '\n'
             '   Changed in version 3.2: Added the ">>" marker.\n'
             '\n'
             'll | longlist\n'
             '\n'
             '   List all source code for the current function or frame.\n'
             '   Interesting lines are marked as for "list".\n'
             '\n'
             '   New in version 3.2.\n'
             '\n'
             'a(rgs)\n'
             '\n'
             '   Print the arguments of the current function and their '
             'current\n'
             '   values.\n'
             '\n'
             'p expression\n'
             '\n'
             '   Evaluate *expression* in the current context and print its '
             'value.\n'
             '\n'
             '   Note:\n'
             '\n'
             '     "print()" can also be used, but is not a debugger command — '
             'this\n'
             '     executes the Python "print()" function.\n'
             '\n'
             'pp expression\n'
             '\n'
             '   Like the "p" command, except the value of *expression* is '
             'pretty-\n'
             '   printed using the "pprint" module.\n'
             '\n'
             'whatis expression\n'
             '\n'
             '   Print the type of *expression*.\n'
             '\n'
             'source expression\n'
             '\n'
             '   Try to get source code of *expression* and display it.\n'
             '\n'
             '   New in version 3.2.\n'
             '\n'
             'display [expression]\n'
             '\n'
             '   Display the value of *expression* if it changed, each time\n'
             '   execution stops in the current frame.\n'
             '\n'
             '   Without *expression*, list all display expressions for the '
             'current\n'
             '   frame.\n'
             '\n'
             '   Note:\n'
             '\n'
             '     Display evaluates *expression* and compares to the result '
             'of the\n'
             '     previous evaluation of *expression*, so when the result is\n'
             '     mutable, display may not be able to pick up the changes.\n'
             '\n'
             '   Example:\n'
             '\n'
             '      lst = []\n'
             '      breakpoint()\n'
             '      pass\n'
             '      lst.append(1)\n'
             '      print(lst)\n'
             '\n'
             '   Display won’t realize "lst" has been changed because the '
             'result of\n'
             '   evaluation is modified in place by "lst.append(1)" before '
             'being\n'
             '   compared:\n'
             '\n'
             '      > example.py(3)<module>()\n'
             '      -> pass\n'
             '      (Pdb) display lst\n'
             '      display lst: []\n'
             '      (Pdb) n\n'
             '      > example.py(4)<module>()\n'
             '      -> lst.append(1)\n'
             '      (Pdb) n\n'
             '      > example.py(5)<module>()\n'
             '      -> print(lst)\n'
             '      (Pdb)\n'
             '\n'
             '   You can do some tricks with copy mechanism to make it work:\n'
             '\n'
             '      > example.py(3)<module>()\n'
             '      -> pass\n'
             '      (Pdb) display lst[:]\n'
             '      display lst[:]: []\n'
             '      (Pdb) n\n'
             '      > example.py(4)<module>()\n'
             '      -> lst.append(1)\n'
             '      (Pdb) n\n'
             '      > example.py(5)<module>()\n'
             '      -> print(lst)\n'
             '      display lst[:]: [1]  [old: []]\n'
             '      (Pdb)\n'
             '\n'
             '   New in version 3.2.\n'
             '\n'
             'undisplay [expression]\n'
             '\n'
             '   Do not display *expression* anymore in the current frame.  '
             'Without\n'
             '   *expression*, clear all display expressions for the current '
             'frame.\n'
             '\n'
             '   New in version 3.2.\n'
             '\n'
             'interact\n'
             '\n'
             '   Start an interactive interpreter (using the "code" module) '
             'whose\n'
             '   global namespace contains all the (global and local) names '
             'found in\n'
             '   the current scope.\n'
             '\n'
             '   New in version 3.2.\n'
             '\n'
             'alias [name [command]]\n'
             '\n'
             '   Create an alias called *name* that executes *command*.  The\n'
             '   *command* must *not* be enclosed in quotes.  Replaceable '
             'parameters\n'
             '   can be indicated by "%1", "%2", and so on, while "%*" is '
             'replaced\n'
             '   by all the parameters. If *command* is omitted, the current '
             'alias\n'
             '   for *name* is shown. If no arguments are given, all aliases '
             'are\n'
             '   listed.\n'
             '\n'
             '   Aliases may be nested and can contain anything that can be '
             'legally\n'
             '   typed at the pdb prompt.  Note that internal pdb commands '
             '*can* be\n'
             '   overridden by aliases.  Such a command is then hidden until '
             'the\n'
             '   alias is removed.  Aliasing is recursively applied to the '
             'first\n'
             '   word of the command line; all other words in the line are '
             'left\n'
             '   alone.\n'
             '\n'
             '   As an example, here are two useful aliases (especially when '
             'placed\n'
             '   in the ".pdbrc" file):\n'
             '\n'
             '      # Print instance variables (usage "pi classInst")\n'
             '      alias pi for k in %1.__dict__.keys(): print(f"%1.{k} = '
             '{%1.__dict__[k]}")\n'
             '      # Print instance variables in self\n'
             '      alias ps pi self\n'
             '\n'
             'unalias name\n'
             '\n'
             '   Delete the specified alias *name*.\n'
             '\n'
             '! statement\n'
             '\n'
             '   Execute the (one-line) *statement* in the context of the '
             'current\n'
             '   stack frame. The exclamation point can be omitted unless the '
             'first\n'
             '   word of the statement resembles a debugger command.  To set '
             'a\n'
             '   global variable, you can prefix the assignment command with '
             'a\n'
             '   "global" statement on the same line, e.g.:\n'
             '\n'
             "      (Pdb) global list_options; list_options = ['-l']\n"
             '      (Pdb)\n'
             '\n'
             'run [args ...]\n'
             'restart [args ...]\n'
             '\n'
             '   Restart the debugged Python program.  If *args* is supplied, '
             'it is\n'
             '   split with "shlex" and the result is used as the new '
             '"sys.argv".\n'
             '   History, breakpoints, actions and debugger options are '
             'preserved.\n'
             '   "restart" is an alias for "run".\n'
             '\n'
             'q(uit)\n'
             '\n'
             '   Quit from the debugger.  The program being executed is '
             'aborted.\n'
             '\n'
             'debug code\n'
             '\n'
             '   Enter a recursive debugger that steps through *code* (which '
             'is an\n'
             '   arbitrary expression or statement to be executed in the '
             'current\n'
             '   environment).\n'
             '\n'
             'retval\n'
             '\n'
             '   Print the return value for the last return of the current '
             'function.\n'
             '\n'
             '-[ Footnotes ]-\n'
             '\n'
             '[1] Whether a frame is considered to originate in a certain '
             'module is\n'
             '    determined by the "__name__" in the frame globals.\n',
 'del': 'The "del" statement\n'
        '*******************\n'
        '\n'
        '   del_stmt ::= "del" target_list\n'
        '\n'
        'Deletion is recursively defined very similar to the way assignment '
        'is\n'
        'defined. Rather than spelling it out in full details, here are some\n'
        'hints.\n'
        '\n'
        'Deletion of a target list recursively deletes each target, from left\n'
        'to right.\n'
        '\n'
        'Deletion of a name removes the binding of that name from the local '
        'or\n'
        'global namespace, depending on whether the name occurs in a "global"\n'
        'statement in the same code block.  If the name is unbound, a\n'
        '"NameError" exception will be raised.\n'
        '\n'
        'Deletion of attribute references, subscriptions and slicings is '
        'passed\n'
        'to the primary object involved; deletion of a slicing is in general\n'
        'equivalent to assignment of an empty slice of the right type (but '
        'even\n'
        'this is determined by the sliced object).\n'
        '\n'
        'Changed in version 3.2: Previously it was illegal to delete a name\n'
        'from the local namespace if it occurs as a free variable in a nested\n'
        'block.\n',
 'dict': 'Dictionary displays\n'
         '*******************\n'
         '\n'
         'A dictionary display is a possibly empty series of dict items\n'
         '(key/value pairs) enclosed in curly braces:\n'
         '\n'
         '   dict_display       ::= "{" [dict_item_list | dict_comprehension] '
         '"}"\n'
         '   dict_item_list     ::= dict_item ("," dict_item)* [","]\n'
         '   dict_item          ::= expression ":" expression | "**" or_expr\n'
         '   dict_comprehension ::= expression ":" expression comp_for\n'
         '\n'
         'A dictionary display yields a new dictionary object.\n'
         '\n'
         'If a comma-separated sequence of dict items is given, they are\n'
         'evaluated from left to right to define the entries of the '
         'dictionary:\n'
         'each key object is used as a key into the dictionary to store the\n'
         'corresponding value.  This means that you can specify the same key\n'
         'multiple times in the dict item list, and the final dictionary’s '
         'value\n'
         'for that key will be the last one given.\n'
         '\n'
         'A double asterisk "**" denotes *dictionary unpacking*. Its operand\n'
         'must be a *mapping*.  Each mapping item is added to the new\n'
         'dictionary.  Later values replace values already set by earlier '
         'dict\n'
         'items and earlier dictionary unpackings.\n'
         '\n'
         'New in version 3.5: Unpacking into dictionary displays, originally\n'
         'proposed by **PEP 448**.\n'
         '\n'
         'A dict comprehension, in contrast to list and set comprehensions,\n'
         'needs two expressions separated with a colon followed by the usual\n'
         '“for” and “if” clauses. When the comprehension is run, the '
         'resulting\n'
         'key and value elements are inserted in the new dictionary in the '
         'order\n'
         'they are produced.\n'
         '\n'
         'Restrictions on the types of the key values are listed earlier in\n'
         'section The standard type hierarchy.  (To summarize, the key type\n'
         'should be *hashable*, which excludes all mutable objects.)  Clashes\n'
         'between duplicate keys are not detected; the last value (textually\n'
         'rightmost in the display) stored for a given key value prevails.\n'
         '\n'
         'Changed in version 3.8: Prior to Python 3.8, in dict '
         'comprehensions,\n'
         'the evaluation order of key and value was not well-defined.  In\n'
         'CPython, the value was evaluated before the key.  Starting with '
         '3.8,\n'
         'the key is evaluated before the value, as proposed by **PEP 572**.\n',
 'dynamic-features': 'Interaction with dynamic features\n'
                     '*********************************\n'
                     '\n'
                     'Name resolution of free variables occurs at runtime, not '
                     'at compile\n'
                     'time. This means that the following code will print 42:\n'
                     '\n'
                     '   i = 10\n'
                     '   def f():\n'
                     '       print(i)\n'
                     '   i = 42\n'
                     '   f()\n'
                     '\n'
                     'The "eval()" and "exec()" functions do not have access '
                     'to the full\n'
                     'environment for resolving names.  Names may be resolved '
                     'in the local\n'
                     'and global namespaces of the caller.  Free variables are '
                     'not resolved\n'
                     'in the nearest enclosing namespace, but in the global '
                     'namespace.  [1]\n'
                     'The "exec()" and "eval()" functions have optional '
                     'arguments to\n'
                     'override the global and local namespace.  If only one '
                     'namespace is\n'
                     'specified, it is used for both.\n',
 'else': 'The "if" statement\n'
         '******************\n'
         '\n'
         'The "if" statement is used for conditional execution:\n'
         '\n'
         '   if_stmt ::= "if" assignment_expression ":" suite\n'
         '               ("elif" assignment_expression ":" suite)*\n'
         '               ["else" ":" suite]\n'
         '\n'
         'It selects exactly one of the suites by evaluating the expressions '
         'one\n'
         'by one until one is found to be true (see section Boolean '
         'operations\n'
         'for the definition of true and false); then that suite is executed\n'
         '(and no other part of the "if" statement is executed or evaluated).\n'
         'If all expressions are false, the suite of the "else" clause, if\n'
         'present, is executed.\n',
 'exceptions': 'Exceptions\n'
               '**********\n'
               '\n'
               'Exceptions are a means of breaking out of the normal flow of '
               'control\n'
               'of a code block in order to handle errors or other '
               'exceptional\n'
               'conditions.  An exception is *raised* at the point where the '
               'error is\n'
               'detected; it may be *handled* by the surrounding code block or '
               'by any\n'
               'code block that directly or indirectly invoked the code block '
               'where\n'
               'the error occurred.\n'
               '\n'
               'The Python interpreter raises an exception when it detects a '
               'run-time\n'
               'error (such as division by zero).  A Python program can also\n'
               'explicitly raise an exception with the "raise" statement. '
               'Exception\n'
               'handlers are specified with the "try" … "except" statement.  '
               'The\n'
               '"finally" clause of such a statement can be used to specify '
               'cleanup\n'
               'code which does not handle the exception, but is executed '
               'whether an\n'
               'exception occurred or not in the preceding code.\n'
               '\n'
               'Python uses the “termination” model of error handling: an '
               'exception\n'
               'handler can find out what happened and continue execution at '
               'an outer\n'
               'level, but it cannot repair the cause of the error and retry '
               'the\n'
               'failing operation (except by re-entering the offending piece '
               'of code\n'
               'from the top).\n'
               '\n'
               'When an exception is not handled at all, the interpreter '
               'terminates\n'
               'execution of the program, or returns to its interactive main '
               'loop.  In\n'
               'either case, it prints a stack traceback, except when the '
               'exception is\n'
               '"SystemExit".\n'
               '\n'
               'Exceptions are identified by class instances.  The "except" '
               'clause is\n'
               'selected depending on the class of the instance: it must '
               'reference the\n'
               'class of the instance or a *non-virtual base class* thereof. '
               'The\n'
               'instance can be received by the handler and can carry '
               'additional\n'
               'information about the exceptional condition.\n'
               '\n'
               'Note:\n'
               '\n'
               '  Exception messages are not part of the Python API.  Their '
               'contents\n'
               '  may change from one version of Python to the next without '
               'warning\n'
               '  and should not be relied on by code which will run under '
               'multiple\n'
               '  versions of the interpreter.\n'
               '\n'
               'See also the description of the "try" statement in section The '
               'try\n'
               'statement and "raise" statement in section The raise '
               'statement.\n'
               '\n'
               '-[ Footnotes ]-\n'
               '\n'
               '[1] This limitation occurs because the code that is executed '
               'by these\n'
               '    operations is not available at the time the module is '
               'compiled.\n',
 'execmodel': 'Execution model\n'
              '***************\n'
              '\n'
              '\n'
              'Structure of a program\n'
              '======================\n'
              '\n'
              'A Python program is constructed from code blocks. A *block* is '
              'a piece\n'
              'of Python program text that is executed as a unit. The '
              'following are\n'
              'blocks: a module, a function body, and a class definition. '
              'Each\n'
              'command typed interactively is a block.  A script file (a file '
              'given\n'
              'as standard input to the interpreter or specified as a command '
              'line\n'
              'argument to the interpreter) is a code block.  A script command '
              '(a\n'
              'command specified on the interpreter command line with the '
              '"-c"\n'
              'option) is a code block. A module run as a top level script (as '
              'module\n'
              '"__main__") from the command line using a "-m" argument is also '
              'a code\n'
              'block. The string argument passed to the built-in functions '
              '"eval()"\n'
              'and "exec()" is a code block.\n'
              '\n'
              'A code block is executed in an *execution frame*.  A frame '
              'contains\n'
              'some administrative information (used for debugging) and '
              'determines\n'
              'where and how execution continues after the code block’s '
              'execution has\n'
              'completed.\n'
              '\n'
              '\n'
              'Naming and binding\n'
              '==================\n'
              '\n'
              '\n'
              'Binding of names\n'
              '----------------\n'
              '\n'
              '*Names* refer to objects.  Names are introduced by name '
              'binding\n'
              'operations.\n'
              '\n'
              'The following constructs bind names:\n'
              '\n'
              '* formal parameters to functions,\n'
              '\n'
              '* class definitions,\n'
              '\n'
              '* function definitions,\n'
              '\n'
              '* assignment expressions,\n'
              '\n'
              '* targets that are identifiers if occurring in an assignment:\n'
              '\n'
              '  * "for" loop header,\n'
              '\n'
              '  * after "as" in a "with" statement, "except" clause, '
              '"except*"\n'
              '    clause, or in the as-pattern in structural pattern '
              'matching,\n'
              '\n'
              '  * in a capture pattern in structural pattern matching\n'
              '\n'
              '* "import" statements.\n'
              '\n'
              'The "import" statement of the form "from ... import *" binds '
              'all names\n'
              'defined in the imported module, except those beginning with an\n'
              'underscore. This form may only be used at the module level.\n'
              '\n'
              'A target occurring in a "del" statement is also considered '
              'bound for\n'
              'this purpose (though the actual semantics are to unbind the '
              'name).\n'
              '\n'
              'Each assignment or import statement occurs within a block '
              'defined by a\n'
              'class or function definition or at the module level (the '
              'top-level\n'
              'code block).\n'
              '\n'
              'If a name is bound in a block, it is a local variable of that '
              'block,\n'
              'unless declared as "nonlocal" or "global".  If a name is bound '
              'at the\n'
              'module level, it is a global variable.  (The variables of the '
              'module\n'
              'code block are local and global.)  If a variable is used in a '
              'code\n'
              'block but not defined there, it is a *free variable*.\n'
              '\n'
              'Each occurrence of a name in the program text refers to the '
              '*binding*\n'
              'of that name established by the following name resolution '
              'rules.\n'
              '\n'
              '\n'
              'Resolution of names\n'
              '-------------------\n'
              '\n'
              'A *scope* defines the visibility of a name within a block.  If '
              'a local\n'
              'variable is defined in a block, its scope includes that block.  '
              'If the\n'
              'definition occurs in a function block, the scope extends to any '
              'blocks\n'
              'contained within the defining one, unless a contained block '
              'introduces\n'
              'a different binding for the name.\n'
              '\n'
              'When a name is used in a code block, it is resolved using the '
              'nearest\n'
              'enclosing scope.  The set of all such scopes visible to a code '
              'block\n'
              'is called the block’s *environment*.\n'
              '\n'
              'When a name is not found at all, a "NameError" exception is '
              'raised. If\n'
              'the current scope is a function scope, and the name refers to a '
              'local\n'
              'variable that has not yet been bound to a value at the point '
              'where the\n'
              'name is used, an "UnboundLocalError" exception is raised.\n'
              '"UnboundLocalError" is a subclass of "NameError".\n'
              '\n'
              'If a name binding operation occurs anywhere within a code '
              'block, all\n'
              'uses of the name within the block are treated as references to '
              'the\n'
              'current block.  This can lead to errors when a name is used '
              'within a\n'
              'block before it is bound.  This rule is subtle.  Python lacks\n'
              'declarations and allows name binding operations to occur '
              'anywhere\n'
              'within a code block.  The local variables of a code block can '
              'be\n'
              'determined by scanning the entire text of the block for name '
              'binding\n'
              'operations. See the FAQ entry on UnboundLocalError for '
              'examples.\n'
              '\n'
              'If the "global" statement occurs within a block, all uses of '
              'the names\n'
              'specified in the statement refer to the bindings of those names '
              'in the\n'
              'top-level namespace.  Names are resolved in the top-level '
              'namespace by\n'
              'searching the global namespace, i.e. the namespace of the '
              'module\n'
              'containing the code block, and the builtins namespace, the '
              'namespace\n'
              'of the module "builtins".  The global namespace is searched '
              'first.  If\n'
              'the names are not found there, the builtins namespace is '
              'searched.\n'
              'The "global" statement must precede all uses of the listed '
              'names.\n'
              '\n'
              'The "global" statement has the same scope as a name binding '
              'operation\n'
              'in the same block.  If the nearest enclosing scope for a free '
              'variable\n'
              'contains a global statement, the free variable is treated as a '
              'global.\n'
              '\n'
              'The "nonlocal" statement causes corresponding names to refer '
              'to\n'
              'previously bound variables in the nearest enclosing function '
              'scope.\n'
              '"SyntaxError" is raised at compile time if the given name does '
              'not\n'
              'exist in any enclosing function scope.\n'
              '\n'
              'The namespace for a module is automatically created the first '
              'time a\n'
              'module is imported.  The main module for a script is always '
              'called\n'
              '"__main__".\n'
              '\n'
              'Class definition blocks and arguments to "exec()" and "eval()" '
              'are\n'
              'special in the context of name resolution. A class definition '
              'is an\n'
              'executable statement that may use and define names. These '
              'references\n'
              'follow the normal rules for name resolution with an exception '
              'that\n'
              'unbound local variables are looked up in the global namespace. '
              'The\n'
              'namespace of the class definition becomes the attribute '
              'dictionary of\n'
              'the class. The scope of names defined in a class block is '
              'limited to\n'
              'the class block; it does not extend to the code blocks of '
              'methods –\n'
              'this includes comprehensions and generator expressions since '
              'they are\n'
              'implemented using a function scope.  This means that the '
              'following\n'
              'will fail:\n'
              '\n'
              '   class A:\n'
              '       a = 42\n'
              '       b = list(a + i for i in range(10))\n'
              '\n'
              '\n'
              'Builtins and restricted execution\n'
              '---------------------------------\n'
              '\n'
              '**CPython implementation detail:** Users should not touch\n'
              '"__builtins__"; it is strictly an implementation detail.  '
              'Users\n'
              'wanting to override values in the builtins namespace should '
              '"import"\n'
              'the "builtins" module and modify its attributes appropriately.\n'
              '\n'
              'The builtins namespace associated with the execution of a code '
              'block\n'
              'is actually found by looking up the name "__builtins__" in its '
              'global\n'
              'namespace; this should be a dictionary or a module (in the '
              'latter case\n'
              'the module’s dictionary is used).  By default, when in the '
              '"__main__"\n'
              'module, "__builtins__" is the built-in module "builtins"; when '
              'in any\n'
              'other module, "__builtins__" is an alias for the dictionary of '
              'the\n'
              '"builtins" module itself.\n'
              '\n'
              '\n'
              'Interaction with dynamic features\n'
              '---------------------------------\n'
              '\n'
              'Name resolution of free variables occurs at runtime, not at '
              'compile\n'
              'time. This means that the following code will print 42:\n'
              '\n'
              '   i = 10\n'
              '   def f():\n'
              '       print(i)\n'
              '   i = 42\n'
              '   f()\n'
              '\n'
              'The "eval()" and "exec()" functions do not have access to the '
              'full\n'
              'environment for resolving names.  Names may be resolved in the '
              'local\n'
              'and global namespaces of the caller.  Free variables are not '
              'resolved\n'
              'in the nearest enclosing namespace, but in the global '
              'namespace.  [1]\n'
              'The "exec()" and "eval()" functions have optional arguments to\n'
              'override the global and local namespace.  If only one namespace '
              'is\n'
              'specified, it is used for both.\n'
              '\n'
              '\n'
              'Exceptions\n'
              '==========\n'
              '\n'
              'Exceptions are a means of breaking out of the normal flow of '
              'control\n'
              'of a code block in order to handle errors or other exceptional\n'
              'conditions.  An exception is *raised* at the point where the '
              'error is\n'
              'detected; it may be *handled* by the surrounding code block or '
              'by any\n'
              'code block that directly or indirectly invoked the code block '
              'where\n'
              'the error occurred.\n'
              '\n'
              'The Python interpreter raises an exception when it detects a '
              'run-time\n'
              'error (such as division by zero).  A Python program can also\n'
              'explicitly raise an exception with the "raise" statement. '
              'Exception\n'
              'handlers are specified with the "try" … "except" statement.  '
              'The\n'
              '"finally" clause of such a statement can be used to specify '
              'cleanup\n'
              'code which does not handle the exception, but is executed '
              'whether an\n'
              'exception occurred or not in the preceding code.\n'
              '\n'
              'Python uses the “termination” model of error handling: an '
              'exception\n'
              'handler can find out what happened and continue execution at an '
              'outer\n'
              'level, but it cannot repair the cause of the error and retry '
              'the\n'
              'failing operation (except by re-entering the offending piece of '
              'code\n'
              'from the top).\n'
              '\n'
              'When an exception is not handled at all, the interpreter '
              'terminates\n'
              'execution of the program, or returns to its interactive main '
              'loop.  In\n'
              'either case, it prints a stack traceback, except when the '
              'exception is\n'
              '"SystemExit".\n'
              '\n'
              'Exceptions are identified by class instances.  The "except" '
              'clause is\n'
              'selected depending on the class of the instance: it must '
              'reference the\n'
              'class of the instance or a *non-virtual base class* thereof. '
              'The\n'
              'instance can be received by the handler and can carry '
              'additional\n'
              'information about the exceptional condition.\n'
              '\n'
              'Note:\n'
              '\n'
              '  Exception messages are not part of the Python API.  Their '
              'contents\n'
              '  may change from one version of Python to the next without '
              'warning\n'
              '  and should not be relied on by code which will run under '
              'multiple\n'
              '  versions of the interpreter.\n'
              '\n'
              'See also the description of the "try" statement in section The '
              'try\n'
              'statement and "raise" statement in section The raise '
              'statement.\n'
              '\n'
              '-[ Footnotes ]-\n'
              '\n'
              '[1] This limitation occurs because the code that is executed by '
              'these\n'
              '    operations is not available at the time the module is '
              'compiled.\n',
 'exprlists': 'Expression lists\n'
              '****************\n'
              '\n'
              '   expression_list    ::= expression ("," expression)* [","]\n'
              '   starred_list       ::= starred_item ("," starred_item)* '
              '[","]\n'
              '   starred_expression ::= expression | (starred_item ",")* '
              '[starred_item]\n'
              '   starred_item       ::= assignment_expression | "*" or_expr\n'
              '\n'
              'Except when part of a list or set display, an expression list\n'
              'containing at least one comma yields a tuple.  The length of '
              'the tuple\n'
              'is the number of expressions in the list.  The expressions are\n'
              'evaluated from left to right.\n'
              '\n'
              'An asterisk "*" denotes *iterable unpacking*.  Its operand must '
              'be an\n'
              '*iterable*.  The iterable is expanded into a sequence of items, '
              'which\n'
              'are included in the new tuple, list, or set, at the site of '
              'the\n'
              'unpacking.\n'
              '\n'
              'New in version 3.5: Iterable unpacking in expression lists, '
              'originally\n'
              'proposed by **PEP 448**.\n'
              '\n'
              'A trailing comma is required only to create a one-item tuple, '
              'such as\n'
              '"1,"; it is optional in all other cases. A single expression '
              'without a\n'
              'trailing comma doesn’t create a tuple, but rather yields the '
              'value of\n'
              'that expression. (To create an empty tuple, use an empty pair '
              'of\n'
              'parentheses: "()".)\n',
 'floating': 'Floating point literals\n'
             '***********************\n'
             '\n'
             'Floating point literals are described by the following lexical\n'
             'definitions:\n'
             '\n'
             '   floatnumber   ::= pointfloat | exponentfloat\n'
             '   pointfloat    ::= [digitpart] fraction | digitpart "."\n'
             '   exponentfloat ::= (digitpart | pointfloat) exponent\n'
             '   digitpart     ::= digit (["_"] digit)*\n'
             '   fraction      ::= "." digitpart\n'
             '   exponent      ::= ("e" | "E") ["+" | "-"] digitpart\n'
             '\n'
             'Note that the integer and exponent parts are always interpreted '
             'using\n'
             'radix 10. For example, "077e010" is legal, and denotes the same '
             'number\n'
             'as "77e10". The allowed range of floating point literals is\n'
             'implementation-dependent.  As in integer literals, underscores '
             'are\n'
             'supported for digit grouping.\n'
             '\n'
             'Some examples of floating point literals:\n'
             '\n'
             '   3.14    10.    .001    1e100    3.14e-10    0e0    '
             '3.14_15_93\n'
             '\n'
             'Changed in version 3.6: Underscores are now allowed for '
             'grouping\n'
             'purposes in literals.\n',
 'for': 'The "for" statement\n'
        '*******************\n'
        '\n'
        'The "for" statement is used to iterate over the elements of a '
        'sequence\n'
        '(such as a string, tuple or list) or other iterable object:\n'
        '\n'
        '   for_stmt ::= "for" target_list "in" starred_list ":" suite\n'
        '                ["else" ":" suite]\n'
        '\n'
        'The "starred_list" expression is evaluated once; it should yield an\n'
        '*iterable* object.  An *iterator* is created for that iterable. The\n'
        'first item provided by the iterator is then assigned to the target\n'
        'list using the standard rules for assignments (see Assignment\n'
        'statements), and the suite is executed.  This repeats for each item\n'
        'provided by the iterator.  When the iterator is exhausted, the suite\n'
        'in the "else" clause, if present, is executed, and the loop\n'
        'terminates.\n'
        '\n'
        'A "break" statement executed in the first suite terminates the loop\n'
        'without executing the "else" clause’s suite.  A "continue" statement\n'
        'executed in the first suite skips the rest of the suite and '
        'continues\n'
        'with the next item, or with the "else" clause if there is no next\n'
        'item.\n'
        '\n'
        'The for-loop makes assignments to the variables in the target list.\n'
        'This overwrites all previous assignments to those variables '
        'including\n'
        'those made in the suite of the for-loop:\n'
        '\n'
        '   for i in range(10):\n'
        '       print(i)\n'
        '       i = 5             # this will not affect the for-loop\n'
        '                         # because i will be overwritten with the '
        'next\n'
        '                         # index in the range\n'
        '\n'
        'Names in the target list are not deleted when the loop is finished,\n'
        'but if the sequence is empty, they will not have been assigned to at\n'
        'all by the loop.  Hint: the built-in type "range()" represents\n'
        'immutable arithmetic sequences of integers. For instance, iterating\n'
        '"range(3)" successively yields 0, 1, and then 2.\n'
        '\n'
        'Changed in version 3.11: Starred elements are now allowed in the\n'
        'expression list.\n',
 'formatstrings': 'Format String Syntax\n'
                  '********************\n'
                  '\n'
                  'The "str.format()" method and the "Formatter" class share '
                  'the same\n'
                  'syntax for format strings (although in the case of '
                  '"Formatter",\n'
                  'subclasses can define their own format string syntax).  The '
                  'syntax is\n'
                  'related to that of formatted string literals, but it is '
                  'less\n'
                  'sophisticated and, in particular, does not support '
                  'arbitrary\n'
                  'expressions.\n'
                  '\n'
                  'Format strings contain “replacement fields” surrounded by '
                  'curly braces\n'
                  '"{}". Anything that is not contained in braces is '
                  'considered literal\n'
                  'text, which is copied unchanged to the output.  If you need '
                  'to include\n'
                  'a brace character in the literal text, it can be escaped by '
                  'doubling:\n'
                  '"{{" and "}}".\n'
                  '\n'
                  'The grammar for a replacement field is as follows:\n'
                  '\n'
                  '   replacement_field ::= "{" [field_name] ["!" conversion] '
                  '[":" format_spec] "}"\n'
                  '   field_name        ::= arg_name ("." attribute_name | "[" '
                  'element_index "]")*\n'
                  '   arg_name          ::= [identifier | digit+]\n'
                  '   attribute_name    ::= identifier\n'
                  '   element_index     ::= digit+ | index_string\n'
                  '   index_string      ::= <any source character except "]"> '
                  '+\n'
                  '   conversion        ::= "r" | "s" | "a"\n'
                  '   format_spec       ::= format-spec:format_spec\n'
                  '\n'
                  'In less formal terms, the replacement field can start with '
                  'a\n'
                  '*field_name* that specifies the object whose value is to be '
                  'formatted\n'
                  'and inserted into the output instead of the replacement '
                  'field. The\n'
                  '*field_name* is optionally followed by a  *conversion* '
                  'field, which is\n'
                  'preceded by an exclamation point "\'!\'", and a '
                  '*format_spec*, which is\n'
                  'preceded by a colon "\':\'".  These specify a non-default '
                  'format for the\n'
                  'replacement value.\n'
                  '\n'
                  'See also the Format Specification Mini-Language section.\n'
                  '\n'
                  'The *field_name* itself begins with an *arg_name* that is '
                  'either a\n'
                  'number or a keyword.  If it’s a number, it refers to a '
                  'positional\n'
                  'argument, and if it’s a keyword, it refers to a named '
                  'keyword\n'
                  'argument. An *arg_name* is treated as a number if a call '
                  'to\n'
                  '"str.isdecimal()" on the string would return true. If the '
                  'numerical\n'
                  'arg_names in a format string are 0, 1, 2, … in sequence, '
                  'they can all\n'
                  'be omitted (not just some) and the numbers 0, 1, 2, … will '
                  'be\n'
                  'automatically inserted in that order. Because *arg_name* is '
                  'not quote-\n'
                  'delimited, it is not possible to specify arbitrary '
                  'dictionary keys\n'
                  '(e.g., the strings "\'10\'" or "\':-]\'") within a format '
                  'string. The\n'
                  '*arg_name* can be followed by any number of index or '
                  'attribute\n'
                  'expressions. An expression of the form "\'.name\'" selects '
                  'the named\n'
                  'attribute using "getattr()", while an expression of the '
                  'form\n'
                  '"\'[index]\'" does an index lookup using "__getitem__()".\n'
                  '\n'
                  'Changed in version 3.1: The positional argument specifiers '
                  'can be\n'
                  'omitted for "str.format()", so "\'{} {}\'.format(a, b)" is '
                  'equivalent to\n'
                  '"\'{0} {1}\'.format(a, b)".\n'
                  '\n'
                  'Changed in version 3.4: The positional argument specifiers '
                  'can be\n'
                  'omitted for "Formatter".\n'
                  '\n'
                  'Some simple format string examples:\n'
                  '\n'
                  '   "First, thou shalt count to {0}"  # References first '
                  'positional argument\n'
                  '   "Bring me a {}"                   # Implicitly '
                  'references the first positional argument\n'
                  '   "From {} to {}"                   # Same as "From {0} to '
                  '{1}"\n'
                  '   "My quest is {name}"              # References keyword '
                  "argument 'name'\n"
                  '   "Weight in tons {0.weight}"       # \'weight\' attribute '
                  'of first positional arg\n'
                  '   "Units destroyed: {players[0]}"   # First element of '
                  "keyword argument 'players'.\n"
                  '\n'
                  'The *conversion* field causes a type coercion before '
                  'formatting.\n'
                  'Normally, the job of formatting a value is done by the '
                  '"__format__()"\n'
                  'method of the value itself.  However, in some cases it is '
                  'desirable to\n'
                  'force a type to be formatted as a string, overriding its '
                  'own\n'
                  'definition of formatting.  By converting the value to a '
                  'string before\n'
                  'calling "__format__()", the normal formatting logic is '
                  'bypassed.\n'
                  '\n'
                  'Three conversion flags are currently supported: "\'!s\'" '
                  'which calls\n'
                  '"str()" on the value, "\'!r\'" which calls "repr()" and '
                  '"\'!a\'" which\n'
                  'calls "ascii()".\n'
                  '\n'
                  'Some examples:\n'
                  '\n'
                  '   "Harold\'s a clever {0!s}"        # Calls str() on the '
                  'argument first\n'
                  '   "Bring out the holy {name!r}"    # Calls repr() on the '
                  'argument first\n'
                  '   "More {!a}"                      # Calls ascii() on the '
                  'argument first\n'
                  '\n'
                  'The *format_spec* field contains a specification of how the '
                  'value\n'
                  'should be presented, including such details as field width, '
                  'alignment,\n'
                  'padding, decimal precision and so on.  Each value type can '
                  'define its\n'
                  'own “formatting mini-language” or interpretation of the '
                  '*format_spec*.\n'
                  '\n'
                  'Most built-in types support a common formatting '
                  'mini-language, which\n'
                  'is described in the next section.\n'
                  '\n'
                  'A *format_spec* field can also include nested replacement '
                  'fields\n'
                  'within it. These nested replacement fields may contain a '
                  'field name,\n'
                  'conversion flag and format specification, but deeper '
                  'nesting is not\n'
                  'allowed.  The replacement fields within the format_spec '
                  'are\n'
                  'substituted before the *format_spec* string is interpreted. '
                  'This\n'
                  'allows the formatting of a value to be dynamically '
                  'specified.\n'
                  '\n'
                  'See the Format examples section for some examples.\n'
                  '\n'
                  '\n'
                  'Format Specification Mini-Language\n'
                  '==================================\n'
                  '\n'
                  '“Format specifications” are used within replacement fields '
                  'contained\n'
                  'within a format string to define how individual values are '
                  'presented\n'
                  '(see Format String Syntax and f-strings). They can also be '
                  'passed\n'
                  'directly to the built-in "format()" function.  Each '
                  'formattable type\n'
                  'may define how the format specification is to be '
                  'interpreted.\n'
                  '\n'
                  'Most built-in types implement the following options for '
                  'format\n'
                  'specifications, although some of the formatting options are '
                  'only\n'
                  'supported by the numeric types.\n'
                  '\n'
                  'A general convention is that an empty format specification '
                  'produces\n'
                  'the same result as if you had called "str()" on the value. '
                  'A non-empty\n'
                  'format specification typically modifies the result.\n'
                  '\n'
                  'The general form of a *standard format specifier* is:\n'
                  '\n'
                  '   format_spec     ::= '
                  '[[fill]align][sign]["z"]["#"]["0"][width][grouping_option]["." '
                  'precision][type]\n'
                  '   fill            ::= <any character>\n'
                  '   align           ::= "<" | ">" | "=" | "^"\n'
                  '   sign            ::= "+" | "-" | " "\n'
                  '   width           ::= digit+\n'
                  '   grouping_option ::= "_" | ","\n'
                  '   precision       ::= digit+\n'
                  '   type            ::= "b" | "c" | "d" | "e" | "E" | "f" | '
                  '"F" | "g" | "G" | "n" | "o" | "s" | "x" | "X" | "%"\n'
                  '\n'
                  'If a valid *align* value is specified, it can be preceded '
                  'by a *fill*\n'
                  'character that can be any character and defaults to a space '
                  'if\n'
                  'omitted. It is not possible to use a literal curly brace '
                  '(”"{"” or\n'
                  '“"}"”) as the *fill* character in a formatted string '
                  'literal or when\n'
                  'using the "str.format()" method.  However, it is possible '
                  'to insert a\n'
                  'curly brace with a nested replacement field.  This '
                  'limitation doesn’t\n'
                  'affect the "format()" function.\n'
                  '\n'
                  'The meaning of the various alignment options is as '
                  'follows:\n'
                  '\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| Option    | '
                  'Meaning                                                    '
                  '|\n'
                  '|===========|============================================================|\n'
                  '| "\'<\'"     | Forces the field to be left-aligned within '
                  'the available   |\n'
                  '|           | space (this is the default for most '
                  'objects).              |\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| "\'>\'"     | Forces the field to be right-aligned within '
                  'the available  |\n'
                  '|           | space (this is the default for '
                  'numbers).                   |\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| "\'=\'"     | Forces the padding to be placed after the '
                  'sign (if any)    |\n'
                  '|           | but before the digits.  This is used for '
                  'printing fields   |\n'
                  '|           | in the form ‘+000000120’. This alignment '
                  'option is only    |\n'
                  '|           | valid for numeric types.  It becomes the '
                  'default for       |\n'
                  '|           | numbers when ‘0’ immediately precedes the '
                  'field width.     |\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| "\'^\'"     | Forces the field to be centered within the '
                  'available       |\n'
                  '|           | '
                  'space.                                                     '
                  '|\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'Note that unless a minimum field width is defined, the '
                  'field width\n'
                  'will always be the same size as the data to fill it, so '
                  'that the\n'
                  'alignment option has no meaning in this case.\n'
                  '\n'
                  'The *sign* option is only valid for number types, and can '
                  'be one of\n'
                  'the following:\n'
                  '\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| Option    | '
                  'Meaning                                                    '
                  '|\n'
                  '|===========|============================================================|\n'
                  '| "\'+\'"     | indicates that a sign should be used for '
                  'both positive as  |\n'
                  '|           | well as negative '
                  'numbers.                                  |\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| "\'-\'"     | indicates that a sign should be used only '
                  'for negative     |\n'
                  '|           | numbers (this is the default '
                  'behavior).                    |\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '| space     | indicates that a leading space should be used '
                  'on positive  |\n'
                  '|           | numbers, and a minus sign on negative '
                  'numbers.             |\n'
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'The "\'z\'" option coerces negative zero floating-point '
                  'values to\n'
                  'positive zero after rounding to the format precision.  This '
                  'option is\n'
                  'only valid for floating-point presentation types.\n'
                  '\n'
                  'Changed in version 3.11: Added the "\'z\'" option (see also '
                  '**PEP\n'
                  '682**).\n'
                  '\n'
                  'The "\'#\'" option causes the “alternate form” to be used '
                  'for the\n'
                  'conversion.  The alternate form is defined differently for '
                  'different\n'
                  'types.  This option is only valid for integer, float and '
                  'complex\n'
                  'types. For integers, when binary, octal, or hexadecimal '
                  'output is\n'
                  'used, this option adds the respective prefix "\'0b\'", '
                  '"\'0o\'", "\'0x\'",\n'
                  'or "\'0X\'" to the output value. For float and complex the '
                  'alternate\n'
                  'form causes the result of the conversion to always contain '
                  'a decimal-\n'
                  'point character, even if no digits follow it. Normally, a '
                  'decimal-\n'
                  'point character appears in the result of these conversions '
                  'only if a\n'
                  'digit follows it. In addition, for "\'g\'" and "\'G\'" '
                  'conversions,\n'
                  'trailing zeros are not removed from the result.\n'
                  '\n'
                  'The "\',\'" option signals the use of a comma for a '
                  'thousands separator.\n'
                  'For a locale aware separator, use the "\'n\'" integer '
                  'presentation type\n'
                  'instead.\n'
                  '\n'
                  'Changed in version 3.1: Added the "\',\'" option (see also '
                  '**PEP 378**).\n'
                  '\n'
                  'The "\'_\'" option signals the use of an underscore for a '
                  'thousands\n'
                  'separator for floating point presentation types and for '
                  'integer\n'
                  'presentation type "\'d\'".  For integer presentation types '
                  '"\'b\'", "\'o\'",\n'
                  '"\'x\'", and "\'X\'", underscores will be inserted every 4 '
                  'digits.  For\n'
                  'other presentation types, specifying this option is an '
                  'error.\n'
                  '\n'
                  'Changed in version 3.6: Added the "\'_\'" option (see also '
                  '**PEP 515**).\n'
                  '\n'
                  '*width* is a decimal integer defining the minimum total '
                  'field width,\n'
                  'including any prefixes, separators, and other formatting '
                  'characters.\n'
                  'If not specified, then the field width will be determined '
                  'by the\n'
                  'content.\n'
                  '\n'
                  'When no explicit alignment is given, preceding the *width* '
                  'field by a\n'
                  'zero ("\'0\'") character enables sign-aware zero-padding '
                  'for numeric\n'
                  'types.  This is equivalent to a *fill* character of "\'0\'" '
                  'with an\n'
                  '*alignment* type of "\'=\'".\n'
                  '\n'
                  'Changed in version 3.10: Preceding the *width* field by '
                  '"\'0\'" no\n'
                  'longer affects the default alignment for strings.\n'
                  '\n'
                  'The *precision* is a decimal integer indicating how many '
                  'digits should\n'
                  'be displayed after the decimal point for presentation types '
                  '"\'f\'" and\n'
                  '"\'F\'", or before and after the decimal point for '
                  'presentation types\n'
                  '"\'g\'" or "\'G\'".  For string presentation types the '
                  'field indicates the\n'
                  'maximum field size - in other words, how many characters '
                  'will be used\n'
                  'from the field content.  The *precision* is not allowed for '
                  'integer\n'
                  'presentation types.\n'
                  '\n'
                  'Finally, the *type* determines how the data should be '
                  'presented.\n'
                  '\n'
                  'The available string presentation types are:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Type      | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '|===========|============================================================|\n'
                  '   | "\'s\'"     | String format. This is the default type '
                  'for strings and    |\n'
                  '   |           | may be '
                  'omitted.                                            |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | None      | The same as '
                  '"\'s\'".                                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'The available integer presentation types are:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Type      | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '|===========|============================================================|\n'
                  '   | "\'b\'"     | Binary format. Outputs the number in '
                  'base 2.               |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'c\'"     | Character. Converts the integer to the '
                  'corresponding       |\n'
                  '   |           | unicode character before '
                  'printing.                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'d\'"     | Decimal Integer. Outputs the number in '
                  'base 10.            |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'o\'"     | Octal format. Outputs the number in base '
                  '8.                |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'x\'"     | Hex format. Outputs the number in base '
                  '16, using lower-    |\n'
                  '   |           | case letters for the digits above '
                  '9.                       |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'X\'"     | Hex format. Outputs the number in base '
                  '16, using upper-    |\n'
                  '   |           | case letters for the digits above 9. In '
                  'case "\'#\'" is      |\n'
                  '   |           | specified, the prefix "\'0x\'" will be '
                  'upper-cased to "\'0X\'" |\n'
                  '   |           | as '
                  'well.                                                   |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'n\'"     | Number. This is the same as "\'d\'", '
                  'except that it uses the |\n'
                  '   |           | current locale setting to insert the '
                  'appropriate number    |\n'
                  '   |           | separator '
                  'characters.                                      |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | None      | The same as '
                  '"\'d\'".                                         |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  'In addition to the above presentation types, integers can '
                  'be formatted\n'
                  'with the floating point presentation types listed below '
                  '(except "\'n\'"\n'
                  'and "None"). When doing so, "float()" is used to convert '
                  'the integer\n'
                  'to a floating point number before formatting.\n'
                  '\n'
                  'The available presentation types for "float" and "Decimal" '
                  'values are:\n'
                  '\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | Type      | '
                  'Meaning                                                    '
                  '|\n'
                  '   '
                  '|===========|============================================================|\n'
                  '   | "\'e\'"     | Scientific notation. For a given '
                  'precision "p", formats    |\n'
                  '   |           | the number in scientific notation with the '
                  'letter ‘e’      |\n'
                  '   |           | separating the coefficient from the '
                  'exponent. The          |\n'
                  '   |           | coefficient has one digit before and "p" '
                  'digits after the  |\n'
                  '   |           | decimal point, for a total of "p + 1" '
                  'significant digits.  |\n'
                  '   |           | With no precision given, uses a precision '
                  'of "6" digits    |\n'
                  '   |           | after the decimal point for "float", and '
                  'shows all         |\n'
                  '   |           | coefficient digits for "Decimal". If no '
                  'digits follow the  |\n'
                  '   |           | decimal point, the decimal point is also '
                  'removed unless    |\n'
                  '   |           | the "#" option is '
                  'used.                                    |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'E\'"     | Scientific notation. Same as "\'e\'" '
                  'except it uses an upper |\n'
                  '   |           | case ‘E’ as the separator '
                  'character.                       |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'f\'"     | Fixed-point notation. For a given '
                  'precision "p", formats   |\n'
                  '   |           | the number as a decimal number with '
                  'exactly "p" digits     |\n'
                  '   |           | following the decimal point. With no '
                  'precision given, uses |\n'
                  '   |           | a precision of "6" digits after the '
                  'decimal point for      |\n'
                  '   |           | "float", and uses a precision large enough '
                  'to show all     |\n'
                  '   |           | coefficient digits for "Decimal". If no '
                  'digits follow the  |\n'
                  '   |           | decimal point, the decimal point is also '
                  'removed unless    |\n'
                  '   |           | the "#" option is '
                  'used.                                    |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'F\'"     | Fixed-point notation. Same as "\'f\'", '
                  'but converts "nan" to |\n'
                  '   |           | "NAN" and "inf" to '
                  '"INF".                                  |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'g\'"     | General format.  For a given precision '
                  '"p >= 1", this      |\n'
                  '   |           | rounds the number to "p" significant '
                  'digits and then       |\n'
                  '   |           | formats the result in either fixed-point '
                  'format or in      |\n'
                  '   |           | scientific notation, depending on its '
                  'magnitude. A         |\n'
                  '   |           | precision of "0" is treated as equivalent '
                  'to a precision   |\n'
                  '   |           | of "1".  The precise rules are as follows: '
                  'suppose that    |\n'
                  '   |           | the result formatted with presentation '
                  'type "\'e\'" and      |\n'
                  '   |           | precision "p-1" would have exponent '
                  '"exp".  Then, if "m <= |\n'
                  '   |           | exp < p", where "m" is -4 for floats and '
                  '-6 for            |\n'
                  '   |           | "Decimals", the number is formatted with '
                  'presentation type |\n'
                  '   |           | "\'f\'" and precision "p-1-exp".  '
                  'Otherwise, the number is   |\n'
                  '   |           | formatted with presentation type "\'e\'" '
                  'and precision       |\n'
                  '   |           | "p-1". In both cases insignificant '
                  'trailing zeros are      |\n'
                  '   |           | removed from the significand, and the '
                  'decimal point is     |\n'
                  '   |           | also removed if there are no remaining '
                  'digits following    |\n'
                  '   |           | it, unless the "\'#\'" option is used.  '
                  'With no precision    |\n'
                  '   |           | given, uses a precision of "6" significant '
                  'digits for      |\n'
                  '   |           | "float". For "Decimal", the coefficient of '
                  'the result is   |\n'
                  '   |           | formed from the coefficient digits of the '
                  'value;           |\n'
                  '   |           | scientific notation is used for values '
                  'smaller than "1e-6" |\n'
                  '   |           | in absolute value and values where the '
                  'place value of the  |\n'
                  '   |           | least significant digit is larger than 1, '
                  'and fixed-point  |\n'
                  '   |           | notation is used otherwise.  Positive and '
                  'negative         |\n'
                  '   |           | infinity, positive and negative zero, and '
                  'nans, are        |\n'
                  '   |           | formatted as "inf", "-inf", "0", "-0" and '
                  '"nan"            |\n'
                  '   |           | respectively, regardless of the '
                  'precision.                 |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'G\'"     | General format. Same as "\'g\'" except '
                  'switches to "\'E\'" if  |\n'
                  '   |           | the number gets too large. The '
                  'representations of infinity |\n'
                  '   |           | and NaN are uppercased, '
                  'too.                               |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'n\'"     | Number. This is the same as "\'g\'", '
                  'except that it uses the |\n'
                  '   |           | current locale setting to insert the '
                  'appropriate number    |\n'
                  '   |           | separator '
                  'characters.                                      |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | "\'%\'"     | Percentage. Multiplies the number by 100 '
                  'and displays in   |\n'
                  '   |           | fixed ("\'f\'") format, followed by a '
                  'percent sign.          |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '   | None      | For "float" this is the same as "\'g\'", '
                  'except that when    |\n'
                  '   |           | fixed-point notation is used to format the '
                  'result, it      |\n'
                  '   |           | always includes at least one digit past '
                  'the decimal point. |\n'
                  '   |           | The precision used is as large as needed '
                  'to represent the  |\n'
                  '   |           | given value faithfully.  For "Decimal", '
                  'this is the same   |\n'
                  '   |           | as either "\'g\'" or "\'G\'" depending on '
                  'the value of         |\n'
                  '   |           | "context.capitals" for the current decimal '
                  'context.  The   |\n'
                  '   |           | overall effect is to match the output of '
                  '"str()" as        |\n'
                  '   |           | altered by the other format '
                  'modifiers.                     |\n'
                  '   '
                  '+-----------+------------------------------------------------------------+\n'
                  '\n'
                  '\n'
                  'Format examples\n'
                  '===============\n'
                  '\n'
                  'This section contains examples of the "str.format()" syntax '
                  'and\n'
                  'comparison with the old "%"-formatting.\n'
                  '\n'
                  'In most of the cases the syntax is similar to the old '
                  '"%"-formatting,\n'
                  'with the addition of the "{}" and with ":" used instead of '
                  '"%". For\n'
                  'example, "\'%03.2f\'" can be translated to "\'{:03.2f}\'".\n'
                  '\n'
                  'The new format syntax also supports new and different '
                  'options, shown\n'
                  'in the following examples.\n'
                  '\n'
                  'Accessing arguments by position:\n'
                  '\n'
                  "   >>> '{0}, {1}, {2}'.format('a', 'b', 'c')\n"
                  "   'a, b, c'\n"
                  "   >>> '{}, {}, {}'.format('a', 'b', 'c')  # 3.1+ only\n"
                  "   'a, b, c'\n"
                  "   >>> '{2}, {1}, {0}'.format('a', 'b', 'c')\n"
                  "   'c, b, a'\n"
                  "   >>> '{2}, {1}, {0}'.format(*'abc')      # unpacking "
                  'argument sequence\n'
                  "   'c, b, a'\n"
                  "   >>> '{0}{1}{0}'.format('abra', 'cad')   # arguments' "
                  'indices can be repeated\n'
                  "   'abracadabra'\n"
                  '\n'
                  'Accessing arguments by name:\n'
                  '\n'
                  "   >>> 'Coordinates: {latitude}, "
                  "{longitude}'.format(latitude='37.24N', "
                  "longitude='-115.81W')\n"
                  "   'Coordinates: 37.24N, -115.81W'\n"
                  "   >>> coord = {'latitude': '37.24N', 'longitude': "
                  "'-115.81W'}\n"
                  "   >>> 'Coordinates: {latitude}, "
                  "{longitude}'.format(**coord)\n"
                  "   'Coordinates: 37.24N, -115.81W'\n"
                  '\n'
                  'Accessing arguments’ attributes:\n'
                  '\n'
                  '   >>> c = 3-5j\n'
                  "   >>> ('The complex number {0} is formed from the real "
                  "part {0.real} '\n"
                  "   ...  'and the imaginary part {0.imag}.').format(c)\n"
                  "   'The complex number (3-5j) is formed from the real part "
                  "3.0 and the imaginary part -5.0.'\n"
                  '   >>> class Point:\n'
                  '   ...     def __init__(self, x, y):\n'
                  '   ...         self.x, self.y = x, y\n'
                  '   ...     def __str__(self):\n'
                  "   ...         return 'Point({self.x}, "
                  "{self.y})'.format(self=self)\n"
                  '   ...\n'
                  '   >>> str(Point(4, 2))\n'
                  "   'Point(4, 2)'\n"
                  '\n'
                  'Accessing arguments’ items:\n'
                  '\n'
                  '   >>> coord = (3, 5)\n'
                  "   >>> 'X: {0[0]};  Y: {0[1]}'.format(coord)\n"
                  "   'X: 3;  Y: 5'\n"
                  '\n'
                  'Replacing "%s" and "%r":\n'
                  '\n'
                  '   >>> "repr() shows quotes: {!r}; str() doesn\'t: '
                  '{!s}".format(\'test1\', \'test2\')\n'
                  '   "repr() shows quotes: \'test1\'; str() doesn\'t: test2"\n'
                  '\n'
                  'Aligning the text and specifying a width:\n'
                  '\n'
                  "   >>> '{:<30}'.format('left aligned')\n"
                  "   'left aligned                  '\n"
                  "   >>> '{:>30}'.format('right aligned')\n"
                  "   '                 right aligned'\n"
                  "   >>> '{:^30}'.format('centered')\n"
                  "   '           centered           '\n"
                  "   >>> '{:*^30}'.format('centered')  # use '*' as a fill "
                  'char\n'
                  "   '***********centered***********'\n"
                  '\n'
                  'Replacing "%+f", "%-f", and "% f" and specifying a sign:\n'
                  '\n'
                  "   >>> '{:+f}; {:+f}'.format(3.14, -3.14)  # show it "
                  'always\n'
                  "   '+3.140000; -3.140000'\n"
                  "   >>> '{: f}; {: f}'.format(3.14, -3.14)  # show a space "
                  'for positive numbers\n'
                  "   ' 3.140000; -3.140000'\n"
                  "   >>> '{:-f}; {:-f}'.format(3.14, -3.14)  # show only the "
                  "minus -- same as '{:f}; {:f}'\n"
                  "   '3.140000; -3.140000'\n"
                  '\n'
                  'Replacing "%x" and "%o" and converting the value to '
                  'different bases:\n'
                  '\n'
                  '   >>> # format also supports binary numbers\n'
                  '   >>> "int: {0:d};  hex: {0:x};  oct: {0:o};  bin: '
                  '{0:b}".format(42)\n'
                  "   'int: 42;  hex: 2a;  oct: 52;  bin: 101010'\n"
                  '   >>> # with 0x, 0o, or 0b as prefix:\n'
                  '   >>> "int: {0:d};  hex: {0:#x};  oct: {0:#o};  bin: '
                  '{0:#b}".format(42)\n'
                  "   'int: 42;  hex: 0x2a;  oct: 0o52;  bin: 0b101010'\n"
                  '\n'
                  'Using the comma as a thousands separator:\n'
                  '\n'
                  "   >>> '{:,}'.format(1234567890)\n"
                  "   '1,234,567,890'\n"
                  '\n'
                  'Expressing a percentage:\n'
                  '\n'
                  '   >>> points = 19\n'
                  '   >>> total = 22\n'
                  "   >>> 'Correct answers: {:.2%}'.format(points/total)\n"
                  "   'Correct answers: 86.36%'\n"
                  '\n'
                  'Using type-specific formatting:\n'
                  '\n'
                  '   >>> import datetime\n'
                  '   >>> d = datetime.datetime(2010, 7, 4, 12, 15, 58)\n'
                  "   >>> '{:%Y-%m-%d %H:%M:%S}'.format(d)\n"
                  "   '2010-07-04 12:15:58'\n"
                  '\n'
                  'Nesting arguments and more complex examples:\n'
                  '\n'
                  "   >>> for align, text in zip('<^>', ['left', 'center', "
                  "'right']):\n"
                  "   ...     '{0:{fill}{align}16}'.format(text, fill=align, "
                  'align=align)\n'
                  '   ...\n'
                  "   'left<<<<<<<<<<<<'\n"
                  "   '^^^^^center^^^^^'\n"
                  "   '>>>>>>>>>>>right'\n"
                  '   >>>\n'
                  '   >>> octets = [192, 168, 0, 1]\n'
                  "   >>> '{:02X}{:02X}{:02X}{:02X}'.format(*octets)\n"
                  "   'C0A80001'\n"
                  '   >>> int(_, 16)\n'
                  '   3232235521\n'
                  '   >>>\n'
                  '   >>> width = 5\n'
                  '   >>> for num in range(5,12): \n'
                  "   ...     for base in 'dXob':\n"
                  "   ...         print('{0:{width}{base}}'.format(num, "
                  "base=base, width=width), end=' ')\n"
                  '   ...     print()\n'
                  '   ...\n'
                  '       5     5     5   101\n'
                  '       6     6     6   110\n'
                  '       7     7     7   111\n'
                  '       8     8    10  1000\n'
                  '       9     9    11  1001\n'
                  '      10     A    12  1010\n'
                  '      11     B    13  1011\n',
 'function': 'Function definitions\n'
             '********************\n'
             '\n'
             'A function definition defines a user-defined function object '
             '(see\n'
             'section The standard type hierarchy):\n'
             '\n'
             '   funcdef                   ::= [decorators] "def" funcname "(" '
             '[parameter_list] ")"\n'
             '               ["->" expression] ":" suite\n'
             '   decorators                ::= decorator+\n'
             '   decorator                 ::= "@" assignment_expression '
             'NEWLINE\n'
             '   parameter_list            ::= defparameter ("," '
             'defparameter)* "," "/" ["," [parameter_list_no_posonly]]\n'
             '                        | parameter_list_no_posonly\n'
             '   parameter_list_no_posonly ::= defparameter ("," '
             'defparameter)* ["," [parameter_list_starargs]]\n'
             '                                 | parameter_list_starargs\n'
             '   parameter_list_starargs   ::= "*" [parameter] ("," '
             'defparameter)* ["," ["**" parameter [","]]]\n'
             '                               | "**" parameter [","]\n'
             '   parameter                 ::= identifier [":" expression]\n'
             '   defparameter              ::= parameter ["=" expression]\n'
             '   funcname                  ::= identifier\n'
             '\n'
             'A function definition is an executable statement.  Its execution '
             'binds\n'
             'the function name in the current local namespace to a function '
             'object\n'
             '(a wrapper around the executable code for the function).  This\n'
             'function object contains a reference to the current global '
             'namespace\n'
             'as the global namespace to be used when the function is called.\n'
             '\n'
             'The function definition does not execute the function body; this '
             'gets\n'
             'executed only when the function is called. [4]\n'
             '\n'
             'A function definition may be wrapped by one or more *decorator*\n'
             'expressions. Decorator expressions are evaluated when the '
             'function is\n'
             'defined, in the scope that contains the function definition.  '
             'The\n'
             'result must be a callable, which is invoked with the function '
             'object\n'
             'as the only argument. The returned value is bound to the '
             'function name\n'
             'instead of the function object.  Multiple decorators are applied '
             'in\n'
             'nested fashion. For example, the following code\n'
             '\n'
             '   @f1(arg)\n'
             '   @f2\n'
             '   def func(): pass\n'
             '\n'
             'is roughly equivalent to\n'
             '\n'
             '   def func(): pass\n'
             '   func = f1(arg)(f2(func))\n'
             '\n'
             'except that the original function is not temporarily bound to '
             'the name\n'
             '"func".\n'
             '\n'
             'Changed in version 3.9: Functions may be decorated with any '
             'valid\n'
             '"assignment_expression". Previously, the grammar was much more\n'
             'restrictive; see **PEP 614** for details.\n'
             '\n'
             'When one or more *parameters* have the form *parameter* "="\n'
             '*expression*, the function is said to have “default parameter '
             'values.”\n'
             'For a parameter with a default value, the corresponding '
             '*argument* may\n'
             'be omitted from a call, in which case the parameter’s default '
             'value is\n'
             'substituted.  If a parameter has a default value, all following\n'
             'parameters up until the “"*"” must also have a default value — '
             'this is\n'
             'a syntactic restriction that is not expressed by the grammar.\n'
             '\n'
             '**Default parameter values are evaluated from left to right when '
             'the\n'
             'function definition is executed.** This means that the '
             'expression is\n'
             'evaluated once, when the function is defined, and that the same '
             '“pre-\n'
             'computed” value is used for each call.  This is especially '
             'important\n'
             'to understand when a default parameter value is a mutable '
             'object, such\n'
             'as a list or a dictionary: if the function modifies the object '
             '(e.g.\n'
             'by appending an item to a list), the default parameter value is '
             'in\n'
             'effect modified.  This is generally not what was intended.  A '
             'way\n'
             'around this is to use "None" as the default, and explicitly test '
             'for\n'
             'it in the body of the function, e.g.:\n'
             '\n'
             '   def whats_on_the_telly(penguin=None):\n'
             '       if penguin is None:\n'
             '           penguin = []\n'
             '       penguin.append("property of the zoo")\n'
             '       return penguin\n'
             '\n'
             'Function call semantics are described in more detail in section '
             'Calls.\n'
             'A function call always assigns values to all parameters '
             'mentioned in\n'
             'the parameter list, either from positional arguments, from '
             'keyword\n'
             'arguments, or from default values.  If the form “"*identifier"” '
             'is\n'
             'present, it is initialized to a tuple receiving any excess '
             'positional\n'
             'parameters, defaulting to the empty tuple. If the form\n'
             '“"**identifier"” is present, it is initialized to a new ordered\n'
             'mapping receiving any excess keyword arguments, defaulting to a '
             'new\n'
             'empty mapping of the same type.  Parameters after “"*"” or\n'
             '“"*identifier"” are keyword-only parameters and may only be '
             'passed by\n'
             'keyword arguments.  Parameters before “"/"” are positional-only\n'
             'parameters and may only be passed by positional arguments.\n'
             '\n'
             'Changed in version 3.8: The "/" function parameter syntax may be '
             'used\n'
             'to indicate positional-only parameters. See **PEP 570** for '
             'details.\n'
             '\n'
             'Parameters may have an *annotation* of the form “": '
             'expression"”\n'
             'following the parameter name.  Any parameter may have an '
             'annotation,\n'
             'even those of the form "*identifier" or "**identifier".  '
             'Functions may\n'
             'have “return” annotation of the form “"-> expression"” after '
             'the\n'
             'parameter list.  These annotations can be any valid Python '
             'expression.\n'
             'The presence of annotations does not change the semantics of a\n'
             'function.  The annotation values are available as values of a\n'
             'dictionary keyed by the parameters’ names in the '
             '"__annotations__"\n'
             'attribute of the function object.  If the "annotations" import '
             'from\n'
             '"__future__" is used, annotations are preserved as strings at '
             'runtime\n'
             'which enables postponed evaluation.  Otherwise, they are '
             'evaluated\n'
             'when the function definition is executed.  In this case '
             'annotations\n'
             'may be evaluated in a different order than they appear in the '
             'source\n'
             'code.\n'
             '\n'
             'It is also possible to create anonymous functions (functions not '
             'bound\n'
             'to a name), for immediate use in expressions.  This uses lambda\n'
             'expressions, described in section Lambdas.  Note that the '
             'lambda\n'
             'expression is merely a shorthand for a simplified function '
             'definition;\n'
             'a function defined in a “"def"” statement can be passed around '
             'or\n'
             'assigned to another name just like a function defined by a '
             'lambda\n'
             'expression.  The “"def"” form is actually more powerful since '
             'it\n'
             'allows the execution of multiple statements and annotations.\n'
             '\n'
             '**Programmer’s note:** Functions are first-class objects.  A '
             '“"def"”\n'
             'statement executed inside a function definition defines a local\n'
             'function that can be returned or passed around.  Free variables '
             'used\n'
             'in the nested function can access the local variables of the '
             'function\n'
             'containing the def.  See section Naming and binding for '
             'details.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 3107** - Function Annotations\n'
             '     The original specification for function annotations.\n'
             '\n'
             '  **PEP 484** - Type Hints\n'
             '     Definition of a standard meaning for annotations: type '
             'hints.\n'
             '\n'
             '  **PEP 526** - Syntax for Variable Annotations\n'
             '     Ability to type hint variable declarations, including '
             'class\n'
             '     variables and instance variables.\n'
             '\n'
             '  **PEP 563** - Postponed Evaluation of Annotations\n'
             '     Support for forward references within annotations by '
             'preserving\n'
             '     annotations in a string form at runtime instead of eager\n'
             '     evaluation.\n'
             '\n'
             '  **PEP 318** - Decorators for Functions and Methods\n'
             '     Function and method decorators were introduced. Class '
             'decorators\n'
             '     were introduced in **PEP 3129**.\n',
 'global': 'The "global" statement\n'
           '**********************\n'
           '\n'
           '   global_stmt ::= "global" identifier ("," identifier)*\n'
           '\n'
           'The "global" statement is a declaration which holds for the '
           'entire\n'
           'current code block.  It means that the listed identifiers are to '
           'be\n'
           'interpreted as globals.  It would be impossible to assign to a '
           'global\n'
           'variable without "global", although free variables may refer to\n'
           'globals without being declared global.\n'
           '\n'
           'Names listed in a "global" statement must not be used in the same '
           'code\n'
           'block textually preceding that "global" statement.\n'
           '\n'
           'Names listed in a "global" statement must not be defined as '
           'formal\n'
           'parameters, or as targets in "with" statements or "except" '
           'clauses, or\n'
           'in a "for" target list, "class" definition, function definition,\n'
           '"import" statement, or variable annotation.\n'
           '\n'
           '**CPython implementation detail:** The current implementation does '
           'not\n'
           'enforce some of these restrictions, but programs should not abuse '
           'this\n'
           'freedom, as future implementations may enforce them or silently '
           'change\n'
           'the meaning of the program.\n'
           '\n'
           '**Programmer’s note:** "global" is a directive to the parser.  It\n'
           'applies only to code parsed at the same time as the "global"\n'
           'statement. In particular, a "global" statement contained in a '
           'string\n'
           'or code object supplied to the built-in "exec()" function does '
           'not\n'
           'affect the code block *containing* the function call, and code\n'
           'contained in such a string is unaffected by "global" statements in '
           'the\n'
           'code containing the function call.  The same applies to the '
           '"eval()"\n'
           'and "compile()" functions.\n',
 'id-classes': 'Reserved classes of identifiers\n'
               '*******************************\n'
               '\n'
               'Certain classes of identifiers (besides keywords) have '
               'special\n'
               'meanings.  These classes are identified by the patterns of '
               'leading and\n'
               'trailing underscore characters:\n'
               '\n'
               '"_*"\n'
               '   Not imported by "from module import *".\n'
               '\n'
               '"_"\n'
               '   In a "case" pattern within a "match" statement, "_" is a '
               'soft\n'
               '   keyword that denotes a wildcard.\n'
               '\n'
               '   Separately, the interactive interpreter makes the result of '
               'the\n'
               '   last evaluation available in the variable "_". (It is '
               'stored in the\n'
               '   "builtins" module, alongside built-in functions like '
               '"print".)\n'
               '\n'
               '   Elsewhere, "_" is a regular identifier. It is often used to '
               'name\n'
               '   “special” items, but it is not special to Python itself.\n'
               '\n'
               '   Note:\n'
               '\n'
               '     The name "_" is often used in conjunction with\n'
               '     internationalization; refer to the documentation for the\n'
               '     "gettext" module for more information on this '
               'convention.It is\n'
               '     also commonly used for unused variables.\n'
               '\n'
               '"__*__"\n'
               '   System-defined names, informally known as “dunder” names. '
               'These\n'
               '   names are defined by the interpreter and its '
               'implementation\n'
               '   (including the standard library). Current system names are\n'
               '   discussed in the Special method names section and '
               'elsewhere. More\n'
               '   will likely be defined in future versions of Python.  *Any* '
               'use of\n'
               '   "__*__" names, in any context, that does not follow '
               'explicitly\n'
               '   documented use, is subject to breakage without warning.\n'
               '\n'
               '"__*"\n'
               '   Class-private names.  Names in this category, when used '
               'within the\n'
               '   context of a class definition, are re-written to use a '
               'mangled form\n'
               '   to help avoid name clashes between “private” attributes of '
               'base and\n'
               '   derived classes. See section Identifiers (Names).\n',
 'identifiers': 'Identifiers and keywords\n'
                '************************\n'
                '\n'
                'Identifiers (also referred to as *names*) are described by '
                'the\n'
                'following lexical definitions.\n'
                '\n'
                'The syntax of identifiers in Python is based on the Unicode '
                'standard\n'
                'annex UAX-31, with elaboration and changes as defined below; '
                'see also\n'
                '**PEP 3131** for further details.\n'
                '\n'
                'Within the ASCII range (U+0001..U+007F), the valid characters '
                'for\n'
                'identifiers are the same as in Python 2.x: the uppercase and '
                'lowercase\n'
                'letters "A" through "Z", the underscore "_" and, except for '
                'the first\n'
                'character, the digits "0" through "9".\n'
                '\n'
                'Python 3.0 introduces additional characters from outside the '
                'ASCII\n'
                'range (see **PEP 3131**).  For these characters, the '
                'classification\n'
                'uses the version of the Unicode Character Database as '
                'included in the\n'
                '"unicodedata" module.\n'
                '\n'
                'Identifiers are unlimited in length.  Case is significant.\n'
                '\n'
                '   identifier   ::= xid_start xid_continue*\n'
                '   id_start     ::= <all characters in general categories Lu, '
                'Ll, Lt, Lm, Lo, Nl, the underscore, and characters with the '
                'Other_ID_Start property>\n'
                '   id_continue  ::= <all characters in id_start, plus '
                'characters in the categories Mn, Mc, Nd, Pc and others with '
                'the Other_ID_Continue property>\n'
                '   xid_start    ::= <all characters in id_start whose NFKC '
                'normalization is in "id_start xid_continue*">\n'
                '   xid_continue ::= <all characters in id_continue whose NFKC '
                'normalization is in "id_continue*">\n'
                '\n'
                'The Unicode category codes mentioned above stand for:\n'
                '\n'
                '* *Lu* - uppercase letters\n'
                '\n'
                '* *Ll* - lowercase letters\n'
                '\n'
                '* *Lt* - titlecase letters\n'
                '\n'
                '* *Lm* - modifier letters\n'
                '\n'
                '* *Lo* - other letters\n'
                '\n'
                '* *Nl* - letter numbers\n'
                '\n'
                '* *Mn* - nonspacing marks\n'
                '\n'
                '* *Mc* - spacing combining marks\n'
                '\n'
                '* *Nd* - decimal numbers\n'
                '\n'
                '* *Pc* - connector punctuations\n'
                '\n'
                '* *Other_ID_Start* - explicit list of characters in '
                'PropList.txt to\n'
                '  support backwards compatibility\n'
                '\n'
                '* *Other_ID_Continue* - likewise\n'
                '\n'
                'All identifiers are converted into the normal form NFKC while '
                'parsing;\n'
                'comparison of identifiers is based on NFKC.\n'
                '\n'
                'A non-normative HTML file listing all valid identifier '
                'characters for\n'
                'Unicode 14.0.0 can be found at\n'
                'https://www.unicode.org/Public/14.0.0/ucd/DerivedCoreProperties.txt\n'
                '\n'
                '\n'
                'Keywords\n'
                '========\n'
                '\n'
                'The following identifiers are used as reserved words, or '
                '*keywords* of\n'
                'the language, and cannot be used as ordinary identifiers.  '
                'They must\n'
                'be spelled exactly as written here:\n'
                '\n'
                '   False      await      else       import     pass\n'
                '   None       break      except     in         raise\n'
                '   True       class      finally    is         return\n'
                '   and        continue   for        lambda     try\n'
                '   as         def        from       nonlocal   while\n'
                '   assert     del        global     not        with\n'
                '   async      elif       if         or         yield\n'
                '\n'
                '\n'
                'Soft Keywords\n'
                '=============\n'
                '\n'
                'New in version 3.10.\n'
                '\n'
                'Some identifiers are only reserved under specific contexts. '
                'These are\n'
                'known as *soft keywords*.  The identifiers "match", "case" '
                'and "_" can\n'
                'syntactically act as keywords in contexts related to the '
                'pattern\n'
                'matching statement, but this distinction is done at the '
                'parser level,\n'
                'not when tokenizing.\n'
                '\n'
                'As soft keywords, their use with pattern matching is possible '
                'while\n'
                'still preserving compatibility with existing code that uses '
                '"match",\n'
                '"case" and "_" as identifier names.\n'
                '\n'
                '\n'
                'Reserved classes of identifiers\n'
                '===============================\n'
                '\n'
                'Certain classes of identifiers (besides keywords) have '
                'special\n'
                'meanings.  These classes are identified by the patterns of '
                'leading and\n'
                'trailing underscore characters:\n'
                '\n'
                '"_*"\n'
                '   Not imported by "from module import *".\n'
                '\n'
                '"_"\n'
                '   In a "case" pattern within a "match" statement, "_" is a '
                'soft\n'
                '   keyword that denotes a wildcard.\n'
                '\n'
                '   Separately, the interactive interpreter makes the result '
                'of the\n'
                '   last evaluation available in the variable "_". (It is '
                'stored in the\n'
                '   "builtins" module, alongside built-in functions like '
                '"print".)\n'
                '\n'
                '   Elsewhere, "_" is a regular identifier. It is often used '
                'to name\n'
                '   “special” items, but it is not special to Python itself.\n'
                '\n'
                '   Note:\n'
                '\n'
                '     The name "_" is often used in conjunction with\n'
                '     internationalization; refer to the documentation for '
                'the\n'
                '     "gettext" module for more information on this '
                'convention.It is\n'
                '     also commonly used for unused variables.\n'
                '\n'
                '"__*__"\n'
                '   System-defined names, informally known as “dunder” names. '
                'These\n'
                '   names are defined by the interpreter and its '
                'implementation\n'
                '   (including the standard library). Current system names '
                'are\n'
                '   discussed in the Special method names section and '
                'elsewhere. More\n'
                '   will likely be defined in future versions of Python.  '
                '*Any* use of\n'
                '   "__*__" names, in any context, that does not follow '
                'explicitly\n'
                '   documented use, is subject to breakage without warning.\n'
                '\n'
                '"__*"\n'
                '   Class-private names.  Names in this category, when used '
                'within the\n'
                '   context of a class definition, are re-written to use a '
                'mangled form\n'
                '   to help avoid name clashes between “private” attributes of '
                'base and\n'
                '   derived classes. See section Identifiers (Names).\n',
 'if': 'The "if" statement\n'
       '******************\n'
       '\n'
       'The "if" statement is used for conditional execution:\n'
       '\n'
       '   if_stmt ::= "if" assignment_expression ":" suite\n'
       '               ("elif" assignment_expression ":" suite)*\n'
       '               ["else" ":" suite]\n'
       '\n'
       'It selects exactly one of the suites by evaluating the expressions '
       'one\n'
       'by one until one is found to be true (see section Boolean operations\n'
       'for the definition of true and false); then that suite is executed\n'
       '(and no other part of the "if" statement is executed or evaluated).\n'
       'If all expressions are false, the suite of the "else" clause, if\n'
       'present, is executed.\n',
 'imaginary': 'Imaginary literals\n'
              '******************\n'
              '\n'
              'Imaginary literals are described by the following lexical '
              'definitions:\n'
              '\n'
              '   imagnumber ::= (floatnumber | digitpart) ("j" | "J")\n'
              '\n'
              'An imaginary literal yields a complex number with a real part '
              'of 0.0.\n'
              'Complex numbers are represented as a pair of floating point '
              'numbers\n'
              'and have the same restrictions on their range.  To create a '
              'complex\n'
              'number with a nonzero real part, add a floating point number to '
              'it,\n'
              'e.g., "(3+4j)".  Some examples of imaginary literals:\n'
              '\n'
              '   3.14j   10.j    10j     .001j   1e100j   3.14e-10j   '
              '3.14_15_93j\n',
 'import': 'The "import" statement\n'
           '**********************\n'
           '\n'
           '   import_stmt     ::= "import" module ["as" identifier] ("," '
           'module ["as" identifier])*\n'
           '                   | "from" relative_module "import" identifier '
           '["as" identifier]\n'
           '                   ("," identifier ["as" identifier])*\n'
           '                   | "from" relative_module "import" "(" '
           'identifier ["as" identifier]\n'
           '                   ("," identifier ["as" identifier])* [","] ")"\n'
           '                   | "from" relative_module "import" "*"\n'
           '   module          ::= (identifier ".")* identifier\n'
           '   relative_module ::= "."* module | "."+\n'
           '\n'
           'The basic import statement (no "from" clause) is executed in two\n'
           'steps:\n'
           '\n'
           '1. find a module, loading and initializing it if necessary\n'
           '\n'
           '2. define a name or names in the local namespace for the scope '
           'where\n'
           '   the "import" statement occurs.\n'
           '\n'
           'When the statement contains multiple clauses (separated by commas) '
           'the\n'
           'two steps are carried out separately for each clause, just as '
           'though\n'
           'the clauses had been separated out into individual import '
           'statements.\n'
           '\n'
           'The details of the first step, finding and loading modules, are\n'
           'described in greater detail in the section on the import system, '
           'which\n'
           'also describes the various types of packages and modules that can '
           'be\n'
           'imported, as well as all the hooks that can be used to customize '
           'the\n'
           'import system. Note that failures in this step may indicate '
           'either\n'
           'that the module could not be located, *or* that an error occurred\n'
           'while initializing the module, which includes execution of the\n'
           'module’s code.\n'
           '\n'
           'If the requested module is retrieved successfully, it will be '
           'made\n'
           'available in the local namespace in one of three ways:\n'
           '\n'
           '* If the module name is followed by "as", then the name following '
           '"as"\n'
           '  is bound directly to the imported module.\n'
           '\n'
           '* If no other name is specified, and the module being imported is '
           'a\n'
           '  top level module, the module’s name is bound in the local '
           'namespace\n'
           '  as a reference to the imported module\n'
           '\n'
           '* If the module being imported is *not* a top level module, then '
           'the\n'
           '  name of the top level package that contains the module is bound '
           'in\n'
           '  the local namespace as a reference to the top level package. '
           'The\n'
           '  imported module must be accessed using its full qualified name\n'
           '  rather than directly\n'
           '\n'
           'The "from" form uses a slightly more complex process:\n'
           '\n'
           '1. find the module specified in the "from" clause, loading and\n'
           '   initializing it if necessary;\n'
           '\n'
           '2. for each of the identifiers specified in the "import" clauses:\n'
           '\n'
           '   1. check if the imported module has an attribute by that name\n'
           '\n'
           '   2. if not, attempt to import a submodule with that name and '
           'then\n'
           '      check the imported module again for that attribute\n'
           '\n'
           '   3. if the attribute is not found, "ImportError" is raised.\n'
           '\n'
           '   4. otherwise, a reference to that value is stored in the local\n'
           '      namespace, using the name in the "as" clause if it is '
           'present,\n'
           '      otherwise using the attribute name\n'
           '\n'
           'Examples:\n'
           '\n'
           '   import foo                 # foo imported and bound locally\n'
           '   import foo.bar.baz         # foo, foo.bar, and foo.bar.baz '
           'imported, foo bound locally\n'
           '   import foo.bar.baz as fbb  # foo, foo.bar, and foo.bar.baz '
           'imported, foo.bar.baz bound as fbb\n'
           '   from foo.bar import baz    # foo, foo.bar, and foo.bar.baz '
           'imported, foo.bar.baz bound as baz\n'
           '   from foo import attr       # foo imported and foo.attr bound as '
           'attr\n'
           '\n'
           'If the list of identifiers is replaced by a star ("\'*\'"), all '
           'public\n'
           'names defined in the module are bound in the local namespace for '
           'the\n'
           'scope where the "import" statement occurs.\n'
           '\n'
           'The *public names* defined by a module are determined by checking '
           'the\n'
           'module’s namespace for a variable named "__all__"; if defined, it '
           'must\n'
           'be a sequence of strings which are names defined or imported by '
           'that\n'
           'module.  The names given in "__all__" are all considered public '
           'and\n'
           'are required to exist.  If "__all__" is not defined, the set of '
           'public\n'
           'names includes all names found in the module’s namespace which do '
           'not\n'
           'begin with an underscore character ("\'_\'").  "__all__" should '
           'contain\n'
           'the entire public API. It is intended to avoid accidentally '
           'exporting\n'
           'items that are not part of the API (such as library modules which '
           'were\n'
           'imported and used within the module).\n'
           '\n'
           'The wild card form of import — "from module import *" — is only\n'
           'allowed at the module level.  Attempting to use it in class or\n'
           'function definitions will raise a "SyntaxError".\n'
           '\n'
           'When specifying what module to import you do not have to specify '
           'the\n'
           'absolute name of the module. When a module or package is '
           'contained\n'
           'within another package it is possible to make a relative import '
           'within\n'
           'the same top package without having to mention the package name. '
           'By\n'
           'using leading dots in the specified module or package after "from" '
           'you\n'
           'can specify how high to traverse up the current package hierarchy\n'
           'without specifying exact names. One leading dot means the current\n'
           'package where the module making the import exists. Two dots means '
           'up\n'
           'one package level. Three dots is up two levels, etc. So if you '
           'execute\n'
           '"from . import mod" from a module in the "pkg" package then you '
           'will\n'
           'end up importing "pkg.mod". If you execute "from ..subpkg2 import '
           'mod"\n'
           'from within "pkg.subpkg1" you will import "pkg.subpkg2.mod". The\n'
           'specification for relative imports is contained in the Package\n'
           'Relative Imports section.\n'
           '\n'
           '"importlib.import_module()" is provided to support applications '
           'that\n'
           'determine dynamically the modules to be loaded.\n'
           '\n'
           'Raises an auditing event "import" with arguments "module", '
           '"filename",\n'
           '"sys.path", "sys.meta_path", "sys.path_hooks".\n'
           '\n'
           '\n'
           'Future statements\n'
           '=================\n'
           '\n'
           'A *future statement* is a directive to the compiler that a '
           'particular\n'
           'module should be compiled using syntax or semantics that will be\n'
           'available in a specified future release of Python where the '
           'feature\n'
           'becomes standard.\n'
           '\n'
           'The future statement is intended to ease migration to future '
           'versions\n'
           'of Python that introduce incompatible changes to the language.  '
           'It\n'
           'allows use of the new features on a per-module basis before the\n'
           'release in which the feature becomes standard.\n'
           '\n'
           '   future_stmt ::= "from" "__future__" "import" feature ["as" '
           'identifier]\n'
           '                   ("," feature ["as" identifier])*\n'
           '                   | "from" "__future__" "import" "(" feature '
           '["as" identifier]\n'
           '                   ("," feature ["as" identifier])* [","] ")"\n'
           '   feature     ::= identifier\n'
           '\n'
           'A future statement must appear near the top of the module.  The '
           'only\n'
           'lines that can appear before a future statement are:\n'
           '\n'
           '* the module docstring (if any),\n'
           '\n'
           '* comments,\n'
           '\n'
           '* blank lines, and\n'
           '\n'
           '* other future statements.\n'
           '\n'
           'The only feature that requires using the future statement is\n'
           '"annotations" (see **PEP 563**).\n'
           '\n'
           'All historical features enabled by the future statement are still\n'
           'recognized by Python 3.  The list includes "absolute_import",\n'
           '"division", "generators", "generator_stop", "unicode_literals",\n'
           '"print_function", "nested_scopes" and "with_statement".  They are '
           'all\n'
           'redundant because they are always enabled, and only kept for '
           'backwards\n'
           'compatibility.\n'
           '\n'
           'A future statement is recognized and treated specially at compile\n'
           'time: Changes to the semantics of core constructs are often\n'
           'implemented by generating different code.  It may even be the '
           'case\n'
           'that a new feature introduces new incompatible syntax (such as a '
           'new\n'
           'reserved word), in which case the compiler may need to parse the\n'
           'module differently.  Such decisions cannot be pushed off until\n'
           'runtime.\n'
           '\n'
           'For any given release, the compiler knows which feature names '
           'have\n'
           'been defined, and raises a compile-time error if a future '
           'statement\n'
           'contains a feature not known to it.\n'
           '\n'
           'The direct runtime semantics are the same as for any import '
           'statement:\n'
           'there is a standard module "__future__", described later, and it '
           'will\n'
           'be imported in the usual way at the time the future statement is\n'
           'executed.\n'
           '\n'
           'The interesting runtime semantics depend on the specific feature\n'
           'enabled by the future statement.\n'
           '\n'
           'Note that there is nothing special about the statement:\n'
           '\n'
           '   import __future__ [as name]\n'
           '\n'
           'That is not a future statement; it’s an ordinary import statement '
           'with\n'
           'no special semantics or syntax restrictions.\n'
           '\n'
           'Code compiled by calls to the built-in functions "exec()" and\n'
           '"compile()" that occur in a module "M" containing a future '
           'statement\n'
           'will, by default, use the new syntax or semantics associated with '
           'the\n'
           'future statement.  This can be controlled by optional arguments '
           'to\n'
           '"compile()" — see the documentation of that function for details.\n'
           '\n'
           'A future statement typed at an interactive interpreter prompt '
           'will\n'
           'take effect for the rest of the interpreter session.  If an\n'
           'interpreter is started with the "-i" option, is passed a script '
           'name\n'
           'to execute, and the script includes a future statement, it will be '
           'in\n'
           'effect in the interactive session started after the script is\n'
           'executed.\n'
           '\n'
           'See also:\n'
           '\n'
           '  **PEP 236** - Back to the __future__\n'
           '     The original proposal for the __future__ mechanism.\n',
 'in': 'Membership test operations\n'
       '**************************\n'
       '\n'
       'The operators "in" and "not in" test for membership.  "x in s"\n'
       'evaluates to "True" if *x* is a member of *s*, and "False" otherwise.\n'
       '"x not in s" returns the negation of "x in s".  All built-in '
       'sequences\n'
       'and set types support this as well as dictionary, for which "in" '
       'tests\n'
       'whether the dictionary has a given key. For container types such as\n'
       'list, tuple, set, frozenset, dict, or collections.deque, the\n'
       'expression "x in y" is equivalent to "any(x is e or x == e for e in\n'
       'y)".\n'
       '\n'
       'For the string and bytes types, "x in y" is "True" if and only if *x*\n'
       'is a substring of *y*.  An equivalent test is "y.find(x) != -1".\n'
       'Empty strings are always considered to be a substring of any other\n'
       'string, so """ in "abc"" will return "True".\n'
       '\n'
       'For user-defined classes which define the "__contains__()" method, "x\n'
       'in y" returns "True" if "y.__contains__(x)" returns a true value, and\n'
       '"False" otherwise.\n'
       '\n'
       'For user-defined classes which do not define "__contains__()" but do\n'
       'define "__iter__()", "x in y" is "True" if some value "z", for which\n'
       'the expression "x is z or x == z" is true, is produced while '
       'iterating\n'
       'over "y". If an exception is raised during the iteration, it is as if\n'
       '"in" raised that exception.\n'
       '\n'
       'Lastly, the old-style iteration protocol is tried: if a class defines\n'
       '"__getitem__()", "x in y" is "True" if and only if there is a non-\n'
       'negative integer index *i* such that "x is y[i] or x == y[i]", and no\n'
       'lower integer index raises the "IndexError" exception.  (If any other\n'
       'exception is raised, it is as if "in" raised that exception).\n'
       '\n'
       'The operator "not in" is defined to have the inverse truth value of\n'
       '"in".\n',
 'integers': 'Integer literals\n'
             '****************\n'
             '\n'
             'Integer literals are described by the following lexical '
             'definitions:\n'
             '\n'
             '   integer      ::= decinteger | bininteger | octinteger | '
             'hexinteger\n'
             '   decinteger   ::= nonzerodigit (["_"] digit)* | "0"+ (["_"] '
             '"0")*\n'
             '   bininteger   ::= "0" ("b" | "B") (["_"] bindigit)+\n'
             '   octinteger   ::= "0" ("o" | "O") (["_"] octdigit)+\n'
             '   hexinteger   ::= "0" ("x" | "X") (["_"] hexdigit)+\n'
             '   nonzerodigit ::= "1"..."9"\n'
             '   digit        ::= "0"..."9"\n'
             '   bindigit     ::= "0" | "1"\n'
             '   octdigit     ::= "0"..."7"\n'
             '   hexdigit     ::= digit | "a"..."f" | "A"..."F"\n'
             '\n'
             'There is no limit for the length of integer literals apart from '
             'what\n'
             'can be stored in available memory.\n'
             '\n'
             'Underscores are ignored for determining the numeric value of '
             'the\n'
             'literal.  They can be used to group digits for enhanced '
             'readability.\n'
             'One underscore can occur between digits, and after base '
             'specifiers\n'
             'like "0x".\n'
             '\n'
             'Note that leading zeros in a non-zero decimal number are not '
             'allowed.\n'
             'This is for disambiguation with C-style octal literals, which '
             'Python\n'
             'used before version 3.0.\n'
             '\n'
             'Some examples of integer literals:\n'
             '\n'
             '   7     2147483647                        0o177    0b100110111\n'
             '   3     79228162514264337593543950336     0o377    0xdeadbeef\n'
             '         100_000_000_000                   0b_1110_0101\n'
             '\n'
             'Changed in version 3.6: Underscores are now allowed for '
             'grouping\n'
             'purposes in literals.\n',
 'lambda': 'Lambdas\n'
           '*******\n'
           '\n'
           '   lambda_expr ::= "lambda" [parameter_list] ":" expression\n'
           '\n'
           'Lambda expressions (sometimes called lambda forms) are used to '
           'create\n'
           'anonymous functions. The expression "lambda parameters: '
           'expression"\n'
           'yields a function object.  The unnamed object behaves like a '
           'function\n'
           'object defined with:\n'
           '\n'
           '   def <lambda>(parameters):\n'
           '       return expression\n'
           '\n'
           'See section Function definitions for the syntax of parameter '
           'lists.\n'
           'Note that functions created with lambda expressions cannot '
           'contain\n'
           'statements or annotations.\n',
 'lists': 'List displays\n'
          '*************\n'
          '\n'
          'A list display is a possibly empty series of expressions enclosed '
          'in\n'
          'square brackets:\n'
          '\n'
          '   list_display ::= "[" [starred_list | comprehension] "]"\n'
          '\n'
          'A list display yields a new list object, the contents being '
          'specified\n'
          'by either a list of expressions or a comprehension.  When a comma-\n'
          'separated list of expressions is supplied, its elements are '
          'evaluated\n'
          'from left to right and placed into the list object in that order.\n'
          'When a comprehension is supplied, the list is constructed from the\n'
          'elements resulting from the comprehension.\n',
 'naming': 'Naming and binding\n'
           '******************\n'
           '\n'
           '\n'
           'Binding of names\n'
           '================\n'
           '\n'
           '*Names* refer to objects.  Names are introduced by name binding\n'
           'operations.\n'
           '\n'
           'The following constructs bind names:\n'
           '\n'
           '* formal parameters to functions,\n'
           '\n'
           '* class definitions,\n'
           '\n'
           '* function definitions,\n'
           '\n'
           '* assignment expressions,\n'
           '\n'
           '* targets that are identifiers if occurring in an assignment:\n'
           '\n'
           '  * "for" loop header,\n'
           '\n'
           '  * after "as" in a "with" statement, "except" clause, "except*"\n'
           '    clause, or in the as-pattern in structural pattern matching,\n'
           '\n'
           '  * in a capture pattern in structural pattern matching\n'
           '\n'
           '* "import" statements.\n'
           '\n'
           'The "import" statement of the form "from ... import *" binds all '
           'names\n'
           'defined in the imported module, except those beginning with an\n'
           'underscore. This form may only be used at the module level.\n'
           '\n'
           'A target occurring in a "del" statement is also considered bound '
           'for\n'
           'this purpose (though the actual semantics are to unbind the '
           'name).\n'
           '\n'
           'Each assignment or import statement occurs within a block defined '
           'by a\n'
           'class or function definition or at the module level (the '
           'top-level\n'
           'code block).\n'
           '\n'
           'If a name is bound in a block, it is a local variable of that '
           'block,\n'
           'unless declared as "nonlocal" or "global".  If a name is bound at '
           'the\n'
           'module level, it is a global variable.  (The variables of the '
           'module\n'
           'code block are local and global.)  If a variable is used in a '
           'code\n'
           'block but not defined there, it is a *free variable*.\n'
           '\n'
           'Each occurrence of a name in the program text refers to the '
           '*binding*\n'
           'of that name established by the following name resolution rules.\n'
           '\n'
           '\n'
           'Resolution of names\n'
           '===================\n'
           '\n'
           'A *scope* defines the visibility of a name within a block.  If a '
           'local\n'
           'variable is defined in a block, its scope includes that block.  If '
           'the\n'
           'definition occurs in a function block, the scope extends to any '
           'blocks\n'
           'contained within the defining one, unless a contained block '
           'introduces\n'
           'a different binding for the name.\n'
           '\n'
           'When a name is used in a code block, it is resolved using the '
           'nearest\n'
           'enclosing scope.  The set of all such scopes visible to a code '
           'block\n'
           'is called the block’s *environment*.\n'
           '\n'
           'When a name is not found at all, a "NameError" exception is '
           'raised. If\n'
           'the current scope is a function scope, and the name refers to a '
           'local\n'
           'variable that has not yet been bound to a value at the point where '
           'the\n'
           'name is used, an "UnboundLocalError" exception is raised.\n'
           '"UnboundLocalError" is a subclass of "NameError".\n'
           '\n'
           'If a name binding operation occurs anywhere within a code block, '
           'all\n'
           'uses of the name within the block are treated as references to '
           'the\n'
           'current block.  This can lead to errors when a name is used within '
           'a\n'
           'block before it is bound.  This rule is subtle.  Python lacks\n'
           'declarations and allows name binding operations to occur anywhere\n'
           'within a code block.  The local variables of a code block can be\n'
           'determined by scanning the entire text of the block for name '
           'binding\n'
           'operations. See the FAQ entry on UnboundLocalError for examples.\n'
           '\n'
           'If the "global" statement occurs within a block, all uses of the '
           'names\n'
           'specified in the statement refer to the bindings of those names in '
           'the\n'
           'top-level namespace.  Names are resolved in the top-level '
           'namespace by\n'
           'searching the global namespace, i.e. the namespace of the module\n'
           'containing the code block, and the builtins namespace, the '
           'namespace\n'
           'of the module "builtins".  The global namespace is searched '
           'first.  If\n'
           'the names are not found there, the builtins namespace is '
           'searched.\n'
           'The "global" statement must precede all uses of the listed names.\n'
           '\n'
           'The "global" statement has the same scope as a name binding '
           'operation\n'
           'in the same block.  If the nearest enclosing scope for a free '
           'variable\n'
           'contains a global statement, the free variable is treated as a '
           'global.\n'
           '\n'
           'The "nonlocal" statement causes corresponding names to refer to\n'
           'previously bound variables in the nearest enclosing function '
           'scope.\n'
           '"SyntaxError" is raised at compile time if the given name does '
           'not\n'
           'exist in any enclosing function scope.\n'
           '\n'
           'The namespace for a module is automatically created the first time '
           'a\n'
           'module is imported.  The main module for a script is always '
           'called\n'
           '"__main__".\n'
           '\n'
           'Class definition blocks and arguments to "exec()" and "eval()" '
           'are\n'
           'special in the context of name resolution. A class definition is '
           'an\n'
           'executable statement that may use and define names. These '
           'references\n'
           'follow the normal rules for name resolution with an exception '
           'that\n'
           'unbound local variables are looked up in the global namespace. '
           'The\n'
           'namespace of the class definition becomes the attribute dictionary '
           'of\n'
           'the class. The scope of names defined in a class block is limited '
           'to\n'
           'the class block; it does not extend to the code blocks of methods '
           '–\n'
           'this includes comprehensions and generator expressions since they '
           'are\n'
           'implemented using a function scope.  This means that the '
           'following\n'
           'will fail:\n'
           '\n'
           '   class A:\n'
           '       a = 42\n'
           '       b = list(a + i for i in range(10))\n'
           '\n'
           '\n'
           'Builtins and restricted execution\n'
           '=================================\n'
           '\n'
           '**CPython implementation detail:** Users should not touch\n'
           '"__builtins__"; it is strictly an implementation detail.  Users\n'
           'wanting to override values in the builtins namespace should '
           '"import"\n'
           'the "builtins" module and modify its attributes appropriately.\n'
           '\n'
           'The builtins namespace associated with the execution of a code '
           'block\n'
           'is actually found by looking up the name "__builtins__" in its '
           'global\n'
           'namespace; this should be a dictionary or a module (in the latter '
           'case\n'
           'the module’s dictionary is used).  By default, when in the '
           '"__main__"\n'
           'module, "__builtins__" is the built-in module "builtins"; when in '
           'any\n'
           'other module, "__builtins__" is an alias for the dictionary of '
           'the\n'
           '"builtins" module itself.\n'
           '\n'
           '\n'
           'Interaction with dynamic features\n'
           '=================================\n'
           '\n'
           'Name resolution of free variables occurs at runtime, not at '
           'compile\n'
           'time. This means that the following code will print 42:\n'
           '\n'
           '   i = 10\n'
           '   def f():\n'
           '       print(i)\n'
           '   i = 42\n'
           '   f()\n'
           '\n'
           'The "eval()" and "exec()" functions do not have access to the '
           'full\n'
           'environment for resolving names.  Names may be resolved in the '
           'local\n'
           'and global namespaces of the caller.  Free variables are not '
           'resolved\n'
           'in the nearest enclosing namespace, but in the global namespace.  '
           '[1]\n'
           'The "exec()" and "eval()" functions have optional arguments to\n'
           'override the global and local namespace.  If only one namespace '
           'is\n'
           'specified, it is used for both.\n',
 'nonlocal': 'The "nonlocal" statement\n'
             '************************\n'
             '\n'
             '   nonlocal_stmt ::= "nonlocal" identifier ("," identifier)*\n'
             '\n'
             'The "nonlocal" statement causes the listed identifiers to refer '
             'to\n'
             'previously bound variables in the nearest enclosing scope '
             'excluding\n'
             'globals. This is important because the default behavior for '
             'binding is\n'
             'to search the local namespace first.  The statement allows\n'
             'encapsulated code to rebind variables outside of the local '
             'scope\n'
             'besides the global (module) scope.\n'
             '\n'
             'Names listed in a "nonlocal" statement, unlike those listed in '
             'a\n'
             '"global" statement, must refer to pre-existing bindings in an\n'
             'enclosing scope (the scope in which a new binding should be '
             'created\n'
             'cannot be determined unambiguously).\n'
             '\n'
             'Names listed in a "nonlocal" statement must not collide with '
             'pre-\n'
             'existing bindings in the local scope.\n'
             '\n'
             'See also:\n'
             '\n'
             '  **PEP 3104** - Access to Names in Outer Scopes\n'
             '     The specification for the "nonlocal" statement.\n',
 'numbers': 'Numeric literals\n'
            '****************\n'
            '\n'
            'There are three types of numeric literals: integers, floating '
            'point\n'
            'numbers, and imaginary numbers.  There are no complex literals\n'
            '(complex numbers can be formed by adding a real number and an\n'
            'imaginary number).\n'
            '\n'
            'Note that numeric literals do not include a sign; a phrase like '
            '"-1"\n'
            'is actually an expression composed of the unary operator ‘"-"’ '
            'and the\n'
            'literal "1".\n',
 'numeric-types': 'Emulating numeric types\n'
                  '***********************\n'
                  '\n'
                  'The following methods can be defined to emulate numeric '
                  'objects.\n'
                  'Methods corresponding to operations that are not supported '
                  'by the\n'
                  'particular kind of number implemented (e.g., bitwise '
                  'operations for\n'
                  'non-integral numbers) should be left undefined.\n'
                  '\n'
                  'object.__add__(self, other)\n'
                  'object.__sub__(self, other)\n'
                  'object.__mul__(self, other)\n'
                  'object.__matmul__(self, other)\n'
                  'object.__truediv__(self, other)\n'
                  'object.__floordiv__(self, other)\n'
                  'object.__mod__(self, other)\n'
                  'object.__divmod__(self, other)\n'
                  'object.__pow__(self, other[, modulo])\n'
                  'object.__lshift__(self, other)\n'
                  'object.__rshift__(self, other)\n'
                  'object.__and__(self, other)\n'
                  'object.__xor__(self, other)\n'
                  'object.__or__(self, other)\n'
                  '\n'
                  '   These methods are called to implement the binary '
                  'arithmetic\n'
                  '   operations ("+", "-", "*", "@", "/", "//", "%", '
                  '"divmod()",\n'
                  '   "pow()", "**", "<<", ">>", "&", "^", "|").  For '
                  'instance, to\n'
                  '   evaluate the expression "x + y", where *x* is an '
                  'instance of a\n'
                  '   class that has an "__add__()" method, '
                  '"type(x).__add__(x, y)" is\n'
                  '   called.  The "__divmod__()" method should be the '
                  'equivalent to\n'
                  '   using "__floordiv__()" and "__mod__()"; it should not be '
                  'related to\n'
                  '   "__truediv__()".  Note that "__pow__()" should be '
                  'defined to accept\n'
                  '   an optional third argument if the ternary version of the '
                  'built-in\n'
                  '   "pow()" function is to be supported.\n'
                  '\n'
                  '   If one of those methods does not support the operation '
                  'with the\n'
                  '   supplied arguments, it should return "NotImplemented".\n'
                  '\n'
                  'object.__radd__(self, other)\n'
                  'object.__rsub__(self, other)\n'
                  'object.__rmul__(self, other)\n'
                  'object.__rmatmul__(self, other)\n'
                  'object.__rtruediv__(self, other)\n'
                  'object.__rfloordiv__(self, other)\n'
                  'object.__rmod__(self, other)\n'
                  'object.__rdivmod__(self, other)\n'
                  'object.__rpow__(self, other[, modulo])\n'
                  'object.__rlshift__(self, other)\n'
                  'object.__rrshift__(self, other)\n'
                  'object.__rand__(self, other)\n'
                  'object.__rxor__(self, other)\n'
                  'object.__ror__(self, other)\n'
                  '\n'
                  '   These methods are called to implement the binary '
                  'arithmetic\n'
                  '   operations ("+", "-", "*", "@", "/", "//", "%", '
                  '"divmod()",\n'
                  '   "pow()", "**", "<<", ">>", "&", "^", "|") with reflected '
                  '(swapped)\n'
                  '   operands.  These functions are only called if the left '
                  'operand does\n'
                  '   not support the corresponding operation [3] and the '
                  'operands are of\n'
                  '   different types. [4] For instance, to evaluate the '
                  'expression "x -\n'
                  '   y", where *y* is an instance of a class that has an '
                  '"__rsub__()"\n'
                  '   method, "type(y).__rsub__(y, x)" is called if '
                  '"type(x).__sub__(x,\n'
                  '   y)" returns *NotImplemented*.\n'
                  '\n'
                  '   Note that ternary "pow()" will not try calling '
                  '"__rpow__()" (the\n'
                  '   coercion rules would become too complicated).\n'
                  '\n'
                  '   Note:\n'
                  '\n'
                  '     If the right operand’s type is a subclass of the left '
                  'operand’s\n'
                  '     type and that subclass provides a different '
                  'implementation of the\n'
                  '     reflected method for the operation, this method will '
                  'be called\n'
                  '     before the left operand’s non-reflected method. This '
                  'behavior\n'
                  '     allows subclasses to override their ancestors’ '
                  'operations.\n'
                  '\n'
                  'object.__iadd__(self, other)\n'
                  'object.__isub__(self, other)\n'
                  'object.__imul__(self, other)\n'
                  'object.__imatmul__(self, other)\n'
                  'object.__itruediv__(self, other)\n'
                  'object.__ifloordiv__(self, other)\n'
                  'object.__imod__(self, other)\n'
                  'object.__ipow__(self, other[, modulo])\n'
                  'object.__ilshift__(self, other)\n'
                  'object.__irshift__(self, other)\n'
                  'object.__iand__(self, other)\n'
                  'object.__ixor__(self, other)\n'
                  'object.__ior__(self, other)\n'
                  '\n'
                  '   These methods are called to implement the augmented '
                  'arithmetic\n'
                  '   assignments ("+=", "-=", "*=", "@=", "/=", "//=", "%=", '
                  '"**=",\n'
                  '   "<<=", ">>=", "&=", "^=", "|=").  These methods should '
                  'attempt to\n'
                  '   do the operation in-place (modifying *self*) and return '
                  'the result\n'
                  '   (which could be, but does not have to be, *self*).  If a '
                  'specific\n'
                  '   method is not defined, the augmented assignment falls '
                  'back to the\n'
                  '   normal methods.  For instance, if *x* is an instance of '
                  'a class\n'
                  '   with an "__iadd__()" method, "x += y" is equivalent to '
                  '"x =\n'
                  '   x.__iadd__(y)" . Otherwise, "x.__add__(y)" and '
                  '"y.__radd__(x)" are\n'
                  '   considered, as with the evaluation of "x + y". In '
                  'certain\n'
                  '   situations, augmented assignment can result in '
                  'unexpected errors\n'
                  '   (see Why does a_tuple[i] += [‘item’] raise an exception '
                  'when the\n'
                  '   addition works?), but this behavior is in fact part of '
                  'the data\n'
                  '   model.\n'
                  '\n'
                  'object.__neg__(self)\n'
                  'object.__pos__(self)\n'
                  'object.__abs__(self)\n'
                  'object.__invert__(self)\n'
                  '\n'
                  '   Called to implement the unary arithmetic operations '
                  '("-", "+",\n'
                  '   "abs()" and "~").\n'
                  '\n'
                  'object.__complex__(self)\n'
                  'object.__int__(self)\n'
                  'object.__float__(self)\n'
                  '\n'
                  '   Called to implement the built-in functions "complex()", '
                  '"int()" and\n'
                  '   "float()".  Should return a value of the appropriate '
                  'type.\n'
                  '\n'
                  'object.__index__(self)\n'
                  '\n'
                  '   Called to implement "operator.index()", and whenever '
                  'Python needs\n'
                  '   to losslessly convert the numeric object to an integer '
                  'object (such\n'
                  '   as in slicing, or in the built-in "bin()", "hex()" and '
                  '"oct()"\n'
                  '   functions). Presence of this method indicates that the '
                  'numeric\n'
                  '   object is an integer type.  Must return an integer.\n'
                  '\n'
                  '   If "__int__()", "__float__()" and "__complex__()" are '
                  'not defined\n'
                  '   then corresponding built-in functions "int()", "float()" '
                  'and\n'
                  '   "complex()" fall back to "__index__()".\n'
                  '\n'
                  'object.__round__(self[, ndigits])\n'
                  'object.__trunc__(self)\n'
                  'object.__floor__(self)\n'
                  'object.__ceil__(self)\n'
                  '\n'
                  '   Called to implement the built-in function "round()" and '
                  '"math"\n'
                  '   functions "trunc()", "floor()" and "ceil()". Unless '
                  '*ndigits* is\n'
                  '   passed to "__round__()" all these methods should return '
                  'the value\n'
                  '   of the object truncated to an "Integral" (typically an '
                  '"int").\n'
                  '\n'
                  '   The built-in function "int()" falls back to '
                  '"__trunc__()" if\n'
                  '   neither "__int__()" nor "__index__()" is defined.\n'
                  '\n'
                  '   Changed in version 3.11: The delegation of "int()" to '
                  '"__trunc__()"\n'
                  '   is deprecated.\n',
 'objects': 'Objects, values and types\n'
            '*************************\n'
            '\n'
            '*Objects* are Python’s abstraction for data.  All data in a '
            'Python\n'
            'program is represented by objects or by relations between '
            'objects. (In\n'
            'a sense, and in conformance to Von Neumann’s model of a “stored\n'
            'program computer”, code is also represented by objects.)\n'
            '\n'
            'Every object has an identity, a type and a value.  An object’s\n'
            '*identity* never changes once it has been created; you may think '
            'of it\n'
            'as the object’s address in memory.  The ‘"is"’ operator compares '
            'the\n'
            'identity of two objects; the "id()" function returns an integer\n'
            'representing its identity.\n'
            '\n'
            '**CPython implementation detail:** For CPython, "id(x)" is the '
            'memory\n'
            'address where "x" is stored.\n'
            '\n'
            'An object’s type determines the operations that the object '
            'supports\n'
            '(e.g., “does it have a length?”) and also defines the possible '
            'values\n'
            'for objects of that type.  The "type()" function returns an '
            'object’s\n'
            'type (which is an object itself).  Like its identity, an '
            'object’s\n'
            '*type* is also unchangeable. [1]\n'
            '\n'
            'The *value* of some objects can change.  Objects whose value can\n'
            'change are said to be *mutable*; objects whose value is '
            'unchangeable\n'
            'once they are created are called *immutable*. (The value of an\n'
            'immutable container object that contains a reference to a '
            'mutable\n'
            'object can change when the latter’s value is changed; however '
            'the\n'
            'container is still considered immutable, because the collection '
            'of\n'
            'objects it contains cannot be changed.  So, immutability is not\n'
            'strictly the same as having an unchangeable value, it is more '
            'subtle.)\n'
            'An object’s mutability is determined by its type; for instance,\n'
            'numbers, strings and tuples are immutable, while dictionaries '
            'and\n'
            'lists are mutable.\n'
            '\n'
            'Objects are never explicitly destroyed; however, when they '
            'become\n'
            'unreachable they may be garbage-collected.  An implementation is\n'
            'allowed to postpone garbage collection or omit it altogether — it '
            'is a\n'
            'matter of implementation quality how garbage collection is\n'
            'implemented, as long as no objects are collected that are still\n'
            'reachable.\n'
            '\n'
            '**CPython implementation detail:** CPython currently uses a '
            'reference-\n'
            'counting scheme with (optional) delayed detection of cyclically '
            'linked\n'
            'garbage, which collects most objects as soon as they become\n'
            'unreachable, but is not guaranteed to collect garbage containing\n'
            'circular references.  See the documentation of the "gc" module '
            'for\n'
            'information on controlling the collection of cyclic garbage. '
            'Other\n'
            'implementations act differently and CPython may change. Do not '
            'depend\n'
            'on immediate finalization of objects when they become unreachable '
            '(so\n'
            'you should always close files explicitly).\n'
            '\n'
            'Note that the use of the implementation’s tracing or debugging\n'
            'facilities may keep objects alive that would normally be '
            'collectable.\n'
            'Also note that catching an exception with a ‘"try"…"except"’ '
            'statement\n'
            'may keep objects alive.\n'
            '\n'
            'Some objects contain references to “external” resources such as '
            'open\n'
            'files or windows.  It is understood that these resources are '
            'freed\n'
            'when the object is garbage-collected, but since garbage '
            'collection is\n'
            'not guaranteed to happen, such objects also provide an explicit '
            'way to\n'
            'release the external resource, usually a "close()" method. '
            'Programs\n'
            'are strongly recommended to explicitly close such objects.  The\n'
            '‘"try"…"finally"’ statement and the ‘"with"’ statement provide\n'
            'convenient ways to do this.\n'
            '\n'
            'Some objects contain references to other objects; these are '
            'called\n'
            '*containers*. Examples of containers are tuples, lists and\n'
            'dictionaries.  The references are part of a container’s value.  '
            'In\n'
            'most cases, when we talk about the value of a container, we imply '
            'the\n'
            'values, not the identities of the contained objects; however, '
            'when we\n'
            'talk about the mutability of a container, only the identities of '
            'the\n'
            'immediately contained objects are implied.  So, if an immutable\n'
            'container (like a tuple) contains a reference to a mutable '
            'object, its\n'
            'value changes if that mutable object is changed.\n'
            '\n'
            'Types affect almost all aspects of object behavior.  Even the\n'
            'importance of object identity is affected in some sense: for '
            'immutable\n'
            'types, operations that compute new values may actually return a\n'
            'reference to any existing object with the same type and value, '
            'while\n'
            'for mutable objects this is not allowed.  E.g., after "a = 1; b = '
            '1",\n'
            '"a" and "b" may or may not refer to the same object with the '
            'value\n'
            'one, depending on the implementation, but after "c = []; d = []", '
            '"c"\n'
            'and "d" are guaranteed to refer to two different, unique, newly\n'
            'created empty lists. (Note that "c = d = []" assigns the same '
            'object\n'
            'to both "c" and "d".)\n',
 'operator-summary': 'Operator precedence\n'
                     '*******************\n'
                     '\n'
                     'The following table summarizes the operator precedence '
                     'in Python, from\n'
                     'highest precedence (most binding) to lowest precedence '
                     '(least\n'
                     'binding).  Operators in the same box have the same '
                     'precedence.  Unless\n'
                     'the syntax is explicitly given, operators are binary.  '
                     'Operators in\n'
                     'the same box group left to right (except for '
                     'exponentiation and\n'
                     'conditional expressions, which group from right to '
                     'left).\n'
                     '\n'
                     'Note that comparisons, membership tests, and identity '
                     'tests, all have\n'
                     'the same precedence and have a left-to-right chaining '
                     'feature as\n'
                     'described in the Comparisons section.\n'
                     '\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| Operator                                        | '
                     'Description                           |\n'
                     '|=================================================|=======================================|\n'
                     '| "(expressions...)",  "[expressions...]", "{key: | '
                     'Binding or parenthesized expression,  |\n'
                     '| value...}", "{expressions...}"                  | list '
                     'display, dictionary display, set |\n'
                     '|                                                 | '
                     'display                               |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "x[index]", "x[index:index]",                   | '
                     'Subscription, slicing, call,          |\n'
                     '| "x(arguments...)", "x.attribute"                | '
                     'attribute reference                   |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "await x"                                       | '
                     'Await expression                      |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "**"                                            | '
                     'Exponentiation [5]                    |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "+x", "-x", "~x"                                | '
                     'Positive, negative, bitwise NOT       |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "*", "@", "/", "//", "%"                        | '
                     'Multiplication, matrix                |\n'
                     '|                                                 | '
                     'multiplication, division, floor       |\n'
                     '|                                                 | '
                     'division, remainder [6]               |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "+", "-"                                        | '
                     'Addition and subtraction              |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "<<", ">>"                                      | '
                     'Shifts                                |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "&"                                             | '
                     'Bitwise AND                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "^"                                             | '
                     'Bitwise XOR                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "|"                                             | '
                     'Bitwise OR                            |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "in", "not in", "is", "is not", "<", "<=", ">", | '
                     'Comparisons, including membership     |\n'
                     '| ">=", "!=", "=="                                | '
                     'tests and identity tests              |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "not x"                                         | '
                     'Boolean NOT                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "and"                                           | '
                     'Boolean AND                           |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "or"                                            | '
                     'Boolean OR                            |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "if" – "else"                                   | '
                     'Conditional expression                |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| "lambda"                                        | '
                     'Lambda expression                     |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '| ":="                                            | '
                     'Assignment expression                 |\n'
                     '+-------------------------------------------------+---------------------------------------+\n'
                     '\n'
                     '-[ Footnotes ]-\n'
                     '\n'
                     '[1] While "abs(x%y) < abs(y)" is true mathematically, '
                     'for floats it\n'
                     '    may not be true numerically due to roundoff.  For '
                     'example, and\n'
                     '    assuming a platform on which a Python float is an '
                     'IEEE 754 double-\n'
                     '    precision number, in order that "-1e-100 % 1e100" '
                     'have the same\n'
                     '    sign as "1e100", the computed result is "-1e-100 + '
                     '1e100", which\n'
                     '    is numerically exactly equal to "1e100".  The '
                     'function\n'
                     '    "math.fmod()" returns a result whose sign matches '
                     'the sign of the\n'
                     '    first argument instead, and so returns "-1e-100" in '
                     'this case.\n'
                     '    Which approach is more appropriate depends on the '
                     'application.\n'
                     '\n'
                     '[2] If x is very close to an exact integer multiple of '
                     'y, it’s\n'
                     '    possible for "x//y" to be one larger than '
                     '"(x-x%y)//y" due to\n'
                     '    rounding.  In such cases, Python returns the latter '
                     'result, in\n'
                     '    order to preserve that "divmod(x,y)[0] * y + x % y" '
                     'be very close\n'
                     '    to "x".\n'
                     '\n'
                     '[3] The Unicode standard distinguishes between *code '
                     'points* (e.g.\n'
                     '    U+0041) and *abstract characters* (e.g. “LATIN '
                     'CAPITAL LETTER A”).\n'
                     '    While most abstract characters in Unicode are only '
                     'represented\n'
                     '    using one code point, there is a number of abstract '
                     'characters\n'
                     '    that can in addition be represented using a sequence '
                     'of more than\n'
                     '    one code point.  For example, the abstract character '
                     '“LATIN\n'
                     '    CAPITAL LETTER C WITH CEDILLA” can be represented as '
                     'a single\n'
                     '    *precomposed character* at code position U+00C7, or '
                     'as a sequence\n'
                     '    of a *base character* at code position U+0043 (LATIN '
                     'CAPITAL\n'
                     '    LETTER C), followed by a *combining character* at '
                     'code position\n'
                     '    U+0327 (COMBINING CEDILLA).\n'
                     '\n'
                     '    The comparison operators on strings compare at the '
                     'level of\n'
                     '    Unicode code points. This may be counter-intuitive '
                     'to humans.  For\n'
                     '    example, ""\\u00C7" == "\\u0043\\u0327"" is "False", '
                     'even though both\n'
                     '    strings represent the same abstract character “LATIN '
                     'CAPITAL\n'
                     '    LETTER C WITH CEDILLA”.\n'
                     '\n'
                     '    To compare strings at the level of abstract '
                     'characters (that is,\n'
                     '    in a way intuitive to humans), use '
                     '"unicodedata.normalize()".\n'
                     '\n'
                     '[4] Due to automatic garbage-collection, free lists, and '
                     'the dynamic\n'
                     '    nature of descriptors, you may notice seemingly '
                     'unusual behaviour\n'
                     '    in certain uses of the "is" operator, like those '
                     'involving\n'
                     '    comparisons between instance methods, or constants.  '
                     'Check their\n'
                     '    documentation for more info.\n'
                     '\n'
                     '[5] The power operator "**" binds less tightly than an '
                     'arithmetic or\n'
                     '    bitwise unary operator on its right, that is, '
                     '"2**-1" is "0.5".\n'
                     '\n'
                     '[6] The "%" operator is also used for string formatting; '
                     'the same\n'
                     '    precedence applies.\n',
 'pass': 'The "pass" statement\n'
         '********************\n'
         '\n'
         '   pass_stmt ::= "pass"\n'
         '\n'
         '"pass" is a null operation — when it is executed, nothing happens. '
         'It\n'
         'is useful as a placeholder when a statement is required '
         'syntactically,\n'
         'but no code needs to be executed, for example:\n'
         '\n'
         '   def f(arg): pass    # a function that does nothing (yet)\n'
         '\n'
         '   class C: pass       # a class with no methods (yet)\n',
 'power': 'The power operator\n'
          '******************\n'
          '\n'
          'The power operator binds more tightly than unary operators on its\n'
          'left; it binds less tightly than unary operators on its right.  '
          'The\n'
          'syntax is:\n'
          '\n'
          '   power ::= (await_expr | primary) ["**" u_expr]\n'
          '\n'
          'Thus, in an unparenthesized sequence of power and unary operators, '
          'the\n'
          'operators are evaluated from right to left (this does not '
          'constrain\n'
          'the evaluation order for the operands): "-1**2" results in "-1".\n'
          '\n'
          'The power operator has the same semantics as the built-in "pow()"\n'
          'function, when called with two arguments: it yields its left '
          'argument\n'
          'raised to the power of its right argument.  The numeric arguments '
          'are\n'
          'first converted to a common type, and the result is of that type.\n'
          '\n'
          'For int operands, the result has the same type as the operands '
          'unless\n'
          'the second argument is negative; in that case, all arguments are\n'
          'converted to float and a float result is delivered. For example,\n'
          '"10**2" returns "100", but "10**-2" returns "0.01".\n'
          '\n'
          'Raising "0.0" to a negative power results in a '
          '"ZeroDivisionError".\n'
          'Raising a negative number to a fractional power results in a '
          '"complex"\n'
          'number. (In earlier versions it raised a "ValueError".)\n'
          '\n'
          'This operation can be customized using the special "__pow__()" '
          'method.\n',
 'raise': 'The "raise" statement\n'
          '*********************\n'
          '\n'
          '   raise_stmt ::= "raise" [expression ["from" expression]]\n'
          '\n'
          'If no expressions are present, "raise" re-raises the exception that '
          'is\n'
          'currently being handled, which is also known as the *active\n'
          'exception*. If there isn’t currently an active exception, a\n'
          '"RuntimeError" exception is raised indicating that this is an '
          'error.\n'
          '\n'
          'Otherwise, "raise" evaluates the first expression as the exception\n'
          'object.  It must be either a subclass or an instance of\n'
          '"BaseException". If it is a class, the exception instance will be\n'
          'obtained when needed by instantiating the class with no arguments.\n'
          '\n'
          'The *type* of the exception is the exception instance’s class, the\n'
          '*value* is the instance itself.\n'
          '\n'
          'A traceback object is normally created automatically when an '
          'exception\n'
          'is raised and attached to it as the "__traceback__" attribute. You '
          'can\n'
          'create an exception and set your own traceback in one step using '
          'the\n'
          '"with_traceback()" exception method (which returns the same '
          'exception\n'
          'instance, with its traceback set to its argument), like so:\n'
          '\n'
          '   raise Exception("foo occurred").with_traceback(tracebackobj)\n'
          '\n'
          'The "from" clause is used for exception chaining: if given, the '
          'second\n'
          '*expression* must be another exception class or instance. If the\n'
          'second expression is an exception instance, it will be attached to '
          'the\n'
          'raised exception as the "__cause__" attribute (which is writable). '
          'If\n'
          'the expression is an exception class, the class will be '
          'instantiated\n'
          'and the resulting exception instance will be attached to the '
          'raised\n'
          'exception as the "__cause__" attribute. If the raised exception is '
          'not\n'
          'handled, both exceptions will be printed:\n'
          '\n'
          '   >>> try:\n'
          '   ...     print(1 / 0)\n'
          '   ... except Exception as exc:\n'
          '   ...     raise RuntimeError("Something bad happened") from exc\n'
          '   ...\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 2, in <module>\n'
          '       print(1 / 0)\n'
          '             ~~^~~\n'
          '   ZeroDivisionError: division by zero\n'
          '\n'
          '   The above exception was the direct cause of the following '
          'exception:\n'
          '\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 4, in <module>\n'
          '       raise RuntimeError("Something bad happened") from exc\n'
          '   RuntimeError: Something bad happened\n'
          '\n'
          'A similar mechanism works implicitly if a new exception is raised '
          'when\n'
          'an exception is already being handled.  An exception may be '
          'handled\n'
          'when an "except" or "finally" clause, or a "with" statement, is '
          'used.\n'
          'The previous exception is then attached as the new exception’s\n'
          '"__context__" attribute:\n'
          '\n'
          '   >>> try:\n'
          '   ...     print(1 / 0)\n'
          '   ... except:\n'
          '   ...     raise RuntimeError("Something bad happened")\n'
          '   ...\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 2, in <module>\n'
          '       print(1 / 0)\n'
          '             ~~^~~\n'
          '   ZeroDivisionError: division by zero\n'
          '\n'
          '   During handling of the above exception, another exception '
          'occurred:\n'
          '\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 4, in <module>\n'
          '       raise RuntimeError("Something bad happened")\n'
          '   RuntimeError: Something bad happened\n'
          '\n'
          'Exception chaining can be explicitly suppressed by specifying '
          '"None"\n'
          'in the "from" clause:\n'
          '\n'
          '   >>> try:\n'
          '   ...     print(1 / 0)\n'
          '   ... except:\n'
          '   ...     raise RuntimeError("Something bad happened") from None\n'
          '   ...\n'
          '   Traceback (most recent call last):\n'
          '     File "<stdin>", line 4, in <module>\n'
          '   RuntimeError: Something bad happened\n'
          '\n'
          'Additional information on exceptions can be found in section\n'
          'Exceptions, and information about handling exceptions is in '
          'section\n'
          'The try statement.\n'
          '\n'
          'Changed in version 3.3: "None" is now permitted as "Y" in "raise X\n'
          'from Y".\n'
          '\n'
          'New in version 3.3: The "__suppress_context__" attribute to '
          'suppress\n'
          'automatic display of the exception context.\n'
          '\n'
          'Changed in version 3.11: If the traceback of the active exception '
          'is\n'
          'modified in an "except" clause, a subsequent "raise" statement re-\n'
          'raises the exception with the modified traceback. Previously, the\n'
          'exception was re-raised with the traceback it had when it was '
          'caught.\n',
 'return': 'The "return" statement\n'
           '**********************\n'
           '\n'
           '   return_stmt ::= "return" [expression_list]\n'
           '\n'
           '"return" may only occur syntactically nested in a function '
           'definition,\n'
           'not within a nested class definition.\n'
           '\n'
           'If an expression list is present, it is evaluated, else "None" is\n'
           'substituted.\n'
           '\n'
           '"return" leaves the current function call with the expression list '
           '(or\n'
           '"None") as return value.\n'
           '\n'
           'When "return" passes control out of a "try" statement with a '
           '"finally"\n'
           'clause, that "finally" clause is executed before really leaving '
           'the\n'
           'function.\n'
           '\n'
           'In a generator function, the "return" statement indicates that '
           'the\n'
           'generator is done and will cause "StopIteration" to be raised. '
           'The\n'
           'returned value (if any) is used as an argument to construct\n'
           '"StopIteration" and becomes the "StopIteration.value" attribute.\n'
           '\n'
           'In an asynchronous generator function, an empty "return" '
           'statement\n'
           'indicates that the asynchronous generator is done and will cause\n'
           '"StopAsyncIteration" to be raised.  A non-empty "return" statement '
           'is\n'
           'a syntax error in an asynchronous generator function.\n',
 'sequence-types': 'Emulating container types\n'
                   '*************************\n'
                   '\n'
                   'The following methods can be defined to implement '
                   'container objects.\n'
                   'Containers usually are *sequences* (such as "lists" or '
                   '"tuples") or\n'
                   '*mappings* (like "dictionaries"), but can represent other '
                   'containers\n'
                   'as well.  The first set of methods is used either to '
                   'emulate a\n'
                   'sequence or to emulate a mapping; the difference is that '
                   'for a\n'
                   'sequence, the allowable keys should be the integers *k* '
                   'for which "0\n'
                   '<= k < N" where *N* is the length of the sequence, or '
                   '"slice" objects,\n'
                   'which define a range of items.  It is also recommended '
                   'that mappings\n'
                   'provide the methods "keys()", "values()", "items()", '
                   '"get()",\n'
                   '"clear()", "setdefault()", "pop()", "popitem()", "copy()", '
                   'and\n'
                   '"update()" behaving similar to those for Python’s '
                   'standard\n'
                   '"dictionary" objects.  The "collections.abc" module '
                   'provides a\n'
                   '"MutableMapping" *abstract base class* to help create '
                   'those methods\n'
                   'from a base set of "__getitem__()", "__setitem__()", '
                   '"__delitem__()",\n'
                   'and "keys()". Mutable sequences should provide methods '
                   '"append()",\n'
                   '"count()", "index()", "extend()", "insert()", "pop()", '
                   '"remove()",\n'
                   '"reverse()" and "sort()", like Python standard "list" '
                   'objects.\n'
                   'Finally, sequence types should implement addition '
                   '(meaning\n'
                   'concatenation) and multiplication (meaning repetition) by '
                   'defining the\n'
                   'methods "__add__()", "__radd__()", "__iadd__()", '
                   '"__mul__()",\n'
                   '"__rmul__()" and "__imul__()" described below; they should '
                   'not define\n'
                   'other numerical operators.  It is recommended that both '
                   'mappings and\n'
                   'sequences implement the "__contains__()" method to allow '
                   'efficient use\n'
                   'of the "in" operator; for mappings, "in" should search the '
                   'mapping’s\n'
                   'keys; for sequences, it should search through the values.  '
                   'It is\n'
                   'further recommended that both mappings and sequences '
                   'implement the\n'
                   '"__iter__()" method to allow efficient iteration through '
                   'the\n'
                   'container; for mappings, "__iter__()" should iterate '
                   'through the\n'
                   'object’s keys; for sequences, it should iterate through '
                   'the values.\n'
                   '\n'
                   'object.__len__(self)\n'
                   '\n'
                   '   Called to implement the built-in function "len()".  '
                   'Should return\n'
                   '   the length of the object, an integer ">=" 0.  Also, an '
                   'object that\n'
                   '   doesn’t define a "__bool__()" method and whose '
                   '"__len__()" method\n'
                   '   returns zero is considered to be false in a Boolean '
                   'context.\n'
                   '\n'
                   '   **CPython implementation detail:** In CPython, the '
                   'length is\n'
                   '   required to be at most "sys.maxsize". If the length is '
                   'larger than\n'
                   '   "sys.maxsize" some features (such as "len()") may '
                   'raise\n'
                   '   "OverflowError".  To prevent raising "OverflowError" by '
                   'truth value\n'
                   '   testing, an object must define a "__bool__()" method.\n'
                   '\n'
                   'object.__length_hint__(self)\n'
                   '\n'
                   '   Called to implement "operator.length_hint()". Should '
                   'return an\n'
                   '   estimated length for the object (which may be greater '
                   'or less than\n'
                   '   the actual length). The length must be an integer ">=" '
                   '0. The\n'
                   '   return value may also be "NotImplemented", which is '
                   'treated the\n'
                   '   same as if the "__length_hint__" method didn’t exist at '
                   'all. This\n'
                   '   method is purely an optimization and is never required '
                   'for\n'
                   '   correctness.\n'
                   '\n'
                   '   New in version 3.4.\n'
                   '\n'
                   'Note:\n'
                   '\n'
                   '  Slicing is done exclusively with the following three '
                   'methods.  A\n'
                   '  call like\n'
                   '\n'
                   '     a[1:2] = b\n'
                   '\n'
                   '  is translated to\n'
                   '\n'
                   '     a[slice(1, 2, None)] = b\n'
                   '\n'
                   '  and so forth.  Missing slice items are always filled in '
                   'with "None".\n'
                   '\n'
                   'object.__getitem__(self, key)\n'
                   '\n'
                   '   Called to implement evaluation of "self[key]". For '
                   '*sequence*\n'
                   '   types, the accepted keys should be integers. '
                   'Optionally, they may\n'
                   '   support "slice" objects as well.  Negative index '
                   'support is also\n'
                   '   optional. If *key* is of an inappropriate type, '
                   '"TypeError" may be\n'
                   '   raised; if *key* is a value outside the set of indexes '
                   'for the\n'
                   '   sequence (after any special interpretation of negative '
                   'values),\n'
                   '   "IndexError" should be raised. For *mapping* types, if '
                   '*key* is\n'
                   '   missing (not in the container), "KeyError" should be '
                   'raised.\n'
                   '\n'
                   '   Note:\n'
                   '\n'
                   '     "for" loops expect that an "IndexError" will be '
                   'raised for\n'
                   '     illegal indexes to allow proper detection of the end '
                   'of the\n'
                   '     sequence.\n'
                   '\n'
                   '   Note:\n'
                   '\n'
                   '     When subscripting a *class*, the special class '
                   'method\n'
                   '     "__class_getitem__()" may be called instead of '
                   '"__getitem__()".\n'
                   '     See __class_getitem__ versus __getitem__ for more '
                   'details.\n'
                   '\n'
                   'object.__setitem__(self, key, value)\n'
                   '\n'
                   '   Called to implement assignment to "self[key]".  Same '
                   'note as for\n'
                   '   "__getitem__()".  This should only be implemented for '
                   'mappings if\n'
                   '   the objects support changes to the values for keys, or '
                   'if new keys\n'
                   '   can be added, or for sequences if elements can be '
                   'replaced.  The\n'
                   '   same exceptions should be raised for improper *key* '
                   'values as for\n'
                   '   the "__getitem__()" method.\n'
                   '\n'
                   'object.__delitem__(self, key)\n'
                   '\n'
                   '   Called to implement deletion of "self[key]".  Same note '
                   'as for\n'
                   '   "__getitem__()".  This should only be implemented for '
                   'mappings if\n'
                   '   the objects support removal of keys, or for sequences '
                   'if elements\n'
                   '   can be removed from the sequence.  The same exceptions '
                   'should be\n'
                   '   raised for improper *key* values as for the '
                   '"__getitem__()" method.\n'
                   '\n'
                   'object.__missing__(self, key)\n'
                   '\n'
                   '   Called by "dict"."__getitem__()" to implement '
                   '"self[key]" for dict\n'
                   '   subclasses when key is not in the dictionary.\n'
                   '\n'
                   'object.__iter__(self)\n'
                   '\n'
                   '   This method is called when an *iterator* is required '
                   'for a\n'
                   '   container. This method should return a new iterator '
                   'object that can\n'
                   '   iterate over all the objects in the container.  For '
                   'mappings, it\n'
                   '   should iterate over the keys of the container.\n'
                   '\n'
                   'object.__reversed__(self)\n'
                   '\n'
                   '   Called (if present) by the "reversed()" built-in to '
                   'implement\n'
                   '   reverse iteration.  It should return a new iterator '
                   'object that\n'
                   '   iterates over all the objects in the container in '
                   'reverse order.\n'
                   '\n'
                   '   If the "__reversed__()" method is not provided, the '
                   '"reversed()"\n'
                   '   built-in will fall back to using the sequence protocol '
                   '("__len__()"\n'
                   '   and "__getitem__()").  Objects that support the '
                   'sequence protocol\n'
                   '   should only provide "__reversed__()" if they can '
                   'provide an\n'
                   '   implementation that is more efficient than the one '
                   'provided by\n'
                   '   "reversed()".\n'
                   '\n'
                   'The membership test operators ("in" and "not in") are '
                   'normally\n'
                   'implemented as an iteration through a container. However, '
                   'container\n'
                   'objects can supply the following special method with a '
                   'more efficient\n'
                   'implementation, which also does not require the object be '
                   'iterable.\n'
                   '\n'
                   'object.__contains__(self, item)\n'
                   '\n'
                   '   Called to implement membership test operators.  Should '
                   'return true\n'
                   '   if *item* is in *self*, false otherwise.  For mapping '
                   'objects, this\n'
                   '   should consider the keys of the mapping rather than the '
                   'values or\n'
                   '   the key-item pairs.\n'
                   '\n'
                   '   For objects that don’t define "__contains__()", the '
                   'membership test\n'
                   '   first tries iteration via "__iter__()", then the old '
                   'sequence\n'
                   '   iteration protocol via "__getitem__()", see this '
                   'section in the\n'
                   '   language reference.\n',
 'shifting': 'Shifting operations\n'
             '*******************\n'
             '\n'
             'The shifting operations have lower priority than the arithmetic\n'
             'operations:\n'
             '\n'
             '   shift_expr ::= a_expr | shift_expr ("<<" | ">>") a_expr\n'
             '\n'
             'These operators accept integers as arguments.  They shift the '
             'first\n'
             'argument to the left or right by the number of bits given by '
             'the\n'
             'second argument.\n'
             '\n'
             'This operation can be customized using the special '
             '"__lshift__()" and\n'
             '"__rshift__()" methods.\n'
             '\n'
             'A right shift by *n* bits is defined as floor division by '
             '"pow(2,n)".\n'
             'A left shift by *n* bits is defined as multiplication with '
             '"pow(2,n)".\n',
 'slicings': 'Slicings\n'
             '********\n'
             '\n'
             'A slicing selects a range of items in a sequence object (e.g., '
             'a\n'
             'string, tuple or list).  Slicings may be used as expressions or '
             'as\n'
             'targets in assignment or "del" statements.  The syntax for a '
             'slicing:\n'
             '\n'
             '   slicing      ::= primary "[" slice_list "]"\n'
             '   slice_list   ::= slice_item ("," slice_item)* [","]\n'
             '   slice_item   ::= expression | proper_slice\n'
             '   proper_slice ::= [lower_bound] ":" [upper_bound] [ ":" '
             '[stride] ]\n'
             '   lower_bound  ::= expression\n'
             '   upper_bound  ::= expression\n'
             '   stride       ::= expression\n'
             '\n'
             'There is ambiguity in the formal syntax here: anything that '
             'looks like\n'
             'an expression list also looks like a slice list, so any '
             'subscription\n'
             'can be interpreted as a slicing.  Rather than further '
             'complicating the\n'
             'syntax, this is disambiguated by defining that in this case the\n'
             'interpretation as a subscription takes priority over the\n'
             'interpretation as a slicing (this is the case if the slice list\n'
             'contains no proper slice).\n'
             '\n'
             'The semantics for a slicing are as follows.  The primary is '
             'indexed\n'
             '(using the same "__getitem__()" method as normal subscription) '
             'with a\n'
             'key that is constructed from the slice list, as follows.  If the '
             'slice\n'
             'list contains at least one comma, the key is a tuple containing '
             'the\n'
             'conversion of the slice items; otherwise, the conversion of the '
             'lone\n'
             'slice item is the key.  The conversion of a slice item that is '
             'an\n'
             'expression is that expression.  The conversion of a proper slice '
             'is a\n'
             'slice object (see section The standard type hierarchy) whose '
             '"start",\n'
             '"stop" and "step" attributes are the values of the expressions '
             'given\n'
             'as lower bound, upper bound and stride, respectively, '
             'substituting\n'
             '"None" for missing expressions.\n',
 'specialattrs': 'Special Attributes\n'
                 '******************\n'
                 '\n'
                 'The implementation adds a few special read-only attributes '
                 'to several\n'
                 'object types, where they are relevant.  Some of these are '
                 'not reported\n'
                 'by the "dir()" built-in function.\n'
                 '\n'
                 'object.__dict__\n'
                 '\n'
                 '   A dictionary or other mapping object used to store an '
                 'object’s\n'
                 '   (writable) attributes.\n'
                 '\n'
                 'instance.__class__\n'
                 '\n'
                 '   The class to which a class instance belongs.\n'
                 '\n'
                 'class.__bases__\n'
                 '\n'
                 '   The tuple of base classes of a class object.\n'
                 '\n'
                 'definition.__name__\n'
                 '\n'
                 '   The name of the class, function, method, descriptor, or '
                 'generator\n'
                 '   instance.\n'
                 '\n'
                 'definition.__qualname__\n'
                 '\n'
                 '   The *qualified name* of the class, function, method, '
                 'descriptor, or\n'
                 '   generator instance.\n'
                 '\n'
                 '   New in version 3.3.\n'
                 '\n'
                 'class.__mro__\n'
                 '\n'
                 '   This attribute is a tuple of classes that are considered '
                 'when\n'
                 '   looking for base classes during method resolution.\n'
                 '\n'
                 'class.mro()\n'
                 '\n'
                 '   This method can be overridden by a metaclass to customize '
                 'the\n'
                 '   method resolution order for its instances.  It is called '
                 'at class\n'
                 '   instantiation, and its result is stored in "__mro__".\n'
                 '\n'
                 'class.__subclasses__()\n'
                 '\n'
                 '   Each class keeps a list of weak references to its '
                 'immediate\n'
                 '   subclasses.  This method returns a list of all those '
                 'references\n'
                 '   still alive.  The list is in definition order.  Example:\n'
                 '\n'
                 '      >>> int.__subclasses__()\n'
                 "      [<class 'bool'>, <enum 'IntEnum'>, <flag 'IntFlag'>, "
                 "<class 're._constants._NamedIntConstant'>]\n",
 'specialnames': 'Special method names\n'
                 '********************\n'
                 '\n'
                 'A class can implement certain operations that are invoked by '
                 'special\n'
                 'syntax (such as arithmetic operations or subscripting and '
                 'slicing) by\n'
                 'defining methods with special names. This is Python’s '
                 'approach to\n'
                 '*operator overloading*, allowing classes to define their own '
                 'behavior\n'
                 'with respect to language operators.  For instance, if a '
                 'class defines\n'
                 'a method named "__getitem__()", and "x" is an instance of '
                 'this class,\n'
                 'then "x[i]" is roughly equivalent to "type(x).__getitem__(x, '
                 'i)".\n'
                 'Except where mentioned, attempts to execute an operation '
                 'raise an\n'
                 'exception when no appropriate method is defined (typically\n'
                 '"AttributeError" or "TypeError").\n'
                 '\n'
                 'Setting a special method to "None" indicates that the '
                 'corresponding\n'
                 'operation is not available.  For example, if a class sets '
                 '"__iter__()"\n'
                 'to "None", the class is not iterable, so calling "iter()" on '
                 'its\n'
                 'instances will raise a "TypeError" (without falling back to\n'
                 '"__getitem__()"). [2]\n'
                 '\n'
                 'When implementing a class that emulates any built-in type, '
                 'it is\n'
                 'important that the emulation only be implemented to the '
                 'degree that it\n'
                 'makes sense for the object being modelled.  For example, '
                 'some\n'
                 'sequences may work well with retrieval of individual '
                 'elements, but\n'
                 'extracting a slice may not make sense.  (One example of this '
                 'is the\n'
                 '"NodeList" interface in the W3C’s Document Object Model.)\n'
                 '\n'
                 '\n'
                 'Basic customization\n'
                 '===================\n'
                 '\n'
                 'object.__new__(cls[, ...])\n'
                 '\n'
                 '   Called to create a new instance of class *cls*.  '
                 '"__new__()" is a\n'
                 '   static method (special-cased so you need not declare it '
                 'as such)\n'
                 '   that takes the class of which an instance was requested '
                 'as its\n'
                 '   first argument.  The remaining arguments are those passed '
                 'to the\n'
                 '   object constructor expression (the call to the class).  '
                 'The return\n'
                 '   value of "__new__()" should be the new object instance '
                 '(usually an\n'
                 '   instance of *cls*).\n'
                 '\n'
                 '   Typical implementations create a new instance of the '
                 'class by\n'
                 '   invoking the superclass’s "__new__()" method using\n'
                 '   "super().__new__(cls[, ...])" with appropriate arguments '
                 'and then\n'
                 '   modifying the newly created instance as necessary before '
                 'returning\n'
                 '   it.\n'
                 '\n'
                 '   If "__new__()" is invoked during object construction and '
                 'it returns\n'
                 '   an instance of *cls*, then the new instance’s '
                 '"__init__()" method\n'
                 '   will be invoked like "__init__(self[, ...])", where '
                 '*self* is the\n'
                 '   new instance and the remaining arguments are the same as '
                 'were\n'
                 '   passed to the object constructor.\n'
                 '\n'
                 '   If "__new__()" does not return an instance of *cls*, then '
                 'the new\n'
                 '   instance’s "__init__()" method will not be invoked.\n'
                 '\n'
                 '   "__new__()" is intended mainly to allow subclasses of '
                 'immutable\n'
                 '   types (like int, str, or tuple) to customize instance '
                 'creation.  It\n'
                 '   is also commonly overridden in custom metaclasses in '
                 'order to\n'
                 '   customize class creation.\n'
                 '\n'
                 'object.__init__(self[, ...])\n'
                 '\n'
                 '   Called after the instance has been created (by '
                 '"__new__()"), but\n'
                 '   before it is returned to the caller.  The arguments are '
                 'those\n'
                 '   passed to the class constructor expression.  If a base '
                 'class has an\n'
                 '   "__init__()" method, the derived class’s "__init__()" '
                 'method, if\n'
                 '   any, must explicitly call it to ensure proper '
                 'initialization of the\n'
                 '   base class part of the instance; for example:\n'
                 '   "super().__init__([args...])".\n'
                 '\n'
                 '   Because "__new__()" and "__init__()" work together in '
                 'constructing\n'
                 '   objects ("__new__()" to create it, and "__init__()" to '
                 'customize\n'
                 '   it), no non-"None" value may be returned by "__init__()"; '
                 'doing so\n'
                 '   will cause a "TypeError" to be raised at runtime.\n'
                 '\n'
                 'object.__del__(self)\n'
                 '\n'
                 '   Called when the instance is about to be destroyed.  This '
                 'is also\n'
                 '   called a finalizer or (improperly) a destructor.  If a '
                 'base class\n'
                 '   has a "__del__()" method, the derived class’s "__del__()" '
                 'method,\n'
                 '   if any, must explicitly call it to ensure proper deletion '
                 'of the\n'
                 '   base class part of the instance.\n'
                 '\n'
                 '   It is possible (though not recommended!) for the '
                 '"__del__()" method\n'
                 '   to postpone destruction of the instance by creating a new '
                 'reference\n'
                 '   to it.  This is called object *resurrection*.  It is\n'
                 '   implementation-dependent whether "__del__()" is called a '
                 'second\n'
                 '   time when a resurrected object is about to be destroyed; '
                 'the\n'
                 '   current *CPython* implementation only calls it once.\n'
                 '\n'
                 '   It is not guaranteed that "__del__()" methods are called '
                 'for\n'
                 '   objects that still exist when the interpreter exits.\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     "del x" doesn’t directly call "x.__del__()" — the '
                 'former\n'
                 '     decrements the reference count for "x" by one, and the '
                 'latter is\n'
                 '     only called when "x"’s reference count reaches zero.\n'
                 '\n'
                 '   **CPython implementation detail:** It is possible for a '
                 'reference\n'
                 '   cycle to prevent the reference count of an object from '
                 'going to\n'
                 '   zero.  In this case, the cycle will be later detected and '
                 'deleted\n'
                 '   by the *cyclic garbage collector*.  A common cause of '
                 'reference\n'
                 '   cycles is when an exception has been caught in a local '
                 'variable.\n'
                 '   The frame’s locals then reference the exception, which '
                 'references\n'
                 '   its own traceback, which references the locals of all '
                 'frames caught\n'
                 '   in the traceback.\n'
                 '\n'
                 '   See also: Documentation for the "gc" module.\n'
                 '\n'
                 '   Warning:\n'
                 '\n'
                 '     Due to the precarious circumstances under which '
                 '"__del__()"\n'
                 '     methods are invoked, exceptions that occur during their '
                 'execution\n'
                 '     are ignored, and a warning is printed to "sys.stderr" '
                 'instead.\n'
                 '     In particular:\n'
                 '\n'
                 '     * "__del__()" can be invoked when arbitrary code is '
                 'being\n'
                 '       executed, including from any arbitrary thread.  If '
                 '"__del__()"\n'
                 '       needs to take a lock or invoke any other blocking '
                 'resource, it\n'
                 '       may deadlock as the resource may already be taken by '
                 'the code\n'
                 '       that gets interrupted to execute "__del__()".\n'
                 '\n'
                 '     * "__del__()" can be executed during interpreter '
                 'shutdown.  As a\n'
                 '       consequence, the global variables it needs to access '
                 '(including\n'
                 '       other modules) may already have been deleted or set '
                 'to "None".\n'
                 '       Python guarantees that globals whose name begins with '
                 'a single\n'
                 '       underscore are deleted from their module before other '
                 'globals\n'
                 '       are deleted; if no other references to such globals '
                 'exist, this\n'
                 '       may help in assuring that imported modules are still '
                 'available\n'
                 '       at the time when the "__del__()" method is called.\n'
                 '\n'
                 'object.__repr__(self)\n'
                 '\n'
                 '   Called by the "repr()" built-in function to compute the '
                 '“official”\n'
                 '   string representation of an object.  If at all possible, '
                 'this\n'
                 '   should look like a valid Python expression that could be '
                 'used to\n'
                 '   recreate an object with the same value (given an '
                 'appropriate\n'
                 '   environment).  If this is not possible, a string of the '
                 'form\n'
                 '   "<...some useful description...>" should be returned. The '
                 'return\n'
                 '   value must be a string object. If a class defines '
                 '"__repr__()" but\n'
                 '   not "__str__()", then "__repr__()" is also used when an '
                 '“informal”\n'
                 '   string representation of instances of that class is '
                 'required.\n'
                 '\n'
                 '   This is typically used for debugging, so it is important '
                 'that the\n'
                 '   representation is information-rich and unambiguous.\n'
                 '\n'
                 'object.__str__(self)\n'
                 '\n'
                 '   Called by "str(object)" and the built-in functions '
                 '"format()" and\n'
                 '   "print()" to compute the “informal” or nicely printable '
                 'string\n'
                 '   representation of an object.  The return value must be a '
                 'string\n'
                 '   object.\n'
                 '\n'
                 '   This method differs from "object.__repr__()" in that '
                 'there is no\n'
                 '   expectation that "__str__()" return a valid Python '
                 'expression: a\n'
                 '   more convenient or concise representation can be used.\n'
                 '\n'
                 '   The default implementation defined by the built-in type '
                 '"object"\n'
                 '   calls "object.__repr__()".\n'
                 '\n'
                 'object.__bytes__(self)\n'
                 '\n'
                 '   Called by bytes to compute a byte-string representation '
                 'of an\n'
                 '   object. This should return a "bytes" object.\n'
                 '\n'
                 'object.__format__(self, format_spec)\n'
                 '\n'
                 '   Called by the "format()" built-in function, and by '
                 'extension,\n'
                 '   evaluation of formatted string literals and the '
                 '"str.format()"\n'
                 '   method, to produce a “formatted” string representation of '
                 'an\n'
                 '   object. The *format_spec* argument is a string that '
                 'contains a\n'
                 '   description of the formatting options desired. The '
                 'interpretation\n'
                 '   of the *format_spec* argument is up to the type '
                 'implementing\n'
                 '   "__format__()", however most classes will either '
                 'delegate\n'
                 '   formatting to one of the built-in types, or use a '
                 'similar\n'
                 '   formatting option syntax.\n'
                 '\n'
                 '   See Format Specification Mini-Language for a description '
                 'of the\n'
                 '   standard formatting syntax.\n'
                 '\n'
                 '   The return value must be a string object.\n'
                 '\n'
                 '   Changed in version 3.4: The __format__ method of "object" '
                 'itself\n'
                 '   raises a "TypeError" if passed any non-empty string.\n'
                 '\n'
                 '   Changed in version 3.7: "object.__format__(x, \'\')" is '
                 'now\n'
                 '   equivalent to "str(x)" rather than "format(str(x), '
                 '\'\')".\n'
                 '\n'
                 'object.__lt__(self, other)\n'
                 'object.__le__(self, other)\n'
                 'object.__eq__(self, other)\n'
                 'object.__ne__(self, other)\n'
                 'object.__gt__(self, other)\n'
                 'object.__ge__(self, other)\n'
                 '\n'
                 '   These are the so-called “rich comparison” methods. The\n'
                 '   correspondence between operator symbols and method names '
                 'is as\n'
                 '   follows: "x<y" calls "x.__lt__(y)", "x<=y" calls '
                 '"x.__le__(y)",\n'
                 '   "x==y" calls "x.__eq__(y)", "x!=y" calls "x.__ne__(y)", '
                 '"x>y" calls\n'
                 '   "x.__gt__(y)", and "x>=y" calls "x.__ge__(y)".\n'
                 '\n'
                 '   A rich comparison method may return the singleton '
                 '"NotImplemented"\n'
                 '   if it does not implement the operation for a given pair '
                 'of\n'
                 '   arguments. By convention, "False" and "True" are returned '
                 'for a\n'
                 '   successful comparison. However, these methods can return '
                 'any value,\n'
                 '   so if the comparison operator is used in a Boolean '
                 'context (e.g.,\n'
                 '   in the condition of an "if" statement), Python will call '
                 '"bool()"\n'
                 '   on the value to determine if the result is true or '
                 'false.\n'
                 '\n'
                 '   By default, "object" implements "__eq__()" by using "is", '
                 'returning\n'
                 '   "NotImplemented" in the case of a false comparison: "True '
                 'if x is y\n'
                 '   else NotImplemented". For "__ne__()", by default it '
                 'delegates to\n'
                 '   "__eq__()" and inverts the result unless it is '
                 '"NotImplemented".\n'
                 '   There are no other implied relationships among the '
                 'comparison\n'
                 '   operators or default implementations; for example, the '
                 'truth of\n'
                 '   "(x<y or x==y)" does not imply "x<=y". To automatically '
                 'generate\n'
                 '   ordering operations from a single root operation, see\n'
                 '   "functools.total_ordering()".\n'
                 '\n'
                 '   See the paragraph on "__hash__()" for some important '
                 'notes on\n'
                 '   creating *hashable* objects which support custom '
                 'comparison\n'
                 '   operations and are usable as dictionary keys.\n'
                 '\n'
                 '   There are no swapped-argument versions of these methods '
                 '(to be used\n'
                 '   when the left argument does not support the operation but '
                 'the right\n'
                 '   argument does); rather, "__lt__()" and "__gt__()" are '
                 'each other’s\n'
                 '   reflection, "__le__()" and "__ge__()" are each other’s '
                 'reflection,\n'
                 '   and "__eq__()" and "__ne__()" are their own reflection. '
                 'If the\n'
                 '   operands are of different types, and right operand’s type '
                 'is a\n'
                 '   direct or indirect subclass of the left operand’s type, '
                 'the\n'
                 '   reflected method of the right operand has priority, '
                 'otherwise the\n'
                 '   left operand’s method has priority.  Virtual subclassing '
                 'is not\n'
                 '   considered.\n'
                 '\n'
                 'object.__hash__(self)\n'
                 '\n'
                 '   Called by built-in function "hash()" and for operations '
                 'on members\n'
                 '   of hashed collections including "set", "frozenset", and '
                 '"dict".\n'
                 '   The "__hash__()" method should return an integer. The '
                 'only required\n'
                 '   property is that objects which compare equal have the '
                 'same hash\n'
                 '   value; it is advised to mix together the hash values of '
                 'the\n'
                 '   components of the object that also play a part in '
                 'comparison of\n'
                 '   objects by packing them into a tuple and hashing the '
                 'tuple.\n'
                 '   Example:\n'
                 '\n'
                 '      def __hash__(self):\n'
                 '          return hash((self.name, self.nick, self.color))\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     "hash()" truncates the value returned from an object’s '
                 'custom\n'
                 '     "__hash__()" method to the size of a "Py_ssize_t".  '
                 'This is\n'
                 '     typically 8 bytes on 64-bit builds and 4 bytes on '
                 '32-bit builds.\n'
                 '     If an object’s   "__hash__()" must interoperate on '
                 'builds of\n'
                 '     different bit sizes, be sure to check the width on all '
                 'supported\n'
                 '     builds.  An easy way to do this is with "python -c '
                 '"import sys;\n'
                 '     print(sys.hash_info.width)"".\n'
                 '\n'
                 '   If a class does not define an "__eq__()" method it should '
                 'not\n'
                 '   define a "__hash__()" operation either; if it defines '
                 '"__eq__()"\n'
                 '   but not "__hash__()", its instances will not be usable as '
                 'items in\n'
                 '   hashable collections.  If a class defines mutable objects '
                 'and\n'
                 '   implements an "__eq__()" method, it should not implement\n'
                 '   "__hash__()", since the implementation of *hashable* '
                 'collections\n'
                 '   requires that a key’s hash value is immutable (if the '
                 'object’s hash\n'
                 '   value changes, it will be in the wrong hash bucket).\n'
                 '\n'
                 '   User-defined classes have "__eq__()" and "__hash__()" '
                 'methods by\n'
                 '   default; with them, all objects compare unequal (except '
                 'with\n'
                 '   themselves) and "x.__hash__()" returns an appropriate '
                 'value such\n'
                 '   that "x == y" implies both that "x is y" and "hash(x) == '
                 'hash(y)".\n'
                 '\n'
                 '   A class that overrides "__eq__()" and does not define '
                 '"__hash__()"\n'
                 '   will have its "__hash__()" implicitly set to "None".  '
                 'When the\n'
                 '   "__hash__()" method of a class is "None", instances of '
                 'the class\n'
                 '   will raise an appropriate "TypeError" when a program '
                 'attempts to\n'
                 '   retrieve their hash value, and will also be correctly '
                 'identified as\n'
                 '   unhashable when checking "isinstance(obj,\n'
                 '   collections.abc.Hashable)".\n'
                 '\n'
                 '   If a class that overrides "__eq__()" needs to retain the\n'
                 '   implementation of "__hash__()" from a parent class, the '
                 'interpreter\n'
                 '   must be told this explicitly by setting "__hash__ =\n'
                 '   <ParentClass>.__hash__".\n'
                 '\n'
                 '   If a class that does not override "__eq__()" wishes to '
                 'suppress\n'
                 '   hash support, it should include "__hash__ = None" in the '
                 'class\n'
                 '   definition. A class which defines its own "__hash__()" '
                 'that\n'
                 '   explicitly raises a "TypeError" would be incorrectly '
                 'identified as\n'
                 '   hashable by an "isinstance(obj, '
                 'collections.abc.Hashable)" call.\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     By default, the "__hash__()" values of str and bytes '
                 'objects are\n'
                 '     “salted” with an unpredictable random value.  Although '
                 'they\n'
                 '     remain constant within an individual Python process, '
                 'they are not\n'
                 '     predictable between repeated invocations of Python.This '
                 'is\n'
                 '     intended to provide protection against a '
                 'denial-of-service caused\n'
                 '     by carefully chosen inputs that exploit the worst case\n'
                 '     performance of a dict insertion, *O*(*n*^2) '
                 'complexity.  See\n'
                 '     http://ocert.org/advisories/ocert-2011-003.html for\n'
                 '     details.Changing hash values affects the iteration '
                 'order of sets.\n'
                 '     Python has never made guarantees about this ordering '
                 '(and it\n'
                 '     typically varies between 32-bit and 64-bit builds).See '
                 'also\n'
                 '     "PYTHONHASHSEED".\n'
                 '\n'
                 '   Changed in version 3.3: Hash randomization is enabled by '
                 'default.\n'
                 '\n'
                 'object.__bool__(self)\n'
                 '\n'
                 '   Called to implement truth value testing and the built-in '
                 'operation\n'
                 '   "bool()"; should return "False" or "True".  When this '
                 'method is not\n'
                 '   defined, "__len__()" is called, if it is defined, and the '
                 'object is\n'
                 '   considered true if its result is nonzero.  If a class '
                 'defines\n'
                 '   neither "__len__()" nor "__bool__()", all its instances '
                 'are\n'
                 '   considered true.\n'
                 '\n'
                 '\n'
                 'Customizing attribute access\n'
                 '============================\n'
                 '\n'
                 'The following methods can be defined to customize the '
                 'meaning of\n'
                 'attribute access (use of, assignment to, or deletion of '
                 '"x.name") for\n'
                 'class instances.\n'
                 '\n'
                 'object.__getattr__(self, name)\n'
                 '\n'
                 '   Called when the default attribute access fails with an\n'
                 '   "AttributeError" (either "__getattribute__()" raises an\n'
                 '   "AttributeError" because *name* is not an instance '
                 'attribute or an\n'
                 '   attribute in the class tree for "self"; or "__get__()" of '
                 'a *name*\n'
                 '   property raises "AttributeError").  This method should '
                 'either\n'
                 '   return the (computed) attribute value or raise an '
                 '"AttributeError"\n'
                 '   exception.\n'
                 '\n'
                 '   Note that if the attribute is found through the normal '
                 'mechanism,\n'
                 '   "__getattr__()" is not called.  (This is an intentional '
                 'asymmetry\n'
                 '   between "__getattr__()" and "__setattr__()".) This is '
                 'done both for\n'
                 '   efficiency reasons and because otherwise "__getattr__()" '
                 'would have\n'
                 '   no way to access other attributes of the instance.  Note '
                 'that at\n'
                 '   least for instance variables, you can fake total control '
                 'by not\n'
                 '   inserting any values in the instance attribute dictionary '
                 '(but\n'
                 '   instead inserting them in another object).  See the\n'
                 '   "__getattribute__()" method below for a way to actually '
                 'get total\n'
                 '   control over attribute access.\n'
                 '\n'
                 'object.__getattribute__(self, name)\n'
                 '\n'
                 '   Called unconditionally to implement attribute accesses '
                 'for\n'
                 '   instances of the class. If the class also defines '
                 '"__getattr__()",\n'
                 '   the latter will not be called unless "__getattribute__()" '
                 'either\n'
                 '   calls it explicitly or raises an "AttributeError". This '
                 'method\n'
                 '   should return the (computed) attribute value or raise an\n'
                 '   "AttributeError" exception. In order to avoid infinite '
                 'recursion in\n'
                 '   this method, its implementation should always call the '
                 'base class\n'
                 '   method with the same name to access any attributes it '
                 'needs, for\n'
                 '   example, "object.__getattribute__(self, name)".\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     This method may still be bypassed when looking up '
                 'special methods\n'
                 '     as the result of implicit invocation via language '
                 'syntax or\n'
                 '     built-in functions. See Special method lookup.\n'
                 '\n'
                 '   For certain sensitive attribute accesses, raises an '
                 'auditing event\n'
                 '   "object.__getattr__" with arguments "obj" and "name".\n'
                 '\n'
                 'object.__setattr__(self, name, value)\n'
                 '\n'
                 '   Called when an attribute assignment is attempted.  This '
                 'is called\n'
                 '   instead of the normal mechanism (i.e. store the value in '
                 'the\n'
                 '   instance dictionary). *name* is the attribute name, '
                 '*value* is the\n'
                 '   value to be assigned to it.\n'
                 '\n'
                 '   If "__setattr__()" wants to assign to an instance '
                 'attribute, it\n'
                 '   should call the base class method with the same name, for '
                 'example,\n'
                 '   "object.__setattr__(self, name, value)".\n'
                 '\n'
                 '   For certain sensitive attribute assignments, raises an '
                 'auditing\n'
                 '   event "object.__setattr__" with arguments "obj", "name", '
                 '"value".\n'
                 '\n'
                 'object.__delattr__(self, name)\n'
                 '\n'
                 '   Like "__setattr__()" but for attribute deletion instead '
                 'of\n'
                 '   assignment.  This should only be implemented if "del '
                 'obj.name" is\n'
                 '   meaningful for the object.\n'
                 '\n'
                 '   For certain sensitive attribute deletions, raises an '
                 'auditing event\n'
                 '   "object.__delattr__" with arguments "obj" and "name".\n'
                 '\n'
                 'object.__dir__(self)\n'
                 '\n'
                 '   Called when "dir()" is called on the object. A sequence '
                 'must be\n'
                 '   returned. "dir()" converts the returned sequence to a '
                 'list and\n'
                 '   sorts it.\n'
                 '\n'
                 '\n'
                 'Customizing module attribute access\n'
                 '-----------------------------------\n'
                 '\n'
                 'Special names "__getattr__" and "__dir__" can be also used '
                 'to\n'
                 'customize access to module attributes. The "__getattr__" '
                 'function at\n'
                 'the module level should accept one argument which is the '
                 'name of an\n'
                 'attribute and return the computed value or raise an '
                 '"AttributeError".\n'
                 'If an attribute is not found on a module object through the '
                 'normal\n'
                 'lookup, i.e. "object.__getattribute__()", then "__getattr__" '
                 'is\n'
                 'searched in the module "__dict__" before raising an '
                 '"AttributeError".\n'
                 'If found, it is called with the attribute name and the '
                 'result is\n'
                 'returned.\n'
                 '\n'
                 'The "__dir__" function should accept no arguments, and '
                 'return a\n'
                 'sequence of strings that represents the names accessible on '
                 'module. If\n'
                 'present, this function overrides the standard "dir()" search '
                 'on a\n'
                 'module.\n'
                 '\n'
                 'For a more fine grained customization of the module behavior '
                 '(setting\n'
                 'attributes, properties, etc.), one can set the "__class__" '
                 'attribute\n'
                 'of a module object to a subclass of "types.ModuleType". For '
                 'example:\n'
                 '\n'
                 '   import sys\n'
                 '   from types import ModuleType\n'
                 '\n'
                 '   class VerboseModule(ModuleType):\n'
                 '       def __repr__(self):\n'
                 "           return f'Verbose {self.__name__}'\n"
                 '\n'
                 '       def __setattr__(self, attr, value):\n'
                 "           print(f'Setting {attr}...')\n"
                 '           super().__setattr__(attr, value)\n'
                 '\n'
                 '   sys.modules[__name__].__class__ = VerboseModule\n'
                 '\n'
                 'Note:\n'
                 '\n'
                 '  Defining module "__getattr__" and setting module '
                 '"__class__" only\n'
                 '  affect lookups made using the attribute access syntax – '
                 'directly\n'
                 '  accessing the module globals (whether by code within the '
                 'module, or\n'
                 '  via a reference to the module’s globals dictionary) is '
                 'unaffected.\n'
                 '\n'
                 'Changed in version 3.5: "__class__" module attribute is now '
                 'writable.\n'
                 '\n'
                 'New in version 3.7: "__getattr__" and "__dir__" module '
                 'attributes.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 562** - Module __getattr__ and __dir__\n'
                 '     Describes the "__getattr__" and "__dir__" functions on '
                 'modules.\n'
                 '\n'
                 '\n'
                 'Implementing Descriptors\n'
                 '------------------------\n'
                 '\n'
                 'The following methods only apply when an instance of the '
                 'class\n'
                 'containing the method (a so-called *descriptor* class) '
                 'appears in an\n'
                 '*owner* class (the descriptor must be in either the owner’s '
                 'class\n'
                 'dictionary or in the class dictionary for one of its '
                 'parents).  In the\n'
                 'examples below, “the attribute” refers to the attribute '
                 'whose name is\n'
                 'the key of the property in the owner class’ "__dict__".\n'
                 '\n'
                 'object.__get__(self, instance, owner=None)\n'
                 '\n'
                 '   Called to get the attribute of the owner class (class '
                 'attribute\n'
                 '   access) or of an instance of that class (instance '
                 'attribute\n'
                 '   access). The optional *owner* argument is the owner '
                 'class, while\n'
                 '   *instance* is the instance that the attribute was '
                 'accessed through,\n'
                 '   or "None" when the attribute is accessed through the '
                 '*owner*.\n'
                 '\n'
                 '   This method should return the computed attribute value or '
                 'raise an\n'
                 '   "AttributeError" exception.\n'
                 '\n'
                 '   **PEP 252** specifies that "__get__()" is callable with '
                 'one or two\n'
                 '   arguments.  Python’s own built-in descriptors support '
                 'this\n'
                 '   specification; however, it is likely that some '
                 'third-party tools\n'
                 '   have descriptors that require both arguments.  Python’s '
                 'own\n'
                 '   "__getattribute__()" implementation always passes in both '
                 'arguments\n'
                 '   whether they are required or not.\n'
                 '\n'
                 'object.__set__(self, instance, value)\n'
                 '\n'
                 '   Called to set the attribute on an instance *instance* of '
                 'the owner\n'
                 '   class to a new value, *value*.\n'
                 '\n'
                 '   Note, adding "__set__()" or "__delete__()" changes the '
                 'kind of\n'
                 '   descriptor to a “data descriptor”.  See Invoking '
                 'Descriptors for\n'
                 '   more details.\n'
                 '\n'
                 'object.__delete__(self, instance)\n'
                 '\n'
                 '   Called to delete the attribute on an instance *instance* '
                 'of the\n'
                 '   owner class.\n'
                 '\n'
                 'Instances of descriptors may also have the "__objclass__" '
                 'attribute\n'
                 'present:\n'
                 '\n'
                 'object.__objclass__\n'
                 '\n'
                 '   The attribute "__objclass__" is interpreted by the '
                 '"inspect" module\n'
                 '   as specifying the class where this object was defined '
                 '(setting this\n'
                 '   appropriately can assist in runtime introspection of '
                 'dynamic class\n'
                 '   attributes). For callables, it may indicate that an '
                 'instance of the\n'
                 '   given type (or a subclass) is expected or required as the '
                 'first\n'
                 '   positional argument (for example, CPython sets this '
                 'attribute for\n'
                 '   unbound methods that are implemented in C).\n'
                 '\n'
                 '\n'
                 'Invoking Descriptors\n'
                 '--------------------\n'
                 '\n'
                 'In general, a descriptor is an object attribute with '
                 '“binding\n'
                 'behavior”, one whose attribute access has been overridden by '
                 'methods\n'
                 'in the descriptor protocol:  "__get__()", "__set__()", and\n'
                 '"__delete__()". If any of those methods are defined for an '
                 'object, it\n'
                 'is said to be a descriptor.\n'
                 '\n'
                 'The default behavior for attribute access is to get, set, or '
                 'delete\n'
                 'the attribute from an object’s dictionary. For instance, '
                 '"a.x" has a\n'
                 'lookup chain starting with "a.__dict__[\'x\']", then\n'
                 '"type(a).__dict__[\'x\']", and continuing through the base '
                 'classes of\n'
                 '"type(a)" excluding metaclasses.\n'
                 '\n'
                 'However, if the looked-up value is an object defining one of '
                 'the\n'
                 'descriptor methods, then Python may override the default '
                 'behavior and\n'
                 'invoke the descriptor method instead.  Where this occurs in '
                 'the\n'
                 'precedence chain depends on which descriptor methods were '
                 'defined and\n'
                 'how they were called.\n'
                 '\n'
                 'The starting point for descriptor invocation is a binding, '
                 '"a.x". How\n'
                 'the arguments are assembled depends on "a":\n'
                 '\n'
                 'Direct Call\n'
                 '   The simplest and least common call is when user code '
                 'directly\n'
                 '   invokes a descriptor method:    "x.__get__(a)".\n'
                 '\n'
                 'Instance Binding\n'
                 '   If binding to an object instance, "a.x" is transformed '
                 'into the\n'
                 '   call: "type(a).__dict__[\'x\'].__get__(a, type(a))".\n'
                 '\n'
                 'Class Binding\n'
                 '   If binding to a class, "A.x" is transformed into the '
                 'call:\n'
                 '   "A.__dict__[\'x\'].__get__(None, A)".\n'
                 '\n'
                 'Super Binding\n'
                 '   A dotted lookup such as "super(A, a).x" searches\n'
                 '   "a.__class__.__mro__" for a base class "B" following "A" '
                 'and then\n'
                 '   returns "B.__dict__[\'x\'].__get__(a, A)".  If not a '
                 'descriptor, "x"\n'
                 '   is returned unchanged.\n'
                 '\n'
                 'For instance bindings, the precedence of descriptor '
                 'invocation depends\n'
                 'on which descriptor methods are defined.  A descriptor can '
                 'define any\n'
                 'combination of "__get__()", "__set__()" and "__delete__()".  '
                 'If it\n'
                 'does not define "__get__()", then accessing the attribute '
                 'will return\n'
                 'the descriptor object itself unless there is a value in the '
                 'object’s\n'
                 'instance dictionary.  If the descriptor defines "__set__()" '
                 'and/or\n'
                 '"__delete__()", it is a data descriptor; if it defines '
                 'neither, it is\n'
                 'a non-data descriptor.  Normally, data descriptors define '
                 'both\n'
                 '"__get__()" and "__set__()", while non-data descriptors have '
                 'just the\n'
                 '"__get__()" method.  Data descriptors with "__get__()" and '
                 '"__set__()"\n'
                 '(and/or "__delete__()") defined always override a '
                 'redefinition in an\n'
                 'instance dictionary.  In contrast, non-data descriptors can '
                 'be\n'
                 'overridden by instances.\n'
                 '\n'
                 'Python methods (including those decorated with '
                 '"@staticmethod" and\n'
                 '"@classmethod") are implemented as non-data descriptors.  '
                 'Accordingly,\n'
                 'instances can redefine and override methods.  This allows '
                 'individual\n'
                 'instances to acquire behaviors that differ from other '
                 'instances of the\n'
                 'same class.\n'
                 '\n'
                 'The "property()" function is implemented as a data '
                 'descriptor.\n'
                 'Accordingly, instances cannot override the behavior of a '
                 'property.\n'
                 '\n'
                 '\n'
                 '__slots__\n'
                 '---------\n'
                 '\n'
                 '*__slots__* allow us to explicitly declare data members '
                 '(like\n'
                 'properties) and deny the creation of "__dict__" and '
                 '*__weakref__*\n'
                 '(unless explicitly declared in *__slots__* or available in a '
                 'parent.)\n'
                 '\n'
                 'The space saved over using "__dict__" can be significant. '
                 'Attribute\n'
                 'lookup speed can be significantly improved as well.\n'
                 '\n'
                 'object.__slots__\n'
                 '\n'
                 '   This class variable can be assigned a string, iterable, '
                 'or sequence\n'
                 '   of strings with variable names used by instances.  '
                 '*__slots__*\n'
                 '   reserves space for the declared variables and prevents '
                 'the\n'
                 '   automatic creation of "__dict__" and *__weakref__* for '
                 'each\n'
                 '   instance.\n'
                 '\n'
                 'Notes on using *__slots__*:\n'
                 '\n'
                 '* When inheriting from a class without *__slots__*, the '
                 '"__dict__" and\n'
                 '  *__weakref__* attribute of the instances will always be '
                 'accessible.\n'
                 '\n'
                 '* Without a "__dict__" variable, instances cannot be '
                 'assigned new\n'
                 '  variables not listed in the *__slots__* definition.  '
                 'Attempts to\n'
                 '  assign to an unlisted variable name raises '
                 '"AttributeError". If\n'
                 '  dynamic assignment of new variables is desired, then add\n'
                 '  "\'__dict__\'" to the sequence of strings in the '
                 '*__slots__*\n'
                 '  declaration.\n'
                 '\n'
                 '* Without a *__weakref__* variable for each instance, '
                 'classes defining\n'
                 '  *__slots__* do not support "weak references" to its '
                 'instances. If\n'
                 '  weak reference support is needed, then add '
                 '"\'__weakref__\'" to the\n'
                 '  sequence of strings in the *__slots__* declaration.\n'
                 '\n'
                 '* *__slots__* are implemented at the class level by '
                 'creating\n'
                 '  descriptors for each variable name.  As a result, class '
                 'attributes\n'
                 '  cannot be used to set default values for instance '
                 'variables defined\n'
                 '  by *__slots__*; otherwise, the class attribute would '
                 'overwrite the\n'
                 '  descriptor assignment.\n'
                 '\n'
                 '* The action of a *__slots__* declaration is not limited to '
                 'the class\n'
                 '  where it is defined.  *__slots__* declared in parents are '
                 'available\n'
                 '  in child classes. However, child subclasses will get a '
                 '"__dict__"\n'
                 '  and *__weakref__* unless they also define *__slots__* '
                 '(which should\n'
                 '  only contain names of any *additional* slots).\n'
                 '\n'
                 '* If a class defines a slot also defined in a base class, '
                 'the instance\n'
                 '  variable defined by the base class slot is inaccessible '
                 '(except by\n'
                 '  retrieving its descriptor directly from the base class). '
                 'This\n'
                 '  renders the meaning of the program undefined.  In the '
                 'future, a\n'
                 '  check may be added to prevent this.\n'
                 '\n'
                 '* "TypeError" will be raised if nonempty *__slots__* are '
                 'defined for a\n'
                 '  class derived from a ""variable-length" built-in type" '
                 'such as\n'
                 '  "int", "bytes", and "tuple".\n'
                 '\n'
                 '* Any non-string *iterable* may be assigned to *__slots__*.\n'
                 '\n'
                 '* If a "dictionary" is used to assign *__slots__*, the '
                 'dictionary keys\n'
                 '  will be used as the slot names. The values of the '
                 'dictionary can be\n'
                 '  used to provide per-attribute docstrings that will be '
                 'recognised by\n'
                 '  "inspect.getdoc()" and displayed in the output of '
                 '"help()".\n'
                 '\n'
                 '* "__class__" assignment works only if both classes have the '
                 'same\n'
                 '  *__slots__*.\n'
                 '\n'
                 '* Multiple inheritance with multiple slotted parent classes '
                 'can be\n'
                 '  used, but only one parent is allowed to have attributes '
                 'created by\n'
                 '  slots (the other bases must have empty slot layouts) - '
                 'violations\n'
                 '  raise "TypeError".\n'
                 '\n'
                 '* If an *iterator* is used for *__slots__* then a '
                 '*descriptor* is\n'
                 '  created for each of the iterator’s values. However, the '
                 '*__slots__*\n'
                 '  attribute will be an empty iterator.\n'
                 '\n'
                 '\n'
                 'Customizing class creation\n'
                 '==========================\n'
                 '\n'
                 'Whenever a class inherits from another class, '
                 '"__init_subclass__()" is\n'
                 'called on the parent class. This way, it is possible to '
                 'write classes\n'
                 'which change the behavior of subclasses. This is closely '
                 'related to\n'
                 'class decorators, but where class decorators only affect the '
                 'specific\n'
                 'class they’re applied to, "__init_subclass__" solely applies '
                 'to future\n'
                 'subclasses of the class defining the method.\n'
                 '\n'
                 'classmethod object.__init_subclass__(cls)\n'
                 '\n'
                 '   This method is called whenever the containing class is '
                 'subclassed.\n'
                 '   *cls* is then the new subclass. If defined as a normal '
                 'instance\n'
                 '   method, this method is implicitly converted to a class '
                 'method.\n'
                 '\n'
                 '   Keyword arguments which are given to a new class are '
                 'passed to the\n'
                 '   parent class’s "__init_subclass__". For compatibility '
                 'with other\n'
                 '   classes using "__init_subclass__", one should take out '
                 'the needed\n'
                 '   keyword arguments and pass the others over to the base '
                 'class, as\n'
                 '   in:\n'
                 '\n'
                 '      class Philosopher:\n'
                 '          def __init_subclass__(cls, /, default_name, '
                 '**kwargs):\n'
                 '              super().__init_subclass__(**kwargs)\n'
                 '              cls.default_name = default_name\n'
                 '\n'
                 '      class AustralianPhilosopher(Philosopher, '
                 'default_name="Bruce"):\n'
                 '          pass\n'
                 '\n'
                 '   The default implementation "object.__init_subclass__" '
                 'does nothing,\n'
                 '   but raises an error if it is called with any arguments.\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     The metaclass hint "metaclass" is consumed by the rest '
                 'of the\n'
                 '     type machinery, and is never passed to '
                 '"__init_subclass__"\n'
                 '     implementations. The actual metaclass (rather than the '
                 'explicit\n'
                 '     hint) can be accessed as "type(cls)".\n'
                 '\n'
                 '   New in version 3.6.\n'
                 '\n'
                 'When a class is created, "type.__new__()" scans the class '
                 'variables\n'
                 'and makes callbacks to those with a "__set_name__()" hook.\n'
                 '\n'
                 'object.__set_name__(self, owner, name)\n'
                 '\n'
                 '   Automatically called at the time the owning class *owner* '
                 'is\n'
                 '   created. The object has been assigned to *name* in that '
                 'class:\n'
                 '\n'
                 '      class A:\n'
                 '          x = C()  # Automatically calls: x.__set_name__(A, '
                 "'x')\n"
                 '\n'
                 '   If the class variable is assigned after the class is '
                 'created,\n'
                 '   "__set_name__()" will not be called automatically. If '
                 'needed,\n'
                 '   "__set_name__()" can be called directly:\n'
                 '\n'
                 '      class A:\n'
                 '         pass\n'
                 '\n'
                 '      c = C()\n'
                 '      A.x = c                  # The hook is not called\n'
                 "      c.__set_name__(A, 'x')   # Manually invoke the hook\n"
                 '\n'
                 '   See Creating the class object for more details.\n'
                 '\n'
                 '   New in version 3.6.\n'
                 '\n'
                 '\n'
                 'Metaclasses\n'
                 '-----------\n'
                 '\n'
                 'By default, classes are constructed using "type()". The '
                 'class body is\n'
                 'executed in a new namespace and the class name is bound '
                 'locally to the\n'
                 'result of "type(name, bases, namespace)".\n'
                 '\n'
                 'The class creation process can be customized by passing the\n'
                 '"metaclass" keyword argument in the class definition line, '
                 'or by\n'
                 'inheriting from an existing class that included such an '
                 'argument. In\n'
                 'the following example, both "MyClass" and "MySubclass" are '
                 'instances\n'
                 'of "Meta":\n'
                 '\n'
                 '   class Meta(type):\n'
                 '       pass\n'
                 '\n'
                 '   class MyClass(metaclass=Meta):\n'
                 '       pass\n'
                 '\n'
                 '   class MySubclass(MyClass):\n'
                 '       pass\n'
                 '\n'
                 'Any other keyword arguments that are specified in the class '
                 'definition\n'
                 'are passed through to all metaclass operations described '
                 'below.\n'
                 '\n'
                 'When a class definition is executed, the following steps '
                 'occur:\n'
                 '\n'
                 '* MRO entries are resolved;\n'
                 '\n'
                 '* the appropriate metaclass is determined;\n'
                 '\n'
                 '* the class namespace is prepared;\n'
                 '\n'
                 '* the class body is executed;\n'
                 '\n'
                 '* the class object is created.\n'
                 '\n'
                 '\n'
                 'Resolving MRO entries\n'
                 '---------------------\n'
                 '\n'
                 'object.__mro_entries__(self, bases)\n'
                 '\n'
                 '   If a base that appears in a class definition is not an '
                 'instance of\n'
                 '   "type", then an "__mro_entries__()" method is searched on '
                 'the base.\n'
                 '   If an "__mro_entries__()" method is found, the base is '
                 'substituted\n'
                 '   with the result of a call to "__mro_entries__()" when '
                 'creating the\n'
                 '   class. The method is called with the original bases tuple '
                 'passed to\n'
                 '   the *bases* parameter, and must return a tuple of classes '
                 'that will\n'
                 '   be used instead of the base. The returned tuple may be '
                 'empty: in\n'
                 '   these cases, the original base is ignored.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  "types.resolve_bases()"\n'
                 '     Dynamically resolve bases that are not instances of '
                 '"type".\n'
                 '\n'
                 '  **PEP 560**\n'
                 '     Core support for typing module and generic types.\n'
                 '\n'
                 '\n'
                 'Determining the appropriate metaclass\n'
                 '-------------------------------------\n'
                 '\n'
                 'The appropriate metaclass for a class definition is '
                 'determined as\n'
                 'follows:\n'
                 '\n'
                 '* if no bases and no explicit metaclass are given, then '
                 '"type()" is\n'
                 '  used;\n'
                 '\n'
                 '* if an explicit metaclass is given and it is *not* an '
                 'instance of\n'
                 '  "type()", then it is used directly as the metaclass;\n'
                 '\n'
                 '* if an instance of "type()" is given as the explicit '
                 'metaclass, or\n'
                 '  bases are defined, then the most derived metaclass is '
                 'used.\n'
                 '\n'
                 'The most derived metaclass is selected from the explicitly '
                 'specified\n'
                 'metaclass (if any) and the metaclasses (i.e. "type(cls)") of '
                 'all\n'
                 'specified base classes. The most derived metaclass is one '
                 'which is a\n'
                 'subtype of *all* of these candidate metaclasses. If none of '
                 'the\n'
                 'candidate metaclasses meets that criterion, then the class '
                 'definition\n'
                 'will fail with "TypeError".\n'
                 '\n'
                 '\n'
                 'Preparing the class namespace\n'
                 '-----------------------------\n'
                 '\n'
                 'Once the appropriate metaclass has been identified, then the '
                 'class\n'
                 'namespace is prepared. If the metaclass has a "__prepare__" '
                 'attribute,\n'
                 'it is called as "namespace = metaclass.__prepare__(name, '
                 'bases,\n'
                 '**kwds)" (where the additional keyword arguments, if any, '
                 'come from\n'
                 'the class definition). The "__prepare__" method should be '
                 'implemented\n'
                 'as a "classmethod". The namespace returned by "__prepare__" '
                 'is passed\n'
                 'in to "__new__", but when the final class object is created '
                 'the\n'
                 'namespace is copied into a new "dict".\n'
                 '\n'
                 'If the metaclass has no "__prepare__" attribute, then the '
                 'class\n'
                 'namespace is initialised as an empty ordered mapping.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 3115** - Metaclasses in Python 3000\n'
                 '     Introduced the "__prepare__" namespace hook\n'
                 '\n'
                 '\n'
                 'Executing the class body\n'
                 '------------------------\n'
                 '\n'
                 'The class body is executed (approximately) as "exec(body, '
                 'globals(),\n'
                 'namespace)". The key difference from a normal call to '
                 '"exec()" is that\n'
                 'lexical scoping allows the class body (including any '
                 'methods) to\n'
                 'reference names from the current and outer scopes when the '
                 'class\n'
                 'definition occurs inside a function.\n'
                 '\n'
                 'However, even when the class definition occurs inside the '
                 'function,\n'
                 'methods defined inside the class still cannot see names '
                 'defined at the\n'
                 'class scope. Class variables must be accessed through the '
                 'first\n'
                 'parameter of instance or class methods, or through the '
                 'implicit\n'
                 'lexically scoped "__class__" reference described in the next '
                 'section.\n'
                 '\n'
                 '\n'
                 'Creating the class object\n'
                 '-------------------------\n'
                 '\n'
                 'Once the class namespace has been populated by executing the '
                 'class\n'
                 'body, the class object is created by calling '
                 '"metaclass(name, bases,\n'
                 'namespace, **kwds)" (the additional keywords passed here are '
                 'the same\n'
                 'as those passed to "__prepare__").\n'
                 '\n'
                 'This class object is the one that will be referenced by the '
                 'zero-\n'
                 'argument form of "super()". "__class__" is an implicit '
                 'closure\n'
                 'reference created by the compiler if any methods in a class '
                 'body refer\n'
                 'to either "__class__" or "super". This allows the zero '
                 'argument form\n'
                 'of "super()" to correctly identify the class being defined '
                 'based on\n'
                 'lexical scoping, while the class or instance that was used '
                 'to make the\n'
                 'current call is identified based on the first argument '
                 'passed to the\n'
                 'method.\n'
                 '\n'
                 '**CPython implementation detail:** In CPython 3.6 and later, '
                 'the\n'
                 '"__class__" cell is passed to the metaclass as a '
                 '"__classcell__" entry\n'
                 'in the class namespace. If present, this must be propagated '
                 'up to the\n'
                 '"type.__new__" call in order for the class to be '
                 'initialised\n'
                 'correctly. Failing to do so will result in a "RuntimeError" '
                 'in Python\n'
                 '3.8.\n'
                 '\n'
                 'When using the default metaclass "type", or any metaclass '
                 'that\n'
                 'ultimately calls "type.__new__", the following additional\n'
                 'customization steps are invoked after creating the class '
                 'object:\n'
                 '\n'
                 '1. The "type.__new__" method collects all of the attributes '
                 'in the\n'
                 '   class namespace that define a "__set_name__()" method;\n'
                 '\n'
                 '2. Those "__set_name__" methods are called with the class '
                 'being\n'
                 '   defined and the assigned name of that particular '
                 'attribute;\n'
                 '\n'
                 '3. The "__init_subclass__()" hook is called on the immediate '
                 'parent of\n'
                 '   the new class in its method resolution order.\n'
                 '\n'
                 'After the class object is created, it is passed to the '
                 'class\n'
                 'decorators included in the class definition (if any) and the '
                 'resulting\n'
                 'object is bound in the local namespace as the defined '
                 'class.\n'
                 '\n'
                 'When a new class is created by "type.__new__", the object '
                 'provided as\n'
                 'the namespace parameter is copied to a new ordered mapping '
                 'and the\n'
                 'original object is discarded. The new copy is wrapped in a '
                 'read-only\n'
                 'proxy, which becomes the "__dict__" attribute of the class '
                 'object.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 3135** - New super\n'
                 '     Describes the implicit "__class__" closure reference\n'
                 '\n'
                 '\n'
                 'Uses for metaclasses\n'
                 '--------------------\n'
                 '\n'
                 'The potential uses for metaclasses are boundless. Some ideas '
                 'that have\n'
                 'been explored include enum, logging, interface checking, '
                 'automatic\n'
                 'delegation, automatic property creation, proxies, '
                 'frameworks, and\n'
                 'automatic resource locking/synchronization.\n'
                 '\n'
                 '\n'
                 'Customizing instance and subclass checks\n'
                 '========================================\n'
                 '\n'
                 'The following methods are used to override the default '
                 'behavior of the\n'
                 '"isinstance()" and "issubclass()" built-in functions.\n'
                 '\n'
                 'In particular, the metaclass "abc.ABCMeta" implements these '
                 'methods in\n'
                 'order to allow the addition of Abstract Base Classes (ABCs) '
                 'as\n'
                 '“virtual base classes” to any class or type (including '
                 'built-in\n'
                 'types), including other ABCs.\n'
                 '\n'
                 'class.__instancecheck__(self, instance)\n'
                 '\n'
                 '   Return true if *instance* should be considered a (direct '
                 'or\n'
                 '   indirect) instance of *class*. If defined, called to '
                 'implement\n'
                 '   "isinstance(instance, class)".\n'
                 '\n'
                 'class.__subclasscheck__(self, subclass)\n'
                 '\n'
                 '   Return true if *subclass* should be considered a (direct '
                 'or\n'
                 '   indirect) subclass of *class*.  If defined, called to '
                 'implement\n'
                 '   "issubclass(subclass, class)".\n'
                 '\n'
                 'Note that these methods are looked up on the type '
                 '(metaclass) of a\n'
                 'class.  They cannot be defined as class methods in the '
                 'actual class.\n'
                 'This is consistent with the lookup of special methods that '
                 'are called\n'
                 'on instances, only in this case the instance is itself a '
                 'class.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 3119** - Introducing Abstract Base Classes\n'
                 '     Includes the specification for customizing '
                 '"isinstance()" and\n'
                 '     "issubclass()" behavior through "__instancecheck__()" '
                 'and\n'
                 '     "__subclasscheck__()", with motivation for this '
                 'functionality in\n'
                 '     the context of adding Abstract Base Classes (see the '
                 '"abc"\n'
                 '     module) to the language.\n'
                 '\n'
                 '\n'
                 'Emulating generic types\n'
                 '=======================\n'
                 '\n'
                 'When using *type annotations*, it is often useful to '
                 '*parameterize* a\n'
                 '*generic type* using Python’s square-brackets notation. For '
                 'example,\n'
                 'the annotation "list[int]" might be used to signify a "list" '
                 'in which\n'
                 'all the elements are of type "int".\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 484** - Type Hints\n'
                 '     Introducing Python’s framework for type annotations\n'
                 '\n'
                 '  Generic Alias Types\n'
                 '     Documentation for objects representing parameterized '
                 'generic\n'
                 '     classes\n'
                 '\n'
                 '  Generics, user-defined generics and "typing.Generic"\n'
                 '     Documentation on how to implement generic classes that '
                 'can be\n'
                 '     parameterized at runtime and understood by static '
                 'type-checkers.\n'
                 '\n'
                 'A class can *generally* only be parameterized if it defines '
                 'the\n'
                 'special class method "__class_getitem__()".\n'
                 '\n'
                 'classmethod object.__class_getitem__(cls, key)\n'
                 '\n'
                 '   Return an object representing the specialization of a '
                 'generic class\n'
                 '   by type arguments found in *key*.\n'
                 '\n'
                 '   When defined on a class, "__class_getitem__()" is '
                 'automatically a\n'
                 '   class method. As such, there is no need for it to be '
                 'decorated with\n'
                 '   "@classmethod" when it is defined.\n'
                 '\n'
                 '\n'
                 'The purpose of *__class_getitem__*\n'
                 '----------------------------------\n'
                 '\n'
                 'The purpose of "__class_getitem__()" is to allow runtime\n'
                 'parameterization of standard-library generic classes in '
                 'order to more\n'
                 'easily apply *type hints* to these classes.\n'
                 '\n'
                 'To implement custom generic classes that can be '
                 'parameterized at\n'
                 'runtime and understood by static type-checkers, users should '
                 'either\n'
                 'inherit from a standard library class that already '
                 'implements\n'
                 '"__class_getitem__()", or inherit from "typing.Generic", '
                 'which has its\n'
                 'own implementation of "__class_getitem__()".\n'
                 '\n'
                 'Custom implementations of "__class_getitem__()" on classes '
                 'defined\n'
                 'outside of the standard library may not be understood by '
                 'third-party\n'
                 'type-checkers such as mypy. Using "__class_getitem__()" on '
                 'any class\n'
                 'for purposes other than type hinting is discouraged.\n'
                 '\n'
                 '\n'
                 '*__class_getitem__* versus *__getitem__*\n'
                 '----------------------------------------\n'
                 '\n'
                 'Usually, the subscription of an object using square brackets '
                 'will call\n'
                 'the "__getitem__()" instance method defined on the object’s '
                 'class.\n'
                 'However, if the object being subscribed is itself a class, '
                 'the class\n'
                 'method "__class_getitem__()" may be called instead.\n'
                 '"__class_getitem__()" should return a GenericAlias object if '
                 'it is\n'
                 'properly defined.\n'
                 '\n'
                 'Presented with the *expression* "obj[x]", the Python '
                 'interpreter\n'
                 'follows something like the following process to decide '
                 'whether\n'
                 '"__getitem__()" or "__class_getitem__()" should be called:\n'
                 '\n'
                 '   from inspect import isclass\n'
                 '\n'
                 '   def subscribe(obj, x):\n'
                 '       """Return the result of the expression \'obj[x]\'"""\n'
                 '\n'
                 '       class_of_obj = type(obj)\n'
                 '\n'
                 '       # If the class of obj defines __getitem__,\n'
                 '       # call class_of_obj.__getitem__(obj, x)\n'
                 "       if hasattr(class_of_obj, '__getitem__'):\n"
                 '           return class_of_obj.__getitem__(obj, x)\n'
                 '\n'
                 '       # Else, if obj is a class and defines '
                 '__class_getitem__,\n'
                 '       # call obj.__class_getitem__(x)\n'
                 '       elif isclass(obj) and hasattr(obj, '
                 "'__class_getitem__'):\n"
                 '           return obj.__class_getitem__(x)\n'
                 '\n'
                 '       # Else, raise an exception\n'
                 '       else:\n'
                 '           raise TypeError(\n'
                 '               f"\'{class_of_obj.__name__}\' object is not '
                 'subscriptable"\n'
                 '           )\n'
                 '\n'
                 'In Python, all classes are themselves instances of other '
                 'classes. The\n'
                 'class of a class is known as that class’s *metaclass*, and '
                 'most\n'
                 'classes have the "type" class as their metaclass. "type" '
                 'does not\n'
                 'define "__getitem__()", meaning that expressions such as '
                 '"list[int]",\n'
                 '"dict[str, float]" and "tuple[str, bytes]" all result in\n'
                 '"__class_getitem__()" being called:\n'
                 '\n'
                 '   >>> # list has class "type" as its metaclass, like most '
                 'classes:\n'
                 '   >>> type(list)\n'
                 "   <class 'type'>\n"
                 '   >>> type(dict) == type(list) == type(tuple) == type(str) '
                 '== type(bytes)\n'
                 '   True\n'
                 '   >>> # "list[int]" calls "list.__class_getitem__(int)"\n'
                 '   >>> list[int]\n'
                 '   list[int]\n'
                 '   >>> # list.__class_getitem__ returns a GenericAlias '
                 'object:\n'
                 '   >>> type(list[int])\n'
                 "   <class 'types.GenericAlias'>\n"
                 '\n'
                 'However, if a class has a custom metaclass that defines\n'
                 '"__getitem__()", subscribing the class may result in '
                 'different\n'
                 'behaviour. An example of this can be found in the "enum" '
                 'module:\n'
                 '\n'
                 '   >>> from enum import Enum\n'
                 '   >>> class Menu(Enum):\n'
                 '   ...     """A breakfast menu"""\n'
                 "   ...     SPAM = 'spam'\n"
                 "   ...     BACON = 'bacon'\n"
                 '   ...\n'
                 '   >>> # Enum classes have a custom metaclass:\n'
                 '   >>> type(Menu)\n'
                 "   <class 'enum.EnumMeta'>\n"
                 '   >>> # EnumMeta defines __getitem__,\n'
                 '   >>> # so __class_getitem__ is not called,\n'
                 '   >>> # and the result is not a GenericAlias object:\n'
                 "   >>> Menu['SPAM']\n"
                 "   <Menu.SPAM: 'spam'>\n"
                 "   >>> type(Menu['SPAM'])\n"
                 "   <enum 'Menu'>\n"
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 560** - Core Support for typing module and generic '
                 'types\n'
                 '     Introducing "__class_getitem__()", and outlining when '
                 'a\n'
                 '     subscription results in "__class_getitem__()" being '
                 'called\n'
                 '     instead of "__getitem__()"\n'
                 '\n'
                 '\n'
                 'Emulating callable objects\n'
                 '==========================\n'
                 '\n'
                 'object.__call__(self[, args...])\n'
                 '\n'
                 '   Called when the instance is “called” as a function; if '
                 'this method\n'
                 '   is defined, "x(arg1, arg2, ...)" roughly translates to\n'
                 '   "type(x).__call__(x, arg1, ...)".\n'
                 '\n'
                 '\n'
                 'Emulating container types\n'
                 '=========================\n'
                 '\n'
                 'The following methods can be defined to implement container '
                 'objects.\n'
                 'Containers usually are *sequences* (such as "lists" or '
                 '"tuples") or\n'
                 '*mappings* (like "dictionaries"), but can represent other '
                 'containers\n'
                 'as well.  The first set of methods is used either to emulate '
                 'a\n'
                 'sequence or to emulate a mapping; the difference is that for '
                 'a\n'
                 'sequence, the allowable keys should be the integers *k* for '
                 'which "0\n'
                 '<= k < N" where *N* is the length of the sequence, or '
                 '"slice" objects,\n'
                 'which define a range of items.  It is also recommended that '
                 'mappings\n'
                 'provide the methods "keys()", "values()", "items()", '
                 '"get()",\n'
                 '"clear()", "setdefault()", "pop()", "popitem()", "copy()", '
                 'and\n'
                 '"update()" behaving similar to those for Python’s standard\n'
                 '"dictionary" objects.  The "collections.abc" module provides '
                 'a\n'
                 '"MutableMapping" *abstract base class* to help create those '
                 'methods\n'
                 'from a base set of "__getitem__()", "__setitem__()", '
                 '"__delitem__()",\n'
                 'and "keys()". Mutable sequences should provide methods '
                 '"append()",\n'
                 '"count()", "index()", "extend()", "insert()", "pop()", '
                 '"remove()",\n'
                 '"reverse()" and "sort()", like Python standard "list" '
                 'objects.\n'
                 'Finally, sequence types should implement addition (meaning\n'
                 'concatenation) and multiplication (meaning repetition) by '
                 'defining the\n'
                 'methods "__add__()", "__radd__()", "__iadd__()", '
                 '"__mul__()",\n'
                 '"__rmul__()" and "__imul__()" described below; they should '
                 'not define\n'
                 'other numerical operators.  It is recommended that both '
                 'mappings and\n'
                 'sequences implement the "__contains__()" method to allow '
                 'efficient use\n'
                 'of the "in" operator; for mappings, "in" should search the '
                 'mapping’s\n'
                 'keys; for sequences, it should search through the values.  '
                 'It is\n'
                 'further recommended that both mappings and sequences '
                 'implement the\n'
                 '"__iter__()" method to allow efficient iteration through '
                 'the\n'
                 'container; for mappings, "__iter__()" should iterate through '
                 'the\n'
                 'object’s keys; for sequences, it should iterate through the '
                 'values.\n'
                 '\n'
                 'object.__len__(self)\n'
                 '\n'
                 '   Called to implement the built-in function "len()".  '
                 'Should return\n'
                 '   the length of the object, an integer ">=" 0.  Also, an '
                 'object that\n'
                 '   doesn’t define a "__bool__()" method and whose '
                 '"__len__()" method\n'
                 '   returns zero is considered to be false in a Boolean '
                 'context.\n'
                 '\n'
                 '   **CPython implementation detail:** In CPython, the length '
                 'is\n'
                 '   required to be at most "sys.maxsize". If the length is '
                 'larger than\n'
                 '   "sys.maxsize" some features (such as "len()") may raise\n'
                 '   "OverflowError".  To prevent raising "OverflowError" by '
                 'truth value\n'
                 '   testing, an object must define a "__bool__()" method.\n'
                 '\n'
                 'object.__length_hint__(self)\n'
                 '\n'
                 '   Called to implement "operator.length_hint()". Should '
                 'return an\n'
                 '   estimated length for the object (which may be greater or '
                 'less than\n'
                 '   the actual length). The length must be an integer ">=" 0. '
                 'The\n'
                 '   return value may also be "NotImplemented", which is '
                 'treated the\n'
                 '   same as if the "__length_hint__" method didn’t exist at '
                 'all. This\n'
                 '   method is purely an optimization and is never required '
                 'for\n'
                 '   correctness.\n'
                 '\n'
                 '   New in version 3.4.\n'
                 '\n'
                 'Note:\n'
                 '\n'
                 '  Slicing is done exclusively with the following three '
                 'methods.  A\n'
                 '  call like\n'
                 '\n'
                 '     a[1:2] = b\n'
                 '\n'
                 '  is translated to\n'
                 '\n'
                 '     a[slice(1, 2, None)] = b\n'
                 '\n'
                 '  and so forth.  Missing slice items are always filled in '
                 'with "None".\n'
                 '\n'
                 'object.__getitem__(self, key)\n'
                 '\n'
                 '   Called to implement evaluation of "self[key]". For '
                 '*sequence*\n'
                 '   types, the accepted keys should be integers. Optionally, '
                 'they may\n'
                 '   support "slice" objects as well.  Negative index support '
                 'is also\n'
                 '   optional. If *key* is of an inappropriate type, '
                 '"TypeError" may be\n'
                 '   raised; if *key* is a value outside the set of indexes '
                 'for the\n'
                 '   sequence (after any special interpretation of negative '
                 'values),\n'
                 '   "IndexError" should be raised. For *mapping* types, if '
                 '*key* is\n'
                 '   missing (not in the container), "KeyError" should be '
                 'raised.\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     "for" loops expect that an "IndexError" will be raised '
                 'for\n'
                 '     illegal indexes to allow proper detection of the end of '
                 'the\n'
                 '     sequence.\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     When subscripting a *class*, the special class method\n'
                 '     "__class_getitem__()" may be called instead of '
                 '"__getitem__()".\n'
                 '     See __class_getitem__ versus __getitem__ for more '
                 'details.\n'
                 '\n'
                 'object.__setitem__(self, key, value)\n'
                 '\n'
                 '   Called to implement assignment to "self[key]".  Same note '
                 'as for\n'
                 '   "__getitem__()".  This should only be implemented for '
                 'mappings if\n'
                 '   the objects support changes to the values for keys, or if '
                 'new keys\n'
                 '   can be added, or for sequences if elements can be '
                 'replaced.  The\n'
                 '   same exceptions should be raised for improper *key* '
                 'values as for\n'
                 '   the "__getitem__()" method.\n'
                 '\n'
                 'object.__delitem__(self, key)\n'
                 '\n'
                 '   Called to implement deletion of "self[key]".  Same note '
                 'as for\n'
                 '   "__getitem__()".  This should only be implemented for '
                 'mappings if\n'
                 '   the objects support removal of keys, or for sequences if '
                 'elements\n'
                 '   can be removed from the sequence.  The same exceptions '
                 'should be\n'
                 '   raised for improper *key* values as for the '
                 '"__getitem__()" method.\n'
                 '\n'
                 'object.__missing__(self, key)\n'
                 '\n'
                 '   Called by "dict"."__getitem__()" to implement "self[key]" '
                 'for dict\n'
                 '   subclasses when key is not in the dictionary.\n'
                 '\n'
                 'object.__iter__(self)\n'
                 '\n'
                 '   This method is called when an *iterator* is required for '
                 'a\n'
                 '   container. This method should return a new iterator '
                 'object that can\n'
                 '   iterate over all the objects in the container.  For '
                 'mappings, it\n'
                 '   should iterate over the keys of the container.\n'
                 '\n'
                 'object.__reversed__(self)\n'
                 '\n'
                 '   Called (if present) by the "reversed()" built-in to '
                 'implement\n'
                 '   reverse iteration.  It should return a new iterator '
                 'object that\n'
                 '   iterates over all the objects in the container in reverse '
                 'order.\n'
                 '\n'
                 '   If the "__reversed__()" method is not provided, the '
                 '"reversed()"\n'
                 '   built-in will fall back to using the sequence protocol '
                 '("__len__()"\n'
                 '   and "__getitem__()").  Objects that support the sequence '
                 'protocol\n'
                 '   should only provide "__reversed__()" if they can provide '
                 'an\n'
                 '   implementation that is more efficient than the one '
                 'provided by\n'
                 '   "reversed()".\n'
                 '\n'
                 'The membership test operators ("in" and "not in") are '
                 'normally\n'
                 'implemented as an iteration through a container. However, '
                 'container\n'
                 'objects can supply the following special method with a more '
                 'efficient\n'
                 'implementation, which also does not require the object be '
                 'iterable.\n'
                 '\n'
                 'object.__contains__(self, item)\n'
                 '\n'
                 '   Called to implement membership test operators.  Should '
                 'return true\n'
                 '   if *item* is in *self*, false otherwise.  For mapping '
                 'objects, this\n'
                 '   should consider the keys of the mapping rather than the '
                 'values or\n'
                 '   the key-item pairs.\n'
                 '\n'
                 '   For objects that don’t define "__contains__()", the '
                 'membership test\n'
                 '   first tries iteration via "__iter__()", then the old '
                 'sequence\n'
                 '   iteration protocol via "__getitem__()", see this section '
                 'in the\n'
                 '   language reference.\n'
                 '\n'
                 '\n'
                 'Emulating numeric types\n'
                 '=======================\n'
                 '\n'
                 'The following methods can be defined to emulate numeric '
                 'objects.\n'
                 'Methods corresponding to operations that are not supported '
                 'by the\n'
                 'particular kind of number implemented (e.g., bitwise '
                 'operations for\n'
                 'non-integral numbers) should be left undefined.\n'
                 '\n'
                 'object.__add__(self, other)\n'
                 'object.__sub__(self, other)\n'
                 'object.__mul__(self, other)\n'
                 'object.__matmul__(self, other)\n'
                 'object.__truediv__(self, other)\n'
                 'object.__floordiv__(self, other)\n'
                 'object.__mod__(self, other)\n'
                 'object.__divmod__(self, other)\n'
                 'object.__pow__(self, other[, modulo])\n'
                 'object.__lshift__(self, other)\n'
                 'object.__rshift__(self, other)\n'
                 'object.__and__(self, other)\n'
                 'object.__xor__(self, other)\n'
                 'object.__or__(self, other)\n'
                 '\n'
                 '   These methods are called to implement the binary '
                 'arithmetic\n'
                 '   operations ("+", "-", "*", "@", "/", "//", "%", '
                 '"divmod()",\n'
                 '   "pow()", "**", "<<", ">>", "&", "^", "|").  For instance, '
                 'to\n'
                 '   evaluate the expression "x + y", where *x* is an instance '
                 'of a\n'
                 '   class that has an "__add__()" method, "type(x).__add__(x, '
                 'y)" is\n'
                 '   called.  The "__divmod__()" method should be the '
                 'equivalent to\n'
                 '   using "__floordiv__()" and "__mod__()"; it should not be '
                 'related to\n'
                 '   "__truediv__()".  Note that "__pow__()" should be defined '
                 'to accept\n'
                 '   an optional third argument if the ternary version of the '
                 'built-in\n'
                 '   "pow()" function is to be supported.\n'
                 '\n'
                 '   If one of those methods does not support the operation '
                 'with the\n'
                 '   supplied arguments, it should return "NotImplemented".\n'
                 '\n'
                 'object.__radd__(self, other)\n'
                 'object.__rsub__(self, other)\n'
                 'object.__rmul__(self, other)\n'
                 'object.__rmatmul__(self, other)\n'
                 'object.__rtruediv__(self, other)\n'
                 'object.__rfloordiv__(self, other)\n'
                 'object.__rmod__(self, other)\n'
                 'object.__rdivmod__(self, other)\n'
                 'object.__rpow__(self, other[, modulo])\n'
                 'object.__rlshift__(self, other)\n'
                 'object.__rrshift__(self, other)\n'
                 'object.__rand__(self, other)\n'
                 'object.__rxor__(self, other)\n'
                 'object.__ror__(self, other)\n'
                 '\n'
                 '   These methods are called to implement the binary '
                 'arithmetic\n'
                 '   operations ("+", "-", "*", "@", "/", "//", "%", '
                 '"divmod()",\n'
                 '   "pow()", "**", "<<", ">>", "&", "^", "|") with reflected '
                 '(swapped)\n'
                 '   operands.  These functions are only called if the left '
                 'operand does\n'
                 '   not support the corresponding operation [3] and the '
                 'operands are of\n'
                 '   different types. [4] For instance, to evaluate the '
                 'expression "x -\n'
                 '   y", where *y* is an instance of a class that has an '
                 '"__rsub__()"\n'
                 '   method, "type(y).__rsub__(y, x)" is called if '
                 '"type(x).__sub__(x,\n'
                 '   y)" returns *NotImplemented*.\n'
                 '\n'
                 '   Note that ternary "pow()" will not try calling '
                 '"__rpow__()" (the\n'
                 '   coercion rules would become too complicated).\n'
                 '\n'
                 '   Note:\n'
                 '\n'
                 '     If the right operand’s type is a subclass of the left '
                 'operand’s\n'
                 '     type and that subclass provides a different '
                 'implementation of the\n'
                 '     reflected method for the operation, this method will be '
                 'called\n'
                 '     before the left operand’s non-reflected method. This '
                 'behavior\n'
                 '     allows subclasses to override their ancestors’ '
                 'operations.\n'
                 '\n'
                 'object.__iadd__(self, other)\n'
                 'object.__isub__(self, other)\n'
                 'object.__imul__(self, other)\n'
                 'object.__imatmul__(self, other)\n'
                 'object.__itruediv__(self, other)\n'
                 'object.__ifloordiv__(self, other)\n'
                 'object.__imod__(self, other)\n'
                 'object.__ipow__(self, other[, modulo])\n'
                 'object.__ilshift__(self, other)\n'
                 'object.__irshift__(self, other)\n'
                 'object.__iand__(self, other)\n'
                 'object.__ixor__(self, other)\n'
                 'object.__ior__(self, other)\n'
                 '\n'
                 '   These methods are called to implement the augmented '
                 'arithmetic\n'
                 '   assignments ("+=", "-=", "*=", "@=", "/=", "//=", "%=", '
                 '"**=",\n'
                 '   "<<=", ">>=", "&=", "^=", "|=").  These methods should '
                 'attempt to\n'
                 '   do the operation in-place (modifying *self*) and return '
                 'the result\n'
                 '   (which could be, but does not have to be, *self*).  If a '
                 'specific\n'
                 '   method is not defined, the augmented assignment falls '
                 'back to the\n'
                 '   normal methods.  For instance, if *x* is an instance of a '
                 'class\n'
                 '   with an "__iadd__()" method, "x += y" is equivalent to "x '
                 '=\n'
                 '   x.__iadd__(y)" . Otherwise, "x.__add__(y)" and '
                 '"y.__radd__(x)" are\n'
                 '   considered, as with the evaluation of "x + y". In '
                 'certain\n'
                 '   situations, augmented assignment can result in unexpected '
                 'errors\n'
                 '   (see Why does a_tuple[i] += [‘item’] raise an exception '
                 'when the\n'
                 '   addition works?), but this behavior is in fact part of '
                 'the data\n'
                 '   model.\n'
                 '\n'
                 'object.__neg__(self)\n'
                 'object.__pos__(self)\n'
                 'object.__abs__(self)\n'
                 'object.__invert__(self)\n'
                 '\n'
                 '   Called to implement the unary arithmetic operations ("-", '
                 '"+",\n'
                 '   "abs()" and "~").\n'
                 '\n'
                 'object.__complex__(self)\n'
                 'object.__int__(self)\n'
                 'object.__float__(self)\n'
                 '\n'
                 '   Called to implement the built-in functions "complex()", '
                 '"int()" and\n'
                 '   "float()".  Should return a value of the appropriate '
                 'type.\n'
                 '\n'
                 'object.__index__(self)\n'
                 '\n'
                 '   Called to implement "operator.index()", and whenever '
                 'Python needs\n'
                 '   to losslessly convert the numeric object to an integer '
                 'object (such\n'
                 '   as in slicing, or in the built-in "bin()", "hex()" and '
                 '"oct()"\n'
                 '   functions). Presence of this method indicates that the '
                 'numeric\n'
                 '   object is an integer type.  Must return an integer.\n'
                 '\n'
                 '   If "__int__()", "__float__()" and "__complex__()" are not '
                 'defined\n'
                 '   then corresponding built-in functions "int()", "float()" '
                 'and\n'
                 '   "complex()" fall back to "__index__()".\n'
                 '\n'
                 'object.__round__(self[, ndigits])\n'
                 'object.__trunc__(self)\n'
                 'object.__floor__(self)\n'
                 'object.__ceil__(self)\n'
                 '\n'
                 '   Called to implement the built-in function "round()" and '
                 '"math"\n'
                 '   functions "trunc()", "floor()" and "ceil()". Unless '
                 '*ndigits* is\n'
                 '   passed to "__round__()" all these methods should return '
                 'the value\n'
                 '   of the object truncated to an "Integral" (typically an '
                 '"int").\n'
                 '\n'
                 '   The built-in function "int()" falls back to "__trunc__()" '
                 'if\n'
                 '   neither "__int__()" nor "__index__()" is defined.\n'
                 '\n'
                 '   Changed in version 3.11: The delegation of "int()" to '
                 '"__trunc__()"\n'
                 '   is deprecated.\n'
                 '\n'
                 '\n'
                 'With Statement Context Managers\n'
                 '===============================\n'
                 '\n'
                 'A *context manager* is an object that defines the runtime '
                 'context to\n'
                 'be established when executing a "with" statement. The '
                 'context manager\n'
                 'handles the entry into, and the exit from, the desired '
                 'runtime context\n'
                 'for the execution of the block of code.  Context managers '
                 'are normally\n'
                 'invoked using the "with" statement (described in section The '
                 'with\n'
                 'statement), but can also be used by directly invoking their '
                 'methods.\n'
                 '\n'
                 'Typical uses of context managers include saving and '
                 'restoring various\n'
                 'kinds of global state, locking and unlocking resources, '
                 'closing opened\n'
                 'files, etc.\n'
                 '\n'
                 'For more information on context managers, see Context '
                 'Manager Types.\n'
                 '\n'
                 'object.__enter__(self)\n'
                 '\n'
                 '   Enter the runtime context related to this object. The '
                 '"with"\n'
                 '   statement will bind this method’s return value to the '
                 'target(s)\n'
                 '   specified in the "as" clause of the statement, if any.\n'
                 '\n'
                 'object.__exit__(self, exc_type, exc_value, traceback)\n'
                 '\n'
                 '   Exit the runtime context related to this object. The '
                 'parameters\n'
                 '   describe the exception that caused the context to be '
                 'exited. If the\n'
                 '   context was exited without an exception, all three '
                 'arguments will\n'
                 '   be "None".\n'
                 '\n'
                 '   If an exception is supplied, and the method wishes to '
                 'suppress the\n'
                 '   exception (i.e., prevent it from being propagated), it '
                 'should\n'
                 '   return a true value. Otherwise, the exception will be '
                 'processed\n'
                 '   normally upon exit from this method.\n'
                 '\n'
                 '   Note that "__exit__()" methods should not reraise the '
                 'passed-in\n'
                 '   exception; this is the caller’s responsibility.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 343** - The “with” statement\n'
                 '     The specification, background, and examples for the '
                 'Python "with"\n'
                 '     statement.\n'
                 '\n'
                 '\n'
                 'Customizing positional arguments in class pattern matching\n'
                 '==========================================================\n'
                 '\n'
                 'When using a class name in a pattern, positional arguments '
                 'in the\n'
                 'pattern are not allowed by default, i.e. "case MyClass(x, '
                 'y)" is\n'
                 'typically invalid without special support in "MyClass". To '
                 'be able to\n'
                 'use that kind of pattern, the class needs to define a '
                 '*__match_args__*\n'
                 'attribute.\n'
                 '\n'
                 'object.__match_args__\n'
                 '\n'
                 '   This class variable can be assigned a tuple of strings. '
                 'When this\n'
                 '   class is used in a class pattern with positional '
                 'arguments, each\n'
                 '   positional argument will be converted into a keyword '
                 'argument,\n'
                 '   using the corresponding value in *__match_args__* as the '
                 'keyword.\n'
                 '   The absence of this attribute is equivalent to setting it '
                 'to "()".\n'
                 '\n'
                 'For example, if "MyClass.__match_args__" is "("left", '
                 '"center",\n'
                 '"right")" that means that "case MyClass(x, y)" is equivalent '
                 'to "case\n'
                 'MyClass(left=x, center=y)". Note that the number of '
                 'arguments in the\n'
                 'pattern must be smaller than or equal to the number of '
                 'elements in\n'
                 '*__match_args__*; if it is larger, the pattern match attempt '
                 'will\n'
                 'raise a "TypeError".\n'
                 '\n'
                 'New in version 3.10.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  **PEP 634** - Structural Pattern Matching\n'
                 '     The specification for the Python "match" statement.\n'
                 '\n'
                 '\n'
                 'Special method lookup\n'
                 '=====================\n'
                 '\n'
                 'For custom classes, implicit invocations of special methods '
                 'are only\n'
                 'guaranteed to work correctly if defined on an object’s type, '
                 'not in\n'
                 'the object’s instance dictionary.  That behaviour is the '
                 'reason why\n'
                 'the following code raises an exception:\n'
                 '\n'
                 '   >>> class C:\n'
                 '   ...     pass\n'
                 '   ...\n'
                 '   >>> c = C()\n'
                 '   >>> c.__len__ = lambda: 5\n'
                 '   >>> len(c)\n'
                 '   Traceback (most recent call last):\n'
                 '     File "<stdin>", line 1, in <module>\n'
                 "   TypeError: object of type 'C' has no len()\n"
                 '\n'
                 'The rationale behind this behaviour lies with a number of '
                 'special\n'
                 'methods such as "__hash__()" and "__repr__()" that are '
                 'implemented by\n'
                 'all objects, including type objects. If the implicit lookup '
                 'of these\n'
                 'methods used the conventional lookup process, they would '
                 'fail when\n'
                 'invoked on the type object itself:\n'
                 '\n'
                 '   >>> 1 .__hash__() == hash(1)\n'
                 '   True\n'
                 '   >>> int.__hash__() == hash(int)\n'
                 '   Traceback (most recent call last):\n'
                 '     File "<stdin>", line 1, in <module>\n'
                 "   TypeError: descriptor '__hash__' of 'int' object needs an "
                 'argument\n'
                 '\n'
                 'Incorrectly attempting to invoke an unbound method of a '
                 'class in this\n'
                 'way is sometimes referred to as ‘metaclass confusion’, and '
                 'is avoided\n'
                 'by bypassing the instance when looking up special methods:\n'
                 '\n'
                 '   >>> type(1).__hash__(1) == hash(1)\n'
                 '   True\n'
                 '   >>> type(int).__hash__(int) == hash(int)\n'
                 '   True\n'
                 '\n'
                 'In addition to bypassing any instance attributes in the '
                 'interest of\n'
                 'correctness, implicit special method lookup generally also '
                 'bypasses\n'
                 'the "__getattribute__()" method even of the object’s '
                 'metaclass:\n'
                 '\n'
                 '   >>> class Meta(type):\n'
                 '   ...     def __getattribute__(*args):\n'
                 '   ...         print("Metaclass getattribute invoked")\n'
                 '   ...         return type.__getattribute__(*args)\n'
                 '   ...\n'
                 '   >>> class C(object, metaclass=Meta):\n'
                 '   ...     def __len__(self):\n'
                 '   ...         return 10\n'
                 '   ...     def __getattribute__(*args):\n'
                 '   ...         print("Class getattribute invoked")\n'
                 '   ...         return object.__getattribute__(*args)\n'
                 '   ...\n'
                 '   >>> c = C()\n'
                 '   >>> c.__len__()                 # Explicit lookup via '
                 'instance\n'
                 '   Class getattribute invoked\n'
                 '   10\n'
                 '   >>> type(c).__len__(c)          # Explicit lookup via '
                 'type\n'
                 '   Metaclass getattribute invoked\n'
                 '   10\n'
                 '   >>> len(c)                      # Implicit lookup\n'
                 '   10\n'
                 '\n'
                 'Bypassing the "__getattribute__()" machinery in this fashion '
                 'provides\n'
                 'significant scope for speed optimisations within the '
                 'interpreter, at\n'
                 'the cost of some flexibility in the handling of special '
                 'methods (the\n'
                 'special method *must* be set on the class object itself in '
                 'order to be\n'
                 'consistently invoked by the interpreter).\n',
 'string-methods': 'String Methods\n'
                   '**************\n'
                   '\n'
                   'Strings implement all of the common sequence operations, '
                   'along with\n'
                   'the additional methods described below.\n'
                   '\n'
                   'Strings also support two styles of string formatting, one '
                   'providing a\n'
                   'large degree of flexibility and customization (see '
                   '"str.format()",\n'
                   'Format String Syntax and Custom String Formatting) and the '
                   'other based\n'
                   'on C "printf" style formatting that handles a narrower '
                   'range of types\n'
                   'and is slightly harder to use correctly, but is often '
                   'faster for the\n'
                   'cases it can handle (printf-style String Formatting).\n'
                   '\n'
                   'The Text Processing Services section of the standard '
                   'library covers a\n'
                   'number of other modules that provide various text related '
                   'utilities\n'
                   '(including regular expression support in the "re" '
                   'module).\n'
                   '\n'
                   'str.capitalize()\n'
                   '\n'
                   '   Return a copy of the string with its first character '
                   'capitalized\n'
                   '   and the rest lowercased.\n'
                   '\n'
                   '   Changed in version 3.8: The first character is now put '
                   'into\n'
                   '   titlecase rather than uppercase. This means that '
                   'characters like\n'
                   '   digraphs will only have their first letter capitalized, '
                   'instead of\n'
                   '   the full character.\n'
                   '\n'
                   'str.casefold()\n'
                   '\n'
                   '   Return a casefolded copy of the string. Casefolded '
                   'strings may be\n'
                   '   used for caseless matching.\n'
                   '\n'
                   '   Casefolding is similar to lowercasing but more '
                   'aggressive because\n'
                   '   it is intended to remove all case distinctions in a '
                   'string. For\n'
                   '   example, the German lowercase letter "\'ß\'" is '
                   'equivalent to ""ss"".\n'
                   '   Since it is already lowercase, "lower()" would do '
                   'nothing to "\'ß\'";\n'
                   '   "casefold()" converts it to ""ss"".\n'
                   '\n'
                   '   The casefolding algorithm is described in section 3.13 '
                   'of the\n'
                   '   Unicode Standard.\n'
                   '\n'
                   '   New in version 3.3.\n'
                   '\n'
                   'str.center(width[, fillchar])\n'
                   '\n'
                   '   Return centered in a string of length *width*. Padding '
                   'is done\n'
                   '   using the specified *fillchar* (default is an ASCII '
                   'space). The\n'
                   '   original string is returned if *width* is less than or '
                   'equal to\n'
                   '   "len(s)".\n'
                   '\n'
                   'str.count(sub[, start[, end]])\n'
                   '\n'
                   '   Return the number of non-overlapping occurrences of '
                   'substring *sub*\n'
                   '   in the range [*start*, *end*].  Optional arguments '
                   '*start* and\n'
                   '   *end* are interpreted as in slice notation.\n'
                   '\n'
                   '   If *sub* is empty, returns the number of empty strings '
                   'between\n'
                   '   characters which is the length of the string plus one.\n'
                   '\n'
                   "str.encode(encoding='utf-8', errors='strict')\n"
                   '\n'
                   '   Return the string encoded to "bytes".\n'
                   '\n'
                   '   *encoding* defaults to "\'utf-8\'"; see Standard '
                   'Encodings for\n'
                   '   possible values.\n'
                   '\n'
                   '   *errors* controls how encoding errors are handled. If '
                   '"\'strict\'"\n'
                   '   (the default), a "UnicodeError" exception is raised. '
                   'Other possible\n'
                   '   values are "\'ignore\'", "\'replace\'", '
                   '"\'xmlcharrefreplace\'",\n'
                   '   "\'backslashreplace\'" and any other name registered '
                   'via\n'
                   '   "codecs.register_error()". See Error Handlers for '
                   'details.\n'
                   '\n'
                   '   For performance reasons, the value of *errors* is not '
                   'checked for\n'
                   '   validity unless an encoding error actually occurs, '
                   'Python\n'
                   '   Development Mode is enabled or a debug build is used.\n'
                   '\n'
                   '   Changed in version 3.1: Added support for keyword '
                   'arguments.\n'
                   '\n'
                   '   Changed in version 3.9: The value of the *errors* '
                   'argument is now\n'
                   '   checked in Python Development Mode and in debug mode.\n'
                   '\n'
                   'str.endswith(suffix[, start[, end]])\n'
                   '\n'
                   '   Return "True" if the string ends with the specified '
                   '*suffix*,\n'
                   '   otherwise return "False".  *suffix* can also be a tuple '
                   'of suffixes\n'
                   '   to look for.  With optional *start*, test beginning at '
                   'that\n'
                   '   position.  With optional *end*, stop comparing at that '
                   'position.\n'
                   '\n'
                   'str.expandtabs(tabsize=8)\n'
                   '\n'
                   '   Return a copy of the string where all tab characters '
                   'are replaced\n'
                   '   by one or more spaces, depending on the current column '
                   'and the\n'
                   '   given tab size.  Tab positions occur every *tabsize* '
                   'characters\n'
                   '   (default is 8, giving tab positions at columns 0, 8, 16 '
                   'and so on).\n'
                   '   To expand the string, the current column is set to zero '
                   'and the\n'
                   '   string is examined character by character.  If the '
                   'character is a\n'
                   '   tab ("\\t"), one or more space characters are inserted '
                   'in the result\n'
                   '   until the current column is equal to the next tab '
                   'position. (The\n'
                   '   tab character itself is not copied.)  If the character '
                   'is a newline\n'
                   '   ("\\n") or return ("\\r"), it is copied and the current '
                   'column is\n'
                   '   reset to zero.  Any other character is copied unchanged '
                   'and the\n'
                   '   current column is incremented by one regardless of how '
                   'the\n'
                   '   character is represented when printed.\n'
                   '\n'
                   "   >>> '01\\t012\\t0123\\t01234'.expandtabs()\n"
                   "   '01      012     0123    01234'\n"
                   "   >>> '01\\t012\\t0123\\t01234'.expandtabs(4)\n"
                   "   '01  012 0123    01234'\n"
                   '\n'
                   'str.find(sub[, start[, end]])\n'
                   '\n'
                   '   Return the lowest index in the string where substring '
                   '*sub* is\n'
                   '   found within the slice "s[start:end]".  Optional '
                   'arguments *start*\n'
                   '   and *end* are interpreted as in slice notation.  Return '
                   '"-1" if\n'
                   '   *sub* is not found.\n'
                   '\n'
                   '   Note:\n'
                   '\n'
                   '     The "find()" method should be used only if you need '
                   'to know the\n'
                   '     position of *sub*.  To check if *sub* is a substring '
                   'or not, use\n'
                   '     the "in" operator:\n'
                   '\n'
                   "        >>> 'Py' in 'Python'\n"
                   '        True\n'
                   '\n'
                   'str.format(*args, **kwargs)\n'
                   '\n'
                   '   Perform a string formatting operation.  The string on '
                   'which this\n'
                   '   method is called can contain literal text or '
                   'replacement fields\n'
                   '   delimited by braces "{}".  Each replacement field '
                   'contains either\n'
                   '   the numeric index of a positional argument, or the name '
                   'of a\n'
                   '   keyword argument.  Returns a copy of the string where '
                   'each\n'
                   '   replacement field is replaced with the string value of '
                   'the\n'
                   '   corresponding argument.\n'
                   '\n'
                   '   >>> "The sum of 1 + 2 is {0}".format(1+2)\n'
                   "   'The sum of 1 + 2 is 3'\n"
                   '\n'
                   '   See Format String Syntax for a description of the '
                   'various\n'
                   '   formatting options that can be specified in format '
                   'strings.\n'
                   '\n'
                   '   Note:\n'
                   '\n'
                   '     When formatting a number ("int", "float", "complex",\n'
                   '     "decimal.Decimal" and subclasses) with the "n" type '
                   '(ex:\n'
                   '     "\'{:n}\'.format(1234)"), the function temporarily '
                   'sets the\n'
                   '     "LC_CTYPE" locale to the "LC_NUMERIC" locale to '
                   'decode\n'
                   '     "decimal_point" and "thousands_sep" fields of '
                   '"localeconv()" if\n'
                   '     they are non-ASCII or longer than 1 byte, and the '
                   '"LC_NUMERIC"\n'
                   '     locale is different than the "LC_CTYPE" locale.  This '
                   'temporary\n'
                   '     change affects other threads.\n'
                   '\n'
                   '   Changed in version 3.7: When formatting a number with '
                   'the "n" type,\n'
                   '   the function sets temporarily the "LC_CTYPE" locale to '
                   'the\n'
                   '   "LC_NUMERIC" locale in some cases.\n'
                   '\n'
                   'str.format_map(mapping)\n'
                   '\n'
                   '   Similar to "str.format(**mapping)", except that '
                   '"mapping" is used\n'
                   '   directly and not copied to a "dict".  This is useful if '
                   'for example\n'
                   '   "mapping" is a dict subclass:\n'
                   '\n'
                   '   >>> class Default(dict):\n'
                   '   ...     def __missing__(self, key):\n'
                   '   ...         return key\n'
                   '   ...\n'
                   "   >>> '{name} was born in "
                   "{country}'.format_map(Default(name='Guido'))\n"
                   "   'Guido was born in country'\n"
                   '\n'
                   '   New in version 3.2.\n'
                   '\n'
                   'str.index(sub[, start[, end]])\n'
                   '\n'
                   '   Like "find()", but raise "ValueError" when the '
                   'substring is not\n'
                   '   found.\n'
                   '\n'
                   'str.isalnum()\n'
                   '\n'
                   '   Return "True" if all characters in the string are '
                   'alphanumeric and\n'
                   '   there is at least one character, "False" otherwise.  A '
                   'character\n'
                   '   "c" is alphanumeric if one of the following returns '
                   '"True":\n'
                   '   "c.isalpha()", "c.isdecimal()", "c.isdigit()", or '
                   '"c.isnumeric()".\n'
                   '\n'
                   'str.isalpha()\n'
                   '\n'
                   '   Return "True" if all characters in the string are '
                   'alphabetic and\n'
                   '   there is at least one character, "False" otherwise.  '
                   'Alphabetic\n'
                   '   characters are those characters defined in the Unicode '
                   'character\n'
                   '   database as “Letter”, i.e., those with general category '
                   'property\n'
                   '   being one of “Lm”, “Lt”, “Lu”, “Ll”, or “Lo”.  Note '
                   'that this is\n'
                   '   different from the “Alphabetic” property defined in the '
                   'Unicode\n'
                   '   Standard.\n'
                   '\n'
                   'str.isascii()\n'
                   '\n'
                   '   Return "True" if the string is empty or all characters '
                   'in the\n'
                   '   string are ASCII, "False" otherwise. ASCII characters '
                   'have code\n'
                   '   points in the range U+0000-U+007F.\n'
                   '\n'
                   '   New in version 3.7.\n'
                   '\n'
                   'str.isdecimal()\n'
                   '\n'
                   '   Return "True" if all characters in the string are '
                   'decimal\n'
                   '   characters and there is at least one character, "False" '
                   'otherwise.\n'
                   '   Decimal characters are those that can be used to form '
                   'numbers in\n'
                   '   base 10, e.g. U+0660, ARABIC-INDIC DIGIT ZERO.  '
                   'Formally a decimal\n'
                   '   character is a character in the Unicode General '
                   'Category “Nd”.\n'
                   '\n'
                   'str.isdigit()\n'
                   '\n'
                   '   Return "True" if all characters in the string are '
                   'digits and there\n'
                   '   is at least one character, "False" otherwise.  Digits '
                   'include\n'
                   '   decimal characters and digits that need special '
                   'handling, such as\n'
                   '   the compatibility superscript digits. This covers '
                   'digits which\n'
                   '   cannot be used to form numbers in base 10, like the '
                   'Kharosthi\n'
                   '   numbers.  Formally, a digit is a character that has the '
                   'property\n'
                   '   value Numeric_Type=Digit or Numeric_Type=Decimal.\n'
                   '\n'
                   'str.isidentifier()\n'
                   '\n'
                   '   Return "True" if the string is a valid identifier '
                   'according to the\n'
                   '   language definition, section Identifiers and keywords.\n'
                   '\n'
                   '   Call "keyword.iskeyword()" to test whether string "s" '
                   'is a reserved\n'
                   '   identifier, such as "def" and "class".\n'
                   '\n'
                   '   Example:\n'
                   '\n'
                   '      >>> from keyword import iskeyword\n'
                   '\n'
                   "      >>> 'hello'.isidentifier(), iskeyword('hello')\n"
                   '      (True, False)\n'
                   "      >>> 'def'.isidentifier(), iskeyword('def')\n"
                   '      (True, True)\n'
                   '\n'
                   'str.islower()\n'
                   '\n'
                   '   Return "True" if all cased characters [4] in the string '
                   'are\n'
                   '   lowercase and there is at least one cased character, '
                   '"False"\n'
                   '   otherwise.\n'
                   '\n'
                   'str.isnumeric()\n'
                   '\n'
                   '   Return "True" if all characters in the string are '
                   'numeric\n'
                   '   characters, and there is at least one character, '
                   '"False" otherwise.\n'
                   '   Numeric characters include digit characters, and all '
                   'characters\n'
                   '   that have the Unicode numeric value property, e.g. '
                   'U+2155, VULGAR\n'
                   '   FRACTION ONE FIFTH.  Formally, numeric characters are '
                   'those with\n'
                   '   the property value Numeric_Type=Digit, '
                   'Numeric_Type=Decimal or\n'
                   '   Numeric_Type=Numeric.\n'
                   '\n'
                   'str.isprintable()\n'
                   '\n'
                   '   Return "True" if all characters in the string are '
                   'printable or the\n'
                   '   string is empty, "False" otherwise.  Nonprintable '
                   'characters are\n'
                   '   those characters defined in the Unicode character '
                   'database as\n'
                   '   “Other” or “Separator”, excepting the ASCII space '
                   '(0x20) which is\n'
                   '   considered printable.  (Note that printable characters '
                   'in this\n'
                   '   context are those which should not be escaped when '
                   '"repr()" is\n'
                   '   invoked on a string.  It has no bearing on the handling '
                   'of strings\n'
                   '   written to "sys.stdout" or "sys.stderr".)\n'
                   '\n'
                   'str.isspace()\n'
                   '\n'
                   '   Return "True" if there are only whitespace characters '
                   'in the string\n'
                   '   and there is at least one character, "False" '
                   'otherwise.\n'
                   '\n'
                   '   A character is *whitespace* if in the Unicode character '
                   'database\n'
                   '   (see "unicodedata"), either its general category is '
                   '"Zs"\n'
                   '   (“Separator, space”), or its bidirectional class is one '
                   'of "WS",\n'
                   '   "B", or "S".\n'
                   '\n'
                   'str.istitle()\n'
                   '\n'
                   '   Return "True" if the string is a titlecased string and '
                   'there is at\n'
                   '   least one character, for example uppercase characters '
                   'may only\n'
                   '   follow uncased characters and lowercase characters only '
                   'cased ones.\n'
                   '   Return "False" otherwise.\n'
                   '\n'
                   'str.isupper()\n'
                   '\n'
                   '   Return "True" if all cased characters [4] in the string '
                   'are\n'
                   '   uppercase and there is at least one cased character, '
                   '"False"\n'
                   '   otherwise.\n'
                   '\n'
                   "   >>> 'BANANA'.isupper()\n"
                   '   True\n'
                   "   >>> 'banana'.isupper()\n"
                   '   False\n'
                   "   >>> 'baNana'.isupper()\n"
                   '   False\n'
                   "   >>> ' '.isupper()\n"
                   '   False\n'
                   '\n'
                   'str.join(iterable)\n'
                   '\n'
                   '   Return a string which is the concatenation of the '
                   'strings in\n'
                   '   *iterable*. A "TypeError" will be raised if there are '
                   'any non-\n'
                   '   string values in *iterable*, including "bytes" '
                   'objects.  The\n'
                   '   separator between elements is the string providing this '
                   'method.\n'
                   '\n'
                   'str.ljust(width[, fillchar])\n'
                   '\n'
                   '   Return the string left justified in a string of length '
                   '*width*.\n'
                   '   Padding is done using the specified *fillchar* (default '
                   'is an ASCII\n'
                   '   space). The original string is returned if *width* is '
                   'less than or\n'
                   '   equal to "len(s)".\n'
                   '\n'
                   'str.lower()\n'
                   '\n'
                   '   Return a copy of the string with all the cased '
                   'characters [4]\n'
                   '   converted to lowercase.\n'
                   '\n'
                   '   The lowercasing algorithm used is described in section '
                   '3.13 of the\n'
                   '   Unicode Standard.\n'
                   '\n'
                   'str.lstrip([chars])\n'
                   '\n'
                   '   Return a copy of the string with leading characters '
                   'removed.  The\n'
                   '   *chars* argument is a string specifying the set of '
                   'characters to be\n'
                   '   removed.  If omitted or "None", the *chars* argument '
                   'defaults to\n'
                   '   removing whitespace.  The *chars* argument is not a '
                   'prefix; rather,\n'
                   '   all combinations of its values are stripped:\n'
                   '\n'
                   "      >>> '   spacious   '.lstrip()\n"
                   "      'spacious   '\n"
                   "      >>> 'www.example.com'.lstrip('cmowz.')\n"
                   "      'example.com'\n"
                   '\n'
                   '   See "str.removeprefix()" for a method that will remove '
                   'a single\n'
                   '   prefix string rather than all of a set of characters.  '
                   'For example:\n'
                   '\n'
                   "      >>> 'Arthur: three!'.lstrip('Arthur: ')\n"
                   "      'ee!'\n"
                   "      >>> 'Arthur: three!'.removeprefix('Arthur: ')\n"
                   "      'three!'\n"
                   '\n'
                   'static str.maketrans(x[, y[, z]])\n'
                   '\n'
                   '   This static method returns a translation table usable '
                   'for\n'
                   '   "str.translate()".\n'
                   '\n'
                   '   If there is only one argument, it must be a dictionary '
                   'mapping\n'
                   '   Unicode ordinals (integers) or characters (strings of '
                   'length 1) to\n'
                   '   Unicode ordinals, strings (of arbitrary lengths) or '
                   '"None".\n'
                   '   Character keys will then be converted to ordinals.\n'
                   '\n'
                   '   If there are two arguments, they must be strings of '
                   'equal length,\n'
                   '   and in the resulting dictionary, each character in x '
                   'will be mapped\n'
                   '   to the character at the same position in y.  If there '
                   'is a third\n'
                   '   argument, it must be a string, whose characters will be '
                   'mapped to\n'
                   '   "None" in the result.\n'
                   '\n'
                   'str.partition(sep)\n'
                   '\n'
                   '   Split the string at the first occurrence of *sep*, and '
                   'return a\n'
                   '   3-tuple containing the part before the separator, the '
                   'separator\n'
                   '   itself, and the part after the separator.  If the '
                   'separator is not\n'
                   '   found, return a 3-tuple containing the string itself, '
                   'followed by\n'
                   '   two empty strings.\n'
                   '\n'
                   'str.removeprefix(prefix, /)\n'
                   '\n'
                   '   If the string starts with the *prefix* string, return\n'
                   '   "string[len(prefix):]". Otherwise, return a copy of the '
                   'original\n'
                   '   string:\n'
                   '\n'
                   "      >>> 'TestHook'.removeprefix('Test')\n"
                   "      'Hook'\n"
                   "      >>> 'BaseTestCase'.removeprefix('Test')\n"
                   "      'BaseTestCase'\n"
                   '\n'
                   '   New in version 3.9.\n'
                   '\n'
                   'str.removesuffix(suffix, /)\n'
                   '\n'
                   '   If the string ends with the *suffix* string and that '
                   '*suffix* is\n'
                   '   not empty, return "string[:-len(suffix)]". Otherwise, '
                   'return a copy\n'
                   '   of the original string:\n'
                   '\n'
                   "      >>> 'MiscTests'.removesuffix('Tests')\n"
                   "      'Misc'\n"
                   "      >>> 'TmpDirMixin'.removesuffix('Tests')\n"
                   "      'TmpDirMixin'\n"
                   '\n'
                   '   New in version 3.9.\n'
                   '\n'
                   'str.replace(old, new[, count])\n'
                   '\n'
                   '   Return a copy of the string with all occurrences of '
                   'substring *old*\n'
                   '   replaced by *new*.  If the optional argument *count* is '
                   'given, only\n'
                   '   the first *count* occurrences are replaced.\n'
                   '\n'
                   'str.rfind(sub[, start[, end]])\n'
                   '\n'
                   '   Return the highest index in the string where substring '
                   '*sub* is\n'
                   '   found, such that *sub* is contained within '
                   '"s[start:end]".\n'
                   '   Optional arguments *start* and *end* are interpreted as '
                   'in slice\n'
                   '   notation.  Return "-1" on failure.\n'
                   '\n'
                   'str.rindex(sub[, start[, end]])\n'
                   '\n'
                   '   Like "rfind()" but raises "ValueError" when the '
                   'substring *sub* is\n'
                   '   not found.\n'
                   '\n'
                   'str.rjust(width[, fillchar])\n'
                   '\n'
                   '   Return the string right justified in a string of length '
                   '*width*.\n'
                   '   Padding is done using the specified *fillchar* (default '
                   'is an ASCII\n'
                   '   space). The original string is returned if *width* is '
                   'less than or\n'
                   '   equal to "len(s)".\n'
                   '\n'
                   'str.rpartition(sep)\n'
                   '\n'
                   '   Split the string at the last occurrence of *sep*, and '
                   'return a\n'
                   '   3-tuple containing the part before the separator, the '
                   'separator\n'
                   '   itself, and the part after the separator.  If the '
                   'separator is not\n'
                   '   found, return a 3-tuple containing two empty strings, '
                   'followed by\n'
                   '   the string itself.\n'
                   '\n'
                   'str.rsplit(sep=None, maxsplit=-1)\n'
                   '\n'
                   '   Return a list of the words in the string, using *sep* '
                   'as the\n'
                   '   delimiter string. If *maxsplit* is given, at most '
                   '*maxsplit* splits\n'
                   '   are done, the *rightmost* ones.  If *sep* is not '
                   'specified or\n'
                   '   "None", any whitespace string is a separator.  Except '
                   'for splitting\n'
                   '   from the right, "rsplit()" behaves like "split()" which '
                   'is\n'
                   '   described in detail below.\n'
                   '\n'
                   'str.rstrip([chars])\n'
                   '\n'
                   '   Return a copy of the string with trailing characters '
                   'removed.  The\n'
                   '   *chars* argument is a string specifying the set of '
                   'characters to be\n'
                   '   removed.  If omitted or "None", the *chars* argument '
                   'defaults to\n'
                   '   removing whitespace.  The *chars* argument is not a '
                   'suffix; rather,\n'
                   '   all combinations of its values are stripped:\n'
                   '\n'
                   "      >>> '   spacious   '.rstrip()\n"
                   "      '   spacious'\n"
                   "      >>> 'mississippi'.rstrip('ipz')\n"
                   "      'mississ'\n"
                   '\n'
                   '   See "str.removesuffix()" for a method that will remove '
                   'a single\n'
                   '   suffix string rather than all of a set of characters.  '
                   'For example:\n'
                   '\n'
                   "      >>> 'Monty Python'.rstrip(' Python')\n"
                   "      'M'\n"
                   "      >>> 'Monty Python'.removesuffix(' Python')\n"
                   "      'Monty'\n"
                   '\n'
                   'str.split(sep=None, maxsplit=-1)\n'
                   '\n'
                   '   Return a list of the words in the string, using *sep* '
                   'as the\n'
                   '   delimiter string.  If *maxsplit* is given, at most '
                   '*maxsplit*\n'
                   '   splits are done (thus, the list will have at most '
                   '"maxsplit+1"\n'
                   '   elements).  If *maxsplit* is not specified or "-1", '
                   'then there is\n'
                   '   no limit on the number of splits (all possible splits '
                   'are made).\n'
                   '\n'
                   '   If *sep* is given, consecutive delimiters are not '
                   'grouped together\n'
                   '   and are deemed to delimit empty strings (for example,\n'
                   '   "\'1,,2\'.split(\',\')" returns "[\'1\', \'\', '
                   '\'2\']").  The *sep* argument\n'
                   '   may consist of multiple characters (for example,\n'
                   '   "\'1<>2<>3\'.split(\'<>\')" returns "[\'1\', \'2\', '
                   '\'3\']"). Splitting an\n'
                   '   empty string with a specified separator returns '
                   '"[\'\']".\n'
                   '\n'
                   '   For example:\n'
                   '\n'
                   "      >>> '1,2,3'.split(',')\n"
                   "      ['1', '2', '3']\n"
                   "      >>> '1,2,3'.split(',', maxsplit=1)\n"
                   "      ['1', '2,3']\n"
                   "      >>> '1,2,,3,'.split(',')\n"
                   "      ['1', '2', '', '3', '']\n"
                   '\n'
                   '   If *sep* is not specified or is "None", a different '
                   'splitting\n'
                   '   algorithm is applied: runs of consecutive whitespace '
                   'are regarded\n'
                   '   as a single separator, and the result will contain no '
                   'empty strings\n'
                   '   at the start or end if the string has leading or '
                   'trailing\n'
                   '   whitespace.  Consequently, splitting an empty string or '
                   'a string\n'
                   '   consisting of just whitespace with a "None" separator '
                   'returns "[]".\n'
                   '\n'
                   '   For example:\n'
                   '\n'
                   "      >>> '1 2 3'.split()\n"
                   "      ['1', '2', '3']\n"
                   "      >>> '1 2 3'.split(maxsplit=1)\n"
                   "      ['1', '2 3']\n"
                   "      >>> '   1   2   3   '.split()\n"
                   "      ['1', '2', '3']\n"
                   '\n'
                   'str.splitlines(keepends=False)\n'
                   '\n'
                   '   Return a list of the lines in the string, breaking at '
                   'line\n'
                   '   boundaries.  Line breaks are not included in the '
                   'resulting list\n'
                   '   unless *keepends* is given and true.\n'
                   '\n'
                   '   This method splits on the following line boundaries.  '
                   'In\n'
                   '   particular, the boundaries are a superset of *universal '
                   'newlines*.\n'
                   '\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | Representation          | '
                   'Description                   |\n'
                   '   '
                   '|=========================|===============================|\n'
                   '   | "\\n"                    | Line '
                   'Feed                     |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\r"                    | Carriage '
                   'Return               |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\r\\n"                  | Carriage Return + Line '
                   'Feed   |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\v" or "\\x0b"          | Line '
                   'Tabulation               |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\f" or "\\x0c"          | Form '
                   'Feed                     |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\x1c"                  | File '
                   'Separator                |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\x1d"                  | Group '
                   'Separator               |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\x1e"                  | Record '
                   'Separator              |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\x85"                  | Next Line (C1 Control '
                   'Code)   |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\u2028"                | Line '
                   'Separator                |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '   | "\\u2029"                | Paragraph '
                   'Separator           |\n'
                   '   '
                   '+-------------------------+-------------------------------+\n'
                   '\n'
                   '   Changed in version 3.2: "\\v" and "\\f" added to list '
                   'of line\n'
                   '   boundaries.\n'
                   '\n'
                   '   For example:\n'
                   '\n'
                   "      >>> 'ab c\\n\\nde fg\\rkl\\r\\n'.splitlines()\n"
                   "      ['ab c', '', 'de fg', 'kl']\n"
                   "      >>> 'ab c\\n\\nde "
                   "fg\\rkl\\r\\n'.splitlines(keepends=True)\n"
                   "      ['ab c\\n', '\\n', 'de fg\\r', 'kl\\r\\n']\n"
                   '\n'
                   '   Unlike "split()" when a delimiter string *sep* is '
                   'given, this\n'
                   '   method returns an empty list for the empty string, and '
                   'a terminal\n'
                   '   line break does not result in an extra line:\n'
                   '\n'
                   '      >>> "".splitlines()\n'
                   '      []\n'
                   '      >>> "One line\\n".splitlines()\n'
                   "      ['One line']\n"
                   '\n'
                   '   For comparison, "split(\'\\n\')" gives:\n'
                   '\n'
                   "      >>> ''.split('\\n')\n"
                   "      ['']\n"
                   "      >>> 'Two lines\\n'.split('\\n')\n"
                   "      ['Two lines', '']\n"
                   '\n'
                   'str.startswith(prefix[, start[, end]])\n'
                   '\n'
                   '   Return "True" if string starts with the *prefix*, '
                   'otherwise return\n'
                   '   "False". *prefix* can also be a tuple of prefixes to '
                   'look for.\n'
                   '   With optional *start*, test string beginning at that '
                   'position.\n'
                   '   With optional *end*, stop comparing string at that '
                   'position.\n'
                   '\n'
                   'str.strip([chars])\n'
                   '\n'
                   '   Return a copy of the string with the leading and '
                   'trailing\n'
                   '   characters removed. The *chars* argument is a string '
                   'specifying the\n'
                   '   set of characters to be removed. If omitted or "None", '
                   'the *chars*\n'
                   '   argument defaults to removing whitespace. The *chars* '
                   'argument is\n'
                   '   not a prefix or suffix; rather, all combinations of its '
                   'values are\n'
                   '   stripped:\n'
                   '\n'
                   "      >>> '   spacious   '.strip()\n"
                   "      'spacious'\n"
                   "      >>> 'www.example.com'.strip('cmowz.')\n"
                   "      'example'\n"
                   '\n'
                   '   The outermost leading and trailing *chars* argument '
                   'values are\n'
                   '   stripped from the string. Characters are removed from '
                   'the leading\n'
                   '   end until reaching a string character that is not '
                   'contained in the\n'
                   '   set of characters in *chars*. A similar action takes '
                   'place on the\n'
                   '   trailing end. For example:\n'
                   '\n'
                   "      >>> comment_string = '#....... Section 3.2.1 Issue "
                   "#32 .......'\n"
                   "      >>> comment_string.strip('.#! ')\n"
                   "      'Section 3.2.1 Issue #32'\n"
                   '\n'
                   'str.swapcase()\n'
                   '\n'
                   '   Return a copy of the string with uppercase characters '
                   'converted to\n'
                   '   lowercase and vice versa. Note that it is not '
                   'necessarily true that\n'
                   '   "s.swapcase().swapcase() == s".\n'
                   '\n'
                   'str.title()\n'
                   '\n'
                   '   Return a titlecased version of the string where words '
                   'start with an\n'
                   '   uppercase character and the remaining characters are '
                   'lowercase.\n'
                   '\n'
                   '   For example:\n'
                   '\n'
                   "      >>> 'Hello world'.title()\n"
                   "      'Hello World'\n"
                   '\n'
                   '   The algorithm uses a simple language-independent '
                   'definition of a\n'
                   '   word as groups of consecutive letters.  The definition '
                   'works in\n'
                   '   many contexts but it means that apostrophes in '
                   'contractions and\n'
                   '   possessives form word boundaries, which may not be the '
                   'desired\n'
                   '   result:\n'
                   '\n'
                   '      >>> "they\'re bill\'s friends from the UK".title()\n'
                   '      "They\'Re Bill\'S Friends From The Uk"\n'
                   '\n'
                   '   The "string.capwords()" function does not have this '
                   'problem, as it\n'
                   '   splits words on spaces only.\n'
                   '\n'
                   '   Alternatively, a workaround for apostrophes can be '
                   'constructed\n'
                   '   using regular expressions:\n'
                   '\n'
                   '      >>> import re\n'
                   '      >>> def titlecase(s):\n'
                   '      ...     return re.sub(r"[A-Za-z]+(\'[A-Za-z]+)?",\n'
                   '      ...                   lambda mo: '
                   'mo.group(0).capitalize(),\n'
                   '      ...                   s)\n'
                   '      ...\n'
                   '      >>> titlecase("they\'re bill\'s friends.")\n'
                   '      "They\'re Bill\'s Friends."\n'
                   '\n'
                   'str.translate(table)\n'
                   '\n'
                   '   Return a copy of the string in which each character has '
                   'been mapped\n'
                   '   through the given translation table.  The table must be '
                   'an object\n'
                   '   that implements indexing via "__getitem__()", typically '
                   'a *mapping*\n'
                   '   or *sequence*.  When indexed by a Unicode ordinal (an '
                   'integer), the\n'
                   '   table object can do any of the following: return a '
                   'Unicode ordinal\n'
                   '   or a string, to map the character to one or more other '
                   'characters;\n'
                   '   return "None", to delete the character from the return '
                   'string; or\n'
                   '   raise a "LookupError" exception, to map the character '
                   'to itself.\n'
                   '\n'
                   '   You can use "str.maketrans()" to create a translation '
                   'map from\n'
                   '   character-to-character mappings in different formats.\n'
                   '\n'
                   '   See also the "codecs" module for a more flexible '
                   'approach to custom\n'
                   '   character mappings.\n'
                   '\n'
                   'str.upper()\n'
                   '\n'
                   '   Return a copy of the string with all the cased '
                   'characters [4]\n'
                   '   converted to uppercase.  Note that '
                   '"s.upper().isupper()" might be\n'
                   '   "False" if "s" contains uncased characters or if the '
                   'Unicode\n'
                   '   category of the resulting character(s) is not “Lu” '
                   '(Letter,\n'
                   '   uppercase), but e.g. “Lt” (Letter, titlecase).\n'
                   '\n'
                   '   The uppercasing algorithm used is described in section '
                   '3.13 of the\n'
                   '   Unicode Standard.\n'
                   '\n'
                   'str.zfill(width)\n'
                   '\n'
                   '   Return a copy of the string left filled with ASCII '
                   '"\'0\'" digits to\n'
                   '   make a string of length *width*. A leading sign prefix\n'
                   '   ("\'+\'"/"\'-\'") is handled by inserting the padding '
                   '*after* the sign\n'
                   '   character rather than before. The original string is '
                   'returned if\n'
                   '   *width* is less than or equal to "len(s)".\n'
                   '\n'
                   '   For example:\n'
                   '\n'
                   '      >>> "42".zfill(5)\n'
                   "      '00042'\n"
                   '      >>> "-42".zfill(5)\n'
                   "      '-0042'\n",
 'strings': 'String and Bytes literals\n'
            '*************************\n'
            '\n'
            'String literals are described by the following lexical '
            'definitions:\n'
            '\n'
            '   stringliteral   ::= [stringprefix](shortstring | longstring)\n'
            '   stringprefix    ::= "r" | "u" | "R" | "U" | "f" | "F"\n'
            '                    | "fr" | "Fr" | "fR" | "FR" | "rf" | "rF" | '
            '"Rf" | "RF"\n'
            '   shortstring     ::= "\'" shortstringitem* "\'" | \'"\' '
            'shortstringitem* \'"\'\n'
            '   longstring      ::= "\'\'\'" longstringitem* "\'\'\'" | '
            '\'"""\' longstringitem* \'"""\'\n'
            '   shortstringitem ::= shortstringchar | stringescapeseq\n'
            '   longstringitem  ::= longstringchar | stringescapeseq\n'
            '   shortstringchar ::= <any source character except "\\" or '
            'newline or the quote>\n'
            '   longstringchar  ::= <any source character except "\\">\n'
            '   stringescapeseq ::= "\\" <any source character>\n'
            '\n'
            '   bytesliteral   ::= bytesprefix(shortbytes | longbytes)\n'
            '   bytesprefix    ::= "b" | "B" | "br" | "Br" | "bR" | "BR" | '
            '"rb" | "rB" | "Rb" | "RB"\n'
            '   shortbytes     ::= "\'" shortbytesitem* "\'" | \'"\' '
            'shortbytesitem* \'"\'\n'
            '   longbytes      ::= "\'\'\'" longbytesitem* "\'\'\'" | \'"""\' '
            'longbytesitem* \'"""\'\n'
            '   shortbytesitem ::= shortbyteschar | bytesescapeseq\n'
            '   longbytesitem  ::= longbyteschar | bytesescapeseq\n'
            '   shortbyteschar ::= <any ASCII character except "\\" or newline '
            'or the quote>\n'
            '   longbyteschar  ::= <any ASCII character except "\\">\n'
            '   bytesescapeseq ::= "\\" <any ASCII character>\n'
            '\n'
            'One syntactic restriction not indicated by these productions is '
            'that\n'
            'whitespace is not allowed between the "stringprefix" or '
            '"bytesprefix"\n'
            'and the rest of the literal. The source character set is defined '
            'by\n'
            'the encoding declaration; it is UTF-8 if no encoding declaration '
            'is\n'
            'given in the source file; see section Encoding declarations.\n'
            '\n'
            'In plain English: Both types of literals can be enclosed in '
            'matching\n'
            'single quotes ("\'") or double quotes (""").  They can also be '
            'enclosed\n'
            'in matching groups of three single or double quotes (these are\n'
            'generally referred to as *triple-quoted strings*).  The '
            'backslash\n'
            '("\\") character is used to escape characters that otherwise have '
            'a\n'
            'special meaning, such as newline, backslash itself, or the quote\n'
            'character.\n'
            '\n'
            'Bytes literals are always prefixed with "\'b\'" or "\'B\'"; they '
            'produce\n'
            'an instance of the "bytes" type instead of the "str" type.  They '
            'may\n'
            'only contain ASCII characters; bytes with a numeric value of 128 '
            'or\n'
            'greater must be expressed with escapes.\n'
            '\n'
            'Both string and bytes literals may optionally be prefixed with a\n'
            'letter "\'r\'" or "\'R\'"; such strings are called *raw strings* '
            'and treat\n'
            'backslashes as literal characters.  As a result, in string '
            'literals,\n'
            '"\'\\U\'" and "\'\\u\'" escapes in raw strings are not treated '
            'specially.\n'
            'Given that Python 2.x’s raw unicode literals behave differently '
            'than\n'
            'Python 3.x’s the "\'ur\'" syntax is not supported.\n'
            '\n'
            'New in version 3.3: The "\'rb\'" prefix of raw bytes literals has '
            'been\n'
            'added as a synonym of "\'br\'".\n'
            '\n'
            'New in version 3.3: Support for the unicode legacy literal\n'
            '("u\'value\'") was reintroduced to simplify the maintenance of '
            'dual\n'
            'Python 2.x and 3.x codebases. See **PEP 414** for more '
            'information.\n'
            '\n'
            'A string literal with "\'f\'" or "\'F\'" in its prefix is a '
            '*formatted\n'
            'string literal*; see f-strings.  The "\'f\'" may be combined with '
            '"\'r\'",\n'
            'but not with "\'b\'" or "\'u\'", therefore raw formatted strings '
            'are\n'
            'possible, but formatted bytes literals are not.\n'
            '\n'
            'In triple-quoted literals, unescaped newlines and quotes are '
            'allowed\n'
            '(and are retained), except that three unescaped quotes in a row\n'
            'terminate the literal.  (A “quote” is the character used to open '
            'the\n'
            'literal, i.e. either "\'" or """.)\n'
            '\n'
            '\n'
            'Escape sequences\n'
            '================\n'
            '\n'
            'Unless an "\'r\'" or "\'R\'" prefix is present, escape sequences '
            'in string\n'
            'and bytes literals are interpreted according to rules similar to '
            'those\n'
            'used by Standard C.  The recognized escape sequences are:\n'
            '\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| Escape Sequence           | Meaning                           | '
            'Notes   |\n'
            '|===========================|===================================|=========|\n'
            '| "\\"<newline>              | Backslash and newline ignored     '
            '| (1)     |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\\\"                      | Backslash '
            '("\\")                   |         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\\'"                      | Single quote '
            '("\'")                |         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\""                      | Double quote (""")                '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\a"                      | ASCII Bell (BEL)                  '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\b"                      | ASCII Backspace (BS)              '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\f"                      | ASCII Formfeed (FF)               '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\n"                      | ASCII Linefeed (LF)               '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\r"                      | ASCII Carriage Return (CR)        '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\t"                      | ASCII Horizontal Tab (TAB)        '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\v"                      | ASCII Vertical Tab (VT)           '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\*ooo*"                  | Character with octal value *ooo*  '
            '| (2,4)   |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\x*hh*"                  | Character with hex value *hh*     '
            '| (3,4)   |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '\n'
            'Escape sequences only recognized in string literals are:\n'
            '\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| Escape Sequence           | Meaning                           | '
            'Notes   |\n'
            '|===========================|===================================|=========|\n'
            '| "\\N{*name*}"              | Character named *name* in the     '
            '| (5)     |\n'
            '|                           | Unicode database                  '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\u*xxxx*"                | Character with 16-bit hex value   '
            '| (6)     |\n'
            '|                           | *xxxx*                            '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '| "\\U*xxxxxxxx*"            | Character with 32-bit hex value   '
            '| (7)     |\n'
            '|                           | *xxxxxxxx*                        '
            '|         |\n'
            '+---------------------------+-----------------------------------+---------+\n'
            '\n'
            'Notes:\n'
            '\n'
            '1. A backslash can be added at the end of a line to ignore the\n'
            '   newline:\n'
            '\n'
            "      >>> 'This string will not include \\\n"
            "      ... backslashes or newline characters.'\n"
            "      'This string will not include backslashes or newline "
            "characters.'\n"
            '\n'
            '   The same result can be achieved using triple-quoted strings, '
            'or\n'
            '   parentheses and string literal concatenation.\n'
            '\n'
            '2. As in Standard C, up to three octal digits are accepted.\n'
            '\n'
            '   Changed in version 3.11: Octal escapes with value larger than\n'
            '   "0o377" produce a "DeprecationWarning". In a future Python '
            'version\n'
            '   they will be a "SyntaxWarning" and eventually a '
            '"SyntaxError".\n'
            '\n'
            '3. Unlike in Standard C, exactly two hex digits are required.\n'
            '\n'
            '4. In a bytes literal, hexadecimal and octal escapes denote the '
            'byte\n'
            '   with the given value. In a string literal, these escapes '
            'denote a\n'
            '   Unicode character with the given value.\n'
            '\n'
            '5. Changed in version 3.3: Support for name aliases [1] has been\n'
            '   added.\n'
            '\n'
            '6. Exactly four hex digits are required.\n'
            '\n'
            '7. Any Unicode character can be encoded this way.  Exactly eight '
            'hex\n'
            '   digits are required.\n'
            '\n'
            'Unlike Standard C, all unrecognized escape sequences are left in '
            'the\n'
            'string unchanged, i.e., *the backslash is left in the result*.  '
            '(This\n'
            'behavior is useful when debugging: if an escape sequence is '
            'mistyped,\n'
            'the resulting output is more easily recognized as broken.)  It is '
            'also\n'
            'important to note that the escape sequences only recognized in '
            'string\n'
            'literals fall into the category of unrecognized escapes for '
            'bytes\n'
            'literals.\n'
            '\n'
            'Changed in version 3.6: Unrecognized escape sequences produce a\n'
            '"DeprecationWarning".  In a future Python version they will be a\n'
            '"SyntaxWarning" and eventually a "SyntaxError".\n'
            '\n'
            'Even in a raw literal, quotes can be escaped with a backslash, '
            'but the\n'
            'backslash remains in the result; for example, "r"\\""" is a '
            'valid\n'
            'string literal consisting of two characters: a backslash and a '
            'double\n'
            'quote; "r"\\"" is not a valid string literal (even a raw string '
            'cannot\n'
            'end in an odd number of backslashes).  Specifically, *a raw '
            'literal\n'
            'cannot end in a single backslash* (since the backslash would '
            'escape\n'
            'the following quote character).  Note also that a single '
            'backslash\n'
            'followed by a newline is interpreted as those two characters as '
            'part\n'
            'of the literal, *not* as a line continuation.\n',
 'subscriptions': 'Subscriptions\n'
                  '*************\n'
                  '\n'
                  'The subscription of an instance of a container class will '
                  'generally\n'
                  'select an element from the container. The subscription of a '
                  '*generic\n'
                  'class* will generally return a GenericAlias object.\n'
                  '\n'
                  '   subscription ::= primary "[" expression_list "]"\n'
                  '\n'
                  'When an object is subscripted, the interpreter will '
                  'evaluate the\n'
                  'primary and the expression list.\n'
                  '\n'
                  'The primary must evaluate to an object that supports '
                  'subscription. An\n'
                  'object may support subscription through defining one or '
                  'both of\n'
                  '"__getitem__()" and "__class_getitem__()". When the primary '
                  'is\n'
                  'subscripted, the evaluated result of the expression list '
                  'will be\n'
                  'passed to one of these methods. For more details on when\n'
                  '"__class_getitem__" is called instead of "__getitem__", '
                  'see\n'
                  '__class_getitem__ versus __getitem__.\n'
                  '\n'
                  'If the expression list contains at least one comma, it will '
                  'evaluate\n'
                  'to a "tuple" containing the items of the expression list. '
                  'Otherwise,\n'
                  'the expression list will evaluate to the value of the '
                  'list’s sole\n'
                  'member.\n'
                  '\n'
                  'For built-in objects, there are two types of objects that '
                  'support\n'
                  'subscription via "__getitem__()":\n'
                  '\n'
                  '1. Mappings. If the primary is a *mapping*, the expression '
                  'list must\n'
                  '   evaluate to an object whose value is one of the keys of '
                  'the\n'
                  '   mapping, and the subscription selects the value in the '
                  'mapping that\n'
                  '   corresponds to that key. An example of a builtin mapping '
                  'class is\n'
                  '   the "dict" class.\n'
                  '\n'
                  '2. Sequences. If the primary is a *sequence*, the '
                  'expression list must\n'
                  '   evaluate to an "int" or a "slice" (as discussed in the '
                  'following\n'
                  '   section). Examples of builtin sequence classes include '
                  'the "str",\n'
                  '   "list" and "tuple" classes.\n'
                  '\n'
                  'The formal syntax makes no special provision for negative '
                  'indices in\n'
                  '*sequences*. However, built-in sequences all provide a '
                  '"__getitem__()"\n'
                  'method that interprets negative indices by adding the '
                  'length of the\n'
                  'sequence to the index so that, for example, "x[-1]" selects '
                  'the last\n'
                  'item of "x". The resulting value must be a nonnegative '
                  'integer less\n'
                  'than the number of items in the sequence, and the '
                  'subscription selects\n'
                  'the item whose index is that value (counting from zero). '
                  'Since the\n'
                  'support for negative indices and slicing occurs in the '
                  'object’s\n'
                  '"__getitem__()" method, subclasses overriding this method '
                  'will need to\n'
                  'explicitly add that support.\n'
                  '\n'
                  'A "string" is a special kind of sequence whose items are '
                  '*characters*.\n'
                  'A character is not a separate data type but a string of '
                  'exactly one\n'
                  'character.\n',
 'truth': 'Truth Value Testing\n'
          '*******************\n'
          '\n'
          'Any object can be tested for truth value, for use in an "if" or\n'
          '"while" condition or as operand of the Boolean operations below.\n'
          '\n'
          'By default, an object is considered true unless its class defines\n'
          'either a "__bool__()" method that returns "False" or a "__len__()"\n'
          'method that returns zero, when called with the object. [1]  Here '
          'are\n'
          'most of the built-in objects considered false:\n'
          '\n'
          '* constants defined to be false: "None" and "False"\n'
          '\n'
          '* zero of any numeric type: "0", "0.0", "0j", "Decimal(0)",\n'
          '  "Fraction(0, 1)"\n'
          '\n'
          '* empty sequences and collections: "\'\'", "()", "[]", "{}", '
          '"set()",\n'
          '  "range(0)"\n'
          '\n'
          'Operations and built-in functions that have a Boolean result '
          'always\n'
          'return "0" or "False" for false and "1" or "True" for true, unless\n'
          'otherwise stated. (Important exception: the Boolean operations '
          '"or"\n'
          'and "and" always return one of their operands.)\n',
 'try': 'The "try" statement\n'
        '*******************\n'
        '\n'
        'The "try" statement specifies exception handlers and/or cleanup code\n'
        'for a group of statements:\n'
        '\n'
        '   try_stmt  ::= try1_stmt | try2_stmt | try3_stmt\n'
        '   try1_stmt ::= "try" ":" suite\n'
        '                 ("except" [expression ["as" identifier]] ":" '
        'suite)+\n'
        '                 ["else" ":" suite]\n'
        '                 ["finally" ":" suite]\n'
        '   try2_stmt ::= "try" ":" suite\n'
        '                 ("except" "*" expression ["as" identifier] ":" '
        'suite)+\n'
        '                 ["else" ":" suite]\n'
        '                 ["finally" ":" suite]\n'
        '   try3_stmt ::= "try" ":" suite\n'
        '                 "finally" ":" suite\n'
        '\n'
        'Additional information on exceptions can be found in section\n'
        'Exceptions, and information on using the "raise" statement to '
        'generate\n'
        'exceptions may be found in section The raise statement.\n'
        '\n'
        '\n'
        '"except" clause\n'
        '===============\n'
        '\n'
        'The "except" clause(s) specify one or more exception handlers. When '
        'no\n'
        'exception occurs in the "try" clause, no exception handler is\n'
        'executed. When an exception occurs in the "try" suite, a search for '
        'an\n'
        'exception handler is started. This search inspects the "except"\n'
        'clauses in turn until one is found that matches the exception. An\n'
        'expression-less "except" clause, if present, must be last; it '
        'matches\n'
        'any exception. For an "except" clause with an expression, that\n'
        'expression is evaluated, and the clause matches the exception if the\n'
        'resulting object is “compatible” with the exception.  An object is\n'
        'compatible with an exception if the object is the class or a *non-\n'
        'virtual base class* of the exception object, or a tuple containing '
        'an\n'
        'item that is the class or a non-virtual base class of the exception\n'
        'object.\n'
        '\n'
        'If no "except" clause matches the exception, the search for an\n'
        'exception handler continues in the surrounding code and on the\n'
        'invocation stack.  [1]\n'
        '\n'
        'If the evaluation of an expression in the header of an "except" '
        'clause\n'
        'raises an exception, the original search for a handler is canceled '
        'and\n'
        'a search starts for the new exception in the surrounding code and on\n'
        'the call stack (it is treated as if the entire "try" statement '
        'raised\n'
        'the exception).\n'
        '\n'
        'When a matching "except" clause is found, the exception is assigned '
        'to\n'
        'the target specified after the "as" keyword in that "except" clause,\n'
        'if present, and the "except" clause’s suite is executed. All '
        '"except"\n'
        'clauses must have an executable block. When the end of this block is\n'
        'reached, execution continues normally after the entire "try"\n'
        'statement. (This means that if two nested handlers exist for the '
        'same\n'
        'exception, and the exception occurs in the "try" clause of the inner\n'
        'handler, the outer handler will not handle the exception.)\n'
        '\n'
        'When an exception has been assigned using "as target", it is cleared\n'
        'at the end of the "except" clause.  This is as if\n'
        '\n'
        '   except E as N:\n'
        '       foo\n'
        '\n'
        'was translated to\n'
        '\n'
        '   except E as N:\n'
        '       try:\n'
        '           foo\n'
        '       finally:\n'
        '           del N\n'
        '\n'
        'This means the exception must be assigned to a different name to be\n'
        'able to refer to it after the "except" clause. Exceptions are '
        'cleared\n'
        'because with the traceback attached to them, they form a reference\n'
        'cycle with the stack frame, keeping all locals in that frame alive\n'
        'until the next garbage collection occurs.\n'
        '\n'
        'Before an "except" clause’s suite is executed, the exception is '
        'stored\n'
        'in the "sys" module, where it can be accessed from within the body '
        'of\n'
        'the "except" clause by calling "sys.exception()". When leaving an\n'
        'exception handler, the exception stored in the "sys" module is reset\n'
        'to its previous value:\n'
        '\n'
        '   >>> print(sys.exception())\n'
        '   None\n'
        '   >>> try:\n'
        '   ...     raise TypeError\n'
        '   ... except:\n'
        '   ...     print(repr(sys.exception()))\n'
        '   ...     try:\n'
        '   ...          raise ValueError\n'
        '   ...     except:\n'
        '   ...         print(repr(sys.exception()))\n'
        '   ...     print(repr(sys.exception()))\n'
        '   ...\n'
        '   TypeError()\n'
        '   ValueError()\n'
        '   TypeError()\n'
        '   >>> print(sys.exception())\n'
        '   None\n'
        '\n'
        '\n'
        '"except*" clause\n'
        '================\n'
        '\n'
        'The "except*" clause(s) are used for handling "ExceptionGroup"s. The\n'
        'exception type for matching is interpreted as in the case of '
        '"except",\n'
        'but in the case of exception groups we can have partial matches when\n'
        'the type matches some of the exceptions in the group. This means '
        'that\n'
        'multiple "except*" clauses can execute, each handling part of the\n'
        'exception group. Each clause executes at most once and handles an\n'
        'exception group of all matching exceptions.  Each exception in the\n'
        'group is handled by at most one "except*" clause, the first that\n'
        'matches it.\n'
        '\n'
        '   >>> try:\n'
        '   ...     raise ExceptionGroup("eg",\n'
        '   ...         [ValueError(1), TypeError(2), OSError(3), '
        'OSError(4)])\n'
        '   ... except* TypeError as e:\n'
        "   ...     print(f'caught {type(e)} with nested {e.exceptions}')\n"
        '   ... except* OSError as e:\n'
        "   ...     print(f'caught {type(e)} with nested {e.exceptions}')\n"
        '   ...\n'
        "   caught <class 'ExceptionGroup'> with nested (TypeError(2),)\n"
        "   caught <class 'ExceptionGroup'> with nested (OSError(3), "
        'OSError(4))\n'
        '     + Exception Group Traceback (most recent call last):\n'
        '     |   File "<stdin>", line 2, in <module>\n'
        '     | ExceptionGroup: eg\n'
        '     +-+---------------- 1 ----------------\n'
        '       | ValueError: 1\n'
        '       +------------------------------------\n'
        '\n'
        'Any remaining exceptions that were not handled by any "except*" '
        'clause\n'
        'are re-raised at the end, combined into an exception group along '
        'with\n'
        'all exceptions that were raised from within "except*" clauses.\n'
        '\n'
        'From version 3.11.4, when the entire "ExceptionGroup" is handled and\n'
        'only one exception is raised from an "except*" clause, this '
        'exception\n'
        'is no longer wrapped to form a new "ExceptionGroup".\n'
        '\n'
        'If the raised exception is not an exception group and its type '
        'matches\n'
        'one of the "except*" clauses, it is caught and wrapped by an '
        'exception\n'
        'group with an empty message string.\n'
        '\n'
        '   >>> try:\n'
        '   ...     raise BlockingIOError\n'
        '   ... except* BlockingIOError as e:\n'
        '   ...     print(repr(e))\n'
        '   ...\n'
        "   ExceptionGroup('', (BlockingIOError()))\n"
        '\n'
        'An "except*" clause must have a matching type, and this type cannot '
        'be\n'
        'a subclass of "BaseExceptionGroup". It is not possible to mix '
        '"except"\n'
        'and "except*" in the same "try". "break", "continue" and "return"\n'
        'cannot appear in an "except*" clause.\n'
        '\n'
        '\n'
        '"else" clause\n'
        '=============\n'
        '\n'
        'The optional "else" clause is executed if the control flow leaves '
        'the\n'
        '"try" suite, no exception was raised, and no "return", "continue", '
        'or\n'
        '"break" statement was executed.  Exceptions in the "else" clause are\n'
        'not handled by the preceding "except" clauses.\n'
        '\n'
        '\n'
        '"finally" clause\n'
        '================\n'
        '\n'
        'If "finally" is present, it specifies a ‘cleanup’ handler.  The '
        '"try"\n'
        'clause is executed, including any "except" and "else" clauses.  If '
        'an\n'
        'exception occurs in any of the clauses and is not handled, the\n'
        'exception is temporarily saved. The "finally" clause is executed.  '
        'If\n'
        'there is a saved exception it is re-raised at the end of the '
        '"finally"\n'
        'clause.  If the "finally" clause raises another exception, the saved\n'
        'exception is set as the context of the new exception. If the '
        '"finally"\n'
        'clause executes a "return", "break" or "continue" statement, the '
        'saved\n'
        'exception is discarded:\n'
        '\n'
        '   >>> def f():\n'
        '   ...     try:\n'
        '   ...         1/0\n'
        '   ...     finally:\n'
        '   ...         return 42\n'
        '   ...\n'
        '   >>> f()\n'
        '   42\n'
        '\n'
        'The exception information is not available to the program during\n'
        'execution of the "finally" clause.\n'
        '\n'
        'When a "return", "break" or "continue" statement is executed in the\n'
        '"try" suite of a "try"…"finally" statement, the "finally" clause is\n'
        'also executed ‘on the way out.’\n'
        '\n'
        'The return value of a function is determined by the last "return"\n'
        'statement executed.  Since the "finally" clause always executes, a\n'
        '"return" statement executed in the "finally" clause will always be '
        'the\n'
        'last one executed:\n'
        '\n'
        '   >>> def foo():\n'
        '   ...     try:\n'
        "   ...         return 'try'\n"
        '   ...     finally:\n'
        "   ...         return 'finally'\n"
        '   ...\n'
        '   >>> foo()\n'
        "   'finally'\n"
        '\n'
        'Changed in version 3.8: Prior to Python 3.8, a "continue" statement\n'
        'was illegal in the "finally" clause due to a problem with the\n'
        'implementation.\n',
 'types': 'The standard type hierarchy\n'
          '***************************\n'
          '\n'
          'Below is a list of the types that are built into Python.  '
          'Extension\n'
          'modules (written in C, Java, or other languages, depending on the\n'
          'implementation) can define additional types.  Future versions of\n'
          'Python may add types to the type hierarchy (e.g., rational '
          'numbers,\n'
          'efficiently stored arrays of integers, etc.), although such '
          'additions\n'
          'will often be provided via the standard library instead.\n'
          '\n'
          'Some of the type descriptions below contain a paragraph listing\n'
          '‘special attributes.’  These are attributes that provide access to '
          'the\n'
          'implementation and are not intended for general use.  Their '
          'definition\n'
          'may change in the future.\n'
          '\n'
          '\n'
          'None\n'
          '====\n'
          '\n'
          'This type has a single value.  There is a single object with this\n'
          'value. This object is accessed through the built-in name "None". It '
          'is\n'
          'used to signify the absence of a value in many situations, e.g., it '
          'is\n'
          'returned from functions that don’t explicitly return anything. Its\n'
          'truth value is false.\n'
          '\n'
          '\n'
          'NotImplemented\n'
          '==============\n'
          '\n'
          'This type has a single value.  There is a single object with this\n'
          'value. This object is accessed through the built-in name\n'
          '"NotImplemented". Numeric methods and rich comparison methods '
          'should\n'
          'return this value if they do not implement the operation for the\n'
          'operands provided.  (The interpreter will then try the reflected\n'
          'operation, or some other fallback, depending on the operator.)  It\n'
          'should not be evaluated in a boolean context.\n'
          '\n'
          'See Implementing the arithmetic operations for more details.\n'
          '\n'
          'Changed in version 3.9: Evaluating "NotImplemented" in a boolean\n'
          'context is deprecated. While it currently evaluates as true, it '
          'will\n'
          'emit a "DeprecationWarning". It will raise a "TypeError" in a '
          'future\n'
          'version of Python.\n'
          '\n'
          '\n'
          'Ellipsis\n'
          '========\n'
          '\n'
          'This type has a single value.  There is a single object with this\n'
          'value. This object is accessed through the literal "..." or the '
          'built-\n'
          'in name "Ellipsis".  Its truth value is true.\n'
          '\n'
          '\n'
          '"numbers.Number"\n'
          '================\n'
          '\n'
          'These are created by numeric literals and returned as results by\n'
          'arithmetic operators and arithmetic built-in functions.  Numeric\n'
          'objects are immutable; once created their value never changes.  '
          'Python\n'
          'numbers are of course strongly related to mathematical numbers, '
          'but\n'
          'subject to the limitations of numerical representation in '
          'computers.\n'
          '\n'
          'The string representations of the numeric classes, computed by\n'
          '"__repr__()" and "__str__()", have the following properties:\n'
          '\n'
          '* They are valid numeric literals which, when passed to their '
          'class\n'
          '  constructor, produce an object having the value of the original\n'
          '  numeric.\n'
          '\n'
          '* The representation is in base 10, when possible.\n'
          '\n'
          '* Leading zeros, possibly excepting a single zero before a decimal\n'
          '  point, are not shown.\n'
          '\n'
          '* Trailing zeros, possibly excepting a single zero after a decimal\n'
          '  point, are not shown.\n'
          '\n'
          '* A sign is shown only when the number is negative.\n'
          '\n'
          'Python distinguishes between integers, floating point numbers, and\n'
          'complex numbers:\n'
          '\n'
          '\n'
          '"numbers.Integral"\n'
          '------------------\n'
          '\n'
          'These represent elements from the mathematical set of integers\n'
          '(positive and negative).\n'
          '\n'
          'Note:\n'
          '\n'
          '  The rules for integer representation are intended to give the '
          'most\n'
          '  meaningful interpretation of shift and mask operations involving\n'
          '  negative integers.\n'
          '\n'
          'There are two types of integers:\n'
          '\n'
          'Integers ("int")\n'
          '   These represent numbers in an unlimited range, subject to '
          'available\n'
          '   (virtual) memory only.  For the purpose of shift and mask\n'
          '   operations, a binary representation is assumed, and negative\n'
          '   numbers are represented in a variant of 2’s complement which '
          'gives\n'
          '   the illusion of an infinite string of sign bits extending to '
          'the\n'
          '   left.\n'
          '\n'
          'Booleans ("bool")\n'
          '   These represent the truth values False and True.  The two '
          'objects\n'
          '   representing the values "False" and "True" are the only Boolean\n'
          '   objects. The Boolean type is a subtype of the integer type, and\n'
          '   Boolean values behave like the values 0 and 1, respectively, in\n'
          '   almost all contexts, the exception being that when converted to '
          'a\n'
          '   string, the strings ""False"" or ""True"" are returned,\n'
          '   respectively.\n'
          '\n'
          '\n'
          '"numbers.Real" ("float")\n'
          '------------------------\n'
          '\n'
          'These represent machine-level double precision floating point '
          'numbers.\n'
          'You are at the mercy of the underlying machine architecture (and C '
          'or\n'
          'Java implementation) for the accepted range and handling of '
          'overflow.\n'
          'Python does not support single-precision floating point numbers; '
          'the\n'
          'savings in processor and memory usage that are usually the reason '
          'for\n'
          'using these are dwarfed by the overhead of using objects in Python, '
          'so\n'
          'there is no reason to complicate the language with two kinds of\n'
          'floating point numbers.\n'
          '\n'
          '\n'
          '"numbers.Complex" ("complex")\n'
          '-----------------------------\n'
          '\n'
          'These represent complex numbers as a pair of machine-level double\n'
          'precision floating point numbers.  The same caveats apply as for\n'
          'floating point numbers. The real and imaginary parts of a complex\n'
          'number "z" can be retrieved through the read-only attributes '
          '"z.real"\n'
          'and "z.imag".\n'
          '\n'
          '\n'
          'Sequences\n'
          '=========\n'
          '\n'
          'These represent finite ordered sets indexed by non-negative '
          'numbers.\n'
          'The built-in function "len()" returns the number of items of a\n'
          'sequence. When the length of a sequence is *n*, the index set '
          'contains\n'
          'the numbers 0, 1, …, *n*-1.  Item *i* of sequence *a* is selected '
          'by\n'
          '"a[i]".\n'
          '\n'
          'Sequences also support slicing: "a[i:j]" selects all items with '
          'index\n'
          '*k* such that *i* "<=" *k* "<" *j*.  When used as an expression, a\n'
          'slice is a sequence of the same type.  This implies that the index '
          'set\n'
          'is renumbered so that it starts at 0.\n'
          '\n'
          'Some sequences also support “extended slicing” with a third “step”\n'
          'parameter: "a[i:j:k]" selects all items of *a* with index *x* where '
          '"x\n'
          '= i + n*k", *n* ">=" "0" and *i* "<=" *x* "<" *j*.\n'
          '\n'
          'Sequences are distinguished according to their mutability:\n'
          '\n'
          '\n'
          'Immutable sequences\n'
          '-------------------\n'
          '\n'
          'An object of an immutable sequence type cannot change once it is\n'
          'created.  (If the object contains references to other objects, '
          'these\n'
          'other objects may be mutable and may be changed; however, the\n'
          'collection of objects directly referenced by an immutable object\n'
          'cannot change.)\n'
          '\n'
          'The following types are immutable sequences:\n'
          '\n'
          'Strings\n'
          '   A string is a sequence of values that represent Unicode code\n'
          '   points. All the code points in the range "U+0000 - U+10FFFF" can '
          'be\n'
          '   represented in a string.  Python doesn’t have a char type; '
          'instead,\n'
          '   every code point in the string is represented as a string '
          'object\n'
          '   with length "1".  The built-in function "ord()" converts a code\n'
          '   point from its string form to an integer in the range "0 - '
          '10FFFF";\n'
          '   "chr()" converts an integer in the range "0 - 10FFFF" to the\n'
          '   corresponding length "1" string object. "str.encode()" can be '
          'used\n'
          '   to convert a "str" to "bytes" using the given text encoding, '
          'and\n'
          '   "bytes.decode()" can be used to achieve the opposite.\n'
          '\n'
          'Tuples\n'
          '   The items of a tuple are arbitrary Python objects. Tuples of two '
          'or\n'
          '   more items are formed by comma-separated lists of expressions.  '
          'A\n'
          '   tuple of one item (a ‘singleton’) can be formed by affixing a '
          'comma\n'
          '   to an expression (an expression by itself does not create a '
          'tuple,\n'
          '   since parentheses must be usable for grouping of expressions).  '
          'An\n'
          '   empty tuple can be formed by an empty pair of parentheses.\n'
          '\n'
          'Bytes\n'
          '   A bytes object is an immutable array.  The items are 8-bit '
          'bytes,\n'
          '   represented by integers in the range 0 <= x < 256.  Bytes '
          'literals\n'
          '   (like "b\'abc\'") and the built-in "bytes()" constructor can be '
          'used\n'
          '   to create bytes objects.  Also, bytes objects can be decoded to\n'
          '   strings via the "decode()" method.\n'
          '\n'
          '\n'
          'Mutable sequences\n'
          '-----------------\n'
          '\n'
          'Mutable sequences can be changed after they are created.  The\n'
          'subscription and slicing notations can be used as the target of\n'
          'assignment and "del" (delete) statements.\n'
          '\n'
          'Note:\n'
          '\n'
          '  The "collections" and "array" module provide additional examples '
          'of\n'
          '  mutable sequence types.\n'
          '\n'
          'There are currently two intrinsic mutable sequence types:\n'
          '\n'
          'Lists\n'
          '   The items of a list are arbitrary Python objects.  Lists are '
          'formed\n'
          '   by placing a comma-separated list of expressions in square\n'
          '   brackets. (Note that there are no special cases needed to form\n'
          '   lists of length 0 or 1.)\n'
          '\n'
          'Byte Arrays\n'
          '   A bytearray object is a mutable array. They are created by the\n'
          '   built-in "bytearray()" constructor.  Aside from being mutable '
          '(and\n'
          '   hence unhashable), byte arrays otherwise provide the same '
          'interface\n'
          '   and functionality as immutable "bytes" objects.\n'
          '\n'
          '\n'
          'Set types\n'
          '=========\n'
          '\n'
          'These represent unordered, finite sets of unique, immutable '
          'objects.\n'
          'As such, they cannot be indexed by any subscript. However, they can '
          'be\n'
          'iterated over, and the built-in function "len()" returns the number '
          'of\n'
          'items in a set. Common uses for sets are fast membership testing,\n'
          'removing duplicates from a sequence, and computing mathematical\n'
          'operations such as intersection, union, difference, and symmetric\n'
          'difference.\n'
          '\n'
          'For set elements, the same immutability rules apply as for '
          'dictionary\n'
          'keys. Note that numeric types obey the normal rules for numeric\n'
          'comparison: if two numbers compare equal (e.g., "1" and "1.0"), '
          'only\n'
          'one of them can be contained in a set.\n'
          '\n'
          'There are currently two intrinsic set types:\n'
          '\n'
          'Sets\n'
          '   These represent a mutable set. They are created by the built-in\n'
          '   "set()" constructor and can be modified afterwards by several\n'
          '   methods, such as "add()".\n'
          '\n'
          'Frozen sets\n'
          '   These represent an immutable set.  They are created by the '
          'built-in\n'
          '   "frozenset()" constructor.  As a frozenset is immutable and\n'
          '   *hashable*, it can be used again as an element of another set, '
          'or\n'
          '   as a dictionary key.\n'
          '\n'
          '\n'
          'Mappings\n'
          '========\n'
          '\n'
          'These represent finite sets of objects indexed by arbitrary index\n'
          'sets. The subscript notation "a[k]" selects the item indexed by '
          '"k"\n'
          'from the mapping "a"; this can be used in expressions and as the\n'
          'target of assignments or "del" statements. The built-in function\n'
          '"len()" returns the number of items in a mapping.\n'
          '\n'
          'There is currently a single intrinsic mapping type:\n'
          '\n'
          '\n'
          'Dictionaries\n'
          '------------\n'
          '\n'
          'These represent finite sets of objects indexed by nearly arbitrary\n'
          'values.  The only types of values not acceptable as keys are '
          'values\n'
          'containing lists or dictionaries or other mutable types that are\n'
          'compared by value rather than by object identity, the reason being\n'
          'that the efficient implementation of dictionaries requires a key’s\n'
          'hash value to remain constant. Numeric types used for keys obey '
          'the\n'
          'normal rules for numeric comparison: if two numbers compare equal\n'
          '(e.g., "1" and "1.0") then they can be used interchangeably to '
          'index\n'
          'the same dictionary entry.\n'
          '\n'
          'Dictionaries preserve insertion order, meaning that keys will be\n'
          'produced in the same order they were added sequentially over the\n'
          'dictionary. Replacing an existing key does not change the order,\n'
          'however removing a key and re-inserting it will add it to the end\n'
          'instead of keeping its old place.\n'
          '\n'
          'Dictionaries are mutable; they can be created by the "{...}" '
          'notation\n'
          '(see section Dictionary displays).\n'
          '\n'
          'The extension modules "dbm.ndbm" and "dbm.gnu" provide additional\n'
          'examples of mapping types, as does the "collections" module.\n'
          '\n'
          'Changed in version 3.7: Dictionaries did not preserve insertion '
          'order\n'
          'in versions of Python before 3.6. In CPython 3.6, insertion order '
          'was\n'
          'preserved, but it was considered an implementation detail at that '
          'time\n'
          'rather than a language guarantee.\n'
          '\n'
          '\n'
          'Callable types\n'
          '==============\n'
          '\n'
          'These are the types to which the function call operation (see '
          'section\n'
          'Calls) can be applied:\n'
          '\n'
          '\n'
          'User-defined functions\n'
          '----------------------\n'
          '\n'
          'A user-defined function object is created by a function definition\n'
          '(see section Function definitions).  It should be called with an\n'
          'argument list containing the same number of items as the '
          'function’s\n'
          'formal parameter list.\n'
          '\n'
          '\n'
          'Special read-only attributes\n'
          '~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| Attribute                                          | '
          'Meaning                                            |\n'
          '|====================================================|====================================================|\n'
          '| function.__globals__                               | A reference '
          'to the "dictionary" that holds the     |\n'
          '|                                                    | function’s '
          'global variables – the global namespace |\n'
          '|                                                    | of the '
          'module in which the function was defined.   |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__closure__                               | "None" or a '
          '"tuple" of cells that contain bindings |\n'
          '|                                                    | for the '
          'function’s free variables.  A cell object  |\n'
          '|                                                    | has the '
          'attribute "cell_contents". This can be     |\n'
          '|                                                    | used to get '
          'the value of the cell, as well as set  |\n'
          '|                                                    | the '
          'value.                                         |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          '\n'
          'Special writable attributes\n'
          '~~~~~~~~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          'Most of these attributes check the type of the assigned value:\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| Attribute                                          | '
          'Meaning                                            |\n'
          '|====================================================|====================================================|\n'
          '| function.__doc__                                   | The '
          'function’s documentation string, or "None" if  |\n'
          '|                                                    | unavailable. '
          'Not inherited by subclasses.          |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__name__                                  | The '
          'function’s name. See also: "__name__           |\n'
          '|                                                    | '
          'attributes".                                       |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__qualname__                              | The '
          'function’s *qualified name*. See also:         |\n'
          '|                                                    | '
          '"__qualname__ attributes".  New in version 3.3.    |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__module__                                | The name of '
          'the module the function was defined    |\n'
          '|                                                    | in, or '
          '"None" if unavailable.                      |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__defaults__                              | A "tuple" '
          'containing default *parameter* values    |\n'
          '|                                                    | for those '
          'parameters that have defaults, or "None" |\n'
          '|                                                    | if no '
          'parameters have a default value.             |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__code__                                  | The code '
          'object representing the compiled function |\n'
          '|                                                    | '
          'body.                                              |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__dict__                                  | The '
          'namespace supporting arbitrary function        |\n'
          '|                                                    | attributes. '
          'See also: "__dict__ attributes".       |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__annotations__                           | A '
          '"dictionary" containing annotations of           |\n'
          '|                                                    | '
          '*parameters*. The keys of the dictionary are the   |\n'
          '|                                                    | parameter '
          'names, and "\'return\'" for the return     |\n'
          '|                                                    | annotation, '
          'if provided. See also: Annotations     |\n'
          '|                                                    | Best '
          'Practices.                                    |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| function.__kwdefaults__                            | A '
          '"dictionary" containing defaults for keyword-    |\n'
          '|                                                    | only '
          '*parameters*.                                 |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          'Function objects also support getting and setting arbitrary\n'
          'attributes, which can be used, for example, to attach metadata to\n'
          'functions.  Regular attribute dot-notation is used to get and set '
          'such\n'
          'attributes.\n'
          '\n'
          '**CPython implementation detail:** CPython’s current '
          'implementation\n'
          'only supports function attributes on user-defined functions. '
          'Function\n'
          'attributes on built-in functions may be supported in the future.\n'
          '\n'
          'Additional information about a function’s definition can be '
          'retrieved\n'
          'from its code object (accessible via the "__code__" attribute).\n'
          '\n'
          '\n'
          'Instance methods\n'
          '----------------\n'
          '\n'
          'An instance method object combines a class, a class instance and '
          'any\n'
          'callable object (normally a user-defined function).\n'
          '\n'
          'Special read-only attributes:\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| method.__self__                                    | Refers to '
          'the class instance object to which the   |\n'
          '|                                                    | method is '
          'bound                                    |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| method.__func__                                    | Refers to '
          'the original function object             |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| method.__doc__                                     | The method’s '
          'documentation (same as                |\n'
          '|                                                    | '
          '"method.__func__.__doc__"). A "string" if the      |\n'
          '|                                                    | original '
          'function had a docstring, else "None".    |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| method.__name__                                    | The name of '
          'the method (same as                    |\n'
          '|                                                    | '
          '"method.__func__.__name__")                        |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| method.__module__                                  | The name of '
          'the module the method was defined in,  |\n'
          '|                                                    | or "None" if '
          'unavailable.                          |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          'Methods also support accessing (but not setting) the arbitrary\n'
          'function attributes on the underlying function object.\n'
          '\n'
          'User-defined method objects may be created when getting an '
          'attribute\n'
          'of a class (perhaps via an instance of that class), if that '
          'attribute\n'
          'is a user-defined function object or a "classmethod" object.\n'
          '\n'
          'When an instance method object is created by retrieving a '
          'user-defined\n'
          'function object from a class via one of its instances, its '
          '"__self__"\n'
          'attribute is the instance, and the method object is said to be\n'
          '*bound*.  The new method’s "__func__" attribute is the original\n'
          'function object.\n'
          '\n'
          'When an instance method object is created by retrieving a\n'
          '"classmethod" object from a class or instance, its "__self__"\n'
          'attribute is the class itself, and its "__func__" attribute is the\n'
          'function object underlying the class method.\n'
          '\n'
          'When an instance method object is called, the underlying function\n'
          '("__func__") is called, inserting the class instance ("__self__") '
          'in\n'
          'front of the argument list.  For instance, when "C" is a class '
          'which\n'
          'contains a definition for a function "f()", and "x" is an instance '
          'of\n'
          '"C", calling "x.f(1)" is equivalent to calling "C.f(x, 1)".\n'
          '\n'
          'When an instance method object is derived from a "classmethod" '
          'object,\n'
          'the “class instance” stored in "__self__" will actually be the '
          'class\n'
          'itself, so that calling either "x.f(1)" or "C.f(1)" is equivalent '
          'to\n'
          'calling "f(C,1)" where "f" is the underlying function.\n'
          '\n'
          'Note that the transformation from function object to instance '
          'method\n'
          'object happens each time the attribute is retrieved from the '
          'instance.\n'
          'In some cases, a fruitful optimization is to assign the attribute '
          'to a\n'
          'local variable and call that local variable. Also notice that this\n'
          'transformation only happens for user-defined functions; other '
          'callable\n'
          'objects (and all non-callable objects) are retrieved without\n'
          'transformation.  It is also important to note that user-defined\n'
          'functions which are attributes of a class instance are not '
          'converted\n'
          'to bound methods; this *only* happens when the function is an\n'
          'attribute of the class.\n'
          '\n'
          '\n'
          'Generator functions\n'
          '-------------------\n'
          '\n'
          'A function or method which uses the "yield" statement (see section '
          'The\n'
          'yield statement) is called a *generator function*.  Such a '
          'function,\n'
          'when called, always returns an *iterator* object which can be used '
          'to\n'
          'execute the body of the function:  calling the iterator’s\n'
          '"iterator.__next__()" method will cause the function to execute '
          'until\n'
          'it provides a value using the "yield" statement.  When the '
          'function\n'
          'executes a "return" statement or falls off the end, a '
          '"StopIteration"\n'
          'exception is raised and the iterator will have reached the end of '
          'the\n'
          'set of values to be returned.\n'
          '\n'
          '\n'
          'Coroutine functions\n'
          '-------------------\n'
          '\n'
          'A function or method which is defined using "async def" is called '
          'a\n'
          '*coroutine function*.  Such a function, when called, returns a\n'
          '*coroutine* object.  It may contain "await" expressions, as well '
          'as\n'
          '"async with" and "async for" statements. See also the Coroutine\n'
          'Objects section.\n'
          '\n'
          '\n'
          'Asynchronous generator functions\n'
          '--------------------------------\n'
          '\n'
          'A function or method which is defined using "async def" and which '
          'uses\n'
          'the "yield" statement is called a *asynchronous generator '
          'function*.\n'
          'Such a function, when called, returns an *asynchronous iterator*\n'
          'object which can be used in an "async for" statement to execute '
          'the\n'
          'body of the function.\n'
          '\n'
          'Calling the asynchronous iterator’s "aiterator.__anext__" method '
          'will\n'
          'return an *awaitable* which when awaited will execute until it\n'
          'provides a value using the "yield" expression.  When the function\n'
          'executes an empty "return" statement or falls off the end, a\n'
          '"StopAsyncIteration" exception is raised and the asynchronous '
          'iterator\n'
          'will have reached the end of the set of values to be yielded.\n'
          '\n'
          '\n'
          'Built-in functions\n'
          '------------------\n'
          '\n'
          'A built-in function object is a wrapper around a C function.  '
          'Examples\n'
          'of built-in functions are "len()" and "math.sin()" ("math" is a\n'
          'standard built-in module). The number and type of the arguments '
          'are\n'
          'determined by the C function. Special read-only attributes:\n'
          '\n'
          '* "__doc__" is the function’s documentation string, or "None" if\n'
          '  unavailable. See "function.__doc__".\n'
          '\n'
          '* "__name__" is the function’s name. See "function.__name__".\n'
          '\n'
          '* "__self__" is set to "None" (but see the next item).\n'
          '\n'
          '* "__module__" is the name of the module the function was defined '
          'in\n'
          '  or "None" if unavailable. See "function.__module__".\n'
          '\n'
          '\n'
          'Built-in methods\n'
          '----------------\n'
          '\n'
          'This is really a different disguise of a built-in function, this '
          'time\n'
          'containing an object passed to the C function as an implicit extra\n'
          'argument.  An example of a built-in method is "alist.append()",\n'
          'assuming *alist* is a list object. In this case, the special '
          'read-only\n'
          'attribute "__self__" is set to the object denoted by *alist*. (The\n'
          'attribute has the same semantics as it does with "other instance\n'
          'methods".)\n'
          '\n'
          '\n'
          'Classes\n'
          '-------\n'
          '\n'
          'Classes are callable.  These objects normally act as factories for '
          'new\n'
          'instances of themselves, but variations are possible for class '
          'types\n'
          'that override "__new__()".  The arguments of the call are passed '
          'to\n'
          '"__new__()" and, in the typical case, to "__init__()" to '
          'initialize\n'
          'the new instance.\n'
          '\n'
          '\n'
          'Class Instances\n'
          '---------------\n'
          '\n'
          'Instances of arbitrary classes can be made callable by defining a\n'
          '"__call__()" method in their class.\n'
          '\n'
          '\n'
          'Modules\n'
          '=======\n'
          '\n'
          'Modules are a basic organizational unit of Python code, and are\n'
          'created by the import system as invoked either by the "import"\n'
          'statement, or by calling functions such as '
          '"importlib.import_module()"\n'
          'and built-in "__import__()".  A module object has a namespace\n'
          'implemented by a "dictionary" object (this is the dictionary\n'
          'referenced by the "__globals__" attribute of functions defined in '
          'the\n'
          'module).  Attribute references are translated to lookups in this\n'
          'dictionary, e.g., "m.x" is equivalent to "m.__dict__["x"]". A '
          'module\n'
          'object does not contain the code object used to initialize the '
          'module\n'
          '(since it isn’t needed once the initialization is done).\n'
          '\n'
          'Attribute assignment updates the module’s namespace dictionary, '
          'e.g.,\n'
          '"m.x = 1" is equivalent to "m.__dict__["x"] = 1".\n'
          '\n'
          'Predefined (writable) attributes:\n'
          '\n'
          '   "__name__"\n'
          '      The module’s name.\n'
          '\n'
          '   "__doc__"\n'
          '      The module’s documentation string, or "None" if unavailable.\n'
          '\n'
          '   "__file__"\n'
          '      The pathname of the file from which the module was loaded, if '
          'it\n'
          '      was loaded from a file. The "__file__" attribute may be '
          'missing\n'
          '      for certain types of modules, such as C modules that are\n'
          '      statically linked into the interpreter.  For extension '
          'modules\n'
          '      loaded dynamically from a shared library, it’s the pathname '
          'of\n'
          '      the shared library file.\n'
          '\n'
          '   "__annotations__"\n'
          '      A dictionary containing *variable annotations* collected '
          'during\n'
          '      module body execution.  For best practices on working with\n'
          '      "__annotations__", please see Annotations Best Practices.\n'
          '\n'
          'Special read-only attribute: "__dict__" is the module’s namespace '
          'as a\n'
          'dictionary object.\n'
          '\n'
          '**CPython implementation detail:** Because of the way CPython '
          'clears\n'
          'module dictionaries, the module dictionary will be cleared when '
          'the\n'
          'module falls out of scope even if the dictionary still has live\n'
          'references.  To avoid this, copy the dictionary or keep the module\n'
          'around while using its dictionary directly.\n'
          '\n'
          '\n'
          'Custom classes\n'
          '==============\n'
          '\n'
          'Custom class types are typically created by class definitions (see\n'
          'section Class definitions).  A class has a namespace implemented by '
          'a\n'
          'dictionary object. Class attribute references are translated to\n'
          'lookups in this dictionary, e.g., "C.x" is translated to\n'
          '"C.__dict__["x"]" (although there are a number of hooks which '
          'allow\n'
          'for other means of locating attributes). When the attribute name '
          'is\n'
          'not found there, the attribute search continues in the base '
          'classes.\n'
          'This search of the base classes uses the C3 method resolution '
          'order\n'
          'which behaves correctly even in the presence of ‘diamond’ '
          'inheritance\n'
          'structures where there are multiple inheritance paths leading back '
          'to\n'
          'a common ancestor. Additional details on the C3 MRO used by Python '
          'can\n'
          'be found in the documentation accompanying the 2.3 release at\n'
          'https://www.python.org/download/releases/2.3/mro/.\n'
          '\n'
          'When a class attribute reference (for class "C", say) would yield '
          'a\n'
          'class method object, it is transformed into an instance method '
          'object\n'
          'whose "__self__" attribute is "C". When it would yield a\n'
          '"staticmethod" object, it is transformed into the object wrapped '
          'by\n'
          'the static method object. See section Implementing Descriptors for\n'
          'another way in which attributes retrieved from a class may differ '
          'from\n'
          'those actually contained in its "__dict__".\n'
          '\n'
          'Class attribute assignments update the class’s dictionary, never '
          'the\n'
          'dictionary of a base class.\n'
          '\n'
          'A class object can be called (see above) to yield a class instance\n'
          '(see below).\n'
          '\n'
          'Special attributes:\n'
          '\n'
          '   "__name__"\n'
          '      The class name.\n'
          '\n'
          '   "__module__"\n'
          '      The name of the module in which the class was defined.\n'
          '\n'
          '   "__dict__"\n'
          '      The dictionary containing the class’s namespace.\n'
          '\n'
          '   "__bases__"\n'
          '      A tuple containing the base classes, in the order of their\n'
          '      occurrence in the base class list.\n'
          '\n'
          '   "__doc__"\n'
          '      The class’s documentation string, or "None" if undefined.\n'
          '\n'
          '   "__annotations__"\n'
          '      A dictionary containing *variable annotations* collected '
          'during\n'
          '      class body execution.  For best practices on working with\n'
          '      "__annotations__", please see Annotations Best Practices.\n'
          '\n'
          '\n'
          'Class instances\n'
          '===============\n'
          '\n'
          'A class instance is created by calling a class object (see above).  '
          'A\n'
          'class instance has a namespace implemented as a dictionary which '
          'is\n'
          'the first place in which attribute references are searched.  When '
          'an\n'
          'attribute is not found there, and the instance’s class has an\n'
          'attribute by that name, the search continues with the class\n'
          'attributes.  If a class attribute is found that is a user-defined\n'
          'function object, it is transformed into an instance method object\n'
          'whose "__self__" attribute is the instance.  Static method and '
          'class\n'
          'method objects are also transformed; see above under “Classes”.  '
          'See\n'
          'section Implementing Descriptors for another way in which '
          'attributes\n'
          'of a class retrieved via its instances may differ from the objects\n'
          'actually stored in the class’s "__dict__".  If no class attribute '
          'is\n'
          'found, and the object’s class has a "__getattr__()" method, that '
          'is\n'
          'called to satisfy the lookup.\n'
          '\n'
          'Attribute assignments and deletions update the instance’s '
          'dictionary,\n'
          'never a class’s dictionary.  If the class has a "__setattr__()" or\n'
          '"__delattr__()" method, this is called instead of updating the\n'
          'instance dictionary directly.\n'
          '\n'
          'Class instances can pretend to be numbers, sequences, or mappings '
          'if\n'
          'they have methods with certain special names.  See section Special\n'
          'method names.\n'
          '\n'
          'Special attributes: "__dict__" is the attribute dictionary;\n'
          '"__class__" is the instance’s class.\n'
          '\n'
          '\n'
          'I/O objects (also known as file objects)\n'
          '========================================\n'
          '\n'
          'A *file object* represents an open file.  Various shortcuts are\n'
          'available to create file objects: the "open()" built-in function, '
          'and\n'
          'also "os.popen()", "os.fdopen()", and the "makefile()" method of\n'
          'socket objects (and perhaps by other functions or methods provided '
          'by\n'
          'extension modules).\n'
          '\n'
          'The objects "sys.stdin", "sys.stdout" and "sys.stderr" are '
          'initialized\n'
          'to file objects corresponding to the interpreter’s standard input,\n'
          'output and error streams; they are all open in text mode and '
          'therefore\n'
          'follow the interface defined by the "io.TextIOBase" abstract '
          'class.\n'
          '\n'
          '\n'
          'Internal types\n'
          '==============\n'
          '\n'
          'A few types used internally by the interpreter are exposed to the\n'
          'user. Their definitions may change with future versions of the\n'
          'interpreter, but they are mentioned here for completeness.\n'
          '\n'
          '\n'
          'Code objects\n'
          '------------\n'
          '\n'
          'Code objects represent *byte-compiled* executable Python code, or\n'
          '*bytecode*. The difference between a code object and a function '
          'object\n'
          'is that the function object contains an explicit reference to the\n'
          'function’s globals (the module in which it was defined), while a '
          'code\n'
          'object contains no context; also the default argument values are\n'
          'stored in the function object, not in the code object (because '
          'they\n'
          'represent values calculated at run-time).  Unlike function '
          'objects,\n'
          'code objects are immutable and contain no references (directly or\n'
          'indirectly) to mutable objects.\n'
          '\n'
          '\n'
          'Special read-only attributes\n'
          '~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_name                                 | The function '
          'name                                  |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_qualname                             | The fully '
          'qualified function name                  |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_argcount                             | The total '
          'number of positional *parameters*        |\n'
          '|                                                    | (including '
          'positional-only parameters and          |\n'
          '|                                                    | parameters '
          'with default values) that the function  |\n'
          '|                                                    | '
          'has                                                |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_posonlyargcount                      | The number '
          'of positional-only *parameters*         |\n'
          '|                                                    | (including '
          'arguments with default values) that the |\n'
          '|                                                    | function '
          'has                                       |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_kwonlyargcount                       | The number '
          'of keyword-only *parameters* (including |\n'
          '|                                                    | arguments '
          'with default values) that the function   |\n'
          '|                                                    | '
          'has                                                |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_nlocals                              | The number '
          'of local variables used by the function |\n'
          '|                                                    | (including '
          'parameters)                             |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_varnames                             | A "tuple" '
          'containing the names of the local        |\n'
          '|                                                    | variables in '
          'the function (starting with the       |\n'
          '|                                                    | parameter '
          'names)                                   |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_cellvars                             | A "tuple" '
          'containing the names of local variables  |\n'
          '|                                                    | that are '
          'referenced by nested functions inside the |\n'
          '|                                                    | '
          'function                                           |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_freevars                             | A "tuple" '
          'containing the names of free variables   |\n'
          '|                                                    | in the '
          'function                                    |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_code                                 | A string '
          'representing the sequence of *bytecode*   |\n'
          '|                                                    | instructions '
          'in the function                       |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_consts                               | A "tuple" '
          'containing the literals used by the      |\n'
          '|                                                    | *bytecode* '
          'in the function                         |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_names                                | A "tuple" '
          'containing the names used by the         |\n'
          '|                                                    | *bytecode* '
          'in the function                         |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_filename                             | The name of '
          'the file from which the code was       |\n'
          '|                                                    | '
          'compiled                                           |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_firstlineno                          | The line '
          'number of the first line of the function  |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_lnotab                               | A string '
          'encoding the mapping from *bytecode*      |\n'
          '|                                                    | offsets to '
          'line numbers. For details, see the      |\n'
          '|                                                    | source code '
          'of the interpreter.                    |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_stacksize                            | The required '
          'stack size of the code object         |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| codeobject.co_flags                                | An "integer" '
          'encoding a number of flags for the    |\n'
          '|                                                    | '
          'interpreter.                                       |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          'The following flag bits are defined for "co_flags": bit "0x04" is '
          'set\n'
          'if the function uses the "*arguments" syntax to accept an '
          'arbitrary\n'
          'number of positional arguments; bit "0x08" is set if the function '
          'uses\n'
          'the "**keywords" syntax to accept arbitrary keyword arguments; bit\n'
          '"0x20" is set if the function is a generator. See Code Objects Bit\n'
          'Flags for details on the semantics of each flags that might be\n'
          'present.\n'
          '\n'
          'Future feature declarations ("from __future__ import division") '
          'also\n'
          'use bits in "co_flags" to indicate whether a code object was '
          'compiled\n'
          'with a particular feature enabled: bit "0x2000" is set if the '
          'function\n'
          'was compiled with future division enabled; bits "0x10" and '
          '"0x1000"\n'
          'were used in earlier versions of Python.\n'
          '\n'
          'Other bits in "co_flags" are reserved for internal use.\n'
          '\n'
          'If a code object represents a function, the first item in '
          '"co_consts"\n'
          'is the documentation string of the function, or "None" if '
          'undefined.\n'
          '\n'
          '\n'
          'Methods on code objects\n'
          '~~~~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          'codeobject.co_positions()\n'
          '\n'
          '   Returns an iterable over the source code positions of each\n'
          '   *bytecode* instruction in the code object.\n'
          '\n'
          '   The iterator returns "tuple"s containing the "(start_line,\n'
          '   end_line, start_column, end_column)". The *i-th* tuple '
          'corresponds\n'
          '   to the position of the source code that compiled to the *i-th*\n'
          '   instruction. Column information is 0-indexed utf-8 byte offsets '
          'on\n'
          '   the given source line.\n'
          '\n'
          '   This positional information can be missing. A non-exhaustive '
          'lists\n'
          '   of cases where this may happen:\n'
          '\n'
          '   * Running the interpreter with "-X" "no_debug_ranges".\n'
          '\n'
          '   * Loading a pyc file compiled while using "-X" '
          '"no_debug_ranges".\n'
          '\n'
          '   * Position tuples corresponding to artificial instructions.\n'
          '\n'
          '   * Line and column numbers that can’t be represented due to\n'
          '     implementation specific limitations.\n'
          '\n'
          '   When this occurs, some or all of the tuple elements can be '
          '"None".\n'
          '\n'
          '   New in version 3.11.\n'
          '\n'
          '   Note:\n'
          '\n'
          '     This feature requires storing column positions in code '
          'objects\n'
          '     which may result in a small increase of disk usage of '
          'compiled\n'
          '     Python files or interpreter memory usage. To avoid storing '
          'the\n'
          '     extra information and/or deactivate printing the extra '
          'traceback\n'
          '     information, the "-X" "no_debug_ranges" command line flag or '
          'the\n'
          '     "PYTHONNODEBUGRANGES" environment variable can be used.\n'
          '\n'
          'codeobject.co_lines()\n'
          '\n'
          '   Returns an iterator that yields information about successive '
          'ranges\n'
          '   of *bytecode*s. Each item yielded is a "(start, end, lineno)"\n'
          '   "tuple":\n'
          '\n'
          '   * "start" (an "int") represents the offset (inclusive) of the '
          'start\n'
          '     of the *bytecode* range\n'
          '\n'
          '   * "end" (an "int") represents the offset (exclusive) of the end '
          'of\n'
          '     the *bytecode* range\n'
          '\n'
          '   * "lineno" is an "int" representing the line number of the\n'
          '     *bytecode* range, or "None" if the bytecodes in the given '
          'range\n'
          '     have no line number\n'
          '\n'
          '   The items yielded will have the following properties:\n'
          '\n'
          '   * The first range yielded will have a "start" of 0.\n'
          '\n'
          '   * The "(start, end)" ranges will be non-decreasing and '
          'consecutive.\n'
          '     That is, for any pair of "tuple"s, the "start" of the second '
          'will\n'
          '     be equal to the "end" of the first.\n'
          '\n'
          '   * No range will be backwards: "end >= start" for all triples.\n'
          '\n'
          '   * The last "tuple" yielded will have "end" equal to the size of '
          'the\n'
          '     *bytecode*.\n'
          '\n'
          '   Zero-width ranges, where "start == end", are allowed. '
          'Zero-width\n'
          '   ranges are used for lines that are present in the source code, '
          'but\n'
          '   have been eliminated by the *bytecode* compiler.\n'
          '\n'
          '   New in version 3.10.\n'
          '\n'
          '   See also:\n'
          '\n'
          '     **PEP 626** - Precise line numbers for debugging and other '
          'tools.\n'
          '        The PEP that introduced the "co_lines()" method.\n'
          '\n'
          '\n'
          'Frame objects\n'
          '-------------\n'
          '\n'
          'Frame objects represent execution frames.  They may occur in '
          'traceback\n'
          'objects, and are also passed to registered trace functions.\n'
          '\n'
          '\n'
          'Special read-only attributes\n'
          '~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_back                                       | Points to '
          'the previous stack frame (towards the    |\n'
          '|                                                    | caller), or '
          '"None" if this is the bottom stack     |\n'
          '|                                                    | '
          'frame                                              |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_code                                       | The code '
          'object being executed in this frame.      |\n'
          '|                                                    | Accessing '
          'this attribute raises an auditing event  |\n'
          '|                                                    | '
          '"object.__getattr__" with arguments "obj" and      |\n'
          '|                                                    | '
          '""f_code"".                                        |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_locals                                     | The '
          'dictionary used by the frame to look up local  |\n'
          '|                                                    | '
          'variables                                          |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_globals                                    | The '
          'dictionary used by the frame to look up global |\n'
          '|                                                    | '
          'variables                                          |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_builtins                                   | The '
          'dictionary used by the frame to look up built- |\n'
          '|                                                    | in '
          '(intrinsic) names                               |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_lasti                                      | The “precise '
          'instruction” of the frame object      |\n'
          '|                                                    | (this is an '
          'index into the *bytecode* string of    |\n'
          '|                                                    | the code '
          'object)                                   |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          '\n'
          'Special writable attributes\n'
          '~~~~~~~~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_trace                                      | If not '
          '"None", this is a function called for       |\n'
          '|                                                    | various '
          'events during code execution (this is used |\n'
          '|                                                    | by '
          'debuggers). Normally an event is triggered for  |\n'
          '|                                                    | each new '
          'source line (see "f_trace_lines").        |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_trace_lines                                | Set this '
          'attribute to "False" to disable           |\n'
          '|                                                    | triggering a '
          'tracing event for each source line.   |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_trace_opcodes                              | Set this '
          'attribute to "True" to allow per-opcode   |\n'
          '|                                                    | events to be '
          'requested. Note that this may lead to |\n'
          '|                                                    | undefined '
          'interpreter behaviour if exceptions      |\n'
          '|                                                    | raised by '
          'the trace function escape to the         |\n'
          '|                                                    | function '
          'being traced.                             |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| frame.f_lineno                                     | The current '
          'line number of the frame – writing to  |\n'
          '|                                                    | this from '
          'within a trace function jumps to the     |\n'
          '|                                                    | given line '
          '(only for the bottom-most frame).  A    |\n'
          '|                                                    | debugger can '
          'implement a Jump command (aka Set     |\n'
          '|                                                    | Next '
          'Statement) by writing to this attribute.      |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          '\n'
          'Frame object methods\n'
          '~~~~~~~~~~~~~~~~~~~~\n'
          '\n'
          'Frame objects support one method:\n'
          '\n'
          'frame.clear()\n'
          '\n'
          '   This method clears all references to local variables held by '
          'the\n'
          '   frame.  Also, if the frame belonged to a *generator*, the '
          'generator\n'
          '   is finalized.  This helps break reference cycles involving '
          'frame\n'
          '   objects (for example when catching an exception and storing its\n'
          '   traceback for later use).\n'
          '\n'
          '   "RuntimeError" is raised if the frame is currently executing.\n'
          '\n'
          '   New in version 3.4.\n'
          '\n'
          '\n'
          'Traceback objects\n'
          '-----------------\n'
          '\n'
          'Traceback objects represent the stack trace of an exception. A\n'
          'traceback object is implicitly created when an exception occurs, '
          'and\n'
          'may also be explicitly created by calling "types.TracebackType".\n'
          '\n'
          'Changed in version 3.7: Traceback objects can now be explicitly\n'
          'instantiated from Python code.\n'
          '\n'
          'For implicitly created tracebacks, when the search for an '
          'exception\n'
          'handler unwinds the execution stack, at each unwound level a '
          'traceback\n'
          'object is inserted in front of the current traceback.  When an\n'
          'exception handler is entered, the stack trace is made available to '
          'the\n'
          'program. (See section The try statement.) It is accessible as the\n'
          'third item of the tuple returned by "sys.exc_info()", and as the\n'
          '"__traceback__" attribute of the caught exception.\n'
          '\n'
          'When the program contains no suitable handler, the stack trace is\n'
          'written (nicely formatted) to the standard error stream; if the\n'
          'interpreter is interactive, it is also made available to the user '
          'as\n'
          '"sys.last_traceback".\n'
          '\n'
          'For explicitly created tracebacks, it is up to the creator of the\n'
          'traceback to determine how the "tb_next" attributes should be '
          'linked\n'
          'to form a full stack trace.\n'
          '\n'
          'Special read-only attributes:\n'
          '\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| traceback.tb_frame                                 | Points to '
          'the execution frame of the current       |\n'
          '|                                                    | level.  '
          'Accessing this attribute raises an         |\n'
          '|                                                    | auditing '
          'event "object.__getattr__" with arguments |\n'
          '|                                                    | "obj" and '
          '""tb_frame"".                            |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| traceback.tb_lineno                                | Gives the '
          'line number where the exception occurred |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '| traceback.tb_lasti                                 | Indicates '
          'the “precise instruction”.               |\n'
          '+----------------------------------------------------+----------------------------------------------------+\n'
          '\n'
          'The line number and last instruction in the traceback may differ '
          'from\n'
          'the line number of its frame object if the exception occurred in a\n'
          '"try" statement with no matching except clause or with a "finally"\n'
          'clause.\n'
          '\n'
          'traceback.tb_next\n'
          '\n'
          '   The special writable attribute "tb_next" is the next level in '
          'the\n'
          '   stack trace (towards the frame where the exception occurred), '
          'or\n'
          '   "None" if there is no next level.\n'
          '\n'
          '   Changed in version 3.7: This attribute is now writable\n'
          '\n'
          '\n'
          'Slice objects\n'
          '-------------\n'
          '\n'
          'Slice objects are used to represent slices for "__getitem__()"\n'
          'methods.  They are also created by the built-in "slice()" '
          'function.\n'
          '\n'
          'Special read-only attributes: "start" is the lower bound; "stop" '
          'is\n'
          'the upper bound; "step" is the step value; each is "None" if '
          'omitted.\n'
          'These attributes can have any type.\n'
          '\n'
          'Slice objects support one method:\n'
          '\n'
          'slice.indices(self, length)\n'
          '\n'
          '   This method takes a single integer argument *length* and '
          'computes\n'
          '   information about the slice that the slice object would describe '
          'if\n'
          '   applied to a sequence of *length* items.  It returns a tuple of\n'
          '   three integers; respectively these are the *start* and *stop*\n'
          '   indices and the *step* or stride length of the slice. Missing '
          'or\n'
          '   out-of-bounds indices are handled in a manner consistent with\n'
          '   regular slices.\n'
          '\n'
          '\n'
          'Static method objects\n'
          '---------------------\n'
          '\n'
          'Static method objects provide a way of defeating the transformation '
          'of\n'
          'function objects to method objects described above. A static '
          'method\n'
          'object is a wrapper around any other object, usually a '
          'user-defined\n'
          'method object. When a static method object is retrieved from a '
          'class\n'
          'or a class instance, the object actually returned is the wrapped\n'
          'object, which is not subject to any further transformation. Static\n'
          'method objects are also callable. Static method objects are created '
          'by\n'
          'the built-in "staticmethod()" constructor.\n'
          '\n'
          '\n'
          'Class method objects\n'
          '--------------------\n'
          '\n'
          'A class method object, like a static method object, is a wrapper\n'
          'around another object that alters the way in which that object is\n'
          'retrieved from classes and class instances. The behaviour of class\n'
          'method objects upon such retrieval is described above, under '
          '“instance\n'
          'methods”. Class method objects are created by the built-in\n'
          '"classmethod()" constructor.\n',
 'typesfunctions': 'Functions\n'
                   '*********\n'
                   '\n'
                   'Function objects are created by function definitions.  The '
                   'only\n'
                   'operation on a function object is to call it: '
                   '"func(argument-list)".\n'
                   '\n'
                   'There are really two flavors of function objects: built-in '
                   'functions\n'
                   'and user-defined functions.  Both support the same '
                   'operation (to call\n'
                   'the function), but the implementation is different, hence '
                   'the\n'
                   'different object types.\n'
                   '\n'
                   'See Function definitions for more information.\n',
 'typesmapping': 'Mapping Types — "dict"\n'
                 '**********************\n'
                 '\n'
                 'A *mapping* object maps *hashable* values to arbitrary '
                 'objects.\n'
                 'Mappings are mutable objects.  There is currently only one '
                 'standard\n'
                 'mapping type, the *dictionary*.  (For other containers see '
                 'the built-\n'
                 'in "list", "set", and "tuple" classes, and the "collections" '
                 'module.)\n'
                 '\n'
                 'A dictionary’s keys are *almost* arbitrary values.  Values '
                 'that are\n'
                 'not *hashable*, that is, values containing lists, '
                 'dictionaries or\n'
                 'other mutable types (that are compared by value rather than '
                 'by object\n'
                 'identity) may not be used as keys. Values that compare equal '
                 '(such as\n'
                 '"1", "1.0", and "True") can be used interchangeably to index '
                 'the same\n'
                 'dictionary entry.\n'
                 '\n'
                 'class dict(**kwargs)\n'
                 'class dict(mapping, **kwargs)\n'
                 'class dict(iterable, **kwargs)\n'
                 '\n'
                 '   Return a new dictionary initialized from an optional '
                 'positional\n'
                 '   argument and a possibly empty set of keyword arguments.\n'
                 '\n'
                 '   Dictionaries can be created by several means:\n'
                 '\n'
                 '   * Use a comma-separated list of "key: value" pairs within '
                 'braces:\n'
                 '     "{\'jack\': 4098, \'sjoerd\': 4127}" or "{4098: '
                 "'jack', 4127:\n"
                 '     \'sjoerd\'}"\n'
                 '\n'
                 '   * Use a dict comprehension: "{}", "{x: x ** 2 for x in '
                 'range(10)}"\n'
                 '\n'
                 '   * Use the type constructor: "dict()", "dict([(\'foo\', '
                 "100), ('bar',\n"
                 '     200)])", "dict(foo=100, bar=200)"\n'
                 '\n'
                 '   If no positional argument is given, an empty dictionary '
                 'is created.\n'
                 '   If a positional argument is given and it is a mapping '
                 'object, a\n'
                 '   dictionary is created with the same key-value pairs as '
                 'the mapping\n'
                 '   object.  Otherwise, the positional argument must be an '
                 '*iterable*\n'
                 '   object.  Each item in the iterable must itself be an '
                 'iterable with\n'
                 '   exactly two objects.  The first object of each item '
                 'becomes a key\n'
                 '   in the new dictionary, and the second object the '
                 'corresponding\n'
                 '   value.  If a key occurs more than once, the last value '
                 'for that key\n'
                 '   becomes the corresponding value in the new dictionary.\n'
                 '\n'
                 '   If keyword arguments are given, the keyword arguments and '
                 'their\n'
                 '   values are added to the dictionary created from the '
                 'positional\n'
                 '   argument.  If a key being added is already present, the '
                 'value from\n'
                 '   the keyword argument replaces the value from the '
                 'positional\n'
                 '   argument.\n'
                 '\n'
                 '   To illustrate, the following examples all return a '
                 'dictionary equal\n'
                 '   to "{"one": 1, "two": 2, "three": 3}":\n'
                 '\n'
                 '      >>> a = dict(one=1, two=2, three=3)\n'
                 "      >>> b = {'one': 1, 'two': 2, 'three': 3}\n"
                 "      >>> c = dict(zip(['one', 'two', 'three'], [1, 2, 3]))\n"
                 "      >>> d = dict([('two', 2), ('one', 1), ('three', 3)])\n"
                 "      >>> e = dict({'three': 3, 'one': 1, 'two': 2})\n"
                 "      >>> f = dict({'one': 1, 'three': 3}, two=2)\n"
                 '      >>> a == b == c == d == e == f\n'
                 '      True\n'
                 '\n'
                 '   Providing keyword arguments as in the first example only '
                 'works for\n'
                 '   keys that are valid Python identifiers.  Otherwise, any '
                 'valid keys\n'
                 '   can be used.\n'
                 '\n'
                 '   These are the operations that dictionaries support (and '
                 'therefore,\n'
                 '   custom mapping types should support too):\n'
                 '\n'
                 '   list(d)\n'
                 '\n'
                 '      Return a list of all the keys used in the dictionary '
                 '*d*.\n'
                 '\n'
                 '   len(d)\n'
                 '\n'
                 '      Return the number of items in the dictionary *d*.\n'
                 '\n'
                 '   d[key]\n'
                 '\n'
                 '      Return the item of *d* with key *key*.  Raises a '
                 '"KeyError" if\n'
                 '      *key* is not in the map.\n'
                 '\n'
                 '      If a subclass of dict defines a method "__missing__()" '
                 'and *key*\n'
                 '      is not present, the "d[key]" operation calls that '
                 'method with\n'
                 '      the key *key* as argument.  The "d[key]" operation '
                 'then returns\n'
                 '      or raises whatever is returned or raised by the\n'
                 '      "__missing__(key)" call. No other operations or '
                 'methods invoke\n'
                 '      "__missing__()". If "__missing__()" is not defined, '
                 '"KeyError"\n'
                 '      is raised. "__missing__()" must be a method; it cannot '
                 'be an\n'
                 '      instance variable:\n'
                 '\n'
                 '         >>> class Counter(dict):\n'
                 '         ...     def __missing__(self, key):\n'
                 '         ...         return 0\n'
                 '         >>> c = Counter()\n'
                 "         >>> c['red']\n"
                 '         0\n'
                 "         >>> c['red'] += 1\n"
                 "         >>> c['red']\n"
                 '         1\n'
                 '\n'
                 '      The example above shows part of the implementation of\n'
                 '      "collections.Counter".  A different "__missing__" '
                 'method is used\n'
                 '      by "collections.defaultdict".\n'
                 '\n'
                 '   d[key] = value\n'
                 '\n'
                 '      Set "d[key]" to *value*.\n'
                 '\n'
                 '   del d[key]\n'
                 '\n'
                 '      Remove "d[key]" from *d*.  Raises a "KeyError" if '
                 '*key* is not\n'
                 '      in the map.\n'
                 '\n'
                 '   key in d\n'
                 '\n'
                 '      Return "True" if *d* has a key *key*, else "False".\n'
                 '\n'
                 '   key not in d\n'
                 '\n'
                 '      Equivalent to "not key in d".\n'
                 '\n'
                 '   iter(d)\n'
                 '\n'
                 '      Return an iterator over the keys of the dictionary.  '
                 'This is a\n'
                 '      shortcut for "iter(d.keys())".\n'
                 '\n'
                 '   clear()\n'
                 '\n'
                 '      Remove all items from the dictionary.\n'
                 '\n'
                 '   copy()\n'
                 '\n'
                 '      Return a shallow copy of the dictionary.\n'
                 '\n'
                 '   classmethod fromkeys(iterable[, value])\n'
                 '\n'
                 '      Create a new dictionary with keys from *iterable* and '
                 'values set\n'
                 '      to *value*.\n'
                 '\n'
                 '      "fromkeys()" is a class method that returns a new '
                 'dictionary.\n'
                 '      *value* defaults to "None".  All of the values refer '
                 'to just a\n'
                 '      single instance, so it generally doesn’t make sense '
                 'for *value*\n'
                 '      to be a mutable object such as an empty list.  To get '
                 'distinct\n'
                 '      values, use a dict comprehension instead.\n'
                 '\n'
                 '   get(key[, default])\n'
                 '\n'
                 '      Return the value for *key* if *key* is in the '
                 'dictionary, else\n'
                 '      *default*. If *default* is not given, it defaults to '
                 '"None", so\n'
                 '      that this method never raises a "KeyError".\n'
                 '\n'
                 '   items()\n'
                 '\n'
                 '      Return a new view of the dictionary’s items ("(key, '
                 'value)"\n'
                 '      pairs). See the documentation of view objects.\n'
                 '\n'
                 '   keys()\n'
                 '\n'
                 '      Return a new view of the dictionary’s keys.  See the\n'
                 '      documentation of view objects.\n'
                 '\n'
                 '   pop(key[, default])\n'
                 '\n'
                 '      If *key* is in the dictionary, remove it and return '
                 'its value,\n'
                 '      else return *default*.  If *default* is not given and '
                 '*key* is\n'
                 '      not in the dictionary, a "KeyError" is raised.\n'
                 '\n'
                 '   popitem()\n'
                 '\n'
                 '      Remove and return a "(key, value)" pair from the '
                 'dictionary.\n'
                 '      Pairs are returned in LIFO (last-in, first-out) '
                 'order.\n'
                 '\n'
                 '      "popitem()" is useful to destructively iterate over a\n'
                 '      dictionary, as often used in set algorithms.  If the '
                 'dictionary\n'
                 '      is empty, calling "popitem()" raises a "KeyError".\n'
                 '\n'
                 '      Changed in version 3.7: LIFO order is now guaranteed. '
                 'In prior\n'
                 '      versions, "popitem()" would return an arbitrary '
                 'key/value pair.\n'
                 '\n'
                 '   reversed(d)\n'
                 '\n'
                 '      Return a reverse iterator over the keys of the '
                 'dictionary. This\n'
                 '      is a shortcut for "reversed(d.keys())".\n'
                 '\n'
                 '      New in version 3.8.\n'
                 '\n'
                 '   setdefault(key[, default])\n'
                 '\n'
                 '      If *key* is in the dictionary, return its value.  If '
                 'not, insert\n'
                 '      *key* with a value of *default* and return *default*.  '
                 '*default*\n'
                 '      defaults to "None".\n'
                 '\n'
                 '   update([other])\n'
                 '\n'
                 '      Update the dictionary with the key/value pairs from '
                 '*other*,\n'
                 '      overwriting existing keys.  Return "None".\n'
                 '\n'
                 '      "update()" accepts either another dictionary object or '
                 'an\n'
                 '      iterable of key/value pairs (as tuples or other '
                 'iterables of\n'
                 '      length two).  If keyword arguments are specified, the '
                 'dictionary\n'
                 '      is then updated with those key/value pairs: '
                 '"d.update(red=1,\n'
                 '      blue=2)".\n'
                 '\n'
                 '   values()\n'
                 '\n'
                 '      Return a new view of the dictionary’s values.  See '
                 'the\n'
                 '      documentation of view objects.\n'
                 '\n'
                 '      An equality comparison between one "dict.values()" '
                 'view and\n'
                 '      another will always return "False". This also applies '
                 'when\n'
                 '      comparing "dict.values()" to itself:\n'
                 '\n'
                 "         >>> d = {'a': 1}\n"
                 '         >>> d.values() == d.values()\n'
                 '         False\n'
                 '\n'
                 '   d | other\n'
                 '\n'
                 '      Create a new dictionary with the merged keys and '
                 'values of *d*\n'
                 '      and *other*, which must both be dictionaries. The '
                 'values of\n'
                 '      *other* take priority when *d* and *other* share '
                 'keys.\n'
                 '\n'
                 '      New in version 3.9.\n'
                 '\n'
                 '   d |= other\n'
                 '\n'
                 '      Update the dictionary *d* with keys and values from '
                 '*other*,\n'
                 '      which may be either a *mapping* or an *iterable* of '
                 'key/value\n'
                 '      pairs. The values of *other* take priority when *d* '
                 'and *other*\n'
                 '      share keys.\n'
                 '\n'
                 '      New in version 3.9.\n'
                 '\n'
                 '   Dictionaries compare equal if and only if they have the '
                 'same "(key,\n'
                 '   value)" pairs (regardless of ordering). Order comparisons '
                 '(‘<’,\n'
                 '   ‘<=’, ‘>=’, ‘>’) raise "TypeError".\n'
                 '\n'
                 '   Dictionaries preserve insertion order.  Note that '
                 'updating a key\n'
                 '   does not affect the order.  Keys added after deletion are '
                 'inserted\n'
                 '   at the end.\n'
                 '\n'
                 '      >>> d = {"one": 1, "two": 2, "three": 3, "four": 4}\n'
                 '      >>> d\n'
                 "      {'one': 1, 'two': 2, 'three': 3, 'four': 4}\n"
                 '      >>> list(d)\n'
                 "      ['one', 'two', 'three', 'four']\n"
                 '      >>> list(d.values())\n'
                 '      [1, 2, 3, 4]\n'
                 '      >>> d["one"] = 42\n'
                 '      >>> d\n'
                 "      {'one': 42, 'two': 2, 'three': 3, 'four': 4}\n"
                 '      >>> del d["two"]\n'
                 '      >>> d["two"] = None\n'
                 '      >>> d\n'
                 "      {'one': 42, 'three': 3, 'four': 4, 'two': None}\n"
                 '\n'
                 '   Changed in version 3.7: Dictionary order is guaranteed to '
                 'be\n'
                 '   insertion order.  This behavior was an implementation '
                 'detail of\n'
                 '   CPython from 3.6.\n'
                 '\n'
                 '   Dictionaries and dictionary views are reversible.\n'
                 '\n'
                 '      >>> d = {"one": 1, "two": 2, "three": 3, "four": 4}\n'
                 '      >>> d\n'
                 "      {'one': 1, 'two': 2, 'three': 3, 'four': 4}\n"
                 '      >>> list(reversed(d))\n'
                 "      ['four', 'three', 'two', 'one']\n"
                 '      >>> list(reversed(d.values()))\n'
                 '      [4, 3, 2, 1]\n'
                 '      >>> list(reversed(d.items()))\n'
                 "      [('four', 4), ('three', 3), ('two', 2), ('one', 1)]\n"
                 '\n'
                 '   Changed in version 3.8: Dictionaries are now reversible.\n'
                 '\n'
                 'See also:\n'
                 '\n'
                 '  "types.MappingProxyType" can be used to create a read-only '
                 'view of a\n'
                 '  "dict".\n'
                 '\n'
                 '\n'
                 'Dictionary view objects\n'
                 '=======================\n'
                 '\n'
                 'The objects returned by "dict.keys()", "dict.values()" and\n'
                 '"dict.items()" are *view objects*.  They provide a dynamic '
                 'view on the\n'
                 'dictionary’s entries, which means that when the dictionary '
                 'changes,\n'
                 'the view reflects these changes.\n'
                 '\n'
                 'Dictionary views can be iterated over to yield their '
                 'respective data,\n'
                 'and support membership tests:\n'
                 '\n'
                 'len(dictview)\n'
                 '\n'
                 '   Return the number of entries in the dictionary.\n'
                 '\n'
                 'iter(dictview)\n'
                 '\n'
                 '   Return an iterator over the keys, values or items '
                 '(represented as\n'
                 '   tuples of "(key, value)") in the dictionary.\n'
                 '\n'
                 '   Keys and values are iterated over in insertion order. '
                 'This allows\n'
                 '   the creation of "(value, key)" pairs using "zip()": '
                 '"pairs =\n'
                 '   zip(d.values(), d.keys())".  Another way to create the '
                 'same list is\n'
                 '   "pairs = [(v, k) for (k, v) in d.items()]".\n'
                 '\n'
                 '   Iterating views while adding or deleting entries in the '
                 'dictionary\n'
                 '   may raise a "RuntimeError" or fail to iterate over all '
                 'entries.\n'
                 '\n'
                 '   Changed in version 3.7: Dictionary order is guaranteed to '
                 'be\n'
                 '   insertion order.\n'
                 '\n'
                 'x in dictview\n'
                 '\n'
                 '   Return "True" if *x* is in the underlying dictionary’s '
                 'keys, values\n'
                 '   or items (in the latter case, *x* should be a "(key, '
                 'value)"\n'
                 '   tuple).\n'
                 '\n'
                 'reversed(dictview)\n'
                 '\n'
                 '   Return a reverse iterator over the keys, values or items '
                 'of the\n'
                 '   dictionary. The view will be iterated in reverse order of '
                 'the\n'
                 '   insertion.\n'
                 '\n'
                 '   Changed in version 3.8: Dictionary views are now '
                 'reversible.\n'
                 '\n'
                 'dictview.mapping\n'
                 '\n'
                 '   Return a "types.MappingProxyType" that wraps the '
                 'original\n'
                 '   dictionary to which the view refers.\n'
                 '\n'
                 '   New in version 3.10.\n'
                 '\n'
                 'Keys views are set-like since their entries are unique and '
                 '*hashable*.\n'
                 'If all values are hashable, so that "(key, value)" pairs are '
                 'unique\n'
                 'and hashable, then the items view is also set-like.  (Values '
                 'views are\n'
                 'not treated as set-like since the entries are generally not '
                 'unique.)\n'
                 'For set-like views, all of the operations defined for the '
                 'abstract\n'
                 'base class "collections.abc.Set" are available (for example, '
                 '"==",\n'
                 '"<", or "^").\n'
                 '\n'
                 'An example of dictionary view usage:\n'
                 '\n'
                 "   >>> dishes = {'eggs': 2, 'sausage': 1, 'bacon': 1, "
                 "'spam': 500}\n"
                 '   >>> keys = dishes.keys()\n'
                 '   >>> values = dishes.values()\n'
                 '\n'
                 '   >>> # iteration\n'
                 '   >>> n = 0\n'
                 '   >>> for val in values:\n'
                 '   ...     n += val\n'
                 '   >>> print(n)\n'
                 '   504\n'
                 '\n'
                 '   >>> # keys and values are iterated over in the same order '
                 '(insertion order)\n'
                 '   >>> list(keys)\n'
                 "   ['eggs', 'sausage', 'bacon', 'spam']\n"
                 '   >>> list(values)\n'
                 '   [2, 1, 1, 500]\n'
                 '\n'
                 '   >>> # view objects are dynamic and reflect dict changes\n'
                 "   >>> del dishes['eggs']\n"
                 "   >>> del dishes['sausage']\n"
                 '   >>> list(keys)\n'
                 "   ['bacon', 'spam']\n"
                 '\n'
                 '   >>> # set operations\n'
                 "   >>> keys & {'eggs', 'bacon', 'salad'}\n"
                 "   {'bacon'}\n"
                 "   >>> keys ^ {'sausage', 'juice'} == {'juice', 'sausage', "
                 "'bacon', 'spam'}\n"
                 '   True\n'
                 "   >>> keys | ['juice', 'juice', 'juice'] == {'bacon', "
                 "'spam', 'juice'}\n"
                 '   True\n'
                 '\n'
                 '   >>> # get back a read-only proxy for the original '
                 'dictionary\n'
                 '   >>> values.mapping\n'
                 "   mappingproxy({'bacon': 1, 'spam': 500})\n"
                 "   >>> values.mapping['spam']\n"
                 '   500\n',
 'typesmethods': 'Methods\n'
                 '*******\n'
                 '\n'
                 'Methods are functions that are called using the attribute '
                 'notation.\n'
                 'There are two flavors: built-in methods (such as "append()" '
                 'on lists)\n'
                 'and class instance method. Built-in methods are described '
                 'with the\n'
                 'types that support them.\n'
                 '\n'
                 'If you access a method (a function defined in a class '
                 'namespace)\n'
                 'through an instance, you get a special object: a *bound '
                 'method* (also\n'
                 'called instance method) object. When called, it will add the '
                 '"self"\n'
                 'argument to the argument list.  Bound methods have two '
                 'special read-\n'
                 'only attributes: "m.__self__" is the object on which the '
                 'method\n'
                 'operates, and "m.__func__" is the function implementing the '
                 'method.\n'
                 'Calling "m(arg-1, arg-2, ..., arg-n)" is completely '
                 'equivalent to\n'
                 'calling "m.__func__(m.__self__, arg-1, arg-2, ..., arg-n)".\n'
                 '\n'
                 'Like function objects, bound method objects support getting '
                 'arbitrary\n'
                 'attributes.  However, since method attributes are actually '
                 'stored on\n'
                 'the underlying function object ("method.__func__"), setting '
                 'method\n'
                 'attributes on bound methods is disallowed.  Attempting to '
                 'set an\n'
                 'attribute on a method results in an "AttributeError" being '
                 'raised.  In\n'
                 'order to set a method attribute, you need to explicitly set '
                 'it on the\n'
                 'underlying function object:\n'
                 '\n'
                 '   >>> class C:\n'
                 '   ...     def method(self):\n'
                 '   ...         pass\n'
                 '   ...\n'
                 '   >>> c = C()\n'
                 "   >>> c.method.whoami = 'my name is method'  # can't set on "
                 'the method\n'
                 '   Traceback (most recent call last):\n'
                 '     File "<stdin>", line 1, in <module>\n'
                 "   AttributeError: 'method' object has no attribute "
                 "'whoami'\n"
                 "   >>> c.method.__func__.whoami = 'my name is method'\n"
                 '   >>> c.method.whoami\n'
                 "   'my name is method'\n"
                 '\n'
                 'See Instance methods for more information.\n',
 'typesmodules': 'Modules\n'
                 '*******\n'
                 '\n'
                 'The only special operation on a module is attribute access: '
                 '"m.name",\n'
                 'where *m* is a module and *name* accesses a name defined in '
                 '*m*’s\n'
                 'symbol table. Module attributes can be assigned to.  (Note '
                 'that the\n'
                 '"import" statement is not, strictly speaking, an operation '
                 'on a module\n'
                 'object; "import foo" does not require a module object named '
                 '*foo* to\n'
                 'exist, rather it requires an (external) *definition* for a '
                 'module\n'
                 'named *foo* somewhere.)\n'
                 '\n'
                 'A special attribute of every module is "__dict__". This is '
                 'the\n'
                 'dictionary containing the module’s symbol table. Modifying '
                 'this\n'
                 'dictionary will actually change the module’s symbol table, '
                 'but direct\n'
                 'assignment to the "__dict__" attribute is not possible (you '
                 'can write\n'
                 '"m.__dict__[\'a\'] = 1", which defines "m.a" to be "1", but '
                 'you can’t\n'
                 'write "m.__dict__ = {}").  Modifying "__dict__" directly is '
                 'not\n'
                 'recommended.\n'
                 '\n'
                 'Modules built into the interpreter are written like this: '
                 '"<module\n'
                 '\'sys\' (built-in)>".  If loaded from a file, they are '
                 'written as\n'
                 '"<module \'os\' from '
                 '\'/usr/local/lib/pythonX.Y/os.pyc\'>".\n',
 'typesseq': 'Sequence Types — "list", "tuple", "range"\n'
             '*****************************************\n'
             '\n'
             'There are three basic sequence types: lists, tuples, and range\n'
             'objects. Additional sequence types tailored for processing of '
             'binary\n'
             'data and text strings are described in dedicated sections.\n'
             '\n'
             '\n'
             'Common Sequence Operations\n'
             '==========================\n'
             '\n'
             'The operations in the following table are supported by most '
             'sequence\n'
             'types, both mutable and immutable. The '
             '"collections.abc.Sequence" ABC\n'
             'is provided to make it easier to correctly implement these '
             'operations\n'
             'on custom sequence types.\n'
             '\n'
             'This table lists the sequence operations sorted in ascending '
             'priority.\n'
             'In the table, *s* and *t* are sequences of the same type, *n*, '
             '*i*,\n'
             '*j* and *k* are integers and *x* is an arbitrary object that '
             'meets any\n'
             'type and value restrictions imposed by *s*.\n'
             '\n'
             'The "in" and "not in" operations have the same priorities as '
             'the\n'
             'comparison operations. The "+" (concatenation) and "*" '
             '(repetition)\n'
             'operations have the same priority as the corresponding numeric\n'
             'operations. [3]\n'
             '\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| Operation                  | Result                           '
             '| Notes      |\n'
             '|============================|==================================|============|\n'
             '| "x in s"                   | "True" if an item of *s* is      '
             '| (1)        |\n'
             '|                            | equal to *x*, else "False"       '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "x not in s"               | "False" if an item of *s* is     '
             '| (1)        |\n'
             '|                            | equal to *x*, else "True"        '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s + t"                    | the concatenation of *s* and *t* '
             '| (6)(7)     |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s * n" or "n * s"         | equivalent to adding *s* to      '
             '| (2)(7)     |\n'
             '|                            | itself *n* times                 '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s[i]"                     | *i*th item of *s*, origin 0      '
             '| (3)        |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s[i:j]"                   | slice of *s* from *i* to *j*     '
             '| (3)(4)     |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s[i:j:k]"                 | slice of *s* from *i* to *j*     '
             '| (3)(5)     |\n'
             '|                            | with step *k*                    '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "len(s)"                   | length of *s*                    '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "min(s)"                   | smallest item of *s*             '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "max(s)"                   | largest item of *s*              '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s.index(x[, i[, j]])"     | index of the first occurrence of '
             '| (8)        |\n'
             '|                            | *x* in *s* (at or after index    '
             '|            |\n'
             '|                            | *i* and before index *j*)        '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '| "s.count(x)"               | total number of occurrences of   '
             '|            |\n'
             '|                            | *x* in *s*                       '
             '|            |\n'
             '+----------------------------+----------------------------------+------------+\n'
             '\n'
             'Sequences of the same type also support comparisons.  In '
             'particular,\n'
             'tuples and lists are compared lexicographically by comparing\n'
             'corresponding elements. This means that to compare equal, every\n'
             'element must compare equal and the two sequences must be of the '
             'same\n'
             'type and have the same length.  (For full details see '
             'Comparisons in\n'
             'the language reference.)\n'
             '\n'
             'Forward and reversed iterators over mutable sequences access '
             'values\n'
             'using an index.  That index will continue to march forward (or\n'
             'backward) even if the underlying sequence is mutated.  The '
             'iterator\n'
             'terminates only when an "IndexError" or a "StopIteration" is\n'
             'encountered (or when the index drops below zero).\n'
             '\n'
             'Notes:\n'
             '\n'
             '1. While the "in" and "not in" operations are used only for '
             'simple\n'
             '   containment testing in the general case, some specialised '
             'sequences\n'
             '   (such as "str", "bytes" and "bytearray") also use them for\n'
             '   subsequence testing:\n'
             '\n'
             '      >>> "gg" in "eggs"\n'
             '      True\n'
             '\n'
             '2. Values of *n* less than "0" are treated as "0" (which yields '
             'an\n'
             '   empty sequence of the same type as *s*).  Note that items in '
             'the\n'
             '   sequence *s* are not copied; they are referenced multiple '
             'times.\n'
             '   This often haunts new Python programmers; consider:\n'
             '\n'
             '      >>> lists = [[]] * 3\n'
             '      >>> lists\n'
             '      [[], [], []]\n'
             '      >>> lists[0].append(3)\n'
             '      >>> lists\n'
             '      [[3], [3], [3]]\n'
             '\n'
             '   What has happened is that "[[]]" is a one-element list '
             'containing\n'
             '   an empty list, so all three elements of "[[]] * 3" are '
             'references\n'
             '   to this single empty list.  Modifying any of the elements of\n'
             '   "lists" modifies this single list. You can create a list of\n'
             '   different lists this way:\n'
             '\n'
             '      >>> lists = [[] for i in range(3)]\n'
             '      >>> lists[0].append(3)\n'
             '      >>> lists[1].append(5)\n'
             '      >>> lists[2].append(7)\n'
             '      >>> lists\n'
             '      [[3], [5], [7]]\n'
             '\n'
             '   Further explanation is available in the FAQ entry How do I '
             'create a\n'
             '   multidimensional list?.\n'
             '\n'
             '3. If *i* or *j* is negative, the index is relative to the end '
             'of\n'
             '   sequence *s*: "len(s) + i" or "len(s) + j" is substituted.  '
             'But\n'
             '   note that "-0" is still "0".\n'
             '\n'
             '4. The slice of *s* from *i* to *j* is defined as the sequence '
             'of\n'
             '   items with index *k* such that "i <= k < j".  If *i* or *j* '
             'is\n'
             '   greater than "len(s)", use "len(s)".  If *i* is omitted or '
             '"None",\n'
             '   use "0".  If *j* is omitted or "None", use "len(s)".  If *i* '
             'is\n'
             '   greater than or equal to *j*, the slice is empty.\n'
             '\n'
             '5. The slice of *s* from *i* to *j* with step *k* is defined as '
             'the\n'
             '   sequence of items with index  "x = i + n*k" such that "0 <= n '
             '<\n'
             '   (j-i)/k".  In other words, the indices are "i", "i+k", '
             '"i+2*k",\n'
             '   "i+3*k" and so on, stopping when *j* is reached (but never\n'
             '   including *j*).  When *k* is positive, *i* and *j* are '
             'reduced to\n'
             '   "len(s)" if they are greater. When *k* is negative, *i* and '
             '*j* are\n'
             '   reduced to "len(s) - 1" if they are greater.  If *i* or *j* '
             'are\n'
             '   omitted or "None", they become “end” values (which end '
             'depends on\n'
             '   the sign of *k*).  Note, *k* cannot be zero. If *k* is '
             '"None", it\n'
             '   is treated like "1".\n'
             '\n'
             '6. Concatenating immutable sequences always results in a new '
             'object.\n'
             '   This means that building up a sequence by repeated '
             'concatenation\n'
             '   will have a quadratic runtime cost in the total sequence '
             'length.\n'
             '   To get a linear runtime cost, you must switch to one of the\n'
             '   alternatives below:\n'
             '\n'
             '   * if concatenating "str" objects, you can build a list and '
             'use\n'
             '     "str.join()" at the end or else write to an "io.StringIO"\n'
             '     instance and retrieve its value when complete\n'
             '\n'
             '   * if concatenating "bytes" objects, you can similarly use\n'
             '     "bytes.join()" or "io.BytesIO", or you can do in-place\n'
             '     concatenation with a "bytearray" object.  "bytearray" '
             'objects are\n'
             '     mutable and have an efficient overallocation mechanism\n'
             '\n'
             '   * if concatenating "tuple" objects, extend a "list" instead\n'
             '\n'
             '   * for other types, investigate the relevant class '
             'documentation\n'
             '\n'
             '7. Some sequence types (such as "range") only support item '
             'sequences\n'
             '   that follow specific patterns, and hence don’t support '
             'sequence\n'
             '   concatenation or repetition.\n'
             '\n'
             '8. "index" raises "ValueError" when *x* is not found in *s*. Not '
             'all\n'
             '   implementations support passing the additional arguments *i* '
             'and\n'
             '   *j*. These arguments allow efficient searching of subsections '
             'of\n'
             '   the sequence. Passing the extra arguments is roughly '
             'equivalent to\n'
             '   using "s[i:j].index(x)", only without copying any data and '
             'with the\n'
             '   returned index being relative to the start of the sequence '
             'rather\n'
             '   than the start of the slice.\n'
             '\n'
             '\n'
             'Immutable Sequence Types\n'
             '========================\n'
             '\n'
             'The only operation that immutable sequence types generally '
             'implement\n'
             'that is not also implemented by mutable sequence types is '
             'support for\n'
             'the "hash()" built-in.\n'
             '\n'
             'This support allows immutable sequences, such as "tuple" '
             'instances, to\n'
             'be used as "dict" keys and stored in "set" and "frozenset" '
             'instances.\n'
             '\n'
             'Attempting to hash an immutable sequence that contains '
             'unhashable\n'
             'values will result in "TypeError".\n'
             '\n'
             '\n'
             'Mutable Sequence Types\n'
             '======================\n'
             '\n'
             'The operations in the following table are defined on mutable '
             'sequence\n'
             'types. The "collections.abc.MutableSequence" ABC is provided to '
             'make\n'
             'it easier to correctly implement these operations on custom '
             'sequence\n'
             'types.\n'
             '\n'
             'In the table *s* is an instance of a mutable sequence type, *t* '
             'is any\n'
             'iterable object and *x* is an arbitrary object that meets any '
             'type and\n'
             'value restrictions imposed by *s* (for example, "bytearray" '
             'only\n'
             'accepts integers that meet the value restriction "0 <= x <= '
             '255").\n'
             '\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| Operation                      | '
             'Result                           | Notes                 |\n'
             '|================================|==================================|=======================|\n'
             '| "s[i] = x"                     | item *i* of *s* is replaced '
             'by   |                       |\n'
             '|                                | '
             '*x*                              |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s[i:j] = t"                   | slice of *s* from *i* to *j* '
             'is  |                       |\n'
             '|                                | replaced by the contents of '
             'the  |                       |\n'
             '|                                | iterable '
             '*t*                     |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "del s[i:j]"                   | same as "s[i:j] = '
             '[]"            |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s[i:j:k] = t"                 | the elements of "s[i:j:k]" '
             'are   | (1)                   |\n'
             '|                                | replaced by those of '
             '*t*         |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "del s[i:j:k]"                 | removes the elements '
             'of          |                       |\n'
             '|                                | "s[i:j:k]" from the '
             'list         |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.append(x)"                  | appends *x* to the end of '
             'the    |                       |\n'
             '|                                | sequence (same '
             'as                |                       |\n'
             '|                                | "s[len(s):len(s)] = '
             '[x]")        |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.clear()"                    | removes all items from *s* '
             '(same | (5)                   |\n'
             '|                                | as "del '
             's[:]")                   |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.copy()"                     | creates a shallow copy of '
             '*s*    | (5)                   |\n'
             '|                                | (same as '
             '"s[:]")                 |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.extend(t)" or "s += t"      | extends *s* with the contents '
             'of |                       |\n'
             '|                                | *t* (for the most part the '
             'same  |                       |\n'
             '|                                | as "s[len(s):len(s)] = '
             't")       |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s *= n"                       | updates *s* with its '
             'contents    | (6)                   |\n'
             '|                                | repeated *n* '
             'times               |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.insert(i, x)"               | inserts *x* into *s* at '
             'the      |                       |\n'
             '|                                | index given by *i* (same '
             'as      |                       |\n'
             '|                                | "s[i:i] = '
             '[x]")                  |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.pop()" or "s.pop(i)"        | retrieves the item at *i* '
             'and    | (2)                   |\n'
             '|                                | also removes it from '
             '*s*         |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.remove(x)"                  | remove the first item from '
             '*s*   | (3)                   |\n'
             '|                                | where "s[i]" is equal to '
             '*x*     |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '| "s.reverse()"                  | reverses the items of *s* '
             'in     | (4)                   |\n'
             '|                                | '
             'place                            |                       |\n'
             '+--------------------------------+----------------------------------+-----------------------+\n'
             '\n'
             'Notes:\n'
             '\n'
             '1. *t* must have the same length as the slice it is replacing.\n'
             '\n'
             '2. The optional argument *i* defaults to "-1", so that by '
             'default the\n'
             '   last item is removed and returned.\n'
             '\n'
             '3. "remove()" raises "ValueError" when *x* is not found in *s*.\n'
             '\n'
             '4. The "reverse()" method modifies the sequence in place for '
             'economy\n'
             '   of space when reversing a large sequence.  To remind users '
             'that it\n'
             '   operates by side effect, it does not return the reversed '
             'sequence.\n'
             '\n'
             '5. "clear()" and "copy()" are included for consistency with the\n'
             '   interfaces of mutable containers that don’t support slicing\n'
             '   operations (such as "dict" and "set"). "copy()" is not part '
             'of the\n'
             '   "collections.abc.MutableSequence" ABC, but most concrete '
             'mutable\n'
             '   sequence classes provide it.\n'
             '\n'
             '   New in version 3.3: "clear()" and "copy()" methods.\n'
             '\n'
             '6. The value *n* is an integer, or an object implementing\n'
             '   "__index__()".  Zero and negative values of *n* clear the '
             'sequence.\n'
             '   Items in the sequence are not copied; they are referenced '
             'multiple\n'
             '   times, as explained for "s * n" under Common Sequence '
             'Operations.\n'
             '\n'
             '\n'
             'Lists\n'
             '=====\n'
             '\n'
             'Lists are mutable sequences, typically used to store collections '
             'of\n'
             'homogeneous items (where the precise degree of similarity will '
             'vary by\n'
             'application).\n'
             '\n'
             'class list([iterable])\n'
             '\n'
             '   Lists may be constructed in several ways:\n'
             '\n'
             '   * Using a pair of square brackets to denote the empty list: '
             '"[]"\n'
             '\n'
             '   * Using square brackets, separating items with commas: "[a]", '
             '"[a,\n'
             '     b, c]"\n'
             '\n'
             '   * Using a list comprehension: "[x for x in iterable]"\n'
             '\n'
             '   * Using the type constructor: "list()" or "list(iterable)"\n'
             '\n'
             '   The constructor builds a list whose items are the same and in '
             'the\n'
             '   same order as *iterable*’s items.  *iterable* may be either '
             'a\n'
             '   sequence, a container that supports iteration, or an '
             'iterator\n'
             '   object.  If *iterable* is already a list, a copy is made and\n'
             '   returned, similar to "iterable[:]". For example, '
             '"list(\'abc\')"\n'
             '   returns "[\'a\', \'b\', \'c\']" and "list( (1, 2, 3) )" '
             'returns "[1, 2,\n'
             '   3]". If no argument is given, the constructor creates a new '
             'empty\n'
             '   list, "[]".\n'
             '\n'
             '   Many other operations also produce lists, including the '
             '"sorted()"\n'
             '   built-in.\n'
             '\n'
             '   Lists implement all of the common and mutable sequence '
             'operations.\n'
             '   Lists also provide the following additional method:\n'
             '\n'
             '   sort(*, key=None, reverse=False)\n'
             '\n'
             '      This method sorts the list in place, using only "<" '
             'comparisons\n'
             '      between items. Exceptions are not suppressed - if any '
             'comparison\n'
             '      operations fail, the entire sort operation will fail (and '
             'the\n'
             '      list will likely be left in a partially modified state).\n'
             '\n'
             '      "sort()" accepts two arguments that can only be passed by\n'
             '      keyword (keyword-only arguments):\n'
             '\n'
             '      *key* specifies a function of one argument that is used '
             'to\n'
             '      extract a comparison key from each list element (for '
             'example,\n'
             '      "key=str.lower"). The key corresponding to each item in '
             'the list\n'
             '      is calculated once and then used for the entire sorting '
             'process.\n'
             '      The default value of "None" means that list items are '
             'sorted\n'
             '      directly without calculating a separate key value.\n'
             '\n'
             '      The "functools.cmp_to_key()" utility is available to '
             'convert a\n'
             '      2.x style *cmp* function to a *key* function.\n'
             '\n'
             '      *reverse* is a boolean value.  If set to "True", then the '
             'list\n'
             '      elements are sorted as if each comparison were reversed.\n'
             '\n'
             '      This method modifies the sequence in place for economy of '
             'space\n'
             '      when sorting a large sequence.  To remind users that it '
             'operates\n'
             '      by side effect, it does not return the sorted sequence '
             '(use\n'
             '      "sorted()" to explicitly request a new sorted list '
             'instance).\n'
             '\n'
             '      The "sort()" method is guaranteed to be stable.  A sort '
             'is\n'
             '      stable if it guarantees not to change the relative order '
             'of\n'
             '      elements that compare equal — this is helpful for sorting '
             'in\n'
             '      multiple passes (for example, sort by department, then by '
             'salary\n'
             '      grade).\n'
             '\n'
             '      For sorting examples and a brief sorting tutorial, see '
             'Sorting\n'
             '      HOW TO.\n'
             '\n'
             '      **CPython implementation detail:** While a list is being '
             'sorted,\n'
             '      the effect of attempting to mutate, or even inspect, the '
             'list is\n'
             '      undefined.  The C implementation of Python makes the list '
             'appear\n'
             '      empty for the duration, and raises "ValueError" if it can '
             'detect\n'
             '      that the list has been mutated during a sort.\n'
             '\n'
             '\n'
             'Tuples\n'
             '======\n'
             '\n'
             'Tuples are immutable sequences, typically used to store '
             'collections of\n'
             'heterogeneous data (such as the 2-tuples produced by the '
             '"enumerate()"\n'
             'built-in). Tuples are also used for cases where an immutable '
             'sequence\n'
             'of homogeneous data is needed (such as allowing storage in a '
             '"set" or\n'
             '"dict" instance).\n'
             '\n'
             'class tuple([iterable])\n'
             '\n'
             '   Tuples may be constructed in a number of ways:\n'
             '\n'
             '   * Using a pair of parentheses to denote the empty tuple: '
             '"()"\n'
             '\n'
             '   * Using a trailing comma for a singleton tuple: "a," or '
             '"(a,)"\n'
             '\n'
             '   * Separating items with commas: "a, b, c" or "(a, b, c)"\n'
             '\n'
             '   * Using the "tuple()" built-in: "tuple()" or '
             '"tuple(iterable)"\n'
             '\n'
             '   The constructor builds a tuple whose items are the same and '
             'in the\n'
             '   same order as *iterable*’s items.  *iterable* may be either '
             'a\n'
             '   sequence, a container that supports iteration, or an '
             'iterator\n'
             '   object.  If *iterable* is already a tuple, it is returned\n'
             '   unchanged. For example, "tuple(\'abc\')" returns "(\'a\', '
             '\'b\', \'c\')"\n'
             '   and "tuple( [1, 2, 3] )" returns "(1, 2, 3)". If no argument '
             'is\n'
             '   given, the constructor creates a new empty tuple, "()".\n'
             '\n'
             '   Note that it is actually the comma which makes a tuple, not '
             'the\n'
             '   parentheses. The parentheses are optional, except in the '
             'empty\n'
             '   tuple case, or when they are needed to avoid syntactic '
             'ambiguity.\n'
             '   For example, "f(a, b, c)" is a function call with three '
             'arguments,\n'
             '   while "f((a, b, c))" is a function call with a 3-tuple as the '
             'sole\n'
             '   argument.\n'
             '\n'
             '   Tuples implement all of the common sequence operations.\n'
             '\n'
             'For heterogeneous collections of data where access by name is '
             'clearer\n'
             'than access by index, "collections.namedtuple()" may be a more\n'
             'appropriate choice than a simple tuple object.\n'
             '\n'
             '\n'
             'Ranges\n'
             '======\n'
             '\n'
             'The "range" type represents an immutable sequence of numbers and '
             'is\n'
             'commonly used for looping a specific number of times in "for" '
             'loops.\n'
             '\n'
             'class range(stop)\n'
             'class range(start, stop[, step])\n'
             '\n'
             '   The arguments to the range constructor must be integers '
             '(either\n'
             '   built-in "int" or any object that implements the '
             '"__index__()"\n'
             '   special method).  If the *step* argument is omitted, it '
             'defaults to\n'
             '   "1". If the *start* argument is omitted, it defaults to "0". '
             'If\n'
             '   *step* is zero, "ValueError" is raised.\n'
             '\n'
             '   For a positive *step*, the contents of a range "r" are '
             'determined\n'
             '   by the formula "r[i] = start + step*i" where "i >= 0" and '
             '"r[i] <\n'
             '   stop".\n'
             '\n'
             '   For a negative *step*, the contents of the range are still\n'
             '   determined by the formula "r[i] = start + step*i", but the\n'
             '   constraints are "i >= 0" and "r[i] > stop".\n'
             '\n'
             '   A range object will be empty if "r[0]" does not meet the '
             'value\n'
             '   constraint. Ranges do support negative indices, but these '
             'are\n'
             '   interpreted as indexing from the end of the sequence '
             'determined by\n'
             '   the positive indices.\n'
             '\n'
             '   Ranges containing absolute values larger than "sys.maxsize" '
             'are\n'
             '   permitted but some features (such as "len()") may raise\n'
             '   "OverflowError".\n'
             '\n'
             '   Range examples:\n'
             '\n'
             '      >>> list(range(10))\n'
             '      [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\n'
             '      >>> list(range(1, 11))\n'
             '      [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]\n'
             '      >>> list(range(0, 30, 5))\n'
             '      [0, 5, 10, 15, 20, 25]\n'
             '      >>> list(range(0, 10, 3))\n'
             '      [0, 3, 6, 9]\n'
             '      >>> list(range(0, -10, -1))\n'
             '      [0, -1, -2, -3, -4, -5, -6, -7, -8, -9]\n'
             '      >>> list(range(0))\n'
             '      []\n'
             '      >>> list(range(1, 0))\n'
             '      []\n'
             '\n'
             '   Ranges implement all of the common sequence operations '
             'except\n'
             '   concatenation and repetition (due to the fact that range '
             'objects\n'
             '   can only represent sequences that follow a strict pattern '
             'and\n'
             '   repetition and concatenation will usually violate that '
             'pattern).\n'
             '\n'
             '   start\n'
             '\n'
             '      The value of the *start* parameter (or "0" if the '
             'parameter was\n'
             '      not supplied)\n'
             '\n'
             '   stop\n'
             '\n'
             '      The value of the *stop* parameter\n'
             '\n'
             '   step\n'
             '\n'
             '      The value of the *step* parameter (or "1" if the parameter '
             'was\n'
             '      not supplied)\n'
             '\n'
             'The advantage of the "range" type over a regular "list" or '
             '"tuple" is\n'
             'that a "range" object will always take the same (small) amount '
             'of\n'
             'memory, no matter the size of the range it represents (as it '
             'only\n'
             'stores the "start", "stop" and "step" values, calculating '
             'individual\n'
             'items and subranges as needed).\n'
             '\n'
             'Range objects implement the "collections.abc.Sequence" ABC, and\n'
             'provide features such as containment tests, element index '
             'lookup,\n'
             'slicing and support for negative indices (see Sequence Types — '
             'list,\n'
             'tuple, range):\n'
             '\n'
             '>>> r = range(0, 20, 2)\n'
             '>>> r\n'
             'range(0, 20, 2)\n'
             '>>> 11 in r\n'
             'False\n'
             '>>> 10 in r\n'
             'True\n'
             '>>> r.index(10)\n'
             '5\n'
             '>>> r[5]\n'
             '10\n'
             '>>> r[:5]\n'
             'range(0, 10, 2)\n'
             '>>> r[-1]\n'
             '18\n'
             '\n'
             'Testing range objects for equality with "==" and "!=" compares '
             'them as\n'
             'sequences.  That is, two range objects are considered equal if '
             'they\n'
             'represent the same sequence of values.  (Note that two range '
             'objects\n'
             'that compare equal might have different "start", "stop" and '
             '"step"\n'
             'attributes, for example "range(0) == range(2, 1, 3)" or '
             '"range(0, 3,\n'
             '2) == range(0, 4, 2)".)\n'
             '\n'
             'Changed in version 3.2: Implement the Sequence ABC. Support '
             'slicing\n'
             'and negative indices. Test "int" objects for membership in '
             'constant\n'
             'time instead of iterating through all items.\n'
             '\n'
             'Changed in version 3.3: Define ‘==’ and ‘!=’ to compare range '
             'objects\n'
             'based on the sequence of values they define (instead of '
             'comparing\n'
             'based on object identity).\n'
             '\n'
             'New in version 3.3: The "start", "stop" and "step" attributes.\n'
             '\n'
             'See also:\n'
             '\n'
             '  * The linspace recipe shows how to implement a lazy version of '
             'range\n'
             '    suitable for floating point applications.\n',
 'typesseq-mutable': 'Mutable Sequence Types\n'
                     '**********************\n'
                     '\n'
                     'The operations in the following table are defined on '
                     'mutable sequence\n'
                     'types. The "collections.abc.MutableSequence" ABC is '
                     'provided to make\n'
                     'it easier to correctly implement these operations on '
                     'custom sequence\n'
                     'types.\n'
                     '\n'
                     'In the table *s* is an instance of a mutable sequence '
                     'type, *t* is any\n'
                     'iterable object and *x* is an arbitrary object that '
                     'meets any type and\n'
                     'value restrictions imposed by *s* (for example, '
                     '"bytearray" only\n'
                     'accepts integers that meet the value restriction "0 <= x '
                     '<= 255").\n'
                     '\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| Operation                      | '
                     'Result                           | Notes                 '
                     '|\n'
                     '|================================|==================================|=======================|\n'
                     '| "s[i] = x"                     | item *i* of *s* is '
                     'replaced by   |                       |\n'
                     '|                                | '
                     '*x*                              |                       '
                     '|\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s[i:j] = t"                   | slice of *s* from *i* '
                     'to *j* is  |                       |\n'
                     '|                                | replaced by the '
                     'contents of the  |                       |\n'
                     '|                                | iterable '
                     '*t*                     |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "del s[i:j]"                   | same as "s[i:j] = '
                     '[]"            |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s[i:j:k] = t"                 | the elements of '
                     '"s[i:j:k]" are   | (1)                   |\n'
                     '|                                | replaced by those of '
                     '*t*         |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "del s[i:j:k]"                 | removes the elements '
                     'of          |                       |\n'
                     '|                                | "s[i:j:k]" from the '
                     'list         |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.append(x)"                  | appends *x* to the '
                     'end of the    |                       |\n'
                     '|                                | sequence (same '
                     'as                |                       |\n'
                     '|                                | "s[len(s):len(s)] = '
                     '[x]")        |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.clear()"                    | removes all items '
                     'from *s* (same | (5)                   |\n'
                     '|                                | as "del '
                     's[:]")                   |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.copy()"                     | creates a shallow '
                     'copy of *s*    | (5)                   |\n'
                     '|                                | (same as '
                     '"s[:]")                 |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.extend(t)" or "s += t"      | extends *s* with the '
                     'contents of |                       |\n'
                     '|                                | *t* (for the most '
                     'part the same  |                       |\n'
                     '|                                | as "s[len(s):len(s)] '
                     '= t")       |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s *= n"                       | updates *s* with its '
                     'contents    | (6)                   |\n'
                     '|                                | repeated *n* '
                     'times               |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.insert(i, x)"               | inserts *x* into *s* '
                     'at the      |                       |\n'
                     '|                                | index given by *i* '
                     '(same as      |                       |\n'
                     '|                                | "s[i:i] = '
                     '[x]")                  |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.pop()" or "s.pop(i)"        | retrieves the item at '
                     '*i* and    | (2)                   |\n'
                     '|                                | also removes it from '
                     '*s*         |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.remove(x)"                  | remove the first item '
                     'from *s*   | (3)                   |\n'
                     '|                                | where "s[i]" is equal '
                     'to *x*     |                       |\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '| "s.reverse()"                  | reverses the items of '
                     '*s* in     | (4)                   |\n'
                     '|                                | '
                     'place                            |                       '
                     '|\n'
                     '+--------------------------------+----------------------------------+-----------------------+\n'
                     '\n'
                     'Notes:\n'
                     '\n'
                     '1. *t* must have the same length as the slice it is '
                     'replacing.\n'
                     '\n'
                     '2. The optional argument *i* defaults to "-1", so that '
                     'by default the\n'
                     '   last item is removed and returned.\n'
                     '\n'
                     '3. "remove()" raises "ValueError" when *x* is not found '
                     'in *s*.\n'
                     '\n'
                     '4. The "reverse()" method modifies the sequence in place '
                     'for economy\n'
                     '   of space when reversing a large sequence.  To remind '
                     'users that it\n'
                     '   operates by side effect, it does not return the '
                     'reversed sequence.\n'
                     '\n'
                     '5. "clear()" and "copy()" are included for consistency '
                     'with the\n'
                     '   interfaces of mutable containers that don’t support '
                     'slicing\n'
                     '   operations (such as "dict" and "set"). "copy()" is '
                     'not part of the\n'
                     '   "collections.abc.MutableSequence" ABC, but most '
                     'concrete mutable\n'
                     '   sequence classes provide it.\n'
                     '\n'
                     '   New in version 3.3: "clear()" and "copy()" methods.\n'
                     '\n'
                     '6. The value *n* is an integer, or an object '
                     'implementing\n'
                     '   "__index__()".  Zero and negative values of *n* clear '
                     'the sequence.\n'
                     '   Items in the sequence are not copied; they are '
                     'referenced multiple\n'
                     '   times, as explained for "s * n" under Common Sequence '
                     'Operations.\n',
 'unary': 'Unary arithmetic and bitwise operations\n'
          '***************************************\n'
          '\n'
          'All unary arithmetic and bitwise operations have the same '
          'priority:\n'
          '\n'
          '   u_expr ::= power | "-" u_expr | "+" u_expr | "~" u_expr\n'
          '\n'
          'The unary "-" (minus) operator yields the negation of its numeric\n'
          'argument; the operation can be overridden with the "__neg__()" '
          'special\n'
          'method.\n'
          '\n'
          'The unary "+" (plus) operator yields its numeric argument '
          'unchanged;\n'
          'the operation can be overridden with the "__pos__()" special '
          'method.\n'
          '\n'
          'The unary "~" (invert) operator yields the bitwise inversion of '
          'its\n'
          'integer argument.  The bitwise inversion of "x" is defined as\n'
          '"-(x+1)".  It only applies to integral numbers or to custom '
          'objects\n'
          'that override the "__invert__()" special method.\n'
          '\n'
          'In all three cases, if the argument does not have the proper type, '
          'a\n'
          '"TypeError" exception is raised.\n',
 'while': 'The "while" statement\n'
          '*********************\n'
          '\n'
          'The "while" statement is used for repeated execution as long as an\n'
          'expression is true:\n'
          '\n'
          '   while_stmt ::= "while" assignment_expression ":" suite\n'
          '                  ["else" ":" suite]\n'
          '\n'
          'This repeatedly tests the expression and, if it is true, executes '
          'the\n'
          'first suite; if the expression is false (which may be the first '
          'time\n'
          'it is tested) the suite of the "else" clause, if present, is '
          'executed\n'
          'and the loop terminates.\n'
          '\n'
          'A "break" statement executed in the first suite terminates the '
          'loop\n'
          'without executing the "else" clause’s suite.  A "continue" '
          'statement\n'
          'executed in the first suite skips the rest of the suite and goes '
          'back\n'
          'to testing the expression.\n',
 'with': 'The "with" statement\n'
         '********************\n'
         '\n'
         'The "with" statement is used to wrap the execution of a block with\n'
         'methods defined by a context manager (see section With Statement\n'
         'Context Managers). This allows common "try"…"except"…"finally" '
         'usage\n'
         'patterns to be encapsulated for convenient reuse.\n'
         '\n'
         '   with_stmt          ::= "with" ( "(" with_stmt_contents ","? ")" | '
         'with_stmt_contents ) ":" suite\n'
         '   with_stmt_contents ::= with_item ("," with_item)*\n'
         '   with_item          ::= expression ["as" target]\n'
         '\n'
         'The execution of the "with" statement with one “item” proceeds as\n'
         'follows:\n'
         '\n'
         '1. The context expression (the expression given in the "with_item") '
         'is\n'
         '   evaluated to obtain a context manager.\n'
         '\n'
         '2. The context manager’s "__enter__()" is loaded for later use.\n'
         '\n'
         '3. The context manager’s "__exit__()" is loaded for later use.\n'
         '\n'
         '4. The context manager’s "__enter__()" method is invoked.\n'
         '\n'
         '5. If a target was included in the "with" statement, the return '
         'value\n'
         '   from "__enter__()" is assigned to it.\n'
         '\n'
         '   Note:\n'
         '\n'
         '     The "with" statement guarantees that if the "__enter__()" '
         'method\n'
         '     returns without an error, then "__exit__()" will always be\n'
         '     called. Thus, if an error occurs during the assignment to the\n'
         '     target list, it will be treated the same as an error occurring\n'
         '     within the suite would be. See step 7 below.\n'
         '\n'
         '6. The suite is executed.\n'
         '\n'
         '7. The context manager’s "__exit__()" method is invoked.  If an\n'
         '   exception caused the suite to be exited, its type, value, and\n'
         '   traceback are passed as arguments to "__exit__()". Otherwise, '
         'three\n'
         '   "None" arguments are supplied.\n'
         '\n'
         '   If the suite was exited due to an exception, and the return '
         'value\n'
         '   from the "__exit__()" method was false, the exception is '
         'reraised.\n'
         '   If the return value was true, the exception is suppressed, and\n'
         '   execution continues with the statement following the "with"\n'
         '   statement.\n'
         '\n'
         '   If the suite was exited for any reason other than an exception, '
         'the\n'
         '   return value from "__exit__()" is ignored, and execution '
         'proceeds\n'
         '   at the normal location for the kind of exit that was taken.\n'
         '\n'
         'The following code:\n'
         '\n'
         '   with EXPRESSION as TARGET:\n'
         '       SUITE\n'
         '\n'
         'is semantically equivalent to:\n'
         '\n'
         '   manager = (EXPRESSION)\n'
         '   enter = type(manager).__enter__\n'
         '   exit = type(manager).__exit__\n'
         '   value = enter(manager)\n'
         '   hit_except = False\n'
         '\n'
         '   try:\n'
         '       TARGET = value\n'
         '       SUITE\n'
         '   except:\n'
         '       hit_except = True\n'
         '       if not exit(manager, *sys.exc_info()):\n'
         '           raise\n'
         '   finally:\n'
         '       if not hit_except:\n'
         '           exit(manager, None, None, None)\n'
         '\n'
         'With more than one item, the context managers are processed as if\n'
         'multiple "with" statements were nested:\n'
         '\n'
         '   with A() as a, B() as b:\n'
         '       SUITE\n'
         '\n'
         'is semantically equivalent to:\n'
         '\n'
         '   with A() as a:\n'
         '       with B() as b:\n'
         '           SUITE\n'
         '\n'
         'You can also write multi-item context managers in multiple lines if\n'
         'the items are surrounded by parentheses. For example:\n'
         '\n'
         '   with (\n'
         '       A() as a,\n'
         '       B() as b,\n'
         '   ):\n'
         '       SUITE\n'
         '\n'
         'Changed in version 3.1: Support for multiple context expressions.\n'
         '\n'
         'Changed in version 3.10: Support for using grouping parentheses to\n'
         'break the statement in multiple lines.\n'
         '\n'
         'See also:\n'
         '\n'
         '  **PEP 343** - The “with” statement\n'
         '     The specification, background, and examples for the Python '
         '"with"\n'
         '     statement.\n',
 'yield': 'The "yield" statement\n'
          '*********************\n'
          '\n'
          '   yield_stmt ::= yield_expression\n'
          '\n'
          'A "yield" statement is semantically equivalent to a yield '
          'expression.\n'
          'The yield statement can be used to omit the parentheses that would\n'
          'otherwise be required in the equivalent yield expression '
          'statement.\n'
          'For example, the yield statements\n'
          '\n'
          '   yield <expr>\n'
          '   yield from <expr>\n'
          '\n'
          'are equivalent to the yield expression statements\n'
          '\n'
          '   (yield <expr>)\n'
          '   (yield from <expr>)\n'
          '\n'
          'Yield expressions and statements are only used when defining a\n'
          '*generator* function, and are only used in the body of the '
          'generator\n'
          'function.  Using yield in a function definition is sufficient to '
          'cause\n'
          'that definition to create a generator function instead of a normal\n'
          'function.\n'
          '\n'
          'For full details of "yield" semantics, refer to the Yield '
          'expressions\n'
          'section.\n'}
