/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;

public class NamespaceDeclarationsImpl
implements NamespaceDeclarations {
    private NamePool namePool;
    private int[] namespaceCodes;
    private int used;
    private static final int[] emptyArray = new int[0];

    public NamespaceDeclarationsImpl() {
    }

    public NamespaceDeclarationsImpl(NamePool pool, int[] codes) {
        this.namePool = pool;
        this.setNamespaceCodes(codes);
    }

    public void setNamePool(NamePool pool) {
        this.namePool = pool;
    }

    public void setNamespaceCodes(int[] codes) {
        if (codes == null) {
            codes = emptyArray;
        }
        this.namespaceCodes = codes;
        this.used = codes.length;
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i] != -1) continue;
            this.used = i;
            break;
        }
    }

    public int[] getNamespaceCodes(int[] buffer) {
        return this.namespaceCodes;
    }

    public int getNumberOfNamespaces() {
        return this.used;
    }

    public String getPrefix(int index) {
        return this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[index]);
    }

    public String getURI(int index) {
        return this.namePool.getURIFromNamespaceCode(this.namespaceCodes[index]);
    }

    public int getNamespaceCode(int index) {
        return this.namespaceCodes[index];
    }
}

