# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

VERIFY_SIG_OPENPGP_KEY_PATH=/usr/share/openpgp-keys/netfilter.org.asc
inherit linux-info verify-sig

DESCRIPTION="Userspace library for interface to user-space helper for conntrack"
HOMEPAGE="https://www.netfilter.org/projects/libnetfilter_cthelper/"
SRC_URI="https://www.netfilter.org/projects/${PN}/files/${P}.tar.bz2
	verify-sig? ( https://www.netfilter.org/projects/${PN}/files/${P}.tar.bz2.sig )"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 ~arm ~arm64 ~hppa ppc ppc64 ~riscv x86"

RDEPEND="net-libs/libmnl:="
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig
	verify-sig? ( sec-keys/openpgp-keys-netfilter )"

CONFIG_CHECK="~NF_CT_NETLINK_HELPER"

pkg_setup() {
	linux-info_pkg_setup

	kernel_is lt 3 6 0 && ewarn "requires at least 3.6.0 kernel version"
}

src_install() {
	default

	find "${ED}" -name '*.la' -delete || die
}
