/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_closedialog.c - creation and destruction of the close dialog 
 *
 * create a warning dialog if a log is changed and we want to close it.
 */
 
#include <gtk/gtk.h>
#include <stdio.h>

#include "gui_closedialog.h"
#include "support.h"
#include "types.h"
#include "log.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern GList *logwindowlist;
extern statetype state;

void
on_menu_close_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *closedialog, *dialog_vbox, *label, *dialog_action_area,
		*closecancelbutton, *closeokbutton;
	GdkPixbuf *closedialog_icon_pixbuf;
	logtype *logwindow;
	gint page, response;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));
	if (page >= 0)
		{
			logwindow = g_list_nth_data (logwindowlist, page);
			if (logwindow->logchanged)
			{
				closedialog = gtk_dialog_new ();
				gtk_window_set_title (GTK_WINDOW (closedialog), _("xlog - closing"));
				gtk_window_set_position (GTK_WINDOW (closedialog), GTK_WIN_POS_MOUSE);
				closedialog_icon_pixbuf = create_pixbuf ("xlog.png");
				if (closedialog_icon_pixbuf)
				{
					gtk_window_set_icon (GTK_WINDOW (closedialog), closedialog_icon_pixbuf);
					g_object_unref (closedialog_icon_pixbuf);
				}
				dialog_vbox = GTK_DIALOG (closedialog)->vbox;
				gtk_widget_show (dialog_vbox);
				label = gtk_label_new (_("This log has not been saved, do you want to close it anyway?"));
				gtk_widget_show (label);
				gtk_box_pack_start (GTK_BOX (dialog_vbox), label, FALSE, FALSE, 0);
				gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
				gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
				gtk_misc_set_padding (GTK_MISC (label), 20, 20);
				dialog_action_area = GTK_DIALOG (closedialog)->action_area;
				gtk_widget_show (dialog_action_area);
				gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);
				closecancelbutton = gtk_button_new_from_stock ("gtk-cancel");
				gtk_widget_show (closecancelbutton);
				gtk_dialog_add_action_widget (GTK_DIALOG (closedialog), closecancelbutton, GTK_RESPONSE_CANCEL);
				GTK_WIDGET_SET_FLAGS (closecancelbutton, GTK_CAN_DEFAULT);
				closeokbutton = gtk_button_new_from_stock ("gtk-ok");
				gtk_widget_show (closeokbutton);
				gtk_dialog_add_action_widget (GTK_DIALOG (closedialog), closeokbutton, GTK_RESPONSE_OK);
				GTK_WIDGET_SET_FLAGS (closeokbutton, GTK_CAN_DEFAULT);
				response = gtk_dialog_run (GTK_DIALOG(closedialog));
				if (response == GTK_RESPONSE_OK)
				{
					logwindowlist = g_list_remove (logwindowlist, logwindow);
					g_free (logwindow->logname);
					g_free (logwindow);
					state.logwindows--;
					gtk_notebook_remove_page (GTK_NOTEBOOK (mainnotebook), page);
				}
				gtk_widget_destroy (closedialog);
			}
			else
			{
				logwindowlist = g_list_remove (logwindowlist, logwindow);
				g_free (logwindow->logname);
				g_free (logwindow);
				gtk_notebook_remove_page (GTK_NOTEBOOK (mainnotebook), page);
				state.logwindows--;
			}
		}
}
