/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_logeditoredialog.c - creation and destruction of the logeditor
 *
 * the logeditor is used to enable/disable columns in the log. We can also name
 * the 2 free fields here. When OK is clicked, the log is updated with the new
 * columns and likewise fields in the QSO frame are added or deleted.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#include "support.h"
#include "types.h"
#include "log.h"
#include "utils.h"
#include "gui_logeditordialog.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern GList *logwindowlist;
extern preferencestype preferences;

static gint
compare_fields (void *f1, void *f2, gpointer user_data)
{
	gint *p = f1, *q = f2;
	if (*p - *q == *p)
		return 0;
	else
		return (*p - *q);
}

/* update logfields and return number of columns */
static void
update_logfields (gint column, gint logfields[], gchar * showhide)
{
	gint i, j;

	for (i = 0; i < QSO_FIELDS; i++)
	{
		if (logfields[i] == column)
			break;
	}
	/*
	 * If the column is not present, add it to the end of the array
	 * if 'Show' is selected
	 */
	if (i == QSO_FIELDS)
	{
		if (strcasecmp (showhide, _("Show")) == 0)
		{
			for (j = 0; j < QSO_FIELDS; j++)
				if (logfields[j] == 0)
				{
					logfields[j] = column;
					break;
				}
		}
	}

	/*
	 * If the column is present, remove from the array
	 * if 'Hide' is selected
	 */
	else
	{
		if (strcasecmp (showhide, _("Hide")) == 0)
		{
			logfields[i] = 0;
			for (j = 0; j < QSO_FIELDS; j++)
			{
				if (logfields[j] == 0)
				{
					if (logfields[j + 1] == 0)
						break;
					/* Shift '0' to the right */
					logfields[j] = logfields[j + 1];
					logfields[j + 1] = 0;
				}
			}
		}
	}
}

void
on_menu_logeditor_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *logeditor, 
		*lecomboentry11, *lecomboentry3, *lecomboentry9_10, *lecomboentry12, 
		*lecomboentry13, *lecomboentry14, *lecomboentry15, *lecomboentry17, 
		*lecomboentry16, *leentry15, *leentry16,
		*endhbox, *powerhbox,*qslhbox, *namehbox, *qthhbox, *locatorhbox, 
		*unknown1hbox, *unknown2hbox, *remarksvbox, *unknownlabel1, *unknownlabel2,
		*dialog_vbox, *mainvbox, *mainhbox, *fieldlabel, *showhidelabel, *hseparator, 
		*lehbox0, *lelabel0_1, *lelabel0_2, 
		*lehbox1, *lelabel1_1, *lelabel1_2, 
		*lehbox2, *lelabel2_1, *lelabel2_2, 
		*lehbox3, *lelabel3_1, *lecombo3, 
		*lehbox4, *lelabel4_1, *lelabel4_2, 
		*lehbox5, *lelabel5_1, *lelabel5_2, 
		*lehbox6, *lelabel6_1, *lelabel6_2, 
		*lehbox7, *lelabel7_1, *lelabel7_2, 
		*lehbox8, *lelabel8_1, *lelabel8_2, 
		*lehbox9_10, *lelabel9_10, *lecombo9_10, 
		*lehbox11, *lelabel11, *lecombo11, 
		*lehbox12, *lelabel12, *lecombo12, 
		*lehbox13, *lelabel13, *lecombo13, 
		*lehbox14, *lelabel14, *lecombo14, 
		*lehbox15, *lecombo15, 
		*lehbox16, *lecombo16,
		*lehbox17, *lelabel17_1, *lecombo17, 
		*dialog_action_area, *logeditorcancelbutton, *logeditorokbutton;
	GList *lecombo_items = NULL;
	GdkPixbuf *logeditor_icon_pixbuf;
	logtype *logw;
	gchar *temp;
	gint i, j, page, response, columns, fields[QSO_FIELDS];
	GtkTreeViewColumn *column;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));

	if (page >= 0)
	{
		logeditor = gtk_dialog_new ();
		gtk_window_set_title (GTK_WINDOW (logeditor), _("xlog - logeditor"));
		gtk_window_set_position (GTK_WINDOW (logeditor), GTK_WIN_POS_MOUSE);
		logeditor_icon_pixbuf = create_pixbuf ("xlog.png");
		if (logeditor_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (logeditor), logeditor_icon_pixbuf);
			g_object_unref (logeditor_icon_pixbuf);
		}

		dialog_vbox = GTK_DIALOG (logeditor)->vbox;
		gtk_widget_show (dialog_vbox);

		mainvbox = gtk_vbox_new (TRUE, 1);
		gtk_widget_show (mainvbox);
		gtk_box_pack_start (GTK_BOX (dialog_vbox), mainvbox, FALSE, FALSE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (mainvbox), 5);

		mainhbox = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (mainhbox);
		gtk_box_pack_start (GTK_BOX (mainvbox), mainhbox, TRUE, TRUE, 0);
	
		fieldlabel = gtk_label_new (_("Fieldname"));
		gtk_widget_show (fieldlabel);
		gtk_box_pack_start (GTK_BOX (mainhbox), fieldlabel, FALSE, FALSE, 0);
	
		showhidelabel = gtk_label_new (_("Show / Hide"));
		gtk_widget_show (showhidelabel);
		gtk_box_pack_start (GTK_BOX (mainhbox), showhidelabel, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (showhidelabel), GTK_JUSTIFY_CENTER);

		hseparator = gtk_hseparator_new ();
		gtk_widget_show (hseparator);
		gtk_box_pack_start (GTK_BOX (mainvbox), hseparator, FALSE, FALSE, 0);
	
		lehbox0 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox0);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox0, TRUE, TRUE, 0);

		lelabel0_1 = gtk_label_new (_("QSO Number"));
		gtk_widget_show (lelabel0_1);
		gtk_box_pack_start (GTK_BOX (lehbox0), lelabel0_1, FALSE, FALSE, 0);

		lelabel0_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel0_2);
		gtk_box_pack_start (GTK_BOX (lehbox0), lelabel0_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel0_2), GTK_JUSTIFY_CENTER);

		lehbox1 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox1);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox1, TRUE, TRUE, 0);
	
		lelabel1_1 = gtk_label_new (_("Date"));
		gtk_widget_show (lelabel1_1);
		gtk_box_pack_start (GTK_BOX (lehbox1), lelabel1_1, FALSE, FALSE, 0);

		lelabel1_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel1_2);
		gtk_box_pack_start (GTK_BOX (lehbox1), lelabel1_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel1_2), GTK_JUSTIFY_CENTER);

		lehbox2 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox2);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox2, TRUE, TRUE, 0);
	
		lelabel2_1 = gtk_label_new ("GMT");
		gtk_widget_show (lelabel2_1);
		gtk_box_pack_start (GTK_BOX (lehbox2), lelabel2_1, FALSE, FALSE, 0);
	
		lelabel2_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel2_2);
		gtk_box_pack_start (GTK_BOX (lehbox2), lelabel2_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel2_2), GTK_JUSTIFY_CENTER);

		lehbox3 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox3);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox3, TRUE, TRUE, 0);

		lelabel3_1 = gtk_label_new (_("Endtime (GMT)"));
		gtk_widget_show (lelabel3_1);
		gtk_box_pack_start (GTK_BOX (lehbox3), lelabel3_1, FALSE, FALSE, 0);
	
		lecombo3 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo3)->popwin), "GladeParentKey", lecombo3);
		gtk_widget_show (lecombo3);
		gtk_box_pack_start (GTK_BOX (lehbox3), lecombo3, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo3, 100, 23);
		lecombo_items = g_list_append (lecombo_items, (gpointer) _("Show"));
		lecombo_items = g_list_append (lecombo_items, (gpointer) _("Hide"));
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo3), lecombo_items);

		lecomboentry3 = GTK_COMBO (lecombo3)->entry;
		gtk_widget_show (lecomboentry3);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry3), FALSE);

		lehbox4 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox4);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox4, TRUE, TRUE, 0);

		lelabel4_1 = gtk_label_new (_("Call"));
		gtk_widget_show (lelabel4_1);
		gtk_box_pack_start (GTK_BOX (lehbox4), lelabel4_1, FALSE, FALSE, 0);

		lelabel4_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel4_2);
		gtk_box_pack_start (GTK_BOX (lehbox4), lelabel4_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel4_2), GTK_JUSTIFY_CENTER);

		lehbox5 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox5);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox5, TRUE, TRUE, 0);

		lelabel5_1 = gtk_label_new ("MHz");
		gtk_widget_show (lelabel5_1);
		gtk_box_pack_start (GTK_BOX (lehbox5), lelabel5_1, FALSE, FALSE, 0);
	
		lelabel5_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel5_2);
		gtk_box_pack_start (GTK_BOX (lehbox5), lelabel5_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel5_2), GTK_JUSTIFY_CENTER);

		lehbox6 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox6);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox6, TRUE, TRUE, 0);

		lelabel6_1 = gtk_label_new (_("Mode"));
		gtk_widget_show (lelabel6_1);
		gtk_box_pack_start (GTK_BOX (lehbox6), lelabel6_1, FALSE, FALSE, 0);

		lelabel6_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel6_2);
		gtk_box_pack_start (GTK_BOX (lehbox6), lelabel6_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel6_2), GTK_JUSTIFY_CENTER);

		lehbox7 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox7);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox7, TRUE, TRUE, 0);

		lelabel7_1 = gtk_label_new ("TX(RST)");
		gtk_widget_show (lelabel7_1);
		gtk_box_pack_start (GTK_BOX (lehbox7), lelabel7_1, FALSE, FALSE, 0);

		lelabel7_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel7_2);
		gtk_box_pack_start (GTK_BOX (lehbox7), lelabel7_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel7_2), GTK_JUSTIFY_CENTER);

		lehbox8 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox8);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox8, TRUE, TRUE, 0);

		lelabel8_1 = gtk_label_new ("RX(RST)");
		gtk_widget_show (lelabel8_1);
		gtk_box_pack_start (GTK_BOX (lehbox8), lelabel8_1, FALSE, FALSE, 0);

		lelabel8_2 = gtk_label_new (_("Show"));
		gtk_widget_show (lelabel8_2);
		gtk_box_pack_start (GTK_BOX (lehbox8), lelabel8_2, FALSE, FALSE, 0);
		gtk_label_set_justify (GTK_LABEL (lelabel8_2), GTK_JUSTIFY_CENTER);

		lehbox9_10 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox9_10);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox9_10, TRUE, TRUE, 0);
	
		lelabel9_10 = gtk_label_new (_("QSL out/in"));
		gtk_widget_show (lelabel9_10);
		gtk_box_pack_start (GTK_BOX (lehbox9_10), lelabel9_10, FALSE, FALSE, 0);

		lecombo9_10 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo9_10)->popwin), "GladeParentKey", lecombo9_10);
		gtk_widget_show (lecombo9_10);
		gtk_box_pack_start (GTK_BOX (lehbox9_10), lecombo9_10, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo9_10, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo9_10), lecombo_items);

		lecomboentry9_10 = GTK_COMBO (lecombo9_10)->entry;
		gtk_widget_show (lecomboentry9_10);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry9_10), FALSE);

		lehbox11 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox11);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox11, TRUE, TRUE, 0);

		lelabel11 = gtk_label_new (_("Power"));
		gtk_widget_show (lelabel11);
		gtk_box_pack_start (GTK_BOX (lehbox11), lelabel11, FALSE, FALSE, 0);

		lecombo11 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo11)->popwin), "GladeParentKey", lecombo11);
		gtk_widget_show (lecombo11);
		gtk_box_pack_start (GTK_BOX (lehbox11), lecombo11, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo11, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo11), lecombo_items);

		lecomboentry11 = GTK_COMBO (lecombo11)->entry;
		gtk_widget_show (lecomboentry11);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry11), FALSE);

		lehbox12 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox12);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox12, TRUE, TRUE, 0);

		lelabel12 = gtk_label_new (_("Name"));
		gtk_widget_show (lelabel12);
		gtk_box_pack_start (GTK_BOX (lehbox12), lelabel12, FALSE, FALSE, 0);

		lecombo12 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo12)->popwin), "GladeParentKey", lecombo12);
		gtk_widget_show (lecombo12);
		gtk_box_pack_start (GTK_BOX (lehbox12), lecombo12, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo12, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo12), lecombo_items);

		lecomboentry12 = GTK_COMBO (lecombo12)->entry;
		gtk_widget_show (lecomboentry12);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry12), FALSE);

		lehbox13 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox13);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox13, TRUE, TRUE, 0);

		lelabel13 = gtk_label_new ("QTH");
		gtk_widget_show (lelabel13);
		gtk_box_pack_start (GTK_BOX (lehbox13), lelabel13, FALSE, FALSE, 0);

		lecombo13 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo13)->popwin), "GladeParentKey", lecombo13);
		gtk_widget_show (lecombo13);
		gtk_box_pack_start (GTK_BOX (lehbox13), lecombo13, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo13, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo13), lecombo_items);

		lecomboentry13 = GTK_COMBO (lecombo13)->entry;
		gtk_widget_show (lecomboentry13);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry13), FALSE);

		lehbox14 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox14);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox14, TRUE, TRUE, 0);

		lelabel14 = gtk_label_new (_("QTH Locator"));
		gtk_widget_show (lelabel14);
		gtk_box_pack_start (GTK_BOX (lehbox14), lelabel14, FALSE, FALSE, 0);

		lecombo14 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo14)->popwin), "GladeParentKey", lecombo14);
		gtk_widget_show (lecombo14);
		gtk_box_pack_start (GTK_BOX (lehbox14), lecombo14, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo14, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo14), lecombo_items);

		lecomboentry14 = GTK_COMBO (lecombo14)->entry;
		gtk_widget_show (lecomboentry14);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry14), FALSE);

		lehbox15 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox15);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox15, TRUE, TRUE, 0);

		leentry15 = gtk_entry_new ();
		gtk_widget_show (leentry15);
		gtk_box_pack_start (GTK_BOX (lehbox15), leentry15, FALSE, FALSE, 0);
		gtk_widget_set_size_request (leentry15, 100, 23);

		lecombo15 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo15)->popwin), "GladeParentKey", lecombo15);
		gtk_widget_show (lecombo15);
		gtk_box_pack_start (GTK_BOX (lehbox15), lecombo15, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo15, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo15), lecombo_items);

		lecomboentry15 = GTK_COMBO (lecombo15)->entry;
		gtk_widget_show (lecomboentry15);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry15), FALSE);

		lehbox16 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox16);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox16, TRUE, TRUE, 0);

		leentry16 = gtk_entry_new ();
		gtk_widget_show (leentry16);
		gtk_box_pack_start (GTK_BOX (lehbox16), leentry16, FALSE, FALSE, 0);
		gtk_widget_set_size_request (leentry16, 100, 23);
	
		lecombo16 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo16)->popwin), "GladeParentKey", lecombo16);
		gtk_widget_show (lecombo16);
		gtk_box_pack_start (GTK_BOX (lehbox16), lecombo16, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo16, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo16), lecombo_items);

		lecomboentry16 = GTK_COMBO (lecombo16)->entry;
		gtk_widget_show (lecomboentry16);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry16), FALSE);

		lehbox17 = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (lehbox17);
		gtk_box_pack_start (GTK_BOX (mainvbox), lehbox17, TRUE, TRUE, 0);

		lelabel17_1 = gtk_label_new (_("Remarks"));
		gtk_widget_show (lelabel17_1);
		gtk_box_pack_start (GTK_BOX (lehbox17), lelabel17_1, FALSE, FALSE, 0);

		lecombo17 = gtk_combo_new ();
		g_object_set_data (G_OBJECT (GTK_COMBO (lecombo17)->popwin), "GladeParentKey", lecombo17);
		gtk_widget_show (lecombo17);
		gtk_box_pack_start (GTK_BOX (lehbox17), lecombo17, TRUE, TRUE, 0);
		gtk_widget_set_size_request (lecombo17, 100, 23);
		gtk_combo_set_popdown_strings (GTK_COMBO (lecombo17), lecombo_items);
		g_list_free (lecombo_items);

		lecomboentry17 = GTK_COMBO (lecombo17)->entry;
		gtk_widget_show (lecomboentry17);
		gtk_editable_set_editable (GTK_EDITABLE (lecomboentry17), FALSE);
	
		dialog_action_area = GTK_DIALOG (logeditor)->action_area;
		gtk_widget_show (dialog_action_area);
		gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_SPREAD);
	
		logeditorcancelbutton = gtk_button_new_from_stock ("gtk-cancel");
		gtk_widget_show (logeditorcancelbutton);
		gtk_dialog_add_action_widget (GTK_DIALOG (logeditor), logeditorcancelbutton, GTK_RESPONSE_CANCEL);
		GTK_WIDGET_SET_FLAGS (logeditorcancelbutton, GTK_CAN_DEFAULT);

		logeditorokbutton = gtk_button_new_from_stock ("gtk-ok");
		gtk_widget_show (logeditorokbutton);
		gtk_dialog_add_action_widget (GTK_DIALOG (logeditor), logeditorokbutton, GTK_RESPONSE_OK);
		GTK_WIDGET_SET_FLAGS (logeditorokbutton, GTK_CAN_DEFAULT);

		endhbox = lookup_widget (mainwindow, "endhbox");
		if (GTK_WIDGET_VISIBLE (endhbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry3), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry3), _("Hide"));
	
		qslhbox = lookup_widget (mainwindow, "qslhbox");
		if (GTK_WIDGET_VISIBLE (qslhbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry9_10), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry9_10), _("Hide"));

		powerhbox = lookup_widget (mainwindow, "powerhbox");
		if (GTK_WIDGET_VISIBLE (powerhbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry11), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry11), _("Hide"));

		namehbox = lookup_widget (mainwindow, "namehbox");
		if (GTK_WIDGET_VISIBLE (namehbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry12), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry12), _("Hide"));

		qthhbox = lookup_widget (mainwindow, "qthhbox");
		if (GTK_WIDGET_VISIBLE (qthhbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry13), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry13), _("Hide"));

		locatorhbox = lookup_widget (mainwindow, "locatorhbox");
		if (GTK_WIDGET_VISIBLE (locatorhbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry14), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry14), _("Hide"));

		unknown1hbox = lookup_widget (mainwindow, "unknown1hbox");
		if (GTK_WIDGET_VISIBLE (unknown1hbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry15), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry15), _("Hide"));

		unknown2hbox = lookup_widget (mainwindow, "unknown2hbox");
		if (GTK_WIDGET_VISIBLE (unknown2hbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry16), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry16), _("Hide"));

		gtk_entry_set_text (GTK_ENTRY (leentry15), preferences.freefield1);
		gtk_entry_set_text (GTK_ENTRY (leentry16), preferences.freefield2);
	
		remarksvbox = lookup_widget (mainwindow, "remarksvbox");
		if (GTK_WIDGET_VISIBLE (remarksvbox))
			gtk_entry_set_text (GTK_ENTRY (lecomboentry17), _("Show"));
		else
			gtk_entry_set_text (GTK_ENTRY (lecomboentry17), _("Hide"));
	
		response = gtk_dialog_run (GTK_DIALOG(logeditor));
		if (response == GTK_RESPONSE_OK)
		{

			logw = g_list_nth_data (logwindowlist, page);

			/* fields is the array with visible columns */
			for (i = 0; i < logw->columns; i++)
				fields[i] = logw->logfields[i];
			for (i = logw->columns; i < QSO_FIELDS; i++)
				fields[i] = 0;

			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry3), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), GMTEND);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (GMTEND, fields, temp);
		
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry9_10), 0, -1);
			if (strcasecmp (temp, _("Hide")) == 0)
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(logw->treeview), QSLOUT);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(logw->treeview), QSLIN);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			}
			else
			{
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(logw->treeview), QSLOUT);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(logw->treeview), QSLIN);
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			}
			update_logfields (QSLOUT, fields, temp);
			update_logfields (QSLIN, fields, temp);
		
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry11), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), POWER);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (POWER, fields, temp);
		
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry12), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), NAME);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (NAME, fields, temp);
		
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry13), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), QTH);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (QTH, fields, temp);
		
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry14), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), LOCATOR);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (LOCATOR, fields, temp);
		
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry15), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), U1);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (U1, fields, temp);

			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry16), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), U2);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (U2, fields, temp);
	
			temp = gtk_editable_get_chars (GTK_EDITABLE (lecomboentry17), 0, -1);
			column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), REMARKS);
			if (strcasecmp (temp, _("Hide")) == 0)
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
			else
				gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), TRUE);
			update_logfields (REMARKS, fields, temp);

			/* how many columns do we have now */
			for (i = 0; i < QSO_FIELDS; i++)
			{
				if (fields[i] == 0)
				break;
			}
			columns = i;
			/* is the log changed? */
			for (i = 0; i < QSO_FIELDS; i++)
			{
				if (fields[i] != logw->logfields[i])
				{
					logw->logchanged = TRUE;
					gtk_label_set_text (GTK_LABEL (logw->label), g_strconcat (logw->logname, " *", NULL));
					break;
				}
			}

			/* sort the fields array and copy it back */
			g_qsort_with_data (fields, QSO_FIELDS, sizeof (gint), (GCompareDataFunc) compare_fields, NULL);
			/* copy the array, ignore prepending zero's */
			for (i = 0; i < QSO_FIELDS; i++)
				if (fields[i] != 0) break;
			for (j = 0; j < columns; j++)
				logw->logfields[j] = fields[j + i];
			/* fill up with zero's */
			for (j = columns; j < QSO_FIELDS; j++)
				logw->logfields[j] = 0;
			logw->columns = columns;

			temp = gtk_editable_get_chars (GTK_EDITABLE (leentry15), 0, -1);
			if (strcasecmp (temp, preferences.freefield1) != 0)
			{
				if (strlen (temp) == 0)
					temp = g_strdup ("UNKNOWN");
				preferences.freefield1 = g_strdup (temp);
				unknownlabel1 = lookup_widget (mainwindow, "unknownlabel1");
				gtk_label_set_text (GTK_LABEL (unknownlabel1), temp);
				column = gtk_tree_view_get_column (GTK_TREE_VIEW(logw->treeview), U1);
				gtk_tree_view_column_set_title (column,	preferences.freefield1);
			}
			temp = gtk_editable_get_chars (GTK_EDITABLE (leentry16), 0, -1);
			if (strcasecmp (temp, preferences.freefield2) != 0)
			{
				if (strlen (temp) == 0)
					temp = g_strdup ("UNKNOWN");
				preferences.freefield2 = g_strdup (temp);
				unknownlabel2 = lookup_widget (mainwindow, "unknownlabel2");
				gtk_label_set_text (GTK_LABEL (unknownlabel2), temp);
				column = gtk_tree_view_get_column (GTK_TREE_VIEW (logw->treeview), U2);
				gtk_tree_view_column_set_title (column,	preferences.freefield2);
			}		
			g_free (temp);
			set_qsoframe (logw);
		}
		gtk_widget_destroy (logeditor);
	}
}
