/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_warningdialog.c - creation and destruction of the warning dialog
 *
 * a dialog with a label and a title.
 */

#include <gtk/gtk.h>
#include "gui_warningdialog.h"
#include "support.h"

void warningdialog (gchar *title, gchar *warning)
{
	GtkWidget *warningdialog, *warningdialog_vbox, *warningdialog_label,
		*warningdialog_action_area, *warningokbutton;
	GdkPixbuf *warningdialog_icon_pixbuf;

	warningdialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (warningdialog), title);
	gtk_window_set_position (GTK_WINDOW (warningdialog), GTK_WIN_POS_MOUSE);
	warningdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (warningdialog_icon_pixbuf)
		{
		gtk_window_set_icon (GTK_WINDOW (warningdialog), warningdialog_icon_pixbuf);
		g_object_unref (warningdialog_icon_pixbuf);
		}

	warningdialog_vbox = GTK_DIALOG (warningdialog)->vbox;
	gtk_widget_show (warningdialog_vbox);
	
	warningdialog_label = gtk_label_new (warning);
	gtk_widget_show (warningdialog_label);
	gtk_box_pack_start (GTK_BOX (warningdialog_vbox), warningdialog_label, FALSE, FALSE, 15);
	gtk_label_set_line_wrap (GTK_LABEL (warningdialog_label), TRUE);
	gtk_label_set_justify (GTK_LABEL (warningdialog_label), GTK_JUSTIFY_CENTER);

	warningdialog_action_area = GTK_DIALOG (warningdialog)->action_area;
	gtk_widget_show (warningdialog_action_area);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (warningdialog_action_area), GTK_BUTTONBOX_SPREAD);
	
	warningokbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (warningokbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (warningdialog), warningokbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (warningokbutton, GTK_CAN_DEFAULT);

	gtk_dialog_run (GTK_DIALOG(warningdialog));
	gtk_widget_destroy (warningdialog);
}
