/*
 * Decompiled with CFR 0.152.
 */
package org.cups;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import org.cups.IPP;
import org.cups.IPPAttribute;
import org.cups.IPPBase64Encoder;
import org.cups.IPPMD5;
import org.cups.IPPRequest;
import org.cups.IPPStatus;

public class IPPHttp {
    public static final int HTTP_WAITING = 0;
    public static final int HTTP_OPTIONS = 1;
    public static final int HTTP_GET = 2;
    public static final int HTTP_GET_SEND = 3;
    public static final int HTTP_HEAD = 4;
    public static final int HTTP_POST = 5;
    public static final int HTTP_POST_RECV = 6;
    public static final int HTTP_POST_SEND = 7;
    public static final int HTTP_PUT = 8;
    public static final int HTTP_PUT_RECV = 9;
    public static final int HTTP_DELETE = 10;
    public static final int HTTP_TRACE = 11;
    public static final int HTTP_CLOSE = 12;
    public static final int HTTP_STATUS = 13;
    public static final int HTTP_0_9 = 9;
    public static final int HTTP_1_0 = 100;
    public static final int HTTP_1_1 = 101;
    public static final int HTTP_KEEPALIVE_OFF = 0;
    public static final int HTTP_KEEPALIVE_ON = 1;
    public static final int HTTP_ENCODE_LENGTH = 0;
    public static final int HTTP_ENCODE_CHUNKED = 1;
    public static final int HTTP_ENCRYPT_IF_REQUESTED = 0;
    public static final int HTTP_ENCRYPT_NEVER = 1;
    public static final int HTTP_ENCRYPT_REQUIRED = 2;
    public static final int HTTP_ENCRYPT_ALWAYS = 3;
    public static final int HTTP_AUTH_NONE = 0;
    public static final int HTTP_AUTH_BASIC = 1;
    public static final int HTTP_AUTH_MD5 = 2;
    public static final int HTTP_AUTH_MD5_SESS = 3;
    public static final int HTTP_AUTH_MD5_INT = 4;
    public static final int HTTP_AUTH_MD5_SESS_INT = 5;
    public static final int HTTP_ERROR = -1;
    public static final int HTTP_CONTINUE = 100;
    public static final int HTTP_SWITCHING_PROTOCOLS = 101;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET_CONTENT = 205;
    public static final int HTTP_PARTIAL_CONTENT = 206;
    public static final int HTTP_MULTIPLE_CHOICES = 300;
    public static final int HTTP_MOVED_PERMANENTLY = 301;
    public static final int HTTP_MOVED_TEMPORARILY = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_METHOD_NOT_ALLOWED = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTHENTICATION = 407;
    public static final int HTTP_REQUEST_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECONDITION = 412;
    public static final int HTTP_REQUEST_TOO_LARGE = 413;
    public static final int HTTP_URI_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_MEDIATYPE = 415;
    public static final int HTTP_UPGRADE_REQUIRED = 426;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_SERVICE_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_NOT_SUPPORTED = 505;
    public static final int HTTP_FIELD_UNKNOWN = -1;
    public static final int HTTP_FIELD_ACCEPT_LANGUAGE = 0;
    public static final int HTTP_FIELD_ACCEPT_RANGES = 1;
    public static final int HTTP_FIELD_AUTHORIZATION = 2;
    public static final int HTTP_FIELD_CONNECTION = 3;
    public static final int HTTP_FIELD_CONTENT_ENCODING = 4;
    public static final int HTTP_FIELD_CONTENT_LANGUAGE = 5;
    public static final int HTTP_FIELD_CONTENT_LENGTH = 6;
    public static final int HTTP_FIELD_CONTENT_LOCATION = 7;
    public static final int HTTP_FIELD_CONTENT_MD5 = 8;
    public static final int HTTP_FIELD_CONTENT_RANGE = 9;
    public static final int HTTP_FIELD_CONTENT_TYPE = 10;
    public static final int HTTP_FIELD_CONTENT_VERSION = 11;
    public static final int HTTP_FIELD_DATE = 12;
    public static final int HTTP_FIELD_HOST = 13;
    public static final int HTTP_FIELD_IF_MODIFIED_SINCE = 14;
    public static final int HTTP_FIELD_IF_UNMODIFIED_SINCE = 15;
    public static final int HTTP_FIELD_KEEP_ALIVE = 16;
    public static final int HTTP_FIELD_LAST_MODIFIED = 17;
    public static final int HTTP_FIELD_LINK = 18;
    public static final int HTTP_FIELD_LOCATION = 19;
    public static final int HTTP_FIELD_RANGE = 20;
    public static final int HTTP_FIELD_REFERER = 21;
    public static final int HTTP_FIELD_RETRY_AFTER = 22;
    public static final int HTTP_FIELD_TRANSFER_ENCODING = 23;
    public static final int HTTP_FIELD_UPGRADE = 24;
    public static final int HTTP_FIELD_USER_AGENT = 25;
    public static final int HTTP_FIELD_WWW_AUTHENTICATE = 26;
    public static final int HTTP_FIELD_MAX = 27;
    public static final String[] http_fields = new String[]{"Accept-Language", "Accept-Ranges", "Authorization", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Content-Version", "Date", "Host", "If-Modified-Since", "If-Unmodified-since", "Keep-Alive", "Last-Modified", "Link", "Location", "Range", "Referer", "Retry-After", "Transfer-Encoding", "Upgrade", "User-Agent", "WWW-Authenticate"};
    public static final String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    public static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private URL url;
    public Socket conn;
    public boolean connected = false;
    public BufferedInputStream is;
    public BufferedReader br;
    public BufferedOutputStream os;
    private boolean encrypted = false;
    public int write_content_length;
    private char[] write_buffer;
    private int write_buffer_head;
    private int write_buffer_tail;
    public String read_header_date;
    public String read_header_server;
    public String read_header_charset;
    public String read_header_content_language;
    public String read_header_content_type;
    public int read_header_content_length;
    public char[] read_buffer;
    private int read_buffer_head;
    private int read_buffer_tail;
    public int status = 0;
    public String status_text = "";
    public String version = "1.0";
    public int error;
    public int activity;
    public String hostname;
    public int port;
    public String path;
    public String user;
    public String passwd;
    public String auth_type;
    public String realm;
    public String opaque;
    public String nonce;
    public String resource;
    public String method;
    public String http_request;
    public int http_content_length;

    public IPPHttp(String string) throws IOException, UnknownHostException {
        this.user = "";
        this.passwd = "";
        this.auth_type = "";
        this.realm = "";
        this.nonce = "";
        this.resource = "";
        this.method = "";
        try {
            this.url = new URL(string);
            this.hostname = this.url.getHost();
            this.port = this.url.getPort();
            this.path = this.url.getPath();
            this.conn = new Socket(this.hostname, this.port);
            this.conn.setSoTimeout(200);
            this.is = new BufferedInputStream(new DataInputStream(this.conn.getInputStream()));
            this.os = new BufferedOutputStream(new DataOutputStream(this.conn.getOutputStream()));
            this.connected = true;
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public IPPHttp(String string, String string2, String string3, String string4) throws IOException, UnknownHostException {
        this.user = string3;
        this.passwd = string4;
        this.auth_type = string2;
        this.realm = "";
        this.nonce = "";
        this.resource = "";
        this.method = "";
        try {
            this.url = new URL(string);
            this.hostname = this.url.getHost();
            this.port = this.url.getPort();
            this.path = this.url.getPath();
            this.conn = new Socket(this.hostname, this.port);
            this.conn.setSoTimeout(200);
            this.is = new BufferedInputStream(new DataInputStream(this.conn.getInputStream()));
            this.os = new BufferedOutputStream(new DataOutputStream(this.conn.getOutputStream()));
            this.connected = true;
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public boolean reConnect() throws IOException {
        this.connected = false;
        this.status = 0;
        this.status_text = "";
        try {
            this.conn = new Socket(this.hostname, this.port);
            this.conn.setSoTimeout(200);
            this.is = new BufferedInputStream(new DataInputStream(this.conn.getInputStream()));
            this.os = new BufferedOutputStream(new DataOutputStream(this.conn.getOutputStream()));
            this.connected = true;
            return this.connected;
        }
        catch (IOException iOException) {
            this.connected = false;
            throw iOException;
        }
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.passwd = string;
    }

    public int writeHeader(String string, int n) throws IOException {
        CharSequence charSequence;
        Object object;
        this.http_request = string;
        this.http_content_length = n;
        try {
            String string2 = "POST " + string + " HTTP/1.0\r\n";
            this.os.write(string2.getBytes(), 0, string2.length());
            string2 = "Content-type: application/ipp\r\n";
            this.os.write(string2.getBytes(), 0, string2.length());
            if (this.auth_type.compareTo("basic") == 0) {
                string2 = this.user + ":" + this.passwd;
                object = new IPPBase64Encoder();
                charSequence = object.encode(string2.getBytes());
                string2 = "Authorization: Basic " + (String)charSequence + "\r\n";
                this.os.write(string2.getBytes(), 0, string2.length());
            } else if (this.auth_type.compareTo("digest") == 0) {
                try {
                    object = IPPMD5.getInstance();
                    charSequence = object.MD5Digest(this.user, this.passwd, this.realm, "POST", this.path, this.nonce);
                    string2 = "Authorization: Digest username=\"" + this.user + "\", " + "realm=\"" + this.realm + "\", " + "nonce=\"" + this.nonce + "\", " + "response=\"" + (String)charSequence + "\"\r\n";
                    this.os.write(string2.getBytes(), 0, string2.length());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    System.out.println("No such algorithm: MD5.");
                }
            }
            string2 = "Content-length: " + n + "\r\n\r\n";
            this.os.write(string2.getBytes(), 0, string2.length());
            this.os.flush();
        }
        catch (IOException iOException) {
            this.error = -1;
            throw iOException;
        }
        try {
            int n2 = 0;
            if (this.is.available() > 0) {
                object = new StringBuffer(32);
                charSequence = new StringBuffer(32);
                StringBuffer stringBuffer = new StringBuffer(256);
                this.status = 0;
                this.is.mark(8192);
                while (this.is.available() > 0) {
                    String string3 = this.read_line();
                    if (!string3.startsWith("HTTP/")) continue;
                    String string4 = string3.substring(5);
                    int n3 = 0;
                    while (n3 < string4.length() && string4.charAt(n3) != ' ') {
                        ((StringBuffer)object).append(string4.charAt(n3));
                        ++n3;
                    }
                    while (n3 < string4.length() && string4.charAt(n3) == ' ') {
                        ++n3;
                    }
                    while (n3 < string4.length() && string4.charAt(n3) != '\n' && string4.charAt(n3) != '\r' && string4.charAt(n3) != ' ') {
                        ((StringBuffer)charSequence).append(string4.charAt(n3));
                        ++n3;
                    }
                    while (n3 < string4.length() && string4.charAt(n3) == ' ') {
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < 256 && n3 < string4.length() && string4.charAt(n3) != '\n' && string4.charAt(n3) != '\r' && string4.charAt(n3) != ' ') {
                        stringBuffer.append(string4.charAt(n3));
                        ++n3;
                    }
                    n2 = Integer.parseInt(((StringBuffer)charSequence).toString(), 10);
                }
                this.is.reset();
            }
            switch (n2) {
                case 401: {
                    this.read_header();
                    return n2;
                }
            }
        }
        catch (IOException iOException) {
            this.error = -1;
            throw iOException;
        }
        return 0;
    }

    public int checkForResponse() {
        try {
            if (this.is.available() > 0) {
                StringBuffer stringBuffer = new StringBuffer(32);
                StringBuffer stringBuffer2 = new StringBuffer(32);
                StringBuffer stringBuffer3 = new StringBuffer(256);
                int n = 0;
                this.status = 0;
                this.is.mark(8192);
                while (this.is.available() > 0) {
                    String string = this.read_line();
                    if (!string.startsWith("HTTP/")) continue;
                    String string2 = string.substring(5);
                    int n2 = 0;
                    while (n2 < string2.length() && string2.charAt(n2) != ' ') {
                        stringBuffer.append(string2.charAt(n2));
                        ++n2;
                    }
                    while (n2 < string2.length() && string2.charAt(n2) == ' ') {
                        ++n2;
                    }
                    while (n2 < string2.length() && string2.charAt(n2) != '\n' && string2.charAt(n2) != '\r' && string2.charAt(n2) != ' ') {
                        stringBuffer2.append(string2.charAt(n2));
                        ++n2;
                    }
                    while (n2 < string2.length() && string2.charAt(n2) == ' ') {
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < 256 && n2 < string2.length() && string2.charAt(n2) != '\n' && string2.charAt(n2) != '\r' && string2.charAt(n2) != ' ') {
                        stringBuffer3.append(string2.charAt(n2));
                        ++n2;
                    }
                    this.status = n = Integer.parseInt(stringBuffer2.toString(), 10);
                }
                this.is.reset();
                switch (n) {
                    case 401: {
                        this.read_header();
                        return n;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return 0;
    }

    public void write(byte[] byArray) throws IOException {
        try {
            this.os.write(byArray, 0, byArray.length);
            this.os.flush();
        }
        catch (IOException iOException) {
            this.error = -1;
            throw iOException;
        }
    }

    public void write(byte[] byArray, int n) throws IOException {
        try {
            this.os.write(byArray, 0, n);
            this.os.flush();
        }
        catch (IOException iOException) {
            this.error = -1;
            throw iOException;
        }
    }

    public int read_header() throws IOException {
        boolean bl = false;
        this.read_header_content_length = 0;
        while (!bl) {
            String string = this.read_line();
            if (string.startsWith("HTTP/")) {
                String string2 = string.substring(5);
                StringBuffer stringBuffer = new StringBuffer(32);
                StringBuffer stringBuffer2 = new StringBuffer(32);
                StringBuffer stringBuffer3 = new StringBuffer(256);
                int n = 0;
                while (n < string2.length() && string2.charAt(n) != ' ') {
                    stringBuffer.append(string2.charAt(n));
                    ++n;
                }
                while (n < string2.length() && string2.charAt(n) == ' ') {
                    ++n;
                }
                while (n < string2.length() && string2.charAt(n) != '\n' && string2.charAt(n) != '\r' && string2.charAt(n) != ' ') {
                    stringBuffer2.append(string2.charAt(n));
                    ++n;
                }
                while (n < string2.length() && string2.charAt(n) == ' ') {
                    ++n;
                }
                int n2 = 0;
                while (n2 < 256 && n < string2.length() && string2.charAt(n) != '\n' && string2.charAt(n) != '\r' && string2.charAt(n) != ' ') {
                    stringBuffer3.append(string2.charAt(n));
                    ++n;
                }
                this.version = stringBuffer.toString();
                this.status = Integer.parseInt(stringBuffer2.toString(), 10);
                this.status_text = stringBuffer3.toString();
                continue;
            }
            if (string.startsWith("WWW-Authenticate: Basic")) {
                String string3 = string.substring("WWW-Authenticate: Basic".length());
                this.auth_type = "basic";
                continue;
            }
            if (string.startsWith("WWW-Authenticate: Digest")) {
                String string4 = string.substring("WWW-Authenticate: Digest".length());
                this.auth_type = "digest";
                this.parseAuthenticate(string4);
                continue;
            }
            if (string.startsWith("Content-Length:")) {
                String string5 = string.substring(15);
                this.read_header_content_length = Integer.parseInt(string5.trim(), 10);
                continue;
            }
            if (string.startsWith("Content-Language:")) {
                String string6 = string.substring(17);
                this.read_header_content_language = string6.trim();
                continue;
            }
            if (string.startsWith("Server:")) {
                String string7 = string.substring(7);
                this.read_header_server = string7.trim();
                continue;
            }
            if (string.startsWith("Date:")) {
                String string8 = string.substring(5);
                this.read_header_date = string8.trim();
                continue;
            }
            if (string.length() != 0) continue;
            bl = true;
            return this.read_header_content_length;
        }
        return 0;
    }

    public String read_line() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n != -1 && n != 10) {
            n = this.is.read();
            switch (n) {
                case -1: 
                case 10: 
                case 13: {
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        return stringBuffer.toString();
    }

    public char[] read(int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = this.is.read();
        while (n3 != -1 && n2 < n) {
            cArray[n2++] = (char)n3;
            n3 = this.is.read();
        }
        return cArray;
    }

    public IPP processResponse() {
        int n;
        IPP iPP = new IPP();
        iPP.request = new IPPRequest();
        int n2 = n = this.read_buffer.length;
        int n3 = 0;
        iPP.current = -1;
        iPP.last = -1;
        IPPAttribute iPPAttribute = null;
        char[] cArray = this.read_buffer;
        short s = -1;
        short s2 = -1;
        iPP.state = 0;
        while (iPP.state != 3 && n2 > 0) {
            switch (iPP.state) {
                case 0: {
                    iPP.state = (short)(iPP.state + 1);
                }
                case 1: {
                    if (n2 < 8) {
                        return null;
                    }
                    if (cArray[0] != '\u0001') {
                        return null;
                    }
                    iPP.request.version[0] = cArray[n3++];
                    iPP.request.version[1] = cArray[n3++];
                    iPP.request.op_status = (short)((short)cArray[n3] << 8) | (short)cArray[n3 + 1];
                    iPP.status = new IPPStatus(iPP.request.op_status);
                    iPP.request.request_id = cArray[n3 += 2] << 24 | cArray[n3 + 1] << 16 | cArray[n3 + 2] << 8 | cArray[n3 + 3];
                    n3 += 4;
                    n2 -= 8;
                    iPP.state = (short)2;
                    iPP.current = -1;
                    iPP.current_tag = 0;
                    break;
                }
                case 2: {
                    block16: while (n2 > 0) {
                        int n4;
                        StringBuffer stringBuffer;
                        s2 = (short)cArray[n3++];
                        --n2;
                        if (s2 == 3) {
                            iPP.state = (short)3;
                            if (iPPAttribute == null) break;
                            iPP.addAttribute(iPPAttribute);
                            iPPAttribute = null;
                            break;
                        }
                        if (s2 < 16) {
                            if (iPPAttribute != null) {
                                iPP.addAttribute(iPPAttribute);
                            }
                            if (iPP.current_tag == (s = s2)) {
                                iPPAttribute = new IPPAttribute(0, 0, "");
                                iPP.addAttribute(iPPAttribute);
                                iPPAttribute = null;
                            }
                            iPP.current_tag = s;
                            iPP.current = -1;
                            continue;
                        }
                        int n5 = cArray[n3] << 8 | cArray[n3 + 1];
                        n3 += 2;
                        n2 -= 2;
                        if (n5 == 0) {
                            if (iPPAttribute == null) {
                                return null;
                            }
                            if (iPPAttribute.value_tag == 48 || iPPAttribute.value_tag >= 53 && iPPAttribute.value_tag <= 73 ? s2 != 48 && (s2 < 53 || s2 > 73) : iPPAttribute.value_tag != s2) {
                                return null;
                            }
                        } else {
                            if (iPPAttribute != null) {
                                iPP.addAttribute(iPPAttribute);
                                iPPAttribute = null;
                            }
                            stringBuffer = new StringBuffer();
                            n4 = 0;
                            while (n4 < n5) {
                                stringBuffer.append(cArray[n3++]);
                                --n2;
                                ++n4;
                            }
                            iPPAttribute = new IPPAttribute((int)s, (int)s2, stringBuffer.toString());
                        }
                        n5 = (short)cArray[n3] << 8 | (short)cArray[n3 + 1];
                        n3 += 2;
                        n2 -= 2;
                        switch (s2) {
                            case 33: 
                            case 35: {
                                n5 = cArray[n3] << 24 | cArray[n3 + 1] << 16 | cArray[n3 + 2] << 8 | cArray[n3 + 3];
                                n3 += 4;
                                n2 -= 4;
                                iPPAttribute.addInteger(n5);
                                break;
                            }
                            case 34: {
                                if ((byte)cArray[n3++] > 0) {
                                    iPPAttribute.addBoolean(true);
                                } else {
                                    iPPAttribute.addBoolean(false);
                                }
                                --n2;
                                break;
                            }
                            case 48: 
                            case 65: 
                            case 66: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: {
                                stringBuffer = new StringBuffer();
                                n4 = 0;
                                while (n4 < n5) {
                                    stringBuffer.append(cArray[n3++]);
                                    --n2;
                                    ++n4;
                                }
                                iPPAttribute.addString("", stringBuffer.toString());
                                break;
                            }
                            case 49: {
                                char[] cArray2 = new char[11];
                                int n6 = 0;
                                while (n6 < 11) {
                                    cArray2[n6] = cArray[n3++];
                                    --n2;
                                    ++n6;
                                }
                                iPPAttribute.addDate(cArray2);
                                break;
                            }
                            case 50: {
                                if (n2 < 9) {
                                    return null;
                                }
                                int n7 = (cArray[n3] & 0xFF000000) << 24 | (cArray[n3 + 1] & 0xFF0000) << 16 | (cArray[n3 + 2] & 0xFF00) << 8 | cArray[n3 + 3] & 0xFF;
                                n2 -= 4;
                                int n8 = (cArray[n3 += 4] & 0xFF000000) << 24 | (cArray[n3 + 1] & 0xFF0000) << 16 | (cArray[n3 + 2] & 0xFF00) << 8 | cArray[n3 + 3] & 0xFF;
                                n3 += 4;
                                n2 -= 4;
                                byte by = (byte)cArray[n3++];
                                --n2;
                                iPPAttribute.addResolution(by, n7, n8);
                                break;
                            }
                            case 51: {
                                if (n2 < 8) {
                                    return null;
                                }
                                int n9 = (cArray[n3] & 0xFF000000) << 24 | (cArray[n3 + 1] & 0xFF0000) << 16 | (cArray[n3 + 2] & 0xFF00) << 8 | cArray[n3 + 3] & 0xFF;
                                n2 -= 4;
                                int n10 = (cArray[n3 += 4] & 0xFF000000) << 24 | (cArray[n3 + 1] & 0xFF0000) << 16 | (cArray[n3 + 2] & 0xFF00) << 8 | cArray[n3 + 3] & 0xFF;
                                n3 += 4;
                                n2 -= 4;
                                iPPAttribute.addRange((int)((short)n9), (int)((short)n10));
                                break;
                            }
                            case 53: 
                            case 54: {
                                n5 = cArray[n3] << 8 | cArray[n3 + 1];
                                n3 += 2;
                                StringBuffer stringBuffer2 = new StringBuffer();
                                int n11 = 0;
                                while (n11 < n5) {
                                    stringBuffer2.append(cArray[n3++]);
                                    --n2;
                                    ++n11;
                                }
                                n5 = cArray[n3] << 8 | cArray[n3 + 1];
                                n3 += 2;
                                StringBuffer stringBuffer3 = new StringBuffer();
                                int n12 = 0;
                                while (n12 < n5) {
                                    stringBuffer3.append(cArray[n3++]);
                                    --n2;
                                    ++n12;
                                }
                                iPPAttribute.addString(stringBuffer2.toString(), stringBuffer3.toString());
                                break;
                            }
                            default: {
                                if (n5 <= 0) continue block16;
                                n3 += n5;
                                n2 -= n5;
                            }
                        }
                    }
                    if (iPPAttribute == null) break;
                    iPP.addAttribute(iPPAttribute);
                    iPPAttribute = null;
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return iPP;
    }

    public void parseAuthenticate(String string) {
        String string2 = string;
        while (string2.length() > 0) {
            StringBuffer stringBuffer;
            int n = 0;
            while (string2.length() > 0 && (string2.charAt(n) == ' ' || string2.charAt(n) == '\"')) {
                string2 = string2.substring(1);
            }
            n = 0;
            if (string2.startsWith("realm=")) {
                n = "realm=".length();
                string2 = string2.substring(n);
                n = 0;
                while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\"' || string2.charAt(n) == '=')) {
                    ++n;
                }
                stringBuffer = new StringBuffer(1024);
                while (n < string2.length() && string2.charAt(n) != '\"') {
                    stringBuffer.append(string2.charAt(n++));
                }
                this.realm = stringBuffer.toString();
                string2 = string2.substring(n);
                continue;
            }
            if (string2.startsWith("nonce=")) {
                n = "nonce=".length();
                string2 = string2.substring(n);
                n = 0;
                while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\"' || string2.charAt(n) == '=')) {
                    ++n;
                }
                stringBuffer = new StringBuffer(1024);
                while (n < string2.length() && string2.charAt(n) != '\"') {
                    stringBuffer.append(string2.charAt(n++));
                }
                this.nonce = stringBuffer.toString();
                string2 = string2.substring(n);
                continue;
            }
            if (string2.startsWith("opaque=")) {
                n = "opaque=".length();
                string2 = string2.substring(n);
                n = 0;
                while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\"' || string2.charAt(n) == '=')) {
                    ++n;
                }
                stringBuffer = new StringBuffer(1024);
                while (n < string2.length() && string2.charAt(n) != '\"') {
                    stringBuffer.append(string2.charAt(n++));
                }
                this.opaque = stringBuffer.toString();
                string2 = string2.substring(n);
                continue;
            }
            StringBuffer stringBuffer2 = new StringBuffer(256);
            while (n < string2.length() && (string2.charAt(n) != ' ' || string2.charAt(n) != '\"' || string2.charAt(n) != '=')) {
                stringBuffer2.append(string2.charAt(n++));
            }
            n = stringBuffer2.toString().length();
            string2 = string2.substring(n);
            n = 0;
            while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\"' || string2.charAt(n) == '=')) {
                ++n;
            }
            stringBuffer = new StringBuffer(1024);
            while (n < string2.length() && string2.charAt(n) != '\"') {
                stringBuffer.append(string2.charAt(n++));
            }
            string2 = string2.substring(n);
        }
    }
}

